// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/commerce/consumer/procurement/v1/license_management_service.proto

package procurementpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Assignment protocol for a license pool.
type AssignmentProtocol struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The type of assignment protocol.
	//
	// Types that are assignable to AssignmentType:
	//
	//	*AssignmentProtocol_ManualAssignmentType_
	//	*AssignmentProtocol_AutoAssignmentType_
	AssignmentType isAssignmentProtocol_AssignmentType `protobuf_oneof:"assignment_type"`
}

func (x *AssignmentProtocol) Reset() {
	*x = AssignmentProtocol{}
	mi := &file_google_cloud_commerce_consumer_procurement_v1_license_management_service_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AssignmentProtocol) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AssignmentProtocol) ProtoMessage() {}

func (x *AssignmentProtocol) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_commerce_consumer_procurement_v1_license_management_service_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AssignmentProtocol.ProtoReflect.Descriptor instead.
func (*AssignmentProtocol) Descriptor() ([]byte, []int) {
	return file_google_cloud_commerce_consumer_procurement_v1_license_management_service_proto_rawDescGZIP(), []int{0}
}

func (m *AssignmentProtocol) GetAssignmentType() isAssignmentProtocol_AssignmentType {
	if m != nil {
		return m.AssignmentType
	}
	return nil
}

func (x *AssignmentProtocol) GetManualAssignmentType() *AssignmentProtocol_ManualAssignmentType {
	if x, ok := x.GetAssignmentType().(*AssignmentProtocol_ManualAssignmentType_); ok {
		return x.ManualAssignmentType
	}
	return nil
}

func (x *AssignmentProtocol) GetAutoAssignmentType() *AssignmentProtocol_AutoAssignmentType {
	if x, ok := x.GetAssignmentType().(*AssignmentProtocol_AutoAssignmentType_); ok {
		return x.AutoAssignmentType
	}
	return nil
}

type isAssignmentProtocol_AssignmentType interface {
	isAssignmentProtocol_AssignmentType()
}

type AssignmentProtocol_ManualAssignmentType_ struct {
	// Allow manual assignments triggered by administrative operations only.
	ManualAssignmentType *AssignmentProtocol_ManualAssignmentType `protobuf:"bytes,2,opt,name=manual_assignment_type,json=manualAssignmentType,proto3,oneof"`
}

type AssignmentProtocol_AutoAssignmentType_ struct {
	// Allow automatic assignments triggered by data plane operations.
	AutoAssignmentType *AssignmentProtocol_AutoAssignmentType `protobuf:"bytes,3,opt,name=auto_assignment_type,json=autoAssignmentType,proto3,oneof"`
}

func (*AssignmentProtocol_ManualAssignmentType_) isAssignmentProtocol_AssignmentType() {}

func (*AssignmentProtocol_AutoAssignmentType_) isAssignmentProtocol_AssignmentType() {}

// A license pool represents a pool of licenses that can be assigned to users.
type LicensePool struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. Format:
	// `billingAccounts/{billing_account}/orders/{order}/licensePool`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Assignment protocol for the license pool.
	LicenseAssignmentProtocol *AssignmentProtocol `protobuf:"bytes,2,opt,name=license_assignment_protocol,json=licenseAssignmentProtocol,proto3" json:"license_assignment_protocol,omitempty"`
	// Output only. Licenses count that are available to be assigned.
	AvailableLicenseCount int32 `protobuf:"varint,3,opt,name=available_license_count,json=availableLicenseCount,proto3" json:"available_license_count,omitempty"`
	// Output only. Total number of licenses in the pool.
	TotalLicenseCount int32 `protobuf:"varint,4,opt,name=total_license_count,json=totalLicenseCount,proto3" json:"total_license_count,omitempty"`
}

func (x *LicensePool) Reset() {
	*x = LicensePool{}
	mi := &file_google_cloud_commerce_consumer_procurement_v1_license_management_service_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LicensePool) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LicensePool) ProtoMessage() {}

func (x *LicensePool) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_commerce_consumer_procurement_v1_license_management_service_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LicensePool.ProtoReflect.Descriptor instead.
func (*LicensePool) Descriptor() ([]byte, []int) {
	return file_google_cloud_commerce_consumer_procurement_v1_license_management_service_proto_rawDescGZIP(), []int{1}
}

func (x *LicensePool) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *LicensePool) GetLicenseAssignmentProtocol() *AssignmentProtocol {
	if x != nil {
		return x.LicenseAssignmentProtocol
	}
	return nil
}

func (x *LicensePool) GetAvailableLicenseCount() int32 {
	if x != nil {
		return x.AvailableLicenseCount
	}
	return 0
}

func (x *LicensePool) GetTotalLicenseCount() int32 {
	if x != nil {
		return x.TotalLicenseCount
	}
	return 0
}

// Request message for getting a license pool.
type GetLicensePoolRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the license pool to get.
	// Format: `billingAccounts/{billing_account}/orders/{order}/licensePool`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetLicensePoolRequest) Reset() {
	*x = GetLicensePoolRequest{}
	mi := &file_google_cloud_commerce_consumer_procurement_v1_license_management_service_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetLicensePoolRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetLicensePoolRequest) ProtoMessage() {}

func (x *GetLicensePoolRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_commerce_consumer_procurement_v1_license_management_service_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetLicensePoolRequest.ProtoReflect.Descriptor instead.
func (*GetLicensePoolRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_commerce_consumer_procurement_v1_license_management_service_proto_rawDescGZIP(), []int{2}
}

func (x *GetLicensePoolRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for updating a license pool.
type UpdateLicensePoolRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The license pool to update.
	//
	// The license pool's name field is used to identify the license pool to
	// update. Format:
	// `billingAccounts/{billing_account}/orders/{order}/licensePool`.
	LicensePool *LicensePool `protobuf:"bytes,1,opt,name=license_pool,json=licensePool,proto3" json:"license_pool,omitempty"`
	// Required. The list of fields to update.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateLicensePoolRequest) Reset() {
	*x = UpdateLicensePoolRequest{}
	mi := &file_google_cloud_commerce_consumer_procurement_v1_license_management_service_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateLicensePoolRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateLicensePoolRequest) ProtoMessage() {}

func (x *UpdateLicensePoolRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_commerce_consumer_procurement_v1_license_management_service_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateLicensePoolRequest.ProtoReflect.Descriptor instead.
func (*UpdateLicensePoolRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_commerce_consumer_procurement_v1_license_management_service_proto_rawDescGZIP(), []int{3}
}

func (x *UpdateLicensePoolRequest) GetLicensePool() *LicensePool {
	if x != nil {
		return x.LicensePool
	}
	return nil
}

func (x *UpdateLicensePoolRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for
// [LicenseManagementService.Assign][google.cloud.commerce.consumer.procurement.v1.LicenseManagementService.Assign].
type AssignRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. License pool name.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Username.
	// Format: `name@domain.com`.
	Usernames []string `protobuf:"bytes,2,rep,name=usernames,proto3" json:"usernames,omitempty"`
}

func (x *AssignRequest) Reset() {
	*x = AssignRequest{}
	mi := &file_google_cloud_commerce_consumer_procurement_v1_license_management_service_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AssignRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AssignRequest) ProtoMessage() {}

func (x *AssignRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_commerce_consumer_procurement_v1_license_management_service_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AssignRequest.ProtoReflect.Descriptor instead.
func (*AssignRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_commerce_consumer_procurement_v1_license_management_service_proto_rawDescGZIP(), []int{4}
}

func (x *AssignRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *AssignRequest) GetUsernames() []string {
	if x != nil {
		return x.Usernames
	}
	return nil
}

// Response message for
// [LicenseManagementService.Assign][google.cloud.commerce.consumer.procurement.v1.LicenseManagementService.Assign].
type AssignResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *AssignResponse) Reset() {
	*x = AssignResponse{}
	mi := &file_google_cloud_commerce_consumer_procurement_v1_license_management_service_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AssignResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AssignResponse) ProtoMessage() {}

func (x *AssignResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_commerce_consumer_procurement_v1_license_management_service_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AssignResponse.ProtoReflect.Descriptor instead.
func (*AssignResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_commerce_consumer_procurement_v1_license_management_service_proto_rawDescGZIP(), []int{5}
}

// Request message for
// [LicenseManagementService.Unassign][google.cloud.commerce.consumer.procurement.v1.LicenseManagementService.Unassign].
type UnassignRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. License pool name.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Username.
	// Format: `name@domain.com`.
	Usernames []string `protobuf:"bytes,2,rep,name=usernames,proto3" json:"usernames,omitempty"`
}

func (x *UnassignRequest) Reset() {
	*x = UnassignRequest{}
	mi := &file_google_cloud_commerce_consumer_procurement_v1_license_management_service_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UnassignRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UnassignRequest) ProtoMessage() {}

func (x *UnassignRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_commerce_consumer_procurement_v1_license_management_service_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UnassignRequest.ProtoReflect.Descriptor instead.
func (*UnassignRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_commerce_consumer_procurement_v1_license_management_service_proto_rawDescGZIP(), []int{6}
}

func (x *UnassignRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *UnassignRequest) GetUsernames() []string {
	if x != nil {
		return x.Usernames
	}
	return nil
}

// Response message for
// [LicenseManagementService.Unassign][google.cloud.commerce.consumer.procurement.v1.LicenseManagementService.Unassign].
type UnassignResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *UnassignResponse) Reset() {
	*x = UnassignResponse{}
	mi := &file_google_cloud_commerce_consumer_procurement_v1_license_management_service_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UnassignResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UnassignResponse) ProtoMessage() {}

func (x *UnassignResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_commerce_consumer_procurement_v1_license_management_service_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UnassignResponse.ProtoReflect.Descriptor instead.
func (*UnassignResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_commerce_consumer_procurement_v1_license_management_service_proto_rawDescGZIP(), []int{7}
}

// Request message for
// [LicenseManagementService.EnumerateLicensedUsers][google.cloud.commerce.consumer.procurement.v1.LicenseManagementService.EnumerateLicensedUsers].
type EnumerateLicensedUsersRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. License pool name.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of users to return. The service may return
	// fewer than this value.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A page token, received from a previous `EnumerateLicensedUsers`
	// call. Provide this to retrieve the subsequent page.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *EnumerateLicensedUsersRequest) Reset() {
	*x = EnumerateLicensedUsersRequest{}
	mi := &file_google_cloud_commerce_consumer_procurement_v1_license_management_service_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EnumerateLicensedUsersRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EnumerateLicensedUsersRequest) ProtoMessage() {}

func (x *EnumerateLicensedUsersRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_commerce_consumer_procurement_v1_license_management_service_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EnumerateLicensedUsersRequest.ProtoReflect.Descriptor instead.
func (*EnumerateLicensedUsersRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_commerce_consumer_procurement_v1_license_management_service_proto_rawDescGZIP(), []int{8}
}

func (x *EnumerateLicensedUsersRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *EnumerateLicensedUsersRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *EnumerateLicensedUsersRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// A licensed user.
type LicensedUser struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Username.
	// Format: `name@domain.com`.
	Username string `protobuf:"bytes,1,opt,name=username,proto3" json:"username,omitempty"`
	// Output only. Timestamp when the license was assigned.
	AssignTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=assign_time,json=assignTime,proto3" json:"assign_time,omitempty"`
	// Output only. Timestamp when the license was recently used. This may not be
	// the most recent usage time, and will be updated regularly (within 24
	// hours).
	RecentUsageTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=recent_usage_time,json=recentUsageTime,proto3" json:"recent_usage_time,omitempty"`
}

func (x *LicensedUser) Reset() {
	*x = LicensedUser{}
	mi := &file_google_cloud_commerce_consumer_procurement_v1_license_management_service_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LicensedUser) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LicensedUser) ProtoMessage() {}

func (x *LicensedUser) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_commerce_consumer_procurement_v1_license_management_service_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LicensedUser.ProtoReflect.Descriptor instead.
func (*LicensedUser) Descriptor() ([]byte, []int) {
	return file_google_cloud_commerce_consumer_procurement_v1_license_management_service_proto_rawDescGZIP(), []int{9}
}

func (x *LicensedUser) GetUsername() string {
	if x != nil {
		return x.Username
	}
	return ""
}

func (x *LicensedUser) GetAssignTime() *timestamppb.Timestamp {
	if x != nil {
		return x.AssignTime
	}
	return nil
}

func (x *LicensedUser) GetRecentUsageTime() *timestamppb.Timestamp {
	if x != nil {
		return x.RecentUsageTime
	}
	return nil
}

// Response message for
// [LicenseManagementService.EnumerateLicensedUsers][google.cloud.commerce.consumer.procurement.v1.LicenseManagementService.EnumerateLicensedUsers].
type EnumerateLicensedUsersResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of licensed users.
	LicensedUsers []*LicensedUser `protobuf:"bytes,1,rep,name=licensed_users,json=licensedUsers,proto3" json:"licensed_users,omitempty"`
	// A token that can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *EnumerateLicensedUsersResponse) Reset() {
	*x = EnumerateLicensedUsersResponse{}
	mi := &file_google_cloud_commerce_consumer_procurement_v1_license_management_service_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EnumerateLicensedUsersResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EnumerateLicensedUsersResponse) ProtoMessage() {}

func (x *EnumerateLicensedUsersResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_commerce_consumer_procurement_v1_license_management_service_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EnumerateLicensedUsersResponse.ProtoReflect.Descriptor instead.
func (*EnumerateLicensedUsersResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_commerce_consumer_procurement_v1_license_management_service_proto_rawDescGZIP(), []int{10}
}

func (x *EnumerateLicensedUsersResponse) GetLicensedUsers() []*LicensedUser {
	if x != nil {
		return x.LicensedUsers
	}
	return nil
}

func (x *EnumerateLicensedUsersResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Allow manual assignments triggered by administrative operations only.
type AssignmentProtocol_ManualAssignmentType struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *AssignmentProtocol_ManualAssignmentType) Reset() {
	*x = AssignmentProtocol_ManualAssignmentType{}
	mi := &file_google_cloud_commerce_consumer_procurement_v1_license_management_service_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AssignmentProtocol_ManualAssignmentType) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AssignmentProtocol_ManualAssignmentType) ProtoMessage() {}

func (x *AssignmentProtocol_ManualAssignmentType) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_commerce_consumer_procurement_v1_license_management_service_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AssignmentProtocol_ManualAssignmentType.ProtoReflect.Descriptor instead.
func (*AssignmentProtocol_ManualAssignmentType) Descriptor() ([]byte, []int) {
	return file_google_cloud_commerce_consumer_procurement_v1_license_management_service_proto_rawDescGZIP(), []int{0, 0}
}

// Configuration for automatic assignments handled by data plane operations.
type AssignmentProtocol_AutoAssignmentType struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The time to live for an inactive license. After this time has
	// passed, the license will be automatically unassigned from the user. Must
	// be at least 7 days, if set. If unset, the license will never expire.
	InactiveLicenseTtl *durationpb.Duration `protobuf:"bytes,1,opt,name=inactive_license_ttl,json=inactiveLicenseTtl,proto3" json:"inactive_license_ttl,omitempty"`
}

func (x *AssignmentProtocol_AutoAssignmentType) Reset() {
	*x = AssignmentProtocol_AutoAssignmentType{}
	mi := &file_google_cloud_commerce_consumer_procurement_v1_license_management_service_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AssignmentProtocol_AutoAssignmentType) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AssignmentProtocol_AutoAssignmentType) ProtoMessage() {}

func (x *AssignmentProtocol_AutoAssignmentType) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_commerce_consumer_procurement_v1_license_management_service_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AssignmentProtocol_AutoAssignmentType.ProtoReflect.Descriptor instead.
func (*AssignmentProtocol_AutoAssignmentType) Descriptor() ([]byte, []int) {
	return file_google_cloud_commerce_consumer_procurement_v1_license_management_service_proto_rawDescGZIP(), []int{0, 1}
}

func (x *AssignmentProtocol_AutoAssignmentType) GetInactiveLicenseTtl() *durationpb.Duration {
	if x != nil {
		return x.InactiveLicenseTtl
	}
	return nil
}

var File_google_cloud_commerce_consumer_procurement_v1_license_management_service_proto protoreflect.FileDescriptor

var file_google_cloud_commerce_consumer_procurement_v1_license_management_service_proto_rawDesc = []byte{
	0x0a, 0x4e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63,
	0x6f, 0x6d, 0x6d, 0x65, 0x72, 0x63, 0x65, 0x2f, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72,
	0x2f, 0x70, 0x72, 0x6f, 0x63, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2f, 0x76, 0x31, 0x2f,
	0x6c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x12, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x6f, 0x6d, 0x6d, 0x65, 0x72, 0x63, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72,
	0x2e, 0x70, 0x72, 0x6f, 0x63, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x1a,
	0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f,
	0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xc3, 0x03, 0x0a, 0x12, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e,
	0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x12, 0x8e, 0x01, 0x0a,
	0x16, 0x6d, 0x61, 0x6e, 0x75, 0x61, 0x6c, 0x5f, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65,
	0x6e, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x56, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6d,
	0x6d, 0x65, 0x72, 0x63, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x2e, 0x70,
	0x72, 0x6f, 0x63, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x73,
	0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c,
	0x2e, 0x4d, 0x61, 0x6e, 0x75, 0x61, 0x6c, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e,
	0x74, 0x54, 0x79, 0x70, 0x65, 0x48, 0x00, 0x52, 0x14, 0x6d, 0x61, 0x6e, 0x75, 0x61, 0x6c, 0x41,
	0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x88, 0x01,
	0x0a, 0x14, 0x61, 0x75, 0x74, 0x6f, 0x5f, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e,
	0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x54, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6d, 0x6d,
	0x65, 0x72, 0x63, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x2e, 0x70, 0x72,
	0x6f, 0x63, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x73, 0x73,
	0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e,
	0x41, 0x75, 0x74, 0x6f, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x54, 0x79,
	0x70, 0x65, 0x48, 0x00, 0x52, 0x12, 0x61, 0x75, 0x74, 0x6f, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e,
	0x6d, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x1a, 0x16, 0x0a, 0x14, 0x4d, 0x61, 0x6e, 0x75,
	0x61, 0x6c, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65,
	0x1a, 0x66, 0x0a, 0x12, 0x41, 0x75, 0x74, 0x6f, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65,
	0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x50, 0x0a, 0x14, 0x69, 0x6e, 0x61, 0x63, 0x74, 0x69,
	0x76, 0x65, 0x5f, 0x6c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x5f, 0x74, 0x74, 0x6c, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x12, 0x69, 0x6e, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x4c, 0x69,
	0x63, 0x65, 0x6e, 0x73, 0x65, 0x54, 0x74, 0x6c, 0x42, 0x11, 0x0a, 0x0f, 0x61, 0x73, 0x73, 0x69,
	0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x22, 0xbe, 0x03, 0x0a, 0x0b,
	0x4c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x17, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x08, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x86, 0x01, 0x0a, 0x1b, 0x6c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65,
	0x5f, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x63, 0x6f, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x72,
	0x63, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x63,
	0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x73, 0x73, 0x69, 0x67,
	0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x19, 0x6c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x41, 0x73, 0x73, 0x69, 0x67,
	0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x12, 0x3b, 0x0a,
	0x17, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6c, 0x69, 0x63, 0x65, 0x6e,
	0x73, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x15, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x4c, 0x69,
	0x63, 0x65, 0x6e, 0x73, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x33, 0x0a, 0x13, 0x74, 0x6f,
	0x74, 0x61, 0x6c, 0x5f, 0x6c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x11, 0x74, 0x6f,
	0x74, 0x61, 0x6c, 0x4c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x3a,
	0x9a, 0x01, 0xea, 0x41, 0x96, 0x01, 0x0a, 0x3b, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x63, 0x6f, 0x6d,
	0x6d, 0x65, 0x72, 0x63, 0x65, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x70, 0x72, 0x6f,
	0x63, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x50,
	0x6f, 0x6f, 0x6c, 0x12, 0x3c, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x41, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x61, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x7d, 0x2f, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x6f,
	0x72, 0x64, 0x65, 0x72, 0x7d, 0x2f, 0x6c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x50, 0x6f, 0x6f,
	0x6c, 0x2a, 0x0c, 0x6c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x32,
	0x0b, 0x6c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x22, 0x30, 0x0a, 0x15,
	0x47, 0x65, 0x74, 0x4c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xc0,
	0x01, 0x0a, 0x18, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65,
	0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x62, 0x0a, 0x0c, 0x6c,
	0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x72, 0x63, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d,
	0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x63, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76,
	0x31, 0x2e, 0x4c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0b, 0x6c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x12,
	0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73,
	0x6b, 0x22, 0x4f, 0x0a, 0x0d, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x21, 0x0a, 0x09, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d,
	0x65, 0x73, 0x22, 0x10, 0x0a, 0x0e, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x51, 0x0a, 0x0f, 0x55, 0x6e, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x21, 0x0a, 0x09, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65,
	0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x75, 0x73,
	0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x22, 0x12, 0x0a, 0x10, 0x55, 0x6e, 0x61, 0x73, 0x73,
	0x69, 0x67, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x82, 0x01, 0x0a, 0x1d,
	0x45, 0x6e, 0x75, 0x6d, 0x65, 0x72, 0x61, 0x74, 0x65, 0x4c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65,
	0x64, 0x55, 0x73, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x22, 0xb9, 0x01, 0x0a, 0x0c, 0x4c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x64, 0x55, 0x73, 0x65,
	0x72, 0x12, 0x1a, 0x0a, 0x08, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x08, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a,
	0x0b, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0a, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x4b, 0x0a, 0x11, 0x72, 0x65, 0x63, 0x65, 0x6e, 0x74, 0x5f, 0x75, 0x73, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x72, 0x65, 0x63,
	0x65, 0x6e, 0x74, 0x55, 0x73, 0x61, 0x67, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x22, 0xac, 0x01, 0x0a,
	0x1e, 0x45, 0x6e, 0x75, 0x6d, 0x65, 0x72, 0x61, 0x74, 0x65, 0x4c, 0x69, 0x63, 0x65, 0x6e, 0x73,
	0x65, 0x64, 0x55, 0x73, 0x65, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x62, 0x0a, 0x0e, 0x6c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x64, 0x5f, 0x75, 0x73, 0x65, 0x72,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x72, 0x63, 0x65, 0x2e,
	0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x63, 0x75, 0x72, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x64,
	0x55, 0x73, 0x65, 0x72, 0x52, 0x0d, 0x6c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x64, 0x55, 0x73,
	0x65, 0x72, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65,
	0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x32, 0xc5, 0x0a, 0x0a, 0x18,
	0x4c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xd4, 0x01, 0x0a, 0x0e, 0x47, 0x65, 0x74,
	0x4c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x44, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x65,
	0x72, 0x63, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f,
	0x63, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x4c,
	0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x72, 0x63, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d,
	0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x63, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76,
	0x31, 0x2e, 0x4c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x22, 0x40, 0xda,
	0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x33, 0x12, 0x31, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x41,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x7d, 0x12,
	0x8b, 0x02, 0x0a, 0x11, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4c, 0x69, 0x63, 0x65, 0x6e, 0x73,
	0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x72, 0x63, 0x65, 0x2e, 0x63, 0x6f,
	0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x63, 0x75, 0x72, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4c, 0x69, 0x63, 0x65,
	0x6e, 0x73, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f,
	0x6d, 0x6d, 0x65, 0x72, 0x63, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x2e,
	0x70, 0x72, 0x6f, 0x63, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x22, 0x71, 0xda, 0x41, 0x18, 0x6c,
	0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x2c, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x50, 0x3a, 0x0c, 0x6c,
	0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x32, 0x40, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x6c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x2e, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x41, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x2f, 0x2a, 0x7d, 0x12, 0xdf, 0x01,
	0x0a, 0x06, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x12, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x72, 0x63, 0x65,
	0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x63, 0x75, 0x72,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x72, 0x63, 0x65, 0x2e, 0x63,
	0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x63, 0x75, 0x72, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x58, 0xda, 0x41, 0x10, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x2c, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3f,
	0x3a, 0x01, 0x2a, 0x22, 0x3a, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x69, 0x63, 0x65,
	0x6e, 0x73, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x7d, 0x3a, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x12,
	0xe7, 0x01, 0x0a, 0x08, 0x55, 0x6e, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x12, 0x3e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6d, 0x6d,
	0x65, 0x72, 0x63, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x2e, 0x70, 0x72,
	0x6f, 0x63, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x6e, 0x61,
	0x73, 0x73, 0x69, 0x67, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3f, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6d, 0x6d,
	0x65, 0x72, 0x63, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x2e, 0x70, 0x72,
	0x6f, 0x63, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x6e, 0x61,
	0x73, 0x73, 0x69, 0x67, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x5a, 0xda,
	0x41, 0x10, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d,
	0x65, 0x73, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x41, 0x3a, 0x01, 0x2a, 0x22, 0x3c, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67,
	0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6f, 0x72, 0x64, 0x65, 0x72,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x7d,
	0x3a, 0x75, 0x6e, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x12, 0x92, 0x02, 0x0a, 0x16, 0x45, 0x6e,
	0x75, 0x6d, 0x65, 0x72, 0x61, 0x74, 0x65, 0x4c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x64, 0x55,
	0x73, 0x65, 0x72, 0x73, 0x12, 0x4c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x72, 0x63, 0x65, 0x2e, 0x63, 0x6f, 0x6e,
	0x73, 0x75, 0x6d, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x63, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x75, 0x6d, 0x65, 0x72, 0x61, 0x74, 0x65, 0x4c, 0x69,
	0x63, 0x65, 0x6e, 0x73, 0x65, 0x64, 0x55, 0x73, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x4d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x72, 0x63, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75,
	0x6d, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x63, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e,
	0x76, 0x31, 0x2e, 0x45, 0x6e, 0x75, 0x6d, 0x65, 0x72, 0x61, 0x74, 0x65, 0x4c, 0x69, 0x63, 0x65,
	0x6e, 0x73, 0x65, 0x64, 0x55, 0x73, 0x65, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x5b, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x4c, 0x12, 0x4a, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d,
	0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x69, 0x63, 0x65, 0x6e,
	0x73, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x7d, 0x3a, 0x65, 0x6e, 0x75, 0x6d, 0x65, 0x72, 0x61, 0x74,
	0x65, 0x4c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x64, 0x55, 0x73, 0x65, 0x72, 0x73, 0x1a, 0x63,
	0xca, 0x41, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x72, 0x63, 0x65,
	0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x70, 0x72, 0x6f, 0x63, 0x75, 0x72, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x42, 0xbe, 0x02, 0x0a, 0x31, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x72, 0x63,
	0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x63, 0x75,
	0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x42, 0x1d, 0x4c, 0x69, 0x63, 0x65, 0x6e,
	0x73, 0x65, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x53, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f,
	0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x72, 0x63, 0x65, 0x2f, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65,
	0x72, 0x2f, 0x70, 0x72, 0x6f, 0x63, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2f, 0x61, 0x70,
	0x69, 0x76, 0x31, 0x2f, 0x70, 0x72, 0x6f, 0x63, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x70,
	0x62, 0x3b, 0x70, 0x72, 0x6f, 0x63, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x70, 0x62, 0xaa,
	0x02, 0x2d, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x43,
	0x6f, 0x6d, 0x6d, 0x65, 0x72, 0x63, 0x65, 0x2e, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72,
	0x2e, 0x50, 0x72, 0x6f, 0x63, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x56, 0x31, 0xca,
	0x02, 0x2d, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x43,
	0x6f, 0x6d, 0x6d, 0x65, 0x72, 0x63, 0x65, 0x5c, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72,
	0x5c, 0x50, 0x72, 0x6f, 0x63, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5c, 0x56, 0x31, 0xea,
	0x02, 0x32, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a,
	0x3a, 0x43, 0x6f, 0x6d, 0x6d, 0x65, 0x72, 0x63, 0x65, 0x3a, 0x3a, 0x43, 0x6f, 0x6e, 0x73, 0x75,
	0x6d, 0x65, 0x72, 0x3a, 0x3a, 0x50, 0x72, 0x6f, 0x63, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_commerce_consumer_procurement_v1_license_management_service_proto_rawDescOnce sync.Once
	file_google_cloud_commerce_consumer_procurement_v1_license_management_service_proto_rawDescData = file_google_cloud_commerce_consumer_procurement_v1_license_management_service_proto_rawDesc
)

func file_google_cloud_commerce_consumer_procurement_v1_license_management_service_proto_rawDescGZIP() []byte {
	file_google_cloud_commerce_consumer_procurement_v1_license_management_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_commerce_consumer_procurement_v1_license_management_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_commerce_consumer_procurement_v1_license_management_service_proto_rawDescData)
	})
	return file_google_cloud_commerce_consumer_procurement_v1_license_management_service_proto_rawDescData
}

var file_google_cloud_commerce_consumer_procurement_v1_license_management_service_proto_msgTypes = make([]protoimpl.MessageInfo, 13)
var file_google_cloud_commerce_consumer_procurement_v1_license_management_service_proto_goTypes = []any{
	(*AssignmentProtocol)(nil),                      // 0: google.cloud.commerce.consumer.procurement.v1.AssignmentProtocol
	(*LicensePool)(nil),                             // 1: google.cloud.commerce.consumer.procurement.v1.LicensePool
	(*GetLicensePoolRequest)(nil),                   // 2: google.cloud.commerce.consumer.procurement.v1.GetLicensePoolRequest
	(*UpdateLicensePoolRequest)(nil),                // 3: google.cloud.commerce.consumer.procurement.v1.UpdateLicensePoolRequest
	(*AssignRequest)(nil),                           // 4: google.cloud.commerce.consumer.procurement.v1.AssignRequest
	(*AssignResponse)(nil),                          // 5: google.cloud.commerce.consumer.procurement.v1.AssignResponse
	(*UnassignRequest)(nil),                         // 6: google.cloud.commerce.consumer.procurement.v1.UnassignRequest
	(*UnassignResponse)(nil),                        // 7: google.cloud.commerce.consumer.procurement.v1.UnassignResponse
	(*EnumerateLicensedUsersRequest)(nil),           // 8: google.cloud.commerce.consumer.procurement.v1.EnumerateLicensedUsersRequest
	(*LicensedUser)(nil),                            // 9: google.cloud.commerce.consumer.procurement.v1.LicensedUser
	(*EnumerateLicensedUsersResponse)(nil),          // 10: google.cloud.commerce.consumer.procurement.v1.EnumerateLicensedUsersResponse
	(*AssignmentProtocol_ManualAssignmentType)(nil), // 11: google.cloud.commerce.consumer.procurement.v1.AssignmentProtocol.ManualAssignmentType
	(*AssignmentProtocol_AutoAssignmentType)(nil),   // 12: google.cloud.commerce.consumer.procurement.v1.AssignmentProtocol.AutoAssignmentType
	(*fieldmaskpb.FieldMask)(nil),                   // 13: google.protobuf.FieldMask
	(*timestamppb.Timestamp)(nil),                   // 14: google.protobuf.Timestamp
	(*durationpb.Duration)(nil),                     // 15: google.protobuf.Duration
}
var file_google_cloud_commerce_consumer_procurement_v1_license_management_service_proto_depIdxs = []int32{
	11, // 0: google.cloud.commerce.consumer.procurement.v1.AssignmentProtocol.manual_assignment_type:type_name -> google.cloud.commerce.consumer.procurement.v1.AssignmentProtocol.ManualAssignmentType
	12, // 1: google.cloud.commerce.consumer.procurement.v1.AssignmentProtocol.auto_assignment_type:type_name -> google.cloud.commerce.consumer.procurement.v1.AssignmentProtocol.AutoAssignmentType
	0,  // 2: google.cloud.commerce.consumer.procurement.v1.LicensePool.license_assignment_protocol:type_name -> google.cloud.commerce.consumer.procurement.v1.AssignmentProtocol
	1,  // 3: google.cloud.commerce.consumer.procurement.v1.UpdateLicensePoolRequest.license_pool:type_name -> google.cloud.commerce.consumer.procurement.v1.LicensePool
	13, // 4: google.cloud.commerce.consumer.procurement.v1.UpdateLicensePoolRequest.update_mask:type_name -> google.protobuf.FieldMask
	14, // 5: google.cloud.commerce.consumer.procurement.v1.LicensedUser.assign_time:type_name -> google.protobuf.Timestamp
	14, // 6: google.cloud.commerce.consumer.procurement.v1.LicensedUser.recent_usage_time:type_name -> google.protobuf.Timestamp
	9,  // 7: google.cloud.commerce.consumer.procurement.v1.EnumerateLicensedUsersResponse.licensed_users:type_name -> google.cloud.commerce.consumer.procurement.v1.LicensedUser
	15, // 8: google.cloud.commerce.consumer.procurement.v1.AssignmentProtocol.AutoAssignmentType.inactive_license_ttl:type_name -> google.protobuf.Duration
	2,  // 9: google.cloud.commerce.consumer.procurement.v1.LicenseManagementService.GetLicensePool:input_type -> google.cloud.commerce.consumer.procurement.v1.GetLicensePoolRequest
	3,  // 10: google.cloud.commerce.consumer.procurement.v1.LicenseManagementService.UpdateLicensePool:input_type -> google.cloud.commerce.consumer.procurement.v1.UpdateLicensePoolRequest
	4,  // 11: google.cloud.commerce.consumer.procurement.v1.LicenseManagementService.Assign:input_type -> google.cloud.commerce.consumer.procurement.v1.AssignRequest
	6,  // 12: google.cloud.commerce.consumer.procurement.v1.LicenseManagementService.Unassign:input_type -> google.cloud.commerce.consumer.procurement.v1.UnassignRequest
	8,  // 13: google.cloud.commerce.consumer.procurement.v1.LicenseManagementService.EnumerateLicensedUsers:input_type -> google.cloud.commerce.consumer.procurement.v1.EnumerateLicensedUsersRequest
	1,  // 14: google.cloud.commerce.consumer.procurement.v1.LicenseManagementService.GetLicensePool:output_type -> google.cloud.commerce.consumer.procurement.v1.LicensePool
	1,  // 15: google.cloud.commerce.consumer.procurement.v1.LicenseManagementService.UpdateLicensePool:output_type -> google.cloud.commerce.consumer.procurement.v1.LicensePool
	5,  // 16: google.cloud.commerce.consumer.procurement.v1.LicenseManagementService.Assign:output_type -> google.cloud.commerce.consumer.procurement.v1.AssignResponse
	7,  // 17: google.cloud.commerce.consumer.procurement.v1.LicenseManagementService.Unassign:output_type -> google.cloud.commerce.consumer.procurement.v1.UnassignResponse
	10, // 18: google.cloud.commerce.consumer.procurement.v1.LicenseManagementService.EnumerateLicensedUsers:output_type -> google.cloud.commerce.consumer.procurement.v1.EnumerateLicensedUsersResponse
	14, // [14:19] is the sub-list for method output_type
	9,  // [9:14] is the sub-list for method input_type
	9,  // [9:9] is the sub-list for extension type_name
	9,  // [9:9] is the sub-list for extension extendee
	0,  // [0:9] is the sub-list for field type_name
}

func init() {
	file_google_cloud_commerce_consumer_procurement_v1_license_management_service_proto_init()
}
func file_google_cloud_commerce_consumer_procurement_v1_license_management_service_proto_init() {
	if File_google_cloud_commerce_consumer_procurement_v1_license_management_service_proto != nil {
		return
	}
	file_google_cloud_commerce_consumer_procurement_v1_license_management_service_proto_msgTypes[0].OneofWrappers = []any{
		(*AssignmentProtocol_ManualAssignmentType_)(nil),
		(*AssignmentProtocol_AutoAssignmentType_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_commerce_consumer_procurement_v1_license_management_service_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   13,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_commerce_consumer_procurement_v1_license_management_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_commerce_consumer_procurement_v1_license_management_service_proto_depIdxs,
		MessageInfos:      file_google_cloud_commerce_consumer_procurement_v1_license_management_service_proto_msgTypes,
	}.Build()
	File_google_cloud_commerce_consumer_procurement_v1_license_management_service_proto = out.File
	file_google_cloud_commerce_consumer_procurement_v1_license_management_service_proto_rawDesc = nil
	file_google_cloud_commerce_consumer_procurement_v1_license_management_service_proto_goTypes = nil
	file_google_cloud_commerce_consumer_procurement_v1_license_management_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// LicenseManagementServiceClient is the client API for LicenseManagementService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type LicenseManagementServiceClient interface {
	// Gets the license pool.
	GetLicensePool(ctx context.Context, in *GetLicensePoolRequest, opts ...grpc.CallOption) (*LicensePool, error)
	// Updates the license pool if one exists for this Order.
	UpdateLicensePool(ctx context.Context, in *UpdateLicensePoolRequest, opts ...grpc.CallOption) (*LicensePool, error)
	// Assigns a license to a user.
	Assign(ctx context.Context, in *AssignRequest, opts ...grpc.CallOption) (*AssignResponse, error)
	// Unassigns a license from a user.
	Unassign(ctx context.Context, in *UnassignRequest, opts ...grpc.CallOption) (*UnassignResponse, error)
	// Enumerates all users assigned a license.
	EnumerateLicensedUsers(ctx context.Context, in *EnumerateLicensedUsersRequest, opts ...grpc.CallOption) (*EnumerateLicensedUsersResponse, error)
}

type licenseManagementServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewLicenseManagementServiceClient(cc grpc.ClientConnInterface) LicenseManagementServiceClient {
	return &licenseManagementServiceClient{cc}
}

func (c *licenseManagementServiceClient) GetLicensePool(ctx context.Context, in *GetLicensePoolRequest, opts ...grpc.CallOption) (*LicensePool, error) {
	out := new(LicensePool)
	err := c.cc.Invoke(ctx, "/google.cloud.commerce.consumer.procurement.v1.LicenseManagementService/GetLicensePool", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *licenseManagementServiceClient) UpdateLicensePool(ctx context.Context, in *UpdateLicensePoolRequest, opts ...grpc.CallOption) (*LicensePool, error) {
	out := new(LicensePool)
	err := c.cc.Invoke(ctx, "/google.cloud.commerce.consumer.procurement.v1.LicenseManagementService/UpdateLicensePool", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *licenseManagementServiceClient) Assign(ctx context.Context, in *AssignRequest, opts ...grpc.CallOption) (*AssignResponse, error) {
	out := new(AssignResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.commerce.consumer.procurement.v1.LicenseManagementService/Assign", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *licenseManagementServiceClient) Unassign(ctx context.Context, in *UnassignRequest, opts ...grpc.CallOption) (*UnassignResponse, error) {
	out := new(UnassignResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.commerce.consumer.procurement.v1.LicenseManagementService/Unassign", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *licenseManagementServiceClient) EnumerateLicensedUsers(ctx context.Context, in *EnumerateLicensedUsersRequest, opts ...grpc.CallOption) (*EnumerateLicensedUsersResponse, error) {
	out := new(EnumerateLicensedUsersResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.commerce.consumer.procurement.v1.LicenseManagementService/EnumerateLicensedUsers", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// LicenseManagementServiceServer is the server API for LicenseManagementService service.
type LicenseManagementServiceServer interface {
	// Gets the license pool.
	GetLicensePool(context.Context, *GetLicensePoolRequest) (*LicensePool, error)
	// Updates the license pool if one exists for this Order.
	UpdateLicensePool(context.Context, *UpdateLicensePoolRequest) (*LicensePool, error)
	// Assigns a license to a user.
	Assign(context.Context, *AssignRequest) (*AssignResponse, error)
	// Unassigns a license from a user.
	Unassign(context.Context, *UnassignRequest) (*UnassignResponse, error)
	// Enumerates all users assigned a license.
	EnumerateLicensedUsers(context.Context, *EnumerateLicensedUsersRequest) (*EnumerateLicensedUsersResponse, error)
}

// UnimplementedLicenseManagementServiceServer can be embedded to have forward compatible implementations.
type UnimplementedLicenseManagementServiceServer struct {
}

func (*UnimplementedLicenseManagementServiceServer) GetLicensePool(context.Context, *GetLicensePoolRequest) (*LicensePool, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetLicensePool not implemented")
}
func (*UnimplementedLicenseManagementServiceServer) UpdateLicensePool(context.Context, *UpdateLicensePoolRequest) (*LicensePool, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateLicensePool not implemented")
}
func (*UnimplementedLicenseManagementServiceServer) Assign(context.Context, *AssignRequest) (*AssignResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Assign not implemented")
}
func (*UnimplementedLicenseManagementServiceServer) Unassign(context.Context, *UnassignRequest) (*UnassignResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Unassign not implemented")
}
func (*UnimplementedLicenseManagementServiceServer) EnumerateLicensedUsers(context.Context, *EnumerateLicensedUsersRequest) (*EnumerateLicensedUsersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method EnumerateLicensedUsers not implemented")
}

func RegisterLicenseManagementServiceServer(s *grpc.Server, srv LicenseManagementServiceServer) {
	s.RegisterService(&_LicenseManagementService_serviceDesc, srv)
}

func _LicenseManagementService_GetLicensePool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetLicensePoolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LicenseManagementServiceServer).GetLicensePool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.commerce.consumer.procurement.v1.LicenseManagementService/GetLicensePool",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LicenseManagementServiceServer).GetLicensePool(ctx, req.(*GetLicensePoolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LicenseManagementService_UpdateLicensePool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateLicensePoolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LicenseManagementServiceServer).UpdateLicensePool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.commerce.consumer.procurement.v1.LicenseManagementService/UpdateLicensePool",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LicenseManagementServiceServer).UpdateLicensePool(ctx, req.(*UpdateLicensePoolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LicenseManagementService_Assign_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AssignRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LicenseManagementServiceServer).Assign(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.commerce.consumer.procurement.v1.LicenseManagementService/Assign",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LicenseManagementServiceServer).Assign(ctx, req.(*AssignRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LicenseManagementService_Unassign_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UnassignRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LicenseManagementServiceServer).Unassign(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.commerce.consumer.procurement.v1.LicenseManagementService/Unassign",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LicenseManagementServiceServer).Unassign(ctx, req.(*UnassignRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LicenseManagementService_EnumerateLicensedUsers_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(EnumerateLicensedUsersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LicenseManagementServiceServer).EnumerateLicensedUsers(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.commerce.consumer.procurement.v1.LicenseManagementService/EnumerateLicensedUsers",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LicenseManagementServiceServer).EnumerateLicensedUsers(ctx, req.(*EnumerateLicensedUsersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _LicenseManagementService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.commerce.consumer.procurement.v1.LicenseManagementService",
	HandlerType: (*LicenseManagementServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetLicensePool",
			Handler:    _LicenseManagementService_GetLicensePool_Handler,
		},
		{
			MethodName: "UpdateLicensePool",
			Handler:    _LicenseManagementService_UpdateLicensePool_Handler,
		},
		{
			MethodName: "Assign",
			Handler:    _LicenseManagementService_Assign_Handler,
		},
		{
			MethodName: "Unassign",
			Handler:    _LicenseManagementService_Unassign_Handler,
		},
		{
			MethodName: "EnumerateLicensedUsers",
			Handler:    _LicenseManagementService_EnumerateLicensedUsers_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/commerce/consumer/procurement/v1/license_management_service.proto",
}
