// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/chat/v1/space_setup.proto

package chatpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Request to create a space and add specified users to it.
type SetUpSpaceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The `Space.spaceType` field is required.
	//
	// To create a space, set `Space.spaceType` to `SPACE` and set
	// `Space.displayName`. If you receive the error message `ALREADY_EXISTS` when
	// setting up a space, try a different `displayName`. An existing space
	// within the Google Workspace organization might already use this display
	// name.
	//
	// To create a group chat, set `Space.spaceType` to
	// `GROUP_CHAT`. Don't set `Space.displayName`.
	//
	// To create a 1:1 conversation between humans,
	// set `Space.spaceType` to `DIRECT_MESSAGE` and set
	// `Space.singleUserBotDm` to `false`. Don't set `Space.displayName` or
	// `Space.spaceDetails`.
	//
	// To create an 1:1 conversation between a human and the calling Chat app, set
	// `Space.spaceType` to `DIRECT_MESSAGE` and
	// `Space.singleUserBotDm` to `true`. Don't set `Space.displayName` or
	// `Space.spaceDetails`.
	//
	// If a `DIRECT_MESSAGE` space already exists, that space is returned instead
	// of creating a new space.
	Space *Space `protobuf:"bytes,1,opt,name=space,proto3" json:"space,omitempty"`
	// Optional. A unique identifier for this request.
	// A random UUID is recommended.
	// Specifying an existing request ID returns the space created with that ID
	// instead of creating a new space.
	// Specifying an existing request ID from the same Chat app with a different
	// authenticated user returns an error.
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Optional. The Google Chat users or groups to invite to join the space. Omit
	// the calling user, as they are added automatically.
	//
	// The set currently allows up to 20 memberships (in addition to the caller).
	//
	// For human membership, the `Membership.member` field must contain a `user`
	// with `name` populated (format: `users/{user}`) and `type` set to
	// `User.Type.HUMAN`. You can only add human users when setting up a space
	// (adding Chat apps is only supported for direct message setup with the
	// calling app). You can also add members using the user's email as an alias
	// for {user}. For example, the `user.name` can be `users/example@gmail.com`.
	// To invite Gmail users or users from external Google Workspace domains,
	// user's email must be used for `{user}`.
	//
	// For Google group membership, the `Membership.group_member` field must
	// contain a `group` with `name` populated (format `groups/{group}`). You
	// can only add Google groups when setting `Space.spaceType` to `SPACE`.
	//
	// Optional when setting `Space.spaceType` to `SPACE`.
	//
	// Required when setting `Space.spaceType` to `GROUP_CHAT`, along with at
	// least two memberships.
	//
	// Required when setting `Space.spaceType` to `DIRECT_MESSAGE` with a human
	// user, along with exactly one membership.
	//
	// Must be empty when creating a 1:1 conversation between a human and the
	// calling Chat app (when setting `Space.spaceType` to
	// `DIRECT_MESSAGE` and `Space.singleUserBotDm` to `true`).
	Memberships []*Membership `protobuf:"bytes,4,rep,name=memberships,proto3" json:"memberships,omitempty"`
}

func (x *SetUpSpaceRequest) Reset() {
	*x = SetUpSpaceRequest{}
	mi := &file_google_chat_v1_space_setup_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SetUpSpaceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetUpSpaceRequest) ProtoMessage() {}

func (x *SetUpSpaceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_space_setup_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetUpSpaceRequest.ProtoReflect.Descriptor instead.
func (*SetUpSpaceRequest) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_space_setup_proto_rawDescGZIP(), []int{0}
}

func (x *SetUpSpaceRequest) GetSpace() *Space {
	if x != nil {
		return x.Space
	}
	return nil
}

func (x *SetUpSpaceRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *SetUpSpaceRequest) GetMemberships() []*Membership {
	if x != nil {
		return x.Memberships
	}
	return nil
}

var File_google_chat_v1_space_setup_proto protoreflect.FileDescriptor

var file_google_chat_v1_space_setup_proto_rawDesc = []byte{
	0x0a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x68, 0x61, 0x74, 0x2f, 0x76, 0x31,
	0x2f, 0x73, 0x70, 0x61, 0x63, 0x65, 0x5f, 0x73, 0x65, 0x74, 0x75, 0x70, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x0e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e,
	0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66,
	0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x68, 0x61, 0x74,
	0x2f, 0x76, 0x31, 0x2f, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x68, 0x61,
	0x74, 0x2f, 0x76, 0x31, 0x2f, 0x73, 0x70, 0x61, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x22, 0xac, 0x01, 0x0a, 0x11, 0x53, 0x65, 0x74, 0x55, 0x70, 0x53, 0x70, 0x61, 0x63, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x30, 0x0a, 0x05, 0x73, 0x70, 0x61, 0x63, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x70, 0x61, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x05, 0x73, 0x70, 0x61, 0x63, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x41, 0x0a, 0x0b,
	0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e,
	0x76, 0x31, 0x2e, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0b, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x73, 0x42,
	0xa8, 0x01, 0x0a, 0x12, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x42, 0x0f, 0x53, 0x70, 0x61, 0x63, 0x65, 0x53, 0x65, 0x74,
	0x75, 0x70, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x2c, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x63,
	0x68, 0x61, 0x74, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x63, 0x68, 0x61, 0x74, 0x70, 0x62,
	0x3b, 0x63, 0x68, 0x61, 0x74, 0x70, 0x62, 0xa2, 0x02, 0x0b, 0x44, 0x59, 0x4e, 0x41, 0x50, 0x49,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0xaa, 0x02, 0x13, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x41,
	0x70, 0x70, 0x73, 0x2e, 0x43, 0x68, 0x61, 0x74, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x13, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x41, 0x70, 0x70, 0x73, 0x5c, 0x43, 0x68, 0x61, 0x74, 0x5c, 0x56,
	0x31, 0xea, 0x02, 0x16, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x41, 0x70, 0x70, 0x73,
	0x3a, 0x3a, 0x43, 0x68, 0x61, 0x74, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x33,
}

var (
	file_google_chat_v1_space_setup_proto_rawDescOnce sync.Once
	file_google_chat_v1_space_setup_proto_rawDescData = file_google_chat_v1_space_setup_proto_rawDesc
)

func file_google_chat_v1_space_setup_proto_rawDescGZIP() []byte {
	file_google_chat_v1_space_setup_proto_rawDescOnce.Do(func() {
		file_google_chat_v1_space_setup_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_chat_v1_space_setup_proto_rawDescData)
	})
	return file_google_chat_v1_space_setup_proto_rawDescData
}

var file_google_chat_v1_space_setup_proto_msgTypes = make([]protoimpl.MessageInfo, 1)
var file_google_chat_v1_space_setup_proto_goTypes = []any{
	(*SetUpSpaceRequest)(nil), // 0: google.chat.v1.SetUpSpaceRequest
	(*Space)(nil),             // 1: google.chat.v1.Space
	(*Membership)(nil),        // 2: google.chat.v1.Membership
}
var file_google_chat_v1_space_setup_proto_depIdxs = []int32{
	1, // 0: google.chat.v1.SetUpSpaceRequest.space:type_name -> google.chat.v1.Space
	2, // 1: google.chat.v1.SetUpSpaceRequest.memberships:type_name -> google.chat.v1.Membership
	2, // [2:2] is the sub-list for method output_type
	2, // [2:2] is the sub-list for method input_type
	2, // [2:2] is the sub-list for extension type_name
	2, // [2:2] is the sub-list for extension extendee
	0, // [0:2] is the sub-list for field type_name
}

func init() { file_google_chat_v1_space_setup_proto_init() }
func file_google_chat_v1_space_setup_proto_init() {
	if File_google_chat_v1_space_setup_proto != nil {
		return
	}
	file_google_chat_v1_membership_proto_init()
	file_google_chat_v1_space_proto_init()
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_chat_v1_space_setup_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   1,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_chat_v1_space_setup_proto_goTypes,
		DependencyIndexes: file_google_chat_v1_space_setup_proto_depIdxs,
		MessageInfos:      file_google_chat_v1_space_setup_proto_msgTypes,
	}.Build()
	File_google_chat_v1_space_setup_proto = out.File
	file_google_chat_v1_space_setup_proto_rawDesc = nil
	file_google_chat_v1_space_setup_proto_goTypes = nil
	file_google_chat_v1_space_setup_proto_depIdxs = nil
}
