// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/chat/v1/contextual_addon.proto

package chatpb

import (
	reflect "reflect"
	sync "sync"

	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type ContextualAddOnMarkup_Card_CardHeader_ImageStyle int32

const (
	ContextualAddOnMarkup_Card_CardHeader_IMAGE_STYLE_UNSPECIFIED ContextualAddOnMarkup_Card_CardHeader_ImageStyle = 0
	// Square border.
	ContextualAddOnMarkup_Card_CardHeader_IMAGE ContextualAddOnMarkup_Card_CardHeader_ImageStyle = 1
	// Circular border.
	ContextualAddOnMarkup_Card_CardHeader_AVATAR ContextualAddOnMarkup_Card_CardHeader_ImageStyle = 2
)

// Enum value maps for ContextualAddOnMarkup_Card_CardHeader_ImageStyle.
var (
	ContextualAddOnMarkup_Card_CardHeader_ImageStyle_name = map[int32]string{
		0: "IMAGE_STYLE_UNSPECIFIED",
		1: "IMAGE",
		2: "AVATAR",
	}
	ContextualAddOnMarkup_Card_CardHeader_ImageStyle_value = map[string]int32{
		"IMAGE_STYLE_UNSPECIFIED": 0,
		"IMAGE":                   1,
		"AVATAR":                  2,
	}
)

func (x ContextualAddOnMarkup_Card_CardHeader_ImageStyle) Enum() *ContextualAddOnMarkup_Card_CardHeader_ImageStyle {
	p := new(ContextualAddOnMarkup_Card_CardHeader_ImageStyle)
	*p = x
	return p
}

func (x ContextualAddOnMarkup_Card_CardHeader_ImageStyle) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ContextualAddOnMarkup_Card_CardHeader_ImageStyle) Descriptor() protoreflect.EnumDescriptor {
	return file_google_chat_v1_contextual_addon_proto_enumTypes[0].Descriptor()
}

func (ContextualAddOnMarkup_Card_CardHeader_ImageStyle) Type() protoreflect.EnumType {
	return &file_google_chat_v1_contextual_addon_proto_enumTypes[0]
}

func (x ContextualAddOnMarkup_Card_CardHeader_ImageStyle) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ContextualAddOnMarkup_Card_CardHeader_ImageStyle.Descriptor instead.
func (ContextualAddOnMarkup_Card_CardHeader_ImageStyle) EnumDescriptor() ([]byte, []int) {
	return file_google_chat_v1_contextual_addon_proto_rawDescGZIP(), []int{0, 0, 0, 0}
}

// The markup for developers to specify the contents of a contextual AddOn.
type ContextualAddOnMarkup struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ContextualAddOnMarkup) Reset() {
	*x = ContextualAddOnMarkup{}
	mi := &file_google_chat_v1_contextual_addon_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ContextualAddOnMarkup) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ContextualAddOnMarkup) ProtoMessage() {}

func (x *ContextualAddOnMarkup) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_contextual_addon_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ContextualAddOnMarkup.ProtoReflect.Descriptor instead.
func (*ContextualAddOnMarkup) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_contextual_addon_proto_rawDescGZIP(), []int{0}
}

// A card is a UI element that can contain UI widgets such as text and
// images.
type ContextualAddOnMarkup_Card struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The header of the card. A header usually contains a title and an image.
	Header *ContextualAddOnMarkup_Card_CardHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	// Sections are separated by a line divider.
	Sections []*ContextualAddOnMarkup_Card_Section `protobuf:"bytes,2,rep,name=sections,proto3" json:"sections,omitempty"`
	// The actions of this card.
	CardActions []*ContextualAddOnMarkup_Card_CardAction `protobuf:"bytes,3,rep,name=card_actions,json=cardActions,proto3" json:"card_actions,omitempty"`
	// Name of the card.
	Name string `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *ContextualAddOnMarkup_Card) Reset() {
	*x = ContextualAddOnMarkup_Card{}
	mi := &file_google_chat_v1_contextual_addon_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ContextualAddOnMarkup_Card) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ContextualAddOnMarkup_Card) ProtoMessage() {}

func (x *ContextualAddOnMarkup_Card) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_contextual_addon_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ContextualAddOnMarkup_Card.ProtoReflect.Descriptor instead.
func (*ContextualAddOnMarkup_Card) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_contextual_addon_proto_rawDescGZIP(), []int{0, 0}
}

func (x *ContextualAddOnMarkup_Card) GetHeader() *ContextualAddOnMarkup_Card_CardHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *ContextualAddOnMarkup_Card) GetSections() []*ContextualAddOnMarkup_Card_Section {
	if x != nil {
		return x.Sections
	}
	return nil
}

func (x *ContextualAddOnMarkup_Card) GetCardActions() []*ContextualAddOnMarkup_Card_CardAction {
	if x != nil {
		return x.CardActions
	}
	return nil
}

func (x *ContextualAddOnMarkup_Card) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

type ContextualAddOnMarkup_Card_CardHeader struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The title must be specified. The header has a fixed height: if both a
	// title and subtitle is specified, each takes up one line. If only the
	// title is specified, it takes up both lines.
	Title string `protobuf:"bytes,1,opt,name=title,proto3" json:"title,omitempty"`
	// The subtitle of the card header.
	Subtitle string `protobuf:"bytes,2,opt,name=subtitle,proto3" json:"subtitle,omitempty"`
	// The image's type (for example, square border or circular border).
	ImageStyle ContextualAddOnMarkup_Card_CardHeader_ImageStyle `protobuf:"varint,3,opt,name=image_style,json=imageStyle,proto3,enum=google.chat.v1.ContextualAddOnMarkup_Card_CardHeader_ImageStyle" json:"image_style,omitempty"`
	// The URL of the image in the card header.
	ImageUrl string `protobuf:"bytes,4,opt,name=image_url,json=imageUrl,proto3" json:"image_url,omitempty"`
}

func (x *ContextualAddOnMarkup_Card_CardHeader) Reset() {
	*x = ContextualAddOnMarkup_Card_CardHeader{}
	mi := &file_google_chat_v1_contextual_addon_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ContextualAddOnMarkup_Card_CardHeader) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ContextualAddOnMarkup_Card_CardHeader) ProtoMessage() {}

func (x *ContextualAddOnMarkup_Card_CardHeader) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_contextual_addon_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ContextualAddOnMarkup_Card_CardHeader.ProtoReflect.Descriptor instead.
func (*ContextualAddOnMarkup_Card_CardHeader) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_contextual_addon_proto_rawDescGZIP(), []int{0, 0, 0}
}

func (x *ContextualAddOnMarkup_Card_CardHeader) GetTitle() string {
	if x != nil {
		return x.Title
	}
	return ""
}

func (x *ContextualAddOnMarkup_Card_CardHeader) GetSubtitle() string {
	if x != nil {
		return x.Subtitle
	}
	return ""
}

func (x *ContextualAddOnMarkup_Card_CardHeader) GetImageStyle() ContextualAddOnMarkup_Card_CardHeader_ImageStyle {
	if x != nil {
		return x.ImageStyle
	}
	return ContextualAddOnMarkup_Card_CardHeader_IMAGE_STYLE_UNSPECIFIED
}

func (x *ContextualAddOnMarkup_Card_CardHeader) GetImageUrl() string {
	if x != nil {
		return x.ImageUrl
	}
	return ""
}

// A section contains a collection of widgets that are rendered
// (vertically) in the order that they are specified. Across all platforms,
// cards have a narrow fixed width, so
// there's currently no need for layout properties (for example, float).
type ContextualAddOnMarkup_Card_Section struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The header of the section. Formatted text is
	// supported. For more information
	// about formatting text, see
	// [Formatting text in Google Chat
	// apps](https://developers.google.com/workspace/chat/format-messages#card-formatting)
	// and
	// [Formatting
	// text in Google Workspace
	// Add-ons](https://developers.google.com/apps-script/add-ons/concepts/widgets#text_formatting).
	Header string `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	// A section must contain at least one widget.
	Widgets []*WidgetMarkup `protobuf:"bytes,2,rep,name=widgets,proto3" json:"widgets,omitempty"`
}

func (x *ContextualAddOnMarkup_Card_Section) Reset() {
	*x = ContextualAddOnMarkup_Card_Section{}
	mi := &file_google_chat_v1_contextual_addon_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ContextualAddOnMarkup_Card_Section) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ContextualAddOnMarkup_Card_Section) ProtoMessage() {}

func (x *ContextualAddOnMarkup_Card_Section) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_contextual_addon_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ContextualAddOnMarkup_Card_Section.ProtoReflect.Descriptor instead.
func (*ContextualAddOnMarkup_Card_Section) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_contextual_addon_proto_rawDescGZIP(), []int{0, 0, 1}
}

func (x *ContextualAddOnMarkup_Card_Section) GetHeader() string {
	if x != nil {
		return x.Header
	}
	return ""
}

func (x *ContextualAddOnMarkup_Card_Section) GetWidgets() []*WidgetMarkup {
	if x != nil {
		return x.Widgets
	}
	return nil
}

// A card action is
// the action associated with the card. For an invoice card, a
// typical action would be: delete invoice, email invoice or open the
// invoice in browser.
//
// Not supported by Google Chat apps.
type ContextualAddOnMarkup_Card_CardAction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The label used to be displayed in the action menu item.
	ActionLabel string `protobuf:"bytes,1,opt,name=action_label,json=actionLabel,proto3" json:"action_label,omitempty"`
	// The onclick action for this action item.
	OnClick *WidgetMarkup_OnClick `protobuf:"bytes,2,opt,name=on_click,json=onClick,proto3" json:"on_click,omitempty"`
}

func (x *ContextualAddOnMarkup_Card_CardAction) Reset() {
	*x = ContextualAddOnMarkup_Card_CardAction{}
	mi := &file_google_chat_v1_contextual_addon_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ContextualAddOnMarkup_Card_CardAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ContextualAddOnMarkup_Card_CardAction) ProtoMessage() {}

func (x *ContextualAddOnMarkup_Card_CardAction) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_contextual_addon_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ContextualAddOnMarkup_Card_CardAction.ProtoReflect.Descriptor instead.
func (*ContextualAddOnMarkup_Card_CardAction) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_contextual_addon_proto_rawDescGZIP(), []int{0, 0, 2}
}

func (x *ContextualAddOnMarkup_Card_CardAction) GetActionLabel() string {
	if x != nil {
		return x.ActionLabel
	}
	return ""
}

func (x *ContextualAddOnMarkup_Card_CardAction) GetOnClick() *WidgetMarkup_OnClick {
	if x != nil {
		return x.OnClick
	}
	return nil
}

var File_google_chat_v1_contextual_addon_proto protoreflect.FileDescriptor

var file_google_chat_v1_contextual_addon_proto_rawDesc = []byte{
	0x0a, 0x25, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x68, 0x61, 0x74, 0x2f, 0x76, 0x31,
	0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x75, 0x61, 0x6c, 0x5f, 0x61, 0x64, 0x64, 0x6f,
	0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x0e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x63, 0x68, 0x61, 0x74, 0x2f, 0x76, 0x31, 0x2f, 0x77, 0x69, 0x64, 0x67, 0x65, 0x74, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xfd, 0x05, 0x0a, 0x15, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78,
	0x74, 0x75, 0x61, 0x6c, 0x41, 0x64, 0x64, 0x4f, 0x6e, 0x4d, 0x61, 0x72, 0x6b, 0x75, 0x70, 0x1a,
	0xe3, 0x05, 0x0a, 0x04, 0x43, 0x61, 0x72, 0x64, 0x12, 0x4d, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64,
	0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78,
	0x74, 0x75, 0x61, 0x6c, 0x41, 0x64, 0x64, 0x4f, 0x6e, 0x4d, 0x61, 0x72, 0x6b, 0x75, 0x70, 0x2e,
	0x43, 0x61, 0x72, 0x64, 0x2e, 0x43, 0x61, 0x72, 0x64, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52,
	0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x4e, 0x0a, 0x08, 0x73, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65,
	0x78, 0x74, 0x75, 0x61, 0x6c, 0x41, 0x64, 0x64, 0x4f, 0x6e, 0x4d, 0x61, 0x72, 0x6b, 0x75, 0x70,
	0x2e, 0x43, 0x61, 0x72, 0x64, 0x2e, 0x53, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x08, 0x73,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x58, 0x0a, 0x0c, 0x63, 0x61, 0x72, 0x64, 0x5f,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x75, 0x61, 0x6c, 0x41, 0x64, 0x64, 0x4f, 0x6e, 0x4d, 0x61,
	0x72, 0x6b, 0x75, 0x70, 0x2e, 0x43, 0x61, 0x72, 0x64, 0x2e, 0x43, 0x61, 0x72, 0x64, 0x41, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x63, 0x61, 0x72, 0x64, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x1a, 0x80, 0x02, 0x0a, 0x0a, 0x43, 0x61, 0x72, 0x64, 0x48, 0x65,
	0x61, 0x64, 0x65, 0x72, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x73, 0x75,
	0x62, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x73, 0x75,
	0x62, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x12, 0x61, 0x0a, 0x0b, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f,
	0x73, 0x74, 0x79, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x40, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e,
	0x74, 0x65, 0x78, 0x74, 0x75, 0x61, 0x6c, 0x41, 0x64, 0x64, 0x4f, 0x6e, 0x4d, 0x61, 0x72, 0x6b,
	0x75, 0x70, 0x2e, 0x43, 0x61, 0x72, 0x64, 0x2e, 0x43, 0x61, 0x72, 0x64, 0x48, 0x65, 0x61, 0x64,
	0x65, 0x72, 0x2e, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x53, 0x74, 0x79, 0x6c, 0x65, 0x52, 0x0a, 0x69,
	0x6d, 0x61, 0x67, 0x65, 0x53, 0x74, 0x79, 0x6c, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x69, 0x6d, 0x61,
	0x67, 0x65, 0x5f, 0x75, 0x72, 0x6c, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x69, 0x6d,
	0x61, 0x67, 0x65, 0x55, 0x72, 0x6c, 0x22, 0x40, 0x0a, 0x0a, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x53,
	0x74, 0x79, 0x6c, 0x65, 0x12, 0x1b, 0x0a, 0x17, 0x49, 0x4d, 0x41, 0x47, 0x45, 0x5f, 0x53, 0x54,
	0x59, 0x4c, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x09, 0x0a, 0x05, 0x49, 0x4d, 0x41, 0x47, 0x45, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06,
	0x41, 0x56, 0x41, 0x54, 0x41, 0x52, 0x10, 0x02, 0x1a, 0x59, 0x0a, 0x07, 0x53, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x36, 0x0a, 0x07, 0x77,
	0x69, 0x64, 0x67, 0x65, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x69,
	0x64, 0x67, 0x65, 0x74, 0x4d, 0x61, 0x72, 0x6b, 0x75, 0x70, 0x52, 0x07, 0x77, 0x69, 0x64, 0x67,
	0x65, 0x74, 0x73, 0x1a, 0x70, 0x0a, 0x0a, 0x43, 0x61, 0x72, 0x64, 0x41, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x21, 0x0a, 0x0c, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x12, 0x3f, 0x0a, 0x08, 0x6f, 0x6e, 0x5f, 0x63, 0x6c, 0x69, 0x63, 0x6b,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x69, 0x64, 0x67, 0x65, 0x74, 0x4d, 0x61,
	0x72, 0x6b, 0x75, 0x70, 0x2e, 0x4f, 0x6e, 0x43, 0x6c, 0x69, 0x63, 0x6b, 0x52, 0x07, 0x6f, 0x6e,
	0x43, 0x6c, 0x69, 0x63, 0x6b, 0x42, 0xad, 0x01, 0x0a, 0x12, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x42, 0x14, 0x43, 0x6f,
	0x6e, 0x74, 0x65, 0x78, 0x74, 0x75, 0x61, 0x6c, 0x41, 0x64, 0x64, 0x4f, 0x6e, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x50, 0x01, 0x5a, 0x2c, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x63, 0x68, 0x61, 0x74, 0x2f, 0x61,
	0x70, 0x69, 0x76, 0x31, 0x2f, 0x63, 0x68, 0x61, 0x74, 0x70, 0x62, 0x3b, 0x63, 0x68, 0x61, 0x74,
	0x70, 0x62, 0xa2, 0x02, 0x0b, 0x44, 0x59, 0x4e, 0x41, 0x50, 0x49, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0xaa, 0x02, 0x13, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x41, 0x70, 0x70, 0x73, 0x2e, 0x43,
	0x68, 0x61, 0x74, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x13, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c,
	0x41, 0x70, 0x70, 0x73, 0x5c, 0x43, 0x68, 0x61, 0x74, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x16, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x41, 0x70, 0x70, 0x73, 0x3a, 0x3a, 0x43, 0x68, 0x61,
	0x74, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_chat_v1_contextual_addon_proto_rawDescOnce sync.Once
	file_google_chat_v1_contextual_addon_proto_rawDescData = file_google_chat_v1_contextual_addon_proto_rawDesc
)

func file_google_chat_v1_contextual_addon_proto_rawDescGZIP() []byte {
	file_google_chat_v1_contextual_addon_proto_rawDescOnce.Do(func() {
		file_google_chat_v1_contextual_addon_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_chat_v1_contextual_addon_proto_rawDescData)
	})
	return file_google_chat_v1_contextual_addon_proto_rawDescData
}

var file_google_chat_v1_contextual_addon_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_chat_v1_contextual_addon_proto_msgTypes = make([]protoimpl.MessageInfo, 5)
var file_google_chat_v1_contextual_addon_proto_goTypes = []any{
	(ContextualAddOnMarkup_Card_CardHeader_ImageStyle)(0), // 0: google.chat.v1.ContextualAddOnMarkup.Card.CardHeader.ImageStyle
	(*ContextualAddOnMarkup)(nil),                         // 1: google.chat.v1.ContextualAddOnMarkup
	(*ContextualAddOnMarkup_Card)(nil),                    // 2: google.chat.v1.ContextualAddOnMarkup.Card
	(*ContextualAddOnMarkup_Card_CardHeader)(nil),         // 3: google.chat.v1.ContextualAddOnMarkup.Card.CardHeader
	(*ContextualAddOnMarkup_Card_Section)(nil),            // 4: google.chat.v1.ContextualAddOnMarkup.Card.Section
	(*ContextualAddOnMarkup_Card_CardAction)(nil),         // 5: google.chat.v1.ContextualAddOnMarkup.Card.CardAction
	(*WidgetMarkup)(nil),                                  // 6: google.chat.v1.WidgetMarkup
	(*WidgetMarkup_OnClick)(nil),                          // 7: google.chat.v1.WidgetMarkup.OnClick
}
var file_google_chat_v1_contextual_addon_proto_depIdxs = []int32{
	3, // 0: google.chat.v1.ContextualAddOnMarkup.Card.header:type_name -> google.chat.v1.ContextualAddOnMarkup.Card.CardHeader
	4, // 1: google.chat.v1.ContextualAddOnMarkup.Card.sections:type_name -> google.chat.v1.ContextualAddOnMarkup.Card.Section
	5, // 2: google.chat.v1.ContextualAddOnMarkup.Card.card_actions:type_name -> google.chat.v1.ContextualAddOnMarkup.Card.CardAction
	0, // 3: google.chat.v1.ContextualAddOnMarkup.Card.CardHeader.image_style:type_name -> google.chat.v1.ContextualAddOnMarkup.Card.CardHeader.ImageStyle
	6, // 4: google.chat.v1.ContextualAddOnMarkup.Card.Section.widgets:type_name -> google.chat.v1.WidgetMarkup
	7, // 5: google.chat.v1.ContextualAddOnMarkup.Card.CardAction.on_click:type_name -> google.chat.v1.WidgetMarkup.OnClick
	6, // [6:6] is the sub-list for method output_type
	6, // [6:6] is the sub-list for method input_type
	6, // [6:6] is the sub-list for extension type_name
	6, // [6:6] is the sub-list for extension extendee
	0, // [0:6] is the sub-list for field type_name
}

func init() { file_google_chat_v1_contextual_addon_proto_init() }
func file_google_chat_v1_contextual_addon_proto_init() {
	if File_google_chat_v1_contextual_addon_proto != nil {
		return
	}
	file_google_chat_v1_widgets_proto_init()
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_chat_v1_contextual_addon_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   5,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_chat_v1_contextual_addon_proto_goTypes,
		DependencyIndexes: file_google_chat_v1_contextual_addon_proto_depIdxs,
		EnumInfos:         file_google_chat_v1_contextual_addon_proto_enumTypes,
		MessageInfos:      file_google_chat_v1_contextual_addon_proto_msgTypes,
	}.Build()
	File_google_chat_v1_contextual_addon_proto = out.File
	file_google_chat_v1_contextual_addon_proto_rawDesc = nil
	file_google_chat_v1_contextual_addon_proto_goTypes = nil
	file_google_chat_v1_contextual_addon_proto_depIdxs = nil
}
