// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/automl/v1beta1/table_spec.proto

package automlpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// A specification of a relational table.
// The table's schema is represented via its child column specs. It is
// pre-populated as part of ImportData by schema inference algorithm, the
// version of which is a required parameter of ImportData InputConfig.
// Note: While working with a table, at times the schema may be
// inconsistent with the data in the table (e.g. string in a FLOAT64 column).
// The consistency validation is done upon creation of a model.
// Used by:
//   - Tables
type TableSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name of the table spec.
	// Form:
	//
	// `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/tableSpecs/{table_spec_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// column_spec_id of the time column. Only used if the parent dataset's
	// ml_use_column_spec_id is not set. Used to split rows into TRAIN, VALIDATE
	// and TEST sets such that oldest rows go to TRAIN set, newest to TEST, and
	// those in between to VALIDATE.
	// Required type: TIMESTAMP.
	// If both this column and ml_use_column are not set, then ML use of all rows
	// will be assigned by AutoML. NOTE: Updates of this field will instantly
	// affect any other users concurrently working with the dataset.
	TimeColumnSpecId string `protobuf:"bytes,2,opt,name=time_column_spec_id,json=timeColumnSpecId,proto3" json:"time_column_spec_id,omitempty"`
	// Output only. The number of rows (i.e. examples) in the table.
	RowCount int64 `protobuf:"varint,3,opt,name=row_count,json=rowCount,proto3" json:"row_count,omitempty"`
	// Output only. The number of valid rows (i.e. without values that don't match
	// DataType-s of their columns).
	ValidRowCount int64 `protobuf:"varint,4,opt,name=valid_row_count,json=validRowCount,proto3" json:"valid_row_count,omitempty"`
	// Output only. The number of columns of the table. That is, the number of
	// child ColumnSpec-s.
	ColumnCount int64 `protobuf:"varint,7,opt,name=column_count,json=columnCount,proto3" json:"column_count,omitempty"`
	// Output only. Input configs via which data currently residing in the table
	// had been imported.
	InputConfigs []*InputConfig `protobuf:"bytes,5,rep,name=input_configs,json=inputConfigs,proto3" json:"input_configs,omitempty"`
	// Used to perform consistent read-modify-write updates. If not set, a blind
	// "overwrite" update happens.
	Etag string `protobuf:"bytes,6,opt,name=etag,proto3" json:"etag,omitempty"`
}

func (x *TableSpec) Reset() {
	*x = TableSpec{}
	mi := &file_google_cloud_automl_v1beta1_table_spec_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TableSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TableSpec) ProtoMessage() {}

func (x *TableSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_automl_v1beta1_table_spec_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TableSpec.ProtoReflect.Descriptor instead.
func (*TableSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_automl_v1beta1_table_spec_proto_rawDescGZIP(), []int{0}
}

func (x *TableSpec) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *TableSpec) GetTimeColumnSpecId() string {
	if x != nil {
		return x.TimeColumnSpecId
	}
	return ""
}

func (x *TableSpec) GetRowCount() int64 {
	if x != nil {
		return x.RowCount
	}
	return 0
}

func (x *TableSpec) GetValidRowCount() int64 {
	if x != nil {
		return x.ValidRowCount
	}
	return 0
}

func (x *TableSpec) GetColumnCount() int64 {
	if x != nil {
		return x.ColumnCount
	}
	return 0
}

func (x *TableSpec) GetInputConfigs() []*InputConfig {
	if x != nil {
		return x.InputConfigs
	}
	return nil
}

func (x *TableSpec) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

var File_google_cloud_automl_v1beta1_table_spec_proto protoreflect.FileDescriptor

var file_google_cloud_automl_v1beta1_table_spec_proto_rawDesc = []byte{
	0x0a, 0x2c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x75, 0x74, 0x6f, 0x6d, 0x6c, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x74, 0x61,
	0x62, 0x6c, 0x65, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1b,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x74,
	0x6f, 0x6d, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x1a, 0x19, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x24, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x6c, 0x2f, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2f, 0x69, 0x6f, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x93, 0x03, 0x0a,
	0x09, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x70, 0x65, 0x63, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2d,
	0x0a, 0x13, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x5f, 0x73, 0x70,
	0x65, 0x63, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x74, 0x69, 0x6d,
	0x65, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x49, 0x64, 0x12, 0x1b, 0x0a,
	0x09, 0x72, 0x6f, 0x77, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x08, 0x72, 0x6f, 0x77, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x26, 0x0a, 0x0f, 0x76, 0x61,
	0x6c, 0x69, 0x64, 0x5f, 0x72, 0x6f, 0x77, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x52, 0x6f, 0x77, 0x43, 0x6f, 0x75,
	0x6e, 0x74, 0x12, 0x21, 0x0a, 0x0c, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x5f, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0b, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e,
	0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x4d, 0x0a, 0x0d, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x74, 0x6f,
	0x6d, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x49, 0x6e, 0x70, 0x75, 0x74,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0c, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x3a, 0x78, 0xea, 0x41, 0x75, 0x0a, 0x1f, 0x61,
	0x75, 0x74, 0x6f, 0x6d, 0x6c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x70, 0x65, 0x63, 0x12, 0x52,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73,
	0x2f, 0x7b, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x7d, 0x2f, 0x74, 0x61, 0x62, 0x6c, 0x65,
	0x53, 0x70, 0x65, 0x63, 0x73, 0x2f, 0x7b, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x73, 0x70, 0x65,
	0x63, 0x7d, 0x42, 0x9b, 0x01, 0x0a, 0x1f, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x6c, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x50, 0x01, 0x5a, 0x37, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x61, 0x75,
	0x74, 0x6f, 0x6d, 0x6c, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f,
	0x61, 0x75, 0x74, 0x6f, 0x6d, 0x6c, 0x70, 0x62, 0x3b, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x6c, 0x70,
	0x62, 0xca, 0x02, 0x1b, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x5c, 0x41, 0x75, 0x74, 0x6f, 0x4d, 0x6c, 0x5c, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0xea,
	0x02, 0x1e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a,
	0x3a, 0x41, 0x75, 0x74, 0x6f, 0x4d, 0x4c, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_automl_v1beta1_table_spec_proto_rawDescOnce sync.Once
	file_google_cloud_automl_v1beta1_table_spec_proto_rawDescData = file_google_cloud_automl_v1beta1_table_spec_proto_rawDesc
)

func file_google_cloud_automl_v1beta1_table_spec_proto_rawDescGZIP() []byte {
	file_google_cloud_automl_v1beta1_table_spec_proto_rawDescOnce.Do(func() {
		file_google_cloud_automl_v1beta1_table_spec_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_automl_v1beta1_table_spec_proto_rawDescData)
	})
	return file_google_cloud_automl_v1beta1_table_spec_proto_rawDescData
}

var file_google_cloud_automl_v1beta1_table_spec_proto_msgTypes = make([]protoimpl.MessageInfo, 1)
var file_google_cloud_automl_v1beta1_table_spec_proto_goTypes = []any{
	(*TableSpec)(nil),   // 0: google.cloud.automl.v1beta1.TableSpec
	(*InputConfig)(nil), // 1: google.cloud.automl.v1beta1.InputConfig
}
var file_google_cloud_automl_v1beta1_table_spec_proto_depIdxs = []int32{
	1, // 0: google.cloud.automl.v1beta1.TableSpec.input_configs:type_name -> google.cloud.automl.v1beta1.InputConfig
	1, // [1:1] is the sub-list for method output_type
	1, // [1:1] is the sub-list for method input_type
	1, // [1:1] is the sub-list for extension type_name
	1, // [1:1] is the sub-list for extension extendee
	0, // [0:1] is the sub-list for field type_name
}

func init() { file_google_cloud_automl_v1beta1_table_spec_proto_init() }
func file_google_cloud_automl_v1beta1_table_spec_proto_init() {
	if File_google_cloud_automl_v1beta1_table_spec_proto != nil {
		return
	}
	file_google_cloud_automl_v1beta1_io_proto_init()
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_automl_v1beta1_table_spec_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   1,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_automl_v1beta1_table_spec_proto_goTypes,
		DependencyIndexes: file_google_cloud_automl_v1beta1_table_spec_proto_depIdxs,
		MessageInfos:      file_google_cloud_automl_v1beta1_table_spec_proto_msgTypes,
	}.Build()
	File_google_cloud_automl_v1beta1_table_spec_proto = out.File
	file_google_cloud_automl_v1beta1_table_spec_proto_rawDesc = nil
	file_google_cloud_automl_v1beta1_table_spec_proto_goTypes = nil
	file_google_cloud_automl_v1beta1_table_spec_proto_depIdxs = nil
}
