// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/apphub/v1/attributes.proto

package apphubpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Criticality Type.
type Criticality_Type int32

const (
	// Unspecified type.
	Criticality_TYPE_UNSPECIFIED Criticality_Type = 0
	// Mission critical service, application or workload.
	Criticality_MISSION_CRITICAL Criticality_Type = 1
	// High impact.
	Criticality_HIGH Criticality_Type = 2
	// Medium impact.
	Criticality_MEDIUM Criticality_Type = 3
	// Low impact.
	Criticality_LOW Criticality_Type = 4
)

// Enum value maps for Criticality_Type.
var (
	Criticality_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "MISSION_CRITICAL",
		2: "HIGH",
		3: "MEDIUM",
		4: "LOW",
	}
	Criticality_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"MISSION_CRITICAL": 1,
		"HIGH":             2,
		"MEDIUM":           3,
		"LOW":              4,
	}
)

func (x Criticality_Type) Enum() *Criticality_Type {
	p := new(Criticality_Type)
	*p = x
	return p
}

func (x Criticality_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Criticality_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_apphub_v1_attributes_proto_enumTypes[0].Descriptor()
}

func (Criticality_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_apphub_v1_attributes_proto_enumTypes[0]
}

func (x Criticality_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Criticality_Type.Descriptor instead.
func (Criticality_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_apphub_v1_attributes_proto_rawDescGZIP(), []int{1, 0}
}

// Environment Type.
type Environment_Type int32

const (
	// Unspecified type.
	Environment_TYPE_UNSPECIFIED Environment_Type = 0
	// Production environment.
	Environment_PRODUCTION Environment_Type = 1
	// Staging environment.
	Environment_STAGING Environment_Type = 2
	// Test environment.
	Environment_TEST Environment_Type = 3
	// Development environment.
	Environment_DEVELOPMENT Environment_Type = 4
)

// Enum value maps for Environment_Type.
var (
	Environment_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "PRODUCTION",
		2: "STAGING",
		3: "TEST",
		4: "DEVELOPMENT",
	}
	Environment_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"PRODUCTION":       1,
		"STAGING":          2,
		"TEST":             3,
		"DEVELOPMENT":      4,
	}
)

func (x Environment_Type) Enum() *Environment_Type {
	p := new(Environment_Type)
	*p = x
	return p
}

func (x Environment_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Environment_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_apphub_v1_attributes_proto_enumTypes[1].Descriptor()
}

func (Environment_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_apphub_v1_attributes_proto_enumTypes[1]
}

func (x Environment_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Environment_Type.Descriptor instead.
func (Environment_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_apphub_v1_attributes_proto_rawDescGZIP(), []int{2, 0}
}

// Consumer provided attributes.
type Attributes struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. User-defined criticality information.
	Criticality *Criticality `protobuf:"bytes,1,opt,name=criticality,proto3" json:"criticality,omitempty"`
	// Optional. User-defined environment information.
	Environment *Environment `protobuf:"bytes,2,opt,name=environment,proto3" json:"environment,omitempty"`
	// Optional. Developer team that owns development and coding.
	DeveloperOwners []*ContactInfo `protobuf:"bytes,3,rep,name=developer_owners,json=developerOwners,proto3" json:"developer_owners,omitempty"`
	// Optional. Operator team that ensures runtime and operations.
	OperatorOwners []*ContactInfo `protobuf:"bytes,4,rep,name=operator_owners,json=operatorOwners,proto3" json:"operator_owners,omitempty"`
	// Optional. Business team that ensures user needs are met and value is
	// delivered
	BusinessOwners []*ContactInfo `protobuf:"bytes,5,rep,name=business_owners,json=businessOwners,proto3" json:"business_owners,omitempty"`
}

func (x *Attributes) Reset() {
	*x = Attributes{}
	mi := &file_google_cloud_apphub_v1_attributes_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Attributes) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Attributes) ProtoMessage() {}

func (x *Attributes) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apphub_v1_attributes_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Attributes.ProtoReflect.Descriptor instead.
func (*Attributes) Descriptor() ([]byte, []int) {
	return file_google_cloud_apphub_v1_attributes_proto_rawDescGZIP(), []int{0}
}

func (x *Attributes) GetCriticality() *Criticality {
	if x != nil {
		return x.Criticality
	}
	return nil
}

func (x *Attributes) GetEnvironment() *Environment {
	if x != nil {
		return x.Environment
	}
	return nil
}

func (x *Attributes) GetDeveloperOwners() []*ContactInfo {
	if x != nil {
		return x.DeveloperOwners
	}
	return nil
}

func (x *Attributes) GetOperatorOwners() []*ContactInfo {
	if x != nil {
		return x.OperatorOwners
	}
	return nil
}

func (x *Attributes) GetBusinessOwners() []*ContactInfo {
	if x != nil {
		return x.BusinessOwners
	}
	return nil
}

// Criticality of the Application, Service, or Workload
type Criticality struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Criticality Type.
	Type Criticality_Type `protobuf:"varint,3,opt,name=type,proto3,enum=google.cloud.apphub.v1.Criticality_Type" json:"type,omitempty"`
}

func (x *Criticality) Reset() {
	*x = Criticality{}
	mi := &file_google_cloud_apphub_v1_attributes_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Criticality) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Criticality) ProtoMessage() {}

func (x *Criticality) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apphub_v1_attributes_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Criticality.ProtoReflect.Descriptor instead.
func (*Criticality) Descriptor() ([]byte, []int) {
	return file_google_cloud_apphub_v1_attributes_proto_rawDescGZIP(), []int{1}
}

func (x *Criticality) GetType() Criticality_Type {
	if x != nil {
		return x.Type
	}
	return Criticality_TYPE_UNSPECIFIED
}

// Environment of the Application, Service, or Workload
type Environment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Environment Type.
	Type Environment_Type `protobuf:"varint,2,opt,name=type,proto3,enum=google.cloud.apphub.v1.Environment_Type" json:"type,omitempty"`
}

func (x *Environment) Reset() {
	*x = Environment{}
	mi := &file_google_cloud_apphub_v1_attributes_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Environment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Environment) ProtoMessage() {}

func (x *Environment) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apphub_v1_attributes_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Environment.ProtoReflect.Descriptor instead.
func (*Environment) Descriptor() ([]byte, []int) {
	return file_google_cloud_apphub_v1_attributes_proto_rawDescGZIP(), []int{2}
}

func (x *Environment) GetType() Environment_Type {
	if x != nil {
		return x.Type
	}
	return Environment_TYPE_UNSPECIFIED
}

// Contact information of stakeholders.
type ContactInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Contact's name.
	// Can have a maximum length of 63 characters.
	DisplayName string `protobuf:"bytes,1,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Required. Email address of the contacts.
	Email string `protobuf:"bytes,2,opt,name=email,proto3" json:"email,omitempty"`
}

func (x *ContactInfo) Reset() {
	*x = ContactInfo{}
	mi := &file_google_cloud_apphub_v1_attributes_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ContactInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ContactInfo) ProtoMessage() {}

func (x *ContactInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apphub_v1_attributes_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ContactInfo.ProtoReflect.Descriptor instead.
func (*ContactInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_apphub_v1_attributes_proto_rawDescGZIP(), []int{3}
}

func (x *ContactInfo) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *ContactInfo) GetEmail() string {
	if x != nil {
		return x.Email
	}
	return ""
}

var File_google_cloud_apphub_v1_attributes_proto protoreflect.FileDescriptor

var file_google_cloud_apphub_v1_attributes_proto_rawDesc = []byte{
	0x0a, 0x27, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x70, 0x70, 0x68, 0x75, 0x62, 0x2f, 0x76, 0x31, 0x2f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75,
	0x74, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x16, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x70, 0x68, 0x75, 0x62, 0x2e, 0x76,
	0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69,
	0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x22, 0x9f, 0x03, 0x0a, 0x0a, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65,
	0x73, 0x12, 0x4a, 0x0a, 0x0b, 0x63, 0x72, 0x69, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x69, 0x74, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x70, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x72, 0x69, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0b, 0x63, 0x72, 0x69, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x12, 0x4a, 0x0a,
	0x0b, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x70, 0x70, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x76, 0x69,
	0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x65, 0x6e,
	0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x53, 0x0a, 0x10, 0x64, 0x65, 0x76,
	0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x5f, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x73, 0x18, 0x03, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x70, 0x70, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e,
	0x74, 0x61, 0x63, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x64,
	0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x4f, 0x77, 0x6e, 0x65, 0x72, 0x73, 0x12, 0x51,
	0x0a, 0x0f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x5f, 0x6f, 0x77, 0x6e, 0x65, 0x72,
	0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x70, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0e, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x4f, 0x77, 0x6e, 0x65, 0x72,
	0x73, 0x12, 0x51, 0x0a, 0x0f, 0x62, 0x75, 0x73, 0x69, 0x6e, 0x65, 0x73, 0x73, 0x5f, 0x6f, 0x77,
	0x6e, 0x65, 0x72, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x70, 0x68, 0x75, 0x62,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x62, 0x75, 0x73, 0x69, 0x6e, 0x65, 0x73, 0x73, 0x4f, 0x77,
	0x6e, 0x65, 0x72, 0x73, 0x22, 0xa3, 0x01, 0x0a, 0x0b, 0x43, 0x72, 0x69, 0x74, 0x69, 0x63, 0x61,
	0x6c, 0x69, 0x74, 0x79, 0x12, 0x41, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x70, 0x70, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x69, 0x74,
	0x69, 0x63, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x22, 0x51, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x14, 0x0a, 0x10, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x14, 0x0a, 0x10, 0x4d, 0x49, 0x53, 0x53, 0x49, 0x4f, 0x4e,
	0x5f, 0x43, 0x52, 0x49, 0x54, 0x49, 0x43, 0x41, 0x4c, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x48,
	0x49, 0x47, 0x48, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x4d, 0x45, 0x44, 0x49, 0x55, 0x4d, 0x10,
	0x03, 0x12, 0x07, 0x0a, 0x03, 0x4c, 0x4f, 0x57, 0x10, 0x04, 0x22, 0xa6, 0x01, 0x0a, 0x0b, 0x45,
	0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x41, 0x0a, 0x04, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x70, 0x68, 0x75, 0x62, 0x2e, 0x76,
	0x31, 0x2e, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x54, 0x79,
	0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x22, 0x54, 0x0a,
	0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0e, 0x0a, 0x0a, 0x50,
	0x52, 0x4f, 0x44, 0x55, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x53,
	0x54, 0x41, 0x47, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x08, 0x0a, 0x04, 0x54, 0x45, 0x53, 0x54,
	0x10, 0x03, 0x12, 0x0f, 0x0a, 0x0b, 0x44, 0x45, 0x56, 0x45, 0x4c, 0x4f, 0x50, 0x4d, 0x45, 0x4e,
	0x54, 0x10, 0x04, 0x22, 0x50, 0x0a, 0x0b, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x49, 0x6e,
	0x66, 0x6f, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64,
	0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x19, 0x0a, 0x05, 0x65, 0x6d,
	0x61, 0x69, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05,
	0x65, 0x6d, 0x61, 0x69, 0x6c, 0x42, 0xb1, 0x01, 0x0a, 0x1a, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x70, 0x68, 0x75,
	0x62, 0x2e, 0x76, 0x31, 0x42, 0x0f, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x32, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x61, 0x70, 0x70,
	0x68, 0x75, 0x62, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x61, 0x70, 0x70, 0x68, 0x75, 0x62,
	0x70, 0x62, 0x3b, 0x61, 0x70, 0x70, 0x68, 0x75, 0x62, 0x70, 0x62, 0xaa, 0x02, 0x16, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x41, 0x70, 0x70, 0x48, 0x75,
	0x62, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x16, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x5c, 0x41, 0x70, 0x70, 0x48, 0x75, 0x62, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x19,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x41,
	0x70, 0x70, 0x48, 0x75, 0x62, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x33,
}

var (
	file_google_cloud_apphub_v1_attributes_proto_rawDescOnce sync.Once
	file_google_cloud_apphub_v1_attributes_proto_rawDescData = file_google_cloud_apphub_v1_attributes_proto_rawDesc
)

func file_google_cloud_apphub_v1_attributes_proto_rawDescGZIP() []byte {
	file_google_cloud_apphub_v1_attributes_proto_rawDescOnce.Do(func() {
		file_google_cloud_apphub_v1_attributes_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_apphub_v1_attributes_proto_rawDescData)
	})
	return file_google_cloud_apphub_v1_attributes_proto_rawDescData
}

var file_google_cloud_apphub_v1_attributes_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_cloud_apphub_v1_attributes_proto_msgTypes = make([]protoimpl.MessageInfo, 4)
var file_google_cloud_apphub_v1_attributes_proto_goTypes = []any{
	(Criticality_Type)(0), // 0: google.cloud.apphub.v1.Criticality.Type
	(Environment_Type)(0), // 1: google.cloud.apphub.v1.Environment.Type
	(*Attributes)(nil),    // 2: google.cloud.apphub.v1.Attributes
	(*Criticality)(nil),   // 3: google.cloud.apphub.v1.Criticality
	(*Environment)(nil),   // 4: google.cloud.apphub.v1.Environment
	(*ContactInfo)(nil),   // 5: google.cloud.apphub.v1.ContactInfo
}
var file_google_cloud_apphub_v1_attributes_proto_depIdxs = []int32{
	3, // 0: google.cloud.apphub.v1.Attributes.criticality:type_name -> google.cloud.apphub.v1.Criticality
	4, // 1: google.cloud.apphub.v1.Attributes.environment:type_name -> google.cloud.apphub.v1.Environment
	5, // 2: google.cloud.apphub.v1.Attributes.developer_owners:type_name -> google.cloud.apphub.v1.ContactInfo
	5, // 3: google.cloud.apphub.v1.Attributes.operator_owners:type_name -> google.cloud.apphub.v1.ContactInfo
	5, // 4: google.cloud.apphub.v1.Attributes.business_owners:type_name -> google.cloud.apphub.v1.ContactInfo
	0, // 5: google.cloud.apphub.v1.Criticality.type:type_name -> google.cloud.apphub.v1.Criticality.Type
	1, // 6: google.cloud.apphub.v1.Environment.type:type_name -> google.cloud.apphub.v1.Environment.Type
	7, // [7:7] is the sub-list for method output_type
	7, // [7:7] is the sub-list for method input_type
	7, // [7:7] is the sub-list for extension type_name
	7, // [7:7] is the sub-list for extension extendee
	0, // [0:7] is the sub-list for field type_name
}

func init() { file_google_cloud_apphub_v1_attributes_proto_init() }
func file_google_cloud_apphub_v1_attributes_proto_init() {
	if File_google_cloud_apphub_v1_attributes_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_apphub_v1_attributes_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   4,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_apphub_v1_attributes_proto_goTypes,
		DependencyIndexes: file_google_cloud_apphub_v1_attributes_proto_depIdxs,
		EnumInfos:         file_google_cloud_apphub_v1_attributes_proto_enumTypes,
		MessageInfos:      file_google_cloud_apphub_v1_attributes_proto_msgTypes,
	}.Build()
	File_google_cloud_apphub_v1_attributes_proto = out.File
	file_google_cloud_apphub_v1_attributes_proto_rawDesc = nil
	file_google_cloud_apphub_v1_attributes_proto_goTypes = nil
	file_google_cloud_apphub_v1_attributes_proto_depIdxs = nil
}
