// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/devtools/build/v1/build_events.proto

package build // import "google.golang.org/genproto/googleapis/devtools/build/v1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import any "github.com/golang/protobuf/ptypes/any"
import timestamp "github.com/golang/protobuf/ptypes/timestamp"
import wrappers "github.com/golang/protobuf/ptypes/wrappers"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import _ "google.golang.org/genproto/googleapis/rpc/status"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// The type of console output stream.
type ConsoleOutputStream int32

const (
	// Unspecified or unknown.
	ConsoleOutputStream_UNKNOWN ConsoleOutputStream = 0
	// Normal output stream.
	ConsoleOutputStream_STDOUT ConsoleOutputStream = 1
	// Error output stream.
	ConsoleOutputStream_STDERR ConsoleOutputStream = 2
)

var ConsoleOutputStream_name = map[int32]string{
	0: "UNKNOWN",
	1: "STDOUT",
	2: "STDERR",
}
var ConsoleOutputStream_value = map[string]int32{
	"UNKNOWN": 0,
	"STDOUT":  1,
	"STDERR":  2,
}

func (x ConsoleOutputStream) String() string {
	return proto.EnumName(ConsoleOutputStream_name, int32(x))
}
func (ConsoleOutputStream) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_build_events_cc132f62a908b693, []int{0}
}

// How did the event stream finish.
type BuildEvent_BuildComponentStreamFinished_FinishType int32

const (
	// Unknown or unspecified; callers should never set this value.
	BuildEvent_BuildComponentStreamFinished_FINISH_TYPE_UNSPECIFIED BuildEvent_BuildComponentStreamFinished_FinishType = 0
	// Set by the event publisher to indicate a build event stream is
	// finished.
	BuildEvent_BuildComponentStreamFinished_FINISHED BuildEvent_BuildComponentStreamFinished_FinishType = 1
	// Set by the WatchBuild RPC server when the publisher of a build event
	// stream stops publishing events without publishing a
	// BuildComponentStreamFinished event whose type equals FINISHED.
	BuildEvent_BuildComponentStreamFinished_EXPIRED BuildEvent_BuildComponentStreamFinished_FinishType = 2
)

var BuildEvent_BuildComponentStreamFinished_FinishType_name = map[int32]string{
	0: "FINISH_TYPE_UNSPECIFIED",
	1: "FINISHED",
	2: "EXPIRED",
}
var BuildEvent_BuildComponentStreamFinished_FinishType_value = map[string]int32{
	"FINISH_TYPE_UNSPECIFIED": 0,
	"FINISHED":                1,
	"EXPIRED":                 2,
}

func (x BuildEvent_BuildComponentStreamFinished_FinishType) String() string {
	return proto.EnumName(BuildEvent_BuildComponentStreamFinished_FinishType_name, int32(x))
}
func (BuildEvent_BuildComponentStreamFinished_FinishType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_build_events_cc132f62a908b693, []int{0, 5, 0}
}

// Which build component generates this event stream. Each build component
// may generate one event stream.
type StreamId_BuildComponent int32

const (
	// Unknown or unspecified; callers should never set this value.
	StreamId_UNKNOWN_COMPONENT StreamId_BuildComponent = 0
	// A component that coordinates builds.
	StreamId_CONTROLLER StreamId_BuildComponent = 1
	// A component that runs executables needed to complete a build.
	StreamId_WORKER StreamId_BuildComponent = 2
	// A component that builds something.
	StreamId_TOOL StreamId_BuildComponent = 3
)

var StreamId_BuildComponent_name = map[int32]string{
	0: "UNKNOWN_COMPONENT",
	1: "CONTROLLER",
	2: "WORKER",
	3: "TOOL",
}
var StreamId_BuildComponent_value = map[string]int32{
	"UNKNOWN_COMPONENT": 0,
	"CONTROLLER":        1,
	"WORKER":            2,
	"TOOL":              3,
}

func (x StreamId_BuildComponent) String() string {
	return proto.EnumName(StreamId_BuildComponent_name, int32(x))
}
func (StreamId_BuildComponent) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_build_events_cc132f62a908b693, []int{1, 0}
}

// An event representing some state change that occured in the build. This
// message does not include field for uniquely identifying an event.
type BuildEvent struct {
	// The timestamp of this event.
	EventTime *timestamp.Timestamp `protobuf:"bytes,1,opt,name=event_time,json=eventTime,proto3" json:"event_time,omitempty"`
	// //////////////////////////////////////////////////////////////////////////
	// Events that indicate a state change of a build request in the build
	// queue.
	//
	// Types that are valid to be assigned to Event:
	//	*BuildEvent_InvocationAttemptStarted_
	//	*BuildEvent_InvocationAttemptFinished_
	//	*BuildEvent_BuildEnqueued_
	//	*BuildEvent_BuildFinished_
	//	*BuildEvent_ConsoleOutput_
	//	*BuildEvent_ComponentStreamFinished
	//	*BuildEvent_BazelEvent
	//	*BuildEvent_BuildExecutionEvent
	//	*BuildEvent_SourceFetchEvent
	Event                isBuildEvent_Event `protobuf_oneof:"event"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *BuildEvent) Reset()         { *m = BuildEvent{} }
func (m *BuildEvent) String() string { return proto.CompactTextString(m) }
func (*BuildEvent) ProtoMessage()    {}
func (*BuildEvent) Descriptor() ([]byte, []int) {
	return fileDescriptor_build_events_cc132f62a908b693, []int{0}
}
func (m *BuildEvent) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BuildEvent.Unmarshal(m, b)
}
func (m *BuildEvent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BuildEvent.Marshal(b, m, deterministic)
}
func (dst *BuildEvent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BuildEvent.Merge(dst, src)
}
func (m *BuildEvent) XXX_Size() int {
	return xxx_messageInfo_BuildEvent.Size(m)
}
func (m *BuildEvent) XXX_DiscardUnknown() {
	xxx_messageInfo_BuildEvent.DiscardUnknown(m)
}

var xxx_messageInfo_BuildEvent proto.InternalMessageInfo

type isBuildEvent_Event interface {
	isBuildEvent_Event()
}

type BuildEvent_InvocationAttemptStarted_ struct {
	InvocationAttemptStarted *BuildEvent_InvocationAttemptStarted `protobuf:"bytes,51,opt,name=invocation_attempt_started,json=invocationAttemptStarted,proto3,oneof"`
}
type BuildEvent_InvocationAttemptFinished_ struct {
	InvocationAttemptFinished *BuildEvent_InvocationAttemptFinished `protobuf:"bytes,52,opt,name=invocation_attempt_finished,json=invocationAttemptFinished,proto3,oneof"`
}
type BuildEvent_BuildEnqueued_ struct {
	BuildEnqueued *BuildEvent_BuildEnqueued `protobuf:"bytes,53,opt,name=build_enqueued,json=buildEnqueued,proto3,oneof"`
}
type BuildEvent_BuildFinished_ struct {
	BuildFinished *BuildEvent_BuildFinished `protobuf:"bytes,55,opt,name=build_finished,json=buildFinished,proto3,oneof"`
}
type BuildEvent_ConsoleOutput_ struct {
	ConsoleOutput *BuildEvent_ConsoleOutput `protobuf:"bytes,56,opt,name=console_output,json=consoleOutput,proto3,oneof"`
}
type BuildEvent_ComponentStreamFinished struct {
	ComponentStreamFinished *BuildEvent_BuildComponentStreamFinished `protobuf:"bytes,59,opt,name=component_stream_finished,json=componentStreamFinished,proto3,oneof"`
}
type BuildEvent_BazelEvent struct {
	BazelEvent *any.Any `protobuf:"bytes,60,opt,name=bazel_event,json=bazelEvent,proto3,oneof"`
}
type BuildEvent_BuildExecutionEvent struct {
	BuildExecutionEvent *any.Any `protobuf:"bytes,61,opt,name=build_execution_event,json=buildExecutionEvent,proto3,oneof"`
}
type BuildEvent_SourceFetchEvent struct {
	SourceFetchEvent *any.Any `protobuf:"bytes,62,opt,name=source_fetch_event,json=sourceFetchEvent,proto3,oneof"`
}

func (*BuildEvent_InvocationAttemptStarted_) isBuildEvent_Event()  {}
func (*BuildEvent_InvocationAttemptFinished_) isBuildEvent_Event() {}
func (*BuildEvent_BuildEnqueued_) isBuildEvent_Event()             {}
func (*BuildEvent_BuildFinished_) isBuildEvent_Event()             {}
func (*BuildEvent_ConsoleOutput_) isBuildEvent_Event()             {}
func (*BuildEvent_ComponentStreamFinished) isBuildEvent_Event()    {}
func (*BuildEvent_BazelEvent) isBuildEvent_Event()                 {}
func (*BuildEvent_BuildExecutionEvent) isBuildEvent_Event()        {}
func (*BuildEvent_SourceFetchEvent) isBuildEvent_Event()           {}

func (m *BuildEvent) GetEvent() isBuildEvent_Event {
	if m != nil {
		return m.Event
	}
	return nil
}

func (m *BuildEvent) GetEventTime() *timestamp.Timestamp {
	if m != nil {
		return m.EventTime
	}
	return nil
}

func (m *BuildEvent) GetInvocationAttemptStarted() *BuildEvent_InvocationAttemptStarted {
	if x, ok := m.GetEvent().(*BuildEvent_InvocationAttemptStarted_); ok {
		return x.InvocationAttemptStarted
	}
	return nil
}

func (m *BuildEvent) GetInvocationAttemptFinished() *BuildEvent_InvocationAttemptFinished {
	if x, ok := m.GetEvent().(*BuildEvent_InvocationAttemptFinished_); ok {
		return x.InvocationAttemptFinished
	}
	return nil
}

func (m *BuildEvent) GetBuildEnqueued() *BuildEvent_BuildEnqueued {
	if x, ok := m.GetEvent().(*BuildEvent_BuildEnqueued_); ok {
		return x.BuildEnqueued
	}
	return nil
}

func (m *BuildEvent) GetBuildFinished() *BuildEvent_BuildFinished {
	if x, ok := m.GetEvent().(*BuildEvent_BuildFinished_); ok {
		return x.BuildFinished
	}
	return nil
}

func (m *BuildEvent) GetConsoleOutput() *BuildEvent_ConsoleOutput {
	if x, ok := m.GetEvent().(*BuildEvent_ConsoleOutput_); ok {
		return x.ConsoleOutput
	}
	return nil
}

func (m *BuildEvent) GetComponentStreamFinished() *BuildEvent_BuildComponentStreamFinished {
	if x, ok := m.GetEvent().(*BuildEvent_ComponentStreamFinished); ok {
		return x.ComponentStreamFinished
	}
	return nil
}

func (m *BuildEvent) GetBazelEvent() *any.Any {
	if x, ok := m.GetEvent().(*BuildEvent_BazelEvent); ok {
		return x.BazelEvent
	}
	return nil
}

func (m *BuildEvent) GetBuildExecutionEvent() *any.Any {
	if x, ok := m.GetEvent().(*BuildEvent_BuildExecutionEvent); ok {
		return x.BuildExecutionEvent
	}
	return nil
}

func (m *BuildEvent) GetSourceFetchEvent() *any.Any {
	if x, ok := m.GetEvent().(*BuildEvent_SourceFetchEvent); ok {
		return x.SourceFetchEvent
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*BuildEvent) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _BuildEvent_OneofMarshaler, _BuildEvent_OneofUnmarshaler, _BuildEvent_OneofSizer, []interface{}{
		(*BuildEvent_InvocationAttemptStarted_)(nil),
		(*BuildEvent_InvocationAttemptFinished_)(nil),
		(*BuildEvent_BuildEnqueued_)(nil),
		(*BuildEvent_BuildFinished_)(nil),
		(*BuildEvent_ConsoleOutput_)(nil),
		(*BuildEvent_ComponentStreamFinished)(nil),
		(*BuildEvent_BazelEvent)(nil),
		(*BuildEvent_BuildExecutionEvent)(nil),
		(*BuildEvent_SourceFetchEvent)(nil),
	}
}

func _BuildEvent_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*BuildEvent)
	// event
	switch x := m.Event.(type) {
	case *BuildEvent_InvocationAttemptStarted_:
		b.EncodeVarint(51<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.InvocationAttemptStarted); err != nil {
			return err
		}
	case *BuildEvent_InvocationAttemptFinished_:
		b.EncodeVarint(52<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.InvocationAttemptFinished); err != nil {
			return err
		}
	case *BuildEvent_BuildEnqueued_:
		b.EncodeVarint(53<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.BuildEnqueued); err != nil {
			return err
		}
	case *BuildEvent_BuildFinished_:
		b.EncodeVarint(55<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.BuildFinished); err != nil {
			return err
		}
	case *BuildEvent_ConsoleOutput_:
		b.EncodeVarint(56<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ConsoleOutput); err != nil {
			return err
		}
	case *BuildEvent_ComponentStreamFinished:
		b.EncodeVarint(59<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ComponentStreamFinished); err != nil {
			return err
		}
	case *BuildEvent_BazelEvent:
		b.EncodeVarint(60<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.BazelEvent); err != nil {
			return err
		}
	case *BuildEvent_BuildExecutionEvent:
		b.EncodeVarint(61<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.BuildExecutionEvent); err != nil {
			return err
		}
	case *BuildEvent_SourceFetchEvent:
		b.EncodeVarint(62<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.SourceFetchEvent); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("BuildEvent.Event has unexpected type %T", x)
	}
	return nil
}

func _BuildEvent_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*BuildEvent)
	switch tag {
	case 51: // event.invocation_attempt_started
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(BuildEvent_InvocationAttemptStarted)
		err := b.DecodeMessage(msg)
		m.Event = &BuildEvent_InvocationAttemptStarted_{msg}
		return true, err
	case 52: // event.invocation_attempt_finished
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(BuildEvent_InvocationAttemptFinished)
		err := b.DecodeMessage(msg)
		m.Event = &BuildEvent_InvocationAttemptFinished_{msg}
		return true, err
	case 53: // event.build_enqueued
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(BuildEvent_BuildEnqueued)
		err := b.DecodeMessage(msg)
		m.Event = &BuildEvent_BuildEnqueued_{msg}
		return true, err
	case 55: // event.build_finished
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(BuildEvent_BuildFinished)
		err := b.DecodeMessage(msg)
		m.Event = &BuildEvent_BuildFinished_{msg}
		return true, err
	case 56: // event.console_output
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(BuildEvent_ConsoleOutput)
		err := b.DecodeMessage(msg)
		m.Event = &BuildEvent_ConsoleOutput_{msg}
		return true, err
	case 59: // event.component_stream_finished
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(BuildEvent_BuildComponentStreamFinished)
		err := b.DecodeMessage(msg)
		m.Event = &BuildEvent_ComponentStreamFinished{msg}
		return true, err
	case 60: // event.bazel_event
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(any.Any)
		err := b.DecodeMessage(msg)
		m.Event = &BuildEvent_BazelEvent{msg}
		return true, err
	case 61: // event.build_execution_event
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(any.Any)
		err := b.DecodeMessage(msg)
		m.Event = &BuildEvent_BuildExecutionEvent{msg}
		return true, err
	case 62: // event.source_fetch_event
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(any.Any)
		err := b.DecodeMessage(msg)
		m.Event = &BuildEvent_SourceFetchEvent{msg}
		return true, err
	default:
		return false, nil
	}
}

func _BuildEvent_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*BuildEvent)
	// event
	switch x := m.Event.(type) {
	case *BuildEvent_InvocationAttemptStarted_:
		s := proto.Size(x.InvocationAttemptStarted)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *BuildEvent_InvocationAttemptFinished_:
		s := proto.Size(x.InvocationAttemptFinished)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *BuildEvent_BuildEnqueued_:
		s := proto.Size(x.BuildEnqueued)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *BuildEvent_BuildFinished_:
		s := proto.Size(x.BuildFinished)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *BuildEvent_ConsoleOutput_:
		s := proto.Size(x.ConsoleOutput)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *BuildEvent_ComponentStreamFinished:
		s := proto.Size(x.ComponentStreamFinished)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *BuildEvent_BazelEvent:
		s := proto.Size(x.BazelEvent)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *BuildEvent_BuildExecutionEvent:
		s := proto.Size(x.BuildExecutionEvent)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *BuildEvent_SourceFetchEvent:
		s := proto.Size(x.SourceFetchEvent)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Notification that the build system has attempted to run the build tool.
type BuildEvent_InvocationAttemptStarted struct {
	// The number of the invocation attempt, starting at 1 and increasing by 1
	// for each new attempt. Can be used to determine if there is a later
	// invocation attempt replacing the current one a client is processing.
	AttemptNumber        int64    `protobuf:"varint,1,opt,name=attempt_number,json=attemptNumber,proto3" json:"attempt_number,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BuildEvent_InvocationAttemptStarted) Reset()         { *m = BuildEvent_InvocationAttemptStarted{} }
func (m *BuildEvent_InvocationAttemptStarted) String() string { return proto.CompactTextString(m) }
func (*BuildEvent_InvocationAttemptStarted) ProtoMessage()    {}
func (*BuildEvent_InvocationAttemptStarted) Descriptor() ([]byte, []int) {
	return fileDescriptor_build_events_cc132f62a908b693, []int{0, 0}
}
func (m *BuildEvent_InvocationAttemptStarted) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BuildEvent_InvocationAttemptStarted.Unmarshal(m, b)
}
func (m *BuildEvent_InvocationAttemptStarted) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BuildEvent_InvocationAttemptStarted.Marshal(b, m, deterministic)
}
func (dst *BuildEvent_InvocationAttemptStarted) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BuildEvent_InvocationAttemptStarted.Merge(dst, src)
}
func (m *BuildEvent_InvocationAttemptStarted) XXX_Size() int {
	return xxx_messageInfo_BuildEvent_InvocationAttemptStarted.Size(m)
}
func (m *BuildEvent_InvocationAttemptStarted) XXX_DiscardUnknown() {
	xxx_messageInfo_BuildEvent_InvocationAttemptStarted.DiscardUnknown(m)
}

var xxx_messageInfo_BuildEvent_InvocationAttemptStarted proto.InternalMessageInfo

func (m *BuildEvent_InvocationAttemptStarted) GetAttemptNumber() int64 {
	if m != nil {
		return m.AttemptNumber
	}
	return 0
}

// Notification that an invocation attempt has finished.
type BuildEvent_InvocationAttemptFinished struct {
	// The exit code of the build tool.
	ExitCode *wrappers.Int32Value `protobuf:"bytes,2,opt,name=exit_code,json=exitCode,proto3" json:"exit_code,omitempty"`
	// Final status of the invocation.
	InvocationStatus     *BuildStatus `protobuf:"bytes,3,opt,name=invocation_status,json=invocationStatus,proto3" json:"invocation_status,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *BuildEvent_InvocationAttemptFinished) Reset()         { *m = BuildEvent_InvocationAttemptFinished{} }
func (m *BuildEvent_InvocationAttemptFinished) String() string { return proto.CompactTextString(m) }
func (*BuildEvent_InvocationAttemptFinished) ProtoMessage()    {}
func (*BuildEvent_InvocationAttemptFinished) Descriptor() ([]byte, []int) {
	return fileDescriptor_build_events_cc132f62a908b693, []int{0, 1}
}
func (m *BuildEvent_InvocationAttemptFinished) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BuildEvent_InvocationAttemptFinished.Unmarshal(m, b)
}
func (m *BuildEvent_InvocationAttemptFinished) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BuildEvent_InvocationAttemptFinished.Marshal(b, m, deterministic)
}
func (dst *BuildEvent_InvocationAttemptFinished) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BuildEvent_InvocationAttemptFinished.Merge(dst, src)
}
func (m *BuildEvent_InvocationAttemptFinished) XXX_Size() int {
	return xxx_messageInfo_BuildEvent_InvocationAttemptFinished.Size(m)
}
func (m *BuildEvent_InvocationAttemptFinished) XXX_DiscardUnknown() {
	xxx_messageInfo_BuildEvent_InvocationAttemptFinished.DiscardUnknown(m)
}

var xxx_messageInfo_BuildEvent_InvocationAttemptFinished proto.InternalMessageInfo

func (m *BuildEvent_InvocationAttemptFinished) GetExitCode() *wrappers.Int32Value {
	if m != nil {
		return m.ExitCode
	}
	return nil
}

func (m *BuildEvent_InvocationAttemptFinished) GetInvocationStatus() *BuildStatus {
	if m != nil {
		return m.InvocationStatus
	}
	return nil
}

// Notification that the build request is enqueued. It could happen when
// a new build request is inserted into the build queue, or when a
// build request is put back into the build queue due to a previous build
// failure.
type BuildEvent_BuildEnqueued struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BuildEvent_BuildEnqueued) Reset()         { *m = BuildEvent_BuildEnqueued{} }
func (m *BuildEvent_BuildEnqueued) String() string { return proto.CompactTextString(m) }
func (*BuildEvent_BuildEnqueued) ProtoMessage()    {}
func (*BuildEvent_BuildEnqueued) Descriptor() ([]byte, []int) {
	return fileDescriptor_build_events_cc132f62a908b693, []int{0, 2}
}
func (m *BuildEvent_BuildEnqueued) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BuildEvent_BuildEnqueued.Unmarshal(m, b)
}
func (m *BuildEvent_BuildEnqueued) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BuildEvent_BuildEnqueued.Marshal(b, m, deterministic)
}
func (dst *BuildEvent_BuildEnqueued) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BuildEvent_BuildEnqueued.Merge(dst, src)
}
func (m *BuildEvent_BuildEnqueued) XXX_Size() int {
	return xxx_messageInfo_BuildEvent_BuildEnqueued.Size(m)
}
func (m *BuildEvent_BuildEnqueued) XXX_DiscardUnknown() {
	xxx_messageInfo_BuildEvent_BuildEnqueued.DiscardUnknown(m)
}

var xxx_messageInfo_BuildEvent_BuildEnqueued proto.InternalMessageInfo

// Notification that the build request has finished, and no further
// invocations will occur.  Note that this applies to the entire Build.
// Individual invocations trigger InvocationFinished when they finish.
type BuildEvent_BuildFinished struct {
	// Final status of the build.
	Status               *BuildStatus `protobuf:"bytes,1,opt,name=status,proto3" json:"status,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *BuildEvent_BuildFinished) Reset()         { *m = BuildEvent_BuildFinished{} }
func (m *BuildEvent_BuildFinished) String() string { return proto.CompactTextString(m) }
func (*BuildEvent_BuildFinished) ProtoMessage()    {}
func (*BuildEvent_BuildFinished) Descriptor() ([]byte, []int) {
	return fileDescriptor_build_events_cc132f62a908b693, []int{0, 3}
}
func (m *BuildEvent_BuildFinished) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BuildEvent_BuildFinished.Unmarshal(m, b)
}
func (m *BuildEvent_BuildFinished) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BuildEvent_BuildFinished.Marshal(b, m, deterministic)
}
func (dst *BuildEvent_BuildFinished) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BuildEvent_BuildFinished.Merge(dst, src)
}
func (m *BuildEvent_BuildFinished) XXX_Size() int {
	return xxx_messageInfo_BuildEvent_BuildFinished.Size(m)
}
func (m *BuildEvent_BuildFinished) XXX_DiscardUnknown() {
	xxx_messageInfo_BuildEvent_BuildFinished.DiscardUnknown(m)
}

var xxx_messageInfo_BuildEvent_BuildFinished proto.InternalMessageInfo

func (m *BuildEvent_BuildFinished) GetStatus() *BuildStatus {
	if m != nil {
		return m.Status
	}
	return nil
}

// Textual output written to standard output or standard error.
type BuildEvent_ConsoleOutput struct {
	// The output stream type.
	Type ConsoleOutputStream `protobuf:"varint,1,opt,name=type,proto3,enum=google.devtools.build.v1.ConsoleOutputStream" json:"type,omitempty"`
	// The output stream content.
	//
	// Types that are valid to be assigned to Output:
	//	*BuildEvent_ConsoleOutput_TextOutput
	//	*BuildEvent_ConsoleOutput_BinaryOutput
	Output               isBuildEvent_ConsoleOutput_Output `protobuf_oneof:"output"`
	XXX_NoUnkeyedLiteral struct{}                          `json:"-"`
	XXX_unrecognized     []byte                            `json:"-"`
	XXX_sizecache        int32                             `json:"-"`
}

func (m *BuildEvent_ConsoleOutput) Reset()         { *m = BuildEvent_ConsoleOutput{} }
func (m *BuildEvent_ConsoleOutput) String() string { return proto.CompactTextString(m) }
func (*BuildEvent_ConsoleOutput) ProtoMessage()    {}
func (*BuildEvent_ConsoleOutput) Descriptor() ([]byte, []int) {
	return fileDescriptor_build_events_cc132f62a908b693, []int{0, 4}
}
func (m *BuildEvent_ConsoleOutput) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BuildEvent_ConsoleOutput.Unmarshal(m, b)
}
func (m *BuildEvent_ConsoleOutput) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BuildEvent_ConsoleOutput.Marshal(b, m, deterministic)
}
func (dst *BuildEvent_ConsoleOutput) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BuildEvent_ConsoleOutput.Merge(dst, src)
}
func (m *BuildEvent_ConsoleOutput) XXX_Size() int {
	return xxx_messageInfo_BuildEvent_ConsoleOutput.Size(m)
}
func (m *BuildEvent_ConsoleOutput) XXX_DiscardUnknown() {
	xxx_messageInfo_BuildEvent_ConsoleOutput.DiscardUnknown(m)
}

var xxx_messageInfo_BuildEvent_ConsoleOutput proto.InternalMessageInfo

type isBuildEvent_ConsoleOutput_Output interface {
	isBuildEvent_ConsoleOutput_Output()
}

type BuildEvent_ConsoleOutput_TextOutput struct {
	TextOutput string `protobuf:"bytes,2,opt,name=text_output,json=textOutput,proto3,oneof"`
}
type BuildEvent_ConsoleOutput_BinaryOutput struct {
	BinaryOutput []byte `protobuf:"bytes,3,opt,name=binary_output,json=binaryOutput,proto3,oneof"`
}

func (*BuildEvent_ConsoleOutput_TextOutput) isBuildEvent_ConsoleOutput_Output()   {}
func (*BuildEvent_ConsoleOutput_BinaryOutput) isBuildEvent_ConsoleOutput_Output() {}

func (m *BuildEvent_ConsoleOutput) GetOutput() isBuildEvent_ConsoleOutput_Output {
	if m != nil {
		return m.Output
	}
	return nil
}

func (m *BuildEvent_ConsoleOutput) GetType() ConsoleOutputStream {
	if m != nil {
		return m.Type
	}
	return ConsoleOutputStream_UNKNOWN
}

func (m *BuildEvent_ConsoleOutput) GetTextOutput() string {
	if x, ok := m.GetOutput().(*BuildEvent_ConsoleOutput_TextOutput); ok {
		return x.TextOutput
	}
	return ""
}

func (m *BuildEvent_ConsoleOutput) GetBinaryOutput() []byte {
	if x, ok := m.GetOutput().(*BuildEvent_ConsoleOutput_BinaryOutput); ok {
		return x.BinaryOutput
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*BuildEvent_ConsoleOutput) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _BuildEvent_ConsoleOutput_OneofMarshaler, _BuildEvent_ConsoleOutput_OneofUnmarshaler, _BuildEvent_ConsoleOutput_OneofSizer, []interface{}{
		(*BuildEvent_ConsoleOutput_TextOutput)(nil),
		(*BuildEvent_ConsoleOutput_BinaryOutput)(nil),
	}
}

func _BuildEvent_ConsoleOutput_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*BuildEvent_ConsoleOutput)
	// output
	switch x := m.Output.(type) {
	case *BuildEvent_ConsoleOutput_TextOutput:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.TextOutput)
	case *BuildEvent_ConsoleOutput_BinaryOutput:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.BinaryOutput)
	case nil:
	default:
		return fmt.Errorf("BuildEvent_ConsoleOutput.Output has unexpected type %T", x)
	}
	return nil
}

func _BuildEvent_ConsoleOutput_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*BuildEvent_ConsoleOutput)
	switch tag {
	case 2: // output.text_output
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Output = &BuildEvent_ConsoleOutput_TextOutput{x}
		return true, err
	case 3: // output.binary_output
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.Output = &BuildEvent_ConsoleOutput_BinaryOutput{x}
		return true, err
	default:
		return false, nil
	}
}

func _BuildEvent_ConsoleOutput_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*BuildEvent_ConsoleOutput)
	// output
	switch x := m.Output.(type) {
	case *BuildEvent_ConsoleOutput_TextOutput:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.TextOutput)))
		n += len(x.TextOutput)
	case *BuildEvent_ConsoleOutput_BinaryOutput:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.BinaryOutput)))
		n += len(x.BinaryOutput)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Notification of the end of a build event stream published by a build
// component other than CONTROLLER (See StreamId.BuildComponents).
type BuildEvent_BuildComponentStreamFinished struct {
	// How the event stream finished.
	Type                 BuildEvent_BuildComponentStreamFinished_FinishType `protobuf:"varint,1,opt,name=type,proto3,enum=google.devtools.build.v1.BuildEvent_BuildComponentStreamFinished_FinishType" json:"type,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                           `json:"-"`
	XXX_unrecognized     []byte                                             `json:"-"`
	XXX_sizecache        int32                                              `json:"-"`
}

func (m *BuildEvent_BuildComponentStreamFinished) Reset() {
	*m = BuildEvent_BuildComponentStreamFinished{}
}
func (m *BuildEvent_BuildComponentStreamFinished) String() string { return proto.CompactTextString(m) }
func (*BuildEvent_BuildComponentStreamFinished) ProtoMessage()    {}
func (*BuildEvent_BuildComponentStreamFinished) Descriptor() ([]byte, []int) {
	return fileDescriptor_build_events_cc132f62a908b693, []int{0, 5}
}
func (m *BuildEvent_BuildComponentStreamFinished) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BuildEvent_BuildComponentStreamFinished.Unmarshal(m, b)
}
func (m *BuildEvent_BuildComponentStreamFinished) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BuildEvent_BuildComponentStreamFinished.Marshal(b, m, deterministic)
}
func (dst *BuildEvent_BuildComponentStreamFinished) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BuildEvent_BuildComponentStreamFinished.Merge(dst, src)
}
func (m *BuildEvent_BuildComponentStreamFinished) XXX_Size() int {
	return xxx_messageInfo_BuildEvent_BuildComponentStreamFinished.Size(m)
}
func (m *BuildEvent_BuildComponentStreamFinished) XXX_DiscardUnknown() {
	xxx_messageInfo_BuildEvent_BuildComponentStreamFinished.DiscardUnknown(m)
}

var xxx_messageInfo_BuildEvent_BuildComponentStreamFinished proto.InternalMessageInfo

func (m *BuildEvent_BuildComponentStreamFinished) GetType() BuildEvent_BuildComponentStreamFinished_FinishType {
	if m != nil {
		return m.Type
	}
	return BuildEvent_BuildComponentStreamFinished_FINISH_TYPE_UNSPECIFIED
}

// Unique identifier for a build event stream.
type StreamId struct {
	// The id of a Build message.
	BuildId string `protobuf:"bytes,1,opt,name=build_id,json=buildId,proto3" json:"build_id,omitempty"`
	// The unique invocation ID within this build.
	// It should be the same as {invocation} (below) during the migration.
	InvocationId string `protobuf:"bytes,6,opt,name=invocation_id,json=invocationId,proto3" json:"invocation_id,omitempty"`
	// The component that emitted this event.
	Component            StreamId_BuildComponent `protobuf:"varint,3,opt,name=component,proto3,enum=google.devtools.build.v1.StreamId_BuildComponent" json:"component,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *StreamId) Reset()         { *m = StreamId{} }
func (m *StreamId) String() string { return proto.CompactTextString(m) }
func (*StreamId) ProtoMessage()    {}
func (*StreamId) Descriptor() ([]byte, []int) {
	return fileDescriptor_build_events_cc132f62a908b693, []int{1}
}
func (m *StreamId) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamId.Unmarshal(m, b)
}
func (m *StreamId) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamId.Marshal(b, m, deterministic)
}
func (dst *StreamId) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamId.Merge(dst, src)
}
func (m *StreamId) XXX_Size() int {
	return xxx_messageInfo_StreamId.Size(m)
}
func (m *StreamId) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamId.DiscardUnknown(m)
}

var xxx_messageInfo_StreamId proto.InternalMessageInfo

func (m *StreamId) GetBuildId() string {
	if m != nil {
		return m.BuildId
	}
	return ""
}

func (m *StreamId) GetInvocationId() string {
	if m != nil {
		return m.InvocationId
	}
	return ""
}

func (m *StreamId) GetComponent() StreamId_BuildComponent {
	if m != nil {
		return m.Component
	}
	return StreamId_UNKNOWN_COMPONENT
}

func init() {
	proto.RegisterType((*BuildEvent)(nil), "google.devtools.build.v1.BuildEvent")
	proto.RegisterType((*BuildEvent_InvocationAttemptStarted)(nil), "google.devtools.build.v1.BuildEvent.InvocationAttemptStarted")
	proto.RegisterType((*BuildEvent_InvocationAttemptFinished)(nil), "google.devtools.build.v1.BuildEvent.InvocationAttemptFinished")
	proto.RegisterType((*BuildEvent_BuildEnqueued)(nil), "google.devtools.build.v1.BuildEvent.BuildEnqueued")
	proto.RegisterType((*BuildEvent_BuildFinished)(nil), "google.devtools.build.v1.BuildEvent.BuildFinished")
	proto.RegisterType((*BuildEvent_ConsoleOutput)(nil), "google.devtools.build.v1.BuildEvent.ConsoleOutput")
	proto.RegisterType((*BuildEvent_BuildComponentStreamFinished)(nil), "google.devtools.build.v1.BuildEvent.BuildComponentStreamFinished")
	proto.RegisterType((*StreamId)(nil), "google.devtools.build.v1.StreamId")
	proto.RegisterEnum("google.devtools.build.v1.ConsoleOutputStream", ConsoleOutputStream_name, ConsoleOutputStream_value)
	proto.RegisterEnum("google.devtools.build.v1.BuildEvent_BuildComponentStreamFinished_FinishType", BuildEvent_BuildComponentStreamFinished_FinishType_name, BuildEvent_BuildComponentStreamFinished_FinishType_value)
	proto.RegisterEnum("google.devtools.build.v1.StreamId_BuildComponent", StreamId_BuildComponent_name, StreamId_BuildComponent_value)
}

func init() {
	proto.RegisterFile("google/devtools/build/v1/build_events.proto", fileDescriptor_build_events_cc132f62a908b693)
}

var fileDescriptor_build_events_cc132f62a908b693 = []byte{
	// 927 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x56, 0x6d, 0x6f, 0xe3, 0x44,
	0x10, 0x8e, 0xdb, 0xa3, 0x4d, 0xa7, 0x49, 0xce, 0xb7, 0xc7, 0xa9, 0x8e, 0x5b, 0xf1, 0x52, 0x54,
	0x09, 0x81, 0x70, 0xd4, 0x14, 0x74, 0x07, 0x47, 0x4f, 0xca, 0x8b, 0xab, 0x98, 0xeb, 0xd9, 0xd1,
	0x26, 0xe5, 0x78, 0xf9, 0x10, 0x1c, 0x7b, 0x9b, 0xb3, 0x94, 0x78, 0x8d, 0xbd, 0x0e, 0x0d, 0x12,
	0x82, 0x5f, 0x83, 0xc4, 0x1f, 0xe1, 0xc7, 0xf0, 0x07, 0xe0, 0x23, 0xf2, 0xee, 0xba, 0x49, 0xda,
	0xa6, 0x77, 0x85, 0x6f, 0xbb, 0x33, 0xcf, 0x3c, 0xcf, 0xcc, 0xec, 0x8c, 0x65, 0xf8, 0x78, 0x44,
	0xe9, 0x68, 0x4c, 0x6a, 0x3e, 0x99, 0x32, 0x4a, 0xc7, 0x49, 0x6d, 0x98, 0x06, 0x63, 0xbf, 0x36,
	0x3d, 0x14, 0x87, 0x01, 0x99, 0x92, 0x90, 0x25, 0x46, 0x14, 0x53, 0x46, 0x91, 0x26, 0xc0, 0x46,
	0x0e, 0x36, 0x38, 0xc6, 0x98, 0x1e, 0xea, 0x7b, 0x92, 0xc6, 0x8d, 0x82, 0x9a, 0x1b, 0x86, 0x94,
	0xb9, 0x2c, 0xa0, 0xa1, 0x8c, 0xd3, 0x5f, 0x27, 0x92, 0x30, 0x97, 0xa5, 0x39, 0xb8, 0x2a, 0xc1,
	0xfc, 0x36, 0x4c, 0xcf, 0x6b, 0x6e, 0x38, 0x93, 0xae, 0x77, 0xaf, 0xba, 0x58, 0x30, 0x21, 0x09,
	0x73, 0x27, 0x91, 0x04, 0xbc, 0x73, 0x15, 0xf0, 0x53, 0xec, 0x46, 0x11, 0x89, 0x73, 0xee, 0x1d,
	0xe9, 0x8f, 0x23, 0xaf, 0xb6, 0x28, 0xba, 0xff, 0x77, 0x09, 0xa0, 0x99, 0xe5, 0x62, 0x66, 0xf5,
	0xa2, 0xcf, 0x01, 0x78, 0xe1, 0x83, 0x4c, 0x40, 0x53, 0xde, 0x53, 0x3e, 0xdc, 0xae, 0xeb, 0x86,
	0xac, 0x3e, 0x27, 0x37, 0xfa, 0xb9, 0x3a, 0xde, 0xe2, 0xe8, 0xec, 0x8e, 0x7e, 0x01, 0x3d, 0x08,
	0xa7, 0xd4, 0xe3, 0x0d, 0x18, 0xb8, 0x8c, 0x91, 0x49, 0xc4, 0xb2, 0x0a, 0x63, 0x46, 0x7c, 0xed,
	0x88, 0x53, 0x1d, 0x1b, 0xab, 0x1a, 0x69, 0xcc, 0x93, 0x30, 0xac, 0x4b, 0x9a, 0x86, 0x60, 0xe9,
	0x09, 0x92, 0x4e, 0x01, 0x6b, 0xc1, 0x0a, 0x1f, 0xfa, 0x4d, 0x81, 0xdd, 0x1b, 0xf4, 0xcf, 0x83,
	0x30, 0x48, 0x5e, 0x11, 0x5f, 0xfb, 0x94, 0x27, 0xf0, 0xec, 0xbf, 0x25, 0x70, 0x22, 0x59, 0x3a,
	0x05, 0x5c, 0x0d, 0x56, 0x39, 0xd1, 0xf7, 0x50, 0x91, 0xb3, 0x13, 0xfe, 0x98, 0x92, 0x94, 0xf8,
	0xda, 0x67, 0x5c, 0xb4, 0xfe, 0x46, 0xa2, 0xe2, 0x28, 0x23, 0x3b, 0x05, 0x5c, 0x1e, 0x2e, 0x1a,
	0xe6, 0xe4, 0x97, 0x15, 0x3d, 0xbe, 0x2b, 0xf9, 0x42, 0x15, 0x82, 0x7c, 0x31, 0x73, 0x8f, 0x86,
	0x09, 0x1d, 0x93, 0x01, 0x4d, 0x59, 0x94, 0x32, 0xed, 0xc9, 0x1d, 0xc8, 0x5b, 0x22, 0xd4, 0xe1,
	0x91, 0x19, 0xb9, 0xb7, 0x68, 0x40, 0xbf, 0x42, 0xd5, 0xa3, 0x93, 0x88, 0x86, 0xd9, 0x5c, 0x25,
	0x2c, 0x26, 0xee, 0x64, 0x5e, 0xc4, 0x53, 0xae, 0xd3, 0x78, 0xf3, 0x22, 0x5a, 0x39, 0x55, 0x8f,
	0x33, 0x2d, 0xd4, 0xb4, 0xe3, 0xdd, 0xec, 0x42, 0x8f, 0x61, 0x7b, 0xe8, 0xfe, 0x4c, 0xc6, 0x62,
	0xa7, 0xb5, 0x2f, 0xb9, 0xe4, 0xdb, 0xd7, 0xa6, 0xba, 0x11, 0xce, 0x3a, 0x05, 0x0c, 0x1c, 0x2a,
	0xb6, 0xe1, 0x2b, 0x78, 0x24, 0x1f, 0xf4, 0x82, 0x78, 0x29, 0x9f, 0x2b, 0x41, 0x71, 0x7c, 0x2b,
	0xc5, 0x43, 0xf1, 0x72, 0x79, 0x8c, 0xe0, 0x6a, 0x03, 0x4a, 0x68, 0x1a, 0x7b, 0x64, 0x70, 0x4e,
	0x98, 0xf7, 0x4a, 0x12, 0x3d, 0xbb, 0x95, 0x48, 0x15, 0x11, 0x27, 0x59, 0x00, 0x67, 0xd1, 0x1b,
	0xa0, 0xad, 0xda, 0x0e, 0x74, 0x00, 0x95, 0x7c, 0xea, 0xc3, 0x74, 0x32, 0x24, 0x31, 0xdf, 0xdf,
	0x75, 0x5c, 0x96, 0x56, 0x9b, 0x1b, 0xf5, 0x3f, 0x14, 0xa8, 0xae, 0x1c, 0x70, 0xf4, 0x04, 0xb6,
	0xc8, 0x45, 0xc0, 0x06, 0x1e, 0xf5, 0x89, 0xb6, 0xc6, 0xb3, 0xdb, 0xbd, 0x96, 0x9d, 0x15, 0xb2,
	0xa3, 0xfa, 0xd7, 0xee, 0x38, 0x25, 0xb8, 0x98, 0xa1, 0x5b, 0xd4, 0x27, 0x08, 0xc3, 0x83, 0x85,
	0xfd, 0x13, 0x1f, 0x19, 0x6d, 0x9d, 0x33, 0x1c, 0xbc, 0xe6, 0x79, 0x7b, 0x1c, 0x8c, 0xd5, 0x79,
	0xbc, 0xb0, 0xe8, 0xf7, 0xa1, 0xbc, 0xb4, 0x16, 0xba, 0x2d, 0x0d, 0x97, 0xf9, 0x1e, 0xc3, 0x86,
	0x94, 0x52, 0xee, 0x22, 0x25, 0x83, 0xf4, 0xdf, 0x15, 0x28, 0x2f, 0x8d, 0x2f, 0x6a, 0xc0, 0x3d,
	0x36, 0x8b, 0xc4, 0xb7, 0xaf, 0x52, 0xff, 0x64, 0x35, 0xdd, 0x52, 0x98, 0x98, 0x38, 0xcc, 0x43,
	0xd1, 0xfb, 0xb0, 0xcd, 0xc8, 0x05, 0xcb, 0x57, 0x29, 0xeb, 0xe2, 0x56, 0x36, 0x59, 0x99, 0x51,
	0xaa, 0x1c, 0x40, 0x79, 0x18, 0x84, 0x6e, 0x3c, 0xcb, 0x41, 0x59, 0xa3, 0x4a, 0x9d, 0x02, 0x2e,
	0x09, 0xb3, 0x80, 0x35, 0x8b, 0xb0, 0x21, 0xfc, 0xfa, 0x9f, 0x0a, 0xec, 0xdd, 0x36, 0xff, 0xe8,
	0x87, 0xa5, 0xbc, 0x4f, 0xff, 0xf7, 0x42, 0x19, 0xe2, 0xd0, 0x9f, 0x45, 0x44, 0x94, 0xb5, 0xdf,
	0x06, 0x98, 0xdb, 0xd0, 0x2e, 0xec, 0x9c, 0x58, 0xb6, 0xd5, 0xeb, 0x0c, 0xfa, 0xdf, 0x76, 0xcd,
	0xc1, 0x99, 0xdd, 0xeb, 0x9a, 0x2d, 0xeb, 0xc4, 0x32, 0xdb, 0x6a, 0x01, 0x95, 0xa0, 0x28, 0x9c,
	0x66, 0x5b, 0x55, 0xd0, 0x36, 0x6c, 0x9a, 0xdf, 0x74, 0x2d, 0x6c, 0xb6, 0xd5, 0xb5, 0xe6, 0x26,
	0xbc, 0xc5, 0x47, 0x7f, 0xff, 0x2f, 0x05, 0x8a, 0x42, 0xd2, 0xf2, 0x51, 0x15, 0x8a, 0x62, 0xd3,
	0x02, 0x9f, 0x57, 0xb0, 0x85, 0x37, 0xf9, 0xdd, 0xf2, 0xd1, 0x07, 0x50, 0x5e, 0x98, 0xab, 0xc0,
	0xd7, 0x36, 0xb8, 0xbf, 0x34, 0x37, 0x5a, 0x3e, 0x72, 0x60, 0xeb, 0x72, 0xfb, 0x79, 0x2f, 0x2b,
	0xf5, 0xc3, 0xd5, 0x2d, 0xc8, 0x65, 0xaf, 0x34, 0x00, 0xcf, 0x39, 0xf6, 0x5f, 0x40, 0x65, 0xd9,
	0x89, 0x1e, 0xc1, 0x83, 0x33, 0xfb, 0xb9, 0xed, 0xbc, 0xb4, 0x07, 0x2d, 0xe7, 0x45, 0xd7, 0xb1,
	0x4d, 0xbb, 0xaf, 0x16, 0x50, 0x05, 0xa0, 0xe5, 0xd8, 0x7d, 0xec, 0x9c, 0x9e, 0x9a, 0x58, 0x55,
	0x10, 0xc0, 0xc6, 0x4b, 0x07, 0x3f, 0x37, 0xb1, 0xba, 0x86, 0x8a, 0x70, 0xaf, 0xef, 0x38, 0xa7,
	0xea, 0xfa, 0x47, 0x5f, 0xc0, 0xc3, 0x1b, 0xe6, 0x25, 0xeb, 0x8c, 0xe4, 0x54, 0x0b, 0x59, 0x64,
	0xaf, 0xdf, 0x76, 0xce, 0xfa, 0x82, 0xa5, 0xd7, 0x6f, 0x9b, 0x18, 0xab, 0x6b, 0xcd, 0x04, 0xf6,
	0x3c, 0x3a, 0x59, 0x59, 0x4d, 0xf3, 0xfe, 0xfc, 0x45, 0xbb, 0xd9, 0x86, 0x76, 0x95, 0xef, 0x8e,
	0x25, 0x78, 0x44, 0xc7, 0x6e, 0x38, 0x32, 0x68, 0x3c, 0xaa, 0x8d, 0x48, 0xc8, 0xf7, 0xb7, 0x26,
	0x5c, 0x6e, 0x14, 0x24, 0xd7, 0x7f, 0x4b, 0x9e, 0xf2, 0xc3, 0x3f, 0x8a, 0x32, 0xdc, 0xe0, 0xe0,
	0xa3, 0x7f, 0x03, 0x00, 0x00, 0xff, 0xff, 0x84, 0x0f, 0x0f, 0xdf, 0x27, 0x09, 0x00, 0x00,
}
