# `gig` -- .gitignore generator

[![](https://github.com/shihanng/gig/workflows/main/badge.svg?branch=develop)](https://github.com/shihanng/gig/actions?query=workflow%3Amain)
[![](https://github.com/shihanng/gig/workflows/release/badge.svg?branch=develop)](https://github.com/shihanng/gig/actions?query=workflow%3Arelease)
[![GitHub](https://img.shields.io/github/license/shihanng/gig)](https://github.com/shihanng/gig/blob/develop/LICENSE)
[![GitHub release (latest by date)](https://img.shields.io/github/v/release/shihanng/gig)](https://github.com/shihanng/gig/releases)
[![Go Report Card](https://goreportcard.com/badge/github.com/shihanng/gig)](https://goreportcard.com/report/github.com/shihanng/gig)
[![Coverage Status](https://coveralls.io/repos/github/shihanng/gig/badge.svg?branch=develop)](https://coveralls.io/github/shihanng/gig?branch=develop)

`gig` is a command line tool to help you create useful `.gitignore` files for your project.
It is inspired by [gitignore.io](https://www.gitignore.io/) and make use of
the large collection of useful [`.gitignore` templates](https://github.com/toptal/gitignore) of the web service.
This also means that `gig` supports the are four file types that gitignore.io recognizes.
Content generated by `gig` should match the one generated by [gitignore.io](https://www.gitignore.io/) except the
order of stacks in which [gitignore.io](https://www.gitignore.io/) does not seem to guarantee any.

## Motivation

Prior to this project, I used to have one of [these command lines](https://docs.gitignore.io/install/command-line) in my `.zshrc`.
However, problems I have with this command line are that
- I won't be able to use it without internet access
- It seems [gitignore.io](https://www.gitignore.io/) that is not using the latest templates in https://github.com/toptal/gitignore. The project needs to update to the latest git submodule then deploy it.

Therefore this tool is created to solve the two main problems above.

# Install

## [Homebrew (macOS)](https://github.com/shihanng/homebrew-gig)

```
brew install shihanng/gig/gig
```

## Binaries

The [release page contains](https://github.com/shihanng/gig/releases) binaries built
for various platforms. Download then extract the binary with `tar -xf`.
Place the binary in the `$PATH` e.g. `/usr/local/bin`.

## With `go get`

```
go get github.com/shihanng/gig
```

# Usage

There are several ways you can generate the `.gitignore` file:

### Using the supported language as input arguments

```
$ gig gen Go Elm

### Elm ###
# elm-package generated files
elm-stuff
# elm-repl generated files
repl-temp-*

### Go ###
# Binaries for programs and plugins
...
```

At the very first run the program will clone the templates repository <https://github.com/toptal/gitignore.git>
into `$XDG_CACHE_HOME/gig`.
This means that internet connection is not required after the first successful run.

### Using the search functionality (depends on [fzf](https://github.com/junegunn/fzf))

```
$ gig search
```

![gig search demo](./.github/images/search.gif)

### Using the EXPERIMENTAL auto generate functionality

```
$ gig autogen
```

### For more information, see

```
gig --help
```

# Development

Found a bug or want to hack around? Clone the repository:

```
git clone git@github.com:shihanng/gig.git
```

When you are ready run the tests:

```
make test
make integ-test
make lint
```

Where `test` run the tests that can be run locally.
`integ-test` run the tests that require internet access.
`lint` help you write better Go codes.

Add subcommand with [cobra](https://github.com/spf13/cobra)
(version managed in [tools.go](./tools.go) with [go.mod](./go.mod)):

```
$ cobra --config .cobra.yaml add <new subcommand>
```

Update golden file:

```
$ go test . -tags=integration -update
```
