# bash completion for ggc
# Code generated by go run tools/cmd/gencompletions/main.go; DO NOT EDIT.

_ggc()
{
    local cur prev opts subopts
    COMPREPLY=()
    cur="${COMP_WORDS[COMP_CWORD]}"
    prev="${COMP_WORDS[COMP_CWORD-1]}"

    opts="add branch clean commit config diff fetch help hook log pull push quit rebase remote restore stash status tag version"
    case ${prev} in
        branch)
            subopts="checkout contains create current delete info list move rename set sort"
            COMPREPLY=( $(compgen -W "${subopts}" -- ${cur}) )
            return 0
            ;;
        clean)
            subopts="dirs files interactive"
            COMPREPLY=( $(compgen -W "${subopts}" -- ${cur}) )
            return 0
            ;;
        commit)
            subopts="allow amend"
            COMPREPLY=( $(compgen -W "${subopts}" -- ${cur}) )
            return 0
            ;;
        config)
            subopts="get list set"
            COMPREPLY=( $(compgen -W "${subopts}" -- ${cur}) )
            return 0
            ;;
        diff)
            subopts="head staged unstaged"
            COMPREPLY=( $(compgen -W "${subopts}" -- ${cur}) )
            return 0
            ;;
        fetch)
            subopts="prune"
            COMPREPLY=( $(compgen -W "${subopts}" -- ${cur}) )
            return 0
            ;;
        hook)
            subopts="disable edit enable install list uninstall"
            COMPREPLY=( $(compgen -W "${subopts}" -- ${cur}) )
            return 0
            ;;
        log)
            subopts="graph simple"
            COMPREPLY=( $(compgen -W "${subopts}" -- ${cur}) )
            return 0
            ;;
        pull)
            subopts="current rebase"
            COMPREPLY=( $(compgen -W "${subopts}" -- ${cur}) )
            return 0
            ;;
        push)
            subopts="current force"
            COMPREPLY=( $(compgen -W "${subopts}" -- ${cur}) )
            return 0
            ;;
        rebase)
            subopts="abort continue interactive skip"
            COMPREPLY=( $(compgen -W "${subopts}" -- ${cur}) )
            return 0
            ;;
        remote)
            subopts="add list remove set-url"
            COMPREPLY=( $(compgen -W "${subopts}" -- ${cur}) )
            return 0
            ;;
        restore)
            subopts="staged"
            COMPREPLY=( $(compgen -W "${subopts}" -- ${cur}) )
            return 0
            ;;
        stash)
            subopts="apply branch clear create drop list pop push save show store"
            COMPREPLY=( $(compgen -W "${subopts}" -- ${cur}) )
            return 0
            ;;
        status)
            subopts="short"
            COMPREPLY=( $(compgen -W "${subopts}" -- ${cur}) )
            return 0
            ;;
        tag)
            subopts="annotated create delete list push show"
            COMPREPLY=( $(compgen -W "${subopts}" -- ${cur}) )
            return 0
            ;;
    esac

    if [[ ${COMP_CWORD} == 1 ]]; then
        COMPREPLY=( $(compgen -W "${opts}" -- ${cur}) )
        return 0
    fi
    if [[ ${COMP_WORDS[1]} == "branch" && ${COMP_WORDS[2]} == "delete" ]]; then
        COMPREPLY=( $(compgen -W "merged" -- ${cur}) )
        return 0
    fi
    if [[ ${COMP_WORDS[1]} == "branch" && ${COMP_WORDS[2]} == "list" ]]; then
        COMPREPLY=( $(compgen -W "local remote verbose" -- ${cur}) )
        return 0
    fi
    if [[ ${COMP_WORDS[1]} == "branch" && ${COMP_WORDS[2]} == "set" ]]; then
        COMPREPLY=( $(compgen -W "upstream" -- ${cur}) )
        return 0
    fi
    if [[ ${COMP_WORDS[1]} == "commit" && ${COMP_WORDS[2]} == "allow" ]]; then
        COMPREPLY=( $(compgen -W "empty" -- ${cur}) )
        return 0
    fi
    if [[ ${COMP_WORDS[1]} == "commit" && ${COMP_WORDS[2]} == "amend" ]]; then
        COMPREPLY=( $(compgen -W "no-edit" -- ${cur}) )
        return 0
    fi
    if [[ ${COMP_WORDS[1]} == "stash" && ${COMP_WORDS[2]} == "push" ]]; then
        COMPREPLY=( $(compgen -W "-m" -- ${cur}) )
        return 0
    fi

    if [[ ${COMP_WORDS[1]} == "branch" && ${COMP_WORDS[2]} == "checkout" ]]; then
        local branches candidates
        branches=$(ggc __complete branch 2>/dev/null)
        candidates="${branches} remote"
        COMPREPLY=( $(compgen -W "${candidates}" -- ${cur}) )
        return 0
    fi

    if [[ ${COMP_WORDS[1]} == "add" ]]; then
        local files candidates extras
        extras="interactive patch"
        candidates="${extras}"
        files=$(ggc __complete files 2>/dev/null)
        if [[ -n ${files} ]]; then
            candidates="${candidates} ${files}"
        fi
        COMPREPLY=( $(compgen -W "${candidates}" -- ${cur}) )
        return 0
    fi

    if [[ ${COMP_WORDS[1]} == "rebase" && ${COMP_CWORD} -eq 2 ]]; then
        case ${cur} in
            continue|abort|skip|interactive)
                ;;
            *)
                local branches
                branches=$(ggc __complete branch 2>/dev/null)
                COMPREPLY=( $(compgen -W "${branches}" -- ${cur}) )
                return 0
                ;;
        esac
    fi
}

complete -F _ggc ggc
