// SPDX-License-Identifier: Unlicense OR BSD-3-Clause

package unicodedata

import (
	"unicode"

	"github.com/go-text/typesetting/language"
)

// Code generated by typesettings-utils/generators/unicodedata/cmd/main.go DO NOT EDIT.

// ScriptVerticalOrientation provides the glyph oriention
// to use for vertical text.
type ScriptVerticalOrientation struct {
	exceptions *unicode.RangeTable
	script language.Script
	isMainSideways bool
}
	
// uprightOrMixedScripts is the list of scripts
// which may use both mode ("upright" or "sideways") for vertical text orientation 
var uprightOrMixedScripts = [...]ScriptVerticalOrientation{
	{nil, language.Anatolian_Hieroglyphs, false},
	{nil, language.Bopomofo, false},
	{
		&unicode.RangeTable{
			R16: []unicode.Range16{
				{Lo: 0x1400, Hi: 0x1400, Stride: 1},
			},
		}, language.Canadian_Aboriginal, false,
	},
	{nil, language.Egyptian_Hieroglyphs, false},
	{nil, language.Han, false},
	{
		&unicode.RangeTable{
			R16: []unicode.Range16{
				{Lo: 0xffa0, Hi: 0xffbe, Stride: 1},
				{Lo: 0xffc2, Hi: 0xffc7, Stride: 1},
				{Lo: 0xffca, Hi: 0xffcf, Stride: 1},
				{Lo: 0xffd2, Hi: 0xffd7, Stride: 1},
				{Lo: 0xffda, Hi: 0xffdc, Stride: 1},
			},
		}, language.Hangul, false,
	},
	{nil, language.Hiragana, false},
	{
		&unicode.RangeTable{
			R16: []unicode.Range16{
				{Lo: 0xff66, Hi: 0xff6f, Stride: 1},
				{Lo: 0xff71, Hi: 0xff9d, Stride: 1},
			},
		}, language.Katakana, false,
	},
	{nil, language.Khitan_Small_Script, false},
	{
		&unicode.RangeTable{
			R16: []unicode.Range16{
				{Lo: 0x2160, Hi: 0x2188, Stride: 1},
				{Lo: 0xff21, Hi: 0xff3a, Stride: 1},
				{Lo: 0xff41, Hi: 0xff5a, Stride: 1},
			},
		}, language.Latin, true,
	},
	{nil, language.Meroitic_Hieroglyphs, false},
	{nil, language.Nushu, false},
	{nil, language.Siddham, false},
	{nil, language.SignWriting, false},
	{nil, language.Soyombo, false},
	{nil, language.Tangut, false},
	{nil, language.Yi, false},
	{nil, language.Zanabazar_Square, false},
}
