// SPDX-License-Identifier: Unlicense OR BSD-3-Clause

package language

// Code generated by typesettings-utils/generators/unicodedata/cmd/main.go DO NOT EDIT.

const (
	Adlam                        = Script(0x41646c6d) // Adlm
	Afaka                        = Script(0x4166616b) // Afak
	Ahom                         = Script(0x41686f6d) // Ahom
	Anatolian_Hieroglyphs        = Script(0x486c7577) // Hluw
	Arabic                       = Script(0x41726162) // Arab
	Armenian                     = Script(0x41726d6e) // Armn
	Avestan                      = Script(0x41767374) // Avst
	Balinese                     = Script(0x42616c69) // Bali
	Bamum                        = Script(0x42616d75) // Bamu
	Bassa_Vah                    = Script(0x42617373) // Bass
	Batak                        = Script(0x4261746b) // Batk
	Bengali                      = Script(0x42656e67) // Beng
	Bhaiksuki                    = Script(0x42686b73) // Bhks
	Blissymbols                  = Script(0x426c6973) // Blis
	Book_Pahlavi                 = Script(0x50686c76) // Phlv
	Bopomofo                     = Script(0x426f706f) // Bopo
	Brahmi                       = Script(0x42726168) // Brah
	Braille                      = Script(0x42726169) // Brai
	Buginese                     = Script(0x42756769) // Bugi
	Buhid                        = Script(0x42756864) // Buhd
	Canadian_Aboriginal          = Script(0x43616e73) // Cans
	Carian                       = Script(0x43617269) // Cari
	Caucasian_Albanian           = Script(0x41676862) // Aghb
	Chakma                       = Script(0x43616b6d) // Cakm
	Cham                         = Script(0x4368616d) // Cham
	Cherokee                     = Script(0x43686572) // Cher
	Chorasmian                   = Script(0x43687273) // Chrs
	Cirth                        = Script(0x43697274) // Cirt
	Code_for_unwritten_documents = Script(0x5a787878) // Zxxx
	Common                       = Script(0x5a797979) // Zyyy
	Coptic                       = Script(0x436f7074) // Copt
	Cuneiform                    = Script(0x58737578) // Xsux
	Cypriot                      = Script(0x43707274) // Cprt
	Cypro_Minoan                 = Script(0x43706d6e) // Cpmn
	Cyrillic                     = Script(0x4379726c) // Cyrl
	Deseret                      = Script(0x44737274) // Dsrt
	Devanagari                   = Script(0x44657661) // Deva
	Dives_Akuru                  = Script(0x4469616b) // Diak
	Dogra                        = Script(0x446f6772) // Dogr
	Duployan                     = Script(0x4475706c) // Dupl
	Egyptian_Hieroglyphs         = Script(0x45677970) // Egyp
	Egyptian_demotic             = Script(0x45677964) // Egyd
	Egyptian_hieratic            = Script(0x45677968) // Egyh
	Elbasan                      = Script(0x456c6261) // Elba
	Elymaic                      = Script(0x456c796d) // Elym
	Ethiopic                     = Script(0x45746869) // Ethi
	Georgian                     = Script(0x47656f72) // Geor
	Glagolitic                   = Script(0x476c6167) // Glag
	Gothic                       = Script(0x476f7468) // Goth
	Grantha                      = Script(0x4772616e) // Gran
	Greek                        = Script(0x4772656b) // Grek
	Gujarati                     = Script(0x47756a72) // Gujr
	Gunjala_Gondi                = Script(0x476f6e67) // Gong
	Gurmukhi                     = Script(0x47757275) // Guru
	Han                          = Script(0x48616e69) // Hani
	Hangul                       = Script(0x48616e67) // Hang
	Hanifi_Rohingya              = Script(0x526f6867) // Rohg
	Hanunoo                      = Script(0x48616e6f) // Hano
	Hatran                       = Script(0x48617472) // Hatr
	Hebrew                       = Script(0x48656272) // Hebr
	Hiragana                     = Script(0x48697261) // Hira
	Imperial_Aramaic             = Script(0x41726d69) // Armi
	Inherited                    = Script(0x5a696e68) // Zinh
	Inscriptional_Pahlavi        = Script(0x50686c69) // Phli
	Inscriptional_Parthian       = Script(0x50727469) // Prti
	Javanese                     = Script(0x4a617661) // Java
	Jurchen                      = Script(0x4a757263) // Jurc
	Kaithi                       = Script(0x4b746869) // Kthi
	Kannada                      = Script(0x4b6e6461) // Knda
	Katakana                     = Script(0x4b616e61) // Kana
	Katakana_Or_Hiragana         = Script(0x48726b74) // Hrkt
	Kawi                         = Script(0x4b617769) // Kawi
	Kayah_Li                     = Script(0x4b616c69) // Kali
	Kharoshthi                   = Script(0x4b686172) // Khar
	Khitan_Small_Script          = Script(0x4b697473) // Kits
	Khitan_large_script          = Script(0x4b69746c) // Kitl
	Khmer                        = Script(0x4b686d72) // Khmr
	Khojki                       = Script(0x4b686f6a) // Khoj
	Khudawadi                    = Script(0x53696e64) // Sind
	Kpelle                       = Script(0x4b70656c) // Kpel
	Lao                          = Script(0x4c616f6f) // Laoo
	Latin                        = Script(0x4c61746e) // Latn
	Leke                         = Script(0x4c656b65) // Leke
	Lepcha                       = Script(0x4c657063) // Lepc
	Limbu                        = Script(0x4c696d62) // Limb
	Linear_A                     = Script(0x4c696e61) // Lina
	Linear_B                     = Script(0x4c696e62) // Linb
	Lisu                         = Script(0x4c697375) // Lisu
	Loma                         = Script(0x4c6f6d61) // Loma
	Lycian                       = Script(0x4c796369) // Lyci
	Lydian                       = Script(0x4c796469) // Lydi
	Mahajani                     = Script(0x4d61686a) // Mahj
	Makasar                      = Script(0x4d616b61) // Maka
	Malayalam                    = Script(0x4d6c796d) // Mlym
	Mandaic                      = Script(0x4d616e64) // Mand
	Manichaean                   = Script(0x4d616e69) // Mani
	Marchen                      = Script(0x4d617263) // Marc
	Masaram_Gondi                = Script(0x476f6e6d) // Gonm
	Mathematical_notation        = Script(0x5a6d7468) // Zmth
	Mayan_hieroglyphs            = Script(0x4d617961) // Maya
	Medefaidrin                  = Script(0x4d656466) // Medf
	Meetei_Mayek                 = Script(0x4d746569) // Mtei
	Mende_Kikakui                = Script(0x4d656e64) // Mend
	Meroitic_Cursive             = Script(0x4d657263) // Merc
	Meroitic_Hieroglyphs         = Script(0x4d65726f) // Mero
	Miao                         = Script(0x506c7264) // Plrd
	Modi                         = Script(0x4d6f6469) // Modi
	Mongolian                    = Script(0x4d6f6e67) // Mong
	Mro                          = Script(0x4d726f6f) // Mroo
	Multani                      = Script(0x4d756c74) // Mult
	Myanmar                      = Script(0x4d796d72) // Mymr
	Nabataean                    = Script(0x4e626174) // Nbat
	Nag_Mundari                  = Script(0x4e61676d) // Nagm
	Nandinagari                  = Script(0x4e616e64) // Nand
	New_Tai_Lue                  = Script(0x54616c75) // Talu
	Newa                         = Script(0x4e657761) // Newa
	Nko                          = Script(0x4e6b6f6f) // Nkoo
	Nushu                        = Script(0x4e736875) // Nshu
	Nyiakeng_Puachue_Hmong       = Script(0x486d6e70) // Hmnp
	Ogham                        = Script(0x4f67616d) // Ogam
	Ol_Chiki                     = Script(0x4f6c636b) // Olck
	Old_Hungarian                = Script(0x48756e67) // Hung
	Old_Italic                   = Script(0x4974616c) // Ital
	Old_North_Arabian            = Script(0x4e617262) // Narb
	Old_Permic                   = Script(0x5065726d) // Perm
	Old_Persian                  = Script(0x5870656f) // Xpeo
	Old_Sogdian                  = Script(0x536f676f) // Sogo
	Old_South_Arabian            = Script(0x53617262) // Sarb
	Old_Turkic                   = Script(0x4f726b68) // Orkh
	Old_Uyghur                   = Script(0x4f756772) // Ougr
	Oriya                        = Script(0x4f727961) // Orya
	Osage                        = Script(0x4f736765) // Osge
	Osmanya                      = Script(0x4f736d61) // Osma
	Pahawh_Hmong                 = Script(0x486d6e67) // Hmng
	Palmyrene                    = Script(0x50616c6d) // Palm
	Pau_Cin_Hau                  = Script(0x50617563) // Pauc
	Phags_Pa                     = Script(0x50686167) // Phag
	Phoenician                   = Script(0x50686e78) // Phnx
	Psalter_Pahlavi              = Script(0x50686c70) // Phlp
	Ranjana                      = Script(0x52616e6a) // Ranj
	Rejang                       = Script(0x526a6e67) // Rjng
	Rongorongo                   = Script(0x526f726f) // Roro
	Runic                        = Script(0x52756e72) // Runr
	Samaritan                    = Script(0x53616d72) // Samr
	Sarati                       = Script(0x53617261) // Sara
	Saurashtra                   = Script(0x53617572) // Saur
	Sharada                      = Script(0x53687264) // Shrd
	Shavian                      = Script(0x53686177) // Shaw
	Shuishu                      = Script(0x53687569) // Shui
	Siddham                      = Script(0x53696464) // Sidd
	SignWriting                  = Script(0x53676e77) // Sgnw
	Sinhala                      = Script(0x53696e68) // Sinh
	Sogdian                      = Script(0x536f6764) // Sogd
	Sora_Sompeng                 = Script(0x536f7261) // Sora
	Soyombo                      = Script(0x536f796f) // Soyo
	Sundanese                    = Script(0x53756e64) // Sund
	Sunuwar                      = Script(0x53756e75) // Sunu
	Syloti_Nagri                 = Script(0x53796c6f) // Sylo
	Symbols                      = Script(0x5a73796d) // Zsym
	Syriac                       = Script(0x53797263) // Syrc
	Tagalog                      = Script(0x54676c67) // Tglg
	Tagbanwa                     = Script(0x54616762) // Tagb
	Tai_Le                       = Script(0x54616c65) // Tale
	Tai_Tham                     = Script(0x4c616e61) // Lana
	Tai_Viet                     = Script(0x54617674) // Tavt
	Takri                        = Script(0x54616b72) // Takr
	Tamil                        = Script(0x54616d6c) // Taml
	Tangsa                       = Script(0x546e7361) // Tnsa
	Tangut                       = Script(0x54616e67) // Tang
	Telugu                       = Script(0x54656c75) // Telu
	Tengwar                      = Script(0x54656e67) // Teng
	Thaana                       = Script(0x54686161) // Thaa
	Thai                         = Script(0x54686169) // Thai
	Tibetan                      = Script(0x54696274) // Tibt
	Tifinagh                     = Script(0x54666e67) // Tfng
	Tirhuta                      = Script(0x54697268) // Tirh
	Toto                         = Script(0x546f746f) // Toto
	Ugaritic                     = Script(0x55676172) // Ugar
	Unknown                      = Script(0x5a7a7a7a) // Zzzz
	Vai                          = Script(0x56616969) // Vaii
	Visible_Speech               = Script(0x56697370) // Visp
	Vithkuqi                     = Script(0x56697468) // Vith
	Wancho                       = Script(0x5763686f) // Wcho
	Warang_Citi                  = Script(0x57617261) // Wara
	Woleai                       = Script(0x576f6c65) // Wole
	Yezidi                       = Script(0x59657a69) // Yezi
	Yi                           = Script(0x59696969) // Yiii
	Zanabazar_Square             = Script(0x5a616e62) // Zanb
)

// scriptToTag is only used in tests and will be
// removed by the linker
var scriptToTag = map[string]Script{
	"Adlam":                        0x41646c6d,
	"Afaka":                        0x4166616b,
	"Ahom":                         0x41686f6d,
	"Anatolian_Hieroglyphs":        0x486c7577,
	"Arabic":                       0x41726162,
	"Armenian":                     0x41726d6e,
	"Avestan":                      0x41767374,
	"Balinese":                     0x42616c69,
	"Bamum":                        0x42616d75,
	"Bassa_Vah":                    0x42617373,
	"Batak":                        0x4261746b,
	"Bengali":                      0x42656e67,
	"Bhaiksuki":                    0x42686b73,
	"Blissymbols":                  0x426c6973,
	"Book_Pahlavi":                 0x50686c76,
	"Bopomofo":                     0x426f706f,
	"Brahmi":                       0x42726168,
	"Braille":                      0x42726169,
	"Buginese":                     0x42756769,
	"Buhid":                        0x42756864,
	"Canadian_Aboriginal":          0x43616e73,
	"Carian":                       0x43617269,
	"Caucasian_Albanian":           0x41676862,
	"Chakma":                       0x43616b6d,
	"Cham":                         0x4368616d,
	"Cherokee":                     0x43686572,
	"Chorasmian":                   0x43687273,
	"Cirth":                        0x43697274,
	"Code_for_unwritten_documents": 0x5a787878,
	"Common":                       0x5a797979,
	"Coptic":                       0x436f7074,
	"Cuneiform":                    0x58737578,
	"Cypriot":                      0x43707274,
	"Cypro_Minoan":                 0x43706d6e,
	"Cyrillic":                     0x4379726c,
	"Deseret":                      0x44737274,
	"Devanagari":                   0x44657661,
	"Dives_Akuru":                  0x4469616b,
	"Dogra":                        0x446f6772,
	"Duployan":                     0x4475706c,
	"Egyptian_Hieroglyphs":         0x45677970,
	"Egyptian_demotic":             0x45677964,
	"Egyptian_hieratic":            0x45677968,
	"Elbasan":                      0x456c6261,
	"Elymaic":                      0x456c796d,
	"Ethiopic":                     0x45746869,
	"Georgian":                     0x47656f72,
	"Glagolitic":                   0x476c6167,
	"Gothic":                       0x476f7468,
	"Grantha":                      0x4772616e,
	"Greek":                        0x4772656b,
	"Gujarati":                     0x47756a72,
	"Gunjala_Gondi":                0x476f6e67,
	"Gurmukhi":                     0x47757275,
	"Han":                          0x48616e69,
	"Hangul":                       0x48616e67,
	"Hanifi_Rohingya":              0x526f6867,
	"Hanunoo":                      0x48616e6f,
	"Hatran":                       0x48617472,
	"Hebrew":                       0x48656272,
	"Hiragana":                     0x48697261,
	"Imperial_Aramaic":             0x41726d69,
	"Inherited":                    0x5a696e68,
	"Inscriptional_Pahlavi":        0x50686c69,
	"Inscriptional_Parthian":       0x50727469,
	"Javanese":                     0x4a617661,
	"Jurchen":                      0x4a757263,
	"Kaithi":                       0x4b746869,
	"Kannada":                      0x4b6e6461,
	"Katakana":                     0x4b616e61,
	"Katakana_Or_Hiragana":         0x48726b74,
	"Kawi":                         0x4b617769,
	"Kayah_Li":                     0x4b616c69,
	"Kharoshthi":                   0x4b686172,
	"Khitan_Small_Script":          0x4b697473,
	"Khitan_large_script":          0x4b69746c,
	"Khmer":                        0x4b686d72,
	"Khojki":                       0x4b686f6a,
	"Khudawadi":                    0x53696e64,
	"Kpelle":                       0x4b70656c,
	"Lao":                          0x4c616f6f,
	"Latin":                        0x4c61746e,
	"Leke":                         0x4c656b65,
	"Lepcha":                       0x4c657063,
	"Limbu":                        0x4c696d62,
	"Linear_A":                     0x4c696e61,
	"Linear_B":                     0x4c696e62,
	"Lisu":                         0x4c697375,
	"Loma":                         0x4c6f6d61,
	"Lycian":                       0x4c796369,
	"Lydian":                       0x4c796469,
	"Mahajani":                     0x4d61686a,
	"Makasar":                      0x4d616b61,
	"Malayalam":                    0x4d6c796d,
	"Mandaic":                      0x4d616e64,
	"Manichaean":                   0x4d616e69,
	"Marchen":                      0x4d617263,
	"Masaram_Gondi":                0x476f6e6d,
	"Mathematical_notation":        0x5a6d7468,
	"Mayan_hieroglyphs":            0x4d617961,
	"Medefaidrin":                  0x4d656466,
	"Meetei_Mayek":                 0x4d746569,
	"Mende_Kikakui":                0x4d656e64,
	"Meroitic_Cursive":             0x4d657263,
	"Meroitic_Hieroglyphs":         0x4d65726f,
	"Miao":                         0x506c7264,
	"Modi":                         0x4d6f6469,
	"Mongolian":                    0x4d6f6e67,
	"Mro":                          0x4d726f6f,
	"Multani":                      0x4d756c74,
	"Myanmar":                      0x4d796d72,
	"Nabataean":                    0x4e626174,
	"Nag_Mundari":                  0x4e61676d,
	"Nandinagari":                  0x4e616e64,
	"New_Tai_Lue":                  0x54616c75,
	"Newa":                         0x4e657761,
	"Nko":                          0x4e6b6f6f,
	"Nushu":                        0x4e736875,
	"Nyiakeng_Puachue_Hmong":       0x486d6e70,
	"Ogham":                        0x4f67616d,
	"Ol_Chiki":                     0x4f6c636b,
	"Old_Hungarian":                0x48756e67,
	"Old_Italic":                   0x4974616c,
	"Old_North_Arabian":            0x4e617262,
	"Old_Permic":                   0x5065726d,
	"Old_Persian":                  0x5870656f,
	"Old_Sogdian":                  0x536f676f,
	"Old_South_Arabian":            0x53617262,
	"Old_Turkic":                   0x4f726b68,
	"Old_Uyghur":                   0x4f756772,
	"Oriya":                        0x4f727961,
	"Osage":                        0x4f736765,
	"Osmanya":                      0x4f736d61,
	"Pahawh_Hmong":                 0x486d6e67,
	"Palmyrene":                    0x50616c6d,
	"Pau_Cin_Hau":                  0x50617563,
	"Phags_Pa":                     0x50686167,
	"Phoenician":                   0x50686e78,
	"Psalter_Pahlavi":              0x50686c70,
	"Ranjana":                      0x52616e6a,
	"Rejang":                       0x526a6e67,
	"Rongorongo":                   0x526f726f,
	"Runic":                        0x52756e72,
	"Samaritan":                    0x53616d72,
	"Sarati":                       0x53617261,
	"Saurashtra":                   0x53617572,
	"Sharada":                      0x53687264,
	"Shavian":                      0x53686177,
	"Shuishu":                      0x53687569,
	"Siddham":                      0x53696464,
	"SignWriting":                  0x53676e77,
	"Sinhala":                      0x53696e68,
	"Sogdian":                      0x536f6764,
	"Sora_Sompeng":                 0x536f7261,
	"Soyombo":                      0x536f796f,
	"Sundanese":                    0x53756e64,
	"Sunuwar":                      0x53756e75,
	"Syloti_Nagri":                 0x53796c6f,
	"Symbols":                      0x5a73796d,
	"Syriac":                       0x53797263,
	"Tagalog":                      0x54676c67,
	"Tagbanwa":                     0x54616762,
	"Tai_Le":                       0x54616c65,
	"Tai_Tham":                     0x4c616e61,
	"Tai_Viet":                     0x54617674,
	"Takri":                        0x54616b72,
	"Tamil":                        0x54616d6c,
	"Tangsa":                       0x546e7361,
	"Tangut":                       0x54616e67,
	"Telugu":                       0x54656c75,
	"Tengwar":                      0x54656e67,
	"Thaana":                       0x54686161,
	"Thai":                         0x54686169,
	"Tibetan":                      0x54696274,
	"Tifinagh":                     0x54666e67,
	"Tirhuta":                      0x54697268,
	"Toto":                         0x546f746f,
	"Ugaritic":                     0x55676172,
	"Unknown":                      0x5a7a7a7a,
	"Vai":                          0x56616969,
	"Visible_Speech":               0x56697370,
	"Vithkuqi":                     0x56697468,
	"Wancho":                       0x5763686f,
	"Warang_Citi":                  0x57617261,
	"Woleai":                       0x576f6c65,
	"Yezidi":                       0x59657a69,
	"Yi":                           0x59696969,
	"Zanabazar_Square":             0x5a616e62,
}

// ScriptRange is an inclusive range of runes
// with constant script.
type ScriptRange struct {
	Start, End rune
	Script     Script
}

// ScriptRanges is a sorted list of script ranges.
var ScriptRanges = [...]ScriptRange{
	{0x0, 0x40, 0x5a797979},
	{0x41, 0x5a, 0x4c61746e},
	{0x5b, 0x60, 0x5a797979},
	{0x61, 0x7a, 0x4c61746e},
	{0x7b, 0xa9, 0x5a797979},
	{0xaa, 0xaa, 0x4c61746e},
	{0xab, 0xb9, 0x5a797979},
	{0xba, 0xba, 0x4c61746e},
	{0xbb, 0xbf, 0x5a797979},
	{0xc0, 0xd6, 0x4c61746e},
	{0xd7, 0xd7, 0x5a797979},
	{0xd8, 0xf6, 0x4c61746e},
	{0xf7, 0xf7, 0x5a797979},
	{0xf8, 0x2b8, 0x4c61746e},
	{0x2b9, 0x2df, 0x5a797979},
	{0x2e0, 0x2e4, 0x4c61746e},
	{0x2e5, 0x2e9, 0x5a797979},
	{0x2ea, 0x2eb, 0x426f706f},
	{0x2ec, 0x2ff, 0x5a797979},
	{0x300, 0x36f, 0x5a696e68},
	{0x370, 0x373, 0x4772656b},
	{0x374, 0x374, 0x5a797979},
	{0x375, 0x377, 0x4772656b},
	{0x37a, 0x37d, 0x4772656b},
	{0x37e, 0x37e, 0x5a797979},
	{0x37f, 0x37f, 0x4772656b},
	{0x384, 0x384, 0x4772656b},
	{0x385, 0x385, 0x5a797979},
	{0x386, 0x386, 0x4772656b},
	{0x387, 0x387, 0x5a797979},
	{0x388, 0x38a, 0x4772656b},
	{0x38c, 0x38c, 0x4772656b},
	{0x38e, 0x3a1, 0x4772656b},
	{0x3a3, 0x3e1, 0x4772656b},
	{0x3e2, 0x3ef, 0x436f7074},
	{0x3f0, 0x3ff, 0x4772656b},
	{0x400, 0x484, 0x4379726c},
	{0x485, 0x486, 0x5a696e68},
	{0x487, 0x52f, 0x4379726c},
	{0x531, 0x556, 0x41726d6e},
	{0x559, 0x58a, 0x41726d6e},
	{0x58d, 0x58f, 0x41726d6e},
	{0x591, 0x5c7, 0x48656272},
	{0x5d0, 0x5ea, 0x48656272},
	{0x5ef, 0x5f4, 0x48656272},
	{0x600, 0x604, 0x41726162},
	{0x605, 0x605, 0x5a797979},
	{0x606, 0x60b, 0x41726162},
	{0x60c, 0x60c, 0x5a797979},
	{0x60d, 0x61a, 0x41726162},
	{0x61b, 0x61b, 0x5a797979},
	{0x61c, 0x61e, 0x41726162},
	{0x61f, 0x61f, 0x5a797979},
	{0x620, 0x63f, 0x41726162},
	{0x640, 0x640, 0x5a797979},
	{0x641, 0x64a, 0x41726162},
	{0x64b, 0x655, 0x5a696e68},
	{0x656, 0x66f, 0x41726162},
	{0x670, 0x670, 0x5a696e68},
	{0x671, 0x6dc, 0x41726162},
	{0x6dd, 0x6dd, 0x5a797979},
	{0x6de, 0x6ff, 0x41726162},
	{0x700, 0x70d, 0x53797263},
	{0x70f, 0x74a, 0x53797263},
	{0x74d, 0x74f, 0x53797263},
	{0x750, 0x77f, 0x41726162},
	{0x780, 0x7b1, 0x54686161},
	{0x7c0, 0x7fa, 0x4e6b6f6f},
	{0x7fd, 0x7ff, 0x4e6b6f6f},
	{0x800, 0x82d, 0x53616d72},
	{0x830, 0x83e, 0x53616d72},
	{0x840, 0x85b, 0x4d616e64},
	{0x85e, 0x85e, 0x4d616e64},
	{0x860, 0x86a, 0x53797263},
	{0x870, 0x88e, 0x41726162},
	{0x890, 0x891, 0x41726162},
	{0x898, 0x8e1, 0x41726162},
	{0x8e2, 0x8e2, 0x5a797979},
	{0x8e3, 0x8ff, 0x41726162},
	{0x900, 0x950, 0x44657661},
	{0x951, 0x954, 0x5a696e68},
	{0x955, 0x963, 0x44657661},
	{0x964, 0x965, 0x5a797979},
	{0x966, 0x97f, 0x44657661},
	{0x980, 0x983, 0x42656e67},
	{0x985, 0x98c, 0x42656e67},
	{0x98f, 0x990, 0x42656e67},
	{0x993, 0x9a8, 0x42656e67},
	{0x9aa, 0x9b0, 0x42656e67},
	{0x9b2, 0x9b2, 0x42656e67},
	{0x9b6, 0x9b9, 0x42656e67},
	{0x9bc, 0x9c4, 0x42656e67},
	{0x9c7, 0x9c8, 0x42656e67},
	{0x9cb, 0x9ce, 0x42656e67},
	{0x9d7, 0x9d7, 0x42656e67},
	{0x9dc, 0x9dd, 0x42656e67},
	{0x9df, 0x9e3, 0x42656e67},
	{0x9e6, 0x9fe, 0x42656e67},
	{0xa01, 0xa03, 0x47757275},
	{0xa05, 0xa0a, 0x47757275},
	{0xa0f, 0xa10, 0x47757275},
	{0xa13, 0xa28, 0x47757275},
	{0xa2a, 0xa30, 0x47757275},
	{0xa32, 0xa33, 0x47757275},
	{0xa35, 0xa36, 0x47757275},
	{0xa38, 0xa39, 0x47757275},
	{0xa3c, 0xa3c, 0x47757275},
	{0xa3e, 0xa42, 0x47757275},
	{0xa47, 0xa48, 0x47757275},
	{0xa4b, 0xa4d, 0x47757275},
	{0xa51, 0xa51, 0x47757275},
	{0xa59, 0xa5c, 0x47757275},
	{0xa5e, 0xa5e, 0x47757275},
	{0xa66, 0xa76, 0x47757275},
	{0xa81, 0xa83, 0x47756a72},
	{0xa85, 0xa8d, 0x47756a72},
	{0xa8f, 0xa91, 0x47756a72},
	{0xa93, 0xaa8, 0x47756a72},
	{0xaaa, 0xab0, 0x47756a72},
	{0xab2, 0xab3, 0x47756a72},
	{0xab5, 0xab9, 0x47756a72},
	{0xabc, 0xac5, 0x47756a72},
	{0xac7, 0xac9, 0x47756a72},
	{0xacb, 0xacd, 0x47756a72},
	{0xad0, 0xad0, 0x47756a72},
	{0xae0, 0xae3, 0x47756a72},
	{0xae6, 0xaf1, 0x47756a72},
	{0xaf9, 0xaff, 0x47756a72},
	{0xb01, 0xb03, 0x4f727961},
	{0xb05, 0xb0c, 0x4f727961},
	{0xb0f, 0xb10, 0x4f727961},
	{0xb13, 0xb28, 0x4f727961},
	{0xb2a, 0xb30, 0x4f727961},
	{0xb32, 0xb33, 0x4f727961},
	{0xb35, 0xb39, 0x4f727961},
	{0xb3c, 0xb44, 0x4f727961},
	{0xb47, 0xb48, 0x4f727961},
	{0xb4b, 0xb4d, 0x4f727961},
	{0xb55, 0xb57, 0x4f727961},
	{0xb5c, 0xb5d, 0x4f727961},
	{0xb5f, 0xb63, 0x4f727961},
	{0xb66, 0xb77, 0x4f727961},
	{0xb82, 0xb83, 0x54616d6c},
	{0xb85, 0xb8a, 0x54616d6c},
	{0xb8e, 0xb90, 0x54616d6c},
	{0xb92, 0xb95, 0x54616d6c},
	{0xb99, 0xb9a, 0x54616d6c},
	{0xb9c, 0xb9c, 0x54616d6c},
	{0xb9e, 0xb9f, 0x54616d6c},
	{0xba3, 0xba4, 0x54616d6c},
	{0xba8, 0xbaa, 0x54616d6c},
	{0xbae, 0xbb9, 0x54616d6c},
	{0xbbe, 0xbc2, 0x54616d6c},
	{0xbc6, 0xbc8, 0x54616d6c},
	{0xbca, 0xbcd, 0x54616d6c},
	{0xbd0, 0xbd0, 0x54616d6c},
	{0xbd7, 0xbd7, 0x54616d6c},
	{0xbe6, 0xbfa, 0x54616d6c},
	{0xc00, 0xc0c, 0x54656c75},
	{0xc0e, 0xc10, 0x54656c75},
	{0xc12, 0xc28, 0x54656c75},
	{0xc2a, 0xc39, 0x54656c75},
	{0xc3c, 0xc44, 0x54656c75},
	{0xc46, 0xc48, 0x54656c75},
	{0xc4a, 0xc4d, 0x54656c75},
	{0xc55, 0xc56, 0x54656c75},
	{0xc58, 0xc5a, 0x54656c75},
	{0xc5d, 0xc5d, 0x54656c75},
	{0xc60, 0xc63, 0x54656c75},
	{0xc66, 0xc6f, 0x54656c75},
	{0xc77, 0xc7f, 0x54656c75},
	{0xc80, 0xc8c, 0x4b6e6461},
	{0xc8e, 0xc90, 0x4b6e6461},
	{0xc92, 0xca8, 0x4b6e6461},
	{0xcaa, 0xcb3, 0x4b6e6461},
	{0xcb5, 0xcb9, 0x4b6e6461},
	{0xcbc, 0xcc4, 0x4b6e6461},
	{0xcc6, 0xcc8, 0x4b6e6461},
	{0xcca, 0xccd, 0x4b6e6461},
	{0xcd5, 0xcd6, 0x4b6e6461},
	{0xcdd, 0xcde, 0x4b6e6461},
	{0xce0, 0xce3, 0x4b6e6461},
	{0xce6, 0xcef, 0x4b6e6461},
	{0xcf1, 0xcf3, 0x4b6e6461},
	{0xd00, 0xd0c, 0x4d6c796d},
	{0xd0e, 0xd10, 0x4d6c796d},
	{0xd12, 0xd44, 0x4d6c796d},
	{0xd46, 0xd48, 0x4d6c796d},
	{0xd4a, 0xd4f, 0x4d6c796d},
	{0xd54, 0xd63, 0x4d6c796d},
	{0xd66, 0xd7f, 0x4d6c796d},
	{0xd81, 0xd83, 0x53696e68},
	{0xd85, 0xd96, 0x53696e68},
	{0xd9a, 0xdb1, 0x53696e68},
	{0xdb3, 0xdbb, 0x53696e68},
	{0xdbd, 0xdbd, 0x53696e68},
	{0xdc0, 0xdc6, 0x53696e68},
	{0xdca, 0xdca, 0x53696e68},
	{0xdcf, 0xdd4, 0x53696e68},
	{0xdd6, 0xdd6, 0x53696e68},
	{0xdd8, 0xddf, 0x53696e68},
	{0xde6, 0xdef, 0x53696e68},
	{0xdf2, 0xdf4, 0x53696e68},
	{0xe01, 0xe3a, 0x54686169},
	{0xe3f, 0xe3f, 0x5a797979},
	{0xe40, 0xe5b, 0x54686169},
	{0xe81, 0xe82, 0x4c616f6f},
	{0xe84, 0xe84, 0x4c616f6f},
	{0xe86, 0xe8a, 0x4c616f6f},
	{0xe8c, 0xea3, 0x4c616f6f},
	{0xea5, 0xea5, 0x4c616f6f},
	{0xea7, 0xebd, 0x4c616f6f},
	{0xec0, 0xec4, 0x4c616f6f},
	{0xec6, 0xec6, 0x4c616f6f},
	{0xec8, 0xece, 0x4c616f6f},
	{0xed0, 0xed9, 0x4c616f6f},
	{0xedc, 0xedf, 0x4c616f6f},
	{0xf00, 0xf47, 0x54696274},
	{0xf49, 0xf6c, 0x54696274},
	{0xf71, 0xf97, 0x54696274},
	{0xf99, 0xfbc, 0x54696274},
	{0xfbe, 0xfcc, 0x54696274},
	{0xfce, 0xfd4, 0x54696274},
	{0xfd5, 0xfd8, 0x5a797979},
	{0xfd9, 0xfda, 0x54696274},
	{0x1000, 0x109f, 0x4d796d72},
	{0x10a0, 0x10c5, 0x47656f72},
	{0x10c7, 0x10c7, 0x47656f72},
	{0x10cd, 0x10cd, 0x47656f72},
	{0x10d0, 0x10fa, 0x47656f72},
	{0x10fb, 0x10fb, 0x5a797979},
	{0x10fc, 0x10ff, 0x47656f72},
	{0x1100, 0x11ff, 0x48616e67},
	{0x1200, 0x1248, 0x45746869},
	{0x124a, 0x124d, 0x45746869},
	{0x1250, 0x1256, 0x45746869},
	{0x1258, 0x1258, 0x45746869},
	{0x125a, 0x125d, 0x45746869},
	{0x1260, 0x1288, 0x45746869},
	{0x128a, 0x128d, 0x45746869},
	{0x1290, 0x12b0, 0x45746869},
	{0x12b2, 0x12b5, 0x45746869},
	{0x12b8, 0x12be, 0x45746869},
	{0x12c0, 0x12c0, 0x45746869},
	{0x12c2, 0x12c5, 0x45746869},
	{0x12c8, 0x12d6, 0x45746869},
	{0x12d8, 0x1310, 0x45746869},
	{0x1312, 0x1315, 0x45746869},
	{0x1318, 0x135a, 0x45746869},
	{0x135d, 0x137c, 0x45746869},
	{0x1380, 0x1399, 0x45746869},
	{0x13a0, 0x13f5, 0x43686572},
	{0x13f8, 0x13fd, 0x43686572},
	{0x1400, 0x167f, 0x43616e73},
	{0x1680, 0x169c, 0x4f67616d},
	{0x16a0, 0x16ea, 0x52756e72},
	{0x16eb, 0x16ed, 0x5a797979},
	{0x16ee, 0x16f8, 0x52756e72},
	{0x1700, 0x1715, 0x54676c67},
	{0x171f, 0x171f, 0x54676c67},
	{0x1720, 0x1734, 0x48616e6f},
	{0x1735, 0x1736, 0x5a797979},
	{0x1740, 0x1753, 0x42756864},
	{0x1760, 0x176c, 0x54616762},
	{0x176e, 0x1770, 0x54616762},
	{0x1772, 0x1773, 0x54616762},
	{0x1780, 0x17dd, 0x4b686d72},
	{0x17e0, 0x17e9, 0x4b686d72},
	{0x17f0, 0x17f9, 0x4b686d72},
	{0x1800, 0x1801, 0x4d6f6e67},
	{0x1802, 0x1803, 0x5a797979},
	{0x1804, 0x1804, 0x4d6f6e67},
	{0x1805, 0x1805, 0x5a797979},
	{0x1806, 0x1819, 0x4d6f6e67},
	{0x1820, 0x1878, 0x4d6f6e67},
	{0x1880, 0x18aa, 0x4d6f6e67},
	{0x18b0, 0x18f5, 0x43616e73},
	{0x1900, 0x191e, 0x4c696d62},
	{0x1920, 0x192b, 0x4c696d62},
	{0x1930, 0x193b, 0x4c696d62},
	{0x1940, 0x1940, 0x4c696d62},
	{0x1944, 0x194f, 0x4c696d62},
	{0x1950, 0x196d, 0x54616c65},
	{0x1970, 0x1974, 0x54616c65},
	{0x1980, 0x19ab, 0x54616c75},
	{0x19b0, 0x19c9, 0x54616c75},
	{0x19d0, 0x19da, 0x54616c75},
	{0x19de, 0x19df, 0x54616c75},
	{0x19e0, 0x19ff, 0x4b686d72},
	{0x1a00, 0x1a1b, 0x42756769},
	{0x1a1e, 0x1a1f, 0x42756769},
	{0x1a20, 0x1a5e, 0x4c616e61},
	{0x1a60, 0x1a7c, 0x4c616e61},
	{0x1a7f, 0x1a89, 0x4c616e61},
	{0x1a90, 0x1a99, 0x4c616e61},
	{0x1aa0, 0x1aad, 0x4c616e61},
	{0x1ab0, 0x1ace, 0x5a696e68},
	{0x1b00, 0x1b4c, 0x42616c69},
	{0x1b50, 0x1b7e, 0x42616c69},
	{0x1b80, 0x1bbf, 0x53756e64},
	{0x1bc0, 0x1bf3, 0x4261746b},
	{0x1bfc, 0x1bff, 0x4261746b},
	{0x1c00, 0x1c37, 0x4c657063},
	{0x1c3b, 0x1c49, 0x4c657063},
	{0x1c4d, 0x1c4f, 0x4c657063},
	{0x1c50, 0x1c7f, 0x4f6c636b},
	{0x1c80, 0x1c88, 0x4379726c},
	{0x1c90, 0x1cba, 0x47656f72},
	{0x1cbd, 0x1cbf, 0x47656f72},
	{0x1cc0, 0x1cc7, 0x53756e64},
	{0x1cd0, 0x1cd2, 0x5a696e68},
	{0x1cd3, 0x1cd3, 0x5a797979},
	{0x1cd4, 0x1ce0, 0x5a696e68},
	{0x1ce1, 0x1ce1, 0x5a797979},
	{0x1ce2, 0x1ce8, 0x5a696e68},
	{0x1ce9, 0x1cec, 0x5a797979},
	{0x1ced, 0x1ced, 0x5a696e68},
	{0x1cee, 0x1cf3, 0x5a797979},
	{0x1cf4, 0x1cf4, 0x5a696e68},
	{0x1cf5, 0x1cf7, 0x5a797979},
	{0x1cf8, 0x1cf9, 0x5a696e68},
	{0x1cfa, 0x1cfa, 0x5a797979},
	{0x1d00, 0x1d25, 0x4c61746e},
	{0x1d26, 0x1d2a, 0x4772656b},
	{0x1d2b, 0x1d2b, 0x4379726c},
	{0x1d2c, 0x1d5c, 0x4c61746e},
	{0x1d5d, 0x1d61, 0x4772656b},
	{0x1d62, 0x1d65, 0x4c61746e},
	{0x1d66, 0x1d6a, 0x4772656b},
	{0x1d6b, 0x1d77, 0x4c61746e},
	{0x1d78, 0x1d78, 0x4379726c},
	{0x1d79, 0x1dbe, 0x4c61746e},
	{0x1dbf, 0x1dbf, 0x4772656b},
	{0x1dc0, 0x1dff, 0x5a696e68},
	{0x1e00, 0x1eff, 0x4c61746e},
	{0x1f00, 0x1f15, 0x4772656b},
	{0x1f18, 0x1f1d, 0x4772656b},
	{0x1f20, 0x1f45, 0x4772656b},
	{0x1f48, 0x1f4d, 0x4772656b},
	{0x1f50, 0x1f57, 0x4772656b},
	{0x1f59, 0x1f59, 0x4772656b},
	{0x1f5b, 0x1f5b, 0x4772656b},
	{0x1f5d, 0x1f5d, 0x4772656b},
	{0x1f5f, 0x1f7d, 0x4772656b},
	{0x1f80, 0x1fb4, 0x4772656b},
	{0x1fb6, 0x1fc4, 0x4772656b},
	{0x1fc6, 0x1fd3, 0x4772656b},
	{0x1fd6, 0x1fdb, 0x4772656b},
	{0x1fdd, 0x1fef, 0x4772656b},
	{0x1ff2, 0x1ff4, 0x4772656b},
	{0x1ff6, 0x1ffe, 0x4772656b},
	{0x2000, 0x200b, 0x5a797979},
	{0x200c, 0x200d, 0x5a696e68},
	{0x200e, 0x2064, 0x5a797979},
	{0x2066, 0x2070, 0x5a797979},
	{0x2071, 0x2071, 0x4c61746e},
	{0x2074, 0x207e, 0x5a797979},
	{0x207f, 0x207f, 0x4c61746e},
	{0x2080, 0x208e, 0x5a797979},
	{0x2090, 0x209c, 0x4c61746e},
	{0x20a0, 0x20c0, 0x5a797979},
	{0x20d0, 0x20f0, 0x5a696e68},
	{0x2100, 0x2125, 0x5a797979},
	{0x2126, 0x2126, 0x4772656b},
	{0x2127, 0x2129, 0x5a797979},
	{0x212a, 0x212b, 0x4c61746e},
	{0x212c, 0x2131, 0x5a797979},
	{0x2132, 0x2132, 0x4c61746e},
	{0x2133, 0x214d, 0x5a797979},
	{0x214e, 0x214e, 0x4c61746e},
	{0x214f, 0x215f, 0x5a797979},
	{0x2160, 0x2188, 0x4c61746e},
	{0x2189, 0x218b, 0x5a797979},
	{0x2190, 0x2426, 0x5a797979},
	{0x2440, 0x244a, 0x5a797979},
	{0x2460, 0x27ff, 0x5a797979},
	{0x2800, 0x28ff, 0x42726169},
	{0x2900, 0x2b73, 0x5a797979},
	{0x2b76, 0x2b95, 0x5a797979},
	{0x2b97, 0x2bff, 0x5a797979},
	{0x2c00, 0x2c5f, 0x476c6167},
	{0x2c60, 0x2c7f, 0x4c61746e},
	{0x2c80, 0x2cf3, 0x436f7074},
	{0x2cf9, 0x2cff, 0x436f7074},
	{0x2d00, 0x2d25, 0x47656f72},
	{0x2d27, 0x2d27, 0x47656f72},
	{0x2d2d, 0x2d2d, 0x47656f72},
	{0x2d30, 0x2d67, 0x54666e67},
	{0x2d6f, 0x2d70, 0x54666e67},
	{0x2d7f, 0x2d7f, 0x54666e67},
	{0x2d80, 0x2d96, 0x45746869},
	{0x2da0, 0x2da6, 0x45746869},
	{0x2da8, 0x2dae, 0x45746869},
	{0x2db0, 0x2db6, 0x45746869},
	{0x2db8, 0x2dbe, 0x45746869},
	{0x2dc0, 0x2dc6, 0x45746869},
	{0x2dc8, 0x2dce, 0x45746869},
	{0x2dd0, 0x2dd6, 0x45746869},
	{0x2dd8, 0x2dde, 0x45746869},
	{0x2de0, 0x2dff, 0x4379726c},
	{0x2e00, 0x2e5d, 0x5a797979},
	{0x2e80, 0x2e99, 0x48616e69},
	{0x2e9b, 0x2ef3, 0x48616e69},
	{0x2f00, 0x2fd5, 0x48616e69},
	{0x2ff0, 0x2ffb, 0x5a797979},
	{0x3000, 0x3004, 0x5a797979},
	{0x3005, 0x3005, 0x48616e69},
	{0x3006, 0x3006, 0x5a797979},
	{0x3007, 0x3007, 0x48616e69},
	{0x3008, 0x3020, 0x5a797979},
	{0x3021, 0x3029, 0x48616e69},
	{0x302a, 0x302d, 0x5a696e68},
	{0x302e, 0x302f, 0x48616e67},
	{0x3030, 0x3037, 0x5a797979},
	{0x3038, 0x303b, 0x48616e69},
	{0x303c, 0x303f, 0x5a797979},
	{0x3041, 0x3096, 0x48697261},
	{0x3099, 0x309a, 0x5a696e68},
	{0x309b, 0x309c, 0x5a797979},
	{0x309d, 0x309f, 0x48697261},
	{0x30a0, 0x30a0, 0x5a797979},
	{0x30a1, 0x30fa, 0x4b616e61},
	{0x30fb, 0x30fc, 0x5a797979},
	{0x30fd, 0x30ff, 0x4b616e61},
	{0x3105, 0x312f, 0x426f706f},
	{0x3131, 0x318e, 0x48616e67},
	{0x3190, 0x319f, 0x5a797979},
	{0x31a0, 0x31bf, 0x426f706f},
	{0x31c0, 0x31e3, 0x5a797979},
	{0x31f0, 0x31ff, 0x4b616e61},
	{0x3200, 0x321e, 0x48616e67},
	{0x3220, 0x325f, 0x5a797979},
	{0x3260, 0x327e, 0x48616e67},
	{0x327f, 0x32cf, 0x5a797979},
	{0x32d0, 0x32fe, 0x4b616e61},
	{0x32ff, 0x32ff, 0x5a797979},
	{0x3300, 0x3357, 0x4b616e61},
	{0x3358, 0x33ff, 0x5a797979},
	{0x3400, 0x4dbf, 0x48616e69},
	{0x4dc0, 0x4dff, 0x5a797979},
	{0x4e00, 0x9fff, 0x48616e69},
	{0xa000, 0xa48c, 0x59696969},
	{0xa490, 0xa4c6, 0x59696969},
	{0xa4d0, 0xa4ff, 0x4c697375},
	{0xa500, 0xa62b, 0x56616969},
	{0xa640, 0xa69f, 0x4379726c},
	{0xa6a0, 0xa6f7, 0x42616d75},
	{0xa700, 0xa721, 0x5a797979},
	{0xa722, 0xa787, 0x4c61746e},
	{0xa788, 0xa78a, 0x5a797979},
	{0xa78b, 0xa7ca, 0x4c61746e},
	{0xa7d0, 0xa7d1, 0x4c61746e},
	{0xa7d3, 0xa7d3, 0x4c61746e},
	{0xa7d5, 0xa7d9, 0x4c61746e},
	{0xa7f2, 0xa7ff, 0x4c61746e},
	{0xa800, 0xa82c, 0x53796c6f},
	{0xa830, 0xa839, 0x5a797979},
	{0xa840, 0xa877, 0x50686167},
	{0xa880, 0xa8c5, 0x53617572},
	{0xa8ce, 0xa8d9, 0x53617572},
	{0xa8e0, 0xa8ff, 0x44657661},
	{0xa900, 0xa92d, 0x4b616c69},
	{0xa92e, 0xa92e, 0x5a797979},
	{0xa92f, 0xa92f, 0x4b616c69},
	{0xa930, 0xa953, 0x526a6e67},
	{0xa95f, 0xa95f, 0x526a6e67},
	{0xa960, 0xa97c, 0x48616e67},
	{0xa980, 0xa9cd, 0x4a617661},
	{0xa9cf, 0xa9cf, 0x5a797979},
	{0xa9d0, 0xa9d9, 0x4a617661},
	{0xa9de, 0xa9df, 0x4a617661},
	{0xa9e0, 0xa9fe, 0x4d796d72},
	{0xaa00, 0xaa36, 0x4368616d},
	{0xaa40, 0xaa4d, 0x4368616d},
	{0xaa50, 0xaa59, 0x4368616d},
	{0xaa5c, 0xaa5f, 0x4368616d},
	{0xaa60, 0xaa7f, 0x4d796d72},
	{0xaa80, 0xaac2, 0x54617674},
	{0xaadb, 0xaadf, 0x54617674},
	{0xaae0, 0xaaf6, 0x4d746569},
	{0xab01, 0xab06, 0x45746869},
	{0xab09, 0xab0e, 0x45746869},
	{0xab11, 0xab16, 0x45746869},
	{0xab20, 0xab26, 0x45746869},
	{0xab28, 0xab2e, 0x45746869},
	{0xab30, 0xab5a, 0x4c61746e},
	{0xab5b, 0xab5b, 0x5a797979},
	{0xab5c, 0xab64, 0x4c61746e},
	{0xab65, 0xab65, 0x4772656b},
	{0xab66, 0xab69, 0x4c61746e},
	{0xab6a, 0xab6b, 0x5a797979},
	{0xab70, 0xabbf, 0x43686572},
	{0xabc0, 0xabed, 0x4d746569},
	{0xabf0, 0xabf9, 0x4d746569},
	{0xac00, 0xd7a3, 0x48616e67},
	{0xd7b0, 0xd7c6, 0x48616e67},
	{0xd7cb, 0xd7fb, 0x48616e67},
	{0xf900, 0xfa6d, 0x48616e69},
	{0xfa70, 0xfad9, 0x48616e69},
	{0xfb00, 0xfb06, 0x4c61746e},
	{0xfb13, 0xfb17, 0x41726d6e},
	{0xfb1d, 0xfb36, 0x48656272},
	{0xfb38, 0xfb3c, 0x48656272},
	{0xfb3e, 0xfb3e, 0x48656272},
	{0xfb40, 0xfb41, 0x48656272},
	{0xfb43, 0xfb44, 0x48656272},
	{0xfb46, 0xfb4f, 0x48656272},
	{0xfb50, 0xfbc2, 0x41726162},
	{0xfbd3, 0xfd3d, 0x41726162},
	{0xfd3e, 0xfd3f, 0x5a797979},
	{0xfd40, 0xfd8f, 0x41726162},
	{0xfd92, 0xfdc7, 0x41726162},
	{0xfdcf, 0xfdcf, 0x41726162},
	{0xfdf0, 0xfdff, 0x41726162},
	{0xfe00, 0xfe0f, 0x5a696e68},
	{0xfe10, 0xfe19, 0x5a797979},
	{0xfe20, 0xfe2d, 0x5a696e68},
	{0xfe2e, 0xfe2f, 0x4379726c},
	{0xfe30, 0xfe52, 0x5a797979},
	{0xfe54, 0xfe66, 0x5a797979},
	{0xfe68, 0xfe6b, 0x5a797979},
	{0xfe70, 0xfe74, 0x41726162},
	{0xfe76, 0xfefc, 0x41726162},
	{0xfeff, 0xfeff, 0x5a797979},
	{0xff01, 0xff20, 0x5a797979},
	{0xff21, 0xff3a, 0x4c61746e},
	{0xff3b, 0xff40, 0x5a797979},
	{0xff41, 0xff5a, 0x4c61746e},
	{0xff5b, 0xff65, 0x5a797979},
	{0xff66, 0xff6f, 0x4b616e61},
	{0xff70, 0xff70, 0x5a797979},
	{0xff71, 0xff9d, 0x4b616e61},
	{0xff9e, 0xff9f, 0x5a797979},
	{0xffa0, 0xffbe, 0x48616e67},
	{0xffc2, 0xffc7, 0x48616e67},
	{0xffca, 0xffcf, 0x48616e67},
	{0xffd2, 0xffd7, 0x48616e67},
	{0xffda, 0xffdc, 0x48616e67},
	{0xffe0, 0xffe6, 0x5a797979},
	{0xffe8, 0xffee, 0x5a797979},
	{0xfff9, 0xfffd, 0x5a797979},
	{0x10000, 0x1000b, 0x4c696e62},
	{0x1000d, 0x10026, 0x4c696e62},
	{0x10028, 0x1003a, 0x4c696e62},
	{0x1003c, 0x1003d, 0x4c696e62},
	{0x1003f, 0x1004d, 0x4c696e62},
	{0x10050, 0x1005d, 0x4c696e62},
	{0x10080, 0x100fa, 0x4c696e62},
	{0x10100, 0x10102, 0x5a797979},
	{0x10107, 0x10133, 0x5a797979},
	{0x10137, 0x1013f, 0x5a797979},
	{0x10140, 0x1018e, 0x4772656b},
	{0x10190, 0x1019c, 0x5a797979},
	{0x101a0, 0x101a0, 0x4772656b},
	{0x101d0, 0x101fc, 0x5a797979},
	{0x101fd, 0x101fd, 0x5a696e68},
	{0x10280, 0x1029c, 0x4c796369},
	{0x102a0, 0x102d0, 0x43617269},
	{0x102e0, 0x102e0, 0x5a696e68},
	{0x102e1, 0x102fb, 0x5a797979},
	{0x10300, 0x10323, 0x4974616c},
	{0x1032d, 0x1032f, 0x4974616c},
	{0x10330, 0x1034a, 0x476f7468},
	{0x10350, 0x1037a, 0x5065726d},
	{0x10380, 0x1039d, 0x55676172},
	{0x1039f, 0x1039f, 0x55676172},
	{0x103a0, 0x103c3, 0x5870656f},
	{0x103c8, 0x103d5, 0x5870656f},
	{0x10400, 0x1044f, 0x44737274},
	{0x10450, 0x1047f, 0x53686177},
	{0x10480, 0x1049d, 0x4f736d61},
	{0x104a0, 0x104a9, 0x4f736d61},
	{0x104b0, 0x104d3, 0x4f736765},
	{0x104d8, 0x104fb, 0x4f736765},
	{0x10500, 0x10527, 0x456c6261},
	{0x10530, 0x10563, 0x41676862},
	{0x1056f, 0x1056f, 0x41676862},
	{0x10570, 0x1057a, 0x56697468},
	{0x1057c, 0x1058a, 0x56697468},
	{0x1058c, 0x10592, 0x56697468},
	{0x10594, 0x10595, 0x56697468},
	{0x10597, 0x105a1, 0x56697468},
	{0x105a3, 0x105b1, 0x56697468},
	{0x105b3, 0x105b9, 0x56697468},
	{0x105bb, 0x105bc, 0x56697468},
	{0x10600, 0x10736, 0x4c696e61},
	{0x10740, 0x10755, 0x4c696e61},
	{0x10760, 0x10767, 0x4c696e61},
	{0x10780, 0x10785, 0x4c61746e},
	{0x10787, 0x107b0, 0x4c61746e},
	{0x107b2, 0x107ba, 0x4c61746e},
	{0x10800, 0x10805, 0x43707274},
	{0x10808, 0x10808, 0x43707274},
	{0x1080a, 0x10835, 0x43707274},
	{0x10837, 0x10838, 0x43707274},
	{0x1083c, 0x1083c, 0x43707274},
	{0x1083f, 0x1083f, 0x43707274},
	{0x10840, 0x10855, 0x41726d69},
	{0x10857, 0x1085f, 0x41726d69},
	{0x10860, 0x1087f, 0x50616c6d},
	{0x10880, 0x1089e, 0x4e626174},
	{0x108a7, 0x108af, 0x4e626174},
	{0x108e0, 0x108f2, 0x48617472},
	{0x108f4, 0x108f5, 0x48617472},
	{0x108fb, 0x108ff, 0x48617472},
	{0x10900, 0x1091b, 0x50686e78},
	{0x1091f, 0x1091f, 0x50686e78},
	{0x10920, 0x10939, 0x4c796469},
	{0x1093f, 0x1093f, 0x4c796469},
	{0x10980, 0x1099f, 0x4d65726f},
	{0x109a0, 0x109b7, 0x4d657263},
	{0x109bc, 0x109cf, 0x4d657263},
	{0x109d2, 0x109ff, 0x4d657263},
	{0x10a00, 0x10a03, 0x4b686172},
	{0x10a05, 0x10a06, 0x4b686172},
	{0x10a0c, 0x10a13, 0x4b686172},
	{0x10a15, 0x10a17, 0x4b686172},
	{0x10a19, 0x10a35, 0x4b686172},
	{0x10a38, 0x10a3a, 0x4b686172},
	{0x10a3f, 0x10a48, 0x4b686172},
	{0x10a50, 0x10a58, 0x4b686172},
	{0x10a60, 0x10a7f, 0x53617262},
	{0x10a80, 0x10a9f, 0x4e617262},
	{0x10ac0, 0x10ae6, 0x4d616e69},
	{0x10aeb, 0x10af6, 0x4d616e69},
	{0x10b00, 0x10b35, 0x41767374},
	{0x10b39, 0x10b3f, 0x41767374},
	{0x10b40, 0x10b55, 0x50727469},
	{0x10b58, 0x10b5f, 0x50727469},
	{0x10b60, 0x10b72, 0x50686c69},
	{0x10b78, 0x10b7f, 0x50686c69},
	{0x10b80, 0x10b91, 0x50686c70},
	{0x10b99, 0x10b9c, 0x50686c70},
	{0x10ba9, 0x10baf, 0x50686c70},
	{0x10c00, 0x10c48, 0x4f726b68},
	{0x10c80, 0x10cb2, 0x48756e67},
	{0x10cc0, 0x10cf2, 0x48756e67},
	{0x10cfa, 0x10cff, 0x48756e67},
	{0x10d00, 0x10d27, 0x526f6867},
	{0x10d30, 0x10d39, 0x526f6867},
	{0x10e60, 0x10e7e, 0x41726162},
	{0x10e80, 0x10ea9, 0x59657a69},
	{0x10eab, 0x10ead, 0x59657a69},
	{0x10eb0, 0x10eb1, 0x59657a69},
	{0x10efd, 0x10eff, 0x41726162},
	{0x10f00, 0x10f27, 0x536f676f},
	{0x10f30, 0x10f59, 0x536f6764},
	{0x10f70, 0x10f89, 0x4f756772},
	{0x10fb0, 0x10fcb, 0x43687273},
	{0x10fe0, 0x10ff6, 0x456c796d},
	{0x11000, 0x1104d, 0x42726168},
	{0x11052, 0x11075, 0x42726168},
	{0x1107f, 0x1107f, 0x42726168},
	{0x11080, 0x110c2, 0x4b746869},
	{0x110cd, 0x110cd, 0x4b746869},
	{0x110d0, 0x110e8, 0x536f7261},
	{0x110f0, 0x110f9, 0x536f7261},
	{0x11100, 0x11134, 0x43616b6d},
	{0x11136, 0x11147, 0x43616b6d},
	{0x11150, 0x11176, 0x4d61686a},
	{0x11180, 0x111df, 0x53687264},
	{0x111e1, 0x111f4, 0x53696e68},
	{0x11200, 0x11211, 0x4b686f6a},
	{0x11213, 0x11241, 0x4b686f6a},
	{0x11280, 0x11286, 0x4d756c74},
	{0x11288, 0x11288, 0x4d756c74},
	{0x1128a, 0x1128d, 0x4d756c74},
	{0x1128f, 0x1129d, 0x4d756c74},
	{0x1129f, 0x112a9, 0x4d756c74},
	{0x112b0, 0x112ea, 0x53696e64},
	{0x112f0, 0x112f9, 0x53696e64},
	{0x11300, 0x11303, 0x4772616e},
	{0x11305, 0x1130c, 0x4772616e},
	{0x1130f, 0x11310, 0x4772616e},
	{0x11313, 0x11328, 0x4772616e},
	{0x1132a, 0x11330, 0x4772616e},
	{0x11332, 0x11333, 0x4772616e},
	{0x11335, 0x11339, 0x4772616e},
	{0x1133b, 0x1133b, 0x5a696e68},
	{0x1133c, 0x11344, 0x4772616e},
	{0x11347, 0x11348, 0x4772616e},
	{0x1134b, 0x1134d, 0x4772616e},
	{0x11350, 0x11350, 0x4772616e},
	{0x11357, 0x11357, 0x4772616e},
	{0x1135d, 0x11363, 0x4772616e},
	{0x11366, 0x1136c, 0x4772616e},
	{0x11370, 0x11374, 0x4772616e},
	{0x11400, 0x1145b, 0x4e657761},
	{0x1145d, 0x11461, 0x4e657761},
	{0x11480, 0x114c7, 0x54697268},
	{0x114d0, 0x114d9, 0x54697268},
	{0x11580, 0x115b5, 0x53696464},
	{0x115b8, 0x115dd, 0x53696464},
	{0x11600, 0x11644, 0x4d6f6469},
	{0x11650, 0x11659, 0x4d6f6469},
	{0x11660, 0x1166c, 0x4d6f6e67},
	{0x11680, 0x116b9, 0x54616b72},
	{0x116c0, 0x116c9, 0x54616b72},
	{0x11700, 0x1171a, 0x41686f6d},
	{0x1171d, 0x1172b, 0x41686f6d},
	{0x11730, 0x11746, 0x41686f6d},
	{0x11800, 0x1183b, 0x446f6772},
	{0x118a0, 0x118f2, 0x57617261},
	{0x118ff, 0x118ff, 0x57617261},
	{0x11900, 0x11906, 0x4469616b},
	{0x11909, 0x11909, 0x4469616b},
	{0x1190c, 0x11913, 0x4469616b},
	{0x11915, 0x11916, 0x4469616b},
	{0x11918, 0x11935, 0x4469616b},
	{0x11937, 0x11938, 0x4469616b},
	{0x1193b, 0x11946, 0x4469616b},
	{0x11950, 0x11959, 0x4469616b},
	{0x119a0, 0x119a7, 0x4e616e64},
	{0x119aa, 0x119d7, 0x4e616e64},
	{0x119da, 0x119e4, 0x4e616e64},
	{0x11a00, 0x11a47, 0x5a616e62},
	{0x11a50, 0x11aa2, 0x536f796f},
	{0x11ab0, 0x11abf, 0x43616e73},
	{0x11ac0, 0x11af8, 0x50617563},
	{0x11b00, 0x11b09, 0x44657661},
	{0x11c00, 0x11c08, 0x42686b73},
	{0x11c0a, 0x11c36, 0x42686b73},
	{0x11c38, 0x11c45, 0x42686b73},
	{0x11c50, 0x11c6c, 0x42686b73},
	{0x11c70, 0x11c8f, 0x4d617263},
	{0x11c92, 0x11ca7, 0x4d617263},
	{0x11ca9, 0x11cb6, 0x4d617263},
	{0x11d00, 0x11d06, 0x476f6e6d},
	{0x11d08, 0x11d09, 0x476f6e6d},
	{0x11d0b, 0x11d36, 0x476f6e6d},
	{0x11d3a, 0x11d3a, 0x476f6e6d},
	{0x11d3c, 0x11d3d, 0x476f6e6d},
	{0x11d3f, 0x11d47, 0x476f6e6d},
	{0x11d50, 0x11d59, 0x476f6e6d},
	{0x11d60, 0x11d65, 0x476f6e67},
	{0x11d67, 0x11d68, 0x476f6e67},
	{0x11d6a, 0x11d8e, 0x476f6e67},
	{0x11d90, 0x11d91, 0x476f6e67},
	{0x11d93, 0x11d98, 0x476f6e67},
	{0x11da0, 0x11da9, 0x476f6e67},
	{0x11ee0, 0x11ef8, 0x4d616b61},
	{0x11f00, 0x11f10, 0x4b617769},
	{0x11f12, 0x11f3a, 0x4b617769},
	{0x11f3e, 0x11f59, 0x4b617769},
	{0x11fb0, 0x11fb0, 0x4c697375},
	{0x11fc0, 0x11ff1, 0x54616d6c},
	{0x11fff, 0x11fff, 0x54616d6c},
	{0x12000, 0x12399, 0x58737578},
	{0x12400, 0x1246e, 0x58737578},
	{0x12470, 0x12474, 0x58737578},
	{0x12480, 0x12543, 0x58737578},
	{0x12f90, 0x12ff2, 0x43706d6e},
	{0x13000, 0x13455, 0x45677970},
	{0x14400, 0x14646, 0x486c7577},
	{0x16800, 0x16a38, 0x42616d75},
	{0x16a40, 0x16a5e, 0x4d726f6f},
	{0x16a60, 0x16a69, 0x4d726f6f},
	{0x16a6e, 0x16a6f, 0x4d726f6f},
	{0x16a70, 0x16abe, 0x546e7361},
	{0x16ac0, 0x16ac9, 0x546e7361},
	{0x16ad0, 0x16aed, 0x42617373},
	{0x16af0, 0x16af5, 0x42617373},
	{0x16b00, 0x16b45, 0x486d6e67},
	{0x16b50, 0x16b59, 0x486d6e67},
	{0x16b5b, 0x16b61, 0x486d6e67},
	{0x16b63, 0x16b77, 0x486d6e67},
	{0x16b7d, 0x16b8f, 0x486d6e67},
	{0x16e40, 0x16e9a, 0x4d656466},
	{0x16f00, 0x16f4a, 0x506c7264},
	{0x16f4f, 0x16f87, 0x506c7264},
	{0x16f8f, 0x16f9f, 0x506c7264},
	{0x16fe0, 0x16fe0, 0x54616e67},
	{0x16fe1, 0x16fe1, 0x4e736875},
	{0x16fe2, 0x16fe3, 0x48616e69},
	{0x16fe4, 0x16fe4, 0x4b697473},
	{0x16ff0, 0x16ff1, 0x48616e69},
	{0x17000, 0x187f7, 0x54616e67},
	{0x18800, 0x18aff, 0x54616e67},
	{0x18b00, 0x18cd5, 0x4b697473},
	{0x18d00, 0x18d08, 0x54616e67},
	{0x1aff0, 0x1aff3, 0x4b616e61},
	{0x1aff5, 0x1affb, 0x4b616e61},
	{0x1affd, 0x1affe, 0x4b616e61},
	{0x1b000, 0x1b000, 0x4b616e61},
	{0x1b001, 0x1b11f, 0x48697261},
	{0x1b120, 0x1b122, 0x4b616e61},
	{0x1b132, 0x1b132, 0x48697261},
	{0x1b150, 0x1b152, 0x48697261},
	{0x1b155, 0x1b155, 0x4b616e61},
	{0x1b164, 0x1b167, 0x4b616e61},
	{0x1b170, 0x1b2fb, 0x4e736875},
	{0x1bc00, 0x1bc6a, 0x4475706c},
	{0x1bc70, 0x1bc7c, 0x4475706c},
	{0x1bc80, 0x1bc88, 0x4475706c},
	{0x1bc90, 0x1bc99, 0x4475706c},
	{0x1bc9c, 0x1bc9f, 0x4475706c},
	{0x1bca0, 0x1bca3, 0x5a797979},
	{0x1cf00, 0x1cf2d, 0x5a696e68},
	{0x1cf30, 0x1cf46, 0x5a696e68},
	{0x1cf50, 0x1cfc3, 0x5a797979},
	{0x1d000, 0x1d0f5, 0x5a797979},
	{0x1d100, 0x1d126, 0x5a797979},
	{0x1d129, 0x1d166, 0x5a797979},
	{0x1d167, 0x1d169, 0x5a696e68},
	{0x1d16a, 0x1d17a, 0x5a797979},
	{0x1d17b, 0x1d182, 0x5a696e68},
	{0x1d183, 0x1d184, 0x5a797979},
	{0x1d185, 0x1d18b, 0x5a696e68},
	{0x1d18c, 0x1d1a9, 0x5a797979},
	{0x1d1aa, 0x1d1ad, 0x5a696e68},
	{0x1d1ae, 0x1d1ea, 0x5a797979},
	{0x1d200, 0x1d245, 0x4772656b},
	{0x1d2c0, 0x1d2d3, 0x5a797979},
	{0x1d2e0, 0x1d2f3, 0x5a797979},
	{0x1d300, 0x1d356, 0x5a797979},
	{0x1d360, 0x1d378, 0x5a797979},
	{0x1d400, 0x1d454, 0x5a797979},
	{0x1d456, 0x1d49c, 0x5a797979},
	{0x1d49e, 0x1d49f, 0x5a797979},
	{0x1d4a2, 0x1d4a2, 0x5a797979},
	{0x1d4a5, 0x1d4a6, 0x5a797979},
	{0x1d4a9, 0x1d4ac, 0x5a797979},
	{0x1d4ae, 0x1d4b9, 0x5a797979},
	{0x1d4bb, 0x1d4bb, 0x5a797979},
	{0x1d4bd, 0x1d4c3, 0x5a797979},
	{0x1d4c5, 0x1d505, 0x5a797979},
	{0x1d507, 0x1d50a, 0x5a797979},
	{0x1d50d, 0x1d514, 0x5a797979},
	{0x1d516, 0x1d51c, 0x5a797979},
	{0x1d51e, 0x1d539, 0x5a797979},
	{0x1d53b, 0x1d53e, 0x5a797979},
	{0x1d540, 0x1d544, 0x5a797979},
	{0x1d546, 0x1d546, 0x5a797979},
	{0x1d54a, 0x1d550, 0x5a797979},
	{0x1d552, 0x1d6a5, 0x5a797979},
	{0x1d6a8, 0x1d7cb, 0x5a797979},
	{0x1d7ce, 0x1d7ff, 0x5a797979},
	{0x1d800, 0x1da8b, 0x53676e77},
	{0x1da9b, 0x1da9f, 0x53676e77},
	{0x1daa1, 0x1daaf, 0x53676e77},
	{0x1df00, 0x1df1e, 0x4c61746e},
	{0x1df25, 0x1df2a, 0x4c61746e},
	{0x1e000, 0x1e006, 0x476c6167},
	{0x1e008, 0x1e018, 0x476c6167},
	{0x1e01b, 0x1e021, 0x476c6167},
	{0x1e023, 0x1e024, 0x476c6167},
	{0x1e026, 0x1e02a, 0x476c6167},
	{0x1e030, 0x1e06d, 0x4379726c},
	{0x1e08f, 0x1e08f, 0x4379726c},
	{0x1e100, 0x1e12c, 0x486d6e70},
	{0x1e130, 0x1e13d, 0x486d6e70},
	{0x1e140, 0x1e149, 0x486d6e70},
	{0x1e14e, 0x1e14f, 0x486d6e70},
	{0x1e290, 0x1e2ae, 0x546f746f},
	{0x1e2c0, 0x1e2f9, 0x5763686f},
	{0x1e2ff, 0x1e2ff, 0x5763686f},
	{0x1e4d0, 0x1e4f9, 0x4e61676d},
	{0x1e7e0, 0x1e7e6, 0x45746869},
	{0x1e7e8, 0x1e7eb, 0x45746869},
	{0x1e7ed, 0x1e7ee, 0x45746869},
	{0x1e7f0, 0x1e7fe, 0x45746869},
	{0x1e800, 0x1e8c4, 0x4d656e64},
	{0x1e8c7, 0x1e8d6, 0x4d656e64},
	{0x1e900, 0x1e94b, 0x41646c6d},
	{0x1e950, 0x1e959, 0x41646c6d},
	{0x1e95e, 0x1e95f, 0x41646c6d},
	{0x1ec71, 0x1ecb4, 0x5a797979},
	{0x1ed01, 0x1ed3d, 0x5a797979},
	{0x1ee00, 0x1ee03, 0x41726162},
	{0x1ee05, 0x1ee1f, 0x41726162},
	{0x1ee21, 0x1ee22, 0x41726162},
	{0x1ee24, 0x1ee24, 0x41726162},
	{0x1ee27, 0x1ee27, 0x41726162},
	{0x1ee29, 0x1ee32, 0x41726162},
	{0x1ee34, 0x1ee37, 0x41726162},
	{0x1ee39, 0x1ee39, 0x41726162},
	{0x1ee3b, 0x1ee3b, 0x41726162},
	{0x1ee42, 0x1ee42, 0x41726162},
	{0x1ee47, 0x1ee47, 0x41726162},
	{0x1ee49, 0x1ee49, 0x41726162},
	{0x1ee4b, 0x1ee4b, 0x41726162},
	{0x1ee4d, 0x1ee4f, 0x41726162},
	{0x1ee51, 0x1ee52, 0x41726162},
	{0x1ee54, 0x1ee54, 0x41726162},
	{0x1ee57, 0x1ee57, 0x41726162},
	{0x1ee59, 0x1ee59, 0x41726162},
	{0x1ee5b, 0x1ee5b, 0x41726162},
	{0x1ee5d, 0x1ee5d, 0x41726162},
	{0x1ee5f, 0x1ee5f, 0x41726162},
	{0x1ee61, 0x1ee62, 0x41726162},
	{0x1ee64, 0x1ee64, 0x41726162},
	{0x1ee67, 0x1ee6a, 0x41726162},
	{0x1ee6c, 0x1ee72, 0x41726162},
	{0x1ee74, 0x1ee77, 0x41726162},
	{0x1ee79, 0x1ee7c, 0x41726162},
	{0x1ee7e, 0x1ee7e, 0x41726162},
	{0x1ee80, 0x1ee89, 0x41726162},
	{0x1ee8b, 0x1ee9b, 0x41726162},
	{0x1eea1, 0x1eea3, 0x41726162},
	{0x1eea5, 0x1eea9, 0x41726162},
	{0x1eeab, 0x1eebb, 0x41726162},
	{0x1eef0, 0x1eef1, 0x41726162},
	{0x1f000, 0x1f02b, 0x5a797979},
	{0x1f030, 0x1f093, 0x5a797979},
	{0x1f0a0, 0x1f0ae, 0x5a797979},
	{0x1f0b1, 0x1f0bf, 0x5a797979},
	{0x1f0c1, 0x1f0cf, 0x5a797979},
	{0x1f0d1, 0x1f0f5, 0x5a797979},
	{0x1f100, 0x1f1ad, 0x5a797979},
	{0x1f1e6, 0x1f1ff, 0x5a797979},
	{0x1f200, 0x1f200, 0x48697261},
	{0x1f201, 0x1f202, 0x5a797979},
	{0x1f210, 0x1f23b, 0x5a797979},
	{0x1f240, 0x1f248, 0x5a797979},
	{0x1f250, 0x1f251, 0x5a797979},
	{0x1f260, 0x1f265, 0x5a797979},
	{0x1f300, 0x1f6d7, 0x5a797979},
	{0x1f6dc, 0x1f6ec, 0x5a797979},
	{0x1f6f0, 0x1f6fc, 0x5a797979},
	{0x1f700, 0x1f776, 0x5a797979},
	{0x1f77b, 0x1f7d9, 0x5a797979},
	{0x1f7e0, 0x1f7eb, 0x5a797979},
	{0x1f7f0, 0x1f7f0, 0x5a797979},
	{0x1f800, 0x1f80b, 0x5a797979},
	{0x1f810, 0x1f847, 0x5a797979},
	{0x1f850, 0x1f859, 0x5a797979},
	{0x1f860, 0x1f887, 0x5a797979},
	{0x1f890, 0x1f8ad, 0x5a797979},
	{0x1f8b0, 0x1f8b1, 0x5a797979},
	{0x1f900, 0x1fa53, 0x5a797979},
	{0x1fa60, 0x1fa6d, 0x5a797979},
	{0x1fa70, 0x1fa7c, 0x5a797979},
	{0x1fa80, 0x1fa88, 0x5a797979},
	{0x1fa90, 0x1fabd, 0x5a797979},
	{0x1fabf, 0x1fac5, 0x5a797979},
	{0x1face, 0x1fadb, 0x5a797979},
	{0x1fae0, 0x1fae8, 0x5a797979},
	{0x1faf0, 0x1faf8, 0x5a797979},
	{0x1fb00, 0x1fb92, 0x5a797979},
	{0x1fb94, 0x1fbca, 0x5a797979},
	{0x1fbf0, 0x1fbf9, 0x5a797979},
	{0x20000, 0x2a6df, 0x48616e69},
	{0x2a700, 0x2b739, 0x48616e69},
	{0x2b740, 0x2b81d, 0x48616e69},
	{0x2b820, 0x2cea1, 0x48616e69},
	{0x2ceb0, 0x2ebe0, 0x48616e69},
	{0x2f800, 0x2fa1d, 0x48616e69},
	{0x30000, 0x3134a, 0x48616e69},
	{0x31350, 0x323af, 0x48616e69},
	{0xe0001, 0xe0001, 0x5a797979},
	{0xe0020, 0xe007f, 0x5a797979},
	{0xe0100, 0xe01ef, 0x5a696e68},
}
