package main

import (
	"image"
	"image/color"

	lbl "github.com/aarzilli/nucular/label"
	nstyle "github.com/aarzilli/nucular/style"
)

func makeBoringStyle() *nstyle.Style {
	style := &nstyle.Style{}

	// not serializing style.Scaling of type *float64
	// not serializing style.Font of type *font.Face
	style.Text.Color = color.RGBA{0, 0, 0, 255}
	style.Text.Padding = image.Point{4, 4}
	style.Button.Normal.Type = nstyle.ItemColor
	style.Button.Normal.Data.Color = color.RGBA{55, 94, 171, 255}
	style.Button.Hover.Type = nstyle.ItemColor
	style.Button.Hover.Data.Color = color.RGBA{70, 121, 216, 255}
	style.Button.Active.Type = nstyle.ItemColor
	style.Button.Active.Data.Color = color.RGBA{0, 90, 255, 255}
	style.Button.BorderColor = color.RGBA{51, 55, 67, 255}
	style.Button.TextBackground = color.RGBA{55, 94, 171, 255}
	style.Button.TextNormal = color.RGBA{255, 255, 255, 255}
	style.Button.TextHover = color.RGBA{255, 255, 255, 255}
	style.Button.TextActive = color.RGBA{255, 255, 255, 255}
	style.Button.Border = 1
	style.Button.Rounding = 4
	style.Button.Padding = image.Point{4, 4}
	style.Button.ImagePadding = image.Point{0, 0}
	style.Button.TouchPadding = image.Point{0, 0}
	style.Button.SymbolBorderWidth = 1
	style.ContextualButton.Normal.Type = nstyle.ItemColor
	style.ContextualButton.Normal.Data.Color = color.RGBA{0, 0, 0, 0}
	style.ContextualButton.Hover.Type = nstyle.ItemColor
	style.ContextualButton.Hover.Data.Color = color.RGBA{75, 131, 233, 255}
	style.ContextualButton.Active.Type = nstyle.ItemColor
	style.ContextualButton.Active.Data.Color = color.RGBA{75, 131, 233, 255}
	style.ContextualButton.BorderColor = color.RGBA{0, 0, 0, 0}
	style.ContextualButton.TextBackground = color.RGBA{212, 208, 200, 255}
	style.ContextualButton.TextNormal = color.RGBA{0, 0, 0, 255}
	style.ContextualButton.TextHover = color.RGBA{0, 0, 0, 255}
	style.ContextualButton.TextActive = color.RGBA{0, 0, 0, 255}
	style.ContextualButton.Border = 0
	style.ContextualButton.Rounding = 0
	style.ContextualButton.Padding = image.Point{4, 4}
	style.ContextualButton.ImagePadding = image.Point{0, 0}
	style.ContextualButton.TouchPadding = image.Point{0, 0}
	style.ContextualButton.SymbolBorderWidth = 1
	style.MenuButton.Normal.Type = nstyle.ItemColor
	style.MenuButton.Normal.Data.Color = color.RGBA{0, 0, 0, 255}
	style.MenuButton.Hover.Type = nstyle.ItemColor
	style.MenuButton.Hover.Data.Color = color.RGBA{0, 0, 0, 255}
	style.MenuButton.Active.Type = nstyle.ItemColor
	style.MenuButton.Active.Data.Color = color.RGBA{0, 0, 0, 255}
	style.MenuButton.BorderColor = color.RGBA{0, 0, 0, 255}
	style.MenuButton.TextBackground = color.RGBA{0, 0, 0, 255}
	style.MenuButton.TextNormal = color.RGBA{190, 190, 190, 255}
	style.MenuButton.TextHover = color.RGBA{190, 190, 190, 255}
	style.MenuButton.TextActive = color.RGBA{190, 190, 190, 255}
	style.MenuButton.Border = 0
	style.MenuButton.Rounding = 1
	style.MenuButton.Padding = image.Point{4, 4}
	style.MenuButton.ImagePadding = image.Point{0, 0}
	style.MenuButton.TouchPadding = image.Point{0, 0}
	style.MenuButton.SymbolBorderWidth = 1
	style.Option.Normal.Type = nstyle.ItemColor
	style.Option.Normal.Data.Color = color.RGBA{255, 255, 255, 255}
	style.Option.Hover.Type = nstyle.ItemColor
	style.Option.Hover.Data.Color = color.RGBA{255, 255, 255, 255}
	style.Option.Active.Type = nstyle.ItemColor
	style.Option.Active.Data.Color = color.RGBA{255, 255, 255, 255}
	style.Option.CursorNormal.Type = nstyle.ItemColor
	style.Option.CursorNormal.Data.Color = color.RGBA{55, 94, 171, 255}
	style.Option.CursorHover.Type = nstyle.ItemColor
	style.Option.CursorHover.Data.Color = color.RGBA{55, 94, 171, 255}
	style.Option.TextNormal = color.RGBA{0, 0, 0, 255}
	style.Option.TextHover = color.RGBA{0, 0, 0, 255}
	style.Option.TextActive = color.RGBA{0, 0, 0, 255}
	style.Option.TextBackground = color.RGBA{0, 0, 0, 255}
	style.Option.Padding = image.Point{4, 4}
	style.Option.TouchPadding = image.Point{0, 0}
	style.Checkbox.Normal.Type = nstyle.ItemColor
	style.Checkbox.Normal.Data.Color = color.RGBA{255, 255, 255, 255}
	style.Checkbox.Hover.Type = nstyle.ItemColor
	style.Checkbox.Hover.Data.Color = color.RGBA{255, 255, 255, 255}
	style.Checkbox.Active.Type = nstyle.ItemColor
	style.Checkbox.Active.Data.Color = color.RGBA{255, 255, 255, 255}
	style.Checkbox.CursorNormal.Type = nstyle.ItemColor
	style.Checkbox.CursorNormal.Data.Color = color.RGBA{55, 94, 171, 255}
	style.Checkbox.CursorHover.Type = nstyle.ItemColor
	style.Checkbox.CursorHover.Data.Color = color.RGBA{55, 94, 171, 255}
	style.Checkbox.TextNormal = color.RGBA{0, 0, 0, 255}
	style.Checkbox.TextHover = color.RGBA{0, 0, 0, 255}
	style.Checkbox.TextActive = color.RGBA{0, 0, 0, 255}
	style.Checkbox.TextBackground = color.RGBA{0, 0, 0, 255}
	style.Checkbox.Padding = image.Point{4, 4}
	style.Checkbox.TouchPadding = image.Point{0, 0}
	style.Selectable.Normal.Type = nstyle.ItemColor
	style.Selectable.Normal.Data.Color = color.RGBA{0, 0, 0, 0}
	style.Selectable.Hover.Type = nstyle.ItemColor
	style.Selectable.Hover.Data.Color = color.RGBA{0, 0, 0, 22}
	style.Selectable.Pressed.Type = nstyle.ItemColor
	style.Selectable.Pressed.Data.Color = color.RGBA{0, 0, 0, 47}
	style.Selectable.NormalActive.Type = nstyle.ItemColor
	style.Selectable.NormalActive.Data.Color = color.RGBA{51, 143, 248, 255}
	style.Selectable.HoverActive.Type = nstyle.ItemColor
	style.Selectable.HoverActive.Data.Color = color.RGBA{51, 143, 248, 255}
	style.Selectable.PressedActive.Type = nstyle.ItemColor
	style.Selectable.PressedActive.Data.Color = color.RGBA{51, 143, 248, 255}
	style.Selectable.TextNormal = color.RGBA{0, 0, 0, 255}
	style.Selectable.TextHover = color.RGBA{0, 0, 0, 255}
	style.Selectable.TextPressed = color.RGBA{0, 0, 0, 255}
	style.Selectable.TextNormalActive = color.RGBA{255, 255, 255, 255}
	style.Selectable.TextHoverActive = color.RGBA{255, 255, 255, 255}
	style.Selectable.TextPressedActive = color.RGBA{255, 255, 255, 255}
	style.Selectable.TextBackground = color.RGBA{51, 143, 248, 255}
	style.Selectable.TextAlignment = 0
	style.Selectable.Rounding = 0
	style.Selectable.Padding = image.Point{4, 4}
	style.Selectable.TouchPadding = image.Point{0, 0}
	style.Slider.Normal.Type = nstyle.ItemColor
	style.Slider.Normal.Data.Color = color.RGBA{0, 0, 0, 0}
	style.Slider.Hover.Type = nstyle.ItemColor
	style.Slider.Hover.Data.Color = color.RGBA{0, 0, 0, 0}
	style.Slider.Active.Type = nstyle.ItemColor
	style.Slider.Active.Data.Color = color.RGBA{0, 0, 0, 0}
	style.Slider.BorderColor = color.RGBA{0, 0, 0, 0}
	style.Slider.BarNormal = color.RGBA{0, 0, 0, 255}
	style.Slider.BarHover = color.RGBA{0, 0, 0, 255}
	style.Slider.BarActive = color.RGBA{0, 0, 0, 255}
	style.Slider.BarFilled = color.RGBA{0, 0, 0, 255}
	style.Slider.CursorNormal.Type = nstyle.ItemColor
	style.Slider.CursorNormal.Data.Color = color.RGBA{55, 94, 171, 255}
	style.Slider.CursorHover.Type = nstyle.ItemColor
	style.Slider.CursorHover.Data.Color = color.RGBA{55, 94, 171, 255}
	style.Slider.CursorActive.Type = nstyle.ItemColor
	style.Slider.CursorActive.Data.Color = color.RGBA{55, 96, 171, 255}
	style.Slider.Border = 0
	style.Slider.Rounding = 0
	style.Slider.BarHeight = 8
	style.Slider.Padding = image.Point{4, 4}
	style.Slider.Spacing = image.Point{4, 4}
	style.Slider.CursorSize = image.Point{16, 16}
	style.Slider.ShowButtons = false
	style.Slider.IncButton.Normal.Type = nstyle.ItemColor
	style.Slider.IncButton.Normal.Data.Color = color.RGBA{40, 40, 40, 255}
	style.Slider.IncButton.Hover.Type = nstyle.ItemColor
	style.Slider.IncButton.Hover.Data.Color = color.RGBA{42, 42, 42, 255}
	style.Slider.IncButton.Active.Type = nstyle.ItemColor
	style.Slider.IncButton.Active.Data.Color = color.RGBA{44, 44, 44, 255}
	style.Slider.IncButton.BorderColor = color.RGBA{65, 65, 65, 255}
	style.Slider.IncButton.TextBackground = color.RGBA{40, 40, 40, 255}
	style.Slider.IncButton.TextNormal = color.RGBA{175, 175, 175, 255}
	style.Slider.IncButton.TextHover = color.RGBA{175, 175, 175, 255}
	style.Slider.IncButton.TextActive = color.RGBA{175, 175, 175, 255}
	style.Slider.IncButton.Border = 1
	style.Slider.IncButton.Rounding = 0
	style.Slider.IncButton.Padding = image.Point{8, 8}
	style.Slider.IncButton.ImagePadding = image.Point{0, 0}
	style.Slider.IncButton.TouchPadding = image.Point{0, 0}
	style.Slider.IncButton.SymbolBorderWidth = 0
	style.Slider.DecButton.Normal.Type = nstyle.ItemColor
	style.Slider.DecButton.Normal.Data.Color = color.RGBA{40, 40, 40, 255}
	style.Slider.DecButton.Hover.Type = nstyle.ItemColor
	style.Slider.DecButton.Hover.Data.Color = color.RGBA{42, 42, 42, 255}
	style.Slider.DecButton.Active.Type = nstyle.ItemColor
	style.Slider.DecButton.Active.Data.Color = color.RGBA{44, 44, 44, 255}
	style.Slider.DecButton.BorderColor = color.RGBA{65, 65, 65, 255}
	style.Slider.DecButton.TextBackground = color.RGBA{40, 40, 40, 255}
	style.Slider.DecButton.TextNormal = color.RGBA{175, 175, 175, 255}
	style.Slider.DecButton.TextHover = color.RGBA{175, 175, 175, 255}
	style.Slider.DecButton.TextActive = color.RGBA{175, 175, 175, 255}
	style.Slider.DecButton.Border = 1
	style.Slider.DecButton.Rounding = 0
	style.Slider.DecButton.Padding = image.Point{8, 8}
	style.Slider.DecButton.ImagePadding = image.Point{0, 0}
	style.Slider.DecButton.TouchPadding = image.Point{0, 0}
	style.Slider.DecButton.SymbolBorderWidth = 0
	style.Slider.IncSymbol = lbl.SymbolType(10)
	style.Slider.DecSymbol = lbl.SymbolType(9)
	style.Progress.Normal.Type = nstyle.ItemColor
	style.Progress.Normal.Data.Color = color.RGBA{51, 55, 67, 255}
	style.Progress.Hover.Type = nstyle.ItemColor
	style.Progress.Hover.Data.Color = color.RGBA{51, 55, 67, 255}
	style.Progress.Active.Type = nstyle.ItemColor
	style.Progress.Active.Data.Color = color.RGBA{51, 55, 67, 255}
	style.Progress.CursorNormal.Type = nstyle.ItemColor
	style.Progress.CursorNormal.Data.Color = color.RGBA{55, 94, 171, 255}
	style.Progress.CursorHover.Type = nstyle.ItemColor
	style.Progress.CursorHover.Data.Color = color.RGBA{55, 94, 171, 255}
	style.Progress.CursorActive.Type = nstyle.ItemColor
	style.Progress.CursorActive.Data.Color = color.RGBA{55, 94, 171, 255}
	style.Progress.Rounding = 0
	style.Progress.Padding = image.Point{4, 4}
	style.Property.Normal.Type = nstyle.ItemColor
	style.Property.Normal.Data.Color = color.RGBA{0, 0, 0, 29}
	style.Property.Hover.Type = nstyle.ItemColor
	style.Property.Hover.Data.Color = color.RGBA{0, 0, 0, 29}
	style.Property.Active.Type = nstyle.ItemColor
	style.Property.Active.Data.Color = color.RGBA{0, 0, 0, 29}
	style.Property.BorderColor = color.RGBA{0, 0, 0, 0}
	style.Property.LabelNormal = color.RGBA{0, 0, 0, 255}
	style.Property.LabelHover = color.RGBA{0, 0, 0, 255}
	style.Property.LabelActive = color.RGBA{0, 0, 0, 255}
	style.Property.SymLeft = lbl.SymbolType(9)
	style.Property.SymRight = lbl.SymbolType(10)
	style.Property.Border = 1
	style.Property.Rounding = 10
	style.Property.Padding = image.Point{4, 4}
	style.Property.Edit.Normal.Type = nstyle.ItemColor
	style.Property.Edit.Normal.Data.Color = color.RGBA{0, 0, 0, 0}
	style.Property.Edit.Hover.Type = nstyle.ItemColor
	style.Property.Edit.Hover.Data.Color = color.RGBA{0, 0, 0, 0}
	style.Property.Edit.Active.Type = nstyle.ItemColor
	style.Property.Edit.Active.Data.Color = color.RGBA{0, 0, 0, 0}
	style.Property.Edit.BorderColor = color.RGBA{0, 0, 0, 0}
	style.Property.Edit.Scrollbar.Normal.Type = nstyle.ItemColor
	style.Property.Edit.Scrollbar.Normal.Data.Color = color.RGBA{0, 0, 0, 0}
	style.Property.Edit.Scrollbar.Hover.Type = nstyle.ItemColor
	style.Property.Edit.Scrollbar.Hover.Data.Color = color.RGBA{0, 0, 0, 0}
	style.Property.Edit.Scrollbar.Active.Type = nstyle.ItemColor
	style.Property.Edit.Scrollbar.Active.Data.Color = color.RGBA{0, 0, 0, 0}
	style.Property.Edit.Scrollbar.BorderColor = color.RGBA{0, 0, 0, 0}
	style.Property.Edit.Scrollbar.CursorNormal.Type = nstyle.ItemColor
	style.Property.Edit.Scrollbar.CursorNormal.Data.Color = color.RGBA{0, 0, 0, 0}
	style.Property.Edit.Scrollbar.CursorHover.Type = nstyle.ItemColor
	style.Property.Edit.Scrollbar.CursorHover.Data.Color = color.RGBA{0, 0, 0, 0}
	style.Property.Edit.Scrollbar.CursorActive.Type = nstyle.ItemColor
	style.Property.Edit.Scrollbar.CursorActive.Data.Color = color.RGBA{0, 0, 0, 0}
	style.Property.Edit.Scrollbar.Border = 0
	style.Property.Edit.Scrollbar.Rounding = 0
	style.Property.Edit.Scrollbar.Padding = image.Point{0, 0}
	style.Property.Edit.Scrollbar.ShowButtons = false
	style.Property.Edit.Scrollbar.IncButton.Normal.Type = nstyle.ItemColor
	style.Property.Edit.Scrollbar.IncButton.Normal.Data.Color = color.RGBA{0, 0, 0, 0}
	style.Property.Edit.Scrollbar.IncButton.Hover.Type = nstyle.ItemColor
	style.Property.Edit.Scrollbar.IncButton.Hover.Data.Color = color.RGBA{0, 0, 0, 0}
	style.Property.Edit.Scrollbar.IncButton.Active.Type = nstyle.ItemColor
	style.Property.Edit.Scrollbar.IncButton.Active.Data.Color = color.RGBA{0, 0, 0, 0}
	style.Property.Edit.Scrollbar.IncButton.BorderColor = color.RGBA{0, 0, 0, 0}
	style.Property.Edit.Scrollbar.IncButton.TextBackground = color.RGBA{0, 0, 0, 0}
	style.Property.Edit.Scrollbar.IncButton.TextNormal = color.RGBA{0, 0, 0, 0}
	style.Property.Edit.Scrollbar.IncButton.TextHover = color.RGBA{0, 0, 0, 0}
	style.Property.Edit.Scrollbar.IncButton.TextActive = color.RGBA{0, 0, 0, 0}
	style.Property.Edit.Scrollbar.IncButton.Border = 0
	style.Property.Edit.Scrollbar.IncButton.Rounding = 0
	style.Property.Edit.Scrollbar.IncButton.Padding = image.Point{0, 0}
	style.Property.Edit.Scrollbar.IncButton.ImagePadding = image.Point{0, 0}
	style.Property.Edit.Scrollbar.IncButton.TouchPadding = image.Point{0, 0}
	style.Property.Edit.Scrollbar.IncButton.SymbolBorderWidth = 0
	style.Property.Edit.Scrollbar.DecButton.Normal.Type = nstyle.ItemColor
	style.Property.Edit.Scrollbar.DecButton.Normal.Data.Color = color.RGBA{0, 0, 0, 0}
	style.Property.Edit.Scrollbar.DecButton.Hover.Type = nstyle.ItemColor
	style.Property.Edit.Scrollbar.DecButton.Hover.Data.Color = color.RGBA{0, 0, 0, 0}
	style.Property.Edit.Scrollbar.DecButton.Active.Type = nstyle.ItemColor
	style.Property.Edit.Scrollbar.DecButton.Active.Data.Color = color.RGBA{0, 0, 0, 0}
	style.Property.Edit.Scrollbar.DecButton.BorderColor = color.RGBA{0, 0, 0, 0}
	style.Property.Edit.Scrollbar.DecButton.TextBackground = color.RGBA{0, 0, 0, 0}
	style.Property.Edit.Scrollbar.DecButton.TextNormal = color.RGBA{0, 0, 0, 0}
	style.Property.Edit.Scrollbar.DecButton.TextHover = color.RGBA{0, 0, 0, 0}
	style.Property.Edit.Scrollbar.DecButton.TextActive = color.RGBA{0, 0, 0, 0}
	style.Property.Edit.Scrollbar.DecButton.Border = 0
	style.Property.Edit.Scrollbar.DecButton.Rounding = 0
	style.Property.Edit.Scrollbar.DecButton.Padding = image.Point{0, 0}
	style.Property.Edit.Scrollbar.DecButton.ImagePadding = image.Point{0, 0}
	style.Property.Edit.Scrollbar.DecButton.TouchPadding = image.Point{0, 0}
	style.Property.Edit.Scrollbar.DecButton.SymbolBorderWidth = 0
	style.Property.Edit.Scrollbar.IncSymbol = lbl.SymbolType(0)
	style.Property.Edit.Scrollbar.DecSymbol = lbl.SymbolType(0)
	style.Property.Edit.CursorNormal = color.RGBA{0, 0, 0, 112}
	style.Property.Edit.CursorHover = color.RGBA{0, 0, 0, 112}
	style.Property.Edit.CursorTextNormal = color.RGBA{0, 0, 0, 255}
	style.Property.Edit.CursorTextHover = color.RGBA{0, 0, 0, 255}
	style.Property.Edit.TextNormal = color.RGBA{0, 0, 0, 255}
	style.Property.Edit.TextHover = color.RGBA{0, 0, 0, 255}
	style.Property.Edit.TextActive = color.RGBA{0, 0, 0, 255}
	style.Property.Edit.SelectedNormal = color.RGBA{114, 176, 252, 255}
	style.Property.Edit.SelectedHover = color.RGBA{114, 176, 252, 255}
	style.Property.Edit.SelectedTextNormal = color.RGBA{0, 0, 0, 255}
	style.Property.Edit.SelectedTextHover = color.RGBA{0, 0, 0, 255}
	style.Property.Edit.Border = 0
	style.Property.Edit.Rounding = 0
	style.Property.Edit.ScrollbarSize = image.Point{0, 0}
	style.Property.Edit.Padding = image.Point{0, 0}
	style.Property.Edit.RowPadding = 0
	style.Property.IncButton.Normal.Type = nstyle.ItemColor
	style.Property.IncButton.Normal.Data.Color = color.RGBA{0, 0, 0, 0}
	style.Property.IncButton.Hover.Type = nstyle.ItemColor
	style.Property.IncButton.Hover.Data.Color = color.RGBA{0, 0, 0, 0}
	style.Property.IncButton.Active.Type = nstyle.ItemColor
	style.Property.IncButton.Active.Data.Color = color.RGBA{0, 0, 0, 0}
	style.Property.IncButton.BorderColor = color.RGBA{0, 0, 0, 0}
	style.Property.IncButton.TextBackground = color.RGBA{51, 55, 67, 255}
	style.Property.IncButton.TextNormal = color.RGBA{0, 0, 0, 255}
	style.Property.IncButton.TextHover = color.RGBA{0, 0, 0, 255}
	style.Property.IncButton.TextActive = color.RGBA{0, 0, 0, 255}
	style.Property.IncButton.Border = 0
	style.Property.IncButton.Rounding = 0
	style.Property.IncButton.Padding = image.Point{0, 0}
	style.Property.IncButton.ImagePadding = image.Point{0, 0}
	style.Property.IncButton.TouchPadding = image.Point{0, 0}
	style.Property.IncButton.SymbolBorderWidth = 1
	style.Property.DecButton.Normal.Type = nstyle.ItemColor
	style.Property.DecButton.Normal.Data.Color = color.RGBA{0, 0, 0, 0}
	style.Property.DecButton.Hover.Type = nstyle.ItemColor
	style.Property.DecButton.Hover.Data.Color = color.RGBA{0, 0, 0, 0}
	style.Property.DecButton.Active.Type = nstyle.ItemColor
	style.Property.DecButton.Active.Data.Color = color.RGBA{0, 0, 0, 0}
	style.Property.DecButton.BorderColor = color.RGBA{0, 0, 0, 0}
	style.Property.DecButton.TextBackground = color.RGBA{51, 55, 67, 255}
	style.Property.DecButton.TextNormal = color.RGBA{0, 0, 0, 255}
	style.Property.DecButton.TextHover = color.RGBA{0, 0, 0, 255}
	style.Property.DecButton.TextActive = color.RGBA{0, 0, 0, 255}
	style.Property.DecButton.Border = 0
	style.Property.DecButton.Rounding = 0
	style.Property.DecButton.Padding = image.Point{0, 0}
	style.Property.DecButton.ImagePadding = image.Point{0, 0}
	style.Property.DecButton.TouchPadding = image.Point{0, 0}
	style.Property.DecButton.SymbolBorderWidth = 1
	style.Edit.Normal.Type = nstyle.ItemColor
	style.Edit.Normal.Data.Color = color.RGBA{255, 255, 255, 255}
	style.Edit.Hover.Type = nstyle.ItemColor
	style.Edit.Hover.Data.Color = color.RGBA{255, 255, 255, 255}
	style.Edit.Active.Type = nstyle.ItemColor
	style.Edit.Active.Data.Color = color.RGBA{255, 255, 255, 255}
	style.Edit.BorderColor = color.RGBA{51, 55, 67, 255}
	style.Edit.Scrollbar.Normal.Type = nstyle.ItemColor
	style.Edit.Scrollbar.Normal.Data.Color = color.RGBA{204, 204, 204, 255}
	style.Edit.Scrollbar.Hover.Type = nstyle.ItemColor
	style.Edit.Scrollbar.Hover.Data.Color = color.RGBA{204, 204, 204, 255}
	style.Edit.Scrollbar.Active.Type = nstyle.ItemColor
	style.Edit.Scrollbar.Active.Data.Color = color.RGBA{204, 204, 204, 255}
	style.Edit.Scrollbar.BorderColor = color.RGBA{65, 65, 65, 255}
	style.Edit.Scrollbar.CursorNormal.Type = nstyle.ItemColor
	style.Edit.Scrollbar.CursorNormal.Data.Color = color.RGBA{64, 84, 95, 255}
	style.Edit.Scrollbar.CursorHover.Type = nstyle.ItemColor
	style.Edit.Scrollbar.CursorHover.Data.Color = color.RGBA{70, 90, 100, 255}
	style.Edit.Scrollbar.CursorActive.Type = nstyle.ItemColor
	style.Edit.Scrollbar.CursorActive.Data.Color = color.RGBA{75, 95, 105, 255}
	style.Edit.Scrollbar.Border = 1
	style.Edit.Scrollbar.Rounding = 0
	style.Edit.Scrollbar.Padding = image.Point{4, 4}
	style.Edit.Scrollbar.ShowButtons = false
	style.Edit.Scrollbar.IncButton.Normal.Type = nstyle.ItemColor
	style.Edit.Scrollbar.IncButton.Normal.Data.Color = color.RGBA{40, 40, 40, 255}
	style.Edit.Scrollbar.IncButton.Hover.Type = nstyle.ItemColor
	style.Edit.Scrollbar.IncButton.Hover.Data.Color = color.RGBA{42, 42, 42, 255}
	style.Edit.Scrollbar.IncButton.Active.Type = nstyle.ItemColor
	style.Edit.Scrollbar.IncButton.Active.Data.Color = color.RGBA{44, 44, 44, 255}
	style.Edit.Scrollbar.IncButton.BorderColor = color.RGBA{65, 65, 65, 255}
	style.Edit.Scrollbar.IncButton.TextBackground = color.RGBA{40, 40, 40, 255}
	style.Edit.Scrollbar.IncButton.TextNormal = color.RGBA{175, 175, 175, 255}
	style.Edit.Scrollbar.IncButton.TextHover = color.RGBA{175, 175, 175, 255}
	style.Edit.Scrollbar.IncButton.TextActive = color.RGBA{175, 175, 175, 255}
	style.Edit.Scrollbar.IncButton.Border = 1
	style.Edit.Scrollbar.IncButton.Rounding = 0
	style.Edit.Scrollbar.IncButton.Padding = image.Point{4, 4}
	style.Edit.Scrollbar.IncButton.ImagePadding = image.Point{0, 0}
	style.Edit.Scrollbar.IncButton.TouchPadding = image.Point{0, 0}
	style.Edit.Scrollbar.IncButton.SymbolBorderWidth = 0
	style.Edit.Scrollbar.DecButton.Normal.Type = nstyle.ItemColor
	style.Edit.Scrollbar.DecButton.Normal.Data.Color = color.RGBA{40, 40, 40, 255}
	style.Edit.Scrollbar.DecButton.Hover.Type = nstyle.ItemColor
	style.Edit.Scrollbar.DecButton.Hover.Data.Color = color.RGBA{42, 42, 42, 255}
	style.Edit.Scrollbar.DecButton.Active.Type = nstyle.ItemColor
	style.Edit.Scrollbar.DecButton.Active.Data.Color = color.RGBA{44, 44, 44, 255}
	style.Edit.Scrollbar.DecButton.BorderColor = color.RGBA{65, 65, 65, 255}
	style.Edit.Scrollbar.DecButton.TextBackground = color.RGBA{40, 40, 40, 255}
	style.Edit.Scrollbar.DecButton.TextNormal = color.RGBA{175, 175, 175, 255}
	style.Edit.Scrollbar.DecButton.TextHover = color.RGBA{175, 175, 175, 255}
	style.Edit.Scrollbar.DecButton.TextActive = color.RGBA{175, 175, 175, 255}
	style.Edit.Scrollbar.DecButton.Border = 1
	style.Edit.Scrollbar.DecButton.Rounding = 0
	style.Edit.Scrollbar.DecButton.Padding = image.Point{4, 4}
	style.Edit.Scrollbar.DecButton.ImagePadding = image.Point{0, 0}
	style.Edit.Scrollbar.DecButton.TouchPadding = image.Point{0, 0}
	style.Edit.Scrollbar.DecButton.SymbolBorderWidth = 0
	style.Edit.Scrollbar.IncSymbol = lbl.SymbolType(4)
	style.Edit.Scrollbar.DecSymbol = lbl.SymbolType(4)
	style.Edit.CursorNormal = color.RGBA{0, 0, 0, 112}
	style.Edit.CursorHover = color.RGBA{0, 0, 0, 112}
	style.Edit.CursorTextNormal = color.RGBA{0, 0, 0, 255}
	style.Edit.CursorTextHover = color.RGBA{0, 0, 0, 255}
	style.Edit.TextNormal = color.RGBA{0, 0, 0, 255}
	style.Edit.TextHover = color.RGBA{0, 0, 0, 255}
	style.Edit.TextActive = color.RGBA{0, 0, 0, 255}
	style.Edit.SelectedNormal = color.RGBA{114, 176, 252, 255}
	style.Edit.SelectedHover = color.RGBA{114, 176, 252, 255}
	style.Edit.SelectedTextNormal = color.RGBA{0, 0, 0, 255}
	style.Edit.SelectedTextHover = color.RGBA{0, 0, 0, 255}
	style.Edit.Border = 1
	style.Edit.Rounding = 0
	style.Edit.ScrollbarSize = image.Point{6, 6}
	style.Edit.Padding = image.Point{0, 0}
	style.Edit.RowPadding = 0
	style.Scrollh.Normal.Type = nstyle.ItemColor
	style.Scrollh.Normal.Data.Color = color.RGBA{189, 199, 207, 255}
	style.Scrollh.Hover.Type = nstyle.ItemColor
	style.Scrollh.Hover.Data.Color = color.RGBA{189, 199, 207, 255}
	style.Scrollh.Active.Type = nstyle.ItemColor
	style.Scrollh.Active.Data.Color = color.RGBA{189, 199, 207, 255}
	style.Scrollh.BorderColor = color.RGBA{65, 65, 65, 255}
	style.Scrollh.CursorNormal.Type = nstyle.ItemColor
	style.Scrollh.CursorNormal.Data.Color = color.RGBA{55, 94, 171, 255}
	style.Scrollh.CursorHover.Type = nstyle.ItemColor
	style.Scrollh.CursorHover.Data.Color = color.RGBA{55, 94, 171, 255}
	style.Scrollh.CursorActive.Type = nstyle.ItemColor
	style.Scrollh.CursorActive.Data.Color = color.RGBA{55, 94, 171, 255}
	style.Scrollh.Border = 0
	style.Scrollh.Rounding = 0
	style.Scrollh.Padding = image.Point{4, 4}
	style.Scrollh.ShowButtons = false
	style.Scrollh.IncButton.Normal.Type = nstyle.ItemColor
	style.Scrollh.IncButton.Normal.Data.Color = color.RGBA{40, 40, 40, 255}
	style.Scrollh.IncButton.Hover.Type = nstyle.ItemColor
	style.Scrollh.IncButton.Hover.Data.Color = color.RGBA{42, 42, 42, 255}
	style.Scrollh.IncButton.Active.Type = nstyle.ItemColor
	style.Scrollh.IncButton.Active.Data.Color = color.RGBA{44, 44, 44, 255}
	style.Scrollh.IncButton.BorderColor = color.RGBA{65, 65, 65, 255}
	style.Scrollh.IncButton.TextBackground = color.RGBA{40, 40, 40, 255}
	style.Scrollh.IncButton.TextNormal = color.RGBA{175, 175, 175, 255}
	style.Scrollh.IncButton.TextHover = color.RGBA{175, 175, 175, 255}
	style.Scrollh.IncButton.TextActive = color.RGBA{175, 175, 175, 255}
	style.Scrollh.IncButton.Border = 1
	style.Scrollh.IncButton.Rounding = 0
	style.Scrollh.IncButton.Padding = image.Point{4, 4}
	style.Scrollh.IncButton.ImagePadding = image.Point{0, 0}
	style.Scrollh.IncButton.TouchPadding = image.Point{0, 0}
	style.Scrollh.IncButton.SymbolBorderWidth = 0
	style.Scrollh.DecButton.Normal.Type = nstyle.ItemColor
	style.Scrollh.DecButton.Normal.Data.Color = color.RGBA{40, 40, 40, 255}
	style.Scrollh.DecButton.Hover.Type = nstyle.ItemColor
	style.Scrollh.DecButton.Hover.Data.Color = color.RGBA{42, 42, 42, 255}
	style.Scrollh.DecButton.Active.Type = nstyle.ItemColor
	style.Scrollh.DecButton.Active.Data.Color = color.RGBA{44, 44, 44, 255}
	style.Scrollh.DecButton.BorderColor = color.RGBA{65, 65, 65, 255}
	style.Scrollh.DecButton.TextBackground = color.RGBA{40, 40, 40, 255}
	style.Scrollh.DecButton.TextNormal = color.RGBA{175, 175, 175, 255}
	style.Scrollh.DecButton.TextHover = color.RGBA{175, 175, 175, 255}
	style.Scrollh.DecButton.TextActive = color.RGBA{175, 175, 175, 255}
	style.Scrollh.DecButton.Border = 1
	style.Scrollh.DecButton.Rounding = 0
	style.Scrollh.DecButton.Padding = image.Point{4, 4}
	style.Scrollh.DecButton.ImagePadding = image.Point{0, 0}
	style.Scrollh.DecButton.TouchPadding = image.Point{0, 0}
	style.Scrollh.DecButton.SymbolBorderWidth = 0
	style.Scrollh.IncSymbol = lbl.SymbolType(4)
	style.Scrollh.DecSymbol = lbl.SymbolType(4)
	style.Scrollv.Normal.Type = nstyle.ItemColor
	style.Scrollv.Normal.Data.Color = color.RGBA{189, 199, 207, 255}
	style.Scrollv.Hover.Type = nstyle.ItemColor
	style.Scrollv.Hover.Data.Color = color.RGBA{189, 199, 207, 255}
	style.Scrollv.Active.Type = nstyle.ItemColor
	style.Scrollv.Active.Data.Color = color.RGBA{189, 199, 207, 255}
	style.Scrollv.BorderColor = color.RGBA{65, 65, 65, 255}
	style.Scrollv.CursorNormal.Type = nstyle.ItemColor
	style.Scrollv.CursorNormal.Data.Color = color.RGBA{55, 94, 171, 255}
	style.Scrollv.CursorHover.Type = nstyle.ItemColor
	style.Scrollv.CursorHover.Data.Color = color.RGBA{55, 94, 171, 255}
	style.Scrollv.CursorActive.Type = nstyle.ItemColor
	style.Scrollv.CursorActive.Data.Color = color.RGBA{55, 94, 171, 255}
	style.Scrollv.Border = 0
	style.Scrollv.Rounding = 0
	style.Scrollv.Padding = image.Point{4, 4}
	style.Scrollv.ShowButtons = false
	style.Scrollv.IncButton.Normal.Type = nstyle.ItemColor
	style.Scrollv.IncButton.Normal.Data.Color = color.RGBA{40, 40, 40, 255}
	style.Scrollv.IncButton.Hover.Type = nstyle.ItemColor
	style.Scrollv.IncButton.Hover.Data.Color = color.RGBA{42, 42, 42, 255}
	style.Scrollv.IncButton.Active.Type = nstyle.ItemColor
	style.Scrollv.IncButton.Active.Data.Color = color.RGBA{44, 44, 44, 255}
	style.Scrollv.IncButton.BorderColor = color.RGBA{65, 65, 65, 255}
	style.Scrollv.IncButton.TextBackground = color.RGBA{40, 40, 40, 255}
	style.Scrollv.IncButton.TextNormal = color.RGBA{175, 175, 175, 255}
	style.Scrollv.IncButton.TextHover = color.RGBA{175, 175, 175, 255}
	style.Scrollv.IncButton.TextActive = color.RGBA{175, 175, 175, 255}
	style.Scrollv.IncButton.Border = 1
	style.Scrollv.IncButton.Rounding = 0
	style.Scrollv.IncButton.Padding = image.Point{4, 4}
	style.Scrollv.IncButton.ImagePadding = image.Point{0, 0}
	style.Scrollv.IncButton.TouchPadding = image.Point{0, 0}
	style.Scrollv.IncButton.SymbolBorderWidth = 0
	style.Scrollv.DecButton.Normal.Type = nstyle.ItemColor
	style.Scrollv.DecButton.Normal.Data.Color = color.RGBA{40, 40, 40, 255}
	style.Scrollv.DecButton.Hover.Type = nstyle.ItemColor
	style.Scrollv.DecButton.Hover.Data.Color = color.RGBA{42, 42, 42, 255}
	style.Scrollv.DecButton.Active.Type = nstyle.ItemColor
	style.Scrollv.DecButton.Active.Data.Color = color.RGBA{44, 44, 44, 255}
	style.Scrollv.DecButton.BorderColor = color.RGBA{65, 65, 65, 255}
	style.Scrollv.DecButton.TextBackground = color.RGBA{40, 40, 40, 255}
	style.Scrollv.DecButton.TextNormal = color.RGBA{175, 175, 175, 255}
	style.Scrollv.DecButton.TextHover = color.RGBA{175, 175, 175, 255}
	style.Scrollv.DecButton.TextActive = color.RGBA{175, 175, 175, 255}
	style.Scrollv.DecButton.Border = 1
	style.Scrollv.DecButton.Rounding = 0
	style.Scrollv.DecButton.Padding = image.Point{4, 4}
	style.Scrollv.DecButton.ImagePadding = image.Point{0, 0}
	style.Scrollv.DecButton.TouchPadding = image.Point{0, 0}
	style.Scrollv.DecButton.SymbolBorderWidth = 0
	style.Scrollv.IncSymbol = lbl.SymbolType(4)
	style.Scrollv.DecSymbol = lbl.SymbolType(4)
	style.Tab.Background.Type = nstyle.ItemColor
	style.Tab.Background.Data.Color = color.RGBA{75, 131, 233, 255}
	style.Tab.BorderColor = color.RGBA{0, 0, 0, 255}
	style.Tab.Text = color.RGBA{0, 0, 0, 255}
	style.Tab.TabButton.Normal.Type = nstyle.ItemColor
	style.Tab.TabButton.Normal.Data.Color = color.RGBA{75, 131, 233, 255}
	style.Tab.TabButton.Hover.Type = nstyle.ItemColor
	style.Tab.TabButton.Hover.Data.Color = color.RGBA{75, 131, 233, 255}
	style.Tab.TabButton.Active.Type = nstyle.ItemColor
	style.Tab.TabButton.Active.Data.Color = color.RGBA{75, 131, 233, 255}
	style.Tab.TabButton.BorderColor = color.RGBA{0, 0, 0, 0}
	style.Tab.TabButton.TextBackground = color.RGBA{181, 45, 69, 255}
	style.Tab.TabButton.TextNormal = color.RGBA{190, 190, 190, 255}
	style.Tab.TabButton.TextHover = color.RGBA{190, 190, 190, 255}
	style.Tab.TabButton.TextActive = color.RGBA{190, 190, 190, 255}
	style.Tab.TabButton.Border = 0
	style.Tab.TabButton.Rounding = 0
	style.Tab.TabButton.Padding = image.Point{2, 2}
	style.Tab.TabButton.ImagePadding = image.Point{0, 0}
	style.Tab.TabButton.TouchPadding = image.Point{0, 0}
	style.Tab.TabButton.SymbolBorderWidth = 2
	style.Tab.NodeButton.Normal.Type = nstyle.ItemColor
	style.Tab.NodeButton.Normal.Data.Color = color.RGBA{224, 235, 245, 255}
	style.Tab.NodeButton.Hover.Type = nstyle.ItemColor
	style.Tab.NodeButton.Hover.Data.Color = color.RGBA{224, 235, 245, 255}
	style.Tab.NodeButton.Active.Type = nstyle.ItemColor
	style.Tab.NodeButton.Active.Data.Color = color.RGBA{224, 235, 245, 255}
	style.Tab.NodeButton.BorderColor = color.RGBA{0, 0, 0, 0}
	style.Tab.NodeButton.TextBackground = color.RGBA{181, 45, 69, 255}
	style.Tab.NodeButton.TextNormal = color.RGBA{0, 0, 0, 255}
	style.Tab.NodeButton.TextHover = color.RGBA{0, 0, 0, 255}
	style.Tab.NodeButton.TextActive = color.RGBA{0, 0, 0, 255}
	style.Tab.NodeButton.Border = 0
	style.Tab.NodeButton.Rounding = 0
	style.Tab.NodeButton.Padding = image.Point{2, 2}
	style.Tab.NodeButton.ImagePadding = image.Point{0, 0}
	style.Tab.NodeButton.TouchPadding = image.Point{0, 0}
	style.Tab.NodeButton.SymbolBorderWidth = 2
	style.Tab.SymMinimize = lbl.SymbolType(8)
	style.Tab.SymMaximize = lbl.SymbolType(10)
	style.Tab.Border = 1
	style.Tab.Rounding = 0
	style.Tab.Padding = image.Point{4, 4}
	style.Tab.Spacing = image.Point{4, 4}
	style.Tab.Indent = 0
	style.Combo.Normal.Type = nstyle.ItemColor
	style.Combo.Normal.Data.Color = color.RGBA{55, 94, 171, 255}
	style.Combo.Hover.Type = nstyle.ItemColor
	style.Combo.Hover.Data.Color = color.RGBA{55, 94, 171, 255}
	style.Combo.Active.Type = nstyle.ItemColor
	style.Combo.Active.Data.Color = color.RGBA{55, 94, 171, 255}
	style.Combo.BorderColor = color.RGBA{0, 0, 0, 255}
	style.Combo.LabelNormal = color.RGBA{255, 255, 255, 255}
	style.Combo.LabelHover = color.RGBA{255, 255, 255, 255}
	style.Combo.LabelActive = color.RGBA{255, 255, 255, 255}
	style.Combo.SymbolNormal = color.RGBA{255, 255, 255, 255}
	style.Combo.SymbolHover = color.RGBA{255, 255, 255, 255}
	style.Combo.SymbolActive = color.RGBA{255, 255, 255, 255}
	style.Combo.Button.Normal.Type = nstyle.ItemColor
	style.Combo.Button.Normal.Data.Color = color.RGBA{55, 94, 171, 255}
	style.Combo.Button.Hover.Type = nstyle.ItemColor
	style.Combo.Button.Hover.Data.Color = color.RGBA{55, 94, 171, 255}
	style.Combo.Button.Active.Type = nstyle.ItemColor
	style.Combo.Button.Active.Data.Color = color.RGBA{55, 94, 171, 255}
	style.Combo.Button.BorderColor = color.RGBA{0, 0, 0, 0}
	style.Combo.Button.TextBackground = color.RGBA{51, 55, 67, 255}
	style.Combo.Button.TextNormal = color.RGBA{190, 190, 190, 255}
	style.Combo.Button.TextHover = color.RGBA{190, 190, 190, 255}
	style.Combo.Button.TextActive = color.RGBA{190, 190, 190, 255}
	style.Combo.Button.Border = 0
	style.Combo.Button.Rounding = 0
	style.Combo.Button.Padding = image.Point{2, 2}
	style.Combo.Button.ImagePadding = image.Point{0, 0}
	style.Combo.Button.TouchPadding = image.Point{0, 0}
	style.Combo.Button.SymbolBorderWidth = 1
	style.Combo.SymNormal = lbl.SymbolType(8)
	style.Combo.SymHover = lbl.SymbolType(8)
	style.Combo.SymActive = lbl.SymbolType(8)
	style.Combo.Border = 1
	style.Combo.Rounding = 0
	style.Combo.ContentPadding = image.Point{4, 4}
	style.Combo.ButtonPadding = image.Point{0, 4}
	style.Combo.Spacing = image.Point{4, 0}
	style.NormalWindow.Header.Normal.Type = nstyle.ItemColor
	style.NormalWindow.Header.Normal.Data.Color = color.RGBA{55, 94, 171, 255}
	style.NormalWindow.Header.Hover.Type = nstyle.ItemColor
	style.NormalWindow.Header.Hover.Data.Color = color.RGBA{55, 94, 171, 255}
	style.NormalWindow.Header.Active.Type = nstyle.ItemColor
	style.NormalWindow.Header.Active.Data.Color = color.RGBA{0x2e, 0x46, 0xf8, 0xff}
	style.NormalWindow.Header.CloseButton.Normal.Type = nstyle.ItemColor
	style.NormalWindow.Header.CloseButton.Normal.Data.Color = color.RGBA{55, 94, 171, 255}
	style.NormalWindow.Header.CloseButton.Hover.Type = nstyle.ItemColor
	style.NormalWindow.Header.CloseButton.Hover.Data.Color = color.RGBA{55, 94, 171, 255}
	style.NormalWindow.Header.CloseButton.Active.Type = nstyle.ItemColor
	style.NormalWindow.Header.CloseButton.Active.Data.Color = color.RGBA{55, 94, 171, 255}
	style.NormalWindow.Header.CloseButton.BorderColor = color.RGBA{0, 0, 0, 0}
	style.NormalWindow.Header.CloseButton.TextBackground = color.RGBA{181, 45, 69, 255}
	style.NormalWindow.Header.CloseButton.TextNormal = color.RGBA{255, 255, 255, 255}
	style.NormalWindow.Header.CloseButton.TextHover = color.RGBA{255, 255, 255, 255}
	style.NormalWindow.Header.CloseButton.TextActive = color.RGBA{255, 255, 255, 255}
	style.NormalWindow.Header.CloseButton.Border = 0
	style.NormalWindow.Header.CloseButton.Rounding = 0
	style.NormalWindow.Header.CloseButton.Padding = image.Point{0, 0}
	style.NormalWindow.Header.CloseButton.ImagePadding = image.Point{0, 0}
	style.NormalWindow.Header.CloseButton.TouchPadding = image.Point{0, 0}
	style.NormalWindow.Header.CloseButton.SymbolBorderWidth = 1
	style.NormalWindow.Header.MinimizeButton.Normal.Type = nstyle.ItemColor
	style.NormalWindow.Header.MinimizeButton.Normal.Data.Color = color.RGBA{181, 45, 69, 255}
	style.NormalWindow.Header.MinimizeButton.Hover.Type = nstyle.ItemColor
	style.NormalWindow.Header.MinimizeButton.Hover.Data.Color = color.RGBA{181, 45, 69, 255}
	style.NormalWindow.Header.MinimizeButton.Active.Type = nstyle.ItemColor
	style.NormalWindow.Header.MinimizeButton.Active.Data.Color = color.RGBA{181, 45, 69, 255}
	style.NormalWindow.Header.MinimizeButton.BorderColor = color.RGBA{0, 0, 0, 0}
	style.NormalWindow.Header.MinimizeButton.TextBackground = color.RGBA{181, 45, 69, 255}
	style.NormalWindow.Header.MinimizeButton.TextNormal = color.RGBA{190, 190, 190, 255}
	style.NormalWindow.Header.MinimizeButton.TextHover = color.RGBA{190, 190, 190, 255}
	style.NormalWindow.Header.MinimizeButton.TextActive = color.RGBA{190, 190, 190, 255}
	style.NormalWindow.Header.MinimizeButton.Border = 0
	style.NormalWindow.Header.MinimizeButton.Rounding = 0
	style.NormalWindow.Header.MinimizeButton.Padding = image.Point{0, 0}
	style.NormalWindow.Header.MinimizeButton.ImagePadding = image.Point{0, 0}
	style.NormalWindow.Header.MinimizeButton.TouchPadding = image.Point{0, 0}
	style.NormalWindow.Header.MinimizeButton.SymbolBorderWidth = 1
	style.NormalWindow.Header.CloseSymbol = lbl.SymbolType(1)
	style.NormalWindow.Header.MinimizeSymbol = lbl.SymbolType(12)
	style.NormalWindow.Header.MaximizeSymbol = lbl.SymbolType(11)
	style.NormalWindow.Header.LabelNormal = color.RGBA{255, 255, 255, 255}
	style.NormalWindow.Header.LabelHover = color.RGBA{255, 255, 255, 255}
	style.NormalWindow.Header.LabelActive = color.RGBA{255, 255, 255, 255}
	style.NormalWindow.Header.Align = nstyle.HeaderAlign(1)
	style.NormalWindow.Header.Padding = image.Point{2, 2}
	style.NormalWindow.Header.LabelPadding = image.Point{2, 2}
	style.NormalWindow.Header.Spacing = image.Point{0, 0}
	style.NormalWindow.FixedBackground.Type = nstyle.ItemColor
	style.NormalWindow.FixedBackground.Data.Color = color.RGBA{224, 235, 245, 255}
	style.NormalWindow.Background = color.RGBA{224, 235, 245, 255}
	style.NormalWindow.BorderColor = color.RGBA{51, 55, 67, 255}
	style.NormalWindow.Scaler.Type = nstyle.ItemColor
	style.NormalWindow.Scaler.Data.Color = color.RGBA{55, 94, 171, 255}
	style.NormalWindow.FooterPadding = image.Point{0, 0}
	style.NormalWindow.Border = 2
	style.NormalWindow.Rounding = 0
	style.NormalWindow.ScalerSize = image.Point{9, 9}
	style.NormalWindow.Padding = image.Point{4, 4}
	style.NormalWindow.Spacing = image.Point{4, 4}
	style.NormalWindow.ScrollbarSize = image.Point{10, 10}
	style.NormalWindow.MinSize = image.Point{64, 64}
	style.MenuWindow.Header.Normal.Type = nstyle.ItemColor
	style.MenuWindow.Header.Normal.Data.Color = color.RGBA{181, 45, 69, 255}
	style.MenuWindow.Header.Hover.Type = nstyle.ItemColor
	style.MenuWindow.Header.Hover.Data.Color = color.RGBA{181, 45, 69, 255}
	style.MenuWindow.Header.Active.Type = nstyle.ItemColor
	style.MenuWindow.Header.Active.Data.Color = color.RGBA{181, 45, 69, 255}
	style.MenuWindow.Header.CloseButton.Normal.Type = nstyle.ItemColor
	style.MenuWindow.Header.CloseButton.Normal.Data.Color = color.RGBA{181, 45, 69, 255}
	style.MenuWindow.Header.CloseButton.Hover.Type = nstyle.ItemColor
	style.MenuWindow.Header.CloseButton.Hover.Data.Color = color.RGBA{181, 45, 69, 255}
	style.MenuWindow.Header.CloseButton.Active.Type = nstyle.ItemColor
	style.MenuWindow.Header.CloseButton.Active.Data.Color = color.RGBA{181, 45, 69, 255}
	style.MenuWindow.Header.CloseButton.BorderColor = color.RGBA{0, 0, 0, 0}
	style.MenuWindow.Header.CloseButton.TextBackground = color.RGBA{181, 45, 69, 255}
	style.MenuWindow.Header.CloseButton.TextNormal = color.RGBA{190, 190, 190, 255}
	style.MenuWindow.Header.CloseButton.TextHover = color.RGBA{190, 190, 190, 255}
	style.MenuWindow.Header.CloseButton.TextActive = color.RGBA{190, 190, 190, 255}
	style.MenuWindow.Header.CloseButton.Border = 0
	style.MenuWindow.Header.CloseButton.Rounding = 0
	style.MenuWindow.Header.CloseButton.Padding = image.Point{0, 0}
	style.MenuWindow.Header.CloseButton.ImagePadding = image.Point{0, 0}
	style.MenuWindow.Header.CloseButton.TouchPadding = image.Point{0, 0}
	style.MenuWindow.Header.CloseButton.SymbolBorderWidth = 1
	style.MenuWindow.Header.MinimizeButton.Normal.Type = nstyle.ItemColor
	style.MenuWindow.Header.MinimizeButton.Normal.Data.Color = color.RGBA{181, 45, 69, 255}
	style.MenuWindow.Header.MinimizeButton.Hover.Type = nstyle.ItemColor
	style.MenuWindow.Header.MinimizeButton.Hover.Data.Color = color.RGBA{181, 45, 69, 255}
	style.MenuWindow.Header.MinimizeButton.Active.Type = nstyle.ItemColor
	style.MenuWindow.Header.MinimizeButton.Active.Data.Color = color.RGBA{181, 45, 69, 255}
	style.MenuWindow.Header.MinimizeButton.BorderColor = color.RGBA{0, 0, 0, 0}
	style.MenuWindow.Header.MinimizeButton.TextBackground = color.RGBA{181, 45, 69, 255}
	style.MenuWindow.Header.MinimizeButton.TextNormal = color.RGBA{190, 190, 190, 255}
	style.MenuWindow.Header.MinimizeButton.TextHover = color.RGBA{190, 190, 190, 255}
	style.MenuWindow.Header.MinimizeButton.TextActive = color.RGBA{190, 190, 190, 255}
	style.MenuWindow.Header.MinimizeButton.Border = 0
	style.MenuWindow.Header.MinimizeButton.Rounding = 0
	style.MenuWindow.Header.MinimizeButton.Padding = image.Point{0, 0}
	style.MenuWindow.Header.MinimizeButton.ImagePadding = image.Point{0, 0}
	style.MenuWindow.Header.MinimizeButton.TouchPadding = image.Point{0, 0}
	style.MenuWindow.Header.MinimizeButton.SymbolBorderWidth = 1
	style.MenuWindow.Header.CloseSymbol = lbl.SymbolType(1)
	style.MenuWindow.Header.MinimizeSymbol = lbl.SymbolType(12)
	style.MenuWindow.Header.MaximizeSymbol = lbl.SymbolType(11)
	style.MenuWindow.Header.LabelNormal = color.RGBA{190, 190, 190, 255}
	style.MenuWindow.Header.LabelHover = color.RGBA{190, 190, 190, 255}
	style.MenuWindow.Header.LabelActive = color.RGBA{190, 190, 190, 255}
	style.MenuWindow.Header.Align = nstyle.HeaderAlign(1)
	style.MenuWindow.Header.Padding = image.Point{2, 2}
	style.MenuWindow.Header.LabelPadding = image.Point{2, 2}
	style.MenuWindow.Header.Spacing = image.Point{0, 0}
	style.MenuWindow.FixedBackground.Type = nstyle.ItemColor
	style.MenuWindow.FixedBackground.Data.Color = color.RGBA{30, 33, 40, 255}
	style.MenuWindow.Background = color.RGBA{30, 33, 40, 255}
	style.MenuWindow.BorderColor = color.RGBA{51, 55, 67, 255}
	style.MenuWindow.Scaler.Type = nstyle.ItemColor
	style.MenuWindow.Scaler.Data.Color = color.RGBA{190, 190, 190, 255}
	style.MenuWindow.FooterPadding = image.Point{0, 0}
	style.MenuWindow.Border = 1
	style.MenuWindow.Rounding = 0
	style.MenuWindow.ScalerSize = image.Point{9, 9}
	style.MenuWindow.Padding = image.Point{4, 4}
	style.MenuWindow.Spacing = image.Point{2, 2}
	style.MenuWindow.ScrollbarSize = image.Point{10, 10}
	style.MenuWindow.MinSize = image.Point{64, 64}
	style.TooltipWindow.Header.Normal.Type = nstyle.ItemColor
	style.TooltipWindow.Header.Normal.Data.Color = color.RGBA{181, 45, 69, 255}
	style.TooltipWindow.Header.Hover.Type = nstyle.ItemColor
	style.TooltipWindow.Header.Hover.Data.Color = color.RGBA{181, 45, 69, 255}
	style.TooltipWindow.Header.Active.Type = nstyle.ItemColor
	style.TooltipWindow.Header.Active.Data.Color = color.RGBA{181, 45, 69, 255}
	style.TooltipWindow.Header.CloseButton.Normal.Type = nstyle.ItemColor
	style.TooltipWindow.Header.CloseButton.Normal.Data.Color = color.RGBA{181, 45, 69, 255}
	style.TooltipWindow.Header.CloseButton.Hover.Type = nstyle.ItemColor
	style.TooltipWindow.Header.CloseButton.Hover.Data.Color = color.RGBA{181, 45, 69, 255}
	style.TooltipWindow.Header.CloseButton.Active.Type = nstyle.ItemColor
	style.TooltipWindow.Header.CloseButton.Active.Data.Color = color.RGBA{181, 45, 69, 255}
	style.TooltipWindow.Header.CloseButton.BorderColor = color.RGBA{0, 0, 0, 0}
	style.TooltipWindow.Header.CloseButton.TextBackground = color.RGBA{181, 45, 69, 255}
	style.TooltipWindow.Header.CloseButton.TextNormal = color.RGBA{190, 190, 190, 255}
	style.TooltipWindow.Header.CloseButton.TextHover = color.RGBA{190, 190, 190, 255}
	style.TooltipWindow.Header.CloseButton.TextActive = color.RGBA{190, 190, 190, 255}
	style.TooltipWindow.Header.CloseButton.Border = 0
	style.TooltipWindow.Header.CloseButton.Rounding = 0
	style.TooltipWindow.Header.CloseButton.Padding = image.Point{0, 0}
	style.TooltipWindow.Header.CloseButton.ImagePadding = image.Point{0, 0}
	style.TooltipWindow.Header.CloseButton.TouchPadding = image.Point{0, 0}
	style.TooltipWindow.Header.CloseButton.SymbolBorderWidth = 1
	style.TooltipWindow.Header.MinimizeButton.Normal.Type = nstyle.ItemColor
	style.TooltipWindow.Header.MinimizeButton.Normal.Data.Color = color.RGBA{181, 45, 69, 255}
	style.TooltipWindow.Header.MinimizeButton.Hover.Type = nstyle.ItemColor
	style.TooltipWindow.Header.MinimizeButton.Hover.Data.Color = color.RGBA{181, 45, 69, 255}
	style.TooltipWindow.Header.MinimizeButton.Active.Type = nstyle.ItemColor
	style.TooltipWindow.Header.MinimizeButton.Active.Data.Color = color.RGBA{181, 45, 69, 255}
	style.TooltipWindow.Header.MinimizeButton.BorderColor = color.RGBA{0, 0, 0, 0}
	style.TooltipWindow.Header.MinimizeButton.TextBackground = color.RGBA{181, 45, 69, 255}
	style.TooltipWindow.Header.MinimizeButton.TextNormal = color.RGBA{190, 190, 190, 255}
	style.TooltipWindow.Header.MinimizeButton.TextHover = color.RGBA{190, 190, 190, 255}
	style.TooltipWindow.Header.MinimizeButton.TextActive = color.RGBA{190, 190, 190, 255}
	style.TooltipWindow.Header.MinimizeButton.Border = 0
	style.TooltipWindow.Header.MinimizeButton.Rounding = 0
	style.TooltipWindow.Header.MinimizeButton.Padding = image.Point{0, 0}
	style.TooltipWindow.Header.MinimizeButton.ImagePadding = image.Point{0, 0}
	style.TooltipWindow.Header.MinimizeButton.TouchPadding = image.Point{0, 0}
	style.TooltipWindow.Header.MinimizeButton.SymbolBorderWidth = 1
	style.TooltipWindow.Header.CloseSymbol = lbl.SymbolType(1)
	style.TooltipWindow.Header.MinimizeSymbol = lbl.SymbolType(12)
	style.TooltipWindow.Header.MaximizeSymbol = lbl.SymbolType(11)
	style.TooltipWindow.Header.LabelNormal = color.RGBA{190, 190, 190, 255}
	style.TooltipWindow.Header.LabelHover = color.RGBA{190, 190, 190, 255}
	style.TooltipWindow.Header.LabelActive = color.RGBA{190, 190, 190, 255}
	style.TooltipWindow.Header.Align = nstyle.HeaderAlign(1)
	style.TooltipWindow.Header.Padding = image.Point{2, 2}
	style.TooltipWindow.Header.LabelPadding = image.Point{2, 2}
	style.TooltipWindow.Header.Spacing = image.Point{0, 0}
	style.TooltipWindow.FixedBackground.Type = nstyle.ItemColor
	style.TooltipWindow.FixedBackground.Data.Color = color.RGBA{30, 33, 40, 255}
	style.TooltipWindow.Background = color.RGBA{30, 33, 40, 255}
	style.TooltipWindow.BorderColor = color.RGBA{51, 55, 67, 255}
	style.TooltipWindow.Scaler.Type = nstyle.ItemColor
	style.TooltipWindow.Scaler.Data.Color = color.RGBA{190, 190, 190, 255}
	style.TooltipWindow.FooterPadding = image.Point{0, 0}
	style.TooltipWindow.Border = 1
	style.TooltipWindow.Rounding = 0
	style.TooltipWindow.ScalerSize = image.Point{9, 9}
	style.TooltipWindow.Padding = image.Point{2, 2}
	style.TooltipWindow.Spacing = image.Point{4, 4}
	style.TooltipWindow.ScrollbarSize = image.Point{10, 10}
	style.TooltipWindow.MinSize = image.Point{64, 64}
	style.ComboWindow.Header.Normal.Type = nstyle.ItemColor
	style.ComboWindow.Header.Normal.Data.Color = color.RGBA{181, 45, 69, 255}
	style.ComboWindow.Header.Hover.Type = nstyle.ItemColor
	style.ComboWindow.Header.Hover.Data.Color = color.RGBA{181, 45, 69, 255}
	style.ComboWindow.Header.Active.Type = nstyle.ItemColor
	style.ComboWindow.Header.Active.Data.Color = color.RGBA{181, 45, 69, 255}
	style.ComboWindow.Header.CloseButton.Normal.Type = nstyle.ItemColor
	style.ComboWindow.Header.CloseButton.Normal.Data.Color = color.RGBA{181, 45, 69, 255}
	style.ComboWindow.Header.CloseButton.Hover.Type = nstyle.ItemColor
	style.ComboWindow.Header.CloseButton.Hover.Data.Color = color.RGBA{181, 45, 69, 255}
	style.ComboWindow.Header.CloseButton.Active.Type = nstyle.ItemColor
	style.ComboWindow.Header.CloseButton.Active.Data.Color = color.RGBA{181, 45, 69, 255}
	style.ComboWindow.Header.CloseButton.BorderColor = color.RGBA{0, 0, 0, 0}
	style.ComboWindow.Header.CloseButton.TextBackground = color.RGBA{181, 45, 69, 255}
	style.ComboWindow.Header.CloseButton.TextNormal = color.RGBA{190, 190, 190, 255}
	style.ComboWindow.Header.CloseButton.TextHover = color.RGBA{190, 190, 190, 255}
	style.ComboWindow.Header.CloseButton.TextActive = color.RGBA{190, 190, 190, 255}
	style.ComboWindow.Header.CloseButton.Border = 0
	style.ComboWindow.Header.CloseButton.Rounding = 0
	style.ComboWindow.Header.CloseButton.Padding = image.Point{0, 0}
	style.ComboWindow.Header.CloseButton.ImagePadding = image.Point{0, 0}
	style.ComboWindow.Header.CloseButton.TouchPadding = image.Point{0, 0}
	style.ComboWindow.Header.CloseButton.SymbolBorderWidth = 1
	style.ComboWindow.Header.MinimizeButton.Normal.Type = nstyle.ItemColor
	style.ComboWindow.Header.MinimizeButton.Normal.Data.Color = color.RGBA{181, 45, 69, 255}
	style.ComboWindow.Header.MinimizeButton.Hover.Type = nstyle.ItemColor
	style.ComboWindow.Header.MinimizeButton.Hover.Data.Color = color.RGBA{181, 45, 69, 255}
	style.ComboWindow.Header.MinimizeButton.Active.Type = nstyle.ItemColor
	style.ComboWindow.Header.MinimizeButton.Active.Data.Color = color.RGBA{181, 45, 69, 255}
	style.ComboWindow.Header.MinimizeButton.BorderColor = color.RGBA{0, 0, 0, 0}
	style.ComboWindow.Header.MinimizeButton.TextBackground = color.RGBA{181, 45, 69, 255}
	style.ComboWindow.Header.MinimizeButton.TextNormal = color.RGBA{190, 190, 190, 255}
	style.ComboWindow.Header.MinimizeButton.TextHover = color.RGBA{190, 190, 190, 255}
	style.ComboWindow.Header.MinimizeButton.TextActive = color.RGBA{190, 190, 190, 255}
	style.ComboWindow.Header.MinimizeButton.Border = 0
	style.ComboWindow.Header.MinimizeButton.Rounding = 0
	style.ComboWindow.Header.MinimizeButton.Padding = image.Point{0, 0}
	style.ComboWindow.Header.MinimizeButton.ImagePadding = image.Point{0, 0}
	style.ComboWindow.Header.MinimizeButton.TouchPadding = image.Point{0, 0}
	style.ComboWindow.Header.MinimizeButton.SymbolBorderWidth = 1
	style.ComboWindow.Header.CloseSymbol = lbl.SymbolType(1)
	style.ComboWindow.Header.MinimizeSymbol = lbl.SymbolType(12)
	style.ComboWindow.Header.MaximizeSymbol = lbl.SymbolType(11)
	style.ComboWindow.Header.LabelNormal = color.RGBA{212, 208, 200, 255}
	style.ComboWindow.Header.LabelHover = color.RGBA{212, 208, 200, 255}
	style.ComboWindow.Header.LabelActive = color.RGBA{212, 208, 200, 255}
	style.ComboWindow.Header.Align = nstyle.HeaderAlign(1)
	style.ComboWindow.Header.Padding = image.Point{2, 2}
	style.ComboWindow.Header.LabelPadding = image.Point{2, 2}
	style.ComboWindow.Header.Spacing = image.Point{0, 0}
	style.ComboWindow.FixedBackground.Type = nstyle.ItemColor
	style.ComboWindow.FixedBackground.Data.Color = color.RGBA{212, 208, 200, 255}
	style.ComboWindow.Background = color.RGBA{212, 208, 200, 255}
	style.ComboWindow.BorderColor = color.RGBA{0, 0, 0, 255}
	style.ComboWindow.Scaler.Type = nstyle.ItemColor
	style.ComboWindow.Scaler.Data.Color = color.RGBA{212, 208, 200, 255}
	style.ComboWindow.FooterPadding = image.Point{0, 0}
	style.ComboWindow.Border = 1
	style.ComboWindow.Rounding = 0
	style.ComboWindow.ScalerSize = image.Point{9, 9}
	style.ComboWindow.Padding = image.Point{4, 4}
	style.ComboWindow.Spacing = image.Point{4, 4}
	style.ComboWindow.ScrollbarSize = image.Point{10, 10}
	style.ComboWindow.MinSize = image.Point{64, 64}
	style.ContextualWindow.Header.Normal.Type = nstyle.ItemColor
	style.ContextualWindow.Header.Normal.Data.Color = color.RGBA{181, 45, 69, 255}
	style.ContextualWindow.Header.Hover.Type = nstyle.ItemColor
	style.ContextualWindow.Header.Hover.Data.Color = color.RGBA{181, 45, 69, 255}
	style.ContextualWindow.Header.Active.Type = nstyle.ItemColor
	style.ContextualWindow.Header.Active.Data.Color = color.RGBA{181, 45, 69, 255}
	style.ContextualWindow.Header.CloseButton.Normal.Type = nstyle.ItemColor
	style.ContextualWindow.Header.CloseButton.Normal.Data.Color = color.RGBA{181, 45, 69, 255}
	style.ContextualWindow.Header.CloseButton.Hover.Type = nstyle.ItemColor
	style.ContextualWindow.Header.CloseButton.Hover.Data.Color = color.RGBA{181, 45, 69, 255}
	style.ContextualWindow.Header.CloseButton.Active.Type = nstyle.ItemColor
	style.ContextualWindow.Header.CloseButton.Active.Data.Color = color.RGBA{181, 45, 69, 255}
	style.ContextualWindow.Header.CloseButton.BorderColor = color.RGBA{0, 0, 0, 0}
	style.ContextualWindow.Header.CloseButton.TextBackground = color.RGBA{181, 45, 69, 255}
	style.ContextualWindow.Header.CloseButton.TextNormal = color.RGBA{190, 190, 190, 255}
	style.ContextualWindow.Header.CloseButton.TextHover = color.RGBA{190, 190, 190, 255}
	style.ContextualWindow.Header.CloseButton.TextActive = color.RGBA{190, 190, 190, 255}
	style.ContextualWindow.Header.CloseButton.Border = 0
	style.ContextualWindow.Header.CloseButton.Rounding = 0
	style.ContextualWindow.Header.CloseButton.Padding = image.Point{0, 0}
	style.ContextualWindow.Header.CloseButton.ImagePadding = image.Point{0, 0}
	style.ContextualWindow.Header.CloseButton.TouchPadding = image.Point{0, 0}
	style.ContextualWindow.Header.CloseButton.SymbolBorderWidth = 1
	style.ContextualWindow.Header.MinimizeButton.Normal.Type = nstyle.ItemColor
	style.ContextualWindow.Header.MinimizeButton.Normal.Data.Color = color.RGBA{181, 45, 69, 255}
	style.ContextualWindow.Header.MinimizeButton.Hover.Type = nstyle.ItemColor
	style.ContextualWindow.Header.MinimizeButton.Hover.Data.Color = color.RGBA{181, 45, 69, 255}
	style.ContextualWindow.Header.MinimizeButton.Active.Type = nstyle.ItemColor
	style.ContextualWindow.Header.MinimizeButton.Active.Data.Color = color.RGBA{181, 45, 69, 255}
	style.ContextualWindow.Header.MinimizeButton.BorderColor = color.RGBA{0, 0, 0, 0}
	style.ContextualWindow.Header.MinimizeButton.TextBackground = color.RGBA{181, 45, 69, 255}
	style.ContextualWindow.Header.MinimizeButton.TextNormal = color.RGBA{190, 190, 190, 255}
	style.ContextualWindow.Header.MinimizeButton.TextHover = color.RGBA{190, 190, 190, 255}
	style.ContextualWindow.Header.MinimizeButton.TextActive = color.RGBA{190, 190, 190, 255}
	style.ContextualWindow.Header.MinimizeButton.Border = 0
	style.ContextualWindow.Header.MinimizeButton.Rounding = 0
	style.ContextualWindow.Header.MinimizeButton.Padding = image.Point{0, 0}
	style.ContextualWindow.Header.MinimizeButton.ImagePadding = image.Point{0, 0}
	style.ContextualWindow.Header.MinimizeButton.TouchPadding = image.Point{0, 0}
	style.ContextualWindow.Header.MinimizeButton.SymbolBorderWidth = 1
	style.ContextualWindow.Header.CloseSymbol = lbl.SymbolType(1)
	style.ContextualWindow.Header.MinimizeSymbol = lbl.SymbolType(12)
	style.ContextualWindow.Header.MaximizeSymbol = lbl.SymbolType(11)
	style.ContextualWindow.Header.LabelNormal = color.RGBA{190, 190, 190, 255}
	style.ContextualWindow.Header.LabelHover = color.RGBA{190, 190, 190, 255}
	style.ContextualWindow.Header.LabelActive = color.RGBA{190, 190, 190, 255}
	style.ContextualWindow.Header.Align = nstyle.HeaderAlign(1)
	style.ContextualWindow.Header.Padding = image.Point{2, 2}
	style.ContextualWindow.Header.LabelPadding = image.Point{2, 2}
	style.ContextualWindow.Header.Spacing = image.Point{0, 0}
	style.ContextualWindow.FixedBackground.Type = nstyle.ItemColor
	style.ContextualWindow.FixedBackground.Data.Color = color.RGBA{212, 208, 200, 255}
	style.ContextualWindow.Background = color.RGBA{212, 208, 200, 255}
	style.ContextualWindow.BorderColor = color.RGBA{109, 106, 103, 255}
	style.ContextualWindow.Scaler.Type = nstyle.ItemColor
	style.ContextualWindow.Scaler.Data.Color = color.RGBA{109, 106, 103, 255}
	style.ContextualWindow.FooterPadding = image.Point{0, 0}
	style.ContextualWindow.Border = 1
	style.ContextualWindow.Rounding = 1
	style.ContextualWindow.ScalerSize = image.Point{9, 9}
	style.ContextualWindow.Padding = image.Point{2, 2}
	style.ContextualWindow.Spacing = image.Point{2, 2}
	style.ContextualWindow.ScrollbarSize = image.Point{10, 10}
	style.ContextualWindow.MinSize = image.Point{64, 64}
	style.GroupWindow.Header.Normal.Type = nstyle.ItemColor
	style.GroupWindow.Header.Normal.Data.Color = color.RGBA{181, 45, 69, 255}
	style.GroupWindow.Header.Hover.Type = nstyle.ItemColor
	style.GroupWindow.Header.Hover.Data.Color = color.RGBA{181, 45, 69, 255}
	style.GroupWindow.Header.Active.Type = nstyle.ItemColor
	style.GroupWindow.Header.Active.Data.Color = color.RGBA{181, 45, 69, 255}
	style.GroupWindow.Header.CloseButton.Normal.Type = nstyle.ItemColor
	style.GroupWindow.Header.CloseButton.Normal.Data.Color = color.RGBA{181, 45, 69, 255}
	style.GroupWindow.Header.CloseButton.Hover.Type = nstyle.ItemColor
	style.GroupWindow.Header.CloseButton.Hover.Data.Color = color.RGBA{181, 45, 69, 255}
	style.GroupWindow.Header.CloseButton.Active.Type = nstyle.ItemColor
	style.GroupWindow.Header.CloseButton.Active.Data.Color = color.RGBA{181, 45, 69, 255}
	style.GroupWindow.Header.CloseButton.BorderColor = color.RGBA{0, 0, 0, 0}
	style.GroupWindow.Header.CloseButton.TextBackground = color.RGBA{181, 45, 69, 255}
	style.GroupWindow.Header.CloseButton.TextNormal = color.RGBA{190, 190, 190, 255}
	style.GroupWindow.Header.CloseButton.TextHover = color.RGBA{190, 190, 190, 255}
	style.GroupWindow.Header.CloseButton.TextActive = color.RGBA{190, 190, 190, 255}
	style.GroupWindow.Header.CloseButton.Border = 0
	style.GroupWindow.Header.CloseButton.Rounding = 0
	style.GroupWindow.Header.CloseButton.Padding = image.Point{0, 0}
	style.GroupWindow.Header.CloseButton.ImagePadding = image.Point{0, 0}
	style.GroupWindow.Header.CloseButton.TouchPadding = image.Point{0, 0}
	style.GroupWindow.Header.CloseButton.SymbolBorderWidth = 1
	style.GroupWindow.Header.MinimizeButton.Normal.Type = nstyle.ItemColor
	style.GroupWindow.Header.MinimizeButton.Normal.Data.Color = color.RGBA{181, 45, 69, 255}
	style.GroupWindow.Header.MinimizeButton.Hover.Type = nstyle.ItemColor
	style.GroupWindow.Header.MinimizeButton.Hover.Data.Color = color.RGBA{181, 45, 69, 255}
	style.GroupWindow.Header.MinimizeButton.Active.Type = nstyle.ItemColor
	style.GroupWindow.Header.MinimizeButton.Active.Data.Color = color.RGBA{181, 45, 69, 255}
	style.GroupWindow.Header.MinimizeButton.BorderColor = color.RGBA{0, 0, 0, 0}
	style.GroupWindow.Header.MinimizeButton.TextBackground = color.RGBA{181, 45, 69, 255}
	style.GroupWindow.Header.MinimizeButton.TextNormal = color.RGBA{190, 190, 190, 255}
	style.GroupWindow.Header.MinimizeButton.TextHover = color.RGBA{190, 190, 190, 255}
	style.GroupWindow.Header.MinimizeButton.TextActive = color.RGBA{190, 190, 190, 255}
	style.GroupWindow.Header.MinimizeButton.Border = 0
	style.GroupWindow.Header.MinimizeButton.Rounding = 0
	style.GroupWindow.Header.MinimizeButton.Padding = image.Point{0, 0}
	style.GroupWindow.Header.MinimizeButton.ImagePadding = image.Point{0, 0}
	style.GroupWindow.Header.MinimizeButton.TouchPadding = image.Point{0, 0}
	style.GroupWindow.Header.MinimizeButton.SymbolBorderWidth = 1
	style.GroupWindow.Header.CloseSymbol = lbl.SymbolType(1)
	style.GroupWindow.Header.MinimizeSymbol = lbl.SymbolType(12)
	style.GroupWindow.Header.MaximizeSymbol = lbl.SymbolType(11)
	style.GroupWindow.Header.LabelNormal = color.RGBA{190, 190, 190, 255}
	style.GroupWindow.Header.LabelHover = color.RGBA{190, 190, 190, 255}
	style.GroupWindow.Header.LabelActive = color.RGBA{190, 190, 190, 255}
	style.GroupWindow.Header.Align = nstyle.HeaderAlign(1)
	style.GroupWindow.Header.Padding = image.Point{2, 2}
	style.GroupWindow.Header.LabelPadding = image.Point{2, 2}
	style.GroupWindow.Header.Spacing = image.Point{0, 0}
	style.GroupWindow.FixedBackground.Type = nstyle.ItemColor
	style.GroupWindow.FixedBackground.Data.Color = color.RGBA{255, 255, 221, 255}
	style.GroupWindow.Background = color.RGBA{255, 255, 221, 255}
	style.GroupWindow.BorderColor = color.RGBA{51, 55, 67, 255}
	style.GroupWindow.Scaler.Type = nstyle.ItemColor
	style.GroupWindow.Scaler.Data.Color = color.RGBA{190, 190, 190, 255}
	style.GroupWindow.FooterPadding = image.Point{0, 0}
	style.GroupWindow.Border = 1
	style.GroupWindow.Rounding = 0
	style.GroupWindow.ScalerSize = image.Point{13, 13}
	style.GroupWindow.Padding = image.Point{0, 0}
	style.GroupWindow.Spacing = image.Point{2, 2}
	style.GroupWindow.ScrollbarSize = image.Point{9, 9}
	style.GroupWindow.MinSize = image.Point{64, 64}

	return style
}
