// Copyright 2021 Dolthub, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package altertests

import (
	"testing"
)

func TestModifyTypeTinyintUnsigned(t *testing.T) {
	SkipByDefaultInCI(t)
	tests := []ModifyTypeTest{
		{
			"TINYINT UNSIGNED",
			"TINYINT",
			"(0,0)",
			[]interface{}{int64(0)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"SMALLINT",
			"(0,0)",
			[]interface{}{int64(0)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"MEDIUMINT",
			"(0,0)",
			[]interface{}{int64(0)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"INT",
			"(0,0)",
			[]interface{}{int64(0)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"BIGINT",
			"(0,0)",
			[]interface{}{int64(0)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"SMALLINT UNSIGNED",
			"(0,0)",
			[]interface{}{uint64(0)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"MEDIUMINT UNSIGNED",
			"(0,0)",
			[]interface{}{uint64(0)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"INT UNSIGNED",
			"(0,0)",
			[]interface{}{uint64(0)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"BIGINT UNSIGNED",
			"(0,0)",
			[]interface{}{uint64(0)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"FLOAT",
			"(0,0)",
			[]interface{}{float64(0)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"DOUBLE",
			"(0,0)",
			[]interface{}{float64(0)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"DECIMAL(1,0)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"DECIMAL(15,0)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"DECIMAL(30,0)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"DECIMAL(65,0)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"DECIMAL(1,1)",
			"(0,0)",
			[]interface{}{"0.0"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"DECIMAL(15,1)",
			"(0,0)",
			[]interface{}{"0.0"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"DECIMAL(30,1)",
			"(0,0)",
			[]interface{}{"0.0"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"DECIMAL(65,1)",
			"(0,0)",
			[]interface{}{"0.0"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"DECIMAL(15,15)",
			"(0,0)",
			[]interface{}{"0.000000000000000"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"DECIMAL(30,15)",
			"(0,0)",
			[]interface{}{"0.000000000000000"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"DECIMAL(65,15)",
			"(0,0)",
			[]interface{}{"0.000000000000000"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"DECIMAL(30,30)",
			"(0,0)",
			[]interface{}{"0.000000000000000000000000000000"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"DECIMAL(65,30)",
			"(0,0)",
			[]interface{}{"0.000000000000000000000000000000"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"BIT(1)",
			"(0,0)",
			[]interface{}{uint64(0)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"BIT(8)",
			"(0,0)",
			[]interface{}{uint64(0)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"BIT(16)",
			"(0,0)",
			[]interface{}{uint64(0)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"BIT(24)",
			"(0,0)",
			[]interface{}{uint64(0)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"BIT(32)",
			"(0,0)",
			[]interface{}{uint64(0)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"BIT(48)",
			"(0,0)",
			[]interface{}{uint64(0)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"BIT(64)",
			"(0,0)",
			[]interface{}{uint64(0)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"TINYBLOB",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"BLOB",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"MEDIUMBLOB",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"LONGBLOB",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"TINYTEXT",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"TEXT",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"MEDIUMTEXT",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"LONGTEXT",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"CHAR(1)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"CHAR(10)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"CHAR(100)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"CHAR(255)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"BINARY(1)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"BINARY(10)",
			"(0,0)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"BINARY(100)",
			"(0,0)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"BINARY(255)",
			"(0,0)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"VARCHAR(1)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"VARCHAR(10)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"VARCHAR(100)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"VARCHAR(255)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"VARCHAR(1023)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"VARCHAR(4095)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"VARBINARY(1)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"VARBINARY(10)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"VARBINARY(100)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"VARBINARY(255)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"VARBINARY(1023)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"VARBINARY(4095)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"VARBINARY(16383)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"YEAR",
			"(0,0)",
			[]interface{}{int64(0)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"DATE",
			"(0,0)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"TIME",
			"(0,0)",
			[]interface{}{"00:00:00"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"TIMESTAMP",
			"(0,0)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"DATETIME",
			"(0,0)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"ENUM('A')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"ENUM('B')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"ENUM('C')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"ENUM('A','B')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"ENUM('A','C')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"ENUM('B','C')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"ENUM('A','B','C')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"ENUM('C','A','B')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"SET('A')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"SET('B')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"SET('C')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"SET('A','B')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"SET('A','C')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"SET('B','C')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"SET('A','B','C')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"SET('C','A','B')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"TINYINT",
			"(0,0), (1,1)",
			[]interface{}{int64(0), int64(1)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"SMALLINT",
			"(0,0), (1,1)",
			[]interface{}{int64(0), int64(1)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"MEDIUMINT",
			"(0,0), (1,1)",
			[]interface{}{int64(0), int64(1)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"INT",
			"(0,0), (1,1)",
			[]interface{}{int64(0), int64(1)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"BIGINT",
			"(0,0), (1,1)",
			[]interface{}{int64(0), int64(1)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"SMALLINT UNSIGNED",
			"(0,0), (1,1)",
			[]interface{}{uint64(0), uint64(1)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"MEDIUMINT UNSIGNED",
			"(0,0), (1,1)",
			[]interface{}{uint64(0), uint64(1)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"INT UNSIGNED",
			"(0,0), (1,1)",
			[]interface{}{uint64(0), uint64(1)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"BIGINT UNSIGNED",
			"(0,0), (1,1)",
			[]interface{}{uint64(0), uint64(1)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"FLOAT",
			"(0,0), (1,1)",
			[]interface{}{float64(0), float64(1)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"DOUBLE",
			"(0,0), (1,1)",
			[]interface{}{float64(0), float64(1)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"DECIMAL(1,0)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"DECIMAL(15,0)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"DECIMAL(30,0)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"DECIMAL(65,0)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"DECIMAL(1,1)",
			"(0,0), (1,1)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"DECIMAL(15,1)",
			"(0,0), (1,1)",
			[]interface{}{"0.0", "1.0"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"DECIMAL(30,1)",
			"(0,0), (1,1)",
			[]interface{}{"0.0", "1.0"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"DECIMAL(65,1)",
			"(0,0), (1,1)",
			[]interface{}{"0.0", "1.0"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"DECIMAL(15,15)",
			"(0,0), (1,1)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"DECIMAL(30,15)",
			"(0,0), (1,1)",
			[]interface{}{"0.000000000000000", "1.000000000000000"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"DECIMAL(65,15)",
			"(0,0), (1,1)",
			[]interface{}{"0.000000000000000", "1.000000000000000"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"DECIMAL(30,30)",
			"(0,0), (1,1)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"DECIMAL(65,30)",
			"(0,0), (1,1)",
			[]interface{}{"0.000000000000000000000000000000", "1.000000000000000000000000000000"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"BIT(1)",
			"(0,0), (1,1)",
			[]interface{}{uint64(0), uint64(1)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"BIT(8)",
			"(0,0), (1,1)",
			[]interface{}{uint64(0), uint64(1)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"BIT(16)",
			"(0,0), (1,1)",
			[]interface{}{uint64(0), uint64(1)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"BIT(24)",
			"(0,0), (1,1)",
			[]interface{}{uint64(0), uint64(1)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"BIT(32)",
			"(0,0), (1,1)",
			[]interface{}{uint64(0), uint64(1)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"BIT(48)",
			"(0,0), (1,1)",
			[]interface{}{uint64(0), uint64(1)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"BIT(64)",
			"(0,0), (1,1)",
			[]interface{}{uint64(0), uint64(1)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"TINYBLOB",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"BLOB",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"MEDIUMBLOB",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"LONGBLOB",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"TINYTEXT",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"TEXT",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"MEDIUMTEXT",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"LONGTEXT",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"CHAR(1)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"CHAR(10)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"CHAR(100)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"CHAR(255)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"BINARY(1)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"BINARY(10)",
			"(0,0), (1,1)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"BINARY(100)",
			"(0,0), (1,1)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"BINARY(255)",
			"(0,0), (1,1)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"VARCHAR(1)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"VARCHAR(10)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"VARCHAR(100)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"VARCHAR(255)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"VARCHAR(1023)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"VARCHAR(4095)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"VARBINARY(1)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"VARBINARY(10)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"VARBINARY(100)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"VARBINARY(255)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"VARBINARY(1023)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"VARBINARY(4095)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"VARBINARY(16383)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"YEAR",
			"(0,0), (1,1)",
			[]interface{}{int64(0), int64(2001)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"DATE",
			"(0,0), (1,1)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"TIME",
			"(0,0), (1,1)",
			[]interface{}{"00:00:00", "00:00:01"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"TIMESTAMP",
			"(0,0), (1,1)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"DATETIME",
			"(0,0), (1,1)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"ENUM('A')",
			"(0,0), (1,1)",
			[]interface{}{"", "A"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"ENUM('B')",
			"(0,0), (1,1)",
			[]interface{}{"", "B"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"ENUM('C')",
			"(0,0), (1,1)",
			[]interface{}{"", "C"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"ENUM('A','B')",
			"(0,0), (1,1)",
			[]interface{}{"", "A"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"ENUM('A','C')",
			"(0,0), (1,1)",
			[]interface{}{"", "A"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"ENUM('B','C')",
			"(0,0), (1,1)",
			[]interface{}{"", "B"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"ENUM('A','B','C')",
			"(0,0), (1,1)",
			[]interface{}{"", "A"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"ENUM('C','A','B')",
			"(0,0), (1,1)",
			[]interface{}{"", "C"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"SET('A')",
			"(0,0), (1,1)",
			[]interface{}{"", "A"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"SET('B')",
			"(0,0), (1,1)",
			[]interface{}{"", "B"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"SET('C')",
			"(0,0), (1,1)",
			[]interface{}{"", "C"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"SET('A','B')",
			"(0,0), (1,1)",
			[]interface{}{"", "A"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"SET('A','C')",
			"(0,0), (1,1)",
			[]interface{}{"", "A"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"SET('B','C')",
			"(0,0), (1,1)",
			[]interface{}{"", "B"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"SET('A','B','C')",
			"(0,0), (1,1)",
			[]interface{}{"", "A"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"SET('C','A','B')",
			"(0,0), (1,1)",
			[]interface{}{"", "C"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"TINYINT",
			"(0,0), (1,1), (2,2)",
			[]interface{}{int64(0), int64(1), int64(2)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"SMALLINT",
			"(0,0), (1,1), (2,2)",
			[]interface{}{int64(0), int64(1), int64(2)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"MEDIUMINT",
			"(0,0), (1,1), (2,2)",
			[]interface{}{int64(0), int64(1), int64(2)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"INT",
			"(0,0), (1,1), (2,2)",
			[]interface{}{int64(0), int64(1), int64(2)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"BIGINT",
			"(0,0), (1,1), (2,2)",
			[]interface{}{int64(0), int64(1), int64(2)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"SMALLINT UNSIGNED",
			"(0,0), (1,1), (2,2)",
			[]interface{}{uint64(0), uint64(1), uint64(2)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"MEDIUMINT UNSIGNED",
			"(0,0), (1,1), (2,2)",
			[]interface{}{uint64(0), uint64(1), uint64(2)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"INT UNSIGNED",
			"(0,0), (1,1), (2,2)",
			[]interface{}{uint64(0), uint64(1), uint64(2)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"BIGINT UNSIGNED",
			"(0,0), (1,1), (2,2)",
			[]interface{}{uint64(0), uint64(1), uint64(2)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"FLOAT",
			"(0,0), (1,1), (2,2)",
			[]interface{}{float64(0), float64(1), float64(2)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"DOUBLE",
			"(0,0), (1,1), (2,2)",
			[]interface{}{float64(0), float64(1), float64(2)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"DECIMAL(1,0)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"DECIMAL(15,0)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"DECIMAL(30,0)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"DECIMAL(65,0)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"DECIMAL(1,1)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"DECIMAL(15,1)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0.0", "1.0", "2.0"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"DECIMAL(30,1)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0.0", "1.0", "2.0"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"DECIMAL(65,1)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0.0", "1.0", "2.0"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"DECIMAL(15,15)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"DECIMAL(30,15)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"DECIMAL(65,15)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"DECIMAL(30,30)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"DECIMAL(65,30)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0.000000000000000000000000000000", "1.000000000000000000000000000000", "2.000000000000000000000000000000"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"BIT(1)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"BIT(8)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{uint64(0), uint64(1), uint64(2)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"BIT(16)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{uint64(0), uint64(1), uint64(2)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"BIT(24)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{uint64(0), uint64(1), uint64(2)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"BIT(32)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{uint64(0), uint64(1), uint64(2)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"BIT(48)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{uint64(0), uint64(1), uint64(2)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"BIT(64)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{uint64(0), uint64(1), uint64(2)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"TINYBLOB",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"BLOB",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"MEDIUMBLOB",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"LONGBLOB",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"TINYTEXT",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"TEXT",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"MEDIUMTEXT",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"LONGTEXT",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"CHAR(1)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"CHAR(10)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"CHAR(100)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"CHAR(255)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"BINARY(1)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"BINARY(10)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"BINARY(100)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"BINARY(255)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"VARCHAR(1)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"VARCHAR(10)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"VARCHAR(100)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"VARCHAR(255)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"VARCHAR(1023)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"VARCHAR(4095)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"VARBINARY(1)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"VARBINARY(10)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"VARBINARY(100)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"VARBINARY(255)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"VARBINARY(1023)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"VARBINARY(4095)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"VARBINARY(16383)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"YEAR",
			"(0,0), (1,1), (2,2)",
			[]interface{}{int64(0), int64(2001), int64(2002)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"DATE",
			"(0,0), (1,1), (2,2)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"TIME",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"00:00:00", "00:00:01", "00:00:02"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"TIMESTAMP",
			"(0,0), (1,1), (2,2)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"DATETIME",
			"(0,0), (1,1), (2,2)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"ENUM('A')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"ENUM('B')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"ENUM('C')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"ENUM('A','B')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"", "A", "B"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"ENUM('A','C')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"", "A", "C"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"ENUM('B','C')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"", "B", "C"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"ENUM('A','B','C')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"", "A", "B"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"ENUM('C','A','B')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"", "C", "A"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"SET('A')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"SET('B')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"SET('C')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"SET('A','B')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"", "A", "B"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"SET('A','C')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"", "A", "C"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"SET('B','C')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"", "B", "C"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"SET('A','B','C')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"", "A", "B"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"SET('C','A','B')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"", "C", "A"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"TINYINT",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"SMALLINT",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"MEDIUMINT",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"INT",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"BIGINT",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"SMALLINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"MEDIUMINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"INT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"BIGINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"FLOAT",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{float64(0), float64(1), float64(2), float64(15)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"DOUBLE",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{float64(0), float64(1), float64(2), float64(15)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"DECIMAL(1,0)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"DECIMAL(15,0)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"DECIMAL(30,0)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"DECIMAL(65,0)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"DECIMAL(1,1)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"DECIMAL(15,1)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"DECIMAL(30,1)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"DECIMAL(65,1)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"DECIMAL(15,15)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"DECIMAL(30,15)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"DECIMAL(65,15)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"DECIMAL(30,30)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"DECIMAL(65,30)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0.000000000000000000000000000000", "1.000000000000000000000000000000", "2.000000000000000000000000000000", "15.000000000000000000000000000000"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"BIT(1)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"BIT(8)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"BIT(16)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"BIT(24)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"BIT(32)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"BIT(48)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"BIT(64)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"TINYBLOB",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"BLOB",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"MEDIUMBLOB",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"LONGBLOB",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"TINYTEXT",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"TEXT",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"MEDIUMTEXT",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"LONGTEXT",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"CHAR(1)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"CHAR(10)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"CHAR(100)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"CHAR(255)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"BINARY(1)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"BINARY(10)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"BINARY(100)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"BINARY(255)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"VARCHAR(1)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"VARCHAR(10)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"VARCHAR(100)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"VARCHAR(255)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"VARCHAR(1023)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"VARCHAR(4095)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"VARBINARY(1)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"VARBINARY(10)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"VARBINARY(100)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"VARBINARY(255)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"VARBINARY(1023)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"VARBINARY(4095)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"VARBINARY(16383)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"YEAR",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{int64(0), int64(2001), int64(2002), int64(2015)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"DATE",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"TIME",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"00:00:00", "00:00:01", "00:00:02", "00:00:15"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"TIMESTAMP",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"DATETIME",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"ENUM('A')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"ENUM('B')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"ENUM('C')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"ENUM('A','B')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"ENUM('A','C')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"ENUM('B','C')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"ENUM('A','B','C')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"ENUM('C','A','B')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"SET('A')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"SET('B')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"SET('C')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"SET('A','B')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"SET('A','C')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"SET('B','C')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"SET('A','B','C')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"SET('C','A','B')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"TINYINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"SMALLINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"MEDIUMINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"INT",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"BIGINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"SMALLINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"MEDIUMINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"INT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"BIGINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"FLOAT",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{float64(0), float64(1), float64(2), float64(15), float64(127)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"DOUBLE",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{float64(0), float64(1), float64(2), float64(15), float64(127)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"DECIMAL(1,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"DECIMAL(15,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"DECIMAL(30,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"DECIMAL(65,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"DECIMAL(1,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"DECIMAL(15,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"DECIMAL(30,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"DECIMAL(65,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"DECIMAL(15,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"DECIMAL(30,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"DECIMAL(65,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"DECIMAL(30,30)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"DECIMAL(65,30)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0.000000000000000000000000000000", "1.000000000000000000000000000000", "2.000000000000000000000000000000", "15.000000000000000000000000000000", "127.000000000000000000000000000000"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"BIT(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"BIT(8)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"BIT(16)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"BIT(24)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"BIT(32)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"BIT(48)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"BIT(64)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"TINYBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"BLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"MEDIUMBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"LONGBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"TINYTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"TEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"MEDIUMTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"LONGTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"CHAR(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"CHAR(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"CHAR(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"CHAR(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"BINARY(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"BINARY(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"BINARY(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"BINARY(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"VARCHAR(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"VARCHAR(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"VARCHAR(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"VARCHAR(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"VARCHAR(1023)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"VARCHAR(4095)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"VARBINARY(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"VARBINARY(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"VARBINARY(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"VARBINARY(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"VARBINARY(1023)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"VARBINARY(4095)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"VARBINARY(16383)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"YEAR",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"DATE",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"TIME",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"00:00:00", "00:00:01", "00:00:02", "00:00:15", "00:01:27"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"TIMESTAMP",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"DATETIME",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"ENUM('A')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"ENUM('B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"ENUM('C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"ENUM('A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"ENUM('A','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"ENUM('B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"ENUM('A','B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"ENUM('C','A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"SET('A')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"SET('B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"SET('C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"SET('A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"SET('A','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"SET('B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"SET('A','B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"SET('C','A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"TINYINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"SMALLINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127), int64(255)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"MEDIUMINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127), int64(255)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"INT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127), int64(255)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"BIGINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127), int64(255)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"SMALLINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"MEDIUMINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"INT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"BIGINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"FLOAT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{float64(0), float64(1), float64(2), float64(15), float64(127), float64(255)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"DOUBLE",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{float64(0), float64(1), float64(2), float64(15), float64(127), float64(255)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"DECIMAL(1,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"DECIMAL(15,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"DECIMAL(30,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"DECIMAL(65,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"DECIMAL(1,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"DECIMAL(15,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0", "255.0"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"DECIMAL(30,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0", "255.0"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"DECIMAL(65,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0", "255.0"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"DECIMAL(15,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"DECIMAL(30,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"DECIMAL(65,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"DECIMAL(30,30)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"DECIMAL(65,30)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0.000000000000000000000000000000", "1.000000000000000000000000000000", "2.000000000000000000000000000000", "15.000000000000000000000000000000", "127.000000000000000000000000000000", "255.000000000000000000000000000000"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"BIT(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"BIT(8)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"BIT(16)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"BIT(24)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"BIT(32)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"BIT(48)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"BIT(64)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255)},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"TINYBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"BLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"MEDIUMBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"LONGBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"TINYTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"TEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"MEDIUMTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"LONGTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"CHAR(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"CHAR(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"CHAR(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"CHAR(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"BINARY(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"BINARY(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"BINARY(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"BINARY(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"VARCHAR(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"VARCHAR(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"VARCHAR(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"VARCHAR(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"VARCHAR(1023)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"VARCHAR(4095)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"VARBINARY(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"VARBINARY(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"VARBINARY(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"VARBINARY(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"VARBINARY(1023)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"VARBINARY(4095)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"VARBINARY(16383)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"YEAR",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"DATE",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"TIME",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"00:00:00", "00:00:01", "00:00:02", "00:00:15", "00:01:27", "00:02:55"},
			false,
		},
		{
			"TINYINT UNSIGNED",
			"TIMESTAMP",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"DATETIME",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"ENUM('A')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"ENUM('B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"ENUM('C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"ENUM('A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"ENUM('A','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"ENUM('B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"ENUM('A','B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"ENUM('C','A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"SET('A')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"SET('B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"SET('C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"SET('A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"SET('A','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"SET('B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"SET('A','B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"TINYINT UNSIGNED",
			"SET('C','A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
	}

	RunModifyTypeTests(t, tests)
}
