// Copyright 2021 Dolthub, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package altertests

import (
	"testing"
)

func TestModifyTypeSmallint(t *testing.T) {
	tests := []ModifyTypeTest{
		{
			"SMALLINT",
			"TINYINT",
			"(0,0)",
			[]interface{}{int64(0)},
			false,
		},
		{
			"SMALLINT",
			"MEDIUMINT",
			"(0,0)",
			[]interface{}{int64(0)},
			false,
		},
		{
			"SMALLINT",
			"INT",
			"(0,0)",
			[]interface{}{int64(0)},
			false,
		},
		{
			"SMALLINT",
			"BIGINT",
			"(0,0)",
			[]interface{}{int64(0)},
			false,
		},
		{
			"SMALLINT",
			"TINYINT UNSIGNED",
			"(0,0)",
			[]interface{}{uint64(0)},
			false,
		},
		{
			"SMALLINT",
			"SMALLINT UNSIGNED",
			"(0,0)",
			[]interface{}{uint64(0)},
			false,
		},
		{
			"SMALLINT",
			"MEDIUMINT UNSIGNED",
			"(0,0)",
			[]interface{}{uint64(0)},
			false,
		},
		{
			"SMALLINT",
			"INT UNSIGNED",
			"(0,0)",
			[]interface{}{uint64(0)},
			false,
		},
		{
			"SMALLINT",
			"BIGINT UNSIGNED",
			"(0,0)",
			[]interface{}{uint64(0)},
			false,
		},
		{
			"SMALLINT",
			"FLOAT",
			"(0,0)",
			[]interface{}{float64(0)},
			false,
		},
		{
			"SMALLINT",
			"DOUBLE",
			"(0,0)",
			[]interface{}{float64(0)},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(1,0)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(15,0)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(30,0)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(65,0)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(1,1)",
			"(0,0)",
			[]interface{}{"0.0"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(15,1)",
			"(0,0)",
			[]interface{}{"0.0"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(30,1)",
			"(0,0)",
			[]interface{}{"0.0"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(65,1)",
			"(0,0)",
			[]interface{}{"0.0"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(15,15)",
			"(0,0)",
			[]interface{}{"0.000000000000000"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(30,15)",
			"(0,0)",
			[]interface{}{"0.000000000000000"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(65,15)",
			"(0,0)",
			[]interface{}{"0.000000000000000"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(30,30)",
			"(0,0)",
			[]interface{}{"0.000000000000000000000000000000"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(65,30)",
			"(0,0)",
			[]interface{}{"0.000000000000000000000000000000"},
			false,
		},
		{
			"SMALLINT",
			"BIT(1)",
			"(0,0)",
			[]interface{}{uint64(0)},
			false,
		},
		{
			"SMALLINT",
			"BIT(8)",
			"(0,0)",
			[]interface{}{uint64(0)},
			false,
		},
		{
			"SMALLINT",
			"BIT(16)",
			"(0,0)",
			[]interface{}{uint64(0)},
			false,
		},
		{
			"SMALLINT",
			"BIT(24)",
			"(0,0)",
			[]interface{}{uint64(0)},
			false,
		},
		{
			"SMALLINT",
			"BIT(32)",
			"(0,0)",
			[]interface{}{uint64(0)},
			false,
		},
		{
			"SMALLINT",
			"BIT(48)",
			"(0,0)",
			[]interface{}{uint64(0)},
			false,
		},
		{
			"SMALLINT",
			"BIT(64)",
			"(0,0)",
			[]interface{}{uint64(0)},
			false,
		},
		{
			"SMALLINT",
			"TINYBLOB",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"SMALLINT",
			"BLOB",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"SMALLINT",
			"MEDIUMBLOB",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"SMALLINT",
			"LONGBLOB",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"SMALLINT",
			"TINYTEXT",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"SMALLINT",
			"TEXT",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"SMALLINT",
			"MEDIUMTEXT",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"SMALLINT",
			"LONGTEXT",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"SMALLINT",
			"CHAR(1)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"SMALLINT",
			"CHAR(10)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"SMALLINT",
			"CHAR(100)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"SMALLINT",
			"CHAR(255)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"SMALLINT",
			"BINARY(1)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"SMALLINT",
			"BINARY(10)",
			"(0,0)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"SMALLINT",
			"BINARY(100)",
			"(0,0)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"SMALLINT",
			"BINARY(255)",
			"(0,0)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"SMALLINT",
			"VARCHAR(1)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"SMALLINT",
			"VARCHAR(10)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"SMALLINT",
			"VARCHAR(100)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"SMALLINT",
			"VARCHAR(255)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"SMALLINT",
			"VARCHAR(1023)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"SMALLINT",
			"VARCHAR(4095)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"SMALLINT",
			"VARBINARY(1)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"SMALLINT",
			"VARBINARY(10)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"SMALLINT",
			"VARBINARY(100)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"SMALLINT",
			"VARBINARY(255)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"SMALLINT",
			"VARBINARY(1023)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"SMALLINT",
			"VARBINARY(4095)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"SMALLINT",
			"VARBINARY(16383)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"SMALLINT",
			"YEAR",
			"(0,0)",
			[]interface{}{int64(0)},
			false,
		},
		{
			"SMALLINT",
			"DATE",
			"(0,0)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"TIME",
			"(0,0)",
			[]interface{}{"00:00:00"},
			false,
		},
		{
			"SMALLINT",
			"TIMESTAMP",
			"(0,0)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"DATETIME",
			"(0,0)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('A')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"SMALLINT",
			"ENUM('B')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"SMALLINT",
			"ENUM('C')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"SMALLINT",
			"ENUM('A','B')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"SMALLINT",
			"ENUM('A','C')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"SMALLINT",
			"ENUM('B','C')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"SMALLINT",
			"ENUM('A','B','C')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"SMALLINT",
			"ENUM('C','A','B')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"SMALLINT",
			"SET('A')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"SMALLINT",
			"SET('B')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"SMALLINT",
			"SET('C')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"SMALLINT",
			"SET('A','B')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"SMALLINT",
			"SET('A','C')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"SMALLINT",
			"SET('B','C')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"SMALLINT",
			"SET('A','B','C')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"SMALLINT",
			"SET('C','A','B')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"SMALLINT",
			"TINYINT",
			"(0,0), (1,1)",
			[]interface{}{int64(0), int64(1)},
			false,
		},
		{
			"SMALLINT",
			"MEDIUMINT",
			"(0,0), (1,1)",
			[]interface{}{int64(0), int64(1)},
			false,
		},
		{
			"SMALLINT",
			"INT",
			"(0,0), (1,1)",
			[]interface{}{int64(0), int64(1)},
			false,
		},
		{
			"SMALLINT",
			"BIGINT",
			"(0,0), (1,1)",
			[]interface{}{int64(0), int64(1)},
			false,
		},
		{
			"SMALLINT",
			"TINYINT UNSIGNED",
			"(0,0), (1,1)",
			[]interface{}{uint64(0), uint64(1)},
			false,
		},
		{
			"SMALLINT",
			"SMALLINT UNSIGNED",
			"(0,0), (1,1)",
			[]interface{}{uint64(0), uint64(1)},
			false,
		},
		{
			"SMALLINT",
			"MEDIUMINT UNSIGNED",
			"(0,0), (1,1)",
			[]interface{}{uint64(0), uint64(1)},
			false,
		},
		{
			"SMALLINT",
			"INT UNSIGNED",
			"(0,0), (1,1)",
			[]interface{}{uint64(0), uint64(1)},
			false,
		},
		{
			"SMALLINT",
			"BIGINT UNSIGNED",
			"(0,0), (1,1)",
			[]interface{}{uint64(0), uint64(1)},
			false,
		},
		{
			"SMALLINT",
			"FLOAT",
			"(0,0), (1,1)",
			[]interface{}{float64(0), float64(1)},
			false,
		},
		{
			"SMALLINT",
			"DOUBLE",
			"(0,0), (1,1)",
			[]interface{}{float64(0), float64(1)},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(1,0)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(15,0)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(30,0)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(65,0)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(1,1)",
			"(0,0), (1,1)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"DECIMAL(15,1)",
			"(0,0), (1,1)",
			[]interface{}{"0.0", "1.0"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(30,1)",
			"(0,0), (1,1)",
			[]interface{}{"0.0", "1.0"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(65,1)",
			"(0,0), (1,1)",
			[]interface{}{"0.0", "1.0"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(15,15)",
			"(0,0), (1,1)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"DECIMAL(30,15)",
			"(0,0), (1,1)",
			[]interface{}{"0.000000000000000", "1.000000000000000"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(65,15)",
			"(0,0), (1,1)",
			[]interface{}{"0.000000000000000", "1.000000000000000"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(30,30)",
			"(0,0), (1,1)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"DECIMAL(65,30)",
			"(0,0), (1,1)",
			[]interface{}{"0.000000000000000000000000000000", "1.000000000000000000000000000000"},
			false,
		},
		{
			"SMALLINT",
			"BIT(1)",
			"(0,0), (1,1)",
			[]interface{}{uint64(0), uint64(1)},
			false,
		},
		{
			"SMALLINT",
			"BIT(8)",
			"(0,0), (1,1)",
			[]interface{}{uint64(0), uint64(1)},
			false,
		},
		{
			"SMALLINT",
			"BIT(16)",
			"(0,0), (1,1)",
			[]interface{}{uint64(0), uint64(1)},
			false,
		},
		{
			"SMALLINT",
			"BIT(24)",
			"(0,0), (1,1)",
			[]interface{}{uint64(0), uint64(1)},
			false,
		},
		{
			"SMALLINT",
			"BIT(32)",
			"(0,0), (1,1)",
			[]interface{}{uint64(0), uint64(1)},
			false,
		},
		{
			"SMALLINT",
			"BIT(48)",
			"(0,0), (1,1)",
			[]interface{}{uint64(0), uint64(1)},
			false,
		},
		{
			"SMALLINT",
			"BIT(64)",
			"(0,0), (1,1)",
			[]interface{}{uint64(0), uint64(1)},
			false,
		},
		{
			"SMALLINT",
			"TINYBLOB",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"SMALLINT",
			"BLOB",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"SMALLINT",
			"MEDIUMBLOB",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"SMALLINT",
			"LONGBLOB",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"SMALLINT",
			"TINYTEXT",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"SMALLINT",
			"TEXT",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"SMALLINT",
			"MEDIUMTEXT",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"SMALLINT",
			"LONGTEXT",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"SMALLINT",
			"CHAR(1)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"SMALLINT",
			"CHAR(10)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"SMALLINT",
			"CHAR(100)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"SMALLINT",
			"CHAR(255)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"SMALLINT",
			"BINARY(1)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"SMALLINT",
			"BINARY(10)",
			"(0,0), (1,1)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"SMALLINT",
			"BINARY(100)",
			"(0,0), (1,1)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"SMALLINT",
			"BINARY(255)",
			"(0,0), (1,1)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"SMALLINT",
			"VARCHAR(1)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"SMALLINT",
			"VARCHAR(10)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"SMALLINT",
			"VARCHAR(100)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"SMALLINT",
			"VARCHAR(255)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"SMALLINT",
			"VARCHAR(1023)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"SMALLINT",
			"VARCHAR(4095)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"SMALLINT",
			"VARBINARY(1)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"SMALLINT",
			"VARBINARY(10)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"SMALLINT",
			"VARBINARY(100)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"SMALLINT",
			"VARBINARY(255)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"SMALLINT",
			"VARBINARY(1023)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"SMALLINT",
			"VARBINARY(4095)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"SMALLINT",
			"VARBINARY(16383)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"SMALLINT",
			"YEAR",
			"(0,0), (1,1)",
			[]interface{}{int64(0), int64(2001)},
			false,
		},
		{
			"SMALLINT",
			"DATE",
			"(0,0), (1,1)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"TIME",
			"(0,0), (1,1)",
			[]interface{}{"00:00:00", "00:00:01"},
			false,
		},
		{
			"SMALLINT",
			"TIMESTAMP",
			"(0,0), (1,1)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"DATETIME",
			"(0,0), (1,1)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('A')",
			"(0,0), (1,1)",
			[]interface{}{"", "A"},
			false,
		},
		{
			"SMALLINT",
			"ENUM('B')",
			"(0,0), (1,1)",
			[]interface{}{"", "B"},
			false,
		},
		{
			"SMALLINT",
			"ENUM('C')",
			"(0,0), (1,1)",
			[]interface{}{"", "C"},
			false,
		},
		{
			"SMALLINT",
			"ENUM('A','B')",
			"(0,0), (1,1)",
			[]interface{}{"", "A"},
			false,
		},
		{
			"SMALLINT",
			"ENUM('A','C')",
			"(0,0), (1,1)",
			[]interface{}{"", "A"},
			false,
		},
		{
			"SMALLINT",
			"ENUM('B','C')",
			"(0,0), (1,1)",
			[]interface{}{"", "B"},
			false,
		},
		{
			"SMALLINT",
			"ENUM('A','B','C')",
			"(0,0), (1,1)",
			[]interface{}{"", "A"},
			false,
		},
		{
			"SMALLINT",
			"ENUM('C','A','B')",
			"(0,0), (1,1)",
			[]interface{}{"", "C"},
			false,
		},
		{
			"SMALLINT",
			"SET('A')",
			"(0,0), (1,1)",
			[]interface{}{"", "A"},
			false,
		},
		{
			"SMALLINT",
			"SET('B')",
			"(0,0), (1,1)",
			[]interface{}{"", "B"},
			false,
		},
		{
			"SMALLINT",
			"SET('C')",
			"(0,0), (1,1)",
			[]interface{}{"", "C"},
			false,
		},
		{
			"SMALLINT",
			"SET('A','B')",
			"(0,0), (1,1)",
			[]interface{}{"", "A"},
			false,
		},
		{
			"SMALLINT",
			"SET('A','C')",
			"(0,0), (1,1)",
			[]interface{}{"", "A"},
			false,
		},
		{
			"SMALLINT",
			"SET('B','C')",
			"(0,0), (1,1)",
			[]interface{}{"", "B"},
			false,
		},
		{
			"SMALLINT",
			"SET('A','B','C')",
			"(0,0), (1,1)",
			[]interface{}{"", "A"},
			false,
		},
		{
			"SMALLINT",
			"SET('C','A','B')",
			"(0,0), (1,1)",
			[]interface{}{"", "C"},
			false,
		},
		{
			"SMALLINT",
			"TINYINT",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{int64(-1), int64(0), int64(1)},
			false,
		},
		{
			"SMALLINT",
			"MEDIUMINT",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{int64(-1), int64(0), int64(1)},
			false,
		},
		{
			"SMALLINT",
			"INT",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{int64(-1), int64(0), int64(1)},
			false,
		},
		{
			"SMALLINT",
			"BIGINT",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{int64(-1), int64(0), int64(1)},
			false,
		},
		{
			"SMALLINT",
			"TINYINT UNSIGNED",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SMALLINT UNSIGNED",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"MEDIUMINT UNSIGNED",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"INT UNSIGNED",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"BIGINT UNSIGNED",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"FLOAT",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{float64(-1), float64(0), float64(1)},
			false,
		},
		{
			"SMALLINT",
			"DOUBLE",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{float64(-1), float64(0), float64(1)},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(1,0)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(15,0)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(30,0)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(65,0)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(1,1)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"DECIMAL(15,1)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1.0", "0.0", "1.0"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(30,1)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1.0", "0.0", "1.0"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(65,1)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1.0", "0.0", "1.0"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(15,15)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"DECIMAL(30,15)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1.000000000000000", "0.000000000000000", "1.000000000000000"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(65,15)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1.000000000000000", "0.000000000000000", "1.000000000000000"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(30,30)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"DECIMAL(65,30)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1.000000000000000000000000000000", "0.000000000000000000000000000000", "1.000000000000000000000000000000"},
			false,
		},
		{
			"SMALLINT",
			"BIT(1)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"BIT(8)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"BIT(16)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"BIT(24)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"BIT(32)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"BIT(48)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"BIT(64)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{uint64(18446744073709551615), uint64(0), uint64(1)},
			false,
		},
		{
			"SMALLINT",
			"TINYBLOB",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"SMALLINT",
			"BLOB",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"SMALLINT",
			"MEDIUMBLOB",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"SMALLINT",
			"LONGBLOB",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"SMALLINT",
			"TINYTEXT",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"SMALLINT",
			"TEXT",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"SMALLINT",
			"MEDIUMTEXT",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"SMALLINT",
			"LONGTEXT",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"SMALLINT",
			"CHAR(1)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"CHAR(10)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"SMALLINT",
			"CHAR(100)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"SMALLINT",
			"CHAR(255)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"SMALLINT",
			"BINARY(1)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"BINARY(10)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"SMALLINT",
			"BINARY(100)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"SMALLINT",
			"BINARY(255)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"SMALLINT",
			"VARCHAR(1)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"VARCHAR(10)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"SMALLINT",
			"VARCHAR(100)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"SMALLINT",
			"VARCHAR(255)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"SMALLINT",
			"VARCHAR(1023)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"SMALLINT",
			"VARCHAR(4095)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"SMALLINT",
			"VARBINARY(1)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"VARBINARY(10)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"SMALLINT",
			"VARBINARY(100)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"SMALLINT",
			"VARBINARY(255)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"SMALLINT",
			"VARBINARY(1023)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"SMALLINT",
			"VARBINARY(4095)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"SMALLINT",
			"VARBINARY(16383)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"SMALLINT",
			"YEAR",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"DATE",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"TIME",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-00:00:01", "00:00:00", "00:00:01"},
			false,
		},
		{
			"SMALLINT",
			"TIMESTAMP",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"DATETIME",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('A')",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('B')",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('C')",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('A','B')",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('A','C')",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('B','C')",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('A','B','C')",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('C','A','B')",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('A')",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('B')",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('C')",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('A','B')",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('A','C')",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('B','C')",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('A','B','C')",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('C','A','B')",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"TINYINT",
			"(0,0), (1,1), (2,2)",
			[]interface{}{int64(0), int64(1), int64(2)},
			false,
		},
		{
			"SMALLINT",
			"MEDIUMINT",
			"(0,0), (1,1), (2,2)",
			[]interface{}{int64(0), int64(1), int64(2)},
			false,
		},
		{
			"SMALLINT",
			"INT",
			"(0,0), (1,1), (2,2)",
			[]interface{}{int64(0), int64(1), int64(2)},
			false,
		},
		{
			"SMALLINT",
			"BIGINT",
			"(0,0), (1,1), (2,2)",
			[]interface{}{int64(0), int64(1), int64(2)},
			false,
		},
		{
			"SMALLINT",
			"TINYINT UNSIGNED",
			"(0,0), (1,1), (2,2)",
			[]interface{}{uint64(0), uint64(1), uint64(2)},
			false,
		},
		{
			"SMALLINT",
			"SMALLINT UNSIGNED",
			"(0,0), (1,1), (2,2)",
			[]interface{}{uint64(0), uint64(1), uint64(2)},
			false,
		},
		{
			"SMALLINT",
			"MEDIUMINT UNSIGNED",
			"(0,0), (1,1), (2,2)",
			[]interface{}{uint64(0), uint64(1), uint64(2)},
			false,
		},
		{
			"SMALLINT",
			"INT UNSIGNED",
			"(0,0), (1,1), (2,2)",
			[]interface{}{uint64(0), uint64(1), uint64(2)},
			false,
		},
		{
			"SMALLINT",
			"BIGINT UNSIGNED",
			"(0,0), (1,1), (2,2)",
			[]interface{}{uint64(0), uint64(1), uint64(2)},
			false,
		},
		{
			"SMALLINT",
			"FLOAT",
			"(0,0), (1,1), (2,2)",
			[]interface{}{float64(0), float64(1), float64(2)},
			false,
		},
		{
			"SMALLINT",
			"DOUBLE",
			"(0,0), (1,1), (2,2)",
			[]interface{}{float64(0), float64(1), float64(2)},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(1,0)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(15,0)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(30,0)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(65,0)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(1,1)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"DECIMAL(15,1)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0.0", "1.0", "2.0"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(30,1)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0.0", "1.0", "2.0"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(65,1)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0.0", "1.0", "2.0"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(15,15)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"DECIMAL(30,15)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(65,15)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(30,30)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"DECIMAL(65,30)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0.000000000000000000000000000000", "1.000000000000000000000000000000", "2.000000000000000000000000000000"},
			false,
		},
		{
			"SMALLINT",
			"BIT(1)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"BIT(8)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{uint64(0), uint64(1), uint64(2)},
			false,
		},
		{
			"SMALLINT",
			"BIT(16)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{uint64(0), uint64(1), uint64(2)},
			false,
		},
		{
			"SMALLINT",
			"BIT(24)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{uint64(0), uint64(1), uint64(2)},
			false,
		},
		{
			"SMALLINT",
			"BIT(32)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{uint64(0), uint64(1), uint64(2)},
			false,
		},
		{
			"SMALLINT",
			"BIT(48)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{uint64(0), uint64(1), uint64(2)},
			false,
		},
		{
			"SMALLINT",
			"BIT(64)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{uint64(0), uint64(1), uint64(2)},
			false,
		},
		{
			"SMALLINT",
			"TINYBLOB",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"SMALLINT",
			"BLOB",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"SMALLINT",
			"MEDIUMBLOB",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"SMALLINT",
			"LONGBLOB",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"SMALLINT",
			"TINYTEXT",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"SMALLINT",
			"TEXT",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"SMALLINT",
			"MEDIUMTEXT",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"SMALLINT",
			"LONGTEXT",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"SMALLINT",
			"CHAR(1)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"SMALLINT",
			"CHAR(10)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"SMALLINT",
			"CHAR(100)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"SMALLINT",
			"CHAR(255)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"SMALLINT",
			"BINARY(1)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"SMALLINT",
			"BINARY(10)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"SMALLINT",
			"BINARY(100)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"SMALLINT",
			"BINARY(255)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"SMALLINT",
			"VARCHAR(1)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"SMALLINT",
			"VARCHAR(10)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"SMALLINT",
			"VARCHAR(100)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"SMALLINT",
			"VARCHAR(255)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"SMALLINT",
			"VARCHAR(1023)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"SMALLINT",
			"VARCHAR(4095)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"SMALLINT",
			"VARBINARY(1)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"SMALLINT",
			"VARBINARY(10)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"SMALLINT",
			"VARBINARY(100)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"SMALLINT",
			"VARBINARY(255)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"SMALLINT",
			"VARBINARY(1023)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"SMALLINT",
			"VARBINARY(4095)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"SMALLINT",
			"VARBINARY(16383)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"SMALLINT",
			"YEAR",
			"(0,0), (1,1), (2,2)",
			[]interface{}{int64(0), int64(2001), int64(2002)},
			false,
		},
		{
			"SMALLINT",
			"DATE",
			"(0,0), (1,1), (2,2)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"TIME",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"00:00:00", "00:00:01", "00:00:02"},
			false,
		},
		{
			"SMALLINT",
			"TIMESTAMP",
			"(0,0), (1,1), (2,2)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"DATETIME",
			"(0,0), (1,1), (2,2)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('A')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('B')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('C')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('A','B')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"", "A", "B"},
			false,
		},
		{
			"SMALLINT",
			"ENUM('A','C')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"", "A", "C"},
			false,
		},
		{
			"SMALLINT",
			"ENUM('B','C')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"", "B", "C"},
			false,
		},
		{
			"SMALLINT",
			"ENUM('A','B','C')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"", "A", "B"},
			false,
		},
		{
			"SMALLINT",
			"ENUM('C','A','B')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"", "C", "A"},
			false,
		},
		{
			"SMALLINT",
			"SET('A')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('B')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('C')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('A','B')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"", "A", "B"},
			false,
		},
		{
			"SMALLINT",
			"SET('A','C')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"", "A", "C"},
			false,
		},
		{
			"SMALLINT",
			"SET('B','C')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"", "B", "C"},
			false,
		},
		{
			"SMALLINT",
			"SET('A','B','C')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"", "A", "B"},
			false,
		},
		{
			"SMALLINT",
			"SET('C','A','B')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"", "C", "A"},
			false,
		},
		{
			"SMALLINT",
			"TINYINT",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{int64(-2), int64(-1), int64(0), int64(1), int64(2)},
			false,
		},
		{
			"SMALLINT",
			"MEDIUMINT",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{int64(-2), int64(-1), int64(0), int64(1), int64(2)},
			false,
		},
		{
			"SMALLINT",
			"INT",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{int64(-2), int64(-1), int64(0), int64(1), int64(2)},
			false,
		},
		{
			"SMALLINT",
			"BIGINT",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{int64(-2), int64(-1), int64(0), int64(1), int64(2)},
			false,
		},
		{
			"SMALLINT",
			"TINYINT UNSIGNED",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SMALLINT UNSIGNED",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"MEDIUMINT UNSIGNED",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"INT UNSIGNED",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"BIGINT UNSIGNED",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"FLOAT",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{float64(-2), float64(-1), float64(0), float64(1), float64(2)},
			false,
		},
		{
			"SMALLINT",
			"DOUBLE",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{float64(-2), float64(-1), float64(0), float64(1), float64(2)},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(1,0)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(15,0)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(30,0)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(65,0)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(1,1)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"DECIMAL(15,1)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2.0", "-1.0", "0.0", "1.0", "2.0"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(30,1)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2.0", "-1.0", "0.0", "1.0", "2.0"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(65,1)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2.0", "-1.0", "0.0", "1.0", "2.0"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(15,15)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"DECIMAL(30,15)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2.000000000000000", "-1.000000000000000", "0.000000000000000", "1.000000000000000", "2.000000000000000"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(65,15)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2.000000000000000", "-1.000000000000000", "0.000000000000000", "1.000000000000000", "2.000000000000000"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(30,30)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"DECIMAL(65,30)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2.000000000000000000000000000000", "-1.000000000000000000000000000000", "0.000000000000000000000000000000", "1.000000000000000000000000000000", "2.000000000000000000000000000000"},
			false,
		},
		{
			"SMALLINT",
			"BIT(1)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"BIT(8)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"BIT(16)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"BIT(24)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"BIT(32)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"BIT(48)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"BIT(64)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{uint64(18446744073709551614), uint64(18446744073709551615), uint64(0), uint64(1), uint64(2)},
			false,
		},
		{
			"SMALLINT",
			"TINYBLOB",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"SMALLINT",
			"BLOB",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"SMALLINT",
			"MEDIUMBLOB",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"SMALLINT",
			"LONGBLOB",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"SMALLINT",
			"TINYTEXT",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"SMALLINT",
			"TEXT",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"SMALLINT",
			"MEDIUMTEXT",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"SMALLINT",
			"LONGTEXT",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"SMALLINT",
			"CHAR(1)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"CHAR(10)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"SMALLINT",
			"CHAR(100)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"SMALLINT",
			"CHAR(255)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"SMALLINT",
			"BINARY(1)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"BINARY(10)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"SMALLINT",
			"BINARY(100)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"SMALLINT",
			"BINARY(255)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"SMALLINT",
			"VARCHAR(1)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"VARCHAR(10)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"SMALLINT",
			"VARCHAR(100)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"SMALLINT",
			"VARCHAR(255)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"SMALLINT",
			"VARCHAR(1023)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"SMALLINT",
			"VARCHAR(4095)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"SMALLINT",
			"VARBINARY(1)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"VARBINARY(10)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"SMALLINT",
			"VARBINARY(100)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"SMALLINT",
			"VARBINARY(255)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"SMALLINT",
			"VARBINARY(1023)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"SMALLINT",
			"VARBINARY(4095)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"SMALLINT",
			"VARBINARY(16383)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"SMALLINT",
			"YEAR",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"DATE",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"TIME",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-00:00:02", "-00:00:01", "00:00:00", "00:00:01", "00:00:02"},
			false,
		},
		{
			"SMALLINT",
			"TIMESTAMP",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"DATETIME",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('A')",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('B')",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('C')",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('A','B')",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('A','C')",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('B','C')",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('A','B','C')",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('C','A','B')",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('A')",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('B')",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('C')",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('A','B')",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('A','C')",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('B','C')",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('A','B','C')",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('C','A','B')",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"TINYINT",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15)},
			false,
		},
		{
			"SMALLINT",
			"MEDIUMINT",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15)},
			false,
		},
		{
			"SMALLINT",
			"INT",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15)},
			false,
		},
		{
			"SMALLINT",
			"BIGINT",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15)},
			false,
		},
		{
			"SMALLINT",
			"TINYINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15)},
			false,
		},
		{
			"SMALLINT",
			"SMALLINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15)},
			false,
		},
		{
			"SMALLINT",
			"MEDIUMINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15)},
			false,
		},
		{
			"SMALLINT",
			"INT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15)},
			false,
		},
		{
			"SMALLINT",
			"BIGINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15)},
			false,
		},
		{
			"SMALLINT",
			"FLOAT",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{float64(0), float64(1), float64(2), float64(15)},
			false,
		},
		{
			"SMALLINT",
			"DOUBLE",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{float64(0), float64(1), float64(2), float64(15)},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(1,0)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"DECIMAL(15,0)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(30,0)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(65,0)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(1,1)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"DECIMAL(15,1)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(30,1)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(65,1)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(15,15)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"DECIMAL(30,15)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(65,15)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(30,30)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"DECIMAL(65,30)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0.000000000000000000000000000000", "1.000000000000000000000000000000", "2.000000000000000000000000000000", "15.000000000000000000000000000000"},
			false,
		},
		{
			"SMALLINT",
			"BIT(1)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"BIT(8)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15)},
			false,
		},
		{
			"SMALLINT",
			"BIT(16)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15)},
			false,
		},
		{
			"SMALLINT",
			"BIT(24)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15)},
			false,
		},
		{
			"SMALLINT",
			"BIT(32)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15)},
			false,
		},
		{
			"SMALLINT",
			"BIT(48)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15)},
			false,
		},
		{
			"SMALLINT",
			"BIT(64)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15)},
			false,
		},
		{
			"SMALLINT",
			"TINYBLOB",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"SMALLINT",
			"BLOB",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"SMALLINT",
			"MEDIUMBLOB",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"SMALLINT",
			"LONGBLOB",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"SMALLINT",
			"TINYTEXT",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"SMALLINT",
			"TEXT",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"SMALLINT",
			"MEDIUMTEXT",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"SMALLINT",
			"LONGTEXT",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"SMALLINT",
			"CHAR(1)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"CHAR(10)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"SMALLINT",
			"CHAR(100)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"SMALLINT",
			"CHAR(255)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"SMALLINT",
			"BINARY(1)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"BINARY(10)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"SMALLINT",
			"BINARY(100)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"SMALLINT",
			"BINARY(255)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"SMALLINT",
			"VARCHAR(1)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"VARCHAR(10)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"SMALLINT",
			"VARCHAR(100)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"SMALLINT",
			"VARCHAR(255)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"SMALLINT",
			"VARCHAR(1023)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"SMALLINT",
			"VARCHAR(4095)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"SMALLINT",
			"VARBINARY(1)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"VARBINARY(10)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"SMALLINT",
			"VARBINARY(100)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"SMALLINT",
			"VARBINARY(255)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"SMALLINT",
			"VARBINARY(1023)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"SMALLINT",
			"VARBINARY(4095)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"SMALLINT",
			"VARBINARY(16383)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"SMALLINT",
			"YEAR",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{int64(0), int64(2001), int64(2002), int64(2015)},
			false,
		},
		{
			"SMALLINT",
			"DATE",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"TIME",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"00:00:00", "00:00:01", "00:00:02", "00:00:15"},
			false,
		},
		{
			"SMALLINT",
			"TIMESTAMP",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"DATETIME",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('A')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('B')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('C')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('A','B')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('A','C')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('B','C')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('A','B','C')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('C','A','B')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('A')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('B')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('C')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('A','B')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('A','C')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('B','C')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('A','B','C')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('C','A','B')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"TINYINT",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{int64(-16), int64(-2), int64(-1), int64(0), int64(1), int64(2), int64(15)},
			false,
		},
		{
			"SMALLINT",
			"MEDIUMINT",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{int64(-16), int64(-2), int64(-1), int64(0), int64(1), int64(2), int64(15)},
			false,
		},
		{
			"SMALLINT",
			"INT",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{int64(-16), int64(-2), int64(-1), int64(0), int64(1), int64(2), int64(15)},
			false,
		},
		{
			"SMALLINT",
			"BIGINT",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{int64(-16), int64(-2), int64(-1), int64(0), int64(1), int64(2), int64(15)},
			false,
		},
		{
			"SMALLINT",
			"TINYINT UNSIGNED",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SMALLINT UNSIGNED",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"MEDIUMINT UNSIGNED",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"INT UNSIGNED",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"BIGINT UNSIGNED",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"FLOAT",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{float64(-16), float64(-2), float64(-1), float64(0), float64(1), float64(2), float64(15)},
			false,
		},
		{
			"SMALLINT",
			"DOUBLE",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{float64(-16), float64(-2), float64(-1), float64(0), float64(1), float64(2), float64(15)},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(1,0)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"DECIMAL(15,0)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(30,0)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(65,0)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(1,1)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"DECIMAL(15,1)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16.0", "-2.0", "-1.0", "0.0", "1.0", "2.0", "15.0"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(30,1)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16.0", "-2.0", "-1.0", "0.0", "1.0", "2.0", "15.0"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(65,1)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16.0", "-2.0", "-1.0", "0.0", "1.0", "2.0", "15.0"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(15,15)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"DECIMAL(30,15)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16.000000000000000", "-2.000000000000000", "-1.000000000000000", "0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(65,15)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16.000000000000000", "-2.000000000000000", "-1.000000000000000", "0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(30,30)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"DECIMAL(65,30)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16.000000000000000000000000000000", "-2.000000000000000000000000000000", "-1.000000000000000000000000000000", "0.000000000000000000000000000000", "1.000000000000000000000000000000", "2.000000000000000000000000000000", "15.000000000000000000000000000000"},
			false,
		},
		{
			"SMALLINT",
			"BIT(1)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"BIT(8)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"BIT(16)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"BIT(24)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"BIT(32)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"BIT(48)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"BIT(64)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{uint64(18446744073709551600), uint64(18446744073709551614), uint64(18446744073709551615), uint64(0), uint64(1), uint64(2), uint64(15)},
			false,
		},
		{
			"SMALLINT",
			"TINYBLOB",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"SMALLINT",
			"BLOB",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"SMALLINT",
			"MEDIUMBLOB",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"SMALLINT",
			"LONGBLOB",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"SMALLINT",
			"TINYTEXT",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"SMALLINT",
			"TEXT",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"SMALLINT",
			"MEDIUMTEXT",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"SMALLINT",
			"LONGTEXT",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"SMALLINT",
			"CHAR(1)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"CHAR(10)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"SMALLINT",
			"CHAR(100)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"SMALLINT",
			"CHAR(255)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"SMALLINT",
			"BINARY(1)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"BINARY(10)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16\x00\x00\x00\x00\x00\x00\x00", "-2\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"SMALLINT",
			"BINARY(100)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"SMALLINT",
			"BINARY(255)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"SMALLINT",
			"VARCHAR(1)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"VARCHAR(10)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"SMALLINT",
			"VARCHAR(100)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"SMALLINT",
			"VARCHAR(255)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"SMALLINT",
			"VARCHAR(1023)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"SMALLINT",
			"VARCHAR(4095)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"SMALLINT",
			"VARBINARY(1)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"VARBINARY(10)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"SMALLINT",
			"VARBINARY(100)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"SMALLINT",
			"VARBINARY(255)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"SMALLINT",
			"VARBINARY(1023)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"SMALLINT",
			"VARBINARY(4095)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"SMALLINT",
			"VARBINARY(16383)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"SMALLINT",
			"YEAR",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"DATE",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"TIME",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-00:00:16", "-00:00:02", "-00:00:01", "00:00:00", "00:00:01", "00:00:02", "00:00:15"},
			false,
		},
		{
			"SMALLINT",
			"TIMESTAMP",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"DATETIME",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('A')",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('B')",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('C')",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('A','B')",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('A','C')",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('B','C')",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('A','B','C')",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('C','A','B')",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('A')",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('B')",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('C')",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('A','B')",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('A','C')",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('B','C')",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('A','B','C')",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('C','A','B')",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"TINYINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127)},
			false,
		},
		{
			"SMALLINT",
			"MEDIUMINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127)},
			false,
		},
		{
			"SMALLINT",
			"INT",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127)},
			false,
		},
		{
			"SMALLINT",
			"BIGINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127)},
			false,
		},
		{
			"SMALLINT",
			"TINYINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127)},
			false,
		},
		{
			"SMALLINT",
			"SMALLINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127)},
			false,
		},
		{
			"SMALLINT",
			"MEDIUMINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127)},
			false,
		},
		{
			"SMALLINT",
			"INT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127)},
			false,
		},
		{
			"SMALLINT",
			"BIGINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127)},
			false,
		},
		{
			"SMALLINT",
			"FLOAT",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{float64(0), float64(1), float64(2), float64(15), float64(127)},
			false,
		},
		{
			"SMALLINT",
			"DOUBLE",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{float64(0), float64(1), float64(2), float64(15), float64(127)},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(1,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"DECIMAL(15,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(30,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(65,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(1,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"DECIMAL(15,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(30,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(65,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(15,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"DECIMAL(30,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(65,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(30,30)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"DECIMAL(65,30)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0.000000000000000000000000000000", "1.000000000000000000000000000000", "2.000000000000000000000000000000", "15.000000000000000000000000000000", "127.000000000000000000000000000000"},
			false,
		},
		{
			"SMALLINT",
			"BIT(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"BIT(8)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127)},
			false,
		},
		{
			"SMALLINT",
			"BIT(16)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127)},
			false,
		},
		{
			"SMALLINT",
			"BIT(24)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127)},
			false,
		},
		{
			"SMALLINT",
			"BIT(32)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127)},
			false,
		},
		{
			"SMALLINT",
			"BIT(48)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127)},
			false,
		},
		{
			"SMALLINT",
			"BIT(64)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127)},
			false,
		},
		{
			"SMALLINT",
			"TINYBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"SMALLINT",
			"BLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"SMALLINT",
			"MEDIUMBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"SMALLINT",
			"LONGBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"SMALLINT",
			"TINYTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"SMALLINT",
			"TEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"SMALLINT",
			"MEDIUMTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"SMALLINT",
			"LONGTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"SMALLINT",
			"CHAR(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"CHAR(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"SMALLINT",
			"CHAR(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"SMALLINT",
			"CHAR(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"SMALLINT",
			"BINARY(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"BINARY(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"SMALLINT",
			"BINARY(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"SMALLINT",
			"BINARY(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"SMALLINT",
			"VARCHAR(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"VARCHAR(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"SMALLINT",
			"VARCHAR(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"SMALLINT",
			"VARCHAR(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"SMALLINT",
			"VARCHAR(1023)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"SMALLINT",
			"VARCHAR(4095)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"SMALLINT",
			"VARBINARY(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"VARBINARY(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"SMALLINT",
			"VARBINARY(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"SMALLINT",
			"VARBINARY(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"SMALLINT",
			"VARBINARY(1023)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"SMALLINT",
			"VARBINARY(4095)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"SMALLINT",
			"VARBINARY(16383)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"SMALLINT",
			"YEAR",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"DATE",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"TIME",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"00:00:00", "00:00:01", "00:00:02", "00:00:15", "00:01:27"},
			false,
		},
		{
			"SMALLINT",
			"TIMESTAMP",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"DATETIME",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('A')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('A','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('A','B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('C','A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('A')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('A','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('A','B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('C','A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"TINYINT",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{int64(-128), int64(-16), int64(-2), int64(-1), int64(0), int64(1), int64(2), int64(15), int64(127)},
			false,
		},
		{
			"SMALLINT",
			"MEDIUMINT",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{int64(-128), int64(-16), int64(-2), int64(-1), int64(0), int64(1), int64(2), int64(15), int64(127)},
			false,
		},
		{
			"SMALLINT",
			"INT",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{int64(-128), int64(-16), int64(-2), int64(-1), int64(0), int64(1), int64(2), int64(15), int64(127)},
			false,
		},
		{
			"SMALLINT",
			"BIGINT",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{int64(-128), int64(-16), int64(-2), int64(-1), int64(0), int64(1), int64(2), int64(15), int64(127)},
			false,
		},
		{
			"SMALLINT",
			"TINYINT UNSIGNED",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SMALLINT UNSIGNED",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"MEDIUMINT UNSIGNED",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"INT UNSIGNED",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"BIGINT UNSIGNED",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"FLOAT",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{float64(-128), float64(-16), float64(-2), float64(-1), float64(0), float64(1), float64(2), float64(15), float64(127)},
			false,
		},
		{
			"SMALLINT",
			"DOUBLE",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{float64(-128), float64(-16), float64(-2), float64(-1), float64(0), float64(1), float64(2), float64(15), float64(127)},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(1,0)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"DECIMAL(15,0)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(30,0)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(65,0)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(1,1)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"DECIMAL(15,1)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128.0", "-16.0", "-2.0", "-1.0", "0.0", "1.0", "2.0", "15.0", "127.0"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(30,1)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128.0", "-16.0", "-2.0", "-1.0", "0.0", "1.0", "2.0", "15.0", "127.0"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(65,1)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128.0", "-16.0", "-2.0", "-1.0", "0.0", "1.0", "2.0", "15.0", "127.0"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(15,15)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"DECIMAL(30,15)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128.000000000000000", "-16.000000000000000", "-2.000000000000000", "-1.000000000000000", "0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(65,15)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128.000000000000000", "-16.000000000000000", "-2.000000000000000", "-1.000000000000000", "0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(30,30)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"DECIMAL(65,30)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128.000000000000000000000000000000", "-16.000000000000000000000000000000", "-2.000000000000000000000000000000", "-1.000000000000000000000000000000", "0.000000000000000000000000000000", "1.000000000000000000000000000000", "2.000000000000000000000000000000", "15.000000000000000000000000000000", "127.000000000000000000000000000000"},
			false,
		},
		{
			"SMALLINT",
			"BIT(1)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"BIT(8)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"BIT(16)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"BIT(24)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"BIT(32)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"BIT(48)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"BIT(64)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{uint64(18446744073709551488), uint64(18446744073709551600), uint64(18446744073709551614), uint64(18446744073709551615), uint64(0), uint64(1), uint64(2), uint64(15), uint64(127)},
			false,
		},
		{
			"SMALLINT",
			"TINYBLOB",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"SMALLINT",
			"BLOB",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"SMALLINT",
			"MEDIUMBLOB",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"SMALLINT",
			"LONGBLOB",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"SMALLINT",
			"TINYTEXT",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"SMALLINT",
			"TEXT",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"SMALLINT",
			"MEDIUMTEXT",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"SMALLINT",
			"LONGTEXT",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"SMALLINT",
			"CHAR(1)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"CHAR(10)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"SMALLINT",
			"CHAR(100)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"SMALLINT",
			"CHAR(255)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"SMALLINT",
			"BINARY(1)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"BINARY(10)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128\x00\x00\x00\x00\x00\x00", "-16\x00\x00\x00\x00\x00\x00\x00", "-2\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"SMALLINT",
			"BINARY(100)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-16\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"SMALLINT",
			"BINARY(255)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-16\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"SMALLINT",
			"VARCHAR(1)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"VARCHAR(10)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"SMALLINT",
			"VARCHAR(100)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"SMALLINT",
			"VARCHAR(255)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"SMALLINT",
			"VARCHAR(1023)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"SMALLINT",
			"VARCHAR(4095)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"SMALLINT",
			"VARBINARY(1)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"VARBINARY(10)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"SMALLINT",
			"VARBINARY(100)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"SMALLINT",
			"VARBINARY(255)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"SMALLINT",
			"VARBINARY(1023)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"SMALLINT",
			"VARBINARY(4095)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"SMALLINT",
			"VARBINARY(16383)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"SMALLINT",
			"YEAR",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"DATE",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"TIME",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-00:01:28", "-00:00:16", "-00:00:02", "-00:00:01", "00:00:00", "00:00:01", "00:00:02", "00:00:15", "00:01:27"},
			false,
		},
		{
			"SMALLINT",
			"TIMESTAMP",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"DATETIME",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('A')",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('B')",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('C')",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('A','B')",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('A','C')",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('B','C')",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('A','B','C')",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('C','A','B')",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('A')",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('B')",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('C')",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('A','B')",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('A','C')",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('B','C')",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('A','B','C')",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('C','A','B')",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"TINYINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"MEDIUMINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127), int64(255)},
			false,
		},
		{
			"SMALLINT",
			"INT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127), int64(255)},
			false,
		},
		{
			"SMALLINT",
			"BIGINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127), int64(255)},
			false,
		},
		{
			"SMALLINT",
			"TINYINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255)},
			false,
		},
		{
			"SMALLINT",
			"SMALLINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255)},
			false,
		},
		{
			"SMALLINT",
			"MEDIUMINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255)},
			false,
		},
		{
			"SMALLINT",
			"INT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255)},
			false,
		},
		{
			"SMALLINT",
			"BIGINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255)},
			false,
		},
		{
			"SMALLINT",
			"FLOAT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{float64(0), float64(1), float64(2), float64(15), float64(127), float64(255)},
			false,
		},
		{
			"SMALLINT",
			"DOUBLE",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{float64(0), float64(1), float64(2), float64(15), float64(127), float64(255)},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(1,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"DECIMAL(15,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(30,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(65,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(1,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"DECIMAL(15,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0", "255.0"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(30,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0", "255.0"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(65,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0", "255.0"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(15,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"DECIMAL(30,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(65,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(30,30)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"DECIMAL(65,30)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0.000000000000000000000000000000", "1.000000000000000000000000000000", "2.000000000000000000000000000000", "15.000000000000000000000000000000", "127.000000000000000000000000000000", "255.000000000000000000000000000000"},
			false,
		},
		{
			"SMALLINT",
			"BIT(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"BIT(8)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255)},
			false,
		},
		{
			"SMALLINT",
			"BIT(16)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255)},
			false,
		},
		{
			"SMALLINT",
			"BIT(24)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255)},
			false,
		},
		{
			"SMALLINT",
			"BIT(32)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255)},
			false,
		},
		{
			"SMALLINT",
			"BIT(48)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255)},
			false,
		},
		{
			"SMALLINT",
			"BIT(64)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255)},
			false,
		},
		{
			"SMALLINT",
			"TINYBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"SMALLINT",
			"BLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"SMALLINT",
			"MEDIUMBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"SMALLINT",
			"LONGBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"SMALLINT",
			"TINYTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"SMALLINT",
			"TEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"SMALLINT",
			"MEDIUMTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"SMALLINT",
			"LONGTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"SMALLINT",
			"CHAR(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"CHAR(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"SMALLINT",
			"CHAR(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"SMALLINT",
			"CHAR(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"SMALLINT",
			"BINARY(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"BINARY(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"SMALLINT",
			"BINARY(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"SMALLINT",
			"BINARY(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"SMALLINT",
			"VARCHAR(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"VARCHAR(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"SMALLINT",
			"VARCHAR(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"SMALLINT",
			"VARCHAR(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"SMALLINT",
			"VARCHAR(1023)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"SMALLINT",
			"VARCHAR(4095)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"SMALLINT",
			"VARBINARY(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"VARBINARY(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"SMALLINT",
			"VARBINARY(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"SMALLINT",
			"VARBINARY(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"SMALLINT",
			"VARBINARY(1023)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"SMALLINT",
			"VARBINARY(4095)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"SMALLINT",
			"VARBINARY(16383)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"SMALLINT",
			"YEAR",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"DATE",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"TIME",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"00:00:00", "00:00:01", "00:00:02", "00:00:15", "00:01:27", "00:02:55"},
			false,
		},
		{
			"SMALLINT",
			"TIMESTAMP",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"DATETIME",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('A')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('A','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('A','B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('C','A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('A')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('A','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('A','B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('C','A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"TINYINT",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"MEDIUMINT",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{int64(-256), int64(-128), int64(-16), int64(-2), int64(-1), int64(0), int64(1), int64(2), int64(15), int64(127), int64(255)},
			false,
		},
		{
			"SMALLINT",
			"INT",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{int64(-256), int64(-128), int64(-16), int64(-2), int64(-1), int64(0), int64(1), int64(2), int64(15), int64(127), int64(255)},
			false,
		},
		{
			"SMALLINT",
			"BIGINT",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{int64(-256), int64(-128), int64(-16), int64(-2), int64(-1), int64(0), int64(1), int64(2), int64(15), int64(127), int64(255)},
			false,
		},
		{
			"SMALLINT",
			"TINYINT UNSIGNED",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SMALLINT UNSIGNED",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"MEDIUMINT UNSIGNED",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"INT UNSIGNED",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"BIGINT UNSIGNED",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"FLOAT",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{float64(-256), float64(-128), float64(-16), float64(-2), float64(-1), float64(0), float64(1), float64(2), float64(15), float64(127), float64(255)},
			false,
		},
		{
			"SMALLINT",
			"DOUBLE",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{float64(-256), float64(-128), float64(-16), float64(-2), float64(-1), float64(0), float64(1), float64(2), float64(15), float64(127), float64(255)},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(1,0)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"DECIMAL(15,0)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(30,0)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(65,0)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(1,1)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"DECIMAL(15,1)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256.0", "-128.0", "-16.0", "-2.0", "-1.0", "0.0", "1.0", "2.0", "15.0", "127.0", "255.0"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(30,1)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256.0", "-128.0", "-16.0", "-2.0", "-1.0", "0.0", "1.0", "2.0", "15.0", "127.0", "255.0"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(65,1)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256.0", "-128.0", "-16.0", "-2.0", "-1.0", "0.0", "1.0", "2.0", "15.0", "127.0", "255.0"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(15,15)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"DECIMAL(30,15)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256.000000000000000", "-128.000000000000000", "-16.000000000000000", "-2.000000000000000", "-1.000000000000000", "0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(65,15)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256.000000000000000", "-128.000000000000000", "-16.000000000000000", "-2.000000000000000", "-1.000000000000000", "0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(30,30)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"DECIMAL(65,30)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256.000000000000000000000000000000", "-128.000000000000000000000000000000", "-16.000000000000000000000000000000", "-2.000000000000000000000000000000", "-1.000000000000000000000000000000", "0.000000000000000000000000000000", "1.000000000000000000000000000000", "2.000000000000000000000000000000", "15.000000000000000000000000000000", "127.000000000000000000000000000000", "255.000000000000000000000000000000"},
			false,
		},
		{
			"SMALLINT",
			"BIT(1)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"BIT(8)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"BIT(16)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"BIT(24)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"BIT(32)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"BIT(48)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"BIT(64)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{uint64(18446744073709551360), uint64(18446744073709551488), uint64(18446744073709551600), uint64(18446744073709551614), uint64(18446744073709551615), uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255)},
			false,
		},
		{
			"SMALLINT",
			"TINYBLOB",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"SMALLINT",
			"BLOB",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"SMALLINT",
			"MEDIUMBLOB",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"SMALLINT",
			"LONGBLOB",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"SMALLINT",
			"TINYTEXT",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"SMALLINT",
			"TEXT",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"SMALLINT",
			"MEDIUMTEXT",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"SMALLINT",
			"LONGTEXT",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"SMALLINT",
			"CHAR(1)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"CHAR(10)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"SMALLINT",
			"CHAR(100)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"SMALLINT",
			"CHAR(255)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"SMALLINT",
			"BINARY(1)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"BINARY(10)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256\x00\x00\x00\x00\x00\x00", "-128\x00\x00\x00\x00\x00\x00", "-16\x00\x00\x00\x00\x00\x00\x00", "-2\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"SMALLINT",
			"BINARY(100)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-128\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-16\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"SMALLINT",
			"BINARY(255)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-128\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-16\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"SMALLINT",
			"VARCHAR(1)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"VARCHAR(10)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"SMALLINT",
			"VARCHAR(100)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"SMALLINT",
			"VARCHAR(255)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"SMALLINT",
			"VARCHAR(1023)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"SMALLINT",
			"VARCHAR(4095)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"SMALLINT",
			"VARBINARY(1)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"VARBINARY(10)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"SMALLINT",
			"VARBINARY(100)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"SMALLINT",
			"VARBINARY(255)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"SMALLINT",
			"VARBINARY(1023)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"SMALLINT",
			"VARBINARY(4095)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"SMALLINT",
			"VARBINARY(16383)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"SMALLINT",
			"YEAR",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"DATE",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"TIME",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-00:02:56", "-00:01:28", "-00:00:16", "-00:00:02", "-00:00:01", "00:00:00", "00:00:01", "00:00:02", "00:00:15", "00:01:27", "00:02:55"},
			false,
		},
		{
			"SMALLINT",
			"TIMESTAMP",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"DATETIME",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('A')",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('B')",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('C')",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('A','B')",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('A','C')",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('B','C')",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('A','B','C')",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('C','A','B')",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('A')",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('B')",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('C')",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('A','B')",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('A','C')",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('B','C')",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('A','B','C')",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('C','A','B')",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"TINYINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"MEDIUMINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127), int64(255), int64(4095)},
			false,
		},
		{
			"SMALLINT",
			"INT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127), int64(255), int64(4095)},
			false,
		},
		{
			"SMALLINT",
			"BIGINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127), int64(255), int64(4095)},
			false,
		},
		{
			"SMALLINT",
			"TINYINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SMALLINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095)},
			false,
		},
		{
			"SMALLINT",
			"MEDIUMINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095)},
			false,
		},
		{
			"SMALLINT",
			"INT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095)},
			false,
		},
		{
			"SMALLINT",
			"BIGINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095)},
			false,
		},
		{
			"SMALLINT",
			"FLOAT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{float64(0), float64(1), float64(2), float64(15), float64(127), float64(255), float64(4095)},
			false,
		},
		{
			"SMALLINT",
			"DOUBLE",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{float64(0), float64(1), float64(2), float64(15), float64(127), float64(255), float64(4095)},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(1,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"DECIMAL(15,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(30,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(65,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(1,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"DECIMAL(15,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(30,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(65,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(15,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"DECIMAL(30,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000", "4095.000000000000000"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(65,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000", "4095.000000000000000"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(30,30)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"DECIMAL(65,30)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0.000000000000000000000000000000", "1.000000000000000000000000000000", "2.000000000000000000000000000000", "15.000000000000000000000000000000", "127.000000000000000000000000000000", "255.000000000000000000000000000000", "4095.000000000000000000000000000000"},
			false,
		},
		{
			"SMALLINT",
			"BIT(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"BIT(8)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"BIT(16)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095)},
			false,
		},
		{
			"SMALLINT",
			"BIT(24)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095)},
			false,
		},
		{
			"SMALLINT",
			"BIT(32)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095)},
			false,
		},
		{
			"SMALLINT",
			"BIT(48)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095)},
			false,
		},
		{
			"SMALLINT",
			"BIT(64)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095)},
			false,
		},
		{
			"SMALLINT",
			"TINYBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"SMALLINT",
			"BLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"SMALLINT",
			"MEDIUMBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"SMALLINT",
			"LONGBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"SMALLINT",
			"TINYTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"SMALLINT",
			"TEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"SMALLINT",
			"MEDIUMTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"SMALLINT",
			"LONGTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"SMALLINT",
			"CHAR(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"CHAR(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"SMALLINT",
			"CHAR(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"SMALLINT",
			"CHAR(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"SMALLINT",
			"BINARY(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"BINARY(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"SMALLINT",
			"BINARY(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"SMALLINT",
			"BINARY(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"SMALLINT",
			"VARCHAR(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"VARCHAR(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"SMALLINT",
			"VARCHAR(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"SMALLINT",
			"VARCHAR(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"SMALLINT",
			"VARCHAR(1023)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"SMALLINT",
			"VARCHAR(4095)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"SMALLINT",
			"VARBINARY(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"VARBINARY(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"SMALLINT",
			"VARBINARY(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"SMALLINT",
			"VARBINARY(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"SMALLINT",
			"VARBINARY(1023)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"SMALLINT",
			"VARBINARY(4095)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"SMALLINT",
			"VARBINARY(16383)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"SMALLINT",
			"YEAR",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"DATE",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"TIME",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"TIMESTAMP",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"DATETIME",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('A')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('A','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('A','B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('C','A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('A')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('A','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('A','B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('C','A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"TINYINT",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"MEDIUMINT",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{int64(-4096), int64(-256), int64(-128), int64(-16), int64(-2), int64(-1), int64(0), int64(1), int64(2), int64(15), int64(127), int64(255), int64(4095)},
			false,
		},
		{
			"SMALLINT",
			"INT",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{int64(-4096), int64(-256), int64(-128), int64(-16), int64(-2), int64(-1), int64(0), int64(1), int64(2), int64(15), int64(127), int64(255), int64(4095)},
			false,
		},
		{
			"SMALLINT",
			"BIGINT",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{int64(-4096), int64(-256), int64(-128), int64(-16), int64(-2), int64(-1), int64(0), int64(1), int64(2), int64(15), int64(127), int64(255), int64(4095)},
			false,
		},
		{
			"SMALLINT",
			"TINYINT UNSIGNED",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SMALLINT UNSIGNED",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"MEDIUMINT UNSIGNED",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"INT UNSIGNED",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"BIGINT UNSIGNED",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"FLOAT",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{float64(-4096), float64(-256), float64(-128), float64(-16), float64(-2), float64(-1), float64(0), float64(1), float64(2), float64(15), float64(127), float64(255), float64(4095)},
			false,
		},
		{
			"SMALLINT",
			"DOUBLE",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{float64(-4096), float64(-256), float64(-128), float64(-16), float64(-2), float64(-1), float64(0), float64(1), float64(2), float64(15), float64(127), float64(255), float64(4095)},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(1,0)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"DECIMAL(15,0)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(30,0)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(65,0)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(1,1)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"DECIMAL(15,1)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096.0", "-256.0", "-128.0", "-16.0", "-2.0", "-1.0", "0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(30,1)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096.0", "-256.0", "-128.0", "-16.0", "-2.0", "-1.0", "0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(65,1)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096.0", "-256.0", "-128.0", "-16.0", "-2.0", "-1.0", "0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(15,15)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"DECIMAL(30,15)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096.000000000000000", "-256.000000000000000", "-128.000000000000000", "-16.000000000000000", "-2.000000000000000", "-1.000000000000000", "0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000", "4095.000000000000000"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(65,15)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096.000000000000000", "-256.000000000000000", "-128.000000000000000", "-16.000000000000000", "-2.000000000000000", "-1.000000000000000", "0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000", "4095.000000000000000"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(30,30)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"DECIMAL(65,30)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096.000000000000000000000000000000", "-256.000000000000000000000000000000", "-128.000000000000000000000000000000", "-16.000000000000000000000000000000", "-2.000000000000000000000000000000", "-1.000000000000000000000000000000", "0.000000000000000000000000000000", "1.000000000000000000000000000000", "2.000000000000000000000000000000", "15.000000000000000000000000000000", "127.000000000000000000000000000000", "255.000000000000000000000000000000", "4095.000000000000000000000000000000"},
			false,
		},
		{
			"SMALLINT",
			"BIT(1)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"BIT(8)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"BIT(16)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"BIT(24)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"BIT(32)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"BIT(48)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"BIT(64)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{uint64(18446744073709547520), uint64(18446744073709551360), uint64(18446744073709551488), uint64(18446744073709551600), uint64(18446744073709551614), uint64(18446744073709551615), uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095)},
			false,
		},
		{
			"SMALLINT",
			"TINYBLOB",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"SMALLINT",
			"BLOB",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"SMALLINT",
			"MEDIUMBLOB",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"SMALLINT",
			"LONGBLOB",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"SMALLINT",
			"TINYTEXT",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"SMALLINT",
			"TEXT",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"SMALLINT",
			"MEDIUMTEXT",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"SMALLINT",
			"LONGTEXT",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"SMALLINT",
			"CHAR(1)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"CHAR(10)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"SMALLINT",
			"CHAR(100)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"SMALLINT",
			"CHAR(255)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"SMALLINT",
			"BINARY(1)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"BINARY(10)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096\x00\x00\x00\x00\x00", "-256\x00\x00\x00\x00\x00\x00", "-128\x00\x00\x00\x00\x00\x00", "-16\x00\x00\x00\x00\x00\x00\x00", "-2\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"SMALLINT",
			"BINARY(100)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-256\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-128\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-16\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"SMALLINT",
			"BINARY(255)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-256\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-128\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-16\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"SMALLINT",
			"VARCHAR(1)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"VARCHAR(10)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"SMALLINT",
			"VARCHAR(100)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"SMALLINT",
			"VARCHAR(255)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"SMALLINT",
			"VARCHAR(1023)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"SMALLINT",
			"VARCHAR(4095)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"SMALLINT",
			"VARBINARY(1)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"VARBINARY(10)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"SMALLINT",
			"VARBINARY(100)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"SMALLINT",
			"VARBINARY(255)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"SMALLINT",
			"VARBINARY(1023)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"SMALLINT",
			"VARBINARY(4095)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"SMALLINT",
			"VARBINARY(16383)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"SMALLINT",
			"YEAR",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"DATE",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"TIME",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"TIMESTAMP",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"DATETIME",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('A')",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('B')",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('C')",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('A','B')",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('A','C')",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('B','C')",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('A','B','C')",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('C','A','B')",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('A')",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('B')",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('C')",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('A','B')",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('A','C')",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('B','C')",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('A','B','C')",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('C','A','B')",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"TINYINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"MEDIUMINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127), int64(255), int64(4095), int64(32767)},
			false,
		},
		{
			"SMALLINT",
			"INT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127), int64(255), int64(4095), int64(32767)},
			false,
		},
		{
			"SMALLINT",
			"BIGINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127), int64(255), int64(4095), int64(32767)},
			false,
		},
		{
			"SMALLINT",
			"TINYINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SMALLINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767)},
			false,
		},
		{
			"SMALLINT",
			"MEDIUMINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767)},
			false,
		},
		{
			"SMALLINT",
			"INT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767)},
			false,
		},
		{
			"SMALLINT",
			"BIGINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767)},
			false,
		},
		{
			"SMALLINT",
			"FLOAT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{float64(0), float64(1), float64(2), float64(15), float64(127), float64(255), float64(4095), float64(32767)},
			false,
		},
		{
			"SMALLINT",
			"DOUBLE",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{float64(0), float64(1), float64(2), float64(15), float64(127), float64(255), float64(4095), float64(32767)},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(1,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"DECIMAL(15,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(30,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(65,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(1,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"DECIMAL(15,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(30,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(65,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(15,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"DECIMAL(30,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000", "4095.000000000000000", "32767.000000000000000"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(65,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000", "4095.000000000000000", "32767.000000000000000"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(30,30)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"DECIMAL(65,30)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0.000000000000000000000000000000", "1.000000000000000000000000000000", "2.000000000000000000000000000000", "15.000000000000000000000000000000", "127.000000000000000000000000000000", "255.000000000000000000000000000000", "4095.000000000000000000000000000000", "32767.000000000000000000000000000000"},
			false,
		},
		{
			"SMALLINT",
			"BIT(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"BIT(8)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"BIT(16)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767)},
			false,
		},
		{
			"SMALLINT",
			"BIT(24)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767)},
			false,
		},
		{
			"SMALLINT",
			"BIT(32)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767)},
			false,
		},
		{
			"SMALLINT",
			"BIT(48)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767)},
			false,
		},
		{
			"SMALLINT",
			"BIT(64)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767)},
			false,
		},
		{
			"SMALLINT",
			"TINYBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"SMALLINT",
			"BLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"SMALLINT",
			"MEDIUMBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"SMALLINT",
			"LONGBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"SMALLINT",
			"TINYTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"SMALLINT",
			"TEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"SMALLINT",
			"MEDIUMTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"SMALLINT",
			"LONGTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"SMALLINT",
			"CHAR(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"CHAR(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"SMALLINT",
			"CHAR(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"SMALLINT",
			"CHAR(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"SMALLINT",
			"BINARY(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"BINARY(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"SMALLINT",
			"BINARY(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"SMALLINT",
			"BINARY(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"SMALLINT",
			"VARCHAR(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"VARCHAR(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"SMALLINT",
			"VARCHAR(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"SMALLINT",
			"VARCHAR(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"SMALLINT",
			"VARCHAR(1023)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"SMALLINT",
			"VARCHAR(4095)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"SMALLINT",
			"VARBINARY(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"VARBINARY(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"SMALLINT",
			"VARBINARY(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"SMALLINT",
			"VARBINARY(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"SMALLINT",
			"VARBINARY(1023)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"SMALLINT",
			"VARBINARY(4095)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"SMALLINT",
			"VARBINARY(16383)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"SMALLINT",
			"YEAR",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"DATE",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"TIME",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"TIMESTAMP",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"DATETIME",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('A')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('A','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('A','B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('C','A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('A')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('A','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('A','B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('C','A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"TINYINT",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"MEDIUMINT",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{int64(-32768), int64(-4096), int64(-256), int64(-128), int64(-16), int64(-2), int64(-1), int64(0), int64(1), int64(2), int64(15), int64(127), int64(255), int64(4095), int64(32767)},
			false,
		},
		{
			"SMALLINT",
			"INT",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{int64(-32768), int64(-4096), int64(-256), int64(-128), int64(-16), int64(-2), int64(-1), int64(0), int64(1), int64(2), int64(15), int64(127), int64(255), int64(4095), int64(32767)},
			false,
		},
		{
			"SMALLINT",
			"BIGINT",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{int64(-32768), int64(-4096), int64(-256), int64(-128), int64(-16), int64(-2), int64(-1), int64(0), int64(1), int64(2), int64(15), int64(127), int64(255), int64(4095), int64(32767)},
			false,
		},
		{
			"SMALLINT",
			"TINYINT UNSIGNED",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SMALLINT UNSIGNED",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"MEDIUMINT UNSIGNED",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"INT UNSIGNED",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"BIGINT UNSIGNED",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"FLOAT",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{float64(-32768), float64(-4096), float64(-256), float64(-128), float64(-16), float64(-2), float64(-1), float64(0), float64(1), float64(2), float64(15), float64(127), float64(255), float64(4095), float64(32767)},
			false,
		},
		{
			"SMALLINT",
			"DOUBLE",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{float64(-32768), float64(-4096), float64(-256), float64(-128), float64(-16), float64(-2), float64(-1), float64(0), float64(1), float64(2), float64(15), float64(127), float64(255), float64(4095), float64(32767)},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(1,0)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"DECIMAL(15,0)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(30,0)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(65,0)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(1,1)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"DECIMAL(15,1)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768.0", "-4096.0", "-256.0", "-128.0", "-16.0", "-2.0", "-1.0", "0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(30,1)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768.0", "-4096.0", "-256.0", "-128.0", "-16.0", "-2.0", "-1.0", "0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(65,1)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768.0", "-4096.0", "-256.0", "-128.0", "-16.0", "-2.0", "-1.0", "0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(15,15)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"DECIMAL(30,15)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768.000000000000000", "-4096.000000000000000", "-256.000000000000000", "-128.000000000000000", "-16.000000000000000", "-2.000000000000000", "-1.000000000000000", "0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000", "4095.000000000000000", "32767.000000000000000"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(65,15)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768.000000000000000", "-4096.000000000000000", "-256.000000000000000", "-128.000000000000000", "-16.000000000000000", "-2.000000000000000", "-1.000000000000000", "0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000", "4095.000000000000000", "32767.000000000000000"},
			false,
		},
		{
			"SMALLINT",
			"DECIMAL(30,30)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"DECIMAL(65,30)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768.000000000000000000000000000000", "-4096.000000000000000000000000000000", "-256.000000000000000000000000000000", "-128.000000000000000000000000000000", "-16.000000000000000000000000000000", "-2.000000000000000000000000000000", "-1.000000000000000000000000000000", "0.000000000000000000000000000000", "1.000000000000000000000000000000", "2.000000000000000000000000000000", "15.000000000000000000000000000000", "127.000000000000000000000000000000", "255.000000000000000000000000000000", "4095.000000000000000000000000000000", "32767.000000000000000000000000000000"},
			false,
		},
		{
			"SMALLINT",
			"BIT(1)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"BIT(8)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"BIT(16)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"BIT(24)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"BIT(32)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"BIT(48)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"BIT(64)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{uint64(18446744073709518848), uint64(18446744073709547520), uint64(18446744073709551360), uint64(18446744073709551488), uint64(18446744073709551600), uint64(18446744073709551614), uint64(18446744073709551615), uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767)},
			false,
		},
		{
			"SMALLINT",
			"TINYBLOB",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"SMALLINT",
			"BLOB",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"SMALLINT",
			"MEDIUMBLOB",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"SMALLINT",
			"LONGBLOB",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"SMALLINT",
			"TINYTEXT",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"SMALLINT",
			"TEXT",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"SMALLINT",
			"MEDIUMTEXT",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"SMALLINT",
			"LONGTEXT",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"SMALLINT",
			"CHAR(1)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"CHAR(10)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"SMALLINT",
			"CHAR(100)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"SMALLINT",
			"CHAR(255)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"SMALLINT",
			"BINARY(1)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"BINARY(10)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768\x00\x00\x00\x00", "-4096\x00\x00\x00\x00\x00", "-256\x00\x00\x00\x00\x00\x00", "-128\x00\x00\x00\x00\x00\x00", "-16\x00\x00\x00\x00\x00\x00\x00", "-2\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"SMALLINT",
			"BINARY(100)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-4096\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-256\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-128\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-16\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"SMALLINT",
			"BINARY(255)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-4096\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-256\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-128\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-16\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"SMALLINT",
			"VARCHAR(1)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"VARCHAR(10)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"SMALLINT",
			"VARCHAR(100)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"SMALLINT",
			"VARCHAR(255)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"SMALLINT",
			"VARCHAR(1023)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"SMALLINT",
			"VARCHAR(4095)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"SMALLINT",
			"VARBINARY(1)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"VARBINARY(10)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"SMALLINT",
			"VARBINARY(100)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"SMALLINT",
			"VARBINARY(255)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"SMALLINT",
			"VARBINARY(1023)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"SMALLINT",
			"VARBINARY(4095)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"SMALLINT",
			"VARBINARY(16383)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"SMALLINT",
			"YEAR",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"DATE",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"TIME",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"TIMESTAMP",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"DATETIME",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('A')",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('B')",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('C')",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('A','B')",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('A','C')",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('B','C')",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('A','B','C')",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"ENUM('C','A','B')",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('A')",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('B')",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('C')",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('A','B')",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('A','C')",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('B','C')",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('A','B','C')",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"SMALLINT",
			"SET('C','A','B')",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
	}

	RunModifyTypeTests(t, tests)
}
