import type {Background} from './text'
/* eslint-disable sort-keys */
const _allTextTypes = {
  Body: 'Body',
  BodyItalic: 'BodyItalic',
  BodyBig: 'BodyBig',
  BodyBigExtrabold: 'BodyBigExtrabold',
  BodyBigLink: 'BodyBigLink',
  BodyBold: 'BodyBold',
  BodyExtrabold: 'BodyExtrabold',
  BodyPrimaryLink: 'BodyPrimaryLink',
  BodySecondaryLink: 'BodySecondaryLink',
  BodySemibold: 'BodySemibold',
  BodySemiboldLink: 'BodySemiboldLink',
  BodySemiboldItalic: 'BodySemiboldItalic',
  BodySmall: 'BodySmall',
  BodySmallBold: 'BodySmallBold',
  BodySmallExtrabold: 'BodySmallExtrabold',
  BodySmallExtraboldSecondaryLink: 'BodySmallExtraboldSecondaryLink',
  BodySmallError: 'BodySmallError',
  BodySmallItalic: 'BodySmallItalic',
  BodySmallPrimaryLink: 'BodySmallPrimaryLink',
  BodySmallSecondaryLink: 'BodySmallSecondaryLink',
  BodySmallSemibold: 'BodySmallSemibold',
  BodySmallSemiboldItalic: 'BodySmallSemiboldItalic',
  BodySmallSemiboldSecondaryLink: 'BodySmallSemiboldSecondaryLink',
  BodySmallSemiboldPrimaryLink: 'BodySmallSemiboldPrimaryLink',
  BodySmallSuccess: 'BodySmallSuccess',
  BodySmallWallet: 'BodySmallWallet',
  BodyTiny: 'BodyTiny',
  BodyTinyLink: 'BodyTinyLink',
  BodyTinySemibold: 'BodyTinySemibold',
  BodyTinySemiboldItalic: 'BodyTinySemiboldItalic',
  BodyTinyBold: 'BodyTinyBold',
  BodyTinyExtrabold: 'BodyTinyBold',
  Header: 'Header',
  HeaderItalic: 'HeaderItalic',
  HeaderExtrabold: 'HeaderExtrabold',
  HeaderBig: 'HeaderBig',
  HeaderBigExtrabold: 'HeaderBigExtrabold',
  HeaderLink: 'HeaderLink',
  Terminal: 'Terminal',
  TerminalComment: 'TerminalComment',
  TerminalEmpty: 'TerminalEmpty',
  TerminalInline: 'TerminalInline',
} as const
type AllTextTypes = typeof _allTextTypes
export type TextType = keyof AllTextTypes

export const backgroundModeIsNegative = (bm?: Background): boolean =>
  !!bm && !['Normal', 'Information'].includes(bm)
