# Contributing to Bit

Thank you so much for contributing to Bit. We appreciate your time and help.
Here are some guidelines to help you get started.

## Code of Conduct

Be kind and respectful to the members of the community. Take time to educate
others who are seeking help. Harassment of any kind will not be tolerated.

## Questions

If you have questions regarding Bit, feel free to ask it in the community
[#bit-slack channel](https://join.slack.com/t/reconbuddy/shared_invite/zt-ij4jqank-FRgwggXw7uuOmTTWhQ7cVQ)

## Filing a bug or feature

1. Before filing an issue, please check the existing issues to see if a
   similar one was already opened. If there is one already opened, feel free
   to comment on it.
1. If you believe you've found a bug, please provide detailed steps of
   reproduction, the version of Bit and anything else you believe will be
   useful to help troubleshoot it (e.g. OS environment, Terminal, Shell
   etc...). Also state the current behavior vs. the expected behavior.
1. If you'd like to see a feature or an enhancement please open an issue with
   a clear title (Starting with *Feature* or *Enhancement*) and description of what the feature is and why it would be
   beneficial to the project and its users.

## Submitting changes

1. Tests: If you are submitting code, please ensure you have adequate tests
   for the feature. Tests can be run via `go test ./cmd`.
1. Since this is golang project, ensure the new code is properly formatted to
   ensure code consistency.

### Quick steps to contribute

1. Fork the project.
1. Download your fork to your PC (`git clone https://github.com/your_username/bit && cd bit`)
1. Create your feature branch (`git checkout -b feature-example`)
1. Make changes and run tests (`go test ./cmd`)
1. Commit your changes (`git commit -am 'feature: some feature'`)
1. Push to the branch (`git push origin my-new-feature`)
1. Create new pull request

<!-- Links -->
[bit-slack]: https://join.slack.com/t/reconbuddy/shared_invite/zt-ij4jqank-FRgwggXw7uuOmTTWhQ7cVQ
