// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Defines device mapping for WorkSpace Instance storage.
type BlockDeviceMappingRequest struct {

	// Name of the device for storage mapping.
	DeviceName *string

	// EBS volume configuration for the device.
	Ebs *EbsBlockDevice

	// Indicates device should not be mapped.
	NoDevice *string

	// Virtual device name for ephemeral storage.
	VirtualName *string

	noSmithyDocumentSerde
}

// Specifies capacity reservation preferences.
type CapacityReservationSpecification struct {

	// Preference for using capacity reservation.
	CapacityReservationPreference CapacityReservationPreferenceEnum

	// Specific capacity reservation target.
	CapacityReservationTarget *CapacityReservationTarget

	noSmithyDocumentSerde
}

// Identifies a specific capacity reservation.
type CapacityReservationTarget struct {

	// Unique identifier for the capacity reservation.
	CapacityReservationId *string

	// ARN of the capacity reservation resource group.
	CapacityReservationResourceGroupArn *string

	noSmithyDocumentSerde
}

// Defines connection tracking parameters for network interfaces.
type ConnectionTrackingSpecificationRequest struct {

	// Timeout for established TCP connections.
	TcpEstablishedTimeout *int32

	// Timeout for UDP stream connections.
	UdpStreamTimeout *int32

	// General timeout for UDP connections.
	UdpTimeout *int32

	noSmithyDocumentSerde
}

// Configures CPU-specific settings for WorkSpace Instance.
type CpuOptionsRequest struct {

	// AMD Secure Encrypted Virtualization configuration.
	AmdSevSnp AmdSevSnpEnum

	// Number of CPU cores to allocate.
	CoreCount *int32

	// Number of threads per CPU core.
	ThreadsPerCore *int32

	noSmithyDocumentSerde
}

// Defines CPU credit configuration for burstable instances.
type CreditSpecificationRequest struct {

	// CPU credit specification mode.
	CpuCredits CpuCreditsEnum

	noSmithyDocumentSerde
}

// Defines configuration for an Elastic Block Store volume.
type EbsBlockDevice struct {

	// Indicates if the volume is encrypted.
	Encrypted *bool

	// Input/output operations per second for the volume.
	Iops *int32

	// KMS key used for volume encryption.
	KmsKeyId *string

	// Volume data transfer rate.
	Throughput *int32

	// Size of the EBS volume in gigabytes.
	VolumeSize *int32

	// Type of EBS volume (e.g., gp2, io1).
	VolumeType VolumeTypeEnum

	noSmithyDocumentSerde
}

// Captures detailed error information for EC2 instance operations.
type EC2InstanceError struct {

	// Unique error code identifying the specific EC2 instance error.
	EC2ErrorCode *string

	// Detailed description of the EC2 instance error.
	EC2ErrorMessage *string

	// Type of exception encountered during EC2 instance operation.
	EC2ExceptionType *string

	noSmithyDocumentSerde
}

// Represents an EC2 instance managed by WorkSpaces.
type EC2ManagedInstance struct {

	// Unique identifier of the managed EC2 instance.
	InstanceId *string

	noSmithyDocumentSerde
}

// Defines Elastic Network Adapter (ENA) Scalable Reliable Datagram (SRD)
// configuration.
type EnaSrdSpecificationRequest struct {

	// Enables or disables ENA SRD for network performance.
	EnaSrdEnabled *bool

	// Configures UDP-specific ENA SRD settings.
	EnaSrdUdpSpecification *EnaSrdUdpSpecificationRequest

	noSmithyDocumentSerde
}

// Specifies UDP configuration for ENA SRD.
type EnaSrdUdpSpecificationRequest struct {

	// Enables or disables ENA SRD for UDP traffic.
	EnaSrdUdpEnabled *bool

	noSmithyDocumentSerde
}

// Configures AWS Nitro Enclave options for the WorkSpace Instance.
type EnclaveOptionsRequest struct {

	// Enables or disables AWS Nitro Enclaves for enhanced security.
	Enabled *bool

	noSmithyDocumentSerde
}

// Defines hibernation configuration for the WorkSpace Instance.
type HibernationOptionsRequest struct {

	// Enables or disables instance hibernation capability.
	Configured *bool

	noSmithyDocumentSerde
}

// Defines IAM instance profile configuration for WorkSpace Instance.
type IamInstanceProfileSpecification struct {

	// Amazon Resource Name (ARN) of the IAM instance profile.
	Arn *string

	// Name of the IAM instance profile.
	Name *string

	noSmithyDocumentSerde
}

// Represents an IPv6 address configuration for a WorkSpace Instance.
type InstanceIpv6Address struct {

	// Specific IPv6 address assigned to the instance.
	Ipv6Address *string

	// Indicates if this is the primary IPv6 address for the instance.
	IsPrimaryIpv6 *bool

	noSmithyDocumentSerde
}

// Configures automatic maintenance settings for WorkSpace Instance.
type InstanceMaintenanceOptionsRequest struct {

	// Enables or disables automatic instance recovery.
	AutoRecovery AutoRecoveryEnum

	noSmithyDocumentSerde
}

// Configures marketplace-specific instance deployment options.
type InstanceMarketOptionsRequest struct {

	// Specifies the type of marketplace for instance deployment.
	MarketType MarketTypeEnum

	// Configuration options for spot instance deployment.
	SpotOptions *SpotMarketOptions

	noSmithyDocumentSerde
}

// Defines instance metadata service configuration.
type InstanceMetadataOptionsRequest struct {

	// Enables or disables HTTP endpoint for instance metadata.
	HttpEndpoint HttpEndpointEnum

	// Configures IPv6 support for instance metadata HTTP protocol.
	HttpProtocolIpv6 HttpProtocolIpv6Enum

	// Sets maximum number of network hops for metadata PUT responses.
	HttpPutResponseHopLimit *int32

	// Configures token requirement for instance metadata retrieval.
	HttpTokens HttpTokensEnum

	// Enables or disables instance metadata tags retrieval.
	InstanceMetadataTags InstanceMetadataTagsEnum

	noSmithyDocumentSerde
}

// Defines network interface configuration for WorkSpace Instance.
type InstanceNetworkInterfaceSpecification struct {

	// Enables carrier IP address association.
	AssociateCarrierIpAddress *bool

	// Enables public IP address assignment.
	AssociatePublicIpAddress *bool

	// Configures network connection tracking parameters.
	ConnectionTrackingSpecification *ConnectionTrackingSpecificationRequest

	// Descriptive text for the network interface.
	Description *string

	// Unique index for the network interface.
	DeviceIndex *int32

	// Configures Elastic Network Adapter Scalable Reliable Datagram settings.
	EnaSrdSpecification *EnaSrdSpecificationRequest

	// Security groups associated with the network interface.
	Groups []string

	// Specifies the type of network interface.
	InterfaceType InterfaceTypeEnum

	// Number of IPv4 prefixes to assign.
	Ipv4PrefixCount *int32

	// IPv4 prefix configurations for the interface.
	Ipv4Prefixes []Ipv4PrefixSpecificationRequest

	// Number of IPv6 addresses to assign.
	Ipv6AddressCount *int32

	// Specific IPv6 addresses for the interface.
	Ipv6Addresses []InstanceIpv6Address

	// Number of IPv6 prefixes to assign.
	Ipv6PrefixCount *int32

	// IPv6 prefix configurations for the interface.
	Ipv6Prefixes []Ipv6PrefixSpecificationRequest

	// Index of the network card for multiple network interfaces.
	NetworkCardIndex *int32

	// Unique identifier for the network interface.
	NetworkInterfaceId *string

	// Indicates the primary IPv6 configuration.
	PrimaryIpv6 *bool

	// Primary private IP address for the interface.
	PrivateIpAddress *string

	// List of private IP addresses for the interface.
	PrivateIpAddresses []PrivateIpAddressSpecification

	// Number of additional private IP addresses to assign.
	SecondaryPrivateIpAddressCount *int32

	// Subnet identifier for the network interface.
	SubnetId *string

	noSmithyDocumentSerde
}

// Configures network performance settings for WorkSpace Instance.
type InstanceNetworkPerformanceOptionsRequest struct {

	// Defines bandwidth allocation strategy for network interfaces.
	BandwidthWeighting BandwidthWeightingEnum

	noSmithyDocumentSerde
}

// Provides details about a specific WorkSpace Instance type.
type InstanceTypeInfo struct {

	// Unique identifier for the WorkSpace Instance type.
	InstanceType *string

	noSmithyDocumentSerde
}

// Specifies IPv4 prefix configuration for network interfaces.
type Ipv4PrefixSpecificationRequest struct {

	// Specific IPv4 prefix for network interface configuration.
	Ipv4Prefix *string

	noSmithyDocumentSerde
}

// Specifies IPv6 prefix configuration for network interfaces.
type Ipv6PrefixSpecificationRequest struct {

	// Specific IPv6 prefix for network interface configuration.
	Ipv6Prefix *string

	noSmithyDocumentSerde
}

// Specifies license configuration for WorkSpace Instance.
type LicenseConfigurationRequest struct {

	// ARN of the license configuration for the WorkSpace Instance.
	LicenseConfigurationArn *string

	noSmithyDocumentSerde
}

// Defines comprehensive configuration for a managed WorkSpace Instance.
type ManagedInstanceRequest struct {

	// Configures block device mappings for storage.
	BlockDeviceMappings []BlockDeviceMappingRequest

	// Specifies capacity reservation preferences.
	CapacityReservationSpecification *CapacityReservationSpecification

	// Configures CPU-specific settings.
	CpuOptions *CpuOptionsRequest

	// Defines CPU credit configuration for burstable instances.
	CreditSpecification *CreditSpecificationRequest

	// Prevents API-initiated instance stop.
	DisableApiStop *bool

	// Enables optimized EBS performance.
	EbsOptimized *bool

	// Enables primary IPv6 address configuration.
	EnablePrimaryIpv6 *bool

	// Configures AWS Nitro Enclave settings.
	EnclaveOptions *EnclaveOptionsRequest

	// Configures instance hibernation capabilities.
	HibernationOptions *HibernationOptionsRequest

	// Specifies IAM instance profile configuration.
	IamInstanceProfile *IamInstanceProfileSpecification

	// Identifies the Amazon Machine Image (AMI) for the instance.
	ImageId *string

	// Configures marketplace-specific deployment options.
	InstanceMarketOptions *InstanceMarketOptionsRequest

	// Specifies the WorkSpace Instance type.
	InstanceType *string

	// Specifies number of IPv6 addresses to assign.
	Ipv6AddressCount *int32

	// Configures specific IPv6 addresses.
	Ipv6Addresses []InstanceIpv6Address

	// Identifies the kernel for the instance.
	KernelId *string

	// Specifies the key pair for instance access.
	KeyName *string

	// Configures license-related settings.
	LicenseSpecifications []LicenseConfigurationRequest

	// Defines automatic maintenance settings.
	MaintenanceOptions *InstanceMaintenanceOptionsRequest

	// Configures instance metadata service settings.
	MetadataOptions *InstanceMetadataOptionsRequest

	// Enables or disables detailed instance monitoring.
	Monitoring *RunInstancesMonitoringEnabled

	// Configures network interface settings.
	NetworkInterfaces []InstanceNetworkInterfaceSpecification

	// Defines network performance configuration.
	NetworkPerformanceOptions *InstanceNetworkPerformanceOptionsRequest

	// Specifies instance placement preferences.
	Placement *Placement

	// Configures private DNS name settings.
	PrivateDnsNameOptions *PrivateDnsNameOptionsRequest

	// Specifies the primary private IP address.
	PrivateIpAddress *string

	// Identifies the ramdisk for the instance.
	RamdiskId *string

	// Specifies security group identifiers.
	SecurityGroupIds []string

	// Configures security group settings.
	SecurityGroups []string

	// Identifies the subnet for the instance.
	SubnetId *string

	// Configures resource tagging specifications.
	TagSpecifications []TagSpecification

	// Provides custom initialization data for the instance.
	UserData *string

	noSmithyDocumentSerde
}

// Defines instance placement configuration for WorkSpace Instance.
type Placement struct {

	// Specifies host affinity for dedicated instances.
	Affinity *string

	// Identifies the specific AWS availability zone.
	AvailabilityZone *string

	// Unique identifier for placement group.
	GroupId *string

	// Name of the placement group.
	GroupName *string

	// Identifies the specific dedicated host.
	HostId *string

	// ARN of the host resource group.
	HostResourceGroupArn *string

	// Specifies partition number for partition placement groups.
	PartitionNumber *int32

	// Defines instance tenancy configuration.
	Tenancy TenancyEnum

	noSmithyDocumentSerde
}

// Configures private DNS name settings for WorkSpace Instance.
type PrivateDnsNameOptionsRequest struct {

	// Enables DNS AAAA record for resource name resolution.
	EnableResourceNameDnsAAAARecord *bool

	// Enables DNS A record for resource name resolution.
	EnableResourceNameDnsARecord *bool

	// Specifies the type of hostname configuration.
	HostnameType HostnameTypeEnum

	noSmithyDocumentSerde
}

// Defines private IP address configuration for network interface.
type PrivateIpAddressSpecification struct {

	// Indicates if this is the primary private IP address.
	Primary *bool

	// Specific private IP address for the network interface.
	PrivateIpAddress *string

	noSmithyDocumentSerde
}

// Represents an AWS region supported by WorkSpaces Instances.
type Region struct {

	// Name of the AWS region.
	RegionName *string

	noSmithyDocumentSerde
}

// Configures detailed monitoring for WorkSpace Instance.
type RunInstancesMonitoringEnabled struct {

	// Enables or disables detailed instance monitoring.
	Enabled *bool

	noSmithyDocumentSerde
}

// Defines configuration for spot instance deployment.
type SpotMarketOptions struct {

	// Duration of spot instance block reservation.
	BlockDurationMinutes *int32

	// Specifies behavior when spot instance is interrupted.
	InstanceInterruptionBehavior InstanceInterruptionBehaviorEnum

	// Maximum hourly price for spot instance.
	MaxPrice *string

	// Defines the type of spot instance request.
	SpotInstanceType SpotInstanceTypeEnum

	// Timestamp until which spot instance request is valid.
	ValidUntilUtc *time.Time

	noSmithyDocumentSerde
}

// Represents a key-value metadata tag.
type Tag struct {

	// Unique identifier for the tag.
	Key *string

	// Value associated with the tag key.
	Value *string

	noSmithyDocumentSerde
}

// Defines tagging configuration for a resource.
type TagSpecification struct {

	// Type of resource being tagged.
	ResourceType ResourceTypeEnum

	// Collection of tags for the specified resource.
	Tags []Tag

	noSmithyDocumentSerde
}

// Represents a validation error field in an API request.
type ValidationExceptionField struct {

	// Detailed error message describing the validation issue.
	//
	// This member is required.
	Message *string

	// Name of the field that failed validation.
	//
	// This member is required.
	Name *string

	// Reason for the validation failure.
	//
	// This member is required.
	Reason *string

	noSmithyDocumentSerde
}

// Represents a single WorkSpace Instance.
type WorkspaceInstance struct {

	// Details of the associated EC2 managed instance.
	EC2ManagedInstance *EC2ManagedInstance

	// Current provisioning state of the WorkSpace Instance.
	ProvisionState ProvisionStateEnum

	// Unique identifier for the WorkSpace Instance.
	WorkspaceInstanceId *string

	noSmithyDocumentSerde
}

// Captures errors specific to WorkSpace Instance operations.
type WorkspaceInstanceError struct {

	// Unique error code for the WorkSpace Instance error.
	ErrorCode *string

	// Detailed description of the WorkSpace Instance error.
	ErrorMessage *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
