// Code generated by smithy-go-codegen DO NOT EDIT.

package wafv2

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/wafv2/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	smithytime "github.com/aws/smithy-go/time"
	"github.com/aws/smithy-go/tracing"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"path"
)

type awsAwsjson11_serializeOpAssociateWebACL struct {
}

func (*awsAwsjson11_serializeOpAssociateWebACL) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpAssociateWebACL) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AssociateWebACLInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSWAF_20190729.AssociateWebACL")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentAssociateWebACLInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCheckCapacity struct {
}

func (*awsAwsjson11_serializeOpCheckCapacity) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCheckCapacity) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CheckCapacityInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSWAF_20190729.CheckCapacity")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCheckCapacityInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreateAPIKey struct {
}

func (*awsAwsjson11_serializeOpCreateAPIKey) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreateAPIKey) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateAPIKeyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSWAF_20190729.CreateAPIKey")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreateAPIKeyInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreateIPSet struct {
}

func (*awsAwsjson11_serializeOpCreateIPSet) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreateIPSet) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateIPSetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSWAF_20190729.CreateIPSet")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreateIPSetInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreateRegexPatternSet struct {
}

func (*awsAwsjson11_serializeOpCreateRegexPatternSet) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreateRegexPatternSet) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateRegexPatternSetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSWAF_20190729.CreateRegexPatternSet")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreateRegexPatternSetInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreateRuleGroup struct {
}

func (*awsAwsjson11_serializeOpCreateRuleGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreateRuleGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateRuleGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSWAF_20190729.CreateRuleGroup")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreateRuleGroupInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreateWebACL struct {
}

func (*awsAwsjson11_serializeOpCreateWebACL) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreateWebACL) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateWebACLInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSWAF_20190729.CreateWebACL")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreateWebACLInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteAPIKey struct {
}

func (*awsAwsjson11_serializeOpDeleteAPIKey) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteAPIKey) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteAPIKeyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSWAF_20190729.DeleteAPIKey")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteAPIKeyInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteFirewallManagerRuleGroups struct {
}

func (*awsAwsjson11_serializeOpDeleteFirewallManagerRuleGroups) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteFirewallManagerRuleGroups) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteFirewallManagerRuleGroupsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSWAF_20190729.DeleteFirewallManagerRuleGroups")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteFirewallManagerRuleGroupsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteIPSet struct {
}

func (*awsAwsjson11_serializeOpDeleteIPSet) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteIPSet) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteIPSetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSWAF_20190729.DeleteIPSet")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteIPSetInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteLoggingConfiguration struct {
}

func (*awsAwsjson11_serializeOpDeleteLoggingConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteLoggingConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteLoggingConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSWAF_20190729.DeleteLoggingConfiguration")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteLoggingConfigurationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeletePermissionPolicy struct {
}

func (*awsAwsjson11_serializeOpDeletePermissionPolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeletePermissionPolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeletePermissionPolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSWAF_20190729.DeletePermissionPolicy")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeletePermissionPolicyInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteRegexPatternSet struct {
}

func (*awsAwsjson11_serializeOpDeleteRegexPatternSet) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteRegexPatternSet) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteRegexPatternSetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSWAF_20190729.DeleteRegexPatternSet")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteRegexPatternSetInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteRuleGroup struct {
}

func (*awsAwsjson11_serializeOpDeleteRuleGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteRuleGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteRuleGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSWAF_20190729.DeleteRuleGroup")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteRuleGroupInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteWebACL struct {
}

func (*awsAwsjson11_serializeOpDeleteWebACL) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteWebACL) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteWebACLInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSWAF_20190729.DeleteWebACL")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteWebACLInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeAllManagedProducts struct {
}

func (*awsAwsjson11_serializeOpDescribeAllManagedProducts) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeAllManagedProducts) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeAllManagedProductsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSWAF_20190729.DescribeAllManagedProducts")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeAllManagedProductsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeManagedProductsByVendor struct {
}

func (*awsAwsjson11_serializeOpDescribeManagedProductsByVendor) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeManagedProductsByVendor) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeManagedProductsByVendorInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSWAF_20190729.DescribeManagedProductsByVendor")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeManagedProductsByVendorInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeManagedRuleGroup struct {
}

func (*awsAwsjson11_serializeOpDescribeManagedRuleGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeManagedRuleGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeManagedRuleGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSWAF_20190729.DescribeManagedRuleGroup")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeManagedRuleGroupInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDisassociateWebACL struct {
}

func (*awsAwsjson11_serializeOpDisassociateWebACL) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDisassociateWebACL) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DisassociateWebACLInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSWAF_20190729.DisassociateWebACL")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDisassociateWebACLInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGenerateMobileSdkReleaseUrl struct {
}

func (*awsAwsjson11_serializeOpGenerateMobileSdkReleaseUrl) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGenerateMobileSdkReleaseUrl) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GenerateMobileSdkReleaseUrlInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSWAF_20190729.GenerateMobileSdkReleaseUrl")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGenerateMobileSdkReleaseUrlInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetDecryptedAPIKey struct {
}

func (*awsAwsjson11_serializeOpGetDecryptedAPIKey) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetDecryptedAPIKey) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetDecryptedAPIKeyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSWAF_20190729.GetDecryptedAPIKey")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetDecryptedAPIKeyInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetIPSet struct {
}

func (*awsAwsjson11_serializeOpGetIPSet) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetIPSet) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetIPSetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSWAF_20190729.GetIPSet")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetIPSetInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetLoggingConfiguration struct {
}

func (*awsAwsjson11_serializeOpGetLoggingConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetLoggingConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetLoggingConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSWAF_20190729.GetLoggingConfiguration")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetLoggingConfigurationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetManagedRuleSet struct {
}

func (*awsAwsjson11_serializeOpGetManagedRuleSet) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetManagedRuleSet) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetManagedRuleSetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSWAF_20190729.GetManagedRuleSet")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetManagedRuleSetInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetMobileSdkRelease struct {
}

func (*awsAwsjson11_serializeOpGetMobileSdkRelease) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetMobileSdkRelease) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetMobileSdkReleaseInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSWAF_20190729.GetMobileSdkRelease")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetMobileSdkReleaseInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetPermissionPolicy struct {
}

func (*awsAwsjson11_serializeOpGetPermissionPolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetPermissionPolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetPermissionPolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSWAF_20190729.GetPermissionPolicy")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetPermissionPolicyInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetRateBasedStatementManagedKeys struct {
}

func (*awsAwsjson11_serializeOpGetRateBasedStatementManagedKeys) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetRateBasedStatementManagedKeys) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetRateBasedStatementManagedKeysInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSWAF_20190729.GetRateBasedStatementManagedKeys")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetRateBasedStatementManagedKeysInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetRegexPatternSet struct {
}

func (*awsAwsjson11_serializeOpGetRegexPatternSet) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetRegexPatternSet) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetRegexPatternSetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSWAF_20190729.GetRegexPatternSet")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetRegexPatternSetInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetRuleGroup struct {
}

func (*awsAwsjson11_serializeOpGetRuleGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetRuleGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetRuleGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSWAF_20190729.GetRuleGroup")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetRuleGroupInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetSampledRequests struct {
}

func (*awsAwsjson11_serializeOpGetSampledRequests) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetSampledRequests) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetSampledRequestsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSWAF_20190729.GetSampledRequests")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetSampledRequestsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetWebACL struct {
}

func (*awsAwsjson11_serializeOpGetWebACL) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetWebACL) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetWebACLInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSWAF_20190729.GetWebACL")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetWebACLInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetWebACLForResource struct {
}

func (*awsAwsjson11_serializeOpGetWebACLForResource) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetWebACLForResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetWebACLForResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSWAF_20190729.GetWebACLForResource")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetWebACLForResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListAPIKeys struct {
}

func (*awsAwsjson11_serializeOpListAPIKeys) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListAPIKeys) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListAPIKeysInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSWAF_20190729.ListAPIKeys")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListAPIKeysInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListAvailableManagedRuleGroups struct {
}

func (*awsAwsjson11_serializeOpListAvailableManagedRuleGroups) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListAvailableManagedRuleGroups) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListAvailableManagedRuleGroupsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSWAF_20190729.ListAvailableManagedRuleGroups")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListAvailableManagedRuleGroupsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListAvailableManagedRuleGroupVersions struct {
}

func (*awsAwsjson11_serializeOpListAvailableManagedRuleGroupVersions) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListAvailableManagedRuleGroupVersions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListAvailableManagedRuleGroupVersionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSWAF_20190729.ListAvailableManagedRuleGroupVersions")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListAvailableManagedRuleGroupVersionsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListIPSets struct {
}

func (*awsAwsjson11_serializeOpListIPSets) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListIPSets) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListIPSetsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSWAF_20190729.ListIPSets")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListIPSetsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListLoggingConfigurations struct {
}

func (*awsAwsjson11_serializeOpListLoggingConfigurations) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListLoggingConfigurations) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListLoggingConfigurationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSWAF_20190729.ListLoggingConfigurations")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListLoggingConfigurationsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListManagedRuleSets struct {
}

func (*awsAwsjson11_serializeOpListManagedRuleSets) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListManagedRuleSets) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListManagedRuleSetsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSWAF_20190729.ListManagedRuleSets")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListManagedRuleSetsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListMobileSdkReleases struct {
}

func (*awsAwsjson11_serializeOpListMobileSdkReleases) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListMobileSdkReleases) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListMobileSdkReleasesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSWAF_20190729.ListMobileSdkReleases")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListMobileSdkReleasesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListRegexPatternSets struct {
}

func (*awsAwsjson11_serializeOpListRegexPatternSets) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListRegexPatternSets) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListRegexPatternSetsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSWAF_20190729.ListRegexPatternSets")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListRegexPatternSetsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListResourcesForWebACL struct {
}

func (*awsAwsjson11_serializeOpListResourcesForWebACL) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListResourcesForWebACL) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListResourcesForWebACLInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSWAF_20190729.ListResourcesForWebACL")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListResourcesForWebACLInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListRuleGroups struct {
}

func (*awsAwsjson11_serializeOpListRuleGroups) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListRuleGroups) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListRuleGroupsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSWAF_20190729.ListRuleGroups")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListRuleGroupsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListTagsForResource struct {
}

func (*awsAwsjson11_serializeOpListTagsForResource) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListTagsForResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTagsForResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSWAF_20190729.ListTagsForResource")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListTagsForResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListWebACLs struct {
}

func (*awsAwsjson11_serializeOpListWebACLs) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListWebACLs) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListWebACLsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSWAF_20190729.ListWebACLs")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListWebACLsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpPutLoggingConfiguration struct {
}

func (*awsAwsjson11_serializeOpPutLoggingConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpPutLoggingConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutLoggingConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSWAF_20190729.PutLoggingConfiguration")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentPutLoggingConfigurationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpPutManagedRuleSetVersions struct {
}

func (*awsAwsjson11_serializeOpPutManagedRuleSetVersions) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpPutManagedRuleSetVersions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutManagedRuleSetVersionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSWAF_20190729.PutManagedRuleSetVersions")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentPutManagedRuleSetVersionsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpPutPermissionPolicy struct {
}

func (*awsAwsjson11_serializeOpPutPermissionPolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpPutPermissionPolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutPermissionPolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSWAF_20190729.PutPermissionPolicy")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentPutPermissionPolicyInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpTagResource struct {
}

func (*awsAwsjson11_serializeOpTagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpTagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*TagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSWAF_20190729.TagResource")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentTagResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUntagResource struct {
}

func (*awsAwsjson11_serializeOpUntagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUntagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UntagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSWAF_20190729.UntagResource")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUntagResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUpdateIPSet struct {
}

func (*awsAwsjson11_serializeOpUpdateIPSet) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUpdateIPSet) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateIPSetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSWAF_20190729.UpdateIPSet")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUpdateIPSetInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUpdateManagedRuleSetVersionExpiryDate struct {
}

func (*awsAwsjson11_serializeOpUpdateManagedRuleSetVersionExpiryDate) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUpdateManagedRuleSetVersionExpiryDate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateManagedRuleSetVersionExpiryDateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSWAF_20190729.UpdateManagedRuleSetVersionExpiryDate")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUpdateManagedRuleSetVersionExpiryDateInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUpdateRegexPatternSet struct {
}

func (*awsAwsjson11_serializeOpUpdateRegexPatternSet) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUpdateRegexPatternSet) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateRegexPatternSetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSWAF_20190729.UpdateRegexPatternSet")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUpdateRegexPatternSetInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUpdateRuleGroup struct {
}

func (*awsAwsjson11_serializeOpUpdateRuleGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUpdateRuleGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateRuleGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSWAF_20190729.UpdateRuleGroup")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUpdateRuleGroupInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUpdateWebACL struct {
}

func (*awsAwsjson11_serializeOpUpdateWebACL) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUpdateWebACL) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateWebACLInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSWAF_20190729.UpdateWebACL")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUpdateWebACLInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsAwsjson11_serializeDocumentActionCondition(v *types.ActionCondition, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Action) > 0 {
		ok := object.Key("Action")
		ok.String(string(v.Action))
	}

	return nil
}

func awsAwsjson11_serializeDocumentAddressField(v *types.AddressField, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Identifier != nil {
		ok := object.Key("Identifier")
		ok.String(*v.Identifier)
	}

	return nil
}

func awsAwsjson11_serializeDocumentAddressFields(v []types.AddressField, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentAddressField(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentAll(v *types.All, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	return nil
}

func awsAwsjson11_serializeDocumentAllowAction(v *types.AllowAction, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CustomRequestHandling != nil {
		ok := object.Key("CustomRequestHandling")
		if err := awsAwsjson11_serializeDocumentCustomRequestHandling(v.CustomRequestHandling, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentAllQueryArguments(v *types.AllQueryArguments, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	return nil
}

func awsAwsjson11_serializeDocumentAndStatement(v *types.AndStatement, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Statements != nil {
		ok := object.Key("Statements")
		if err := awsAwsjson11_serializeDocumentStatements(v.Statements, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentAPIKeyTokenDomains(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentApplicationAttribute(v *types.ApplicationAttribute, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Values != nil {
		ok := object.Key("Values")
		if err := awsAwsjson11_serializeDocumentAttributeValues(v.Values, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentApplicationAttributes(v []types.ApplicationAttribute, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentApplicationAttribute(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentApplicationConfig(v *types.ApplicationConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Attributes != nil {
		ok := object.Key("Attributes")
		if err := awsAwsjson11_serializeDocumentApplicationAttributes(v.Attributes, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentAsnList(v []int64, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.Long(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentAsnMatchStatement(v *types.AsnMatchStatement, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AsnList != nil {
		ok := object.Key("AsnList")
		if err := awsAwsjson11_serializeDocumentAsnList(v.AsnList, ok); err != nil {
			return err
		}
	}

	if v.ForwardedIPConfig != nil {
		ok := object.Key("ForwardedIPConfig")
		if err := awsAwsjson11_serializeDocumentForwardedIPConfig(v.ForwardedIPConfig, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentAssociationConfig(v *types.AssociationConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.RequestBody != nil {
		ok := object.Key("RequestBody")
		if err := awsAwsjson11_serializeDocumentRequestBody(v.RequestBody, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentAttributeValues(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentAWSManagedRulesACFPRuleSet(v *types.AWSManagedRulesACFPRuleSet, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CreationPath != nil {
		ok := object.Key("CreationPath")
		ok.String(*v.CreationPath)
	}

	if v.EnableRegexInPath {
		ok := object.Key("EnableRegexInPath")
		ok.Boolean(v.EnableRegexInPath)
	}

	if v.RegistrationPagePath != nil {
		ok := object.Key("RegistrationPagePath")
		ok.String(*v.RegistrationPagePath)
	}

	if v.RequestInspection != nil {
		ok := object.Key("RequestInspection")
		if err := awsAwsjson11_serializeDocumentRequestInspectionACFP(v.RequestInspection, ok); err != nil {
			return err
		}
	}

	if v.ResponseInspection != nil {
		ok := object.Key("ResponseInspection")
		if err := awsAwsjson11_serializeDocumentResponseInspection(v.ResponseInspection, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentAWSManagedRulesAntiDDoSRuleSet(v *types.AWSManagedRulesAntiDDoSRuleSet, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientSideActionConfig != nil {
		ok := object.Key("ClientSideActionConfig")
		if err := awsAwsjson11_serializeDocumentClientSideActionConfig(v.ClientSideActionConfig, ok); err != nil {
			return err
		}
	}

	if len(v.SensitivityToBlock) > 0 {
		ok := object.Key("SensitivityToBlock")
		ok.String(string(v.SensitivityToBlock))
	}

	return nil
}

func awsAwsjson11_serializeDocumentAWSManagedRulesATPRuleSet(v *types.AWSManagedRulesATPRuleSet, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EnableRegexInPath {
		ok := object.Key("EnableRegexInPath")
		ok.Boolean(v.EnableRegexInPath)
	}

	if v.LoginPath != nil {
		ok := object.Key("LoginPath")
		ok.String(*v.LoginPath)
	}

	if v.RequestInspection != nil {
		ok := object.Key("RequestInspection")
		if err := awsAwsjson11_serializeDocumentRequestInspection(v.RequestInspection, ok); err != nil {
			return err
		}
	}

	if v.ResponseInspection != nil {
		ok := object.Key("ResponseInspection")
		if err := awsAwsjson11_serializeDocumentResponseInspection(v.ResponseInspection, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentAWSManagedRulesBotControlRuleSet(v *types.AWSManagedRulesBotControlRuleSet, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EnableMachineLearning != nil {
		ok := object.Key("EnableMachineLearning")
		ok.Boolean(*v.EnableMachineLearning)
	}

	if len(v.InspectionLevel) > 0 {
		ok := object.Key("InspectionLevel")
		ok.String(string(v.InspectionLevel))
	}

	return nil
}

func awsAwsjson11_serializeDocumentBlockAction(v *types.BlockAction, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CustomResponse != nil {
		ok := object.Key("CustomResponse")
		if err := awsAwsjson11_serializeDocumentCustomResponse(v.CustomResponse, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentBody(v *types.Body, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.OversizeHandling) > 0 {
		ok := object.Key("OversizeHandling")
		ok.String(string(v.OversizeHandling))
	}

	return nil
}

func awsAwsjson11_serializeDocumentByteMatchStatement(v *types.ByteMatchStatement, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FieldToMatch != nil {
		ok := object.Key("FieldToMatch")
		if err := awsAwsjson11_serializeDocumentFieldToMatch(v.FieldToMatch, ok); err != nil {
			return err
		}
	}

	if len(v.PositionalConstraint) > 0 {
		ok := object.Key("PositionalConstraint")
		ok.String(string(v.PositionalConstraint))
	}

	if v.SearchString != nil {
		ok := object.Key("SearchString")
		ok.Base64EncodeBytes(v.SearchString)
	}

	if v.TextTransformations != nil {
		ok := object.Key("TextTransformations")
		if err := awsAwsjson11_serializeDocumentTextTransformations(v.TextTransformations, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentCaptchaAction(v *types.CaptchaAction, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CustomRequestHandling != nil {
		ok := object.Key("CustomRequestHandling")
		if err := awsAwsjson11_serializeDocumentCustomRequestHandling(v.CustomRequestHandling, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentCaptchaConfig(v *types.CaptchaConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ImmunityTimeProperty != nil {
		ok := object.Key("ImmunityTimeProperty")
		if err := awsAwsjson11_serializeDocumentImmunityTimeProperty(v.ImmunityTimeProperty, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentChallengeAction(v *types.ChallengeAction, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CustomRequestHandling != nil {
		ok := object.Key("CustomRequestHandling")
		if err := awsAwsjson11_serializeDocumentCustomRequestHandling(v.CustomRequestHandling, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentChallengeConfig(v *types.ChallengeConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ImmunityTimeProperty != nil {
		ok := object.Key("ImmunityTimeProperty")
		if err := awsAwsjson11_serializeDocumentImmunityTimeProperty(v.ImmunityTimeProperty, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentClientSideAction(v *types.ClientSideAction, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ExemptUriRegularExpressions != nil {
		ok := object.Key("ExemptUriRegularExpressions")
		if err := awsAwsjson11_serializeDocumentRegularExpressionList(v.ExemptUriRegularExpressions, ok); err != nil {
			return err
		}
	}

	if len(v.Sensitivity) > 0 {
		ok := object.Key("Sensitivity")
		ok.String(string(v.Sensitivity))
	}

	if len(v.UsageOfAction) > 0 {
		ok := object.Key("UsageOfAction")
		ok.String(string(v.UsageOfAction))
	}

	return nil
}

func awsAwsjson11_serializeDocumentClientSideActionConfig(v *types.ClientSideActionConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Challenge != nil {
		ok := object.Key("Challenge")
		if err := awsAwsjson11_serializeDocumentClientSideAction(v.Challenge, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentCondition(v *types.Condition, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ActionCondition != nil {
		ok := object.Key("ActionCondition")
		if err := awsAwsjson11_serializeDocumentActionCondition(v.ActionCondition, ok); err != nil {
			return err
		}
	}

	if v.LabelNameCondition != nil {
		ok := object.Key("LabelNameCondition")
		if err := awsAwsjson11_serializeDocumentLabelNameCondition(v.LabelNameCondition, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentConditions(v []types.Condition, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentCondition(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentCookieMatchPattern(v *types.CookieMatchPattern, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.All != nil {
		ok := object.Key("All")
		if err := awsAwsjson11_serializeDocumentAll(v.All, ok); err != nil {
			return err
		}
	}

	if v.ExcludedCookies != nil {
		ok := object.Key("ExcludedCookies")
		if err := awsAwsjson11_serializeDocumentCookieNames(v.ExcludedCookies, ok); err != nil {
			return err
		}
	}

	if v.IncludedCookies != nil {
		ok := object.Key("IncludedCookies")
		if err := awsAwsjson11_serializeDocumentCookieNames(v.IncludedCookies, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentCookieNames(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentCookies(v *types.Cookies, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MatchPattern != nil {
		ok := object.Key("MatchPattern")
		if err := awsAwsjson11_serializeDocumentCookieMatchPattern(v.MatchPattern, ok); err != nil {
			return err
		}
	}

	if len(v.MatchScope) > 0 {
		ok := object.Key("MatchScope")
		ok.String(string(v.MatchScope))
	}

	if len(v.OversizeHandling) > 0 {
		ok := object.Key("OversizeHandling")
		ok.String(string(v.OversizeHandling))
	}

	return nil
}

func awsAwsjson11_serializeDocumentCountAction(v *types.CountAction, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CustomRequestHandling != nil {
		ok := object.Key("CustomRequestHandling")
		if err := awsAwsjson11_serializeDocumentCustomRequestHandling(v.CustomRequestHandling, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentCountryCodes(v []types.CountryCode, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsAwsjson11_serializeDocumentCustomHTTPHeader(v *types.CustomHTTPHeader, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Value != nil {
		ok := object.Key("Value")
		ok.String(*v.Value)
	}

	return nil
}

func awsAwsjson11_serializeDocumentCustomHTTPHeaders(v []types.CustomHTTPHeader, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentCustomHTTPHeader(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentCustomRequestHandling(v *types.CustomRequestHandling, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.InsertHeaders != nil {
		ok := object.Key("InsertHeaders")
		if err := awsAwsjson11_serializeDocumentCustomHTTPHeaders(v.InsertHeaders, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentCustomResponse(v *types.CustomResponse, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CustomResponseBodyKey != nil {
		ok := object.Key("CustomResponseBodyKey")
		ok.String(*v.CustomResponseBodyKey)
	}

	if v.ResponseCode != nil {
		ok := object.Key("ResponseCode")
		ok.Integer(*v.ResponseCode)
	}

	if v.ResponseHeaders != nil {
		ok := object.Key("ResponseHeaders")
		if err := awsAwsjson11_serializeDocumentCustomHTTPHeaders(v.ResponseHeaders, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentCustomResponseBodies(v map[string]types.CustomResponseBody, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		mapVar := v[key]
		if err := awsAwsjson11_serializeDocumentCustomResponseBody(&mapVar, om); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentCustomResponseBody(v *types.CustomResponseBody, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Content != nil {
		ok := object.Key("Content")
		ok.String(*v.Content)
	}

	if len(v.ContentType) > 0 {
		ok := object.Key("ContentType")
		ok.String(string(v.ContentType))
	}

	return nil
}

func awsAwsjson11_serializeDocumentDataProtection(v *types.DataProtection, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Action) > 0 {
		ok := object.Key("Action")
		ok.String(string(v.Action))
	}

	if v.ExcludeRateBasedDetails {
		ok := object.Key("ExcludeRateBasedDetails")
		ok.Boolean(v.ExcludeRateBasedDetails)
	}

	if v.ExcludeRuleMatchDetails {
		ok := object.Key("ExcludeRuleMatchDetails")
		ok.Boolean(v.ExcludeRuleMatchDetails)
	}

	if v.Field != nil {
		ok := object.Key("Field")
		if err := awsAwsjson11_serializeDocumentFieldToProtect(v.Field, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentDataProtectionConfig(v *types.DataProtectionConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DataProtections != nil {
		ok := object.Key("DataProtections")
		if err := awsAwsjson11_serializeDocumentDataProtections(v.DataProtections, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentDataProtections(v []types.DataProtection, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentDataProtection(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentDefaultAction(v *types.DefaultAction, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Allow != nil {
		ok := object.Key("Allow")
		if err := awsAwsjson11_serializeDocumentAllowAction(v.Allow, ok); err != nil {
			return err
		}
	}

	if v.Block != nil {
		ok := object.Key("Block")
		if err := awsAwsjson11_serializeDocumentBlockAction(v.Block, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentEmailField(v *types.EmailField, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Identifier != nil {
		ok := object.Key("Identifier")
		ok.String(*v.Identifier)
	}

	return nil
}

func awsAwsjson11_serializeDocumentExcludedRule(v *types.ExcludedRule, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

func awsAwsjson11_serializeDocumentExcludedRules(v []types.ExcludedRule, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentExcludedRule(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentFieldToMatch(v *types.FieldToMatch, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AllQueryArguments != nil {
		ok := object.Key("AllQueryArguments")
		if err := awsAwsjson11_serializeDocumentAllQueryArguments(v.AllQueryArguments, ok); err != nil {
			return err
		}
	}

	if v.Body != nil {
		ok := object.Key("Body")
		if err := awsAwsjson11_serializeDocumentBody(v.Body, ok); err != nil {
			return err
		}
	}

	if v.Cookies != nil {
		ok := object.Key("Cookies")
		if err := awsAwsjson11_serializeDocumentCookies(v.Cookies, ok); err != nil {
			return err
		}
	}

	if v.HeaderOrder != nil {
		ok := object.Key("HeaderOrder")
		if err := awsAwsjson11_serializeDocumentHeaderOrder(v.HeaderOrder, ok); err != nil {
			return err
		}
	}

	if v.Headers != nil {
		ok := object.Key("Headers")
		if err := awsAwsjson11_serializeDocumentHeaders(v.Headers, ok); err != nil {
			return err
		}
	}

	if v.JA3Fingerprint != nil {
		ok := object.Key("JA3Fingerprint")
		if err := awsAwsjson11_serializeDocumentJA3Fingerprint(v.JA3Fingerprint, ok); err != nil {
			return err
		}
	}

	if v.JA4Fingerprint != nil {
		ok := object.Key("JA4Fingerprint")
		if err := awsAwsjson11_serializeDocumentJA4Fingerprint(v.JA4Fingerprint, ok); err != nil {
			return err
		}
	}

	if v.JsonBody != nil {
		ok := object.Key("JsonBody")
		if err := awsAwsjson11_serializeDocumentJsonBody(v.JsonBody, ok); err != nil {
			return err
		}
	}

	if v.Method != nil {
		ok := object.Key("Method")
		if err := awsAwsjson11_serializeDocumentMethod(v.Method, ok); err != nil {
			return err
		}
	}

	if v.QueryString != nil {
		ok := object.Key("QueryString")
		if err := awsAwsjson11_serializeDocumentQueryString(v.QueryString, ok); err != nil {
			return err
		}
	}

	if v.SingleHeader != nil {
		ok := object.Key("SingleHeader")
		if err := awsAwsjson11_serializeDocumentSingleHeader(v.SingleHeader, ok); err != nil {
			return err
		}
	}

	if v.SingleQueryArgument != nil {
		ok := object.Key("SingleQueryArgument")
		if err := awsAwsjson11_serializeDocumentSingleQueryArgument(v.SingleQueryArgument, ok); err != nil {
			return err
		}
	}

	if v.UriFragment != nil {
		ok := object.Key("UriFragment")
		if err := awsAwsjson11_serializeDocumentUriFragment(v.UriFragment, ok); err != nil {
			return err
		}
	}

	if v.UriPath != nil {
		ok := object.Key("UriPath")
		if err := awsAwsjson11_serializeDocumentUriPath(v.UriPath, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentFieldToProtect(v *types.FieldToProtect, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FieldKeys != nil {
		ok := object.Key("FieldKeys")
		if err := awsAwsjson11_serializeDocumentFieldToProtectKeys(v.FieldKeys, ok); err != nil {
			return err
		}
	}

	if len(v.FieldType) > 0 {
		ok := object.Key("FieldType")
		ok.String(string(v.FieldType))
	}

	return nil
}

func awsAwsjson11_serializeDocumentFieldToProtectKeys(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentFilter(v *types.Filter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Behavior) > 0 {
		ok := object.Key("Behavior")
		ok.String(string(v.Behavior))
	}

	if v.Conditions != nil {
		ok := object.Key("Conditions")
		if err := awsAwsjson11_serializeDocumentConditions(v.Conditions, ok); err != nil {
			return err
		}
	}

	if len(v.Requirement) > 0 {
		ok := object.Key("Requirement")
		ok.String(string(v.Requirement))
	}

	return nil
}

func awsAwsjson11_serializeDocumentFilters(v []types.Filter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentFilter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentForwardedIPConfig(v *types.ForwardedIPConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.FallbackBehavior) > 0 {
		ok := object.Key("FallbackBehavior")
		ok.String(string(v.FallbackBehavior))
	}

	if v.HeaderName != nil {
		ok := object.Key("HeaderName")
		ok.String(*v.HeaderName)
	}

	return nil
}

func awsAwsjson11_serializeDocumentGeoMatchStatement(v *types.GeoMatchStatement, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CountryCodes != nil {
		ok := object.Key("CountryCodes")
		if err := awsAwsjson11_serializeDocumentCountryCodes(v.CountryCodes, ok); err != nil {
			return err
		}
	}

	if v.ForwardedIPConfig != nil {
		ok := object.Key("ForwardedIPConfig")
		if err := awsAwsjson11_serializeDocumentForwardedIPConfig(v.ForwardedIPConfig, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentHeaderMatchPattern(v *types.HeaderMatchPattern, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.All != nil {
		ok := object.Key("All")
		if err := awsAwsjson11_serializeDocumentAll(v.All, ok); err != nil {
			return err
		}
	}

	if v.ExcludedHeaders != nil {
		ok := object.Key("ExcludedHeaders")
		if err := awsAwsjson11_serializeDocumentHeaderNames(v.ExcludedHeaders, ok); err != nil {
			return err
		}
	}

	if v.IncludedHeaders != nil {
		ok := object.Key("IncludedHeaders")
		if err := awsAwsjson11_serializeDocumentHeaderNames(v.IncludedHeaders, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentHeaderNames(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentHeaderOrder(v *types.HeaderOrder, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.OversizeHandling) > 0 {
		ok := object.Key("OversizeHandling")
		ok.String(string(v.OversizeHandling))
	}

	return nil
}

func awsAwsjson11_serializeDocumentHeaders(v *types.Headers, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MatchPattern != nil {
		ok := object.Key("MatchPattern")
		if err := awsAwsjson11_serializeDocumentHeaderMatchPattern(v.MatchPattern, ok); err != nil {
			return err
		}
	}

	if len(v.MatchScope) > 0 {
		ok := object.Key("MatchScope")
		ok.String(string(v.MatchScope))
	}

	if len(v.OversizeHandling) > 0 {
		ok := object.Key("OversizeHandling")
		ok.String(string(v.OversizeHandling))
	}

	return nil
}

func awsAwsjson11_serializeDocumentImmunityTimeProperty(v *types.ImmunityTimeProperty, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ImmunityTime != nil {
		ok := object.Key("ImmunityTime")
		ok.Long(*v.ImmunityTime)
	}

	return nil
}

func awsAwsjson11_serializeDocumentIPAddresses(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentIPSetForwardedIPConfig(v *types.IPSetForwardedIPConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.FallbackBehavior) > 0 {
		ok := object.Key("FallbackBehavior")
		ok.String(string(v.FallbackBehavior))
	}

	if v.HeaderName != nil {
		ok := object.Key("HeaderName")
		ok.String(*v.HeaderName)
	}

	if len(v.Position) > 0 {
		ok := object.Key("Position")
		ok.String(string(v.Position))
	}

	return nil
}

func awsAwsjson11_serializeDocumentIPSetReferenceStatement(v *types.IPSetReferenceStatement, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ARN != nil {
		ok := object.Key("ARN")
		ok.String(*v.ARN)
	}

	if v.IPSetForwardedIPConfig != nil {
		ok := object.Key("IPSetForwardedIPConfig")
		if err := awsAwsjson11_serializeDocumentIPSetForwardedIPConfig(v.IPSetForwardedIPConfig, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentJA3Fingerprint(v *types.JA3Fingerprint, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.FallbackBehavior) > 0 {
		ok := object.Key("FallbackBehavior")
		ok.String(string(v.FallbackBehavior))
	}

	return nil
}

func awsAwsjson11_serializeDocumentJA4Fingerprint(v *types.JA4Fingerprint, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.FallbackBehavior) > 0 {
		ok := object.Key("FallbackBehavior")
		ok.String(string(v.FallbackBehavior))
	}

	return nil
}

func awsAwsjson11_serializeDocumentJsonBody(v *types.JsonBody, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.InvalidFallbackBehavior) > 0 {
		ok := object.Key("InvalidFallbackBehavior")
		ok.String(string(v.InvalidFallbackBehavior))
	}

	if v.MatchPattern != nil {
		ok := object.Key("MatchPattern")
		if err := awsAwsjson11_serializeDocumentJsonMatchPattern(v.MatchPattern, ok); err != nil {
			return err
		}
	}

	if len(v.MatchScope) > 0 {
		ok := object.Key("MatchScope")
		ok.String(string(v.MatchScope))
	}

	if len(v.OversizeHandling) > 0 {
		ok := object.Key("OversizeHandling")
		ok.String(string(v.OversizeHandling))
	}

	return nil
}

func awsAwsjson11_serializeDocumentJsonMatchPattern(v *types.JsonMatchPattern, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.All != nil {
		ok := object.Key("All")
		if err := awsAwsjson11_serializeDocumentAll(v.All, ok); err != nil {
			return err
		}
	}

	if v.IncludedPaths != nil {
		ok := object.Key("IncludedPaths")
		if err := awsAwsjson11_serializeDocumentJsonPointerPaths(v.IncludedPaths, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentJsonPointerPaths(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentLabel(v *types.Label, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

func awsAwsjson11_serializeDocumentLabelMatchStatement(v *types.LabelMatchStatement, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Key != nil {
		ok := object.Key("Key")
		ok.String(*v.Key)
	}

	if len(v.Scope) > 0 {
		ok := object.Key("Scope")
		ok.String(string(v.Scope))
	}

	return nil
}

func awsAwsjson11_serializeDocumentLabelNameCondition(v *types.LabelNameCondition, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LabelName != nil {
		ok := object.Key("LabelName")
		ok.String(*v.LabelName)
	}

	return nil
}

func awsAwsjson11_serializeDocumentLabels(v []types.Label, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentLabel(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentLogDestinationConfigs(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentLoggingConfiguration(v *types.LoggingConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LogDestinationConfigs != nil {
		ok := object.Key("LogDestinationConfigs")
		if err := awsAwsjson11_serializeDocumentLogDestinationConfigs(v.LogDestinationConfigs, ok); err != nil {
			return err
		}
	}

	if v.LoggingFilter != nil {
		ok := object.Key("LoggingFilter")
		if err := awsAwsjson11_serializeDocumentLoggingFilter(v.LoggingFilter, ok); err != nil {
			return err
		}
	}

	if len(v.LogScope) > 0 {
		ok := object.Key("LogScope")
		ok.String(string(v.LogScope))
	}

	if len(v.LogType) > 0 {
		ok := object.Key("LogType")
		ok.String(string(v.LogType))
	}

	if v.ManagedByFirewallManager {
		ok := object.Key("ManagedByFirewallManager")
		ok.Boolean(v.ManagedByFirewallManager)
	}

	if v.RedactedFields != nil {
		ok := object.Key("RedactedFields")
		if err := awsAwsjson11_serializeDocumentRedactedFields(v.RedactedFields, ok); err != nil {
			return err
		}
	}

	if v.ResourceArn != nil {
		ok := object.Key("ResourceArn")
		ok.String(*v.ResourceArn)
	}

	return nil
}

func awsAwsjson11_serializeDocumentLoggingFilter(v *types.LoggingFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.DefaultBehavior) > 0 {
		ok := object.Key("DefaultBehavior")
		ok.String(string(v.DefaultBehavior))
	}

	if v.Filters != nil {
		ok := object.Key("Filters")
		if err := awsAwsjson11_serializeDocumentFilters(v.Filters, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentManagedRuleGroupConfig(v *types.ManagedRuleGroupConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AWSManagedRulesACFPRuleSet != nil {
		ok := object.Key("AWSManagedRulesACFPRuleSet")
		if err := awsAwsjson11_serializeDocumentAWSManagedRulesACFPRuleSet(v.AWSManagedRulesACFPRuleSet, ok); err != nil {
			return err
		}
	}

	if v.AWSManagedRulesAntiDDoSRuleSet != nil {
		ok := object.Key("AWSManagedRulesAntiDDoSRuleSet")
		if err := awsAwsjson11_serializeDocumentAWSManagedRulesAntiDDoSRuleSet(v.AWSManagedRulesAntiDDoSRuleSet, ok); err != nil {
			return err
		}
	}

	if v.AWSManagedRulesATPRuleSet != nil {
		ok := object.Key("AWSManagedRulesATPRuleSet")
		if err := awsAwsjson11_serializeDocumentAWSManagedRulesATPRuleSet(v.AWSManagedRulesATPRuleSet, ok); err != nil {
			return err
		}
	}

	if v.AWSManagedRulesBotControlRuleSet != nil {
		ok := object.Key("AWSManagedRulesBotControlRuleSet")
		if err := awsAwsjson11_serializeDocumentAWSManagedRulesBotControlRuleSet(v.AWSManagedRulesBotControlRuleSet, ok); err != nil {
			return err
		}
	}

	if v.LoginPath != nil {
		ok := object.Key("LoginPath")
		ok.String(*v.LoginPath)
	}

	if v.PasswordField != nil {
		ok := object.Key("PasswordField")
		if err := awsAwsjson11_serializeDocumentPasswordField(v.PasswordField, ok); err != nil {
			return err
		}
	}

	if len(v.PayloadType) > 0 {
		ok := object.Key("PayloadType")
		ok.String(string(v.PayloadType))
	}

	if v.UsernameField != nil {
		ok := object.Key("UsernameField")
		if err := awsAwsjson11_serializeDocumentUsernameField(v.UsernameField, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentManagedRuleGroupConfigs(v []types.ManagedRuleGroupConfig, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentManagedRuleGroupConfig(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentManagedRuleGroupStatement(v *types.ManagedRuleGroupStatement, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ExcludedRules != nil {
		ok := object.Key("ExcludedRules")
		if err := awsAwsjson11_serializeDocumentExcludedRules(v.ExcludedRules, ok); err != nil {
			return err
		}
	}

	if v.ManagedRuleGroupConfigs != nil {
		ok := object.Key("ManagedRuleGroupConfigs")
		if err := awsAwsjson11_serializeDocumentManagedRuleGroupConfigs(v.ManagedRuleGroupConfigs, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.RuleActionOverrides != nil {
		ok := object.Key("RuleActionOverrides")
		if err := awsAwsjson11_serializeDocumentRuleActionOverrides(v.RuleActionOverrides, ok); err != nil {
			return err
		}
	}

	if v.ScopeDownStatement != nil {
		ok := object.Key("ScopeDownStatement")
		if err := awsAwsjson11_serializeDocumentStatement(v.ScopeDownStatement, ok); err != nil {
			return err
		}
	}

	if v.VendorName != nil {
		ok := object.Key("VendorName")
		ok.String(*v.VendorName)
	}

	if v.Version != nil {
		ok := object.Key("Version")
		ok.String(*v.Version)
	}

	return nil
}

func awsAwsjson11_serializeDocumentMethod(v *types.Method, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	return nil
}

func awsAwsjson11_serializeDocumentNoneAction(v *types.NoneAction, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	return nil
}

func awsAwsjson11_serializeDocumentNotStatement(v *types.NotStatement, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Statement != nil {
		ok := object.Key("Statement")
		if err := awsAwsjson11_serializeDocumentStatement(v.Statement, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentOnSourceDDoSProtectionConfig(v *types.OnSourceDDoSProtectionConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.ALBLowReputationMode) > 0 {
		ok := object.Key("ALBLowReputationMode")
		ok.String(string(v.ALBLowReputationMode))
	}

	return nil
}

func awsAwsjson11_serializeDocumentOrStatement(v *types.OrStatement, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Statements != nil {
		ok := object.Key("Statements")
		if err := awsAwsjson11_serializeDocumentStatements(v.Statements, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentOverrideAction(v *types.OverrideAction, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Count != nil {
		ok := object.Key("Count")
		if err := awsAwsjson11_serializeDocumentCountAction(v.Count, ok); err != nil {
			return err
		}
	}

	if v.None != nil {
		ok := object.Key("None")
		if err := awsAwsjson11_serializeDocumentNoneAction(v.None, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentPasswordField(v *types.PasswordField, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Identifier != nil {
		ok := object.Key("Identifier")
		ok.String(*v.Identifier)
	}

	return nil
}

func awsAwsjson11_serializeDocumentPhoneNumberField(v *types.PhoneNumberField, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Identifier != nil {
		ok := object.Key("Identifier")
		ok.String(*v.Identifier)
	}

	return nil
}

func awsAwsjson11_serializeDocumentPhoneNumberFields(v []types.PhoneNumberField, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentPhoneNumberField(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentQueryString(v *types.QueryString, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	return nil
}

func awsAwsjson11_serializeDocumentRateBasedStatement(v *types.RateBasedStatement, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AggregateKeyType) > 0 {
		ok := object.Key("AggregateKeyType")
		ok.String(string(v.AggregateKeyType))
	}

	if v.CustomKeys != nil {
		ok := object.Key("CustomKeys")
		if err := awsAwsjson11_serializeDocumentRateBasedStatementCustomKeys(v.CustomKeys, ok); err != nil {
			return err
		}
	}

	if v.EvaluationWindowSec != 0 {
		ok := object.Key("EvaluationWindowSec")
		ok.Long(v.EvaluationWindowSec)
	}

	if v.ForwardedIPConfig != nil {
		ok := object.Key("ForwardedIPConfig")
		if err := awsAwsjson11_serializeDocumentForwardedIPConfig(v.ForwardedIPConfig, ok); err != nil {
			return err
		}
	}

	if v.Limit != nil {
		ok := object.Key("Limit")
		ok.Long(*v.Limit)
	}

	if v.ScopeDownStatement != nil {
		ok := object.Key("ScopeDownStatement")
		if err := awsAwsjson11_serializeDocumentStatement(v.ScopeDownStatement, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentRateBasedStatementCustomKey(v *types.RateBasedStatementCustomKey, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ASN != nil {
		ok := object.Key("ASN")
		if err := awsAwsjson11_serializeDocumentRateLimitAsn(v.ASN, ok); err != nil {
			return err
		}
	}

	if v.Cookie != nil {
		ok := object.Key("Cookie")
		if err := awsAwsjson11_serializeDocumentRateLimitCookie(v.Cookie, ok); err != nil {
			return err
		}
	}

	if v.ForwardedIP != nil {
		ok := object.Key("ForwardedIP")
		if err := awsAwsjson11_serializeDocumentRateLimitForwardedIP(v.ForwardedIP, ok); err != nil {
			return err
		}
	}

	if v.Header != nil {
		ok := object.Key("Header")
		if err := awsAwsjson11_serializeDocumentRateLimitHeader(v.Header, ok); err != nil {
			return err
		}
	}

	if v.HTTPMethod != nil {
		ok := object.Key("HTTPMethod")
		if err := awsAwsjson11_serializeDocumentRateLimitHTTPMethod(v.HTTPMethod, ok); err != nil {
			return err
		}
	}

	if v.IP != nil {
		ok := object.Key("IP")
		if err := awsAwsjson11_serializeDocumentRateLimitIP(v.IP, ok); err != nil {
			return err
		}
	}

	if v.JA3Fingerprint != nil {
		ok := object.Key("JA3Fingerprint")
		if err := awsAwsjson11_serializeDocumentRateLimitJA3Fingerprint(v.JA3Fingerprint, ok); err != nil {
			return err
		}
	}

	if v.JA4Fingerprint != nil {
		ok := object.Key("JA4Fingerprint")
		if err := awsAwsjson11_serializeDocumentRateLimitJA4Fingerprint(v.JA4Fingerprint, ok); err != nil {
			return err
		}
	}

	if v.LabelNamespace != nil {
		ok := object.Key("LabelNamespace")
		if err := awsAwsjson11_serializeDocumentRateLimitLabelNamespace(v.LabelNamespace, ok); err != nil {
			return err
		}
	}

	if v.QueryArgument != nil {
		ok := object.Key("QueryArgument")
		if err := awsAwsjson11_serializeDocumentRateLimitQueryArgument(v.QueryArgument, ok); err != nil {
			return err
		}
	}

	if v.QueryString != nil {
		ok := object.Key("QueryString")
		if err := awsAwsjson11_serializeDocumentRateLimitQueryString(v.QueryString, ok); err != nil {
			return err
		}
	}

	if v.UriPath != nil {
		ok := object.Key("UriPath")
		if err := awsAwsjson11_serializeDocumentRateLimitUriPath(v.UriPath, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentRateBasedStatementCustomKeys(v []types.RateBasedStatementCustomKey, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentRateBasedStatementCustomKey(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentRateLimitAsn(v *types.RateLimitAsn, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	return nil
}

func awsAwsjson11_serializeDocumentRateLimitCookie(v *types.RateLimitCookie, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.TextTransformations != nil {
		ok := object.Key("TextTransformations")
		if err := awsAwsjson11_serializeDocumentTextTransformations(v.TextTransformations, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentRateLimitForwardedIP(v *types.RateLimitForwardedIP, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	return nil
}

func awsAwsjson11_serializeDocumentRateLimitHeader(v *types.RateLimitHeader, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.TextTransformations != nil {
		ok := object.Key("TextTransformations")
		if err := awsAwsjson11_serializeDocumentTextTransformations(v.TextTransformations, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentRateLimitHTTPMethod(v *types.RateLimitHTTPMethod, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	return nil
}

func awsAwsjson11_serializeDocumentRateLimitIP(v *types.RateLimitIP, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	return nil
}

func awsAwsjson11_serializeDocumentRateLimitJA3Fingerprint(v *types.RateLimitJA3Fingerprint, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.FallbackBehavior) > 0 {
		ok := object.Key("FallbackBehavior")
		ok.String(string(v.FallbackBehavior))
	}

	return nil
}

func awsAwsjson11_serializeDocumentRateLimitJA4Fingerprint(v *types.RateLimitJA4Fingerprint, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.FallbackBehavior) > 0 {
		ok := object.Key("FallbackBehavior")
		ok.String(string(v.FallbackBehavior))
	}

	return nil
}

func awsAwsjson11_serializeDocumentRateLimitLabelNamespace(v *types.RateLimitLabelNamespace, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Namespace != nil {
		ok := object.Key("Namespace")
		ok.String(*v.Namespace)
	}

	return nil
}

func awsAwsjson11_serializeDocumentRateLimitQueryArgument(v *types.RateLimitQueryArgument, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.TextTransformations != nil {
		ok := object.Key("TextTransformations")
		if err := awsAwsjson11_serializeDocumentTextTransformations(v.TextTransformations, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentRateLimitQueryString(v *types.RateLimitQueryString, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.TextTransformations != nil {
		ok := object.Key("TextTransformations")
		if err := awsAwsjson11_serializeDocumentTextTransformations(v.TextTransformations, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentRateLimitUriPath(v *types.RateLimitUriPath, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.TextTransformations != nil {
		ok := object.Key("TextTransformations")
		if err := awsAwsjson11_serializeDocumentTextTransformations(v.TextTransformations, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentRedactedFields(v []types.FieldToMatch, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentFieldToMatch(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentRegex(v *types.Regex, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.RegexString != nil {
		ok := object.Key("RegexString")
		ok.String(*v.RegexString)
	}

	return nil
}

func awsAwsjson11_serializeDocumentRegexMatchStatement(v *types.RegexMatchStatement, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FieldToMatch != nil {
		ok := object.Key("FieldToMatch")
		if err := awsAwsjson11_serializeDocumentFieldToMatch(v.FieldToMatch, ok); err != nil {
			return err
		}
	}

	if v.RegexString != nil {
		ok := object.Key("RegexString")
		ok.String(*v.RegexString)
	}

	if v.TextTransformations != nil {
		ok := object.Key("TextTransformations")
		if err := awsAwsjson11_serializeDocumentTextTransformations(v.TextTransformations, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentRegexPatternSetReferenceStatement(v *types.RegexPatternSetReferenceStatement, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ARN != nil {
		ok := object.Key("ARN")
		ok.String(*v.ARN)
	}

	if v.FieldToMatch != nil {
		ok := object.Key("FieldToMatch")
		if err := awsAwsjson11_serializeDocumentFieldToMatch(v.FieldToMatch, ok); err != nil {
			return err
		}
	}

	if v.TextTransformations != nil {
		ok := object.Key("TextTransformations")
		if err := awsAwsjson11_serializeDocumentTextTransformations(v.TextTransformations, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentRegularExpressionList(v []types.Regex, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentRegex(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentRequestBody(v map[string]types.RequestBodyAssociatedResourceTypeConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		mapVar := v[key]
		if err := awsAwsjson11_serializeDocumentRequestBodyAssociatedResourceTypeConfig(&mapVar, om); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentRequestBodyAssociatedResourceTypeConfig(v *types.RequestBodyAssociatedResourceTypeConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.DefaultSizeInspectionLimit) > 0 {
		ok := object.Key("DefaultSizeInspectionLimit")
		ok.String(string(v.DefaultSizeInspectionLimit))
	}

	return nil
}

func awsAwsjson11_serializeDocumentRequestInspection(v *types.RequestInspection, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PasswordField != nil {
		ok := object.Key("PasswordField")
		if err := awsAwsjson11_serializeDocumentPasswordField(v.PasswordField, ok); err != nil {
			return err
		}
	}

	if len(v.PayloadType) > 0 {
		ok := object.Key("PayloadType")
		ok.String(string(v.PayloadType))
	}

	if v.UsernameField != nil {
		ok := object.Key("UsernameField")
		if err := awsAwsjson11_serializeDocumentUsernameField(v.UsernameField, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentRequestInspectionACFP(v *types.RequestInspectionACFP, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AddressFields != nil {
		ok := object.Key("AddressFields")
		if err := awsAwsjson11_serializeDocumentAddressFields(v.AddressFields, ok); err != nil {
			return err
		}
	}

	if v.EmailField != nil {
		ok := object.Key("EmailField")
		if err := awsAwsjson11_serializeDocumentEmailField(v.EmailField, ok); err != nil {
			return err
		}
	}

	if v.PasswordField != nil {
		ok := object.Key("PasswordField")
		if err := awsAwsjson11_serializeDocumentPasswordField(v.PasswordField, ok); err != nil {
			return err
		}
	}

	if len(v.PayloadType) > 0 {
		ok := object.Key("PayloadType")
		ok.String(string(v.PayloadType))
	}

	if v.PhoneNumberFields != nil {
		ok := object.Key("PhoneNumberFields")
		if err := awsAwsjson11_serializeDocumentPhoneNumberFields(v.PhoneNumberFields, ok); err != nil {
			return err
		}
	}

	if v.UsernameField != nil {
		ok := object.Key("UsernameField")
		if err := awsAwsjson11_serializeDocumentUsernameField(v.UsernameField, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentResponseInspection(v *types.ResponseInspection, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BodyContains != nil {
		ok := object.Key("BodyContains")
		if err := awsAwsjson11_serializeDocumentResponseInspectionBodyContains(v.BodyContains, ok); err != nil {
			return err
		}
	}

	if v.Header != nil {
		ok := object.Key("Header")
		if err := awsAwsjson11_serializeDocumentResponseInspectionHeader(v.Header, ok); err != nil {
			return err
		}
	}

	if v.Json != nil {
		ok := object.Key("Json")
		if err := awsAwsjson11_serializeDocumentResponseInspectionJson(v.Json, ok); err != nil {
			return err
		}
	}

	if v.StatusCode != nil {
		ok := object.Key("StatusCode")
		if err := awsAwsjson11_serializeDocumentResponseInspectionStatusCode(v.StatusCode, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentResponseInspectionBodyContains(v *types.ResponseInspectionBodyContains, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FailureStrings != nil {
		ok := object.Key("FailureStrings")
		if err := awsAwsjson11_serializeDocumentResponseInspectionBodyContainsFailureStrings(v.FailureStrings, ok); err != nil {
			return err
		}
	}

	if v.SuccessStrings != nil {
		ok := object.Key("SuccessStrings")
		if err := awsAwsjson11_serializeDocumentResponseInspectionBodyContainsSuccessStrings(v.SuccessStrings, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentResponseInspectionBodyContainsFailureStrings(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentResponseInspectionBodyContainsSuccessStrings(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentResponseInspectionHeader(v *types.ResponseInspectionHeader, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FailureValues != nil {
		ok := object.Key("FailureValues")
		if err := awsAwsjson11_serializeDocumentResponseInspectionHeaderFailureValues(v.FailureValues, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.SuccessValues != nil {
		ok := object.Key("SuccessValues")
		if err := awsAwsjson11_serializeDocumentResponseInspectionHeaderSuccessValues(v.SuccessValues, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentResponseInspectionHeaderFailureValues(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentResponseInspectionHeaderSuccessValues(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentResponseInspectionJson(v *types.ResponseInspectionJson, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FailureValues != nil {
		ok := object.Key("FailureValues")
		if err := awsAwsjson11_serializeDocumentResponseInspectionJsonFailureValues(v.FailureValues, ok); err != nil {
			return err
		}
	}

	if v.Identifier != nil {
		ok := object.Key("Identifier")
		ok.String(*v.Identifier)
	}

	if v.SuccessValues != nil {
		ok := object.Key("SuccessValues")
		if err := awsAwsjson11_serializeDocumentResponseInspectionJsonSuccessValues(v.SuccessValues, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentResponseInspectionJsonFailureValues(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentResponseInspectionJsonSuccessValues(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentResponseInspectionStatusCode(v *types.ResponseInspectionStatusCode, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FailureCodes != nil {
		ok := object.Key("FailureCodes")
		if err := awsAwsjson11_serializeDocumentResponseInspectionStatusCodeFailureCodes(v.FailureCodes, ok); err != nil {
			return err
		}
	}

	if v.SuccessCodes != nil {
		ok := object.Key("SuccessCodes")
		if err := awsAwsjson11_serializeDocumentResponseInspectionStatusCodeSuccessCodes(v.SuccessCodes, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentResponseInspectionStatusCodeFailureCodes(v []int32, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.Integer(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentResponseInspectionStatusCodeSuccessCodes(v []int32, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.Integer(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentRule(v *types.Rule, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Action != nil {
		ok := object.Key("Action")
		if err := awsAwsjson11_serializeDocumentRuleAction(v.Action, ok); err != nil {
			return err
		}
	}

	if v.CaptchaConfig != nil {
		ok := object.Key("CaptchaConfig")
		if err := awsAwsjson11_serializeDocumentCaptchaConfig(v.CaptchaConfig, ok); err != nil {
			return err
		}
	}

	if v.ChallengeConfig != nil {
		ok := object.Key("ChallengeConfig")
		if err := awsAwsjson11_serializeDocumentChallengeConfig(v.ChallengeConfig, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.OverrideAction != nil {
		ok := object.Key("OverrideAction")
		if err := awsAwsjson11_serializeDocumentOverrideAction(v.OverrideAction, ok); err != nil {
			return err
		}
	}

	{
		ok := object.Key("Priority")
		ok.Integer(v.Priority)
	}

	if v.RuleLabels != nil {
		ok := object.Key("RuleLabels")
		if err := awsAwsjson11_serializeDocumentLabels(v.RuleLabels, ok); err != nil {
			return err
		}
	}

	if v.Statement != nil {
		ok := object.Key("Statement")
		if err := awsAwsjson11_serializeDocumentStatement(v.Statement, ok); err != nil {
			return err
		}
	}

	if v.VisibilityConfig != nil {
		ok := object.Key("VisibilityConfig")
		if err := awsAwsjson11_serializeDocumentVisibilityConfig(v.VisibilityConfig, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentRuleAction(v *types.RuleAction, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Allow != nil {
		ok := object.Key("Allow")
		if err := awsAwsjson11_serializeDocumentAllowAction(v.Allow, ok); err != nil {
			return err
		}
	}

	if v.Block != nil {
		ok := object.Key("Block")
		if err := awsAwsjson11_serializeDocumentBlockAction(v.Block, ok); err != nil {
			return err
		}
	}

	if v.Captcha != nil {
		ok := object.Key("Captcha")
		if err := awsAwsjson11_serializeDocumentCaptchaAction(v.Captcha, ok); err != nil {
			return err
		}
	}

	if v.Challenge != nil {
		ok := object.Key("Challenge")
		if err := awsAwsjson11_serializeDocumentChallengeAction(v.Challenge, ok); err != nil {
			return err
		}
	}

	if v.Count != nil {
		ok := object.Key("Count")
		if err := awsAwsjson11_serializeDocumentCountAction(v.Count, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentRuleActionOverride(v *types.RuleActionOverride, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ActionToUse != nil {
		ok := object.Key("ActionToUse")
		if err := awsAwsjson11_serializeDocumentRuleAction(v.ActionToUse, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

func awsAwsjson11_serializeDocumentRuleActionOverrides(v []types.RuleActionOverride, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentRuleActionOverride(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentRuleGroupReferenceStatement(v *types.RuleGroupReferenceStatement, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ARN != nil {
		ok := object.Key("ARN")
		ok.String(*v.ARN)
	}

	if v.ExcludedRules != nil {
		ok := object.Key("ExcludedRules")
		if err := awsAwsjson11_serializeDocumentExcludedRules(v.ExcludedRules, ok); err != nil {
			return err
		}
	}

	if v.RuleActionOverrides != nil {
		ok := object.Key("RuleActionOverrides")
		if err := awsAwsjson11_serializeDocumentRuleActionOverrides(v.RuleActionOverrides, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentRules(v []types.Rule, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentRule(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentSingleHeader(v *types.SingleHeader, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

func awsAwsjson11_serializeDocumentSingleQueryArgument(v *types.SingleQueryArgument, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

func awsAwsjson11_serializeDocumentSizeConstraintStatement(v *types.SizeConstraintStatement, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.ComparisonOperator) > 0 {
		ok := object.Key("ComparisonOperator")
		ok.String(string(v.ComparisonOperator))
	}

	if v.FieldToMatch != nil {
		ok := object.Key("FieldToMatch")
		if err := awsAwsjson11_serializeDocumentFieldToMatch(v.FieldToMatch, ok); err != nil {
			return err
		}
	}

	{
		ok := object.Key("Size")
		ok.Long(v.Size)
	}

	if v.TextTransformations != nil {
		ok := object.Key("TextTransformations")
		if err := awsAwsjson11_serializeDocumentTextTransformations(v.TextTransformations, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentSqliMatchStatement(v *types.SqliMatchStatement, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FieldToMatch != nil {
		ok := object.Key("FieldToMatch")
		if err := awsAwsjson11_serializeDocumentFieldToMatch(v.FieldToMatch, ok); err != nil {
			return err
		}
	}

	if len(v.SensitivityLevel) > 0 {
		ok := object.Key("SensitivityLevel")
		ok.String(string(v.SensitivityLevel))
	}

	if v.TextTransformations != nil {
		ok := object.Key("TextTransformations")
		if err := awsAwsjson11_serializeDocumentTextTransformations(v.TextTransformations, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentStatement(v *types.Statement, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AndStatement != nil {
		ok := object.Key("AndStatement")
		if err := awsAwsjson11_serializeDocumentAndStatement(v.AndStatement, ok); err != nil {
			return err
		}
	}

	if v.AsnMatchStatement != nil {
		ok := object.Key("AsnMatchStatement")
		if err := awsAwsjson11_serializeDocumentAsnMatchStatement(v.AsnMatchStatement, ok); err != nil {
			return err
		}
	}

	if v.ByteMatchStatement != nil {
		ok := object.Key("ByteMatchStatement")
		if err := awsAwsjson11_serializeDocumentByteMatchStatement(v.ByteMatchStatement, ok); err != nil {
			return err
		}
	}

	if v.GeoMatchStatement != nil {
		ok := object.Key("GeoMatchStatement")
		if err := awsAwsjson11_serializeDocumentGeoMatchStatement(v.GeoMatchStatement, ok); err != nil {
			return err
		}
	}

	if v.IPSetReferenceStatement != nil {
		ok := object.Key("IPSetReferenceStatement")
		if err := awsAwsjson11_serializeDocumentIPSetReferenceStatement(v.IPSetReferenceStatement, ok); err != nil {
			return err
		}
	}

	if v.LabelMatchStatement != nil {
		ok := object.Key("LabelMatchStatement")
		if err := awsAwsjson11_serializeDocumentLabelMatchStatement(v.LabelMatchStatement, ok); err != nil {
			return err
		}
	}

	if v.ManagedRuleGroupStatement != nil {
		ok := object.Key("ManagedRuleGroupStatement")
		if err := awsAwsjson11_serializeDocumentManagedRuleGroupStatement(v.ManagedRuleGroupStatement, ok); err != nil {
			return err
		}
	}

	if v.NotStatement != nil {
		ok := object.Key("NotStatement")
		if err := awsAwsjson11_serializeDocumentNotStatement(v.NotStatement, ok); err != nil {
			return err
		}
	}

	if v.OrStatement != nil {
		ok := object.Key("OrStatement")
		if err := awsAwsjson11_serializeDocumentOrStatement(v.OrStatement, ok); err != nil {
			return err
		}
	}

	if v.RateBasedStatement != nil {
		ok := object.Key("RateBasedStatement")
		if err := awsAwsjson11_serializeDocumentRateBasedStatement(v.RateBasedStatement, ok); err != nil {
			return err
		}
	}

	if v.RegexMatchStatement != nil {
		ok := object.Key("RegexMatchStatement")
		if err := awsAwsjson11_serializeDocumentRegexMatchStatement(v.RegexMatchStatement, ok); err != nil {
			return err
		}
	}

	if v.RegexPatternSetReferenceStatement != nil {
		ok := object.Key("RegexPatternSetReferenceStatement")
		if err := awsAwsjson11_serializeDocumentRegexPatternSetReferenceStatement(v.RegexPatternSetReferenceStatement, ok); err != nil {
			return err
		}
	}

	if v.RuleGroupReferenceStatement != nil {
		ok := object.Key("RuleGroupReferenceStatement")
		if err := awsAwsjson11_serializeDocumentRuleGroupReferenceStatement(v.RuleGroupReferenceStatement, ok); err != nil {
			return err
		}
	}

	if v.SizeConstraintStatement != nil {
		ok := object.Key("SizeConstraintStatement")
		if err := awsAwsjson11_serializeDocumentSizeConstraintStatement(v.SizeConstraintStatement, ok); err != nil {
			return err
		}
	}

	if v.SqliMatchStatement != nil {
		ok := object.Key("SqliMatchStatement")
		if err := awsAwsjson11_serializeDocumentSqliMatchStatement(v.SqliMatchStatement, ok); err != nil {
			return err
		}
	}

	if v.XssMatchStatement != nil {
		ok := object.Key("XssMatchStatement")
		if err := awsAwsjson11_serializeDocumentXssMatchStatement(v.XssMatchStatement, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentStatements(v []types.Statement, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentStatement(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentTag(v *types.Tag, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Key != nil {
		ok := object.Key("Key")
		ok.String(*v.Key)
	}

	if v.Value != nil {
		ok := object.Key("Value")
		ok.String(*v.Value)
	}

	return nil
}

func awsAwsjson11_serializeDocumentTagKeyList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentTagList(v []types.Tag, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentTag(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentTextTransformation(v *types.TextTransformation, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	{
		ok := object.Key("Priority")
		ok.Integer(v.Priority)
	}

	if len(v.Type) > 0 {
		ok := object.Key("Type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsAwsjson11_serializeDocumentTextTransformations(v []types.TextTransformation, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentTextTransformation(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentTimeWindow(v *types.TimeWindow, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EndTime != nil {
		ok := object.Key("EndTime")
		ok.Double(smithytime.FormatEpochSeconds(*v.EndTime))
	}

	if v.StartTime != nil {
		ok := object.Key("StartTime")
		ok.Double(smithytime.FormatEpochSeconds(*v.StartTime))
	}

	return nil
}

func awsAwsjson11_serializeDocumentTokenDomains(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentUriFragment(v *types.UriFragment, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.FallbackBehavior) > 0 {
		ok := object.Key("FallbackBehavior")
		ok.String(string(v.FallbackBehavior))
	}

	return nil
}

func awsAwsjson11_serializeDocumentUriPath(v *types.UriPath, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	return nil
}

func awsAwsjson11_serializeDocumentUsernameField(v *types.UsernameField, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Identifier != nil {
		ok := object.Key("Identifier")
		ok.String(*v.Identifier)
	}

	return nil
}

func awsAwsjson11_serializeDocumentVersionsToPublish(v map[string]types.VersionToPublish, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		mapVar := v[key]
		if err := awsAwsjson11_serializeDocumentVersionToPublish(&mapVar, om); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentVersionToPublish(v *types.VersionToPublish, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AssociatedRuleGroupArn != nil {
		ok := object.Key("AssociatedRuleGroupArn")
		ok.String(*v.AssociatedRuleGroupArn)
	}

	if v.ForecastedLifetime != nil {
		ok := object.Key("ForecastedLifetime")
		ok.Integer(*v.ForecastedLifetime)
	}

	return nil
}

func awsAwsjson11_serializeDocumentVisibilityConfig(v *types.VisibilityConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	{
		ok := object.Key("CloudWatchMetricsEnabled")
		ok.Boolean(v.CloudWatchMetricsEnabled)
	}

	if v.MetricName != nil {
		ok := object.Key("MetricName")
		ok.String(*v.MetricName)
	}

	{
		ok := object.Key("SampledRequestsEnabled")
		ok.Boolean(v.SampledRequestsEnabled)
	}

	return nil
}

func awsAwsjson11_serializeDocumentXssMatchStatement(v *types.XssMatchStatement, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FieldToMatch != nil {
		ok := object.Key("FieldToMatch")
		if err := awsAwsjson11_serializeDocumentFieldToMatch(v.FieldToMatch, ok); err != nil {
			return err
		}
	}

	if v.TextTransformations != nil {
		ok := object.Key("TextTransformations")
		if err := awsAwsjson11_serializeDocumentTextTransformations(v.TextTransformations, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentAssociateWebACLInput(v *AssociateWebACLInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceArn != nil {
		ok := object.Key("ResourceArn")
		ok.String(*v.ResourceArn)
	}

	if v.WebACLArn != nil {
		ok := object.Key("WebACLArn")
		ok.String(*v.WebACLArn)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCheckCapacityInput(v *CheckCapacityInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Rules != nil {
		ok := object.Key("Rules")
		if err := awsAwsjson11_serializeDocumentRules(v.Rules, ok); err != nil {
			return err
		}
	}

	if len(v.Scope) > 0 {
		ok := object.Key("Scope")
		ok.String(string(v.Scope))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreateAPIKeyInput(v *CreateAPIKeyInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Scope) > 0 {
		ok := object.Key("Scope")
		ok.String(string(v.Scope))
	}

	if v.TokenDomains != nil {
		ok := object.Key("TokenDomains")
		if err := awsAwsjson11_serializeDocumentAPIKeyTokenDomains(v.TokenDomains, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreateIPSetInput(v *CreateIPSetInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Addresses != nil {
		ok := object.Key("Addresses")
		if err := awsAwsjson11_serializeDocumentIPAddresses(v.Addresses, ok); err != nil {
			return err
		}
	}

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if len(v.IPAddressVersion) > 0 {
		ok := object.Key("IPAddressVersion")
		ok.String(string(v.IPAddressVersion))
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if len(v.Scope) > 0 {
		ok := object.Key("Scope")
		ok.String(string(v.Scope))
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsAwsjson11_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreateRegexPatternSetInput(v *CreateRegexPatternSetInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.RegularExpressionList != nil {
		ok := object.Key("RegularExpressionList")
		if err := awsAwsjson11_serializeDocumentRegularExpressionList(v.RegularExpressionList, ok); err != nil {
			return err
		}
	}

	if len(v.Scope) > 0 {
		ok := object.Key("Scope")
		ok.String(string(v.Scope))
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsAwsjson11_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreateRuleGroupInput(v *CreateRuleGroupInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Capacity != nil {
		ok := object.Key("Capacity")
		ok.Long(*v.Capacity)
	}

	if v.CustomResponseBodies != nil {
		ok := object.Key("CustomResponseBodies")
		if err := awsAwsjson11_serializeDocumentCustomResponseBodies(v.CustomResponseBodies, ok); err != nil {
			return err
		}
	}

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Rules != nil {
		ok := object.Key("Rules")
		if err := awsAwsjson11_serializeDocumentRules(v.Rules, ok); err != nil {
			return err
		}
	}

	if len(v.Scope) > 0 {
		ok := object.Key("Scope")
		ok.String(string(v.Scope))
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsAwsjson11_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.VisibilityConfig != nil {
		ok := object.Key("VisibilityConfig")
		if err := awsAwsjson11_serializeDocumentVisibilityConfig(v.VisibilityConfig, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreateWebACLInput(v *CreateWebACLInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApplicationConfig != nil {
		ok := object.Key("ApplicationConfig")
		if err := awsAwsjson11_serializeDocumentApplicationConfig(v.ApplicationConfig, ok); err != nil {
			return err
		}
	}

	if v.AssociationConfig != nil {
		ok := object.Key("AssociationConfig")
		if err := awsAwsjson11_serializeDocumentAssociationConfig(v.AssociationConfig, ok); err != nil {
			return err
		}
	}

	if v.CaptchaConfig != nil {
		ok := object.Key("CaptchaConfig")
		if err := awsAwsjson11_serializeDocumentCaptchaConfig(v.CaptchaConfig, ok); err != nil {
			return err
		}
	}

	if v.ChallengeConfig != nil {
		ok := object.Key("ChallengeConfig")
		if err := awsAwsjson11_serializeDocumentChallengeConfig(v.ChallengeConfig, ok); err != nil {
			return err
		}
	}

	if v.CustomResponseBodies != nil {
		ok := object.Key("CustomResponseBodies")
		if err := awsAwsjson11_serializeDocumentCustomResponseBodies(v.CustomResponseBodies, ok); err != nil {
			return err
		}
	}

	if v.DataProtectionConfig != nil {
		ok := object.Key("DataProtectionConfig")
		if err := awsAwsjson11_serializeDocumentDataProtectionConfig(v.DataProtectionConfig, ok); err != nil {
			return err
		}
	}

	if v.DefaultAction != nil {
		ok := object.Key("DefaultAction")
		if err := awsAwsjson11_serializeDocumentDefaultAction(v.DefaultAction, ok); err != nil {
			return err
		}
	}

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.OnSourceDDoSProtectionConfig != nil {
		ok := object.Key("OnSourceDDoSProtectionConfig")
		if err := awsAwsjson11_serializeDocumentOnSourceDDoSProtectionConfig(v.OnSourceDDoSProtectionConfig, ok); err != nil {
			return err
		}
	}

	if v.Rules != nil {
		ok := object.Key("Rules")
		if err := awsAwsjson11_serializeDocumentRules(v.Rules, ok); err != nil {
			return err
		}
	}

	if len(v.Scope) > 0 {
		ok := object.Key("Scope")
		ok.String(string(v.Scope))
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsAwsjson11_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.TokenDomains != nil {
		ok := object.Key("TokenDomains")
		if err := awsAwsjson11_serializeDocumentTokenDomains(v.TokenDomains, ok); err != nil {
			return err
		}
	}

	if v.VisibilityConfig != nil {
		ok := object.Key("VisibilityConfig")
		if err := awsAwsjson11_serializeDocumentVisibilityConfig(v.VisibilityConfig, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteAPIKeyInput(v *DeleteAPIKeyInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.APIKey != nil {
		ok := object.Key("APIKey")
		ok.String(*v.APIKey)
	}

	if len(v.Scope) > 0 {
		ok := object.Key("Scope")
		ok.String(string(v.Scope))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteFirewallManagerRuleGroupsInput(v *DeleteFirewallManagerRuleGroupsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.WebACLArn != nil {
		ok := object.Key("WebACLArn")
		ok.String(*v.WebACLArn)
	}

	if v.WebACLLockToken != nil {
		ok := object.Key("WebACLLockToken")
		ok.String(*v.WebACLLockToken)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteIPSetInput(v *DeleteIPSetInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Id != nil {
		ok := object.Key("Id")
		ok.String(*v.Id)
	}

	if v.LockToken != nil {
		ok := object.Key("LockToken")
		ok.String(*v.LockToken)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if len(v.Scope) > 0 {
		ok := object.Key("Scope")
		ok.String(string(v.Scope))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteLoggingConfigurationInput(v *DeleteLoggingConfigurationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.LogScope) > 0 {
		ok := object.Key("LogScope")
		ok.String(string(v.LogScope))
	}

	if len(v.LogType) > 0 {
		ok := object.Key("LogType")
		ok.String(string(v.LogType))
	}

	if v.ResourceArn != nil {
		ok := object.Key("ResourceArn")
		ok.String(*v.ResourceArn)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeletePermissionPolicyInput(v *DeletePermissionPolicyInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceArn != nil {
		ok := object.Key("ResourceArn")
		ok.String(*v.ResourceArn)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteRegexPatternSetInput(v *DeleteRegexPatternSetInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Id != nil {
		ok := object.Key("Id")
		ok.String(*v.Id)
	}

	if v.LockToken != nil {
		ok := object.Key("LockToken")
		ok.String(*v.LockToken)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if len(v.Scope) > 0 {
		ok := object.Key("Scope")
		ok.String(string(v.Scope))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteRuleGroupInput(v *DeleteRuleGroupInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Id != nil {
		ok := object.Key("Id")
		ok.String(*v.Id)
	}

	if v.LockToken != nil {
		ok := object.Key("LockToken")
		ok.String(*v.LockToken)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if len(v.Scope) > 0 {
		ok := object.Key("Scope")
		ok.String(string(v.Scope))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteWebACLInput(v *DeleteWebACLInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Id != nil {
		ok := object.Key("Id")
		ok.String(*v.Id)
	}

	if v.LockToken != nil {
		ok := object.Key("LockToken")
		ok.String(*v.LockToken)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if len(v.Scope) > 0 {
		ok := object.Key("Scope")
		ok.String(string(v.Scope))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeAllManagedProductsInput(v *DescribeAllManagedProductsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Scope) > 0 {
		ok := object.Key("Scope")
		ok.String(string(v.Scope))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeManagedProductsByVendorInput(v *DescribeManagedProductsByVendorInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Scope) > 0 {
		ok := object.Key("Scope")
		ok.String(string(v.Scope))
	}

	if v.VendorName != nil {
		ok := object.Key("VendorName")
		ok.String(*v.VendorName)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeManagedRuleGroupInput(v *DescribeManagedRuleGroupInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if len(v.Scope) > 0 {
		ok := object.Key("Scope")
		ok.String(string(v.Scope))
	}

	if v.VendorName != nil {
		ok := object.Key("VendorName")
		ok.String(*v.VendorName)
	}

	if v.VersionName != nil {
		ok := object.Key("VersionName")
		ok.String(*v.VersionName)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDisassociateWebACLInput(v *DisassociateWebACLInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceArn != nil {
		ok := object.Key("ResourceArn")
		ok.String(*v.ResourceArn)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGenerateMobileSdkReleaseUrlInput(v *GenerateMobileSdkReleaseUrlInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Platform) > 0 {
		ok := object.Key("Platform")
		ok.String(string(v.Platform))
	}

	if v.ReleaseVersion != nil {
		ok := object.Key("ReleaseVersion")
		ok.String(*v.ReleaseVersion)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetDecryptedAPIKeyInput(v *GetDecryptedAPIKeyInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.APIKey != nil {
		ok := object.Key("APIKey")
		ok.String(*v.APIKey)
	}

	if len(v.Scope) > 0 {
		ok := object.Key("Scope")
		ok.String(string(v.Scope))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetIPSetInput(v *GetIPSetInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Id != nil {
		ok := object.Key("Id")
		ok.String(*v.Id)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if len(v.Scope) > 0 {
		ok := object.Key("Scope")
		ok.String(string(v.Scope))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetLoggingConfigurationInput(v *GetLoggingConfigurationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.LogScope) > 0 {
		ok := object.Key("LogScope")
		ok.String(string(v.LogScope))
	}

	if len(v.LogType) > 0 {
		ok := object.Key("LogType")
		ok.String(string(v.LogType))
	}

	if v.ResourceArn != nil {
		ok := object.Key("ResourceArn")
		ok.String(*v.ResourceArn)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetManagedRuleSetInput(v *GetManagedRuleSetInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Id != nil {
		ok := object.Key("Id")
		ok.String(*v.Id)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if len(v.Scope) > 0 {
		ok := object.Key("Scope")
		ok.String(string(v.Scope))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetMobileSdkReleaseInput(v *GetMobileSdkReleaseInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Platform) > 0 {
		ok := object.Key("Platform")
		ok.String(string(v.Platform))
	}

	if v.ReleaseVersion != nil {
		ok := object.Key("ReleaseVersion")
		ok.String(*v.ReleaseVersion)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetPermissionPolicyInput(v *GetPermissionPolicyInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceArn != nil {
		ok := object.Key("ResourceArn")
		ok.String(*v.ResourceArn)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetRateBasedStatementManagedKeysInput(v *GetRateBasedStatementManagedKeysInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.RuleGroupRuleName != nil {
		ok := object.Key("RuleGroupRuleName")
		ok.String(*v.RuleGroupRuleName)
	}

	if v.RuleName != nil {
		ok := object.Key("RuleName")
		ok.String(*v.RuleName)
	}

	if len(v.Scope) > 0 {
		ok := object.Key("Scope")
		ok.String(string(v.Scope))
	}

	if v.WebACLId != nil {
		ok := object.Key("WebACLId")
		ok.String(*v.WebACLId)
	}

	if v.WebACLName != nil {
		ok := object.Key("WebACLName")
		ok.String(*v.WebACLName)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetRegexPatternSetInput(v *GetRegexPatternSetInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Id != nil {
		ok := object.Key("Id")
		ok.String(*v.Id)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if len(v.Scope) > 0 {
		ok := object.Key("Scope")
		ok.String(string(v.Scope))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetRuleGroupInput(v *GetRuleGroupInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ARN != nil {
		ok := object.Key("ARN")
		ok.String(*v.ARN)
	}

	if v.Id != nil {
		ok := object.Key("Id")
		ok.String(*v.Id)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if len(v.Scope) > 0 {
		ok := object.Key("Scope")
		ok.String(string(v.Scope))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetSampledRequestsInput(v *GetSampledRequestsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxItems != nil {
		ok := object.Key("MaxItems")
		ok.Long(*v.MaxItems)
	}

	if v.RuleMetricName != nil {
		ok := object.Key("RuleMetricName")
		ok.String(*v.RuleMetricName)
	}

	if len(v.Scope) > 0 {
		ok := object.Key("Scope")
		ok.String(string(v.Scope))
	}

	if v.TimeWindow != nil {
		ok := object.Key("TimeWindow")
		if err := awsAwsjson11_serializeDocumentTimeWindow(v.TimeWindow, ok); err != nil {
			return err
		}
	}

	if v.WebAclArn != nil {
		ok := object.Key("WebAclArn")
		ok.String(*v.WebAclArn)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetWebACLForResourceInput(v *GetWebACLForResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceArn != nil {
		ok := object.Key("ResourceArn")
		ok.String(*v.ResourceArn)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetWebACLInput(v *GetWebACLInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ARN != nil {
		ok := object.Key("ARN")
		ok.String(*v.ARN)
	}

	if v.Id != nil {
		ok := object.Key("Id")
		ok.String(*v.Id)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if len(v.Scope) > 0 {
		ok := object.Key("Scope")
		ok.String(string(v.Scope))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListAPIKeysInput(v *ListAPIKeysInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Limit != nil {
		ok := object.Key("Limit")
		ok.Integer(*v.Limit)
	}

	if v.NextMarker != nil {
		ok := object.Key("NextMarker")
		ok.String(*v.NextMarker)
	}

	if len(v.Scope) > 0 {
		ok := object.Key("Scope")
		ok.String(string(v.Scope))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListAvailableManagedRuleGroupsInput(v *ListAvailableManagedRuleGroupsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Limit != nil {
		ok := object.Key("Limit")
		ok.Integer(*v.Limit)
	}

	if v.NextMarker != nil {
		ok := object.Key("NextMarker")
		ok.String(*v.NextMarker)
	}

	if len(v.Scope) > 0 {
		ok := object.Key("Scope")
		ok.String(string(v.Scope))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListAvailableManagedRuleGroupVersionsInput(v *ListAvailableManagedRuleGroupVersionsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Limit != nil {
		ok := object.Key("Limit")
		ok.Integer(*v.Limit)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.NextMarker != nil {
		ok := object.Key("NextMarker")
		ok.String(*v.NextMarker)
	}

	if len(v.Scope) > 0 {
		ok := object.Key("Scope")
		ok.String(string(v.Scope))
	}

	if v.VendorName != nil {
		ok := object.Key("VendorName")
		ok.String(*v.VendorName)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListIPSetsInput(v *ListIPSetsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Limit != nil {
		ok := object.Key("Limit")
		ok.Integer(*v.Limit)
	}

	if v.NextMarker != nil {
		ok := object.Key("NextMarker")
		ok.String(*v.NextMarker)
	}

	if len(v.Scope) > 0 {
		ok := object.Key("Scope")
		ok.String(string(v.Scope))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListLoggingConfigurationsInput(v *ListLoggingConfigurationsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Limit != nil {
		ok := object.Key("Limit")
		ok.Integer(*v.Limit)
	}

	if len(v.LogScope) > 0 {
		ok := object.Key("LogScope")
		ok.String(string(v.LogScope))
	}

	if v.NextMarker != nil {
		ok := object.Key("NextMarker")
		ok.String(*v.NextMarker)
	}

	if len(v.Scope) > 0 {
		ok := object.Key("Scope")
		ok.String(string(v.Scope))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListManagedRuleSetsInput(v *ListManagedRuleSetsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Limit != nil {
		ok := object.Key("Limit")
		ok.Integer(*v.Limit)
	}

	if v.NextMarker != nil {
		ok := object.Key("NextMarker")
		ok.String(*v.NextMarker)
	}

	if len(v.Scope) > 0 {
		ok := object.Key("Scope")
		ok.String(string(v.Scope))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListMobileSdkReleasesInput(v *ListMobileSdkReleasesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Limit != nil {
		ok := object.Key("Limit")
		ok.Integer(*v.Limit)
	}

	if v.NextMarker != nil {
		ok := object.Key("NextMarker")
		ok.String(*v.NextMarker)
	}

	if len(v.Platform) > 0 {
		ok := object.Key("Platform")
		ok.String(string(v.Platform))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListRegexPatternSetsInput(v *ListRegexPatternSetsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Limit != nil {
		ok := object.Key("Limit")
		ok.Integer(*v.Limit)
	}

	if v.NextMarker != nil {
		ok := object.Key("NextMarker")
		ok.String(*v.NextMarker)
	}

	if len(v.Scope) > 0 {
		ok := object.Key("Scope")
		ok.String(string(v.Scope))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListResourcesForWebACLInput(v *ListResourcesForWebACLInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.ResourceType) > 0 {
		ok := object.Key("ResourceType")
		ok.String(string(v.ResourceType))
	}

	if v.WebACLArn != nil {
		ok := object.Key("WebACLArn")
		ok.String(*v.WebACLArn)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListRuleGroupsInput(v *ListRuleGroupsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Limit != nil {
		ok := object.Key("Limit")
		ok.Integer(*v.Limit)
	}

	if v.NextMarker != nil {
		ok := object.Key("NextMarker")
		ok.String(*v.NextMarker)
	}

	if len(v.Scope) > 0 {
		ok := object.Key("Scope")
		ok.String(string(v.Scope))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListTagsForResourceInput(v *ListTagsForResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Limit != nil {
		ok := object.Key("Limit")
		ok.Integer(*v.Limit)
	}

	if v.NextMarker != nil {
		ok := object.Key("NextMarker")
		ok.String(*v.NextMarker)
	}

	if v.ResourceARN != nil {
		ok := object.Key("ResourceARN")
		ok.String(*v.ResourceARN)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListWebACLsInput(v *ListWebACLsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Limit != nil {
		ok := object.Key("Limit")
		ok.Integer(*v.Limit)
	}

	if v.NextMarker != nil {
		ok := object.Key("NextMarker")
		ok.String(*v.NextMarker)
	}

	if len(v.Scope) > 0 {
		ok := object.Key("Scope")
		ok.String(string(v.Scope))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentPutLoggingConfigurationInput(v *PutLoggingConfigurationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LoggingConfiguration != nil {
		ok := object.Key("LoggingConfiguration")
		if err := awsAwsjson11_serializeDocumentLoggingConfiguration(v.LoggingConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentPutManagedRuleSetVersionsInput(v *PutManagedRuleSetVersionsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Id != nil {
		ok := object.Key("Id")
		ok.String(*v.Id)
	}

	if v.LockToken != nil {
		ok := object.Key("LockToken")
		ok.String(*v.LockToken)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.RecommendedVersion != nil {
		ok := object.Key("RecommendedVersion")
		ok.String(*v.RecommendedVersion)
	}

	if len(v.Scope) > 0 {
		ok := object.Key("Scope")
		ok.String(string(v.Scope))
	}

	if v.VersionsToPublish != nil {
		ok := object.Key("VersionsToPublish")
		if err := awsAwsjson11_serializeDocumentVersionsToPublish(v.VersionsToPublish, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentPutPermissionPolicyInput(v *PutPermissionPolicyInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Policy != nil {
		ok := object.Key("Policy")
		ok.String(*v.Policy)
	}

	if v.ResourceArn != nil {
		ok := object.Key("ResourceArn")
		ok.String(*v.ResourceArn)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentTagResourceInput(v *TagResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceARN != nil {
		ok := object.Key("ResourceARN")
		ok.String(*v.ResourceARN)
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsAwsjson11_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUntagResourceInput(v *UntagResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceARN != nil {
		ok := object.Key("ResourceARN")
		ok.String(*v.ResourceARN)
	}

	if v.TagKeys != nil {
		ok := object.Key("TagKeys")
		if err := awsAwsjson11_serializeDocumentTagKeyList(v.TagKeys, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUpdateIPSetInput(v *UpdateIPSetInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Addresses != nil {
		ok := object.Key("Addresses")
		if err := awsAwsjson11_serializeDocumentIPAddresses(v.Addresses, ok); err != nil {
			return err
		}
	}

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.Id != nil {
		ok := object.Key("Id")
		ok.String(*v.Id)
	}

	if v.LockToken != nil {
		ok := object.Key("LockToken")
		ok.String(*v.LockToken)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if len(v.Scope) > 0 {
		ok := object.Key("Scope")
		ok.String(string(v.Scope))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUpdateManagedRuleSetVersionExpiryDateInput(v *UpdateManagedRuleSetVersionExpiryDateInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ExpiryTimestamp != nil {
		ok := object.Key("ExpiryTimestamp")
		ok.Double(smithytime.FormatEpochSeconds(*v.ExpiryTimestamp))
	}

	if v.Id != nil {
		ok := object.Key("Id")
		ok.String(*v.Id)
	}

	if v.LockToken != nil {
		ok := object.Key("LockToken")
		ok.String(*v.LockToken)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if len(v.Scope) > 0 {
		ok := object.Key("Scope")
		ok.String(string(v.Scope))
	}

	if v.VersionToExpire != nil {
		ok := object.Key("VersionToExpire")
		ok.String(*v.VersionToExpire)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUpdateRegexPatternSetInput(v *UpdateRegexPatternSetInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.Id != nil {
		ok := object.Key("Id")
		ok.String(*v.Id)
	}

	if v.LockToken != nil {
		ok := object.Key("LockToken")
		ok.String(*v.LockToken)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.RegularExpressionList != nil {
		ok := object.Key("RegularExpressionList")
		if err := awsAwsjson11_serializeDocumentRegularExpressionList(v.RegularExpressionList, ok); err != nil {
			return err
		}
	}

	if len(v.Scope) > 0 {
		ok := object.Key("Scope")
		ok.String(string(v.Scope))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUpdateRuleGroupInput(v *UpdateRuleGroupInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CustomResponseBodies != nil {
		ok := object.Key("CustomResponseBodies")
		if err := awsAwsjson11_serializeDocumentCustomResponseBodies(v.CustomResponseBodies, ok); err != nil {
			return err
		}
	}

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.Id != nil {
		ok := object.Key("Id")
		ok.String(*v.Id)
	}

	if v.LockToken != nil {
		ok := object.Key("LockToken")
		ok.String(*v.LockToken)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Rules != nil {
		ok := object.Key("Rules")
		if err := awsAwsjson11_serializeDocumentRules(v.Rules, ok); err != nil {
			return err
		}
	}

	if len(v.Scope) > 0 {
		ok := object.Key("Scope")
		ok.String(string(v.Scope))
	}

	if v.VisibilityConfig != nil {
		ok := object.Key("VisibilityConfig")
		if err := awsAwsjson11_serializeDocumentVisibilityConfig(v.VisibilityConfig, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUpdateWebACLInput(v *UpdateWebACLInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApplicationConfig != nil {
		ok := object.Key("ApplicationConfig")
		if err := awsAwsjson11_serializeDocumentApplicationConfig(v.ApplicationConfig, ok); err != nil {
			return err
		}
	}

	if v.AssociationConfig != nil {
		ok := object.Key("AssociationConfig")
		if err := awsAwsjson11_serializeDocumentAssociationConfig(v.AssociationConfig, ok); err != nil {
			return err
		}
	}

	if v.CaptchaConfig != nil {
		ok := object.Key("CaptchaConfig")
		if err := awsAwsjson11_serializeDocumentCaptchaConfig(v.CaptchaConfig, ok); err != nil {
			return err
		}
	}

	if v.ChallengeConfig != nil {
		ok := object.Key("ChallengeConfig")
		if err := awsAwsjson11_serializeDocumentChallengeConfig(v.ChallengeConfig, ok); err != nil {
			return err
		}
	}

	if v.CustomResponseBodies != nil {
		ok := object.Key("CustomResponseBodies")
		if err := awsAwsjson11_serializeDocumentCustomResponseBodies(v.CustomResponseBodies, ok); err != nil {
			return err
		}
	}

	if v.DataProtectionConfig != nil {
		ok := object.Key("DataProtectionConfig")
		if err := awsAwsjson11_serializeDocumentDataProtectionConfig(v.DataProtectionConfig, ok); err != nil {
			return err
		}
	}

	if v.DefaultAction != nil {
		ok := object.Key("DefaultAction")
		if err := awsAwsjson11_serializeDocumentDefaultAction(v.DefaultAction, ok); err != nil {
			return err
		}
	}

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.Id != nil {
		ok := object.Key("Id")
		ok.String(*v.Id)
	}

	if v.LockToken != nil {
		ok := object.Key("LockToken")
		ok.String(*v.LockToken)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.OnSourceDDoSProtectionConfig != nil {
		ok := object.Key("OnSourceDDoSProtectionConfig")
		if err := awsAwsjson11_serializeDocumentOnSourceDDoSProtectionConfig(v.OnSourceDDoSProtectionConfig, ok); err != nil {
			return err
		}
	}

	if v.Rules != nil {
		ok := object.Key("Rules")
		if err := awsAwsjson11_serializeDocumentRules(v.Rules, ok); err != nil {
			return err
		}
	}

	if len(v.Scope) > 0 {
		ok := object.Key("Scope")
		ok.String(string(v.Scope))
	}

	if v.TokenDomains != nil {
		ok := object.Key("TokenDomains")
		if err := awsAwsjson11_serializeDocumentTokenDomains(v.TokenDomains, ok); err != nil {
			return err
		}
	}

	if v.VisibilityConfig != nil {
		ok := object.Key("VisibilityConfig")
		if err := awsAwsjson11_serializeDocumentVisibilityConfig(v.VisibilityConfig, ok); err != nil {
			return err
		}
	}

	return nil
}
