// Code generated by smithy-go-codegen DO NOT EDIT.

package transcribestreaming

import (
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/aws/protocol/eventstream"
	"github.com/aws/aws-sdk-go-v2/aws/protocol/eventstream/eventstreamapi"
	"github.com/aws/aws-sdk-go-v2/service/transcribestreaming/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	"github.com/aws/smithy-go/tracing"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

type awsRestjson1_serializeOpGetMedicalScribeStream struct {
}

func (*awsRestjson1_serializeOpGetMedicalScribeStream) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetMedicalScribeStream) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetMedicalScribeStreamInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/medical-scribe-stream/{SessionId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetMedicalScribeStreamInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetMedicalScribeStreamInput(v *GetMedicalScribeStreamInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.SessionId == nil || len(*v.SessionId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member SessionId must not be empty")}
	}
	if v.SessionId != nil {
		if err := encoder.SetURI("SessionId").String(*v.SessionId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpStartCallAnalyticsStreamTranscription struct {
}

func (*awsRestjson1_serializeOpStartCallAnalyticsStreamTranscription) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpStartCallAnalyticsStreamTranscription) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartCallAnalyticsStreamTranscriptionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/call-analytics-stream-transcription")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsStartCallAnalyticsStreamTranscriptionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/vnd.amazon.eventstream")

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsStartCallAnalyticsStreamTranscriptionInput(v *StartCallAnalyticsStreamTranscriptionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if len(v.ContentIdentificationType) > 0 {
		locationName := "X-Amzn-Transcribe-Content-Identification-Type"
		encoder.SetHeader(locationName).String(string(v.ContentIdentificationType))
	}

	if len(v.ContentRedactionType) > 0 {
		locationName := "X-Amzn-Transcribe-Content-Redaction-Type"
		encoder.SetHeader(locationName).String(string(v.ContentRedactionType))
	}

	if v.EnablePartialResultsStabilization {
		locationName := "X-Amzn-Transcribe-Enable-Partial-Results-Stabilization"
		encoder.SetHeader(locationName).Boolean(v.EnablePartialResultsStabilization)
	}

	if len(v.LanguageCode) > 0 {
		locationName := "X-Amzn-Transcribe-Language-Code"
		encoder.SetHeader(locationName).String(string(v.LanguageCode))
	}

	if v.LanguageModelName != nil {
		locationName := "X-Amzn-Transcribe-Language-Model-Name"
		encoder.SetHeader(locationName).String(*v.LanguageModelName)
	}

	if len(v.MediaEncoding) > 0 {
		locationName := "X-Amzn-Transcribe-Media-Encoding"
		encoder.SetHeader(locationName).String(string(v.MediaEncoding))
	}

	if v.MediaSampleRateHertz != nil {
		locationName := "X-Amzn-Transcribe-Sample-Rate"
		encoder.SetHeader(locationName).Integer(*v.MediaSampleRateHertz)
	}

	if len(v.PartialResultsStability) > 0 {
		locationName := "X-Amzn-Transcribe-Partial-Results-Stability"
		encoder.SetHeader(locationName).String(string(v.PartialResultsStability))
	}

	if v.PiiEntityTypes != nil {
		locationName := "X-Amzn-Transcribe-Pii-Entity-Types"
		encoder.SetHeader(locationName).String(*v.PiiEntityTypes)
	}

	if v.SessionId != nil {
		locationName := "X-Amzn-Transcribe-Session-Id"
		encoder.SetHeader(locationName).String(*v.SessionId)
	}

	if len(v.VocabularyFilterMethod) > 0 {
		locationName := "X-Amzn-Transcribe-Vocabulary-Filter-Method"
		encoder.SetHeader(locationName).String(string(v.VocabularyFilterMethod))
	}

	if v.VocabularyFilterName != nil {
		locationName := "X-Amzn-Transcribe-Vocabulary-Filter-Name"
		encoder.SetHeader(locationName).String(*v.VocabularyFilterName)
	}

	if v.VocabularyName != nil {
		locationName := "X-Amzn-Transcribe-Vocabulary-Name"
		encoder.SetHeader(locationName).String(*v.VocabularyName)
	}

	return nil
}

type awsRestjson1_serializeOpStartMedicalScribeStream struct {
}

func (*awsRestjson1_serializeOpStartMedicalScribeStream) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpStartMedicalScribeStream) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartMedicalScribeStreamInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/medical-scribe-stream")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsStartMedicalScribeStreamInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/vnd.amazon.eventstream")

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsStartMedicalScribeStreamInput(v *StartMedicalScribeStreamInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if len(v.LanguageCode) > 0 {
		locationName := "X-Amzn-Transcribe-Language-Code"
		encoder.SetHeader(locationName).String(string(v.LanguageCode))
	}

	if len(v.MediaEncoding) > 0 {
		locationName := "X-Amzn-Transcribe-Media-Encoding"
		encoder.SetHeader(locationName).String(string(v.MediaEncoding))
	}

	if v.MediaSampleRateHertz != nil {
		locationName := "X-Amzn-Transcribe-Sample-Rate"
		encoder.SetHeader(locationName).Integer(*v.MediaSampleRateHertz)
	}

	if v.SessionId != nil {
		locationName := "X-Amzn-Transcribe-Session-Id"
		encoder.SetHeader(locationName).String(*v.SessionId)
	}

	return nil
}

type awsRestjson1_serializeOpStartMedicalStreamTranscription struct {
}

func (*awsRestjson1_serializeOpStartMedicalStreamTranscription) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpStartMedicalStreamTranscription) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartMedicalStreamTranscriptionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/medical-stream-transcription")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsStartMedicalStreamTranscriptionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/vnd.amazon.eventstream")

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsStartMedicalStreamTranscriptionInput(v *StartMedicalStreamTranscriptionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if len(v.ContentIdentificationType) > 0 {
		locationName := "X-Amzn-Transcribe-Content-Identification-Type"
		encoder.SetHeader(locationName).String(string(v.ContentIdentificationType))
	}

	if v.EnableChannelIdentification {
		locationName := "X-Amzn-Transcribe-Enable-Channel-Identification"
		encoder.SetHeader(locationName).Boolean(v.EnableChannelIdentification)
	}

	if len(v.LanguageCode) > 0 {
		locationName := "X-Amzn-Transcribe-Language-Code"
		encoder.SetHeader(locationName).String(string(v.LanguageCode))
	}

	if len(v.MediaEncoding) > 0 {
		locationName := "X-Amzn-Transcribe-Media-Encoding"
		encoder.SetHeader(locationName).String(string(v.MediaEncoding))
	}

	if v.MediaSampleRateHertz != nil {
		locationName := "X-Amzn-Transcribe-Sample-Rate"
		encoder.SetHeader(locationName).Integer(*v.MediaSampleRateHertz)
	}

	if v.NumberOfChannels != nil {
		locationName := "X-Amzn-Transcribe-Number-Of-Channels"
		encoder.SetHeader(locationName).Integer(*v.NumberOfChannels)
	}

	if v.SessionId != nil {
		locationName := "X-Amzn-Transcribe-Session-Id"
		encoder.SetHeader(locationName).String(*v.SessionId)
	}

	if v.ShowSpeakerLabel {
		locationName := "X-Amzn-Transcribe-Show-Speaker-Label"
		encoder.SetHeader(locationName).Boolean(v.ShowSpeakerLabel)
	}

	if len(v.Specialty) > 0 {
		locationName := "X-Amzn-Transcribe-Specialty"
		encoder.SetHeader(locationName).String(string(v.Specialty))
	}

	if len(v.Type) > 0 {
		locationName := "X-Amzn-Transcribe-Type"
		encoder.SetHeader(locationName).String(string(v.Type))
	}

	if v.VocabularyName != nil {
		locationName := "X-Amzn-Transcribe-Vocabulary-Name"
		encoder.SetHeader(locationName).String(*v.VocabularyName)
	}

	return nil
}

type awsRestjson1_serializeOpStartStreamTranscription struct {
}

func (*awsRestjson1_serializeOpStartStreamTranscription) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpStartStreamTranscription) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartStreamTranscriptionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/stream-transcription")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsStartStreamTranscriptionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/vnd.amazon.eventstream")

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsStartStreamTranscriptionInput(v *StartStreamTranscriptionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if len(v.ContentIdentificationType) > 0 {
		locationName := "X-Amzn-Transcribe-Content-Identification-Type"
		encoder.SetHeader(locationName).String(string(v.ContentIdentificationType))
	}

	if len(v.ContentRedactionType) > 0 {
		locationName := "X-Amzn-Transcribe-Content-Redaction-Type"
		encoder.SetHeader(locationName).String(string(v.ContentRedactionType))
	}

	if v.EnableChannelIdentification {
		locationName := "X-Amzn-Transcribe-Enable-Channel-Identification"
		encoder.SetHeader(locationName).Boolean(v.EnableChannelIdentification)
	}

	if v.EnablePartialResultsStabilization {
		locationName := "X-Amzn-Transcribe-Enable-Partial-Results-Stabilization"
		encoder.SetHeader(locationName).Boolean(v.EnablePartialResultsStabilization)
	}

	if v.IdentifyLanguage {
		locationName := "X-Amzn-Transcribe-Identify-Language"
		encoder.SetHeader(locationName).Boolean(v.IdentifyLanguage)
	}

	if v.IdentifyMultipleLanguages {
		locationName := "X-Amzn-Transcribe-Identify-Multiple-Languages"
		encoder.SetHeader(locationName).Boolean(v.IdentifyMultipleLanguages)
	}

	if len(v.LanguageCode) > 0 {
		locationName := "X-Amzn-Transcribe-Language-Code"
		encoder.SetHeader(locationName).String(string(v.LanguageCode))
	}

	if v.LanguageModelName != nil {
		locationName := "X-Amzn-Transcribe-Language-Model-Name"
		encoder.SetHeader(locationName).String(*v.LanguageModelName)
	}

	if v.LanguageOptions != nil {
		locationName := "X-Amzn-Transcribe-Language-Options"
		encoder.SetHeader(locationName).String(*v.LanguageOptions)
	}

	if len(v.MediaEncoding) > 0 {
		locationName := "X-Amzn-Transcribe-Media-Encoding"
		encoder.SetHeader(locationName).String(string(v.MediaEncoding))
	}

	if v.MediaSampleRateHertz != nil {
		locationName := "X-Amzn-Transcribe-Sample-Rate"
		encoder.SetHeader(locationName).Integer(*v.MediaSampleRateHertz)
	}

	if v.NumberOfChannels != nil {
		locationName := "X-Amzn-Transcribe-Number-Of-Channels"
		encoder.SetHeader(locationName).Integer(*v.NumberOfChannels)
	}

	if len(v.PartialResultsStability) > 0 {
		locationName := "X-Amzn-Transcribe-Partial-Results-Stability"
		encoder.SetHeader(locationName).String(string(v.PartialResultsStability))
	}

	if v.PiiEntityTypes != nil {
		locationName := "X-Amzn-Transcribe-Pii-Entity-Types"
		encoder.SetHeader(locationName).String(*v.PiiEntityTypes)
	}

	if len(v.PreferredLanguage) > 0 {
		locationName := "X-Amzn-Transcribe-Preferred-Language"
		encoder.SetHeader(locationName).String(string(v.PreferredLanguage))
	}

	if v.SessionId != nil {
		locationName := "X-Amzn-Transcribe-Session-Id"
		encoder.SetHeader(locationName).String(*v.SessionId)
	}

	if v.ShowSpeakerLabel {
		locationName := "X-Amzn-Transcribe-Show-Speaker-Label"
		encoder.SetHeader(locationName).Boolean(v.ShowSpeakerLabel)
	}

	if len(v.VocabularyFilterMethod) > 0 {
		locationName := "X-Amzn-Transcribe-Vocabulary-Filter-Method"
		encoder.SetHeader(locationName).String(string(v.VocabularyFilterMethod))
	}

	if v.VocabularyFilterName != nil {
		locationName := "X-Amzn-Transcribe-Vocabulary-Filter-Name"
		encoder.SetHeader(locationName).String(*v.VocabularyFilterName)
	}

	if v.VocabularyFilterNames != nil {
		locationName := "X-Amzn-Transcribe-Vocabulary-Filter-Names"
		encoder.SetHeader(locationName).String(*v.VocabularyFilterNames)
	}

	if v.VocabularyName != nil {
		locationName := "X-Amzn-Transcribe-Vocabulary-Name"
		encoder.SetHeader(locationName).String(*v.VocabularyName)
	}

	if v.VocabularyNames != nil {
		locationName := "X-Amzn-Transcribe-Vocabulary-Names"
		encoder.SetHeader(locationName).String(*v.VocabularyNames)
	}

	return nil
}

func awsRestjson1_serializeEventStreamMedicalScribeInputStream(v types.MedicalScribeInputStream, msg *eventstream.Message) error {
	if v == nil {
		return fmt.Errorf("unexpected serialization of nil %T", v)
	}

	switch vv := v.(type) {
	case *types.MedicalScribeInputStreamMemberAudioEvent:
		msg.Headers.Set(eventstreamapi.EventTypeHeader, eventstream.StringValue("AudioEvent"))
		return awsRestjson1_serializeEventMessageMedicalScribeAudioEvent(&vv.Value, msg)

	case *types.MedicalScribeInputStreamMemberSessionControlEvent:
		msg.Headers.Set(eventstreamapi.EventTypeHeader, eventstream.StringValue("SessionControlEvent"))
		return awsRestjson1_serializeEventMessageMedicalScribeSessionControlEvent(&vv.Value, msg)

	case *types.MedicalScribeInputStreamMemberConfigurationEvent:
		msg.Headers.Set(eventstreamapi.EventTypeHeader, eventstream.StringValue("ConfigurationEvent"))
		return awsRestjson1_serializeEventMessageMedicalScribeConfigurationEvent(&vv.Value, msg)

	default:
		return fmt.Errorf("unexpected event message type: %v", v)

	}
}
func awsRestjson1_serializeEventMessageMedicalScribeAudioEvent(v *types.MedicalScribeAudioEvent, msg *eventstream.Message) error {
	if v == nil {
		return fmt.Errorf("unexpected serialization of nil %T", v)
	}

	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.EventMessageType))
	if v.AudioChunk != nil {
		msg.Headers.Set(eventstreamapi.ContentTypeHeader, eventstream.StringValue("application/octet-stream"))
		msg.Payload = v.AudioChunk
	}
	return nil
}

func awsRestjson1_serializeEventMessageMedicalScribeConfigurationEvent(v *types.MedicalScribeConfigurationEvent, msg *eventstream.Message) error {
	if v == nil {
		return fmt.Errorf("unexpected serialization of nil %T", v)
	}

	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.EventMessageType))
	msg.Headers.Set(eventstreamapi.ContentTypeHeader, eventstream.StringValue("application/json"))
	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeDocumentMedicalScribeConfigurationEvent(v, jsonEncoder.Value); err != nil {
		return err
	}
	msg.Payload = jsonEncoder.Bytes()
	return nil
}

func awsRestjson1_serializeEventMessageMedicalScribeSessionControlEvent(v *types.MedicalScribeSessionControlEvent, msg *eventstream.Message) error {
	if v == nil {
		return fmt.Errorf("unexpected serialization of nil %T", v)
	}

	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.EventMessageType))
	msg.Headers.Set(eventstreamapi.ContentTypeHeader, eventstream.StringValue("application/json"))
	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeDocumentMedicalScribeSessionControlEvent(v, jsonEncoder.Value); err != nil {
		return err
	}
	msg.Payload = jsonEncoder.Bytes()
	return nil
}

func awsRestjson1_serializeDocumentClinicalNoteGenerationSettings(v *types.ClinicalNoteGenerationSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.NoteTemplate) > 0 {
		ok := object.Key("NoteTemplate")
		ok.String(string(v.NoteTemplate))
	}

	if v.OutputBucketName != nil {
		ok := object.Key("OutputBucketName")
		ok.String(*v.OutputBucketName)
	}

	return nil
}

func awsRestjson1_serializeDocumentKMSEncryptionContextMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentMedicalScribeChannelDefinition(v *types.MedicalScribeChannelDefinition, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	{
		ok := object.Key("ChannelId")
		ok.Integer(v.ChannelId)
	}

	if len(v.ParticipantRole) > 0 {
		ok := object.Key("ParticipantRole")
		ok.String(string(v.ParticipantRole))
	}

	return nil
}

func awsRestjson1_serializeDocumentMedicalScribeChannelDefinitions(v []types.MedicalScribeChannelDefinition, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentMedicalScribeChannelDefinition(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentMedicalScribeConfigurationEvent(v *types.MedicalScribeConfigurationEvent, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ChannelDefinitions != nil {
		ok := object.Key("ChannelDefinitions")
		if err := awsRestjson1_serializeDocumentMedicalScribeChannelDefinitions(v.ChannelDefinitions, ok); err != nil {
			return err
		}
	}

	if v.EncryptionSettings != nil {
		ok := object.Key("EncryptionSettings")
		if err := awsRestjson1_serializeDocumentMedicalScribeEncryptionSettings(v.EncryptionSettings, ok); err != nil {
			return err
		}
	}

	if v.MedicalScribeContext != nil {
		ok := object.Key("MedicalScribeContext")
		if err := awsRestjson1_serializeDocumentMedicalScribeContext(v.MedicalScribeContext, ok); err != nil {
			return err
		}
	}

	if v.PostStreamAnalyticsSettings != nil {
		ok := object.Key("PostStreamAnalyticsSettings")
		if err := awsRestjson1_serializeDocumentMedicalScribePostStreamAnalyticsSettings(v.PostStreamAnalyticsSettings, ok); err != nil {
			return err
		}
	}

	if v.ResourceAccessRoleArn != nil {
		ok := object.Key("ResourceAccessRoleArn")
		ok.String(*v.ResourceAccessRoleArn)
	}

	if len(v.VocabularyFilterMethod) > 0 {
		ok := object.Key("VocabularyFilterMethod")
		ok.String(string(v.VocabularyFilterMethod))
	}

	if v.VocabularyFilterName != nil {
		ok := object.Key("VocabularyFilterName")
		ok.String(*v.VocabularyFilterName)
	}

	if v.VocabularyName != nil {
		ok := object.Key("VocabularyName")
		ok.String(*v.VocabularyName)
	}

	return nil
}

func awsRestjson1_serializeDocumentMedicalScribeContext(v *types.MedicalScribeContext, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PatientContext != nil {
		ok := object.Key("PatientContext")
		if err := awsRestjson1_serializeDocumentMedicalScribePatientContext(v.PatientContext, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentMedicalScribeEncryptionSettings(v *types.MedicalScribeEncryptionSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.KmsEncryptionContext != nil {
		ok := object.Key("KmsEncryptionContext")
		if err := awsRestjson1_serializeDocumentKMSEncryptionContextMap(v.KmsEncryptionContext, ok); err != nil {
			return err
		}
	}

	if v.KmsKeyId != nil {
		ok := object.Key("KmsKeyId")
		ok.String(*v.KmsKeyId)
	}

	return nil
}

func awsRestjson1_serializeDocumentMedicalScribePatientContext(v *types.MedicalScribePatientContext, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Pronouns) > 0 {
		ok := object.Key("Pronouns")
		ok.String(string(v.Pronouns))
	}

	return nil
}

func awsRestjson1_serializeDocumentMedicalScribePostStreamAnalyticsSettings(v *types.MedicalScribePostStreamAnalyticsSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClinicalNoteGenerationSettings != nil {
		ok := object.Key("ClinicalNoteGenerationSettings")
		if err := awsRestjson1_serializeDocumentClinicalNoteGenerationSettings(v.ClinicalNoteGenerationSettings, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentMedicalScribeSessionControlEvent(v *types.MedicalScribeSessionControlEvent, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Type) > 0 {
		ok := object.Key("Type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsRestjson1_serializeEventStreamAudioStream(v types.AudioStream, msg *eventstream.Message) error {
	if v == nil {
		return fmt.Errorf("unexpected serialization of nil %T", v)
	}

	switch vv := v.(type) {
	case *types.AudioStreamMemberAudioEvent:
		msg.Headers.Set(eventstreamapi.EventTypeHeader, eventstream.StringValue("AudioEvent"))
		return awsRestjson1_serializeEventMessageAudioEvent(&vv.Value, msg)

	case *types.AudioStreamMemberConfigurationEvent:
		msg.Headers.Set(eventstreamapi.EventTypeHeader, eventstream.StringValue("ConfigurationEvent"))
		return awsRestjson1_serializeEventMessageConfigurationEvent(&vv.Value, msg)

	default:
		return fmt.Errorf("unexpected event message type: %v", v)

	}
}
func awsRestjson1_serializeEventMessageAudioEvent(v *types.AudioEvent, msg *eventstream.Message) error {
	if v == nil {
		return fmt.Errorf("unexpected serialization of nil %T", v)
	}

	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.EventMessageType))
	if v.AudioChunk != nil {
		msg.Headers.Set(eventstreamapi.ContentTypeHeader, eventstream.StringValue("application/octet-stream"))
		msg.Payload = v.AudioChunk
	}
	return nil
}

func awsRestjson1_serializeEventMessageConfigurationEvent(v *types.ConfigurationEvent, msg *eventstream.Message) error {
	if v == nil {
		return fmt.Errorf("unexpected serialization of nil %T", v)
	}

	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.EventMessageType))
	msg.Headers.Set(eventstreamapi.ContentTypeHeader, eventstream.StringValue("application/json"))
	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeDocumentConfigurationEvent(v, jsonEncoder.Value); err != nil {
		return err
	}
	msg.Payload = jsonEncoder.Bytes()
	return nil
}

func awsRestjson1_serializeDocumentChannelDefinition(v *types.ChannelDefinition, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	{
		ok := object.Key("ChannelId")
		ok.Integer(v.ChannelId)
	}

	if len(v.ParticipantRole) > 0 {
		ok := object.Key("ParticipantRole")
		ok.String(string(v.ParticipantRole))
	}

	return nil
}

func awsRestjson1_serializeDocumentChannelDefinitions(v []types.ChannelDefinition, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentChannelDefinition(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentConfigurationEvent(v *types.ConfigurationEvent, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ChannelDefinitions != nil {
		ok := object.Key("ChannelDefinitions")
		if err := awsRestjson1_serializeDocumentChannelDefinitions(v.ChannelDefinitions, ok); err != nil {
			return err
		}
	}

	if v.PostCallAnalyticsSettings != nil {
		ok := object.Key("PostCallAnalyticsSettings")
		if err := awsRestjson1_serializeDocumentPostCallAnalyticsSettings(v.PostCallAnalyticsSettings, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentPostCallAnalyticsSettings(v *types.PostCallAnalyticsSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.ContentRedactionOutput) > 0 {
		ok := object.Key("ContentRedactionOutput")
		ok.String(string(v.ContentRedactionOutput))
	}

	if v.DataAccessRoleArn != nil {
		ok := object.Key("DataAccessRoleArn")
		ok.String(*v.DataAccessRoleArn)
	}

	if v.OutputEncryptionKMSKeyId != nil {
		ok := object.Key("OutputEncryptionKMSKeyId")
		ok.String(*v.OutputEncryptionKMSKeyId)
	}

	if v.OutputLocation != nil {
		ok := object.Key("OutputLocation")
		ok.String(*v.OutputLocation)
	}

	return nil
}
