// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Configuration settings for notifications related to account settings.
type AccountSettingsNotificationConfiguration struct {

	// An Amazon Resource Name (ARN) that grants Timestream permission to publish
	// notifications. This field is only visible if SNS Topic is provided when updating
	// the account settings.
	//
	// This member is required.
	RoleArn *string

	// Details on SNS that are required to send the notification.
	SnsConfiguration *SnsConfiguration

	noSmithyDocumentSerde
}

//	Contains the metadata for query results such as the column names, data types,
//
// and other attributes.
type ColumnInfo struct {

	// The data type of the result set column. The data type can be a scalar or
	// complex. Scalar data types are integers, strings, doubles, Booleans, and others.
	// Complex data types are types such as arrays, rows, and others.
	//
	// This member is required.
	Type *Type

	//  The name of the result set column. The name of the result set is available for
	// columns of all data types except for arrays.
	Name *string

	noSmithyDocumentSerde
}

// Datum represents a single data point in a query result.
type Datum struct {

	//  Indicates if the data point is an array.
	ArrayValue []Datum

	//  Indicates if the data point is null.
	NullValue *bool

	//  Indicates if the data point is a row.
	RowValue *Row

	//  Indicates if the data point is a scalar value such as integer, string, double,
	// or Boolean.
	ScalarValue *string

	//  Indicates if the data point is a timeseries data type.
	TimeSeriesValue []TimeSeriesDataPoint

	noSmithyDocumentSerde
}

// This type is used to map column(s) from the query result to a dimension in the
// destination table.
type DimensionMapping struct {

	// Type for the dimension.
	//
	// This member is required.
	DimensionValueType DimensionValueType

	// Column name from query result.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// Represents an available endpoint against which to make API calls against, as
// well as the TTL for that endpoint.
type Endpoint struct {

	// An endpoint address.
	//
	// This member is required.
	Address *string

	// The TTL for the endpoint, in minutes.
	//
	// This member is required.
	CachePeriodInMinutes int64

	noSmithyDocumentSerde
}

// Configuration required for error reporting.
type ErrorReportConfiguration struct {

	// The S3 configuration for the error reports.
	//
	// This member is required.
	S3Configuration *S3Configuration

	noSmithyDocumentSerde
}

// This contains the location of the error report for a single scheduled query
// call.
type ErrorReportLocation struct {

	// The S3 location where error reports are written.
	S3ReportLocation *S3ReportLocation

	noSmithyDocumentSerde
}

// Statistics for a single scheduled query run.
type ExecutionStats struct {

	// Bytes metered for a single scheduled query run.
	BytesMetered int64

	// Bytes scanned for a single scheduled query run.
	CumulativeBytesScanned int64

	// Data writes metered for records ingested in a single scheduled query run.
	DataWrites int64

	// Total time, measured in milliseconds, that was needed for the scheduled query
	// run to complete.
	ExecutionTimeInMillis int64

	// Number of rows present in the output from running a query before ingestion to
	// destination data source.
	QueryResultRows int64

	// The number of records ingested for a single scheduled query run.
	RecordsIngested int64

	noSmithyDocumentSerde
}

// Configuration object that contains the most recent account settings update,
// visible only if settings have been updated previously.
type LastUpdate struct {

	// The status of the last update. Can be either PENDING , FAILED , or SUCCEEDED .
	Status LastUpdateStatus

	// Error message describing the last account settings update status, visible only
	// if an error occurred.
	StatusMessage *string

	// The number of TimeStream Compute Units (TCUs) requested in the last account
	// settings update.
	TargetQueryTCU *int32

	noSmithyDocumentSerde
}

// MixedMeasureMappings are mappings that can be used to ingest data into a
// mixture of narrow and multi measures in the derived table.
type MixedMeasureMapping struct {

	// Type of the value that is to be read from sourceColumn. If the mapping is for
	// MULTI, use MeasureValueType.MULTI.
	//
	// This member is required.
	MeasureValueType MeasureValueType

	// Refers to the value of measure_name in a result row. This field is required if
	// MeasureNameColumn is provided.
	MeasureName *string

	// Required when measureValueType is MULTI. Attribute mappings for MULTI value
	// measures.
	MultiMeasureAttributeMappings []MultiMeasureAttributeMapping

	// This field refers to the source column from which measure-value is to be read
	// for result materialization.
	SourceColumn *string

	// Target measure name to be used. If not provided, the target measure name by
	// default would be measure-name if provided, or sourceColumn otherwise.
	TargetMeasureName *string

	noSmithyDocumentSerde
}

// Attribute mapping for MULTI value measures.
type MultiMeasureAttributeMapping struct {

	// Type of the attribute to be read from the source column.
	//
	// This member is required.
	MeasureValueType ScalarMeasureValueType

	// Source column from where the attribute value is to be read.
	//
	// This member is required.
	SourceColumn *string

	// Custom name to be used for attribute name in derived table. If not provided,
	// source column name would be used.
	TargetMultiMeasureAttributeName *string

	noSmithyDocumentSerde
}

// Only one of MixedMeasureMappings or MultiMeasureMappings is to be provided.
// MultiMeasureMappings can be used to ingest data as multi measures in the derived
// table.
type MultiMeasureMappings struct {

	// Required. Attribute mappings to be used for mapping query results to ingest
	// data for multi-measure attributes.
	//
	// This member is required.
	MultiMeasureAttributeMappings []MultiMeasureAttributeMapping

	// The name of the target multi-measure name in the derived table. This input is
	// required when measureNameColumn is not provided. If MeasureNameColumn is
	// provided, then value from that column will be used as multi-measure name.
	TargetMultiMeasureName *string

	noSmithyDocumentSerde
}

// Notification configuration for a scheduled query. A notification is sent by
// Timestream when a scheduled query is created, its state is updated or when it is
// deleted.
type NotificationConfiguration struct {

	// Details about the Amazon Simple Notification Service (SNS) configuration. This
	// field is visible only when SNS Topic is provided when updating the account
	// settings.
	//
	// This member is required.
	SnsConfiguration *SnsConfiguration

	noSmithyDocumentSerde
}

// Mapping for named parameters.
type ParameterMapping struct {

	// Parameter name.
	//
	// This member is required.
	Name *string

	// Contains the data type of a column in a query result set. The data type can be
	// scalar or complex. The supported scalar data types are integers, Boolean,
	// string, double, timestamp, date, time, and intervals. The supported complex data
	// types are arrays, rows, and timeseries.
	//
	// This member is required.
	Type *Type

	noSmithyDocumentSerde
}

// A request to update the provisioned capacity settings for querying data.
type ProvisionedCapacityRequest struct {

	// The target compute capacity for querying data, specified in Timestream Compute
	// Units (TCUs).
	//
	// This member is required.
	TargetQueryTCU *int32

	// Configuration settings for notifications related to the provisioned capacity
	// update.
	NotificationConfiguration *AccountSettingsNotificationConfiguration

	noSmithyDocumentSerde
}

// The response to a request to update the provisioned capacity settings for
// querying data.
type ProvisionedCapacityResponse struct {

	// The number of Timestream Compute Units (TCUs) provisioned in the account. This
	// field is only visible when the compute mode is PROVISIONED .
	ActiveQueryTCU *int32

	// Information about the last update to the provisioned capacity settings.
	LastUpdate *LastUpdate

	// An object that contains settings for notifications that are sent whenever the
	// provisioned capacity settings are modified. This field is only visible when the
	// compute mode is PROVISIONED .
	NotificationConfiguration *AccountSettingsNotificationConfiguration

	noSmithyDocumentSerde
}

// A request to retrieve or update the compute capacity settings for querying data.
type QueryComputeRequest struct {

	// The mode in which Timestream Compute Units (TCUs) are allocated and utilized
	// within an account. Note that in the Asia Pacific (Mumbai) region, the API
	// operation only recognizes the value PROVISIONED .
	ComputeMode ComputeMode

	// Configuration object that contains settings for provisioned Timestream Compute
	// Units (TCUs) in your account.
	ProvisionedCapacity *ProvisionedCapacityRequest

	noSmithyDocumentSerde
}

// The response to a request to retrieve or update the compute capacity settings
// for querying data.
type QueryComputeResponse struct {

	// The mode in which Timestream Compute Units (TCUs) are allocated and utilized
	// within an account. Note that in the Asia Pacific (Mumbai) region, the API
	// operation only recognizes the value PROVISIONED .
	ComputeMode ComputeMode

	// Configuration object that contains settings for provisioned Timestream Compute
	// Units (TCUs) in your account.
	ProvisionedCapacity *ProvisionedCapacityResponse

	noSmithyDocumentSerde
}

// QueryInsights is a performance tuning feature that helps you optimize your
// queries, reducing costs and improving performance. With QueryInsights , you can
// assess the pruning efficiency of your queries and identify areas for improvement
// to enhance query performance. With QueryInsights , you can also analyze the
// effectiveness of your queries in terms of temporal and spatial pruning, and
// identify opportunities to improve performance. Specifically, you can evaluate
// how well your queries use time-based and partition key-based indexing strategies
// to optimize data retrieval. To optimize query performance, it's essential that
// you fine-tune both the temporal and spatial parameters that govern query
// execution.
//
// The key metrics provided by QueryInsights are QuerySpatialCoverage and
// QueryTemporalRange . QuerySpatialCoverage indicates how much of the spatial
// axis the query scans, with lower values being more efficient. QueryTemporalRange
// shows the time range scanned, with narrower ranges being more performant.
//
// # Benefits of QueryInsights
//
// The following are the key benefits of using QueryInsights :
//
//   - Identifying inefficient queries – QueryInsights provides information on the
//     time-based and attribute-based pruning of the tables accessed by the query. This
//     information helps you identify the tables that are sub-optimally accessed.
//
//   - Optimizing your data model and partitioning – You can use the QueryInsights
//     information to access and fine-tune your data model and partitioning strategy.
//
//   - Tuning queries – QueryInsights highlights opportunities to use indexes more
//     effectively.
//
// The maximum number of Query API requests you're allowed to make with
// QueryInsights enabled is 1 query per second (QPS). If you exceed this query
// rate, it might result in throttling.
type QueryInsights struct {

	// Provides the following modes to enable QueryInsights :
	//
	//   - ENABLED_WITH_RATE_CONTROL – Enables QueryInsights for the queries being
	//   processed. This mode also includes a rate control mechanism, which limits the
	//   QueryInsights feature to 1 query per second (QPS).
	//
	//   - DISABLED – Disables QueryInsights .
	//
	// This member is required.
	Mode QueryInsightsMode

	noSmithyDocumentSerde
}

// Provides various insights and metrics related to the query that you executed.
type QueryInsightsResponse struct {

	// Indicates the size of query result set in bytes. You can use this data to
	// validate if the result set has changed as part of the query tuning exercise.
	OutputBytes *int64

	// Indicates the total number of rows returned as part of the query result set.
	// You can use this data to validate if the number of rows in the result set have
	// changed as part of the query tuning exercise.
	OutputRows *int64

	// Provides insights into the spatial coverage of the query, including the table
	// with sub-optimal (max) spatial pruning. This information can help you identify
	// areas for improvement in your partitioning strategy to enhance spatial pruning.
	QuerySpatialCoverage *QuerySpatialCoverage

	// Indicates the number of tables in the query.
	QueryTableCount *int64

	// Provides insights into the temporal range of the query, including the table
	// with the largest (max) time range. Following are some of the potential options
	// for optimizing time-based pruning:
	//
	//   - Add missing time-predicates.
	//
	//   - Remove functions around the time predicates.
	//
	//   - Add time predicates to all the sub-queries.
	QueryTemporalRange *QueryTemporalRange

	// Indicates the partitions created by the Unload operation.
	UnloadPartitionCount *int64

	// Indicates the size, in bytes, written by the Unload operation.
	UnloadWrittenBytes *int64

	// Indicates the rows written by the Unload query.
	UnloadWrittenRows *int64

	noSmithyDocumentSerde
}

// Provides insights into the spatial coverage of the query, including the table
// with sub-optimal (max) spatial pruning. This information can help you identify
// areas for improvement in your partitioning strategy to enhance spatial pruning
//
// For example, you can do the following with the QuerySpatialCoverage information:
//
//   - Add measure_name or use [customer-defined partition key](CDPK) predicates.
//
//   - If you've already done the preceding action, remove functions around them
//     or clauses, such as LIKE .
//
// [customer-defined partition key]: https://docs.aws.amazon.com/timestream/latest/developerguide/customer-defined-partition-keys.html
type QuerySpatialCoverage struct {

	// Provides insights into the spatial coverage of the executed query and the table
	// with the most inefficient spatial pruning.
	//
	//   - Value – The maximum ratio of spatial coverage.
	//
	//   - TableArn – The Amazon Resource Name (ARN) of the table with sub-optimal
	//   spatial pruning.
	//
	//   - PartitionKey – The partition key used for partitioning, which can be a
	//   default measure_name or a CDPK.
	Max *QuerySpatialCoverageMax

	noSmithyDocumentSerde
}

// Provides insights into the table with the most sub-optimal spatial range
// scanned by your query.
type QuerySpatialCoverageMax struct {

	// The partition key used for partitioning, which can be a default measure_name or
	// a [customer defined partition key].
	//
	// [customer defined partition key]: https://docs.aws.amazon.com/timestream/latest/developerguide/customer-defined-partition-keys.html
	PartitionKey []string

	// The Amazon Resource Name (ARN) of the table with the most sub-optimal spatial
	// pruning.
	TableArn *string

	// The maximum ratio of spatial coverage.
	Value float64

	noSmithyDocumentSerde
}

// Information about the status of the query, including progress and bytes scanned.
type QueryStatus struct {

	// The amount of data scanned by the query in bytes that you will be charged for.
	// This is a cumulative sum and represents the total amount of data that you will
	// be charged for since the query was started. The charge is applied only once and
	// is either applied when the query completes running or when the query is
	// cancelled.
	CumulativeBytesMetered int64

	// The amount of data scanned by the query in bytes. This is a cumulative sum and
	// represents the total amount of bytes scanned since the query was started.
	CumulativeBytesScanned int64

	// The progress of the query, expressed as a percentage.
	ProgressPercentage float64

	noSmithyDocumentSerde
}

// Provides insights into the temporal range of the query, including the table
// with the largest (max) time range.
type QueryTemporalRange struct {

	// Encapsulates the following properties that provide insights into the most
	// sub-optimal performing table on the temporal axis:
	//
	//   - Value – The maximum duration in nanoseconds between the start and end of the
	//   query.
	//
	//   - TableArn – The Amazon Resource Name (ARN) of the table which is queried with
	//   the largest time range.
	Max *QueryTemporalRangeMax

	noSmithyDocumentSerde
}

// Provides insights into the table with the most sub-optimal temporal pruning
// scanned by your query.
type QueryTemporalRangeMax struct {

	// The Amazon Resource Name (ARN) of the table which is queried with the largest
	// time range.
	TableArn *string

	// The maximum duration in nanoseconds between the start and end of the query.
	Value int64

	noSmithyDocumentSerde
}

// Represents a single row in the query results.
type Row struct {

	// List of data points in a single row of the result set.
	//
	// This member is required.
	Data []Datum

	noSmithyDocumentSerde
}

// Details on S3 location for error reports that result from running a query.
type S3Configuration struct {

	//  Name of the S3 bucket under which error reports will be created.
	//
	// This member is required.
	BucketName *string

	//  Encryption at rest options for the error reports. If no encryption option is
	// specified, Timestream will choose SSE_S3 as default.
	EncryptionOption S3EncryptionOption

	//  Prefix for the error report key. Timestream by default adds the following
	// prefix to the error report path.
	ObjectKeyPrefix *string

	noSmithyDocumentSerde
}

// S3 report location for the scheduled query run.
type S3ReportLocation struct {

	//  S3 bucket name.
	BucketName *string

	// S3 key.
	ObjectKey *string

	noSmithyDocumentSerde
}

// Configuration of the schedule of the query.
type ScheduleConfiguration struct {

	// An expression that denotes when to trigger the scheduled query run. This can be
	// a cron expression or a rate expression.
	//
	// This member is required.
	ScheduleExpression *string

	noSmithyDocumentSerde
}

// Scheduled Query
type ScheduledQuery struct {

	// The Amazon Resource Name.
	//
	// This member is required.
	Arn *string

	// The name of the scheduled query.
	//
	// This member is required.
	Name *string

	// State of scheduled query.
	//
	// This member is required.
	State ScheduledQueryState

	// The creation time of the scheduled query.
	CreationTime *time.Time

	// Configuration for scheduled query error reporting.
	ErrorReportConfiguration *ErrorReportConfiguration

	// Status of the last scheduled query run.
	LastRunStatus ScheduledQueryRunStatus

	// The next time the scheduled query is to be run.
	NextInvocationTime *time.Time

	// The last time the scheduled query was run.
	PreviousInvocationTime *time.Time

	// Target data source where final scheduled query result will be written.
	TargetDestination *TargetDestination

	noSmithyDocumentSerde
}

// Structure that describes scheduled query.
type ScheduledQueryDescription struct {

	// Scheduled query ARN.
	//
	// This member is required.
	Arn *string

	// Name of the scheduled query.
	//
	// This member is required.
	Name *string

	// Notification configuration.
	//
	// This member is required.
	NotificationConfiguration *NotificationConfiguration

	// The query to be run.
	//
	// This member is required.
	QueryString *string

	// Schedule configuration.
	//
	// This member is required.
	ScheduleConfiguration *ScheduleConfiguration

	// State of the scheduled query.
	//
	// This member is required.
	State ScheduledQueryState

	// Creation time of the scheduled query.
	CreationTime *time.Time

	// Error-reporting configuration for the scheduled query.
	ErrorReportConfiguration *ErrorReportConfiguration

	// A customer provided KMS key used to encrypt the scheduled query resource.
	KmsKeyId *string

	// Runtime summary for the last scheduled query run.
	LastRunSummary *ScheduledQueryRunSummary

	// The next time the scheduled query is scheduled to run.
	NextInvocationTime *time.Time

	// Last time the query was run.
	PreviousInvocationTime *time.Time

	// Runtime summary for the last five failed scheduled query runs.
	RecentlyFailedRuns []ScheduledQueryRunSummary

	// IAM role that Timestream uses to run the schedule query.
	ScheduledQueryExecutionRoleArn *string

	// Scheduled query target store configuration.
	TargetConfiguration *TargetConfiguration

	noSmithyDocumentSerde
}

// Encapsulates settings for enabling QueryInsights on an
// ExecuteScheduledQueryRequest .
type ScheduledQueryInsights struct {

	// Provides the following modes to enable ScheduledQueryInsights :
	//
	//   - ENABLED_WITH_RATE_CONTROL – Enables ScheduledQueryInsights for the queries
	//   being processed. This mode also includes a rate control mechanism, which limits
	//   the QueryInsights feature to 1 query per second (QPS).
	//
	//   - DISABLED – Disables ScheduledQueryInsights .
	//
	// This member is required.
	Mode ScheduledQueryInsightsMode

	noSmithyDocumentSerde
}

// Provides various insights and metrics related to the
// ExecuteScheduledQueryRequest that was executed.
type ScheduledQueryInsightsResponse struct {

	// Indicates the size of query result set in bytes. You can use this data to
	// validate if the result set has changed as part of the query tuning exercise.
	OutputBytes *int64

	// Indicates the total number of rows returned as part of the query result set.
	// You can use this data to validate if the number of rows in the result set have
	// changed as part of the query tuning exercise.
	OutputRows *int64

	// Provides insights into the spatial coverage of the query, including the table
	// with sub-optimal (max) spatial pruning. This information can help you identify
	// areas for improvement in your partitioning strategy to enhance spatial pruning.
	QuerySpatialCoverage *QuerySpatialCoverage

	// Indicates the number of tables in the query.
	QueryTableCount *int64

	// Provides insights into the temporal range of the query, including the table
	// with the largest (max) time range. Following are some of the potential options
	// for optimizing time-based pruning:
	//
	//   - Add missing time-predicates.
	//
	//   - Remove functions around the time predicates.
	//
	//   - Add time predicates to all the sub-queries.
	QueryTemporalRange *QueryTemporalRange

	noSmithyDocumentSerde
}

// Run summary for the scheduled query
type ScheduledQueryRunSummary struct {

	// S3 location for error report.
	ErrorReportLocation *ErrorReportLocation

	// Runtime statistics for a scheduled run.
	ExecutionStats *ExecutionStats

	// Error message for the scheduled query in case of failure. You might have to
	// look at the error report to get more detailed error reasons.
	FailureReason *string

	// InvocationTime for this run. This is the time at which the query is scheduled
	// to run. Parameter @scheduled_runtime can be used in the query to get the value.
	InvocationTime *time.Time

	// Provides various insights and metrics related to the run summary of the
	// scheduled query.
	QueryInsightsResponse *ScheduledQueryInsightsResponse

	// The status of a scheduled query run.
	RunStatus ScheduledQueryRunStatus

	// The actual time when the query was run.
	TriggerTime *time.Time

	noSmithyDocumentSerde
}

// Details of the column that is returned by the query.
type SelectColumn struct {

	// True, if the column name was aliased by the query. False otherwise.
	Aliased *bool

	//  Database that has this column.
	DatabaseName *string

	// Name of the column.
	Name *string

	// Table within the database that has this column.
	TableName *string

	// Contains the data type of a column in a query result set. The data type can be
	// scalar or complex. The supported scalar data types are integers, Boolean,
	// string, double, timestamp, date, time, and intervals. The supported complex data
	// types are arrays, rows, and timeseries.
	Type *Type

	noSmithyDocumentSerde
}

// Details on SNS that are required to send the notification.
type SnsConfiguration struct {

	// SNS topic ARN that the scheduled query status notifications will be sent to.
	//
	// This member is required.
	TopicArn *string

	noSmithyDocumentSerde
}

// A tag is a label that you assign to a Timestream database and/or table. Each
// tag consists of a key and an optional value, both of which you define. Tags
// enable you to categorize databases and/or tables, for example, by purpose,
// owner, or environment.
type Tag struct {

	// The key of the tag. Tag keys are case sensitive.
	//
	// This member is required.
	Key *string

	// The value of the tag. Tag values are case sensitive and can be null.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// Configuration used for writing the output of a query.
type TargetConfiguration struct {

	// Configuration needed to write data into the Timestream database and table.
	//
	// This member is required.
	TimestreamConfiguration *TimestreamConfiguration

	noSmithyDocumentSerde
}

// Destination details to write data for a target data source. Current supported
// data source is Timestream.
type TargetDestination struct {

	// Query result destination details for Timestream data source.
	TimestreamDestination *TimestreamDestination

	noSmithyDocumentSerde
}

// The timeseries data type represents the values of a measure over time. A time
// series is an array of rows of timestamps and measure values, with rows sorted in
// ascending order of time. A TimeSeriesDataPoint is a single data point in the
// time series. It represents a tuple of (time, measure value) in a time series.
type TimeSeriesDataPoint struct {

	// The timestamp when the measure value was collected.
	//
	// This member is required.
	Time *string

	// The measure value for the data point.
	//
	// This member is required.
	Value *Datum

	noSmithyDocumentSerde
}

//	Configuration to write data into Timestream database and table. This
//
// configuration allows the user to map the query result select columns into the
// destination table columns.
type TimestreamConfiguration struct {

	// Name of Timestream database to which the query result will be written.
	//
	// This member is required.
	DatabaseName *string

	//  This is to allow mapping column(s) from the query result to the dimension in
	// the destination table.
	//
	// This member is required.
	DimensionMappings []DimensionMapping

	// Name of Timestream table that the query result will be written to. The table
	// should be within the same database that is provided in Timestream configuration.
	//
	// This member is required.
	TableName *string

	// Column from query result that should be used as the time column in destination
	// table. Column type for this should be TIMESTAMP.
	//
	// This member is required.
	TimeColumn *string

	// Name of the measure column.
	MeasureNameColumn *string

	// Specifies how to map measures to multi-measure records.
	MixedMeasureMappings []MixedMeasureMapping

	// Multi-measure mappings.
	MultiMeasureMappings *MultiMeasureMappings

	noSmithyDocumentSerde
}

// Destination for scheduled query.
type TimestreamDestination struct {

	// Timestream database name.
	DatabaseName *string

	// Timestream table name.
	TableName *string

	noSmithyDocumentSerde
}

// Contains the data type of a column in a query result set. The data type can be
// scalar or complex. The supported scalar data types are integers, Boolean,
// string, double, timestamp, date, time, and intervals. The supported complex data
// types are arrays, rows, and timeseries.
type Type struct {

	// Indicates if the column is an array.
	ArrayColumnInfo *ColumnInfo

	// Indicates if the column is a row.
	RowColumnInfo []ColumnInfo

	// Indicates if the column is of type string, integer, Boolean, double, timestamp,
	// date, time. For more information, see [Supported data types].
	//
	// [Supported data types]: https://docs.aws.amazon.com/timestream/latest/developerguide/supported-data-types.html
	ScalarType ScalarType

	// Indicates if the column is a timeseries data type.
	TimeSeriesMeasureValueColumnInfo *ColumnInfo

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
