// Code generated by smithy-go-codegen DO NOT EDIT.

package taxsettings

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/taxsettings/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Adds or updates tax registration for a single account. You can't set a TRN if
// there's a pending TRN. You'll need to delete the pending TRN first.
//
// To call this API operation for specific countries, see the following
// country-specific requirements.
//
// Bangladesh
//
//   - You must specify the tax registration certificate document in the
//     taxRegistrationDocuments field of the VerificationDetails object.
//
// Brazil
//
//   - You must complete the tax registration process in the [Payment preferences]page in the Billing
//     and Cost Management console. After your TRN and billing address are verified,
//     you can call this API operation.
//
//   - For Amazon Web Services accounts created through Organizations, you can
//     call this API operation when you don't have a billing address.
//
// Georgia
//
//   - The valid personType values are Physical Person and Business .
//
// Indonesia
//
//   - PutTaxRegistration : The use of this operation to submit tax information is
//     subject to the [Amazon Web Services service terms]. By submitting, you’re providing consent for Amazon Web
//     Services to validate NIK, NPWP, and NITKU data, provided by you with the
//     Directorate General of Taxes of Indonesia in accordance with the Minister of
//     Finance Regulation (PMK) Number 112/PMK.03/2022.
//
//   - BatchPutTaxRegistration : The use of this operation to submit tax
//     information is subject to the [Amazon Web Services service terms]. By submitting, you’re providing consent for
//     Amazon Web Services to validate NIK, NPWP, and NITKU data, provided by you with
//     the Directorate General of Taxes of Indonesia in accordance with the Minister of
//     Finance Regulation (PMK) Number 112/PMK.03/2022, through our third-party partner
//     PT Achilles Advanced Management (OnlinePajak).
//
//   - You must specify the taxRegistrationNumberType in the
//     indonesiaAdditionalInfo field of the additionalTaxInformation object.
//
//   - If you specify decisionNumber , you must specify the
//     ppnExceptionDesignationCode in the indonesiaAdditionalInfo field of the
//     additionalTaxInformation object. If the taxRegistrationNumberType is set to
//     NPWP or NITKU, valid values for ppnExceptionDesignationCode are either 01 , 02
//     , 03 , 07 , or 08 .
//
// For other taxRegistrationNumberType values, ppnExceptionDesignationCode must be
//
//	either 01 , 07 , or 08 .
//
//	- If ppnExceptionDesignationCode is 07 , you must specify the decisionNumber
//	in the indonesiaAdditionalInfo field of the additionalTaxInformation object.
//
// Kenya
//
//   - You must specify the personType in the kenyaAdditionalInfo field of the
//     additionalTaxInformation object.
//
//   - If the personType is Physical Person , you must specify the tax registration
//     certificate document in the taxRegistrationDocuments field of the
//     VerificationDetails object.
//
// Malaysia
//
//   - The sector valid values are Business and Individual .
//
//   - RegistrationType valid values are NRIC for individual, and TIN and sales and
//     service tax (SST) for Business.
//
//   - For individual, you can specify the taxInformationNumber in
//     MalaysiaAdditionalInfo with NRIC type, and a valid MyKad or NRIC number.
//
//   - For business, you must specify a businessRegistrationNumber in
//     MalaysiaAdditionalInfo with a TIN type and tax identification number.
//
//   - For business resellers, you must specify a businessRegistrationNumber and
//     taxInformationNumber in MalaysiaAdditionalInfo with a sales and service tax
//     (SST) type and a valid SST number.
//
//   - For business resellers with service codes, you must specify
//     businessRegistrationNumber , taxInformationNumber , and distinct
//     serviceTaxCodes in MalaysiaAdditionalInfo with a SST type and valid sales and
//     service tax (SST) number. By using this API operation, Amazon Web Services
//     registers your self-declaration that you’re an authorized business reseller
//     registered with the Royal Malaysia Customs Department (RMCD), and have a valid
//     SST number.
//
//   - Amazon Web Services reserves the right to seek additional information
//     and/or take other actions to support your self-declaration as appropriate.
//
//   - Amazon Web Services is currently registered under the following service tax
//     codes. You must include at least one of the service tax codes in the service tax
//     code strings to declare yourself as an authorized registered business reseller.
//
// Taxable service and service tax codes:
//
// # Consultancy - 9907061674
//
// # Training or coaching service - 9907071685
//
// # IT service - 9907101676
//
// # Digital services and electronic medium - 9907121690
//
// Nepal
//
//   - The sector valid values are Business and Individual .
//
// Saudi Arabia
//
//   - For address , you must specify addressLine3 .
//
// South Korea
//
//   - You must specify the certifiedEmailId and legalName in the
//     TaxRegistrationEntry object. Use Korean characters for legalName .
//
//   - You must specify the businessRepresentativeName , itemOfBusiness , and
//     lineOfBusiness in the southKoreaAdditionalInfo field of the
//     additionalTaxInformation object. Use Korean characters for these fields.
//
//   - You must specify the tax registration certificate document in the
//     taxRegistrationDocuments field of the VerificationDetails object.
//
//   - For the address object, use Korean characters for addressLine1 ,
//     addressLine2 city , postalCode , and stateOrRegion .
//
// Spain
//
//   - You must specify the registrationType in the spainAdditionalInfo field of
//     the additionalTaxInformation object.
//
//   - If the registrationType is Local , you must specify the tax registration
//     certificate document in the taxRegistrationDocuments field of the
//     VerificationDetails object.
//
// Turkey
//
//   - You must specify the sector in the taxRegistrationEntry object.
//
//   - If your sector is Business , Individual , or Government :
//
//   - Specify the taxOffice . If your sector is Individual , don't enter this
//     value.
//
//   - (Optional) Specify the kepEmailId . If your sector is Individual , don't
//     enter this value.
//
//   - Note: In the Tax Settings page of the Billing console, Government appears as
//     Public institutions
//
//   - If your sector is Business and you're subject to KDV tax, you must specify
//     your industry in the industries field.
//
//   - For address , you must specify districtOrCounty .
//
// Ukraine
//
//   - The sector valid values are Business and Individual .
//
// [Amazon Web Services service terms]: http://aws.amazon.com/service-terms/
// [Payment preferences]: https://console.aws.amazon.com/billing/home#/paymentpreferences/paymentmethods
func (c *Client) PutTaxRegistration(ctx context.Context, params *PutTaxRegistrationInput, optFns ...func(*Options)) (*PutTaxRegistrationOutput, error) {
	if params == nil {
		params = &PutTaxRegistrationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "PutTaxRegistration", params, optFns, c.addOperationPutTaxRegistrationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*PutTaxRegistrationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type PutTaxRegistrationInput struct {

	//  Your TRN information that will be stored to the account mentioned in accountId
	// .
	//
	// This member is required.
	TaxRegistrationEntry *types.TaxRegistrationEntry

	// Your unique account identifier.
	AccountId *string

	noSmithyDocumentSerde
}

type PutTaxRegistrationOutput struct {

	// The status of your TRN stored in the system after processing. Based on the
	// validation occurring on the TRN, the status can be Verified , Pending or
	// Rejected .
	Status types.TaxRegistrationStatus

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationPutTaxRegistrationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpPutTaxRegistration{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpPutTaxRegistration{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "PutTaxRegistration"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpPutTaxRegistrationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opPutTaxRegistration(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opPutTaxRegistration(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "PutTaxRegistration",
	}
}
