// Code generated by smithy-go-codegen DO NOT EDIT.

package storagegateway

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/storagegateway/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Gets a description of a Server Message Block (SMB) file share settings from a
// file gateway. This operation is only supported for file gateways.
func (c *Client) DescribeSMBSettings(ctx context.Context, params *DescribeSMBSettingsInput, optFns ...func(*Options)) (*DescribeSMBSettingsOutput, error) {
	if params == nil {
		params = &DescribeSMBSettingsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeSMBSettings", params, optFns, c.addOperationDescribeSMBSettingsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeSMBSettingsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeSMBSettingsInput struct {

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation to return a
	// list of gateways for your account and Amazon Web Services Region.
	//
	// This member is required.
	GatewayARN *string

	noSmithyDocumentSerde
}

type DescribeSMBSettingsOutput struct {

	// Indicates the status of a gateway that is a member of the Active Directory
	// domain.
	//
	// This field is only used as part of a JoinDomain request. It is not affected by
	// Active Directory connectivity changes that occur after the JoinDomain request
	// succeeds.
	//
	//   - ACCESS_DENIED : Indicates that the JoinDomain operation failed due to an
	//   authentication error.
	//
	//   - DETACHED : Indicates that gateway is not joined to a domain.
	//
	//   - JOINED : Indicates that the gateway has successfully joined a domain.
	//
	//   - JOINING : Indicates that a JoinDomain operation is in progress.
	//
	//   - NETWORK_ERROR : Indicates that JoinDomain operation failed due to a network
	//   or connectivity error.
	//
	//   - TIMEOUT : Indicates that the JoinDomain operation failed because the
	//   operation didn't complete within the allotted time.
	//
	//   - UNKNOWN_ERROR : Indicates that the JoinDomain operation failed due to
	//   another type of error.
	ActiveDirectoryStatus types.ActiveDirectoryStatus

	// The name of the domain that the gateway is joined to.
	DomainName *string

	// The shares on this gateway appear when listing shares. Only supported for S3
	// File Gateways.
	FileSharesVisible *bool

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation to return a
	// list of gateways for your account and Amazon Web Services Region.
	GatewayARN *string

	// This value is true if a password for the guest user smbguest is set, otherwise
	// false . Only supported for S3 File Gateways.
	//
	// Valid Values: true | false
	SMBGuestPasswordSet *bool

	// A list of Active Directory users and groups that have special permissions for
	// SMB file shares on the gateway.
	SMBLocalGroups *types.SMBLocalGroups

	// The type of security strategy that was specified for file gateway.
	//
	//   - ClientSpecified : If you choose this option, requests are established based
	//   on what is negotiated by the client. This option is recommended when you want to
	//   maximize compatibility across different clients in your environment. Supported
	//   only for S3 File Gateway.
	//
	//   - MandatorySigning : If you choose this option, File Gateway only allows
	//   connections from SMBv2 or SMBv3 clients that have signing turned on. This option
	//   works with SMB clients on Microsoft Windows Vista, Windows Server 2008, or
	//   later.
	//
	//   - MandatoryEncryption : If you choose this option, File Gateway only allows
	//   connections from SMBv3 clients that have encryption turned on. Both 256-bit and
	//   128-bit algorithms are allowed. This option is recommended for environments that
	//   handle sensitive data. It works with SMB clients on Microsoft Windows 8, Windows
	//   Server 2012, or later.
	//
	//   - MandatoryEncryptionNoAes128 : If you choose this option, File Gateway only
	//   allows connections from SMBv3 clients that use 256-bit AES encryption
	//   algorithms. 128-bit algorithms are not allowed. This option is recommended for
	//   environments that handle sensitive data. It works with SMB clients on Microsoft
	//   Windows 8, Windows Server 2012, or later.
	SMBSecurityStrategy types.SMBSecurityStrategy

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeSMBSettingsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpDescribeSMBSettings{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpDescribeSMBSettings{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeSMBSettings"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpDescribeSMBSettingsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeSMBSettings(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDescribeSMBSettings(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeSMBSettings",
	}
}
