// Code generated by smithy-go-codegen DO NOT EDIT.

package sagemaker

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/sagemaker/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Lists the Amazon SageMaker AI Studio Lifecycle Configurations in your Amazon
// Web Services Account.
func (c *Client) ListStudioLifecycleConfigs(ctx context.Context, params *ListStudioLifecycleConfigsInput, optFns ...func(*Options)) (*ListStudioLifecycleConfigsOutput, error) {
	if params == nil {
		params = &ListStudioLifecycleConfigsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListStudioLifecycleConfigs", params, optFns, c.addOperationListStudioLifecycleConfigsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListStudioLifecycleConfigsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListStudioLifecycleConfigsInput struct {

	// A parameter to search for the App Type to which the Lifecycle Configuration is
	// attached.
	AppTypeEquals types.StudioLifecycleConfigAppType

	// A filter that returns only Lifecycle Configurations created on or after the
	// specified time.
	CreationTimeAfter *time.Time

	// A filter that returns only Lifecycle Configurations created on or before the
	// specified time.
	CreationTimeBefore *time.Time

	// The total number of items to return in the response. If the total number of
	// items available is more than the value specified, a NextToken is provided in
	// the response. To resume pagination, provide the NextToken value in the as part
	// of a subsequent call. The default value is 10.
	MaxResults *int32

	// A filter that returns only Lifecycle Configurations modified after the
	// specified time.
	ModifiedTimeAfter *time.Time

	// A filter that returns only Lifecycle Configurations modified before the
	// specified time.
	ModifiedTimeBefore *time.Time

	// A string in the Lifecycle Configuration name. This filter returns only
	// Lifecycle Configurations whose name contains the specified string.
	NameContains *string

	// If the previous call to ListStudioLifecycleConfigs didn't return the full set
	// of Lifecycle Configurations, the call returns a token for getting the next set
	// of Lifecycle Configurations.
	NextToken *string

	// The property used to sort results. The default value is CreationTime.
	SortBy types.StudioLifecycleConfigSortKey

	// The sort order. The default value is Descending.
	SortOrder types.SortOrder

	noSmithyDocumentSerde
}

type ListStudioLifecycleConfigsOutput struct {

	// If the previous response was truncated, you will receive this token. Use it in
	// your next request to receive the next set of results.
	NextToken *string

	// A list of Lifecycle Configurations and their properties.
	StudioLifecycleConfigs []types.StudioLifecycleConfigDetails

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListStudioLifecycleConfigsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListStudioLifecycleConfigs{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListStudioLifecycleConfigs{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListStudioLifecycleConfigs"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListStudioLifecycleConfigs(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListStudioLifecycleConfigsPaginatorOptions is the paginator options for
// ListStudioLifecycleConfigs
type ListStudioLifecycleConfigsPaginatorOptions struct {
	// The total number of items to return in the response. If the total number of
	// items available is more than the value specified, a NextToken is provided in
	// the response. To resume pagination, provide the NextToken value in the as part
	// of a subsequent call. The default value is 10.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListStudioLifecycleConfigsPaginator is a paginator for
// ListStudioLifecycleConfigs
type ListStudioLifecycleConfigsPaginator struct {
	options   ListStudioLifecycleConfigsPaginatorOptions
	client    ListStudioLifecycleConfigsAPIClient
	params    *ListStudioLifecycleConfigsInput
	nextToken *string
	firstPage bool
}

// NewListStudioLifecycleConfigsPaginator returns a new
// ListStudioLifecycleConfigsPaginator
func NewListStudioLifecycleConfigsPaginator(client ListStudioLifecycleConfigsAPIClient, params *ListStudioLifecycleConfigsInput, optFns ...func(*ListStudioLifecycleConfigsPaginatorOptions)) *ListStudioLifecycleConfigsPaginator {
	if params == nil {
		params = &ListStudioLifecycleConfigsInput{}
	}

	options := ListStudioLifecycleConfigsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListStudioLifecycleConfigsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListStudioLifecycleConfigsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListStudioLifecycleConfigs page.
func (p *ListStudioLifecycleConfigsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListStudioLifecycleConfigsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListStudioLifecycleConfigs(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListStudioLifecycleConfigsAPIClient is a client that implements the
// ListStudioLifecycleConfigs operation.
type ListStudioLifecycleConfigsAPIClient interface {
	ListStudioLifecycleConfigs(context.Context, *ListStudioLifecycleConfigsInput, ...func(*Options)) (*ListStudioLifecycleConfigsOutput, error)
}

var _ ListStudioLifecycleConfigsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListStudioLifecycleConfigs(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListStudioLifecycleConfigs",
	}
}
