// Code generated by smithy-go-codegen DO NOT EDIT.

package s3tables

import (
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/s3tables/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/middleware"
)

type validateOpCreateNamespace struct {
}

func (*validateOpCreateNamespace) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateNamespace) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateNamespaceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateNamespaceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateTableBucket struct {
}

func (*validateOpCreateTableBucket) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateTableBucket) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateTableBucketInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateTableBucketInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateTable struct {
}

func (*validateOpCreateTable) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateTable) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateTableInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateTableInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteNamespace struct {
}

func (*validateOpDeleteNamespace) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteNamespace) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteNamespaceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteNamespaceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteTableBucketEncryption struct {
}

func (*validateOpDeleteTableBucketEncryption) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteTableBucketEncryption) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteTableBucketEncryptionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteTableBucketEncryptionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteTableBucket struct {
}

func (*validateOpDeleteTableBucket) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteTableBucket) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteTableBucketInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteTableBucketInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteTableBucketPolicy struct {
}

func (*validateOpDeleteTableBucketPolicy) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteTableBucketPolicy) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteTableBucketPolicyInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteTableBucketPolicyInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteTable struct {
}

func (*validateOpDeleteTable) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteTable) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteTableInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteTableInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteTablePolicy struct {
}

func (*validateOpDeleteTablePolicy) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteTablePolicy) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteTablePolicyInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteTablePolicyInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetNamespace struct {
}

func (*validateOpGetNamespace) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetNamespace) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetNamespaceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetNamespaceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetTableBucketEncryption struct {
}

func (*validateOpGetTableBucketEncryption) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetTableBucketEncryption) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetTableBucketEncryptionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetTableBucketEncryptionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetTableBucket struct {
}

func (*validateOpGetTableBucket) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetTableBucket) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetTableBucketInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetTableBucketInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetTableBucketMaintenanceConfiguration struct {
}

func (*validateOpGetTableBucketMaintenanceConfiguration) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetTableBucketMaintenanceConfiguration) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetTableBucketMaintenanceConfigurationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetTableBucketMaintenanceConfigurationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetTableBucketPolicy struct {
}

func (*validateOpGetTableBucketPolicy) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetTableBucketPolicy) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetTableBucketPolicyInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetTableBucketPolicyInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetTableEncryption struct {
}

func (*validateOpGetTableEncryption) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetTableEncryption) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetTableEncryptionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetTableEncryptionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetTableMaintenanceConfiguration struct {
}

func (*validateOpGetTableMaintenanceConfiguration) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetTableMaintenanceConfiguration) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetTableMaintenanceConfigurationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetTableMaintenanceConfigurationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetTableMaintenanceJobStatus struct {
}

func (*validateOpGetTableMaintenanceJobStatus) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetTableMaintenanceJobStatus) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetTableMaintenanceJobStatusInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetTableMaintenanceJobStatusInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetTableMetadataLocation struct {
}

func (*validateOpGetTableMetadataLocation) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetTableMetadataLocation) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetTableMetadataLocationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetTableMetadataLocationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetTablePolicy struct {
}

func (*validateOpGetTablePolicy) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetTablePolicy) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetTablePolicyInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetTablePolicyInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListNamespaces struct {
}

func (*validateOpListNamespaces) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListNamespaces) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListNamespacesInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListNamespacesInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListTables struct {
}

func (*validateOpListTables) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListTables) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListTablesInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListTablesInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpPutTableBucketEncryption struct {
}

func (*validateOpPutTableBucketEncryption) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpPutTableBucketEncryption) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*PutTableBucketEncryptionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpPutTableBucketEncryptionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpPutTableBucketMaintenanceConfiguration struct {
}

func (*validateOpPutTableBucketMaintenanceConfiguration) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpPutTableBucketMaintenanceConfiguration) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*PutTableBucketMaintenanceConfigurationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpPutTableBucketMaintenanceConfigurationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpPutTableBucketPolicy struct {
}

func (*validateOpPutTableBucketPolicy) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpPutTableBucketPolicy) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*PutTableBucketPolicyInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpPutTableBucketPolicyInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpPutTableMaintenanceConfiguration struct {
}

func (*validateOpPutTableMaintenanceConfiguration) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpPutTableMaintenanceConfiguration) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*PutTableMaintenanceConfigurationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpPutTableMaintenanceConfigurationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpPutTablePolicy struct {
}

func (*validateOpPutTablePolicy) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpPutTablePolicy) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*PutTablePolicyInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpPutTablePolicyInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpRenameTable struct {
}

func (*validateOpRenameTable) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpRenameTable) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*RenameTableInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpRenameTableInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateTableMetadataLocation struct {
}

func (*validateOpUpdateTableMetadataLocation) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateTableMetadataLocation) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateTableMetadataLocationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateTableMetadataLocationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

func addOpCreateNamespaceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateNamespace{}, middleware.After)
}

func addOpCreateTableBucketValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateTableBucket{}, middleware.After)
}

func addOpCreateTableValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateTable{}, middleware.After)
}

func addOpDeleteNamespaceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteNamespace{}, middleware.After)
}

func addOpDeleteTableBucketEncryptionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteTableBucketEncryption{}, middleware.After)
}

func addOpDeleteTableBucketValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteTableBucket{}, middleware.After)
}

func addOpDeleteTableBucketPolicyValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteTableBucketPolicy{}, middleware.After)
}

func addOpDeleteTableValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteTable{}, middleware.After)
}

func addOpDeleteTablePolicyValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteTablePolicy{}, middleware.After)
}

func addOpGetNamespaceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetNamespace{}, middleware.After)
}

func addOpGetTableBucketEncryptionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetTableBucketEncryption{}, middleware.After)
}

func addOpGetTableBucketValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetTableBucket{}, middleware.After)
}

func addOpGetTableBucketMaintenanceConfigurationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetTableBucketMaintenanceConfiguration{}, middleware.After)
}

func addOpGetTableBucketPolicyValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetTableBucketPolicy{}, middleware.After)
}

func addOpGetTableEncryptionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetTableEncryption{}, middleware.After)
}

func addOpGetTableMaintenanceConfigurationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetTableMaintenanceConfiguration{}, middleware.After)
}

func addOpGetTableMaintenanceJobStatusValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetTableMaintenanceJobStatus{}, middleware.After)
}

func addOpGetTableMetadataLocationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetTableMetadataLocation{}, middleware.After)
}

func addOpGetTablePolicyValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetTablePolicy{}, middleware.After)
}

func addOpListNamespacesValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListNamespaces{}, middleware.After)
}

func addOpListTablesValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListTables{}, middleware.After)
}

func addOpPutTableBucketEncryptionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpPutTableBucketEncryption{}, middleware.After)
}

func addOpPutTableBucketMaintenanceConfigurationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpPutTableBucketMaintenanceConfiguration{}, middleware.After)
}

func addOpPutTableBucketPolicyValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpPutTableBucketPolicy{}, middleware.After)
}

func addOpPutTableMaintenanceConfigurationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpPutTableMaintenanceConfiguration{}, middleware.After)
}

func addOpPutTablePolicyValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpPutTablePolicy{}, middleware.After)
}

func addOpRenameTableValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpRenameTable{}, middleware.After)
}

func addOpUpdateTableMetadataLocationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateTableMetadataLocation{}, middleware.After)
}

func validateEncryptionConfiguration(v *types.EncryptionConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "EncryptionConfiguration"}
	if len(v.SseAlgorithm) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("SseAlgorithm"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateIcebergMetadata(v *types.IcebergMetadata) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "IcebergMetadata"}
	if v.Schema == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Schema"))
	} else if v.Schema != nil {
		if err := validateIcebergSchema(v.Schema); err != nil {
			invalidParams.AddNested("Schema", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateIcebergSchema(v *types.IcebergSchema) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "IcebergSchema"}
	if v.Fields == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Fields"))
	} else if v.Fields != nil {
		if err := validateSchemaFieldList(v.Fields); err != nil {
			invalidParams.AddNested("Fields", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSchemaField(v *types.SchemaField) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SchemaField"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if v.Type == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Type"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSchemaFieldList(v []types.SchemaField) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SchemaFieldList"}
	for i := range v {
		if err := validateSchemaField(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTableMetadata(v types.TableMetadata) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TableMetadata"}
	switch uv := v.(type) {
	case *types.TableMetadataMemberIceberg:
		if err := validateIcebergMetadata(&uv.Value); err != nil {
			invalidParams.AddNested("[iceberg]", err.(smithy.InvalidParamsError))
		}

	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateNamespaceInput(v *CreateNamespaceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateNamespaceInput"}
	if v.TableBucketARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TableBucketARN"))
	}
	if v.Namespace == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Namespace"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateTableBucketInput(v *CreateTableBucketInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateTableBucketInput"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if v.EncryptionConfiguration != nil {
		if err := validateEncryptionConfiguration(v.EncryptionConfiguration); err != nil {
			invalidParams.AddNested("EncryptionConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateTableInput(v *CreateTableInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateTableInput"}
	if v.TableBucketARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TableBucketARN"))
	}
	if v.Namespace == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Namespace"))
	}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if len(v.Format) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Format"))
	}
	if v.Metadata != nil {
		if err := validateTableMetadata(v.Metadata); err != nil {
			invalidParams.AddNested("Metadata", err.(smithy.InvalidParamsError))
		}
	}
	if v.EncryptionConfiguration != nil {
		if err := validateEncryptionConfiguration(v.EncryptionConfiguration); err != nil {
			invalidParams.AddNested("EncryptionConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteNamespaceInput(v *DeleteNamespaceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteNamespaceInput"}
	if v.TableBucketARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TableBucketARN"))
	}
	if v.Namespace == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Namespace"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteTableBucketEncryptionInput(v *DeleteTableBucketEncryptionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteTableBucketEncryptionInput"}
	if v.TableBucketARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TableBucketARN"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteTableBucketInput(v *DeleteTableBucketInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteTableBucketInput"}
	if v.TableBucketARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TableBucketARN"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteTableBucketPolicyInput(v *DeleteTableBucketPolicyInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteTableBucketPolicyInput"}
	if v.TableBucketARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TableBucketARN"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteTableInput(v *DeleteTableInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteTableInput"}
	if v.TableBucketARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TableBucketARN"))
	}
	if v.Namespace == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Namespace"))
	}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteTablePolicyInput(v *DeleteTablePolicyInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteTablePolicyInput"}
	if v.TableBucketARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TableBucketARN"))
	}
	if v.Namespace == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Namespace"))
	}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetNamespaceInput(v *GetNamespaceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetNamespaceInput"}
	if v.TableBucketARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TableBucketARN"))
	}
	if v.Namespace == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Namespace"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetTableBucketEncryptionInput(v *GetTableBucketEncryptionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetTableBucketEncryptionInput"}
	if v.TableBucketARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TableBucketARN"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetTableBucketInput(v *GetTableBucketInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetTableBucketInput"}
	if v.TableBucketARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TableBucketARN"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetTableBucketMaintenanceConfigurationInput(v *GetTableBucketMaintenanceConfigurationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetTableBucketMaintenanceConfigurationInput"}
	if v.TableBucketARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TableBucketARN"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetTableBucketPolicyInput(v *GetTableBucketPolicyInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetTableBucketPolicyInput"}
	if v.TableBucketARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TableBucketARN"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetTableEncryptionInput(v *GetTableEncryptionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetTableEncryptionInput"}
	if v.TableBucketARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TableBucketARN"))
	}
	if v.Namespace == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Namespace"))
	}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetTableMaintenanceConfigurationInput(v *GetTableMaintenanceConfigurationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetTableMaintenanceConfigurationInput"}
	if v.TableBucketARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TableBucketARN"))
	}
	if v.Namespace == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Namespace"))
	}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetTableMaintenanceJobStatusInput(v *GetTableMaintenanceJobStatusInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetTableMaintenanceJobStatusInput"}
	if v.TableBucketARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TableBucketARN"))
	}
	if v.Namespace == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Namespace"))
	}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetTableMetadataLocationInput(v *GetTableMetadataLocationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetTableMetadataLocationInput"}
	if v.TableBucketARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TableBucketARN"))
	}
	if v.Namespace == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Namespace"))
	}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetTablePolicyInput(v *GetTablePolicyInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetTablePolicyInput"}
	if v.TableBucketARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TableBucketARN"))
	}
	if v.Namespace == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Namespace"))
	}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListNamespacesInput(v *ListNamespacesInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListNamespacesInput"}
	if v.TableBucketARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TableBucketARN"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListTablesInput(v *ListTablesInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListTablesInput"}
	if v.TableBucketARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TableBucketARN"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpPutTableBucketEncryptionInput(v *PutTableBucketEncryptionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PutTableBucketEncryptionInput"}
	if v.TableBucketARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TableBucketARN"))
	}
	if v.EncryptionConfiguration == nil {
		invalidParams.Add(smithy.NewErrParamRequired("EncryptionConfiguration"))
	} else if v.EncryptionConfiguration != nil {
		if err := validateEncryptionConfiguration(v.EncryptionConfiguration); err != nil {
			invalidParams.AddNested("EncryptionConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpPutTableBucketMaintenanceConfigurationInput(v *PutTableBucketMaintenanceConfigurationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PutTableBucketMaintenanceConfigurationInput"}
	if v.TableBucketARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TableBucketARN"))
	}
	if len(v.Type) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Type"))
	}
	if v.Value == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Value"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpPutTableBucketPolicyInput(v *PutTableBucketPolicyInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PutTableBucketPolicyInput"}
	if v.TableBucketARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TableBucketARN"))
	}
	if v.ResourcePolicy == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourcePolicy"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpPutTableMaintenanceConfigurationInput(v *PutTableMaintenanceConfigurationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PutTableMaintenanceConfigurationInput"}
	if v.TableBucketARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TableBucketARN"))
	}
	if v.Namespace == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Namespace"))
	}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if len(v.Type) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Type"))
	}
	if v.Value == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Value"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpPutTablePolicyInput(v *PutTablePolicyInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PutTablePolicyInput"}
	if v.TableBucketARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TableBucketARN"))
	}
	if v.Namespace == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Namespace"))
	}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if v.ResourcePolicy == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourcePolicy"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpRenameTableInput(v *RenameTableInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RenameTableInput"}
	if v.TableBucketARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TableBucketARN"))
	}
	if v.Namespace == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Namespace"))
	}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateTableMetadataLocationInput(v *UpdateTableMetadataLocationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateTableMetadataLocationInput"}
	if v.TableBucketARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TableBucketARN"))
	}
	if v.Namespace == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Namespace"))
	}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if v.VersionToken == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VersionToken"))
	}
	if v.MetadataLocation == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MetadataLocation"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}
