// Code generated by smithy-go-codegen DO NOT EDIT.

package paymentcryptographydata

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/paymentcryptographydata/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Encrypts plaintext data to ciphertext using a symmetric (TDES, AES), asymmetric
// (RSA), or derived (DUKPT or EMV) encryption key scheme. For more information,
// see [Encrypt data]in the Amazon Web Services Payment Cryptography User Guide.
//
// You can generate an encryption key within Amazon Web Services Payment
// Cryptography by calling [CreateKey]. You can import your own encryption key by calling [ImportKey].
//
// For this operation, the key must have KeyModesOfUse set to Encrypt . In
// asymmetric encryption, plaintext is encrypted using public component. You can
// import the public component of an asymmetric key pair created outside Amazon Web
// Services Payment Cryptography by calling [ImportKey].
//
// This operation also supports dynamic keys, allowing you to pass a dynamic
// encryption key as a TR-31 WrappedKeyBlock. This can be used when key material is
// frequently rotated, such as during every card transaction, and there is need to
// avoid importing short-lived keys into Amazon Web Services Payment Cryptography.
// To encrypt using dynamic keys, the keyARN is the Key Encryption Key (KEK) of
// the TR-31 wrapped encryption key material. The incoming wrapped key shall have a
// key purpose of D0 with a mode of use of B or D. For more information, see [Using Dynamic Keys]in
// the Amazon Web Services Payment Cryptography User Guide.
//
// For symmetric and DUKPT encryption, Amazon Web Services Payment Cryptography
// supports TDES and AES algorithms. For EMV encryption, Amazon Web Services
// Payment Cryptography supports TDES algorithms.For asymmetric encryption, Amazon
// Web Services Payment Cryptography supports RSA .
//
// When you use TDES or TDES DUKPT, the plaintext data length must be a multiple
// of 8 bytes. For AES or AES DUKPT, the plaintext data length must be a multiple
// of 16 bytes. For RSA, it sould be equal to the key size unless padding is
// enabled.
//
// To encrypt using DUKPT, you must already have a BDK (Base Derivation Key) key
// in your account with KeyModesOfUse set to DeriveKey , or you can generate a new
// DUKPT key by calling [CreateKey]. To encrypt using EMV, you must already have an IMK
// (Issuer Master Key) key in your account with KeyModesOfUse set to DeriveKey .
//
// For information about valid keys for this operation, see [Understanding key attributes] and [Key types for specific data operations] in the Amazon
// Web Services Payment Cryptography User Guide.
//
// Cross-account use: This operation can't be used across different Amazon Web
// Services accounts.
//
// Related operations:
//
// # DecryptData
//
// [GetPublicCertificate]
//
// [ImportKey]
//
// # ReEncryptData
//
// [Using Dynamic Keys]: https://docs.aws.amazon.com/payment-cryptography/latest/userguide/use-cases-acquirers-dynamickeys.html
// [GetPublicCertificate]: https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_GetPublicKeyCertificate.html
// [Encrypt data]: https://docs.aws.amazon.com/payment-cryptography/latest/userguide/encrypt-data.html
// [ImportKey]: https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_ImportKey.html
// [Key types for specific data operations]: https://docs.aws.amazon.com/payment-cryptography/latest/userguide/crypto-ops-validkeys-ops.html
// [Understanding key attributes]: https://docs.aws.amazon.com/payment-cryptography/latest/userguide/keys-validattributes.html
// [CreateKey]: https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_CreateKey.html
func (c *Client) EncryptData(ctx context.Context, params *EncryptDataInput, optFns ...func(*Options)) (*EncryptDataOutput, error) {
	if params == nil {
		params = &EncryptDataInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "EncryptData", params, optFns, c.addOperationEncryptDataMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*EncryptDataOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type EncryptDataInput struct {

	// The encryption key type and attributes for plaintext encryption.
	//
	// This member is required.
	EncryptionAttributes types.EncryptionDecryptionAttributes

	// The keyARN of the encryption key that Amazon Web Services Payment Cryptography
	// uses for plaintext encryption.
	//
	// When a WrappedKeyBlock is provided, this value will be the identifier to the
	// key wrapping key. Otherwise, it is the key identifier used to perform the
	// operation.
	//
	// This member is required.
	KeyIdentifier *string

	// The plaintext to be encrypted.
	//
	// For encryption using asymmetric keys, plaintext data length is constrained by
	// encryption key strength that you define in KeyAlgorithm and padding type that
	// you define in AsymmetricEncryptionAttributes . For more information, see [Encrypt data] in
	// the Amazon Web Services Payment Cryptography User Guide.
	//
	// [Encrypt data]: https://docs.aws.amazon.com/payment-cryptography/latest/userguide/encrypt-data.html
	//
	// This member is required.
	PlainText *string

	// The WrappedKeyBlock containing the encryption key for plaintext encryption.
	WrappedKey *types.WrappedKey

	noSmithyDocumentSerde
}

type EncryptDataOutput struct {

	// The encrypted ciphertext.
	//
	// This member is required.
	CipherText *string

	// The keyARN of the encryption key that Amazon Web Services Payment Cryptography
	// uses for plaintext encryption.
	//
	// This member is required.
	KeyArn *string

	// The key check value (KCV) of the encryption key. The KCV is used to check if
	// all parties holding a given key have the same key or to detect that a key has
	// changed.
	//
	// Amazon Web Services Payment Cryptography computes the KCV according to the CMAC
	// specification.
	KeyCheckValue *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationEncryptDataMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpEncryptData{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpEncryptData{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "EncryptData"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpEncryptDataValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opEncryptData(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opEncryptData(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "EncryptData",
	}
}
