// Code generated by smithy-go-codegen DO NOT EDIT.

package partnercentralselling

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/partnercentralselling/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves a list of resource view snapshots based on specified criteria. This
// operation supports various use cases, including:
//
//   - Fetching all snapshots associated with an engagement.
//
//   - Retrieving snapshots of a specific resource type within an engagement.
//
//   - Obtaining snapshots for a particular resource using a specified template.
//
//   - Accessing the latest snapshot of a resource within an engagement.
//
//   - Filtering snapshots by resource owner.
func (c *Client) ListResourceSnapshots(ctx context.Context, params *ListResourceSnapshotsInput, optFns ...func(*Options)) (*ListResourceSnapshotsOutput, error) {
	if params == nil {
		params = &ListResourceSnapshotsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListResourceSnapshots", params, optFns, c.addOperationListResourceSnapshotsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListResourceSnapshotsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListResourceSnapshotsInput struct {

	//  Specifies the catalog related to the request.
	//
	// This member is required.
	Catalog *string

	//  The unique identifier of the engagement associated with the snapshots.
	//
	// This member is required.
	EngagementIdentifier *string

	// Filters the response to include only snapshots of resources owned by the
	// specified AWS account.
	CreatedBy *string

	//  The maximum number of results to return in a single call.
	MaxResults *int32

	//  The token for the next set of results.
	NextToken *string

	//  Filters the response to include only snapshots of the specified resource.
	ResourceIdentifier *string

	// Filters the response to include only snapshots created using the specified
	// template.
	ResourceSnapshotTemplateIdentifier *string

	//  Filters the response to include only snapshots of the specified resource type.
	ResourceType types.ResourceType

	noSmithyDocumentSerde
}

type ListResourceSnapshotsOutput struct {

	//  An array of resource snapshot summary objects.
	//
	// This member is required.
	ResourceSnapshotSummaries []types.ResourceSnapshotSummary

	//  The token to retrieve the next set of results. If there are no additional
	// results, this value is null.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListResourceSnapshotsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpListResourceSnapshots{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpListResourceSnapshots{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListResourceSnapshots"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListResourceSnapshotsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListResourceSnapshots(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListResourceSnapshotsPaginatorOptions is the paginator options for
// ListResourceSnapshots
type ListResourceSnapshotsPaginatorOptions struct {
	//  The maximum number of results to return in a single call.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListResourceSnapshotsPaginator is a paginator for ListResourceSnapshots
type ListResourceSnapshotsPaginator struct {
	options   ListResourceSnapshotsPaginatorOptions
	client    ListResourceSnapshotsAPIClient
	params    *ListResourceSnapshotsInput
	nextToken *string
	firstPage bool
}

// NewListResourceSnapshotsPaginator returns a new ListResourceSnapshotsPaginator
func NewListResourceSnapshotsPaginator(client ListResourceSnapshotsAPIClient, params *ListResourceSnapshotsInput, optFns ...func(*ListResourceSnapshotsPaginatorOptions)) *ListResourceSnapshotsPaginator {
	if params == nil {
		params = &ListResourceSnapshotsInput{}
	}

	options := ListResourceSnapshotsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListResourceSnapshotsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListResourceSnapshotsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListResourceSnapshots page.
func (p *ListResourceSnapshotsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListResourceSnapshotsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListResourceSnapshots(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListResourceSnapshotsAPIClient is a client that implements the
// ListResourceSnapshots operation.
type ListResourceSnapshotsAPIClient interface {
	ListResourceSnapshots(context.Context, *ListResourceSnapshotsInput, ...func(*Options)) (*ListResourceSnapshotsOutput, error)
}

var _ ListResourceSnapshotsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListResourceSnapshots(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListResourceSnapshots",
	}
}
