// Code generated by smithy-go-codegen DO NOT EDIT.

package odb

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/odb/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a VM cluster on the specified Exadata infrastructure.
func (c *Client) CreateCloudVmCluster(ctx context.Context, params *CreateCloudVmClusterInput, optFns ...func(*Options)) (*CreateCloudVmClusterOutput, error) {
	if params == nil {
		params = &CreateCloudVmClusterInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateCloudVmCluster", params, optFns, c.addOperationCreateCloudVmClusterMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateCloudVmClusterOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateCloudVmClusterInput struct {

	// The unique identifier of the Exadata infrastructure for this VM cluster.
	//
	// This member is required.
	CloudExadataInfrastructureId *string

	// The number of CPU cores to enable on the VM cluster.
	//
	// This member is required.
	CpuCoreCount *int32

	// A user-friendly name for the VM cluster.
	//
	// This member is required.
	DisplayName *string

	// A valid software version of Oracle Grid Infrastructure (GI). To get the list of
	// valid values, use the ListGiVersions operation and specify the shape of the
	// Exadata infrastructure.
	//
	// Example: 19.0.0.0
	//
	// This member is required.
	GiVersion *string

	// The host name for the VM cluster.
	//
	// Constraints:
	//
	//   - Can't be "localhost" or "hostname".
	//
	//   - Can't contain "-version".
	//
	//   - The maximum length of the combined hostname and domain is 63 characters.
	//
	//   - The hostname must be unique within the subnet.
	//
	// This member is required.
	Hostname *string

	// The unique identifier of the ODB network for the VM cluster.
	//
	// This member is required.
	OdbNetworkId *string

	// The public key portion of one or more key pairs used for SSH access to the VM
	// cluster.
	//
	// This member is required.
	SshPublicKeys []string

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. If you don't specify a client token, the Amazon Web Services SDK
	// automatically generates a client token and uses it for the request to ensure
	// idempotency. The client token is valid for up to 24 hours after it's first used.
	ClientToken *string

	// A name for the Grid Infrastructure cluster. The name isn't case sensitive.
	ClusterName *string

	// The set of preferences for the various diagnostic collection options for the VM
	// cluster.
	DataCollectionOptions *types.DataCollectionOptions

	// The size of the data disk group, in terabytes (TBs), to allocate for the VM
	// cluster.
	DataStorageSizeInTBs *float64

	// The amount of local node storage, in gigabytes (GBs), to allocate for the VM
	// cluster.
	DbNodeStorageSizeInGBs *int32

	// The list of database servers for the VM cluster.
	DbServers []string

	// Specifies whether to enable database backups to local Exadata storage for the
	// VM cluster.
	IsLocalBackupEnabled *bool

	// Specifies whether to create a sparse disk group for the VM cluster.
	IsSparseDiskgroupEnabled *bool

	// The Oracle license model to apply to the VM cluster.
	//
	// Default: LICENSE_INCLUDED
	LicenseModel types.LicenseModel

	// The amount of memory, in gigabytes (GBs), to allocate for the VM cluster.
	MemorySizeInGBs *int32

	// The port number for TCP connections to the single client access name (SCAN)
	// listener.
	//
	// Valid values: 1024–8999 with the following exceptions: 2484 , 6100 , 6200 , 7060
	// , 7070 , 7085 , and 7879
	//
	// Default: 1521
	ScanListenerPortTcp *int32

	// The version of the operating system of the image for the VM cluster.
	SystemVersion *string

	// The list of resource tags to apply to the VM cluster.
	Tags map[string]string

	// The time zone for the VM cluster. For a list of valid values for time zone, you
	// can check the options in the console.
	//
	// Default: UTC
	TimeZone *string

	noSmithyDocumentSerde
}

type CreateCloudVmClusterOutput struct {

	// The unique identifier for the VM cluster.
	//
	// This member is required.
	CloudVmClusterId *string

	// The user-friendly name for the VM cluster.
	DisplayName *string

	// The current status of the VM cluster.
	Status types.ResourceStatus

	// Additional information about the status of the VM cluster.
	StatusReason *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateCloudVmClusterMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpCreateCloudVmCluster{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpCreateCloudVmCluster{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateCloudVmCluster"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opCreateCloudVmClusterMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpCreateCloudVmClusterValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateCloudVmCluster(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpCreateCloudVmCluster struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpCreateCloudVmCluster) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpCreateCloudVmCluster) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*CreateCloudVmClusterInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *CreateCloudVmClusterInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opCreateCloudVmClusterMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpCreateCloudVmCluster{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opCreateCloudVmCluster(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateCloudVmCluster",
	}
}
