// Code generated by smithy-go-codegen DO NOT EDIT.

package marketplacemetering

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Paid container software products sold through Amazon Web Services Marketplace
// must integrate with the Amazon Web Services Marketplace Metering Service and
// call the RegisterUsage operation for software entitlement and metering. Free
// and BYOL products for Amazon ECS or Amazon EKS aren't required to call
// RegisterUsage , but you may choose to do so if you would like to receive usage
// data in your seller reports. The sections below explain the behavior of
// RegisterUsage . RegisterUsage performs two primary functions: metering and
// entitlement.
//
//   - Entitlement: RegisterUsage allows you to verify that the customer running
//     your paid software is subscribed to your product on Amazon Web Services
//     Marketplace, enabling you to guard against unauthorized use. Your container
//     image that integrates with RegisterUsage is only required to guard against
//     unauthorized use at container startup, as such a
//     CustomerNotSubscribedException or PlatformNotSupportedException will only be
//     thrown on the initial call to RegisterUsage . Subsequent calls from the same
//     Amazon ECS task instance (e.g. task-id) or Amazon EKS pod will not throw a
//     CustomerNotSubscribedException , even if the customer unsubscribes while the
//     Amazon ECS task or Amazon EKS pod is still running.
//
//   - Metering: RegisterUsage meters software use per ECS task, per hour, or per
//     pod for Amazon EKS with usage prorated to the second. A minimum of 1 minute of
//     usage applies to tasks that are short lived. For example, if a customer has a 10
//     node Amazon ECS or Amazon EKS cluster and a service configured as a Daemon Set,
//     then Amazon ECS or Amazon EKS will launch a task on all 10 cluster nodes and the
//     customer will be charged for 10 tasks. Software metering is handled by the
//     Amazon Web Services Marketplace metering control plane—your software is not
//     required to perform metering-specific actions other than to call RegisterUsage
//     to commence metering. The Amazon Web Services Marketplace metering control plane
//     will also bill customers for running ECS tasks and Amazon EKS pods, regardless
//     of the customer's subscription state, which removes the need for your software
//     to run entitlement checks at runtime. For containers, RegisterUsage should be
//     called immediately at launch. If you don’t register the container within the
//     first 6 hours of the launch, Amazon Web Services Marketplace Metering Service
//     doesn’t provide any metering guarantees for previous months. Metering will
//     continue, however, for the current month forward until the container ends.
//     RegisterUsage is for metering paid hourly container products.
//
// For Amazon Web Services Regions that support RegisterUsage , see [RegisterUsage Region support].
//
// [RegisterUsage Region support]: https://docs.aws.amazon.com/marketplace/latest/APIReference/metering-regions.html#registerusage-region-support
func (c *Client) RegisterUsage(ctx context.Context, params *RegisterUsageInput, optFns ...func(*Options)) (*RegisterUsageOutput, error) {
	if params == nil {
		params = &RegisterUsageInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "RegisterUsage", params, optFns, c.addOperationRegisterUsageMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*RegisterUsageOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type RegisterUsageInput struct {

	// Product code is used to uniquely identify a product in Amazon Web Services
	// Marketplace. The product code should be the same as the one used during the
	// publishing of a new product.
	//
	// This member is required.
	ProductCode *string

	// Public Key Version provided by Amazon Web Services Marketplace
	//
	// This member is required.
	PublicKeyVersion *int32

	// (Optional) To scope down the registration to a specific running software
	// instance and guard against replay attacks.
	Nonce *string

	noSmithyDocumentSerde
}

type RegisterUsageOutput struct {

	// (Optional) Only included when public key version has expired
	PublicKeyRotationTimestamp *time.Time

	// JWT Token
	Signature *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationRegisterUsageMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpRegisterUsage{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpRegisterUsage{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "RegisterUsage"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpRegisterUsageValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opRegisterUsage(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opRegisterUsage(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "RegisterUsage",
	}
}
