// Code generated by smithy-go-codegen DO NOT EDIT.

package iotsitewise

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/iotsitewise/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves a paginated list of properties associated with an asset model. If you
// update properties associated with the model before you finish listing all the
// properties, you need to start all over again.
func (c *Client) ListAssetModelProperties(ctx context.Context, params *ListAssetModelPropertiesInput, optFns ...func(*Options)) (*ListAssetModelPropertiesOutput, error) {
	if params == nil {
		params = &ListAssetModelPropertiesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListAssetModelProperties", params, optFns, c.addOperationListAssetModelPropertiesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListAssetModelPropertiesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListAssetModelPropertiesInput struct {

	// The ID of the asset model. This can be either the actual ID in UUID format, or
	// else externalId: followed by the external ID, if it has one. For more
	// information, see [Referencing objects with external IDs]in the IoT SiteWise User Guide.
	//
	// [Referencing objects with external IDs]: https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references
	//
	// This member is required.
	AssetModelId *string

	// The version alias that specifies the latest or active version of the asset
	// model. The details are returned in the response. The default value is LATEST .
	// See [Asset model versions]in the IoT SiteWise User Guide.
	//
	// [Asset model versions]: https://docs.aws.amazon.com/iot-sitewise/latest/userguide/model-active-version.html
	AssetModelVersion *string

	//  Filters the requested list of asset model properties. You can choose one of
	// the following options:
	//
	//   - ALL – The list includes all asset model properties for a given asset model
	//   ID.
	//
	//   - BASE – The list includes only base asset model properties for a given asset
	//   model ID.
	//
	// Default: BASE
	Filter types.ListAssetModelPropertiesFilter

	// The maximum number of results to return for each paginated request. If not
	// specified, the default value is 50.
	MaxResults *int32

	// The token to be used for the next set of paginated results.
	NextToken *string

	noSmithyDocumentSerde
}

type ListAssetModelPropertiesOutput struct {

	// A list that summarizes the properties associated with the specified asset model.
	//
	// This member is required.
	AssetModelPropertySummaries []types.AssetModelPropertySummary

	// The token for the next set of results, or null if there are no additional
	// results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListAssetModelPropertiesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListAssetModelProperties{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListAssetModelProperties{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListAssetModelProperties"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addEndpointPrefix_opListAssetModelPropertiesMiddleware(stack); err != nil {
		return err
	}
	if err = addOpListAssetModelPropertiesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListAssetModelProperties(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListAssetModelPropertiesPaginatorOptions is the paginator options for
// ListAssetModelProperties
type ListAssetModelPropertiesPaginatorOptions struct {
	// The maximum number of results to return for each paginated request. If not
	// specified, the default value is 50.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListAssetModelPropertiesPaginator is a paginator for ListAssetModelProperties
type ListAssetModelPropertiesPaginator struct {
	options   ListAssetModelPropertiesPaginatorOptions
	client    ListAssetModelPropertiesAPIClient
	params    *ListAssetModelPropertiesInput
	nextToken *string
	firstPage bool
}

// NewListAssetModelPropertiesPaginator returns a new
// ListAssetModelPropertiesPaginator
func NewListAssetModelPropertiesPaginator(client ListAssetModelPropertiesAPIClient, params *ListAssetModelPropertiesInput, optFns ...func(*ListAssetModelPropertiesPaginatorOptions)) *ListAssetModelPropertiesPaginator {
	if params == nil {
		params = &ListAssetModelPropertiesInput{}
	}

	options := ListAssetModelPropertiesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListAssetModelPropertiesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListAssetModelPropertiesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListAssetModelProperties page.
func (p *ListAssetModelPropertiesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListAssetModelPropertiesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListAssetModelProperties(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

type endpointPrefix_opListAssetModelPropertiesMiddleware struct {
}

func (*endpointPrefix_opListAssetModelPropertiesMiddleware) ID() string {
	return "EndpointHostPrefix"
}

func (m *endpointPrefix_opListAssetModelPropertiesMiddleware) HandleFinalize(ctx context.Context, in middleware.FinalizeInput, next middleware.FinalizeHandler) (
	out middleware.FinalizeOutput, metadata middleware.Metadata, err error,
) {
	if smithyhttp.GetHostnameImmutable(ctx) || smithyhttp.IsEndpointHostPrefixDisabled(ctx) {
		return next.HandleFinalize(ctx, in)
	}

	req, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, fmt.Errorf("unknown transport type %T", in.Request)
	}

	req.URL.Host = "api." + req.URL.Host

	return next.HandleFinalize(ctx, in)
}
func addEndpointPrefix_opListAssetModelPropertiesMiddleware(stack *middleware.Stack) error {
	return stack.Finalize.Insert(&endpointPrefix_opListAssetModelPropertiesMiddleware{}, "ResolveEndpointV2", middleware.After)
}

// ListAssetModelPropertiesAPIClient is a client that implements the
// ListAssetModelProperties operation.
type ListAssetModelPropertiesAPIClient interface {
	ListAssetModelProperties(context.Context, *ListAssetModelPropertiesInput, ...func(*Options)) (*ListAssetModelPropertiesOutput, error)
}

var _ ListAssetModelPropertiesAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListAssetModelProperties(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListAssetModelProperties",
	}
}
