// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
)

// Geometry defined as a circle. When request routing boundary was set as
// AutoCircle , the response routing boundary will return Circle derived from the
// AutoCircle settings.
type Circle struct {

	// Center of the Circle defined in longitude and latitude coordinates.
	//
	// Example: [-123.1174, 49.2847] represents the position with longitude -123.1174
	// and latitude 49.2847 .
	//
	// This member is required.
	Center []float64

	// Radius of the Circle.
	//
	// Unit: meters
	//
	// This member is required.
	Radius *float64

	noSmithyDocumentSerde
}

// Geometry defined as a corridor - a LineString with a radius that defines the
// width of the corridor.
type Corridor struct {

	// An ordered list of positions used to plot a route on a map.
	//
	// LineString and Polyline are mutually exclusive properties.
	//
	// This member is required.
	LineString [][]float64

	// Radius that defines the width of the corridor.
	//
	// This member is required.
	Radius *int32

	noSmithyDocumentSerde
}

// Calculated isolines and associated properties.
type Isoline struct {

	// Isolines may contain multiple components, if these components are connected by
	// ferry links. These components are returned as separate polygons while the ferry
	// links are returned as connections.
	//
	// This member is required.
	Connections []IsolineConnection

	// Geometries for the Calculated isolines.
	//
	// This member is required.
	Geometries []IsolineShapeGeometry

	// Distance threshold corresponding to the calculated Isoline.
	DistanceThreshold int64

	// Time threshold corresponding to the calculated isoline.
	TimeThreshold int64

	noSmithyDocumentSerde
}

// Features that are allowed while calculating an isoline.
type IsolineAllowOptions struct {

	// Allow Hot (High Occupancy Toll) lanes while calculating an isoline.
	//
	// Default value: false
	Hot *bool

	// Allow Hov (High Occupancy vehicle) lanes while calculating an isoline.
	//
	// Default value: false
	Hov *bool

	noSmithyDocumentSerde
}

// The area to be avoided.
type IsolineAvoidanceArea struct {

	// Geometry of the area to be avoided.
	//
	// This member is required.
	Geometry *IsolineAvoidanceAreaGeometry

	// Exceptions to the provided avoidance geometry, to be included while calculating
	// an isoline.
	Except []IsolineAvoidanceAreaGeometry

	noSmithyDocumentSerde
}

// The avoidance geometry, to be included while calculating an isoline.
type IsolineAvoidanceAreaGeometry struct {

	// Geometry defined as a bounding box. The first pair represents the X and Y
	// coordinates (longitude and latitude,) of the southwest corner of the bounding
	// box; the second pair represents the X and Y coordinates (longitude and latitude)
	// of the northeast corner.
	BoundingBox []float64

	// Geometry defined as a corridor - a LineString with a radius that defines the
	// width of the corridor.
	Corridor *Corridor

	// A list of Polygon will be excluded for calculating isolines, the list can only
	// contain 1 polygon.
	Polygon [][][]float64

	// Geometry defined as an encoded corridor – a polyline with a radius that defines
	// the width of the corridor. For more information on polyline encoding, see [https://github.com/heremaps/flexiblepolyline/blob/master/README.md].
	//
	// [https://github.com/heremaps/flexiblepolyline/blob/master/README.md]: https://github.com/heremaps/flexiblepolyline/blob/master/README.md
	PolylineCorridor *PolylineCorridor

	// A list of PolylinePolygon's that are excluded for calculating isolines, the
	// list can only contain 1 polygon. For more information on polyline encoding, see [https://github.com/heremaps/flexiblepolyline/blob/master/README.md]
	// .
	//
	// [https://github.com/heremaps/flexiblepolyline/blob/master/README.md]: https://github.com/heremaps/flexiblepolyline/blob/master/README.md
	PolylinePolygon []string

	noSmithyDocumentSerde
}

// Features that are avoided while calculating isolines. Avoidance is on a
// best-case basis. If an avoidance can't be satisfied for a particular case, it
// violates the avoidance and the returned response produces a notice for the
// violation.
type IsolineAvoidanceOptions struct {

	// Areas to be avoided.
	Areas []IsolineAvoidanceArea

	// Avoid car-shuttle-trains while calculating an isoline.
	CarShuttleTrains *bool

	// Avoid controlled access highways while calculating an isoline.
	ControlledAccessHighways *bool

	// Avoid dirt roads while calculating an isoline.
	DirtRoads *bool

	// Avoid ferries while calculating an isoline.
	Ferries *bool

	// Avoid roads that have seasonal closure while calculating an isoline.
	SeasonalClosure *bool

	// Avoids roads where the specified toll transponders are the only mode of payment.
	TollRoads *bool

	// Avoids roads where the specified toll transponders are the only mode of payment.
	TollTransponders *bool

	// Truck road type identifiers. BK1 through BK4 apply only to Sweden.
	// A2,A4,B2,B4,C,D,ET2,ET4 apply only to Mexico.
	//
	// There are currently no other supported values as of 26th April 2024.
	TruckRoadTypes []string

	// Avoid tunnels while calculating an isoline.
	Tunnels *bool

	// Avoid U-turns for calculation on highways and motorways.
	UTurns *bool

	// Zone categories to be avoided.
	ZoneCategories []IsolineAvoidanceZoneCategory

	noSmithyDocumentSerde
}

// Zone category to be avoided.
type IsolineAvoidanceZoneCategory struct {

	// Zone category to be avoided.
	Category IsolineZoneCategory

	noSmithyDocumentSerde
}

// Travel mode options when the provided travel mode is Car .
type IsolineCarOptions struct {

	// Engine type of the vehicle.
	EngineType IsolineEngineType

	// The vehicle License Plate.
	LicensePlate *IsolineVehicleLicensePlate

	// Maximum speed.
	//
	// Unit: KilometersPerHour
	MaxSpeed *float64

	// The number of occupants in the vehicle.
	//
	// Default Value: 1
	Occupancy *int32

	noSmithyDocumentSerde
}

// Isolines may contain multiple components, if these components are connected by
// ferry links. These components are returned as separate polygons while the ferry
// links are returned as connections.
type IsolineConnection struct {

	// Index of the polygon corresponding to the "from" component of the connection.
	// The polygon is available from Isoline[].Geometries .
	//
	// This member is required.
	FromPolygonIndex *int32

	// The isoline geometry.
	//
	// This member is required.
	Geometry *IsolineConnectionGeometry

	// Index of the polygon corresponding to the "to" component of the connection. The
	// polygon is available from Isoline[].Geometries .
	//
	// This member is required.
	ToPolygonIndex *int32

	noSmithyDocumentSerde
}

// Geometry of the connection between different isoline components.
type IsolineConnectionGeometry struct {

	// An ordered list of positions used to plot a route on a map.
	//
	// LineString and Polyline are mutually exclusive properties.
	LineString [][]float64

	// An ordered list of positions used to plot a route on a map in a lossy
	// compression format.
	//
	// LineString and Polyline are mutually exclusive properties.
	Polyline *string

	noSmithyDocumentSerde
}

// Destination related options.
type IsolineDestinationOptions struct {

	// Avoids actions for the provided distance. This is typically to consider for
	// users in moving vehicles who may not have sufficient time to make an action at
	// an origin or a destination.
	AvoidActionsForDistance int64

	// GPS Heading at the position.
	Heading float64

	// Options to configure matching the provided position to the road network.
	Matching *IsolineMatchingOptions

	// Options to configure matching the provided position to a side of the street.
	SideOfStreet *IsolineSideOfStreetOptions

	noSmithyDocumentSerde
}

// Isoline granularity related options.
type IsolineGranularityOptions struct {

	// Maximum number of points of returned Isoline.
	MaxPoints *int32

	// Maximum resolution of the returned isoline.
	//
	// Unit: meters
	MaxResolution int64

	noSmithyDocumentSerde
}

// Isoline matching related options.
type IsolineMatchingOptions struct {

	// Attempts to match the provided position to a road similar to the provided name.
	NameHint *string

	// If the distance to a highway/bridge/tunnel/sliproad is within threshold, the
	// waypoint will be snapped to the highway/bridge/tunnel/sliproad.
	//
	// Unit: meters
	OnRoadThreshold int64

	// Considers all roads within the provided radius to match the provided
	// destination to. The roads that are considered are determined by the provided
	// Strategy.
	//
	// Unit: Meters
	Radius int64

	// Strategy that defines matching of the position onto the road network. MatchAny
	// considers all roads possible, whereas MatchMostSignificantRoad matches to the
	// most significant road.
	Strategy MatchingStrategy

	noSmithyDocumentSerde
}

// Origin related options.
type IsolineOriginOptions struct {

	// Avoids actions for the provided distance. This is typically to consider for
	// users in moving vehicles who may not have sufficient time to make an action at
	// an origin or a destination.
	AvoidActionsForDistance int64

	// GPS Heading at the position.
	Heading float64

	// Options to configure matching the provided position to the road network.
	Matching *IsolineMatchingOptions

	// Options to configure matching the provided position to a side of the street.
	SideOfStreet *IsolineSideOfStreetOptions

	noSmithyDocumentSerde
}

// Travel mode options when the provided travel mode is Scooter
type IsolineScooterOptions struct {

	// Engine type of the vehicle.
	EngineType IsolineEngineType

	// The vehicle License Plate.
	LicensePlate *IsolineVehicleLicensePlate

	// Maximum speed specified.
	//
	// Unit: KilometersPerHour
	MaxSpeed *float64

	// The number of occupants in the vehicle.
	//
	// Default Value: 1
	Occupancy *int32

	noSmithyDocumentSerde
}

// Geometry of the connection between different Isoline components.
type IsolineShapeGeometry struct {

	// A list of Isoline Polygons, for each isoline polygon, it contains polygons of
	// the first linear ring (the outer ring) and from 2nd item to the last item (the
	// inner rings).
	Polygon [][][]float64

	// A list of Isoline PolylinePolygon, for each isoline PolylinePolygon, it
	// contains PolylinePolygon of the first linear ring (the outer ring) and from 2nd
	// item to the last item (the inner rings). For more information on polyline
	// encoding, see [https://github.com/heremaps/flexiblepolyline/blob/master/README.md].
	//
	// [https://github.com/heremaps/flexiblepolyline/blob/master/README.md]: https://github.com/heremaps/flexiblepolyline/blob/master/README.md
	PolylinePolygon []string

	noSmithyDocumentSerde
}

// Options to configure matching the provided position to a side of the street.
type IsolineSideOfStreetOptions struct {

	// Position defined as [longitude, latitude] .
	//
	// This member is required.
	Position []float64

	// Strategy that defines when the side of street position should be used.
	// AnyStreet will always use the provided position.
	//
	// Default Value: DividedStreetOnly
	UseWith SideOfStreetMatchingStrategy

	noSmithyDocumentSerde
}

// Threshold to be used for the isoline calculation. Up to 5 thresholds per
// provided type can be requested.
type IsolineThresholds struct {

	// Distance to be used for the isoline calculation.
	Distance []int64

	// Time to be used for the isoline calculation.
	Time []int64

	noSmithyDocumentSerde
}

// Options related to traffic.
type IsolineTrafficOptions struct {

	// Duration for which flow traffic is considered valid. For this period, the flow
	// traffic is used over historical traffic data. Flow traffic refers to congestion,
	// which changes very quickly. Duration in seconds for which flow traffic event
	// would be considered valid. While flow traffic event is valid it will be used
	// over the historical traffic data.
	//
	// Unit: seconds
	FlowEventThresholdOverride int64

	// Determines if traffic should be used or ignored while calculating the route.
	//
	// Default Value: UseTrafficData
	Usage TrafficUsage

	noSmithyDocumentSerde
}

// Trailer options corresponding to the vehicle.
type IsolineTrailerOptions struct {

	// Total number of axles of the vehicle.
	AxleCount *int32

	// Number of trailers attached to the vehicle.
	//
	// Default Value: 0
	TrailerCount *int32

	noSmithyDocumentSerde
}

// Travel mode related options for the provided travel mode.
type IsolineTravelModeOptions struct {

	// Travel mode options when the provided travel mode is "Car"
	Car *IsolineCarOptions

	// Travel mode options when the provided travel mode is Scooter
	//
	// When travel mode is set to Scooter , then the avoidance option
	// ControlledAccessHighways defaults to true .
	Scooter *IsolineScooterOptions

	// Travel mode options when the provided travel mode is "Truck"
	Truck *IsolineTruckOptions

	noSmithyDocumentSerde
}

// Travel mode options when the provided travel mode is "Truck"
type IsolineTruckOptions struct {

	// Total number of axles of the vehicle.
	AxleCount *int32

	// Engine type of the vehicle.
	EngineType IsolineEngineType

	// Gross weight of the vehicle including trailers, and goods at capacity.
	//
	// Unit: Kilograms
	GrossWeight int64

	// List of Hazardous cargo contained in the vehicle.
	HazardousCargos []IsolineHazardousCargoType

	// Height of the vehicle.
	//
	// Unit: centimeters
	Height int64

	// Height of the vehicle above its first axle.
	//
	// Unit: centimeters
	HeightAboveFirstAxle int64

	// Kingpin to rear axle length of the vehicle.
	//
	// Unit: centimeters
	KpraLength int64

	// Length of the vehicle.
	//
	// Unit: centimeters
	Length int64

	// The vehicle License Plate.
	LicensePlate *IsolineVehicleLicensePlate

	// Maximum speed specified.
	//
	// Unit: KilometersPerHour
	MaxSpeed *float64

	// The number of occupants in the vehicle.
	//
	// Default Value: 1
	Occupancy *int32

	// Payload capacity of the vehicle and trailers attached.
	//
	// Unit: kilograms
	PayloadCapacity int64

	// Number of tires on the vehicle.
	TireCount *int32

	// Trailer options corresponding to the vehicle.
	Trailer *IsolineTrailerOptions

	// Type of the truck.
	TruckType IsolineTruckType

	// The tunnel restriction code.
	//
	// Tunnel categories in this list indicate the restrictions which apply to certain
	// tunnels in Great Britain. They relate to the types of dangerous goods that can
	// be transported through them.
	//
	//   - Tunnel Category B
	//
	//   - Risk Level: Limited risk
	//
	//   - Restrictions: Few restrictions
	//
	//   - Tunnel Category C
	//
	//   - Risk Level: Medium risk
	//
	//   - Restrictions: Some restrictions
	//
	//   - Tunnel Category D
	//
	//   - Risk Level: High risk
	//
	//   - Restrictions: Many restrictions occur
	//
	//   - Tunnel Category E
	//
	//   - Risk Level: Very high risk
	//
	//   - Restrictions: Restricted tunnel
	TunnelRestrictionCode *string

	// Heaviest weight per axle irrespective of the axle type or the axle group. Meant
	// for usage in countries where the differences in axle types or axle groups are
	// not distinguished.
	//
	// Unit: Kilograms
	WeightPerAxle int64

	// Specifies the total weight for the specified axle group. Meant for usage in
	// countries that have different regulations based on the axle group type.
	//
	// Unit: Kilograms
	WeightPerAxleGroup *WeightPerAxleGroup

	// Width of the vehicle.
	//
	// Unit: centimeters
	Width int64

	noSmithyDocumentSerde
}

// The vehicle license plate.
type IsolineVehicleLicensePlate struct {

	// The last character of the License Plate.
	LastCharacter *string

	noSmithyDocumentSerde
}

// The localized string.
type LocalizedString struct {

	// The value of the localized string.
	//
	// This member is required.
	Value *string

	// A list of BCP 47 compliant language codes for the results to be rendered in.
	// The request uses the regional default as the fallback if the requested language
	// can't be provided.
	Language *string

	noSmithyDocumentSerde
}

// Geometry defined as an encoded corridor - an encoded polyline with a radius
// that defines the width of the corridor.
type PolylineCorridor struct {

	// An ordered list of positions used to plot a route on a map in a lossy
	// compression format.
	//
	// LineString and Polyline are mutually exclusive properties.
	//
	// This member is required.
	Polyline *string

	// Considers all roads within the provided radius to match the provided
	// destination to. The roads that are considered are determined by the provided
	// Strategy.
	//
	// Unit: Meters
	//
	// This member is required.
	Radius *int32

	noSmithyDocumentSerde
}

// Notices provide information around factors that may have influenced snapping in
// a manner atypical to the standard use cases.
type RoadSnapNotice struct {

	// Code corresponding to the issue.
	//
	// This member is required.
	Code RoadSnapNoticeCode

	// The notice title.
	//
	// This member is required.
	Title *string

	// TracePoint indices for which the provided notice code corresponds to.
	//
	// This member is required.
	TracePointIndexes []int32

	noSmithyDocumentSerde
}

// Interpolated geometry for the snapped route that is overlay-able onto a map.
type RoadSnapSnappedGeometry struct {

	// An ordered list of positions used to plot a route on a map.
	//
	// LineString and Polyline are mutually exclusive properties.
	LineString [][]float64

	// An ordered list of positions used to plot a route on a map in a lossy
	// compression format.
	//
	// LineString and Polyline are mutually exclusive properties.
	Polyline *string

	noSmithyDocumentSerde
}

// TracePoints snapped onto the road network.
type RoadSnapSnappedTracePoint struct {

	// Confidence value for the correctness of this point match.
	//
	// This member is required.
	Confidence *float64

	// Position of the TracePoint provided within the request, at the same index.
	//
	// This member is required.
	OriginalPosition []float64

	// Snapped position of the TracePoint provided within the request, at the same
	// index.
	//
	// This member is required.
	SnappedPosition []float64

	noSmithyDocumentSerde
}

// TracePoint indices for which the provided notice code corresponds to.
type RoadSnapTracePoint struct {

	// Position defined as [longitude, latitude] .
	//
	// This member is required.
	Position []float64

	// GPS Heading at the position.
	Heading float64

	// Speed at the specified trace point .
	//
	// Unit: KilometersPerHour
	Speed float64

	// Timestamp of the event.
	Timestamp *string

	noSmithyDocumentSerde
}

// Trailer options corresponding to the vehicle.
type RoadSnapTrailerOptions struct {

	// Number of trailers attached to the vehicle.
	//
	// Default Value: 0
	TrailerCount *int32

	noSmithyDocumentSerde
}

// Travel mode related options for the provided travel mode.
type RoadSnapTravelModeOptions struct {

	// Travel mode options when the provided travel mode is "Truck".
	Truck *RoadSnapTruckOptions

	noSmithyDocumentSerde
}

// Travel mode options when the provided travel mode is "Truck".
type RoadSnapTruckOptions struct {

	// Gross weight of the vehicle including trailers, and goods at capacity.
	//
	// Unit: Kilograms
	GrossWeight int64

	// List of Hazardous cargos contained in the vehicle.
	HazardousCargos []RoadSnapHazardousCargoType

	// Height of the vehicle.
	//
	// Unit: centimeters
	Height int64

	// Length of the vehicle.
	//
	// Unit: centimeters
	Length int64

	// Trailer options corresponding to the vehicle.
	Trailer *RoadSnapTrailerOptions

	// The tunnel restriction code.
	//
	// Tunnel categories in this list indicate the restrictions which apply to certain
	// tunnels in Great Britain. They relate to the types of dangerous goods that can
	// be transported through them.
	//
	//   - Tunnel Category B
	//
	//   - Risk Level: Limited risk
	//
	//   - Restrictions: Few restrictions
	//
	//   - Tunnel Category C
	//
	//   - Risk Level: Medium risk
	//
	//   - Restrictions: Some restrictions
	//
	//   - Tunnel Category D
	//
	//   - Risk Level: High risk
	//
	//   - Restrictions: Many restrictions occur
	//
	//   - Tunnel Category E
	//
	//   - Risk Level: Very high risk
	//
	//   - Restrictions: Restricted tunnel
	TunnelRestrictionCode *string

	// Width of the vehicle in centimenters.
	Width int64

	noSmithyDocumentSerde
}

// The route.
type Route struct {

	// A leg is a section of a route from one waypoint to the next. A leg could be of
	// type Vehicle, Pedestrian or Ferry. Legs of different types could occur together
	// within a single route. For example, a car employing the use of a Ferry will
	// contain Vehicle legs corresponding to journey on land, and Ferry legs
	// corresponding to the journey via Ferry.
	//
	// This member is required.
	Legs []RouteLeg

	// Important labels including names and route numbers that differentiate the
	// current route from the alternatives presented.
	//
	// This member is required.
	MajorRoadLabels []RouteMajorRoadLabel

	// Summarized details of the leg.
	Summary *RouteSummary

	noSmithyDocumentSerde
}

// Features that are allowed while calculating a route.
type RouteAllowOptions struct {

	// Allow Hot (High Occupancy Toll) lanes while calculating the route.
	//
	// Default value: false
	Hot *bool

	// Allow Hov (High Occupancy vehicle) lanes while calculating the route.
	//
	// Default value: false
	Hov *bool

	noSmithyDocumentSerde
}

// Areas to be avoided.
type RouteAvoidanceArea struct {

	// Geometry of the area to be avoided.
	//
	// This member is required.
	Geometry *RouteAvoidanceAreaGeometry

	// Exceptions to the provided avoidance geometry, to be included while calculating
	// the route.
	Except []RouteAvoidanceAreaGeometry

	noSmithyDocumentSerde
}

// Geometry of the area to be avoided.
type RouteAvoidanceAreaGeometry struct {

	// Geometry defined as a bounding box. The first pair represents the X and Y
	// coordinates (longitude and latitude,) of the southwest corner of the bounding
	// box; the second pair represents the X and Y coordinates (longitude and latitude)
	// of the northeast corner.
	BoundingBox []float64

	// Geometry defined as a corridor - a LineString with a radius that defines the
	// width of the corridor.
	Corridor *Corridor

	// Geometry defined as a polygon with only one linear ring.
	Polygon [][][]float64

	// Geometry defined as an encoded corridor - an encoded polyline with a radius
	// that defines the width of the corridor.
	PolylineCorridor *PolylineCorridor

	// A list of Isoline PolylinePolygon, for each isoline PolylinePolygon, it
	// contains PolylinePolygon of the first linear ring (the outer ring) and from 2nd
	// item to the last item (the inner rings). For more information on polyline
	// encoding, see [https://github.com/heremaps/flexiblepolyline/blob/master/README.md].
	//
	// [https://github.com/heremaps/flexiblepolyline/blob/master/README.md]: https://github.com/heremaps/flexiblepolyline/blob/master/README.md
	PolylinePolygon []string

	noSmithyDocumentSerde
}

// Specifies options for areas to avoid when calculating the route. This is a
// best-effort avoidance setting, meaning the router will try to honor the
// avoidance preferences but may still include restricted areas if no feasible
// alternative route exists. If avoidance options are not followed, the response
// will indicate that the avoidance criteria were violated.
type RouteAvoidanceOptions struct {

	// Areas to be avoided.
	Areas []RouteAvoidanceArea

	// Avoid car-shuttle-trains while calculating the route.
	CarShuttleTrains *bool

	// Avoid controlled access highways while calculating the route.
	ControlledAccessHighways *bool

	// Avoid dirt roads while calculating the route.
	DirtRoads *bool

	// Avoid ferries while calculating the route.
	Ferries *bool

	// Avoid roads that have seasonal closure while calculating the route.
	SeasonalClosure *bool

	// Avoids roads where the specified toll transponders are the only mode of payment.
	TollRoads *bool

	// Avoids roads where the specified toll transponders are the only mode of payment.
	TollTransponders *bool

	// Truck road type identifiers. BK1 through BK4 apply only to Sweden.
	// A2,A4,B2,B4,C,D,ET2,ET4 apply only to Mexico.
	//
	// There are currently no other supported values as of 26th April 2024.
	TruckRoadTypes []string

	// Avoid tunnels while calculating the route.
	Tunnels *bool

	// Avoid U-turns for calculation on highways and motorways.
	UTurns *bool

	// Zone categories to be avoided.
	ZoneCategories []RouteAvoidanceZoneCategory

	noSmithyDocumentSerde
}

// Zone categories to be avoided.
type RouteAvoidanceZoneCategory struct {

	// Zone category to be avoided.
	//
	// This member is required.
	Category RouteZoneCategory

	noSmithyDocumentSerde
}

// Travel mode options when the provided travel mode is Car .
type RouteCarOptions struct {

	// Engine type of the vehicle.
	EngineType RouteEngineType

	// The vehicle License Plate.
	LicensePlate *RouteVehicleLicensePlate

	// Maximum speed specified.
	//
	// Unit: KilometersPerHour
	MaxSpeed *float64

	// The number of occupants in the vehicle.
	//
	// Default Value: 1
	Occupancy *int32

	noSmithyDocumentSerde
}

// Details related to the continue highway step.
type RouteContinueHighwayStepDetails struct {

	// Name of the intersection, if applicable to the step.
	//
	// This member is required.
	Intersection []LocalizedString

	// Steering direction for the step.
	SteeringDirection RouteSteeringDirection

	// Angle of the turn.
	TurnAngle float64

	// Intensity of the turn.
	TurnIntensity RouteTurnIntensity

	noSmithyDocumentSerde
}

// Details related to the continue step.
type RouteContinueStepDetails struct {

	// Name of the intersection, if applicable to the step.
	//
	// This member is required.
	Intersection []LocalizedString

	noSmithyDocumentSerde
}

// Options related to the destination.
type RouteDestinationOptions struct {

	// Avoids actions for the provided distance. This is typically to consider for
	// users in moving vehicles who may not have sufficient time to make an action at
	// an origin or a destination.
	AvoidActionsForDistance int64

	// Avoid U-turns for calculation on highways and motorways.
	AvoidUTurns *bool

	// GPS Heading at the position.
	Heading float64

	// Options to configure matching the provided position to the road network.
	Matching *RouteMatchingOptions

	// Options to configure matching the provided position to a side of the street.
	SideOfStreet *RouteSideOfStreetOptions

	// Duration of the stop.
	//
	// Unit: seconds
	StopDuration int64

	noSmithyDocumentSerde
}

// Driver related options.
type RouteDriverOptions struct {

	// Driver work-rest schedule. Stops are added to fulfil the provided rest schedule.
	Schedule []RouteDriverScheduleInterval

	noSmithyDocumentSerde
}

// Interval of the driver work-rest schedule. Stops are added to fulfil the
// provided rest schedule.
type RouteDriverScheduleInterval struct {

	// Maximum allowed driving time before stopping to rest.
	//
	// Unit: seconds
	//
	// This member is required.
	DriveDuration int64

	// Resting time before the driver can continue driving.
	//
	// Unit: seconds
	//
	// This member is required.
	RestDuration int64

	noSmithyDocumentSerde
}

// Type of the emission.
//
// Valid values: Euro1, Euro2, Euro3, Euro4, Euro5, Euro6, EuroEev
type RouteEmissionType struct {

	// Type of the emission.
	//
	// Valid values: Euro1, Euro2, Euro3, Euro4, Euro5, Euro6, EuroEev
	//
	// This member is required.
	Type *string

	// The CO 2 emission classes.
	Co2EmissionClass *string

	noSmithyDocumentSerde
}

// Details related to the enter highway step.
type RouteEnterHighwayStepDetails struct {

	// Name of the intersection, if applicable to the step.
	//
	// This member is required.
	Intersection []LocalizedString

	// Steering direction for the step.
	SteeringDirection RouteSteeringDirection

	// Angle of the turn.
	TurnAngle float64

	// Intensity of the turn.
	TurnIntensity RouteTurnIntensity

	noSmithyDocumentSerde
}

// Specifies strict exclusion options for the route calculation. This setting
// mandates that the router will avoid any routes that include the specified
// options, rather than merely attempting to minimize them.
type RouteExclusionOptions struct {

	// List of countries to be avoided defined by two-letter or three-letter country
	// codes.
	//
	// This member is required.
	Countries []string

	noSmithyDocumentSerde
}

// Details related to the exit step.
type RouteExitStepDetails struct {

	// Name of the intersection, if applicable to the step.
	//
	// This member is required.
	Intersection []LocalizedString

	// Exit to be taken.
	RelativeExit *int32

	// Steering direction for the step.
	SteeringDirection RouteSteeringDirection

	// Angle of the turn.
	TurnAngle float64

	// Intensity of the turn.
	TurnIntensity RouteTurnIntensity

	noSmithyDocumentSerde
}

// Steps of a leg that must be performed after the travel portion of the leg.
type RouteFerryAfterTravelStep struct {

	// Duration of the step.
	//
	// Unit: seconds
	//
	// This member is required.
	Duration int64

	// Type of the step.
	//
	// This member is required.
	Type RouteFerryAfterTravelStepType

	// Brief description of the step in the requested language.
	//
	// Only available when the TravelStepType is Default.
	Instruction *string

	noSmithyDocumentSerde
}

// Details corresponding to the arrival for the leg.
type RouteFerryArrival struct {

	// The place details.
	//
	// This member is required.
	Place *RouteFerryPlace

	// The time.
	Time *string

	noSmithyDocumentSerde
}

// Steps of a leg that must be performed before the travel portion of the leg.
type RouteFerryBeforeTravelStep struct {

	// Duration of the step.
	//
	// Unit: seconds
	//
	// This member is required.
	Duration int64

	// Type of the step.
	//
	// This member is required.
	Type RouteFerryBeforeTravelStepType

	// Brief description of the step in the requested language.
	//
	// Only available when the TravelStepType is Default.
	Instruction *string

	noSmithyDocumentSerde
}

// Details corresponding to the departure for the leg.
type RouteFerryDeparture struct {

	// The place details.
	//
	// This member is required.
	Place *RouteFerryPlace

	// The time.
	Time *string

	noSmithyDocumentSerde
}

// FerryLegDetails is populated when the Leg type is Ferry, and provides
// additional information that is specific
type RouteFerryLegDetails struct {

	// Steps of a leg that must be performed after the travel portion of the leg.
	//
	// This member is required.
	AfterTravelSteps []RouteFerryAfterTravelStep

	// Details corresponding to the arrival for the leg.
	//
	// This member is required.
	Arrival *RouteFerryArrival

	// Steps of a leg that must be performed before the travel portion of the leg.
	//
	// This member is required.
	BeforeTravelSteps []RouteFerryBeforeTravelStep

	// Details corresponding to the departure for the leg.
	//
	// This member is required.
	Departure *RouteFerryDeparture

	// Notices are additional information returned that indicate issues that occurred
	// during route calculation.
	//
	// This member is required.
	Notices []RouteFerryNotice

	// Waypoints that were passed through during the leg. This includes the waypoints
	// that were configured with the PassThrough option.
	//
	// This member is required.
	PassThroughWaypoints []RoutePassThroughWaypoint

	// Spans that were computed for the requested SpanAdditionalFeatures.
	//
	// This member is required.
	Spans []RouteFerrySpan

	// Steps of a leg that must be performed before the travel portion of the leg.
	//
	// This member is required.
	TravelSteps []RouteFerryTravelStep

	// Route name of the ferry line.
	RouteName *string

	// Summarized details of the leg.
	Summary *RouteFerrySummary

	noSmithyDocumentSerde
}

// Notices are additional information returned that indicate issues that occurred
// during route calculation.
type RouteFerryNotice struct {

	// Code corresponding to the issue.
	//
	// This member is required.
	Code RouteFerryNoticeCode

	// Impact corresponding to the issue. While Low impact notices can be safely
	// ignored, High impact notices must be evaluated further to determine the impact.
	Impact RouteNoticeImpact

	noSmithyDocumentSerde
}

// Summarized details of the leg.
type RouteFerryOverviewSummary struct {

	// Distance of the step.
	//
	// This member is required.
	Distance int64

	// Duration of the step.
	//
	// Unit: seconds
	//
	// This member is required.
	Duration int64

	noSmithyDocumentSerde
}

// Position provided in the request.
type RouteFerryPlace struct {

	// Position defined as [longitude, latitude] .
	//
	// This member is required.
	Position []float64

	// The name of the place.
	Name *string

	// Position provided in the request.
	OriginalPosition []float64

	// Index of the waypoint in the request.
	WaypointIndex *int32

	noSmithyDocumentSerde
}

// Span computed for the requested SpanAdditionalFeatures.
type RouteFerrySpan struct {

	// 3 letter Country code corresponding to the Span.
	Country *string

	// Distance of the computed span. This feature doesn't split a span, but is always
	// computed on a span split by other properties.
	//
	// Unit: meters
	Distance int64

	// Duration of the computed span. This feature doesn't split a span, but is always
	// computed on a span split by other properties.
	//
	// Unit: seconds
	Duration int64

	// Offset in the leg geometry corresponding to the start of this span.
	GeometryOffset *int32

	// Provides an array of names of the ferry span in available languages.
	Names []LocalizedString

	// 2-3 letter Region code corresponding to the Span. This is either a province or
	// a state.
	Region *string

	noSmithyDocumentSerde
}

// Summarized details for the leg including travel steps only. The Distance for
// the travel only portion of the journey is the same as the Distance within the
// Overview summary.
type RouteFerrySummary struct {

	// Summarized details for the leg including before travel, travel and after travel
	// steps.
	Overview *RouteFerryOverviewSummary

	// Summarized details for the leg including travel steps only. The Distance for
	// the travel only portion of the journey is in meters
	TravelOnly *RouteFerryTravelOnlySummary

	noSmithyDocumentSerde
}

// Summarized details for the leg including travel steps only. The Distance for
// the travel only portion of the journey is the same as the Distance within the
// Overview summary.
type RouteFerryTravelOnlySummary struct {

	// Total duration in free flowing traffic, which is the best case or shortest
	// duration possible to cover the leg.
	//
	// Unit: seconds
	//
	// This member is required.
	Duration int64

	noSmithyDocumentSerde
}

// Steps of a leg that must be performed during the travel portion of the leg.
type RouteFerryTravelStep struct {

	// Duration of the step.
	//
	// Unit: seconds
	//
	// This member is required.
	Duration int64

	// Type of the step.
	//
	// This member is required.
	Type RouteFerryTravelStepType

	// Distance of the step.
	Distance int64

	// Offset in the leg geometry corresponding to the start of this step.
	GeometryOffset *int32

	// Brief description of the step in the requested language.
	//
	// Only available when the TravelStepType is Default.
	Instruction *string

	noSmithyDocumentSerde
}

// Details that are specific to a Keep step.
type RouteKeepStepDetails struct {

	// Name of the intersection, if applicable to the step.
	//
	// This member is required.
	Intersection []LocalizedString

	// Steering direction for the step.
	SteeringDirection RouteSteeringDirection

	// Angle of the turn.
	TurnAngle float64

	// Intensity of the turn.
	TurnIntensity RouteTurnIntensity

	noSmithyDocumentSerde
}

// A leg is a section of a route from one waypoint to the next. A leg could be of
// type Vehicle, Pedestrian or Ferry. Legs of different types could occur together
// within a single route. For example, a car employing the use of a Ferry will
// contain Vehicle legs corresponding to journey on land, and Ferry legs
// corresponding to the journey via Ferry.
type RouteLeg struct {

	// Geometry of the area to be avoided.
	//
	// This member is required.
	Geometry *RouteLegGeometry

	// Specifies the mode of transport when calculating a route. Used in estimating
	// the speed of travel and road compatibility.
	//
	// Default Value: Car
	//
	// This member is required.
	TravelMode RouteLegTravelMode

	// Type of the leg.
	//
	// This member is required.
	Type RouteLegType

	// FerryLegDetails is populated when the Leg type is Ferry, and provides
	// additional information that is specific
	FerryLegDetails *RouteFerryLegDetails

	// List of languages for instructions within steps in the response.
	Language *string

	// Details related to the pedestrian leg.
	PedestrianLegDetails *RoutePedestrianLegDetails

	// Details related to the vehicle leg.
	VehicleLegDetails *RouteVehicleLegDetails

	noSmithyDocumentSerde
}

// The returned Route leg geometry.
type RouteLegGeometry struct {

	// An ordered list of positions used to plot a route on a map.
	//
	// LineString and Polyline are mutually exclusive properties.
	LineString [][]float64

	// An ordered list of positions used to plot a route on a map in a lossy
	// compression format.
	//
	// LineString and Polyline are mutually exclusive properties.
	Polyline *string

	noSmithyDocumentSerde
}

// Important labels including names and route numbers that differentiate the
// current route from the alternatives presented.
type RouteMajorRoadLabel struct {

	// Name of the road (localized).
	RoadName *LocalizedString

	// Route number of the road.
	RouteNumber *RouteNumber

	noSmithyDocumentSerde
}

// Options related to route matching.
type RouteMatchingOptions struct {

	// Attempts to match the provided position to a road similar to the provided name.
	NameHint *string

	// If the distance to a highway/bridge/tunnel/sliproad is within threshold, the
	// waypoint will be snapped to the highway/bridge/tunnel/sliproad.
	//
	// Unit: meters
	OnRoadThreshold int64

	// Considers all roads within the provided radius to match the provided
	// destination to. The roads that are considered are determined by the provided
	// Strategy.
	//
	// Unit: Meters
	Radius int64

	// Strategy that defines matching of the position onto the road network. MatchAny
	// considers all roads possible, whereas MatchMostSignificantRoad matches to the
	// most significant road.
	Strategy MatchingStrategy

	noSmithyDocumentSerde
}

// Allow Options related to the route matrix.
type RouteMatrixAllowOptions struct {

	// Allow Hot (High Occupancy Toll) lanes while calculating the route.
	//
	// Default value: false
	Hot *bool

	// Allow Hov (High Occupancy vehicle) lanes while calculating the route.
	//
	// Default value: false
	Hov *bool

	noSmithyDocumentSerde
}

// Provides the circle that was used while calculating the route.
type RouteMatrixAutoCircle struct {

	// The margin provided for the calculation.
	Margin int64

	// The maximum size of the radius provided for the calculation.
	MaxRadius int64

	noSmithyDocumentSerde
}

// Area to be avoided.
type RouteMatrixAvoidanceArea struct {

	// Geometry of the area to be avoided.
	//
	// This member is required.
	Geometry *RouteMatrixAvoidanceAreaGeometry

	noSmithyDocumentSerde
}

// Geometry of the area to be avoided.
type RouteMatrixAvoidanceAreaGeometry struct {

	// Geometry defined as a bounding box. The first pair represents the X and Y
	// coordinates (longitude and latitude,) of the southwest corner of the bounding
	// box; the second pair represents the X and Y coordinates (longitude and latitude)
	// of the northeast corner.
	BoundingBox []float64

	// Geometry defined as a polygon with only one linear ring.
	Polygon [][][]float64

	// A list of Isoline PolylinePolygon, for each isoline PolylinePolygon, it
	// contains PolylinePolygon of the first linear ring (the outer ring) and from
	// second item to the last item (the inner rings). For more information on polyline
	// encoding, see [https://github.com/heremaps/flexiblepolyline/blob/master/README.md].
	//
	// [https://github.com/heremaps/flexiblepolyline/blob/master/README.md]: https://github.com/heremaps/flexiblepolyline/blob/master/README.md
	PolylinePolygon []string

	noSmithyDocumentSerde
}

// Specifies options for areas to avoid when calculating the route. This is a
// best-effort avoidance setting, meaning the router will try to honor the
// avoidance preferences but may still include restricted areas if no feasible
// alternative route exists. If avoidance options are not followed, the response
// will indicate that the avoidance criteria were violated.
type RouteMatrixAvoidanceOptions struct {

	// Areas to be avoided.
	Areas []RouteMatrixAvoidanceArea

	// Avoid car-shuttle-trains while calculating the route.
	CarShuttleTrains *bool

	// Avoid controlled access highways while calculating the route.
	ControlledAccessHighways *bool

	// Avoid dirt roads while calculating the route.
	DirtRoads *bool

	// Avoid ferries while calculating the route.
	Ferries *bool

	// Avoids roads where the specified toll transponders are the only mode of payment.
	TollRoads *bool

	// Avoids roads where the specified toll transponders are the only mode of payment.
	TollTransponders *bool

	// Truck road type identifiers. BK1 through BK4 apply only to Sweden.
	// A2,A4,B2,B4,C,D,ET2,ET4 apply only to Mexico.
	//
	// There are currently no other supported values as of 26th April 2024.
	TruckRoadTypes []string

	// Avoid tunnels while calculating the route.
	Tunnels *bool

	// Avoid U-turns for calculation on highways and motorways.
	UTurns *bool

	// Zone categories to be avoided.
	ZoneCategories []RouteMatrixAvoidanceZoneCategory

	noSmithyDocumentSerde
}

// Zone categories to be avoided.
type RouteMatrixAvoidanceZoneCategory struct {

	// Zone category to be avoided.
	Category RouteMatrixZoneCategory

	noSmithyDocumentSerde
}

// Boundary within which the matrix is to be calculated. All data, origins and
// destinations outside the boundary are considered invalid.
type RouteMatrixBoundary struct {

	// Geometry of the area to be avoided.
	Geometry *RouteMatrixBoundaryGeometry

	// No restrictions in terms of a routing boundary, and is typically used for
	// longer routes.
	Unbounded *bool

	noSmithyDocumentSerde
}

// Geometry of the routing boundary.
type RouteMatrixBoundaryGeometry struct {

	// Provides the circle that was used while calculating the route.
	AutoCircle *RouteMatrixAutoCircle

	// Geometry defined as a bounding box. The first pair represents the X and Y
	// coordinates (longitude and latitude,) of the southwest corner of the bounding
	// box; the second pair represents the X and Y coordinates (longitude and latitude)
	// of the northeast corner.
	BoundingBox []float64

	// Geometry defined as a circle. When request routing boundary was set as
	// AutoCircle , the response routing boundary will return Circle derived from the
	// AutoCircle settings.
	Circle *Circle

	// Geometry defined as a polygon with only one linear ring.
	Polygon [][][]float64

	noSmithyDocumentSerde
}

// Travel mode options when the provided travel mode is Car .
type RouteMatrixCarOptions struct {

	// The vehicle License Plate.
	LicensePlate *RouteMatrixVehicleLicensePlate

	// Maximum speed
	//
	// Unit: KilometersPerHour
	MaxSpeed *float64

	// The number of occupants in the vehicle.
	//
	// Default Value: 1
	Occupancy *int32

	noSmithyDocumentSerde
}

// The route destination.
type RouteMatrixDestination struct {

	// Position defined as [longitude, latitude] .
	//
	// This member is required.
	Position []float64

	// Destination related options.
	Options *RouteMatrixDestinationOptions

	noSmithyDocumentSerde
}

// Options related to the destination.
type RouteMatrixDestinationOptions struct {

	// Avoids actions for the provided distance. This is typically to consider for
	// users in moving vehicles who may not have sufficient time to make an action at
	// an origin or a destination.
	AvoidActionsForDistance int64

	// GPS Heading at the position.
	Heading float64

	// Options to configure matching the provided position to the road network.
	Matching *RouteMatrixMatchingOptions

	// Options to configure matching the provided position to a side of the street.
	SideOfStreet *RouteMatrixSideOfStreetOptions

	noSmithyDocumentSerde
}

// The calculated route matrix containing the results for all pairs of Origins to
// Destination positions. Each row corresponds to one entry in Origins. Each entry
// in the row corresponds to the route from that entry in Origins to an entry in
// Destination positions.
type RouteMatrixEntry struct {

	// The total distance of travel for the route.
	//
	// This member is required.
	Distance int64

	// The expected duration of travel for the route.
	//
	// Unit: seconds
	//
	// This member is required.
	Duration int64

	// Error code that occurred during calculation of the route.
	Error RouteMatrixErrorCode

	noSmithyDocumentSerde
}

// Specifies strict exclusion options for the route calculation. This setting
// mandates that the router will avoid any routes that include the specified
// options, rather than merely attempting to minimize them.
type RouteMatrixExclusionOptions struct {

	// List of countries to be avoided defined by two-letter or three-letter country
	// codes.
	//
	// This member is required.
	Countries []string

	noSmithyDocumentSerde
}

// Matching options.
type RouteMatrixMatchingOptions struct {

	// Attempts to match the provided position to a road similar to the provided name.
	NameHint *string

	// If the distance to a highway/bridge/tunnel/sliproad is within threshold, the
	// waypoint will be snapped to the highway/bridge/tunnel/sliproad.
	//
	// Unit: meters
	OnRoadThreshold int64

	// Considers all roads within the provided radius to match the provided
	// destination to. The roads that are considered are determined by the provided
	// Strategy.
	//
	// Unit: Meters
	Radius int64

	// Strategy that defines matching of the position onto the road network. MatchAny
	// considers all roads possible, whereas MatchMostSignificantRoad matches to the
	// most significant road.
	Strategy MatchingStrategy

	noSmithyDocumentSerde
}

// The start position for the route.
type RouteMatrixOrigin struct {

	// Position defined as [longitude, latitude] .
	//
	// This member is required.
	Position []float64

	// Origin related options.
	Options *RouteMatrixOriginOptions

	noSmithyDocumentSerde
}

// Origin related options.
type RouteMatrixOriginOptions struct {

	// Avoids actions for the provided distance. This is typically to consider for
	// users in moving vehicles who may not have sufficient time to make an action at
	// an origin or a destination.
	AvoidActionsForDistance int64

	// GPS Heading at the position.
	Heading float64

	// Options to configure matching the provided position to the road network.
	Matching *RouteMatrixMatchingOptions

	// Options to configure matching the provided position to a side of the street.
	SideOfStreet *RouteMatrixSideOfStreetOptions

	noSmithyDocumentSerde
}

// Travel mode options when the provided travel mode is Scooter
type RouteMatrixScooterOptions struct {

	// The vehicle License Plate.
	LicensePlate *RouteMatrixVehicleLicensePlate

	// Maximum speed.
	//
	// Unit: KilometersPerHour
	MaxSpeed *float64

	// The number of occupants in the vehicle.
	//
	// Default Value: 1
	Occupancy *int32

	noSmithyDocumentSerde
}

// Options to configure matching the provided position to a side of the street.
type RouteMatrixSideOfStreetOptions struct {

	// Position defined as [longitude, latitude] .
	//
	// This member is required.
	Position []float64

	// Strategy that defines when the side of street position should be used.
	// AnyStreet will always use the provided position.
	//
	// Default Value: DividedStreetOnly
	UseWith SideOfStreetMatchingStrategy

	noSmithyDocumentSerde
}

// Traffic related options.
type RouteMatrixTrafficOptions struct {

	// Duration for which flow traffic is considered valid. For this period, the flow
	// traffic is used over historical traffic data. Flow traffic refers to congestion,
	// which changes very quickly. Duration in seconds for which flow traffic event
	// would be considered valid. While flow traffic event is valid it will be used
	// over the historical traffic data.
	FlowEventThresholdOverride int64

	// Determines if traffic should be used or ignored while calculating the route.
	//
	// Default Value: UseTrafficData
	Usage TrafficUsage

	noSmithyDocumentSerde
}

// Trailer options corresponding to the vehicle.
type RouteMatrixTrailerOptions struct {

	// Number of trailers attached to the vehicle.
	//
	// Default Value: 0
	TrailerCount *int32

	noSmithyDocumentSerde
}

// Travel mode related options for the provided travel mode.
type RouteMatrixTravelModeOptions struct {

	// Travel mode options when the provided travel mode is "Car"
	Car *RouteMatrixCarOptions

	// Travel mode options when the provided travel mode is Scooter
	//
	// When travel mode is set to Scooter , then the avoidance option
	// ControlledAccessHighways defaults to true .
	Scooter *RouteMatrixScooterOptions

	// Travel mode options when the provided travel mode is "Truck"
	Truck *RouteMatrixTruckOptions

	noSmithyDocumentSerde
}

// Travel mode options when the provided travel mode is "Truck"
type RouteMatrixTruckOptions struct {

	// Total number of axles of the vehicle.
	AxleCount *int32

	// Gross weight of the vehicle including trailers, and goods at capacity.
	//
	// Unit: Kilograms
	GrossWeight int64

	// List of Hazardous cargo contained in the vehicle.
	HazardousCargos []RouteMatrixHazardousCargoType

	// Height of the vehicle.
	//
	// Unit: centimeters
	Height int64

	// Kingpin to rear axle length of the vehicle
	//
	// Unit: centimeters
	KpraLength int64

	// Length of the vehicle.
	//
	// Unit: centimeters
	Length int64

	// The vehicle License Plate.
	LicensePlate *RouteMatrixVehicleLicensePlate

	// Maximum speed
	//
	// Unit: KilometersPerHour
	MaxSpeed *float64

	// The number of occupants in the vehicle.
	//
	// Default Value: 1
	Occupancy *int32

	// Payload capacity of the vehicle and trailers attached.
	//
	// Unit: kilograms
	PayloadCapacity int64

	// Trailer options corresponding to the vehicle.
	Trailer *RouteMatrixTrailerOptions

	// Type of the truck.
	TruckType RouteMatrixTruckType

	// The tunnel restriction code.
	//
	// Tunnel categories in this list indicate the restrictions which apply to certain
	// tunnels in Great Britain. They relate to the types of dangerous goods that can
	// be transported through them.
	//
	//   - Tunnel Category B
	//
	//   - Risk Level: Limited risk
	//
	//   - Restrictions: Few restrictions
	//
	//   - Tunnel Category C
	//
	//   - Risk Level: Medium risk
	//
	//   - Restrictions: Some restrictions
	//
	//   - Tunnel Category D
	//
	//   - Risk Level: High risk
	//
	//   - Restrictions: Many restrictions occur
	//
	//   - Tunnel Category E
	//
	//   - Risk Level: Very high risk
	//
	//   - Restrictions: Restricted tunnel
	TunnelRestrictionCode *string

	// Heaviest weight per axle irrespective of the axle type or the axle group. Meant
	// for usage in countries where the differences in axle types or axle groups are
	// not distinguished.
	//
	// Unit: Kilograms
	WeightPerAxle int64

	// Specifies the total weight for the specified axle group. Meant for usage in
	// countries that have different regulations based on the axle group type.
	WeightPerAxleGroup *WeightPerAxleGroup

	// Width of the vehicle.
	//
	// Unit: centimeters
	Width int64

	noSmithyDocumentSerde
}

// The vehicle License Plate.
type RouteMatrixVehicleLicensePlate struct {

	// The last character of the License Plate.
	LastCharacter *string

	noSmithyDocumentSerde
}

// Notice Detail that is a range.
type RouteNoticeDetailRange struct {

	// Maximum value for the range.
	Max *int32

	// Minimum value for the range.
	Min *int32

	noSmithyDocumentSerde
}

// The route number.
type RouteNumber struct {

	// The route number.
	//
	// This member is required.
	Value *string

	// Directional identifier of the route.
	Direction RouteDirection

	// List of languages for instructions corresponding to the route number.
	Language *string

	noSmithyDocumentSerde
}

// Origin related options.
type RouteOriginOptions struct {

	// Avoids actions for the provided distance. This is typically to consider for
	// users in moving vehicles who may not have sufficient time to make an action at
	// an origin or a destination.
	AvoidActionsForDistance int64

	// Avoid U-turns for calculation on highways and motorways.
	AvoidUTurns *bool

	// GPS Heading at the position.
	Heading float64

	// Options to configure matching the provided position to the road network.
	Matching *RouteMatchingOptions

	// Options to configure matching the provided position to a side of the street.
	SideOfStreet *RouteSideOfStreetOptions

	noSmithyDocumentSerde
}

// The place where the waypoint is passed through and not treated as a stop.
type RoutePassThroughPlace struct {

	// Position defined as [longitude, latitude] .
	//
	// This member is required.
	Position []float64

	// Position provided in the request.
	OriginalPosition []float64

	// Index of the waypoint in the request.
	WaypointIndex *int32

	noSmithyDocumentSerde
}

// If the waypoint should be treated as a stop. If yes, the route is split up into
// different legs around the stop.
type RoutePassThroughWaypoint struct {

	// The place details.
	//
	// This member is required.
	Place *RoutePassThroughPlace

	// Offset in the leg geometry corresponding to the start of this step.
	GeometryOffset *int32

	noSmithyDocumentSerde
}

// Details corresponding to the arrival for a leg.
//
// Time format: YYYY-MM-DDThh:mm:ss.sssZ | YYYY-MM-DDThh:mm:ss.sss+hh:mm
//
// Examples:
//
//	2020-04-22T17:57:24Z
//
//	2020-04-22T17:57:24+02:00
type RoutePedestrianArrival struct {

	// The place details.
	//
	// This member is required.
	Place *RoutePedestrianPlace

	// The time.
	Time *string

	noSmithyDocumentSerde
}

// Details corresponding to the departure for a leg.
//
// Time format: YYYY-MM-DDThh:mm:ss.sssZ | YYYY-MM-DDThh:mm:ss.sss+hh:mm
//
// Examples:
//
//	2020-04-22T17:57:24Z
//
//	2020-04-22T17:57:24+02:00
type RoutePedestrianDeparture struct {

	// The place details.
	//
	// This member is required.
	Place *RoutePedestrianPlace

	// The time.
	Time *string

	noSmithyDocumentSerde
}

// Details that are specific to a pedestrian leg.
type RoutePedestrianLegDetails struct {

	// Details corresponding to the arrival for the leg.
	//
	// This member is required.
	Arrival *RoutePedestrianArrival

	// Details corresponding to the departure for the leg.
	//
	// This member is required.
	Departure *RoutePedestrianDeparture

	// Notices are additional information returned that indicate issues that occurred
	// during route calculation.
	//
	// This member is required.
	Notices []RoutePedestrianNotice

	// Waypoints that were passed through during the leg. This includes the waypoints
	// that were configured with the PassThrough option.
	//
	// This member is required.
	PassThroughWaypoints []RoutePassThroughWaypoint

	// Spans that were computed for the requested SpanAdditionalFeatures.
	//
	// This member is required.
	Spans []RoutePedestrianSpan

	// Steps of a leg that must be performed before the travel portion of the leg.
	//
	// This member is required.
	TravelSteps []RoutePedestrianTravelStep

	// Summarized details of the leg.
	Summary *RoutePedestrianSummary

	noSmithyDocumentSerde
}

// Notices are additional information returned that indicate issues that occurred
// during route calculation.
type RoutePedestrianNotice struct {

	// Code corresponding to the issue.
	//
	// This member is required.
	Code RoutePedestrianNoticeCode

	// Impact corresponding to the issue. While Low impact notices can be safely
	// ignored, High impact notices must be evaluated further to determine the impact.
	Impact RouteNoticeImpact

	noSmithyDocumentSerde
}

// Options related to the pedestrian.
type RoutePedestrianOptions struct {

	// Walking speed in Kilometers per hour.
	Speed *float64

	noSmithyDocumentSerde
}

// Provides a summary of a pedestrian route step.
type RoutePedestrianOverviewSummary struct {

	// Distance of the step.
	//
	// This member is required.
	Distance int64

	// Duration of the step.
	//
	// This member is required.
	Duration int64

	noSmithyDocumentSerde
}

// Place details corresponding to the arrival or departure.
type RoutePedestrianPlace struct {

	// Position defined as [longitude, latitude] .
	//
	// This member is required.
	Position []float64

	// The name of the place.
	Name *string

	// Position provided in the request.
	OriginalPosition []float64

	// Options to configure matching the provided position to a side of the street.
	SideOfStreet RouteSideOfStreet

	// Index of the waypoint in the request.
	WaypointIndex *int32

	noSmithyDocumentSerde
}

// Span computed for the requested SpanAdditionalFeatures.
type RoutePedestrianSpan struct {

	// Duration of the computed span without traffic congestion.
	//
	// Unit: seconds
	BestCaseDuration int64

	// 3 letter Country code corresponding to the Span.
	Country *string

	// Distance of the computed span. This feature doesn't split a span, but is always
	// computed on a span split by other properties.
	Distance int64

	// Duration of the computed span. This feature doesn't split a span, but is always
	// computed on a span split by other properties.
	//
	// Unit: seconds
	Duration int64

	// Dynamic speed details corresponding to the span.
	//
	// Unit: KilometersPerHour
	DynamicSpeed *RouteSpanDynamicSpeedDetails

	// Functional classification of the road segment corresponding to the span.
	FunctionalClassification *int32

	// Offset in the leg geometry corresponding to the start of this span.
	GeometryOffset *int32

	// Incidents corresponding to the span. These index into the Incidents in the
	// parent Leg.
	Incidents []int32

	// Provides an array of names of the pedestrian span in available languages.
	Names []LocalizedString

	// Access attributes for a pedestrian corresponding to the span.
	PedestrianAccess []RouteSpanPedestrianAccessAttribute

	// 2-3 letter Region code corresponding to the Span. This is either a province or
	// a state.
	Region *string

	// Attributes for the road segment corresponding to the span.
	RoadAttributes []RouteSpanRoadAttribute

	// Designated route name or number corresponding to the span.
	RouteNumbers []RouteNumber

	// Speed limit details corresponding to the span.
	//
	// Unit: KilometersPerHour
	SpeedLimit *RouteSpanSpeedLimitDetails

	// Duration of the computed span under typical traffic congestion.
	//
	// Unit: seconds
	TypicalDuration int64

	noSmithyDocumentSerde
}

// Summarized details for the leg including before travel, travel and after travel
// steps.
type RoutePedestrianSummary struct {

	// Summarized details for the leg including before travel, travel and after travel
	// steps.
	Overview *RoutePedestrianOverviewSummary

	// Summarized details for the leg including travel steps only. The Distance for
	// the travel only portion of the journey is in meters
	TravelOnly *RoutePedestrianTravelOnlySummary

	noSmithyDocumentSerde
}

// Summarized details for the leg including travel steps.
type RoutePedestrianTravelOnlySummary struct {

	// Duration of the step.
	//
	// Unit: seconds
	//
	// This member is required.
	Duration int64

	noSmithyDocumentSerde
}

// Steps of a leg that must be performed during the travel portion of the leg.
type RoutePedestrianTravelStep struct {

	// Duration of the step.
	//
	// Unit: seconds
	//
	// This member is required.
	Duration int64

	// Type of the step.
	//
	// This member is required.
	Type RoutePedestrianTravelStepType

	// Details related to the continue step.
	ContinueStepDetails *RouteContinueStepDetails

	// Details of the current road. See RouteRoad for details of sub-attributes.
	CurrentRoad *RouteRoad

	// Distance of the step.
	Distance int64

	// Exit number of the road exit, if applicable.
	ExitNumber []LocalizedString

	// Offset in the leg geometry corresponding to the start of this step.
	GeometryOffset *int32

	// Brief description of the step in the requested language.
	//
	// Only available when the TravelStepType is Default.
	Instruction *string

	// Details that are specific to a Keep step.
	KeepStepDetails *RouteKeepStepDetails

	// Details of the next road. See RouteRoad for details of sub-attributes.
	NextRoad *RouteRoad

	// Details that are specific to a Roundabout Enter step.
	RoundaboutEnterStepDetails *RouteRoundaboutEnterStepDetails

	// Details that are specific to a Roundabout Exit step.
	RoundaboutExitStepDetails *RouteRoundaboutExitStepDetails

	// Details that are specific to a Roundabout Pass step.
	RoundaboutPassStepDetails *RouteRoundaboutPassStepDetails

	// Sign post information of the action, applicable only for TurnByTurn steps. See
	// RouteSignpost for details of sub-attributes.
	Signpost *RouteSignpost

	// Details that are specific to a turn step.
	TurnStepDetails *RouteTurnStepDetails

	noSmithyDocumentSerde
}

// Details that are specific to a ramp step.
type RouteRampStepDetails struct {

	// Name of the intersection, if applicable to the step.
	//
	// This member is required.
	Intersection []LocalizedString

	// Steering direction for the step.
	SteeringDirection RouteSteeringDirection

	// Angle of the turn.
	TurnAngle float64

	// Intensity of the turn.
	TurnIntensity RouteTurnIntensity

	noSmithyDocumentSerde
}

// Notices are additional information returned that indicate issues that occurred
// during route calculation.
type RouteResponseNotice struct {

	// Code corresponding to the issue.
	//
	// This member is required.
	Code RouteResponseNoticeCode

	// Impact corresponding to the issue. While Low impact notices can be safely
	// ignored, High impact notices must be evaluated further to determine the impact.
	Impact RouteNoticeImpact

	noSmithyDocumentSerde
}

// The road on the route.
type RouteRoad struct {

	// Name of the road (localized).
	//
	// This member is required.
	RoadName []LocalizedString

	// Route number of the road.
	//
	// This member is required.
	RouteNumber []RouteNumber

	// Names of destinations that can be reached when traveling on the road.
	//
	// This member is required.
	Towards []LocalizedString

	// The type of road.
	Type RouteRoadType

	noSmithyDocumentSerde
}

// Details about the roundabout leg.
type RouteRoundaboutEnterStepDetails struct {

	// Name of the intersection, if applicable to the step.
	//
	// This member is required.
	Intersection []LocalizedString

	// Steering direction for the step.
	SteeringDirection RouteSteeringDirection

	// Angle of the turn.
	TurnAngle float64

	// Intensity of the turn.
	TurnIntensity RouteTurnIntensity

	noSmithyDocumentSerde
}

// Details about the roundabout step.
type RouteRoundaboutExitStepDetails struct {

	// Name of the intersection, if applicable to the step.
	//
	// This member is required.
	Intersection []LocalizedString

	// Exit to be taken.
	RelativeExit *int32

	// Angle of the roundabout.
	RoundaboutAngle float64

	// Steering direction for the step.
	SteeringDirection RouteSteeringDirection

	noSmithyDocumentSerde
}

// Details about the step.
type RouteRoundaboutPassStepDetails struct {

	// Name of the intersection, if applicable to the step.
	//
	// This member is required.
	Intersection []LocalizedString

	// Steering direction for the step.
	SteeringDirection RouteSteeringDirection

	// Angle of the turn.
	TurnAngle float64

	// Intensity of the turn.
	TurnIntensity RouteTurnIntensity

	noSmithyDocumentSerde
}

// Travel mode options when the provided travel mode is Scooter
type RouteScooterOptions struct {

	// Engine type of the vehicle.
	EngineType RouteEngineType

	// The vehicle License Plate.
	LicensePlate *RouteVehicleLicensePlate

	// Maximum speed
	//
	// Unit: KilometersPerHour
	MaxSpeed *float64

	// The number of occupants in the vehicle.
	//
	// Default Value: 1
	Occupancy *int32

	noSmithyDocumentSerde
}

// Options to configure matching the provided position to a side of the street.
type RouteSideOfStreetOptions struct {

	// Position defined as [longitude, latitude] .
	//
	// This member is required.
	Position []float64

	// Strategy that defines when the side of street position should be used.
	//
	// Default Value: DividedStreetOnly
	UseWith SideOfStreetMatchingStrategy

	noSmithyDocumentSerde
}

// Sign post information of the action, applicable only for TurnByTurn steps. See
// RouteSignpost for details of sub-attributes.
type RouteSignpost struct {

	// Labels present on the sign post.
	//
	// This member is required.
	Labels []RouteSignpostLabel

	noSmithyDocumentSerde
}

// Labels presented on the sign post.
type RouteSignpostLabel struct {

	// Route number of the road.
	RouteNumber *RouteNumber

	// The Signpost text.
	Text *LocalizedString

	noSmithyDocumentSerde
}

// Details about the dynamic speed.
//
// Unit: KilometersPerHour
type RouteSpanDynamicSpeedDetails struct {

	// Estimated speed while traversing the span without traffic congestion.
	//
	// Unit: KilometersPerHour
	BestCaseSpeed float64

	// Estimated time to turn from this span into the next.
	//
	// Unit: seconds
	TurnDuration int64

	// Estimated speed while traversing the span under typical traffic congestion.
	//
	// Unit: KilometersPerHour
	TypicalSpeed float64

	noSmithyDocumentSerde
}

// Details about the speed limit corresponding to the span.
//
// Unit: KilometersPerHour
type RouteSpanSpeedLimitDetails struct {

	// Maximum speed.
	//
	// Unit: KilometersPerHour
	MaxSpeed float64

	// If the span doesn't have a speed limit like the Autobahn.
	Unlimited *bool

	noSmithyDocumentSerde
}

// Summarized details for the leg including travel steps only. The Distance for
// the travel only portion of the journey is the same as the Distance within the
// Overview summary.
type RouteSummary struct {

	// Distance of the route.
	Distance int64

	// Duration of the route.
	//
	// Unit: seconds
	Duration int64

	// Toll summary for the complete route.
	Tolls *RouteTollSummary

	noSmithyDocumentSerde
}

// Provides details about toll information along a route, including the payment
// sites, applicable toll rates, toll systems, and the country associated with the
// toll collection.
type RouteToll struct {

	// Locations or sites where the toll fare is collected.
	//
	// This member is required.
	PaymentSites []RouteTollPaymentSite

	// Toll rates that need to be paid to travel this leg of the route.
	//
	// This member is required.
	Rates []RouteTollRate

	// Toll systems are authorities that collect payments for the toll.
	//
	// This member is required.
	Systems []int32

	// The alpha-2 or alpha-3 character code for the country.
	Country *string

	noSmithyDocumentSerde
}

// Options related to Tolls on a route.
type RouteTollOptions struct {

	// Specifies if the user has valid transponder with access to all toll systems.
	// This impacts toll calculation, and if true the price with transponders is used.
	AllTransponders *bool

	// Specifies if the user has valid vignettes with access for all toll roads. If a
	// user has a vignette for a toll road, then toll cost for that road is omitted
	// since no further payment is necessary.
	AllVignettes *bool

	// Currency code corresponding to the price. This is the same as Currency
	// specified in the request.
	Currency *string

	// Emission type of the vehicle for toll cost calculation.
	//
	// Valid values: Euro1, Euro2, Euro3, Euro4, Euro5, Euro6, EuroEev
	EmissionType *RouteEmissionType

	// Vehicle category for toll cost calculation.
	VehicleCategory RouteTollVehicleCategory

	noSmithyDocumentSerde
}

// Details if the toll rate can be a pass that supports multiple trips.
type RouteTollPass struct {

	// If the pass includes the rate for the return leg of the trip.
	IncludesReturnTrip *bool

	// If the pass is only valid for senior persons.
	SeniorPass *bool

	// If the toll pass can be transferred, and how many times.
	TransferCount *int32

	// Number of trips the pass is valid for.
	TripCount *int32

	// Period for which the pass is valid.
	ValidityPeriod *RouteTollPassValidityPeriod

	noSmithyDocumentSerde
}

// Period for which the pass is valid.
type RouteTollPassValidityPeriod struct {

	// Validity period.
	//
	// This member is required.
	Period RouteTollPassValidityPeriodType

	// Counts for the validity period.
	PeriodCount *int32

	noSmithyDocumentSerde
}

// Locations or sites where the toll fare is collected.
type RouteTollPaymentSite struct {

	// Position defined as [longitude, latitude] .
	//
	// This member is required.
	Position []float64

	// Name of the payment site.
	Name *string

	noSmithyDocumentSerde
}

// The toll price.
type RouteTollPrice struct {

	// Currency code corresponding to the price. This is the same as Currency
	// specified in the request.
	//
	// This member is required.
	Currency *string

	// If the price is an estimate or an exact value.
	//
	// This member is required.
	Estimate *bool

	// If the price is a range or an exact value. If any of the toll fares making up
	// the route is a range, the overall price is also a range.
	//
	// This member is required.
	Range *bool

	// Exact price, if not a range.
	//
	// This member is required.
	Value *float64

	// Duration for which the price corresponds to.
	//
	// Unit: seconds
	PerDuration int64

	// Price range with a minimum and maximum value, if a range.
	RangeValue *RouteTollPriceValueRange

	noSmithyDocumentSerde
}

// Summary of the route and toll price.
type RouteTollPriceSummary struct {

	// Currency code corresponding to the price. This is the same as Currency
	// specified in the request.
	//
	// This member is required.
	Currency *string

	// If the price is an estimate or an exact value.
	//
	// This member is required.
	Estimate *bool

	// If the price is a range or an exact value. If any of the toll fares making up
	// the route is a range, the overall price is also a range.
	//
	// This member is required.
	Range *bool

	// Exact price, if not a range.
	//
	// This member is required.
	Value *float64

	// Price range with a minimum and maximum value, if a range.
	RangeValue *RouteTollPriceValueRange

	noSmithyDocumentSerde
}

// Price range with a minimum and maximum value, if a range.
type RouteTollPriceValueRange struct {

	// Maximum price.
	//
	// This member is required.
	Max *float64

	// Minimum price.
	//
	// This member is required.
	Min *float64

	noSmithyDocumentSerde
}

// The toll rate.
type RouteTollRate struct {

	// The Toll rate Id.
	//
	// This member is required.
	Id *string

	// Price in the local regional currency.
	//
	// This member is required.
	LocalPrice *RouteTollPrice

	// The name of the toll.
	//
	// This member is required.
	Name *string

	// Accepted payment methods at the toll.
	//
	// This member is required.
	PaymentMethods []RouteTollPaymentMethod

	// Transponders for which this toll can be applied.
	//
	// This member is required.
	Transponders []RouteTransponder

	// Time when the rate is valid.
	ApplicableTimes *string

	// Price in the converted currency as specified in the request.
	ConvertedPrice *RouteTollPrice

	// Details if the toll rate can be a pass that supports multiple trips.
	Pass *RouteTollPass

	noSmithyDocumentSerde
}

// The toll summary for the complete route.
type RouteTollSummary struct {

	// Total toll summary for the complete route. Total is the only summary available
	// today.
	Total *RouteTollPriceSummary

	noSmithyDocumentSerde
}

// Toll systems are authorities that collect payments for the toll.
type RouteTollSystem struct {

	// The toll system name.
	Name *string

	noSmithyDocumentSerde
}

// Traffic options for the route.
type RouteTrafficOptions struct {

	// Duration for which flow traffic is considered valid. For this period, the flow
	// traffic is used over historical traffic data. Flow traffic refers to congestion,
	// which changes very quickly. Duration in seconds for which flow traffic event
	// would be considered valid. While flow traffic event is valid it will be used
	// over the historical traffic data.
	FlowEventThresholdOverride int64

	// Determines if traffic should be used or ignored while calculating the route.
	//
	// Default Value: UseTrafficData
	Usage TrafficUsage

	noSmithyDocumentSerde
}

// Trailer options corresponding to the vehicle.
type RouteTrailerOptions struct {

	// Total number of axles of the vehicle.
	AxleCount *int32

	// Number of trailers attached to the vehicle.
	//
	// Default Value: 0
	TrailerCount *int32

	noSmithyDocumentSerde
}

// Transponders for which this toll can be applied.
type RouteTransponder struct {

	// Names of the toll system collecting the toll.
	SystemName *string

	noSmithyDocumentSerde
}

// Travel mode related options for the provided travel mode.
type RouteTravelModeOptions struct {

	// Travel mode options when the provided travel mode is "Car"
	Car *RouteCarOptions

	// Travel mode options when the provided travel mode is "Pedestrian"
	Pedestrian *RoutePedestrianOptions

	// Travel mode options when the provided travel mode is Scooter
	//
	// When travel mode is set to Scooter , then the avoidance option
	// ControlledAccessHighways defaults to true .
	Scooter *RouteScooterOptions

	// Travel mode options when the provided travel mode is "Truck"
	Truck *RouteTruckOptions

	noSmithyDocumentSerde
}

// Travel mode options when the provided travel mode is "Truck"
type RouteTruckOptions struct {

	// Total number of axles of the vehicle.
	AxleCount *int32

	// Engine type of the vehicle.
	EngineType RouteEngineType

	// Gross weight of the vehicle including trailers, and goods at capacity.
	//
	// Unit: Kilograms
	GrossWeight int64

	// List of Hazardous cargo contained in the vehicle.
	HazardousCargos []RouteHazardousCargoType

	// Height of the vehicle.
	//
	// Unit: centimeters
	Height int64

	// Height of the vehicle above its first axle.
	//
	// Unit: centimeters
	HeightAboveFirstAxle int64

	// Kingpin to rear axle length of the vehicle.
	//
	// Unit: centimeters
	KpraLength int64

	// Length of the vehicle.
	//
	// Unit: c
	Length int64

	// The vehicle License Plate.
	LicensePlate *RouteVehicleLicensePlate

	// Maximum speed
	//
	// Unit: KilometersPerHour
	MaxSpeed *float64

	// The number of occupants in the vehicle.
	//
	// Default Value: 1
	Occupancy *int32

	// Payload capacity of the vehicle and trailers attached.
	//
	// Unit: kilograms
	PayloadCapacity int64

	// Number of tires on the vehicle.
	TireCount *int32

	// Trailer options corresponding to the vehicle.
	Trailer *RouteTrailerOptions

	// Type of the truck.
	TruckType RouteTruckType

	// The tunnel restriction code.
	//
	// Tunnel categories in this list indicate the restrictions which apply to certain
	// tunnels in Great Britain. They relate to the types of dangerous goods that can
	// be transported through them.
	//
	//   - Tunnel Category B
	//
	//   - Risk Level: Limited risk
	//
	//   - Restrictions: Few restrictions
	//
	//   - Tunnel Category C
	//
	//   - Risk Level: Medium risk
	//
	//   - Restrictions: Some restrictions
	//
	//   - Tunnel Category D
	//
	//   - Risk Level: High risk
	//
	//   - Restrictions: Many restrictions occur
	//
	//   - Tunnel Category E
	//
	//   - Risk Level: Very high risk
	//
	//   - Restrictions: Restricted tunnel
	TunnelRestrictionCode *string

	// Heaviest weight per axle irrespective of the axle type or the axle group. Meant
	// for usage in countries where the differences in axle types or axle groups are
	// not distinguished.
	//
	// Unit: Kilograms
	WeightPerAxle int64

	// Specifies the total weight for the specified axle group. Meant for usage in
	// countries that have different regulations based on the axle group type.
	//
	// Unit: Kilograms
	WeightPerAxleGroup *WeightPerAxleGroup

	// Width of the vehicle.
	//
	// Unit: centimeters
	Width int64

	noSmithyDocumentSerde
}

// Details related to the turn step.
type RouteTurnStepDetails struct {

	// Name of the intersection, if applicable to the step.
	//
	// This member is required.
	Intersection []LocalizedString

	// Steering direction for the step.
	SteeringDirection RouteSteeringDirection

	// Angle of the turn.
	TurnAngle float64

	// Intensity of the turn.
	TurnIntensity RouteTurnIntensity

	noSmithyDocumentSerde
}

// Details related to the U-turn step.
type RouteUTurnStepDetails struct {

	// Name of the intersection, if applicable to the step.
	//
	// This member is required.
	Intersection []LocalizedString

	// Steering direction for the step.
	SteeringDirection RouteSteeringDirection

	// Angle of the turn.
	TurnAngle float64

	// Intensity of the turn.
	TurnIntensity RouteTurnIntensity

	noSmithyDocumentSerde
}

// Details corresponding to the arrival for a leg.
type RouteVehicleArrival struct {

	// The place details.
	//
	// This member is required.
	Place *RouteVehiclePlace

	// The time.
	Time *string

	noSmithyDocumentSerde
}

// Details corresponding to the departure for the leg.
type RouteVehicleDeparture struct {

	// The place details.
	//
	// This member is required.
	Place *RouteVehiclePlace

	// The departure time.
	Time *string

	noSmithyDocumentSerde
}

// Incidents corresponding to this leg of the route.
type RouteVehicleIncident struct {

	// Brief readable description of the incident.
	Description *string

	// End timestamp of the incident.
	EndTime *string

	// Severity of the incident Critical - The part of the route the incident affects
	// is unusable. Major- Major impact on the leg duration, for example stop and go
	// Minor- Minor impact on the leg duration, for example traffic jam Low - Low on
	// duration, for example slightly increased traffic
	Severity RouteVehicleIncidentSeverity

	// Start time of the incident.
	StartTime *string

	// Type of the incident.
	Type RouteVehicleIncidentType

	noSmithyDocumentSerde
}

// Steps of a leg that correspond to the travel portion of the leg.
type RouteVehicleLegDetails struct {

	// Details corresponding to the arrival for the leg.
	//
	// This member is required.
	Arrival *RouteVehicleArrival

	// Details corresponding to the departure for the leg.
	//
	// This member is required.
	Departure *RouteVehicleDeparture

	// Incidents corresponding to this leg of the route.
	//
	// This member is required.
	Incidents []RouteVehicleIncident

	// Notices are additional information returned that indicate issues that occurred
	// during route calculation.
	//
	// This member is required.
	Notices []RouteVehicleNotice

	// Waypoints that were passed through during the leg. This includes the waypoints
	// that were configured with the PassThrough option.
	//
	// This member is required.
	PassThroughWaypoints []RoutePassThroughWaypoint

	// Spans that were computed for the requested SpanAdditionalFeatures.
	//
	// This member is required.
	Spans []RouteVehicleSpan

	// Toll systems are authorities that collect payments for the toll.
	//
	// This member is required.
	TollSystems []RouteTollSystem

	// Toll related options.
	//
	// This member is required.
	Tolls []RouteToll

	// Steps of a leg that must be performed before the travel portion of the leg.
	//
	// This member is required.
	TravelSteps []RouteVehicleTravelStep

	// Truck road type identifiers. BK1 through BK4 apply only to Sweden.
	// A2,A4,B2,B4,C,D,ET2,ET4 apply only to Mexico.
	//
	// There are currently no other supported values as of 26th April 2024.
	//
	// This member is required.
	TruckRoadTypes []string

	// Zones corresponding to this leg of the route.
	//
	// This member is required.
	Zones []RouteZone

	// Summarized details of the leg.
	Summary *RouteVehicleSummary

	noSmithyDocumentSerde
}

// License plate information of the vehicle. Currently, only the last character is
// used where license plate based controlled access is enforced.
type RouteVehicleLicensePlate struct {

	// The last character of the License Plate.
	LastCharacter *string

	noSmithyDocumentSerde
}

// Notices are additional information returned that indicate issues that occurred
// during route calculation.
type RouteVehicleNotice struct {

	// Code corresponding to the issue.
	//
	// This member is required.
	Code RouteVehicleNoticeCode

	// Additional details of the notice.
	//
	// This member is required.
	Details []RouteVehicleNoticeDetail

	// Impact corresponding to the issue. While Low impact notices can be safely
	// ignored, High impact notices must be evaluated further to determine the impact.
	Impact RouteNoticeImpact

	noSmithyDocumentSerde
}

// Additional details of the notice.
type RouteVehicleNoticeDetail struct {

	// The notice title.
	Title *string

	// Any violated constraints.
	ViolatedConstraints *RouteViolatedConstraints

	noSmithyDocumentSerde
}

// Summarized details of the leg.
type RouteVehicleOverviewSummary struct {

	// Distance of the step.
	//
	// This member is required.
	Distance int64

	// Duration of the step.
	//
	// Unit: seconds
	//
	// This member is required.
	Duration int64

	// Total duration in free flowing traffic, which is the best case or shortest
	// duration possible to cover the leg.
	//
	// Unit: seconds
	BestCaseDuration int64

	// Duration of the computed span under typical traffic congestion.
	//
	// Unit: seconds
	TypicalDuration int64

	noSmithyDocumentSerde
}

// Place details corresponding to the arrival or departure.
type RouteVehiclePlace struct {

	// Position defined as [longitude, latitude] .
	//
	// This member is required.
	Position []float64

	// The name of the place.
	Name *string

	// Position provided in the request.
	OriginalPosition []float64

	// Options to configure matching the provided position to a side of the street.
	SideOfStreet RouteSideOfStreet

	// Index of the waypoint in the request.
	WaypointIndex *int32

	noSmithyDocumentSerde
}

// Span computed for the requested SpanAdditionalFeatures.
type RouteVehicleSpan struct {

	// Duration of the computed span without traffic congestion.
	//
	// Unit: seconds
	BestCaseDuration int64

	// Access attributes for a car corresponding to the span.
	CarAccess []RouteSpanCarAccessAttribute

	// 3 letter Country code corresponding to the Span.
	Country *string

	// Distance of the computed span. This feature doesn't split a span, but is always
	// computed on a span split by other properties.
	Distance int64

	// Duration of the computed span. This feature doesn't split a span, but is always
	// computed on a span split by other properties.
	//
	// Unit: seconds
	Duration int64

	// Dynamic speed details corresponding to the span.
	//
	// Unit: KilometersPerHour
	DynamicSpeed *RouteSpanDynamicSpeedDetails

	// Functional classification of the road segment corresponding to the span.
	FunctionalClassification *int32

	// Attributes corresponding to a gate. The gate is present at the end of the
	// returned span.
	Gate RouteSpanGateAttribute

	// Offset in the leg geometry corresponding to the start of this span.
	GeometryOffset *int32

	// Incidents corresponding to the span. These index into the Incidents in the
	// parent Leg.
	Incidents []int32

	// Provides an array of names of the vehicle span in available languages.
	Names []LocalizedString

	// Notices are additional information returned that indicate issues that occurred
	// during route calculation.
	Notices []int32

	// Attributes corresponding to a railway crossing. The gate is present at the end
	// of the returned span.
	RailwayCrossing RouteSpanRailwayCrossingAttribute

	// 2-3 letter Region code corresponding to the Span. This is either a province or
	// a state.
	Region *string

	// Attributes for the road segment corresponding to the span.
	RoadAttributes []RouteSpanRoadAttribute

	// Designated route name or number corresponding to the span.
	RouteNumbers []RouteNumber

	// Access attributes for a scooter corresponding to the span.
	ScooterAccess []RouteSpanScooterAccessAttribute

	// Speed limit details corresponding to the span.
	//
	// Unit: KilometersPerHour
	SpeedLimit *RouteSpanSpeedLimitDetails

	// Toll systems are authorities that collect payments for the toll.
	TollSystems []int32

	// Access attributes for a truck corresponding to the span.
	TruckAccess []RouteSpanTruckAccessAttribute

	// Truck road type identifiers. BK1 through BK4 apply only to Sweden.
	// A2,A4,B2,B4,C,D,ET2,ET4 apply only to Mexico.
	//
	// There are currently no other supported values as of 26th April 2024.
	TruckRoadTypes []int32

	// Duration of the computed span under typical traffic congestion.
	//
	// Unit: seconds
	TypicalDuration int64

	// Zones corresponding to this leg of the route.
	Zones []int32

	noSmithyDocumentSerde
}

// Summarized details of the route.
type RouteVehicleSummary struct {

	// Summarized details for the leg including before travel, travel and after travel
	// steps.
	Overview *RouteVehicleOverviewSummary

	// Summarized details for the leg including travel steps only. The Distance for
	// the travel only portion of the journey is in meters
	TravelOnly *RouteVehicleTravelOnlySummary

	noSmithyDocumentSerde
}

// Summarized details of the route.
type RouteVehicleTravelOnlySummary struct {

	// Duration of the step.
	//
	// Unit: seconds
	//
	// This member is required.
	Duration int64

	// Total duration in free flowing traffic, which is the best case or shortest
	// duration possible to cover the leg.
	//
	// Unit: seconds
	BestCaseDuration int64

	// Duration of the computed span under typical traffic congestion.
	//
	// Unit: seconds
	TypicalDuration int64

	noSmithyDocumentSerde
}

// Steps of a leg that correspond to the travel portion of the leg.
type RouteVehicleTravelStep struct {

	// Duration of the step.
	//
	// Unit: seconds
	//
	// This member is required.
	Duration int64

	// Type of the step.
	//
	// This member is required.
	Type RouteVehicleTravelStepType

	// Details that are specific to a Continue Highway step.
	ContinueHighwayStepDetails *RouteContinueHighwayStepDetails

	// Details that are specific to a Continue step.
	ContinueStepDetails *RouteContinueStepDetails

	// Details of the current road.
	CurrentRoad *RouteRoad

	// Distance of the step.
	Distance int64

	// Details that are specific to a Enter Highway step.
	EnterHighwayStepDetails *RouteEnterHighwayStepDetails

	// Exit number of the road exit, if applicable.
	ExitNumber []LocalizedString

	// Details that are specific to a Roundabout Exit step.
	ExitStepDetails *RouteExitStepDetails

	// Offset in the leg geometry corresponding to the start of this step.
	GeometryOffset *int32

	// Brief description of the step in the requested language.
	//
	// Only available when the TravelStepType is Default.
	Instruction *string

	// Details that are specific to a Keep step.
	KeepStepDetails *RouteKeepStepDetails

	// Details of the next road. See RouteRoad for details of sub-attributes.
	NextRoad *RouteRoad

	// Details that are specific to a Ramp step.
	RampStepDetails *RouteRampStepDetails

	// Details that are specific to a Roundabout Enter step.
	RoundaboutEnterStepDetails *RouteRoundaboutEnterStepDetails

	// Details that are specific to a Roundabout Exit step.
	RoundaboutExitStepDetails *RouteRoundaboutExitStepDetails

	// Details that are specific to a Roundabout Pass step.
	RoundaboutPassStepDetails *RouteRoundaboutPassStepDetails

	// Sign post information of the action, applicable only for TurnByTurn steps. See
	// RouteSignpost for details of sub-attributes.
	Signpost *RouteSignpost

	// Details that are specific to a Turn step.
	TurnStepDetails *RouteTurnStepDetails

	// Details that are specific to a Turn step.
	UTurnStepDetails *RouteUTurnStepDetails

	noSmithyDocumentSerde
}

// This property contains a summary of violated constraints.
type RouteViolatedConstraints struct {

	// List of Hazardous cargo contained in the vehicle.
	//
	// This member is required.
	HazardousCargos []RouteHazardousCargoType

	// This restriction applies to truck cargo, where the resulting route excludes
	// roads on which hazardous materials are prohibited from being transported.
	AllHazardsRestricted *bool

	// Total number of axles of the vehicle.
	AxleCount *RouteNoticeDetailRange

	// The maximum height of the vehicle.
	MaxHeight int64

	// The maximum Kpra length of the vehicle.
	//
	// Unit: centimeters
	MaxKpraLength int64

	// The maximum length of the vehicle.
	MaxLength int64

	// The maximum load capacity of the vehicle.
	//
	// Unit: kilograms
	MaxPayloadCapacity int64

	// The maximum weight of the route.
	//
	// Unit: Kilograms
	MaxWeight *RouteWeightConstraint

	// The maximum weight per axle of the vehicle.
	//
	// Unit: Kilograms
	MaxWeightPerAxle int64

	// The maximum weight per axle group of the vehicle.
	//
	// Unit: Kilograms
	MaxWeightPerAxleGroup *WeightPerAxleGroup

	// The maximum width of the vehicle.
	MaxWidth int64

	// The number of occupants in the vehicle.
	//
	// Default Value: 1
	Occupancy *RouteNoticeDetailRange

	// Access radius restrictions based on time.
	RestrictedTimes *string

	// The time dependent constraint.
	TimeDependent *bool

	// Number of trailers attached to the vehicle.
	//
	// Default Value: 0
	TrailerCount *RouteNoticeDetailRange

	// Travel mode corresponding to the leg.
	TravelMode *bool

	// Truck road type identifiers. BK1 through BK4 apply only to Sweden.
	// A2,A4,B2,B4,C,D,ET2,ET4 apply only to Mexico.
	//
	// There are currently no other supported values as of 26th April 2024.
	TruckRoadType *string

	// Type of the truck.
	TruckType RouteTruckType

	// The tunnel restriction code.
	//
	// Tunnel categories in this list indicate the restrictions which apply to certain
	// tunnels in Great Britain. They relate to the types of dangerous goods that can
	// be transported through them.
	//
	//   - Tunnel Category B
	//
	//   - Risk Level: Limited risk
	//
	//   - Restrictions: Few restrictions
	//
	//   - Tunnel Category C
	//
	//   - Risk Level: Medium risk
	//
	//   - Restrictions: Some restrictions
	//
	//   - Tunnel Category D
	//
	//   - Risk Level: High risk
	//
	//   - Restrictions: Many restrictions occur
	//
	//   - Tunnel Category E
	//
	//   - Risk Level: Very high risk
	//
	//   - Restrictions: Restricted tunnel
	TunnelRestrictionCode *string

	noSmithyDocumentSerde
}

// Waypoint between the Origin and Destination.
type RouteWaypoint struct {

	// Position defined as [longitude, latitude] .
	//
	// This member is required.
	Position []float64

	// Avoids actions for the provided distance. This is typically to consider for
	// users in moving vehicles who may not have sufficient time to make an action at
	// an origin or a destination.
	AvoidActionsForDistance int64

	// Avoid U-turns for calculation on highways and motorways.
	AvoidUTurns *bool

	// GPS Heading at the position.
	Heading float64

	// Options to configure matching the provided position to the road network.
	Matching *RouteMatchingOptions

	// If the waypoint should not be treated as a stop. If yes, the waypoint is passed
	// through and doesn't split the route into different legs.
	PassThrough *bool

	// Options to configure matching the provided position to a side of the street.
	SideOfStreet *RouteSideOfStreetOptions

	// Duration of the stop.
	//
	// Unit: seconds
	StopDuration int64

	noSmithyDocumentSerde
}

// The weight constraint for the route.
//
// Unit: Kilograms
type RouteWeightConstraint struct {

	// The type of constraint.
	//
	// This member is required.
	Type RouteWeightConstraintType

	// The constraint value.
	//
	// Unit: Kilograms
	//
	// This member is required.
	Value int64

	noSmithyDocumentSerde
}

// The zone.
type RouteZone struct {

	// The zone category.
	Category RouteZoneCategory

	// The name of the zone.
	Name *string

	noSmithyDocumentSerde
}

// The input fails to satisfy the constraints specified by the Amazon Location
// service.
type ValidationExceptionField struct {

	// The error message.
	//
	// This member is required.
	Message *string

	// The name of the Validation Exception Field.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// Access hours corresponding to when a destination can be visited.
type WaypointOptimizationAccessHours struct {

	// Contains the ID of the starting waypoint in this connection.
	//
	// This member is required.
	From *WaypointOptimizationAccessHoursEntry

	// Contains the ID of the ending waypoint in this connection.
	//
	// This member is required.
	To *WaypointOptimizationAccessHoursEntry

	noSmithyDocumentSerde
}

// Hours of entry.
type WaypointOptimizationAccessHoursEntry struct {

	// Day of the week.
	//
	// This member is required.
	DayOfWeek DayOfWeek

	// Time of the day.
	//
	// This member is required.
	TimeOfDay *string

	noSmithyDocumentSerde
}

// The area to be avoided.
type WaypointOptimizationAvoidanceArea struct {

	// Geometry of the area to be avoided.
	//
	// This member is required.
	Geometry *WaypointOptimizationAvoidanceAreaGeometry

	noSmithyDocumentSerde
}

// Geometry of the area to be avoided.
type WaypointOptimizationAvoidanceAreaGeometry struct {

	// Geometry defined as a bounding box. The first pair represents the X and Y
	// coordinates (longitude and latitude,) of the southwest corner of the bounding
	// box; the second pair represents the X and Y coordinates (longitude and latitude)
	// of the northeast corner.
	BoundingBox []float64

	noSmithyDocumentSerde
}

// Specifies options for areas to avoid. This is a best-effort avoidance setting,
// meaning the router will try to honor the avoidance preferences but may still
// include restricted areas if no feasible alternative route exists. If avoidance
// options are not followed, the response will indicate that the avoidance criteria
// were violated.
type WaypointOptimizationAvoidanceOptions struct {

	// Areas to be avoided.
	Areas []WaypointOptimizationAvoidanceArea

	// Avoidance options for cars-shuttles-trains.
	CarShuttleTrains *bool

	// Avoid controlled access highways while calculating the route.
	ControlledAccessHighways *bool

	// Avoid dirt roads while calculating the route.
	DirtRoads *bool

	// Avoidance options for ferries.
	Ferries *bool

	// Avoids roads where the specified toll transponders are the only mode of payment.
	TollRoads *bool

	// Avoid tunnels while calculating the route.
	Tunnels *bool

	// Avoid U-turns for calculation on highways and motorways.
	UTurns *bool

	noSmithyDocumentSerde
}

// Options for WaypointOptimizationClustering.
type WaypointOptimizationClusteringOptions struct {

	// The algorithm to be used. DrivingDistance assigns all the waypoints that are
	// within driving distance of each other into a single cluster. TopologySegment
	// assigns all the waypoints that are within the same topology segment into a
	// single cluster. A Topology segment is a linear stretch of road between two
	// junctions.
	//
	// This member is required.
	Algorithm WaypointOptimizationClusteringAlgorithm

	// Driving distance options to be used when the clustering algorithm is
	// DrivingDistance.
	DrivingDistanceOptions *WaypointOptimizationDrivingDistanceOptions

	noSmithyDocumentSerde
}

// This contains information such as distance and duration from one waypoint to
// the next waypoint in the sequence.
type WaypointOptimizationConnection struct {

	// Distance of the step.
	//
	// This member is required.
	Distance int64

	// contains the ID of the starting waypoint in this connection.
	//
	// This member is required.
	From *string

	// Resting time before the driver can continue driving.
	//
	// This member is required.
	RestDuration int64

	// Contains the ID of the ending waypoint in this connection.
	//
	// This member is required.
	To *string

	// Total duration.
	//
	// Unit: seconds
	//
	// This member is required.
	TravelDuration int64

	// Duration of a wait step.
	//
	// Unit: seconds
	//
	// This member is required.
	WaitDuration int64

	noSmithyDocumentSerde
}

// Destination related options.
type WaypointOptimizationDestinationOptions struct {

	// Access hours corresponding to when a waypoint can be visited.
	AccessHours *WaypointOptimizationAccessHours

	// Appointment time at the destination.
	AppointmentTime *string

	// GPS Heading at the position.
	Heading float64

	// The waypoint Id.
	Id *string

	// Service time spent at the destination. At an appointment, the service time
	// should be the appointment duration.
	//
	// Unit: seconds
	ServiceDuration int64

	// Options to configure matching the provided position to a side of the street.
	SideOfStreet *WaypointOptimizationSideOfStreetOptions

	noSmithyDocumentSerde
}

// Driver related options.
type WaypointOptimizationDriverOptions struct {

	// Driver work-rest schedules defined by a short and long cycle. A rest needs to
	// be taken after the short work duration. The short cycle can be repeated until
	// you hit the long work duration, at which point the long rest duration should be
	// taken before restarting.
	RestCycles *WaypointOptimizationRestCycles

	// Pre defined rest profiles for a driver schedule. The only currently supported
	// profile is EU.
	RestProfile *WaypointOptimizationRestProfile

	// If the service time provided at a waypoint/destination should be considered as
	// rest or work. This contributes to the total time breakdown returned within the
	// response.
	TreatServiceTimeAs WaypointOptimizationServiceTimeTreatment

	noSmithyDocumentSerde
}

// Driving distance related options.
type WaypointOptimizationDrivingDistanceOptions struct {

	// DrivingDistance assigns all the waypoints that are within driving distance of
	// each other into a single cluster.
	//
	// This member is required.
	DrivingDistance int64

	noSmithyDocumentSerde
}

// Specifies strict exclusion options for the route calculation. This setting
// mandates that the router will avoid any routes that include the specified
// options, rather than merely attempting to minimize them.
type WaypointOptimizationExclusionOptions struct {

	// List of countries to be avoided defined by two-letter or three-letter country
	// codes.
	//
	// This member is required.
	Countries []string

	noSmithyDocumentSerde
}

// The failed constraint.
type WaypointOptimizationFailedConstraint struct {

	// The failed constraint.
	Constraint WaypointOptimizationConstraint

	// Reason for the failed constraint.
	Reason *string

	noSmithyDocumentSerde
}

// The impeding waypoint.
type WaypointOptimizationImpedingWaypoint struct {

	// Failed constraints for an impeding waypoint.
	//
	// This member is required.
	FailedConstraints []WaypointOptimizationFailedConstraint

	// The waypoint Id.
	//
	// This member is required.
	Id *string

	// Position defined as [longitude, latitude] .
	//
	// This member is required.
	Position []float64

	noSmithyDocumentSerde
}

// The optimized waypoint.
type WaypointOptimizationOptimizedWaypoint struct {

	// Estimated time of departure from thr origin.
	//
	// Time format: YYYY-MM-DDThh:mm:ss.sssZ | YYYY-MM-DDThh:mm:ss.sss+hh:mm
	//
	// Examples:
	//
	//     2020-04-22T17:57:24Z
	//
	//     2020-04-22T17:57:24+02:00
	//
	// This member is required.
	DepartureTime *string

	// The waypoint Id.
	//
	// This member is required.
	Id *string

	// Position defined as [longitude, latitude] .
	//
	// This member is required.
	Position []float64

	// Estimated time of arrival at the destination.
	//
	// Time format: YYYY-MM-DDThh:mm:ss.sssZ | YYYY-MM-DDThh:mm:ss.sss+hh:mm
	//
	// Examples:
	//
	//     2020-04-22T17:57:24Z
	//
	//     2020-04-22T17:57:24+02:00
	ArrivalTime *string

	// Index of the cluster the waypoint is associated with. The index is included in
	// the response only if clustering was performed while processing the request.
	ClusterIndex *int32

	noSmithyDocumentSerde
}

// Origin related options.
type WaypointOptimizationOriginOptions struct {

	// The Origin Id.
	Id *string

	noSmithyDocumentSerde
}

// Options related to a pedestrian.
type WaypointOptimizationPedestrianOptions struct {

	// Walking speed.
	//
	// Unit: KilometersPerHour
	Speed *float64

	noSmithyDocumentSerde
}

// Driver work-rest schedules defined by a short and long cycle. A rest needs to
// be taken after the short work duration. The short cycle can be repeated until
// you hit the long work duration, at which point the long rest duration should be
// taken before restarting.
//
// Unit: seconds
type WaypointOptimizationRestCycleDurations struct {

	// Resting phase of the cycle.
	//
	// Unit: seconds
	//
	// This member is required.
	RestDuration int64

	// Working phase of the cycle.
	//
	// Unit: seconds
	//
	// This member is required.
	WorkDuration int64

	noSmithyDocumentSerde
}

// Resting phase of the cycle.
type WaypointOptimizationRestCycles struct {

	// Long cycle for a driver work-rest schedule.
	//
	// This member is required.
	LongCycle *WaypointOptimizationRestCycleDurations

	// Short cycle for a driver work-rest schedule
	//
	// This member is required.
	ShortCycle *WaypointOptimizationRestCycleDurations

	noSmithyDocumentSerde
}

// Pre defined rest profiles for a driver schedule. The only currently supported
// profile is EU.
type WaypointOptimizationRestProfile struct {

	// Pre defined rest profiles for a driver schedule. The only currently supported
	// profile is EU.
	//
	// This member is required.
	Profile *string

	noSmithyDocumentSerde
}

// Options to configure matching the provided position to a side of the street.
type WaypointOptimizationSideOfStreetOptions struct {

	// Position defined as [longitude, latitude] .
	//
	// This member is required.
	Position []float64

	// Strategy that defines when the side of street position should be used.
	// AnyStreet will always use the provided position.
	//
	// Default Value: DividedStreetOnly
	UseWith SideOfStreetMatchingStrategy

	noSmithyDocumentSerde
}

// Time breakdown for the sequence.
type WaypointOptimizationTimeBreakdown struct {

	// Resting phase of the cycle.
	//
	// Unit: seconds
	//
	// This member is required.
	RestDuration int64

	// Service time spent at the destination. At an appointment, the service time
	// should be the appointment duration.
	//
	// Unit: seconds
	//
	// This member is required.
	ServiceDuration int64

	// Traveling phase of the cycle.
	//
	// Unit: seconds
	//
	// This member is required.
	TravelDuration int64

	// Waiting phase of the cycle.
	//
	// Unit: seconds
	//
	// This member is required.
	WaitDuration int64

	noSmithyDocumentSerde
}

// Options related to traffic.
type WaypointOptimizationTrafficOptions struct {

	// Determines if traffic should be used or ignored while calculating the route.
	//
	// Default Value: UseTrafficData
	Usage TrafficUsage

	noSmithyDocumentSerde
}

// Trailer options corresponding to the vehicle.
type WaypointOptimizationTrailerOptions struct {

	// Number of trailers attached to the vehicle.
	//
	// Default Value: 0
	TrailerCount *int32

	noSmithyDocumentSerde
}

// Travel mode related options for the provided travel mode.
type WaypointOptimizationTravelModeOptions struct {

	// Travel mode options when the provided travel mode is "Pedestrian"
	Pedestrian *WaypointOptimizationPedestrianOptions

	// Travel mode options when the provided travel mode is "Truck"
	Truck *WaypointOptimizationTruckOptions

	noSmithyDocumentSerde
}

// Travel mode options when the provided travel mode is "Truck"
type WaypointOptimizationTruckOptions struct {

	// Gross weight of the vehicle including trailers, and goods at capacity.
	//
	// Unit: Kilograms
	GrossWeight int64

	// List of Hazardous cargo contained in the vehicle.
	HazardousCargos []WaypointOptimizationHazardousCargoType

	// Height of the vehicle.
	//
	// Unit: centimeters
	Height int64

	// Length of the vehicle.
	//
	// Unit: centimeters
	Length int64

	// Trailer options corresponding to the vehicle.
	Trailer *WaypointOptimizationTrailerOptions

	// Type of the truck.
	TruckType WaypointOptimizationTruckType

	// The tunnel restriction code.
	//
	// Tunnel categories in this list indicate the restrictions which apply to certain
	// tunnels in Great Britain. They relate to the types of dangerous goods that can
	// be transported through them.
	//
	//   - Tunnel Category B
	//
	//   - Risk Level: Limited risk
	//
	//   - Restrictions: Few restrictions
	//
	//   - Tunnel Category C
	//
	//   - Risk Level: Medium risk
	//
	//   - Restrictions: Some restrictions
	//
	//   - Tunnel Category D
	//
	//   - Risk Level: High risk
	//
	//   - Restrictions: Many restrictions occur
	//
	//   - Tunnel Category E
	//
	//   - Risk Level: Very high risk
	//
	//   - Restrictions: Restricted tunnel
	TunnelRestrictionCode *string

	// Heaviest weight per axle irrespective of the axle type or the axle group. Meant
	// for usage in countries where the differences in axle types or axle groups are
	// not distinguished.
	//
	// Unit: Kilograms
	WeightPerAxle int64

	// Width of the vehicle.
	//
	// Unit: centimeters
	Width int64

	noSmithyDocumentSerde
}

// Waypoint between the Origin and Destination.
type WaypointOptimizationWaypoint struct {

	// Position defined as [longitude, latitude] .
	//
	// This member is required.
	Position []float64

	// Access hours corresponding to when a waypoint can be visited.
	AccessHours *WaypointOptimizationAccessHours

	// Appointment time at the waypoint.
	AppointmentTime *string

	// Constraint defining what waypoints are to be visited after this waypoint.
	Before []int32

	// GPS Heading at the position.
	Heading float64

	// The waypoint Id.
	Id *string

	// Service time spent at the waypoint. At an appointment, the service time should
	// be the appointment duration.
	//
	// Unit: seconds
	ServiceDuration int64

	// Options to configure matching the provided position to a side of the street.
	SideOfStreet *WaypointOptimizationSideOfStreetOptions

	noSmithyDocumentSerde
}

// Specifies the total weight for the specified axle group. Meant for usage in
// countries that have different regulations based on the axle group type.
//
// Unit: Kilograms
type WeightPerAxleGroup struct {

	// Weight for quad axle group.
	//
	// Unit: Kilograms
	Quad int64

	// Weight for quad quint group.
	//
	// Unit: Kilograms
	Quint int64

	// Weight for single axle group.
	//
	// Unit: Kilograms
	Single int64

	// Weight for tandem axle group.
	//
	// Unit: Kilograms
	Tandem int64

	// Weight for triple axle group.
	//
	// Unit: Kilograms
	Triple int64

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
