// Code generated by smithy-go-codegen DO NOT EDIT.

package directoryservice

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/directoryservice/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Retrieves detailed information about the certificate authority (CA) enrollment
// policy for the specified directory. This policy determines how client
// certificates are automatically enrolled and managed through Amazon Web Services
// Private Certificate Authority.
func (c *Client) DescribeCAEnrollmentPolicy(ctx context.Context, params *DescribeCAEnrollmentPolicyInput, optFns ...func(*Options)) (*DescribeCAEnrollmentPolicyOutput, error) {
	if params == nil {
		params = &DescribeCAEnrollmentPolicyInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeCAEnrollmentPolicy", params, optFns, c.addOperationDescribeCAEnrollmentPolicyMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeCAEnrollmentPolicyOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// Contains the inputs for the DescribeCAEnrollmentPolicy operation.
type DescribeCAEnrollmentPolicyInput struct {

	// The identifier of the directory for which to retrieve the CA enrollment policy
	// information.
	//
	// This member is required.
	DirectoryId *string

	noSmithyDocumentSerde
}

// Contains the results of the DescribeCAEnrollmentPolicy operation.
type DescribeCAEnrollmentPolicyOutput struct {

	// The current status of the CA enrollment policy. This indicates if automatic
	// certificate enrollment is currently active, inactive, or in a transitional
	// state.
	//
	// Valid values:
	//
	//   - IN_PROGRESS - The policy is being activated T
	//
	//   - SUCCESS - The policy is active and automatic certificate enrollment is
	//   operational
	//
	//   - FAILED - The policy activation or deactivation failed
	//
	//   - DISABLING - The policy is being deactivated
	//
	//   - DISABLED - The policy is inactive and automatic certificate enrollment is
	//   not available
	//
	//   - IMPAIRED - Network connectivity is impaired.
	CaEnrollmentPolicyStatus types.CaEnrollmentPolicyStatus

	// Additional information explaining the current status of the CA enrollment
	// policy, particularly useful when the policy is in an error or transitional
	// state.
	CaEnrollmentPolicyStatusReason *string

	// The identifier of the directory associated with this CA enrollment policy.
	DirectoryId *string

	// The date and time when the CA enrollment policy was last modified or updated.
	LastUpdatedDateTime *time.Time

	// The Amazon Resource Name (ARN) of the Amazon Web Services Private Certificate
	// Authority (PCA) connector that is configured for automatic certificate
	// enrollment in this directory.
	PcaConnectorArn *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeCAEnrollmentPolicyMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpDescribeCAEnrollmentPolicy{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpDescribeCAEnrollmentPolicy{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeCAEnrollmentPolicy"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpDescribeCAEnrollmentPolicyValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeCAEnrollmentPolicy(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDescribeCAEnrollmentPolicy(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeCAEnrollmentPolicy",
	}
}
