// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Specifies the prediction (aka, the automatically generated piece of metadata)
// and the target (for example, a column name) that can be accepted.
type AcceptChoice struct {

	// Specifies the target (for example, a column name) where a prediction can be
	// accepted.
	//
	// This member is required.
	PredictionTarget *string

	// The edit of the prediction.
	EditedValue *string

	// Specifies the prediction (aka, the automatically generated piece of metadata)
	// that can be accepted.
	PredictionChoice *int32

	noSmithyDocumentSerde
}

// The accepted asset scope.
type AcceptedAssetScope struct {

	// The asset ID of the accepted asset scope.
	//
	// This member is required.
	AssetId *string

	// The filter IDs of the accepted asset scope.
	//
	// This member is required.
	FilterIds []string

	noSmithyDocumentSerde
}

// Specifies the rule and the threshold under which a prediction can be accepted.
type AcceptRule struct {

	// Specifies whether you want to accept the top prediction for all targets or none.
	Rule AcceptRuleBehavior

	// The confidence score that specifies the condition at which a prediction can be
	// accepted.
	Threshold *float32

	noSmithyDocumentSerde
}

// The account information within an account pool.
type AccountInfo struct {

	// The account ID.
	//
	// This member is required.
	AwsAccountId *string

	// The regions supported for an account within an account pool.
	//
	// This member is required.
	SupportedRegions []string

	// The account name.
	AwsAccountName *string

	noSmithyDocumentSerde
}

// The summary of the account pool.
type AccountPoolSummary struct {

	// The user who created the account pool.
	CreatedBy *string

	// The ID of the domain.
	DomainId *string

	// The ID of the domain unit.
	DomainUnitId *string

	// The ID of the account pool.
	Id *string

	// The name of the account pool.
	Name *string

	// The mechanism used to resolve the account selection from the account pool.
	ResolutionStrategy ResolutionStrategy

	// The user who updated the account pool.
	UpdatedBy *string

	noSmithyDocumentSerde
}

// The source of accounts for the account pool. In the current release, it's
// either a static list of accounts provided by the customer or a custom Amazon Web
// Services Lambda handler.
//
// The following types satisfy this interface:
//
//	AccountSourceMemberAccounts
//	AccountSourceMemberCustomAccountPoolHandler
type AccountSource interface {
	isAccountSource()
}

// The static list of accounts within an account pool.
type AccountSourceMemberAccounts struct {
	Value []AccountInfo

	noSmithyDocumentSerde
}

func (*AccountSourceMemberAccounts) isAccountSource() {}

// The custom Amazon Web Services Lambda handler within an account pool.
type AccountSourceMemberCustomAccountPoolHandler struct {
	Value CustomAccountPoolHandler

	noSmithyDocumentSerde
}

func (*AccountSourceMemberCustomAccountPoolHandler) isAccountSource() {}

// The parameters of the environment action.
//
// The following types satisfy this interface:
//
//	ActionParametersMemberAwsConsoleLink
type ActionParameters interface {
	isActionParameters()
}

// The console link specified as part of the environment action.
type ActionParametersMemberAwsConsoleLink struct {
	Value AwsConsoleLinkParameters

	noSmithyDocumentSerde
}

func (*ActionParametersMemberAwsConsoleLink) isActionParameters() {}

// The details of the policy grant.
type AddToProjectMemberPoolPolicyGrantDetail struct {

	// Specifies whether the policy grant is applied to child domain units.
	IncludeChildDomainUnits *bool

	noSmithyDocumentSerde
}

// An aggregation list item.
type AggregationListItem struct {

	// An attribute on which to compute aggregations.
	//
	// This member is required.
	Attribute *string

	// The display value of the aggregation list item. Supported values include value
	// and glossaryTerm.name .
	DisplayValue *string

	noSmithyDocumentSerde
}

// The aggregation for an attribute.
type AggregationOutput struct {

	// The attribute for this aggregation.
	Attribute *string

	// The display value of the aggregation output item.
	DisplayValue *string

	// A list of aggregation output items.
	Items []AggregationOutputItem

	noSmithyDocumentSerde
}

// An aggregation output item.
type AggregationOutputItem struct {

	// The count of the aggregation output item.
	Count *int32

	// The display value of the aggregation. If the attribute being aggregated
	// corresponds to the id of a public resource, the service automatically resolves
	// the id to the provided display value.
	DisplayValue *string

	// The attribute value of the aggregation output item.
	Value *string

	noSmithyDocumentSerde
}

// The grant filter for all domain units.
type AllDomainUnitsGrantFilter struct {
	noSmithyDocumentSerde
}

// The all users grant filter.
type AllUsersGrantFilter struct {
	noSmithyDocumentSerde
}

// The configuration details of the asset filter.
//
// The following types satisfy this interface:
//
//	AssetFilterConfigurationMemberColumnConfiguration
//	AssetFilterConfigurationMemberRowConfiguration
type AssetFilterConfiguration interface {
	isAssetFilterConfiguration()
}

// The column configuration of the asset filter.
type AssetFilterConfigurationMemberColumnConfiguration struct {
	Value ColumnFilterConfiguration

	noSmithyDocumentSerde
}

func (*AssetFilterConfigurationMemberColumnConfiguration) isAssetFilterConfiguration() {}

// The row configuration of the asset filter.
type AssetFilterConfigurationMemberRowConfiguration struct {
	Value RowFilterConfiguration

	noSmithyDocumentSerde
}

func (*AssetFilterConfigurationMemberRowConfiguration) isAssetFilterConfiguration() {}

// The summary of the asset filter.
type AssetFilterSummary struct {

	// The ID of the data asset.
	//
	// This member is required.
	AssetId *string

	// The ID of the domain where the asset filter lives.
	//
	// This member is required.
	DomainId *string

	// The ID of the asset filter.
	//
	// This member is required.
	Id *string

	// The name of the asset filter.
	//
	// This member is required.
	Name *string

	// The timestamp at which the asset filter was created.
	CreatedAt *time.Time

	// The description of the asset filter.
	Description *string

	// The effective column names of the asset filter.
	EffectiveColumnNames []string

	// The effective row filter of the asset filter.
	EffectiveRowFilter *string

	// The error message that is displayed if the action does not succeed.
	ErrorMessage *string

	// The status of the asset filter.
	Status FilterStatus

	noSmithyDocumentSerde
}

// The listing of the asset in a data product.
type AssetInDataProductListingItem struct {

	// The entity ID of the listing of the asset in a data product.
	EntityId *string

	// The entity revision of the listing of the asset in a data product.
	EntityRevision *string

	// The entity type of the listing of the asset in a data product.
	EntityType *string

	noSmithyDocumentSerde
}

// A Amazon DataZone inventory asset.
type AssetItem struct {

	// The identifier of the Amazon DataZone domain in which the inventory asset
	// exists.
	//
	// This member is required.
	DomainId *string

	// the identifier of the Amazon DataZone inventory asset.
	//
	// This member is required.
	Identifier *string

	// The name of the Amazon DataZone inventory asset.
	//
	// This member is required.
	Name *string

	// The identifier of the Amazon DataZone project that owns the inventory asset.
	//
	// This member is required.
	OwningProjectId *string

	// The identifier of the asset type of the specified Amazon DataZone inventory
	// asset.
	//
	// This member is required.
	TypeIdentifier *string

	// The revision of the inventory asset type.
	//
	// This member is required.
	TypeRevision *string

	// The additional attributes of a Amazon DataZone inventory asset.
	AdditionalAttributes *AssetItemAdditionalAttributes

	// The timestamp of when the Amazon DataZone inventory asset was created.
	CreatedAt *time.Time

	// The Amazon DataZone user who created the inventory asset.
	CreatedBy *string

	// The description of an Amazon DataZone inventory asset.
	Description *string

	// The external identifier of the Amazon DataZone inventory asset.
	ExternalIdentifier *string

	// The timestamp of when the first revision of the inventory asset was created.
	FirstRevisionCreatedAt *time.Time

	// The Amazon DataZone user who created the first revision of the inventory asset.
	FirstRevisionCreatedBy *string

	// The glossary terms attached to the Amazon DataZone inventory asset.
	GlossaryTerms []string

	// The restricted glossary terms accociated with an asset.
	GovernedGlossaryTerms []string

	noSmithyDocumentSerde
}

// The additional attributes of an inventory asset.
type AssetItemAdditionalAttributes struct {

	// The forms included in the additional attributes of an inventory asset.
	FormsOutput []FormOutput

	// The latest time series data points forms included in the additional attributes
	// of an asset.
	LatestTimeSeriesDataPointFormsOutput []TimeSeriesDataPointSummaryFormOutput

	// List of rationales indicating why this item was matched by search.
	MatchRationale []MatchRationaleItem

	// The read-only forms included in the additional attributes of an inventory asset.
	ReadOnlyFormsOutput []FormOutput

	noSmithyDocumentSerde
}

// An asset published in an Amazon DataZone catalog.
type AssetListing struct {

	// The identifier of an asset published in an Amazon DataZone catalog.
	AssetId *string

	// The revision of an asset published in an Amazon DataZone catalog.
	AssetRevision *string

	// The type of an asset published in an Amazon DataZone catalog.
	AssetType *string

	// The timestamp of when an asset published in an Amazon DataZone catalog was
	// created.
	CreatedAt *time.Time

	// The metadata forms attached to an asset published in an Amazon DataZone
	// catalog.
	Forms *string

	// The glossary terms attached to an asset published in an Amazon DataZone
	// catalog.
	GlossaryTerms []DetailedGlossaryTerm

	// The restricted glossary terms associated with an asset.
	GovernedGlossaryTerms []DetailedGlossaryTerm

	// The latest time series data points forms included in the additional attributes
	// of an asset.
	LatestTimeSeriesDataPointForms []TimeSeriesDataPointSummaryFormOutput

	// The identifier of the project where an asset published in an Amazon DataZone
	// catalog exists.
	OwningProjectId *string

	noSmithyDocumentSerde
}

// The details of an asset published in an Amazon DataZone catalog.
type AssetListingDetails struct {

	// The identifier of an asset published in an Amazon DataZone catalog.
	//
	// This member is required.
	ListingId *string

	// The status of an asset published in an Amazon DataZone catalog.
	//
	// This member is required.
	ListingStatus ListingStatus

	noSmithyDocumentSerde
}

// The details of an asset published in an Amazon DataZone catalog.
type AssetListingItem struct {

	// The additional attributes of an asset published in an Amazon DataZone catalog.
	AdditionalAttributes *AssetListingItemAdditionalAttributes

	// The timestamp of when an asset published in an Amazon DataZone catalog was
	// created.
	CreatedAt *time.Time

	// The description of an asset published in an Amazon DataZone catalog.
	Description *string

	// The identifier of the inventory asset.
	EntityId *string

	// The revision of the inventory asset.
	EntityRevision *string

	// The type of the inventory asset.
	EntityType *string

	// Glossary terms attached to the inventory asset.
	GlossaryTerms []DetailedGlossaryTerm

	// The restricted glossary terms associated with an asset.
	GovernedGlossaryTerms []DetailedGlossaryTerm

	// The Amazon DataZone user who created the listing.
	ListingCreatedBy *string

	// The identifier of the listing (asset published in Amazon DataZone catalog).
	ListingId *string

	// The revision of the listing (asset published in Amazon DataZone catalog).
	ListingRevision *string

	// The Amazon DataZone user who updated the listing.
	ListingUpdatedBy *string

	// The name of the inventory asset.
	Name *string

	// The identifier of the project that owns the inventory asset.
	OwningProjectId *string

	noSmithyDocumentSerde
}

// Additional attributes of an inventory asset.
type AssetListingItemAdditionalAttributes struct {

	// The metadata forms that form additional attributes of the metadata asset.
	Forms *string

	// The latest time series data points forms included in the additional attributes
	// of an asset.
	LatestTimeSeriesDataPointForms []TimeSeriesDataPointSummaryFormOutput

	// List of rationales indicating why this item was matched by search.
	MatchRationale []MatchRationaleItem

	noSmithyDocumentSerde
}

// The revision of an inventory asset.
type AssetRevision struct {

	// The timestamp of when an inventory asset revison was created.
	CreatedAt *time.Time

	// The Amazon DataZone user who created the asset revision.
	CreatedBy *string

	// The Amazon DataZone user who created the inventory asset.
	DomainId *string

	// The identifier of the inventory asset revision.
	Id *string

	// The revision details of the inventory asset.
	Revision *string

	noSmithyDocumentSerde
}

// The asset scope.
type AssetScope struct {

	// The asset ID of the asset scope.
	//
	// This member is required.
	AssetId *string

	// The filter IDs of the asset scope.
	//
	// This member is required.
	FilterIds []string

	// The status of the asset scope.
	//
	// This member is required.
	Status *string

	// The error message of the asset scope.
	ErrorMessage *string

	noSmithyDocumentSerde
}

// The name map for assets.
type AssetTargetNameMap struct {

	// The identifier of the inventory asset.
	//
	// This member is required.
	AssetId *string

	// The target name in the asset target name map.
	//
	// This member is required.
	TargetName *string

	noSmithyDocumentSerde
}

// The details of the asset type.
type AssetTypeItem struct {

	// The identifier of the Amazon DataZone domain where the asset type exists.
	//
	// This member is required.
	DomainId *string

	// The forms included in the details of the asset type.
	//
	// This member is required.
	FormsOutput map[string]FormEntryOutput

	// The name of the asset type.
	//
	// This member is required.
	Name *string

	// The identifier of the Amazon DataZone project that owns the asset type.
	//
	// This member is required.
	OwningProjectId *string

	// The revision of the asset type.
	//
	// This member is required.
	Revision *string

	// The timestamp of when the asset type was created.
	CreatedAt *time.Time

	// The Amazon DataZone user who created the asset type.
	CreatedBy *string

	// The description of the asset type.
	Description *string

	// The identifier of the Amazon DataZone domain where the asset type was
	// originally created.
	OriginDomainId *string

	// The identifier of the Amazon DataZone project where the asset type exists.
	OriginProjectId *string

	// The timestamp of when the asset type was updated.
	UpdatedAt *time.Time

	// The Amazon DataZone user who updated the asset type.
	UpdatedBy *string

	noSmithyDocumentSerde
}

// The asset type for the rule details.
type AssetTypesForRule struct {

	// The selection mode for the rule.
	//
	// This member is required.
	SelectionMode RuleScopeSelectionMode

	// The specific asset types that are included in the rule.
	SpecificAssetTypes []string

	noSmithyDocumentSerde
}

// The Amazon Athena properties of a connection.
type AthenaPropertiesInput struct {

	// The Amazon Athena workgroup name of a connection.
	WorkgroupName *string

	noSmithyDocumentSerde
}

// The Amazon Athena properties of a connection.
type AthenaPropertiesOutput struct {

	// The Amazon Athena workgroup name of a connection.
	WorkgroupName *string

	noSmithyDocumentSerde
}

// The Amazon Athena properties patch of a connection.
type AthenaPropertiesPatch struct {

	// The Amazon Athena workgroup name of a connection.
	WorkgroupName *string

	noSmithyDocumentSerde
}

// The authentication configuration of a connection.
type AuthenticationConfiguration struct {

	// The authentication type of a connection.
	AuthenticationType AuthenticationType

	// The oAuth2 properties of a connection.
	OAuth2Properties *OAuth2Properties

	// The secret ARN of a connection.
	SecretArn *string

	noSmithyDocumentSerde
}

// The authentication configuration of a connection.
type AuthenticationConfigurationInput struct {

	// The authentication type of a connection.
	AuthenticationType AuthenticationType

	// The basic authentication credentials of a connection.
	BasicAuthenticationCredentials *BasicAuthenticationCredentials

	// The custom authentication credentials of a connection.
	CustomAuthenticationCredentials map[string]string

	// The KMS key ARN of a connection.
	KmsKeyArn *string

	// The oAuth2 properties of a connection.
	OAuth2Properties *OAuth2Properties

	// The secret ARN of a connection.
	SecretArn *string

	noSmithyDocumentSerde
}

// The authentication configuration patch of a connection.
type AuthenticationConfigurationPatch struct {

	// The basic authentication credentials of a connection.
	BasicAuthenticationCredentials *BasicAuthenticationCredentials

	// The secret ARN of a connection.
	SecretArn *string

	noSmithyDocumentSerde
}

// The authorization code properties of a connection.
type AuthorizationCodeProperties struct {

	// The authorization code of a connection.
	AuthorizationCode *string

	// The redirect URI of a connection.
	RedirectUri *string

	noSmithyDocumentSerde
}

// The account ID of a project.
//
// The following types satisfy this interface:
//
//	AwsAccountMemberAwsAccountId
//	AwsAccountMemberAwsAccountIdPath
type AwsAccount interface {
	isAwsAccount()
}

// The account ID of a project.
type AwsAccountMemberAwsAccountId struct {
	Value string

	noSmithyDocumentSerde
}

func (*AwsAccountMemberAwsAccountId) isAwsAccount() {}

// The account ID path of a project.
type AwsAccountMemberAwsAccountIdPath struct {
	Value string

	noSmithyDocumentSerde
}

func (*AwsAccountMemberAwsAccountIdPath) isAwsAccount() {}

// The parameters of the console link specified as part of the environment action.
type AwsConsoleLinkParameters struct {

	// The URI of the console link specified as part of the environment action.
	Uri *string

	noSmithyDocumentSerde
}

// The location of a project.
type AwsLocation struct {

	// The access role of a connection.
	AccessRole *string

	// The account ID of a connection.
	AwsAccountId *string

	// The Region of a connection.
	AwsRegion *string

	// The IAM connection ID of a connection.
	IamConnectionId *string

	noSmithyDocumentSerde
}

// The basic authentication credentials of a connection.
type BasicAuthenticationCredentials struct {

	// The password for a connection.
	Password *string

	// The user name for the connecion.
	UserName *string

	noSmithyDocumentSerde
}

// The configuration of the business name generation.
type BusinessNameGenerationConfiguration struct {

	// Specifies whether the business name generation is enabled.
	Enabled *bool

	noSmithyDocumentSerde
}

// Part of the provisioning properties of the environment blueprint.
type CloudFormationProperties struct {

	// The template URL of the cloud formation provisioning properties of the
	// environment blueprint.
	//
	// This member is required.
	TemplateUrl *string

	noSmithyDocumentSerde
}

// The column configuration of the asset filter.
type ColumnFilterConfiguration struct {

	// Specifies whether to include column names.
	IncludedColumnNames []string

	noSmithyDocumentSerde
}

// The details of the parameters for the configurable environment action.
type ConfigurableActionParameter struct {

	// The key of the configurable action parameter.
	Key *string

	// The value of the configurable action parameter.
	Value *string

	noSmithyDocumentSerde
}

// The configurable action of a Amazon DataZone environment.
type ConfigurableEnvironmentAction struct {

	// The parameters of a configurable action in a Amazon DataZone environment.
	//
	// This member is required.
	Parameters []ConfigurableActionParameter

	// The type of a configurable action in a Amazon DataZone environment.
	//
	// This member is required.
	Type *string

	// The authentication type of a configurable action of a Amazon DataZone
	// environment.
	Auth ConfigurableActionTypeAuthorization

	noSmithyDocumentSerde
}

// The credentials of a connection.
type ConnectionCredentials struct {

	// The access key ID of a connection.
	AccessKeyId *string

	// The expiration of the connection credentials.
	Expiration *time.Time

	// The secret access key of a connection.
	SecretAccessKey *string

	// The session token of a connection credentials.
	SessionToken *string

	noSmithyDocumentSerde
}

// The properties of a connection.
//
// The following types satisfy this interface:
//
//	ConnectionPropertiesInputMemberAthenaProperties
//	ConnectionPropertiesInputMemberGlueProperties
//	ConnectionPropertiesInputMemberHyperPodProperties
//	ConnectionPropertiesInputMemberIamProperties
//	ConnectionPropertiesInputMemberRedshiftProperties
//	ConnectionPropertiesInputMemberS3Properties
//	ConnectionPropertiesInputMemberSparkEmrProperties
//	ConnectionPropertiesInputMemberSparkGlueProperties
type ConnectionPropertiesInput interface {
	isConnectionPropertiesInput()
}

// The Amazon Athena properties of a connection.
type ConnectionPropertiesInputMemberAthenaProperties struct {
	Value AthenaPropertiesInput

	noSmithyDocumentSerde
}

func (*ConnectionPropertiesInputMemberAthenaProperties) isConnectionPropertiesInput() {}

// The Amazon Web Services Glue properties of a connection.
type ConnectionPropertiesInputMemberGlueProperties struct {
	Value GluePropertiesInput

	noSmithyDocumentSerde
}

func (*ConnectionPropertiesInputMemberGlueProperties) isConnectionPropertiesInput() {}

// The hyper pod properties of a connection.
type ConnectionPropertiesInputMemberHyperPodProperties struct {
	Value HyperPodPropertiesInput

	noSmithyDocumentSerde
}

func (*ConnectionPropertiesInputMemberHyperPodProperties) isConnectionPropertiesInput() {}

// The IAM properties of a connection.
type ConnectionPropertiesInputMemberIamProperties struct {
	Value IamPropertiesInput

	noSmithyDocumentSerde
}

func (*ConnectionPropertiesInputMemberIamProperties) isConnectionPropertiesInput() {}

// The Amazon Redshift properties of a connection.
type ConnectionPropertiesInputMemberRedshiftProperties struct {
	Value RedshiftPropertiesInput

	noSmithyDocumentSerde
}

func (*ConnectionPropertiesInputMemberRedshiftProperties) isConnectionPropertiesInput() {}

// The Amazon S3 properties of a connection.
type ConnectionPropertiesInputMemberS3Properties struct {
	Value S3PropertiesInput

	noSmithyDocumentSerde
}

func (*ConnectionPropertiesInputMemberS3Properties) isConnectionPropertiesInput() {}

// The Spark EMR properties of a connection.
type ConnectionPropertiesInputMemberSparkEmrProperties struct {
	Value SparkEmrPropertiesInput

	noSmithyDocumentSerde
}

func (*ConnectionPropertiesInputMemberSparkEmrProperties) isConnectionPropertiesInput() {}

// The Spark Amazon Web Services Glue properties of a connection.
type ConnectionPropertiesInputMemberSparkGlueProperties struct {
	Value SparkGluePropertiesInput

	noSmithyDocumentSerde
}

func (*ConnectionPropertiesInputMemberSparkGlueProperties) isConnectionPropertiesInput() {}

// The properties of a connection.
//
// The following types satisfy this interface:
//
//	ConnectionPropertiesOutputMemberAthenaProperties
//	ConnectionPropertiesOutputMemberGlueProperties
//	ConnectionPropertiesOutputMemberHyperPodProperties
//	ConnectionPropertiesOutputMemberIamProperties
//	ConnectionPropertiesOutputMemberRedshiftProperties
//	ConnectionPropertiesOutputMemberS3Properties
//	ConnectionPropertiesOutputMemberSparkEmrProperties
//	ConnectionPropertiesOutputMemberSparkGlueProperties
type ConnectionPropertiesOutput interface {
	isConnectionPropertiesOutput()
}

// The Amazon Athena properties of a connection.
type ConnectionPropertiesOutputMemberAthenaProperties struct {
	Value AthenaPropertiesOutput

	noSmithyDocumentSerde
}

func (*ConnectionPropertiesOutputMemberAthenaProperties) isConnectionPropertiesOutput() {}

// The Amazon Web Services Glue properties of a connection.
type ConnectionPropertiesOutputMemberGlueProperties struct {
	Value GluePropertiesOutput

	noSmithyDocumentSerde
}

func (*ConnectionPropertiesOutputMemberGlueProperties) isConnectionPropertiesOutput() {}

// The hyper pod properties of a connection.
type ConnectionPropertiesOutputMemberHyperPodProperties struct {
	Value HyperPodPropertiesOutput

	noSmithyDocumentSerde
}

func (*ConnectionPropertiesOutputMemberHyperPodProperties) isConnectionPropertiesOutput() {}

// The IAM properties of a connection.
type ConnectionPropertiesOutputMemberIamProperties struct {
	Value IamPropertiesOutput

	noSmithyDocumentSerde
}

func (*ConnectionPropertiesOutputMemberIamProperties) isConnectionPropertiesOutput() {}

// The Amazon Redshift properties of a connection.
type ConnectionPropertiesOutputMemberRedshiftProperties struct {
	Value RedshiftPropertiesOutput

	noSmithyDocumentSerde
}

func (*ConnectionPropertiesOutputMemberRedshiftProperties) isConnectionPropertiesOutput() {}

// The Amazon S3 properties of a connection.
type ConnectionPropertiesOutputMemberS3Properties struct {
	Value S3PropertiesOutput

	noSmithyDocumentSerde
}

func (*ConnectionPropertiesOutputMemberS3Properties) isConnectionPropertiesOutput() {}

// The Spark EMR properties of a connection.
type ConnectionPropertiesOutputMemberSparkEmrProperties struct {
	Value SparkEmrPropertiesOutput

	noSmithyDocumentSerde
}

func (*ConnectionPropertiesOutputMemberSparkEmrProperties) isConnectionPropertiesOutput() {}

// The Spark Amazon Web Services Glue properties of a connection.
type ConnectionPropertiesOutputMemberSparkGlueProperties struct {
	Value SparkGluePropertiesOutput

	noSmithyDocumentSerde
}

func (*ConnectionPropertiesOutputMemberSparkGlueProperties) isConnectionPropertiesOutput() {}

// The connection properties patch.
//
// The following types satisfy this interface:
//
//	ConnectionPropertiesPatchMemberAthenaProperties
//	ConnectionPropertiesPatchMemberGlueProperties
//	ConnectionPropertiesPatchMemberIamProperties
//	ConnectionPropertiesPatchMemberRedshiftProperties
//	ConnectionPropertiesPatchMemberS3Properties
//	ConnectionPropertiesPatchMemberSparkEmrProperties
type ConnectionPropertiesPatch interface {
	isConnectionPropertiesPatch()
}

// The Amazon Athena properties of a connection properties patch.
type ConnectionPropertiesPatchMemberAthenaProperties struct {
	Value AthenaPropertiesPatch

	noSmithyDocumentSerde
}

func (*ConnectionPropertiesPatchMemberAthenaProperties) isConnectionPropertiesPatch() {}

// The Amazon Web Services Glue properties of a connection properties patch.
type ConnectionPropertiesPatchMemberGlueProperties struct {
	Value GluePropertiesPatch

	noSmithyDocumentSerde
}

func (*ConnectionPropertiesPatchMemberGlueProperties) isConnectionPropertiesPatch() {}

// The IAM properties of a connection properties patch.
type ConnectionPropertiesPatchMemberIamProperties struct {
	Value IamPropertiesPatch

	noSmithyDocumentSerde
}

func (*ConnectionPropertiesPatchMemberIamProperties) isConnectionPropertiesPatch() {}

// The Amazon Redshift properties of a connection properties patch.
type ConnectionPropertiesPatchMemberRedshiftProperties struct {
	Value RedshiftPropertiesPatch

	noSmithyDocumentSerde
}

func (*ConnectionPropertiesPatchMemberRedshiftProperties) isConnectionPropertiesPatch() {}

// The Amazon S3 properties of a connection properties patch.
type ConnectionPropertiesPatchMemberS3Properties struct {
	Value S3PropertiesPatch

	noSmithyDocumentSerde
}

func (*ConnectionPropertiesPatchMemberS3Properties) isConnectionPropertiesPatch() {}

// The Spark EMR properties of a connection properties patch.
type ConnectionPropertiesPatchMemberSparkEmrProperties struct {
	Value SparkEmrPropertiesPatch

	noSmithyDocumentSerde
}

func (*ConnectionPropertiesPatchMemberSparkEmrProperties) isConnectionPropertiesPatch() {}

// The summary of a connection.
type ConnectionSummary struct {

	// The ID of a connection.
	//
	// This member is required.
	ConnectionId *string

	// The domain ID of a connection.
	//
	// This member is required.
	DomainId *string

	// The domain unit ID of a connection.
	//
	// This member is required.
	DomainUnitId *string

	// The connection name.
	//
	// This member is required.
	Name *string

	// The connection physical endpoints.
	//
	// This member is required.
	PhysicalEndpoints []PhysicalEndpoint

	// The connection type.
	//
	// This member is required.
	Type ConnectionType

	// The environment ID of a connection.
	EnvironmentId *string

	// The connection project ID.
	ProjectId *string

	// The connection props.
	Props ConnectionPropertiesOutput

	noSmithyDocumentSerde
}

// The details of the policy grant.
type CreateAssetTypePolicyGrantDetail struct {

	// Specifies whether the policy grant is applied to child domain units.
	IncludeChildDomainUnits *bool

	noSmithyDocumentSerde
}

// The details of the policy grant.
type CreateDomainUnitPolicyGrantDetail struct {

	// Specifies whether the policy grant is applied to child domain units.
	IncludeChildDomainUnits *bool

	noSmithyDocumentSerde
}

// The details of the policy grant.
type CreateEnvironmentProfilePolicyGrantDetail struct {

	// The ID of the domain unit.
	DomainUnitId *string

	noSmithyDocumentSerde
}

// The details of the policy grant.
type CreateFormTypePolicyGrantDetail struct {

	// Specifies whether the policy grant is applied to child domain units.
	IncludeChildDomainUnits *bool

	noSmithyDocumentSerde
}

// The details of the policy grant.
type CreateGlossaryPolicyGrantDetail struct {

	// Specifies whether the policy grant is applied to child domain units.
	IncludeChildDomainUnits *bool

	noSmithyDocumentSerde
}

// Specifies whether to create a project from project profile policy grant details.
type CreateProjectFromProjectProfilePolicyGrantDetail struct {

	// Specifies whether to include child domain units when creating a project from
	// project profile policy grant details
	IncludeChildDomainUnits *bool

	// Specifies project profiles when creating a project from project profile policy
	// grant details
	ProjectProfiles []string

	noSmithyDocumentSerde
}

// The details of the policy grant.
type CreateProjectPolicyGrantDetail struct {

	// Specifies whether the policy grant is applied to child domain units.
	IncludeChildDomainUnits *bool

	noSmithyDocumentSerde
}

// The custom Amazon Web Services Lambda handler within an account pool.
type CustomAccountPoolHandler struct {

	// The ARN of the Amazon Web Services Lambda function for the custom Amazon Web
	// Services Lambda handler.
	//
	// This member is required.
	LambdaFunctionArn *string

	// The ARN of the IAM role that enables Amazon SageMaker Unified Studio to invoke
	// the Amazon Web Services Lambda funtion if the account source is the custom
	// account pool handler.
	LambdaExecutionRoleArn *string

	noSmithyDocumentSerde
}

// The details of user parameters of an environment blueprint.
type CustomParameter struct {

	// The filed type of the parameter.
	//
	// This member is required.
	FieldType *string

	// The key name of the parameter.
	//
	// This member is required.
	KeyName *string

	// The default value of the parameter.
	DefaultValue *string

	// The description of the parameter.
	Description *string

	// Specifies whether the parameter is editable.
	IsEditable *bool

	// Specifies whether the custom parameter is optional.
	IsOptional *bool

	noSmithyDocumentSerde
}

// The data product.
type DataProductItem struct {

	// The ID of the data product.
	//
	// This member is required.
	Identifier *string

	// The type of the data product.
	//
	// This member is required.
	ItemType DataProductItemType

	// The glossary terms of the data product.
	GlossaryTerms []string

	// The revision of the data product.
	Revision *string

	noSmithyDocumentSerde
}

// The additional attributes of an Amazon DataZone data product.
type DataProductItemAdditionalAttributes struct {

	// List of rationales indicating why this item was matched by search.
	MatchRationale []MatchRationaleItem

	noSmithyDocumentSerde
}

// The data product listing.
type DataProductListing struct {

	// The timestamp at which the data product listing was created.
	CreatedAt *time.Time

	// The ID of the data product listing.
	DataProductId *string

	// The revision of the data product listing.
	DataProductRevision *string

	// The metadata forms of the data product listing.
	Forms *string

	// The glossary terms of the data product listing.
	GlossaryTerms []DetailedGlossaryTerm

	// The data assets of the data product listing.
	Items []ListingSummary

	// The ID of the owning project of the data product listing.
	OwningProjectId *string

	noSmithyDocumentSerde
}

// The asset of the data product listing.
type DataProductListingItem struct {

	// The additional attributes of the asset of the data product.
	AdditionalAttributes *DataProductListingItemAdditionalAttributes

	// The timestamp at which the asset of the data product listing was created.
	CreatedAt *time.Time

	// The description of the asset of the asset of the data product.
	Description *string

	// The entity ID of the asset of the asset of the data product.
	EntityId *string

	// The revision of the asset of the asset of the data product.
	EntityRevision *string

	// The glossary terms of the asset of the asset of the data product.
	GlossaryTerms []DetailedGlossaryTerm

	// The data of the asset of the data product.
	Items []ListingSummaryItem

	// The timestamp at which the listing was created.
	ListingCreatedBy *string

	// The ID of the listing.
	ListingId *string

	// The revision of the listing.
	ListingRevision *string

	// The user who updated the listing.
	ListingUpdatedBy *string

	// The name of the asset of the data product.
	Name *string

	// The ID of the owning project of the asset of the data product.
	OwningProjectId *string

	noSmithyDocumentSerde
}

// The additional attributes of the asset of the data product.
type DataProductListingItemAdditionalAttributes struct {

	// The metadata forms of the asset of the data product.
	Forms *string

	// List of rationales indicating why this item was matched by search.
	MatchRationale []MatchRationaleItem

	noSmithyDocumentSerde
}

// The data product.
type DataProductResultItem struct {

	// The ID of the domain where the data product lives.
	//
	// This member is required.
	DomainId *string

	// The ID of the data product.
	//
	// This member is required.
	Id *string

	// The name of the data product.
	//
	// This member is required.
	Name *string

	// The ID of the owning project of the data product.
	//
	// This member is required.
	OwningProjectId *string

	// The additional attributes of an Amazon DataZone data product.
	AdditionalAttributes *DataProductItemAdditionalAttributes

	// The timestamp at which the data product was created.
	CreatedAt *time.Time

	// The user who created the data product.
	CreatedBy *string

	// The description of the data product.
	Description *string

	// The timestamp at which first revision of the data product was created.
	FirstRevisionCreatedAt *time.Time

	// The user who created the first revision of the data product.
	FirstRevisionCreatedBy *string

	// The glossary terms of the data product.
	GlossaryTerms []string

	noSmithyDocumentSerde
}

// The data product revision.
type DataProductRevision struct {

	// The timestamp at which the data product revision was created.
	CreatedAt *time.Time

	// The user who created the data product revision.
	CreatedBy *string

	// The ID of the domain where the data product revision lives.
	DomainId *string

	// The ID of the data product revision.
	Id *string

	// The data product revision.
	Revision *string

	noSmithyDocumentSerde
}

// The configuration of the data source.
//
// The following types satisfy this interface:
//
//	DataSourceConfigurationInputMemberGlueRunConfiguration
//	DataSourceConfigurationInputMemberRedshiftRunConfiguration
//	DataSourceConfigurationInputMemberSageMakerRunConfiguration
type DataSourceConfigurationInput interface {
	isDataSourceConfigurationInput()
}

// The configuration of the Amazon Web Services Glue data source.
type DataSourceConfigurationInputMemberGlueRunConfiguration struct {
	Value GlueRunConfigurationInput

	noSmithyDocumentSerde
}

func (*DataSourceConfigurationInputMemberGlueRunConfiguration) isDataSourceConfigurationInput() {}

// The configuration of the Amazon Redshift data source.
type DataSourceConfigurationInputMemberRedshiftRunConfiguration struct {
	Value RedshiftRunConfigurationInput

	noSmithyDocumentSerde
}

func (*DataSourceConfigurationInputMemberRedshiftRunConfiguration) isDataSourceConfigurationInput() {}

// The Amazon SageMaker run configuration.
type DataSourceConfigurationInputMemberSageMakerRunConfiguration struct {
	Value SageMakerRunConfigurationInput

	noSmithyDocumentSerde
}

func (*DataSourceConfigurationInputMemberSageMakerRunConfiguration) isDataSourceConfigurationInput() {
}

// The configuration of the data source.
//
// The following types satisfy this interface:
//
//	DataSourceConfigurationOutputMemberGlueRunConfiguration
//	DataSourceConfigurationOutputMemberRedshiftRunConfiguration
//	DataSourceConfigurationOutputMemberSageMakerRunConfiguration
type DataSourceConfigurationOutput interface {
	isDataSourceConfigurationOutput()
}

// The configuration of the Amazon Web Services Glue data source.
type DataSourceConfigurationOutputMemberGlueRunConfiguration struct {
	Value GlueRunConfigurationOutput

	noSmithyDocumentSerde
}

func (*DataSourceConfigurationOutputMemberGlueRunConfiguration) isDataSourceConfigurationOutput() {}

// The configuration of the Amazon Redshift data source.
type DataSourceConfigurationOutputMemberRedshiftRunConfiguration struct {
	Value RedshiftRunConfigurationOutput

	noSmithyDocumentSerde
}

func (*DataSourceConfigurationOutputMemberRedshiftRunConfiguration) isDataSourceConfigurationOutput() {
}

// The Amazon SageMaker run configuration.
type DataSourceConfigurationOutputMemberSageMakerRunConfiguration struct {
	Value SageMakerRunConfigurationOutput

	noSmithyDocumentSerde
}

func (*DataSourceConfigurationOutputMemberSageMakerRunConfiguration) isDataSourceConfigurationOutput() {
}

// The details of the error message that is returned if the operation cannot be
// successfully completed.
type DataSourceErrorMessage struct {

	// The type of the error message that is returned if the operation cannot be
	// successfully completed.
	//
	// This member is required.
	ErrorType DataSourceErrorType

	// The details of the error message that is returned if the operation cannot be
	// successfully completed.
	ErrorDetail *string

	noSmithyDocumentSerde
}

// The activity details of the data source run.
type DataSourceRunActivity struct {

	// The timestamp of when data source run activity was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The status of the asset included in the data source run activity.
	//
	// This member is required.
	DataAssetStatus DataAssetActivityStatus

	// The identifier of the data source for the data source run activity.
	//
	// This member is required.
	DataSourceRunId *string

	// The database included in the data source run activity.
	//
	// This member is required.
	Database *string

	// The project ID included in the data source run activity.
	//
	// This member is required.
	ProjectId *string

	// The technical name included in the data source run activity.
	//
	// This member is required.
	TechnicalName *string

	// The timestamp of when data source run activity was updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The identifier of the asset included in the data source run activity.
	DataAssetId *string

	// The details of the error message that is returned if the operation cannot be
	// successfully completed.
	ErrorMessage *DataSourceErrorMessage

	// The data lineage summary.
	LineageSummary *LineageInfo

	// The technical description included in the data source run activity.
	TechnicalDescription *string

	noSmithyDocumentSerde
}

// The run lineage summary of a data source.
type DataSourceRunLineageSummary struct {

	// The import status that's part of the run lineage summary of a data source.
	ImportStatus LineageImportStatus

	noSmithyDocumentSerde
}

// The details of a data source run.
type DataSourceRunSummary struct {

	// The timestamp of when a data source run was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The identifier of the data source of the data source run.
	//
	// This member is required.
	DataSourceId *string

	// The identifier of the data source run.
	//
	// This member is required.
	Id *string

	// The project ID of the data source run.
	//
	// This member is required.
	ProjectId *string

	// The status of the data source run.
	//
	// This member is required.
	Status DataSourceRunStatus

	// The type of the data source run.
	//
	// This member is required.
	Type DataSourceRunType

	// The timestamp of when a data source run was updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The details of the error message that is returned if the operation cannot be
	// successfully completed.
	ErrorMessage *DataSourceErrorMessage

	// The run lineage summary of a data source.
	LineageSummary *DataSourceRunLineageSummary

	// The asset statistics from the data source run.
	RunStatisticsForAssets *RunStatisticsForAssets

	// The timestamp of when a data source run was started.
	StartedAt *time.Time

	// The timestamp of when a data source run was stopped.
	StoppedAt *time.Time

	noSmithyDocumentSerde
}

// The details of the data source.
type DataSourceSummary struct {

	// The ID of the data source.
	//
	// This member is required.
	DataSourceId *string

	// The ID of the Amazon DataZone domain in which the data source exists.
	//
	// This member is required.
	DomainId *string

	// The name of the data source.
	//
	// This member is required.
	Name *string

	// The status of the data source.
	//
	// This member is required.
	Status DataSourceStatus

	// The type of the data source.
	//
	// This member is required.
	Type *string

	// The connection ID that's part of the data source summary.
	ConnectionId *string

	// The timestamp of when the data source was created.
	CreatedAt *time.Time

	// The data source description.
	Description *string

	// Specifies whether the data source is enabled.
	EnableSetting EnableSetting

	// The ID of the environment in which the data source exists.
	EnvironmentId *string

	// The count of the assets created during the last data source run.
	LastRunAssetCount *int32

	// The timestamp of when the data source run was last performed.
	LastRunAt *time.Time

	// The details of the error message that is returned if the operation cannot be
	// successfully completed.
	LastRunErrorMessage *DataSourceErrorMessage

	// The status of the last data source run.
	LastRunStatus DataSourceRunStatus

	// The details of the schedule of the data source runs.
	Schedule *ScheduleConfiguration

	// The timestamp of when the data source was updated.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// The details of the last deployment of the environment.
type Deployment struct {

	// The identifier of the last deployment of the environment.
	DeploymentId *string

	// The status of the last deployment of the environment.
	DeploymentStatus DeploymentStatus

	// The type of the last deployment of the environment.
	DeploymentType DeploymentType

	// The failure reason of the last deployment of the environment.
	FailureReason *EnvironmentError

	// Specifies whether the last deployment of the environment is complete.
	IsDeploymentComplete *bool

	// The messages of the last deployment of the environment.
	Messages []string

	noSmithyDocumentSerde
}

// The deployment properties of the Amazon DataZone blueprint.
type DeploymentProperties struct {

	// The end timeout of the environment blueprint deployment.
	EndTimeoutMinutes *int32

	// The start timeout of the environment blueprint deployment.
	StartTimeoutMinutes *int32

	noSmithyDocumentSerde
}

// Details of a glossary term attached to the inventory asset.
type DetailedGlossaryTerm struct {

	// The name of a glossary term attached to the inventory asset.
	Name *string

	// The shoft description of a glossary term attached to the inventory asset.
	ShortDescription *string

	noSmithyDocumentSerde
}

// A summary of a Amazon DataZone domain.
type DomainSummary struct {

	// The ARN of the Amazon DataZone domain.
	//
	// This member is required.
	Arn *string

	// A timestamp of when a Amazon DataZone domain was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The ID of the Amazon DataZone domain.
	//
	// This member is required.
	Id *string

	// The identifier of the Amazon Web Services account that manages the domain.
	//
	// This member is required.
	ManagedAccountId *string

	// A name of an Amazon DataZone domain.
	//
	// This member is required.
	Name *string

	// The status of the Amazon DataZone domain.
	//
	// This member is required.
	Status DomainStatus

	// A description of an Amazon DataZone domain.
	Description *string

	// The domain version.
	DomainVersion DomainVersion

	// A timestamp of when a Amazon DataZone domain was last updated.
	LastUpdatedAt *time.Time

	// The data portal URL for the Amazon DataZone domain.
	PortalUrl *string

	noSmithyDocumentSerde
}

// The domain unit filter of the project grant filter.
type DomainUnitFilterForProject struct {

	// The domain unit ID to use in the filter.
	//
	// This member is required.
	DomainUnit *string

	// Specifies whether to include child domain units.
	IncludeChildDomainUnits *bool

	noSmithyDocumentSerde
}

// The grant filter for the domain unit. In the current release of Amazon
// DataZone, the only supported filter is the allDomainUnitsGrantFilter .
//
// The following types satisfy this interface:
//
//	DomainUnitGrantFilterMemberAllDomainUnitsGrantFilter
type DomainUnitGrantFilter interface {
	isDomainUnitGrantFilter()
}

// Specifies a grant filter containing all domain units.
type DomainUnitGrantFilterMemberAllDomainUnitsGrantFilter struct {
	Value AllDomainUnitsGrantFilter

	noSmithyDocumentSerde
}

func (*DomainUnitGrantFilterMemberAllDomainUnitsGrantFilter) isDomainUnitGrantFilter() {}

// The properties of a domain unit group.
type DomainUnitGroupProperties struct {

	// The ID of the domain unit group.
	GroupId *string

	noSmithyDocumentSerde
}

// The properties of the domain unit owner.
//
// The following types satisfy this interface:
//
//	DomainUnitOwnerPropertiesMemberGroup
//	DomainUnitOwnerPropertiesMemberUser
type DomainUnitOwnerProperties interface {
	isDomainUnitOwnerProperties()
}

// Indicates that the domain unit owner is a group.
type DomainUnitOwnerPropertiesMemberGroup struct {
	Value DomainUnitGroupProperties

	noSmithyDocumentSerde
}

func (*DomainUnitOwnerPropertiesMemberGroup) isDomainUnitOwnerProperties() {}

// Indicates that the domain unit owner is a user.
type DomainUnitOwnerPropertiesMemberUser struct {
	Value DomainUnitUserProperties

	noSmithyDocumentSerde
}

func (*DomainUnitOwnerPropertiesMemberUser) isDomainUnitOwnerProperties() {}

// The domain unit principal to whom the policy is granted.
type DomainUnitPolicyGrantPrincipal struct {

	// Specifes the designation of the domain unit users.
	//
	// This member is required.
	DomainUnitDesignation DomainUnitDesignation

	// The grant filter for the domain unit.
	DomainUnitGrantFilter DomainUnitGrantFilter

	// The ID of the domain unit.
	DomainUnitIdentifier *string

	noSmithyDocumentSerde
}

// The summary of the domain unit.
type DomainUnitSummary struct {

	// The ID of the domain unit summary.
	//
	// This member is required.
	Id *string

	// The name of the domain unit summary.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// The target for the domain unit.
type DomainUnitTarget struct {

	// The ID of the domain unit.
	//
	// This member is required.
	DomainUnitId *string

	// Specifies whether to apply a rule to the child domain units.
	IncludeChildDomainUnits *bool

	noSmithyDocumentSerde
}

// The properties of the domain unit user.
type DomainUnitUserProperties struct {

	// The ID of teh domain unit user.
	UserId *string

	noSmithyDocumentSerde
}

// The details about the specified action configured for an environment. For
// example, the details of the specified console links for an analytics tool that
// is available in this environment.
type EnvironmentActionSummary struct {

	// The Amazon DataZone domain ID of the environment action.
	//
	// This member is required.
	DomainId *string

	// The environment ID of the environment action.
	//
	// This member is required.
	EnvironmentId *string

	// The ID of the environment action.
	//
	// This member is required.
	Id *string

	// The name of the environment action.
	//
	// This member is required.
	Name *string

	// The parameters of the environment action.
	//
	// This member is required.
	Parameters ActionParameters

	// The environment action description.
	Description *string

	noSmithyDocumentSerde
}

// The configuration details of an environment blueprint.
type EnvironmentBlueprintConfigurationItem struct {

	// The identifier of the Amazon DataZone domain in which an environment blueprint
	// exists.
	//
	// This member is required.
	DomainId *string

	// The identifier of the environment blueprint.
	//
	// This member is required.
	EnvironmentBlueprintId *string

	// The timestamp of when an environment blueprint was created.
	CreatedAt *time.Time

	// The enabled Amazon Web Services Regions specified in a blueprint configuration.
	EnabledRegions []string

	// The environment role permission boundary.
	EnvironmentRolePermissionBoundary *string

	// The ARN of the manage access role specified in the environment blueprint
	// configuration.
	ManageAccessRoleArn *string

	// The provisioning configuration of a blueprint.
	ProvisioningConfigurations []ProvisioningConfiguration

	// The ARN of the provisioning role specified in the environment blueprint
	// configuration.
	ProvisioningRoleArn *string

	// The regional parameters of the environment blueprint.
	RegionalParameters map[string]map[string]string

	// The timestamp of when the environment blueprint was updated.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// The details of an environment blueprint summary.
type EnvironmentBlueprintSummary struct {

	// The identifier of the blueprint.
	//
	// This member is required.
	Id *string

	// The name of the blueprint.
	//
	// This member is required.
	Name *string

	// The provider of the blueprint.
	//
	// This member is required.
	Provider *string

	// The provisioning properties of the blueprint.
	//
	// This member is required.
	ProvisioningProperties ProvisioningProperties

	// The timestamp of when an environment blueprint was created.
	CreatedAt *time.Time

	// The description of a blueprint.
	Description *string

	// The timestamp of when the blueprint was enabled.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// The configuration of an environment.
type EnvironmentConfiguration struct {

	// The environment blueprint ID.
	//
	// This member is required.
	EnvironmentBlueprintId *string

	// The environment name.
	//
	// This member is required.
	Name *string

	// The account pools used by a custom project profile.
	AccountPools []string

	// The Amazon Web Services account of the environment.
	AwsAccount AwsAccount

	// The Amazon Web Services Region of the environment.
	AwsRegion Region

	// The configuration parameters of the environment.
	ConfigurationParameters *EnvironmentConfigurationParametersDetails

	// The deployment mode of the environment.
	DeploymentMode DeploymentMode

	// The deployment order of the environment.
	DeploymentOrder *int32

	// The environment description.
	Description *string

	// The environment ID.
	Id *string

	noSmithyDocumentSerde
}

// The environment configuration parameter.
type EnvironmentConfigurationParameter struct {

	// Specifies whether the environment parameter is editable.
	IsEditable *bool

	// The name of the environment configuration parameter.
	Name *string

	// The value of the environment configuration parameter.
	Value *string

	noSmithyDocumentSerde
}

// The details of the environment configuration parameter.
type EnvironmentConfigurationParametersDetails struct {

	// The parameter overrides.
	ParameterOverrides []EnvironmentConfigurationParameter

	// The resolved environment configuration parameters.
	ResolvedParameters []EnvironmentConfigurationParameter

	// Ssm path environment configuration parameters.
	SsmPath *string

	noSmithyDocumentSerde
}

// The environment configuration user parameters.
type EnvironmentConfigurationUserParameter struct {

	// The environment configuration name.
	EnvironmentConfigurationName *string

	// The ID of the environment.
	EnvironmentId *string

	// The environment parameters.
	EnvironmentParameters []EnvironmentParameter

	// Specifies the account/Region that is to be used during project creation for a
	// particular blueprint.
	EnvironmentResolvedAccount *EnvironmentResolvedAccount

	noSmithyDocumentSerde
}

// The environment deployment details.
type EnvironmentDeploymentDetails struct {

	// Environment failure reasons.
	EnvironmentFailureReasons map[string][]EnvironmentError

	// The overall deployment status of the environment.
	OverallDeploymentStatus OverallDeploymentStatus

	noSmithyDocumentSerde
}

// The failure reasons for the environment deployment.
type EnvironmentError struct {

	// The error message for the failure reason for the environment deployment.
	//
	// This member is required.
	Message *string

	// The error code for the failure reason for the environment deployment.
	Code *string

	noSmithyDocumentSerde
}

// The parameter details of an evironment profile.
type EnvironmentParameter struct {

	// The name of an environment profile parameter.
	Name *string

	// The value of an environment profile parameter.
	Value *string

	noSmithyDocumentSerde
}

// The details of an environment profile.
type EnvironmentProfileSummary struct {

	// The Amazon DataZone user who created the environment profile.
	//
	// This member is required.
	CreatedBy *string

	// The identifier of the Amazon DataZone domain in which the environment profile
	// exists.
	//
	// This member is required.
	DomainId *string

	// The identifier of a blueprint with which an environment profile is created.
	//
	// This member is required.
	EnvironmentBlueprintId *string

	// The identifier of the environment profile.
	//
	// This member is required.
	Id *string

	// The name of the environment profile.
	//
	// This member is required.
	Name *string

	// The identifier of an Amazon Web Services account in which an environment
	// profile exists.
	AwsAccountId *string

	// The Amazon Web Services Region in which an environment profile exists.
	AwsAccountRegion *string

	// The timestamp of when an environment profile was created.
	CreatedAt *time.Time

	// The description of the environment profile.
	Description *string

	// The identifier of a project in which an environment profile exists.
	ProjectId *string

	// The timestamp of when the environment profile was updated.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// Specifies the account/Region that is to be used during project creation for a
// particular blueprint.
type EnvironmentResolvedAccount struct {

	// The ID of the resolved account.
	//
	// This member is required.
	AwsAccountId *string

	// The name of the resolved Region.
	//
	// This member is required.
	RegionName *string

	// The ID of the account pool.
	SourceAccountPoolId *string

	noSmithyDocumentSerde
}

// The details of an environment.
type EnvironmentSummary struct {

	// The Amazon DataZone user who created the environment.
	//
	// This member is required.
	CreatedBy *string

	// The identifier of the Amazon DataZone domain in which the environment exists.
	//
	// This member is required.
	DomainId *string

	// The name of the environment.
	//
	// This member is required.
	Name *string

	// The identifier of the project in which the environment exists.
	//
	// This member is required.
	ProjectId *string

	// The provider of the environment.
	//
	// This member is required.
	Provider *string

	// The identifier of the Amazon Web Services account in which an environment
	// exists.
	AwsAccountId *string

	// The Amazon Web Services Region in which an environment exists.
	AwsAccountRegion *string

	// The timestamp of when the environment was created.
	CreatedAt *time.Time

	// The description of the environment.
	Description *string

	// The configuration ID with which the environment is created.
	EnvironmentConfigurationId *string

	// The identifier of the environment profile with which the environment was
	// created.
	EnvironmentProfileId *string

	// The identifier of the environment.
	Id *string

	// The status of the environment.
	Status EnvironmentStatus

	// The timestamp of when the environment was updated.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// Specifies whether the value is equal to an expression.
type EqualToExpression struct {

	// The name of the column.
	//
	// This member is required.
	ColumnName *string

	// The value that might be equal to an expression.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// The event summary.
//
// The following types satisfy this interface:
//
//	EventSummaryMemberOpenLineageRunEventSummary
type EventSummary interface {
	isEventSummary()
}

// The open lineage run event summary.
type EventSummaryMemberOpenLineageRunEventSummary struct {
	Value OpenLineageRunEventSummary

	noSmithyDocumentSerde
}

func (*EventSummaryMemberOpenLineageRunEventSummary) isEventSummary() {}

// Specifies the error message that is returned if the operation cannot be
// successfully completed.
type FailureCause struct {

	// The description of the error message.
	Message *string

	noSmithyDocumentSerde
}

// A search filter in Amazon DataZone.
type Filter struct {

	// A search filter attribute in Amazon DataZone.
	//
	// This member is required.
	Attribute *string

	// A search filter value in Amazon DataZone.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// A search filter clause in Amazon DataZone.
//
// The following types satisfy this interface:
//
//	FilterClauseMemberAnd
//	FilterClauseMemberFilter
//	FilterClauseMemberOr
type FilterClause interface {
	isFilterClause()
}

// The 'and' search filter clause in Amazon DataZone.
type FilterClauseMemberAnd struct {
	Value []FilterClause

	noSmithyDocumentSerde
}

func (*FilterClauseMemberAnd) isFilterClause() {}

// A search filter in Amazon DataZone.
type FilterClauseMemberFilter struct {
	Value Filter

	noSmithyDocumentSerde
}

func (*FilterClauseMemberFilter) isFilterClause() {}

// The 'or' search filter clause in Amazon DataZone.
type FilterClauseMemberOr struct {
	Value []FilterClause

	noSmithyDocumentSerde
}

func (*FilterClauseMemberOr) isFilterClause() {}

// A filter expression in Amazon DataZone.
type FilterExpression struct {

	// The search filter expression.
	//
	// This member is required.
	Expression *string

	// The search filter explresison type.
	//
	// This member is required.
	Type FilterExpressionType

	noSmithyDocumentSerde
}

// The details of the form entry.
type FormEntryInput struct {

	// The type ID of the form entry.
	//
	// This member is required.
	TypeIdentifier *string

	// The type revision of the form entry.
	//
	// This member is required.
	TypeRevision *string

	// Specifies whether a form entry is required.
	Required *bool

	noSmithyDocumentSerde
}

// The details of the form entry.
type FormEntryOutput struct {

	// The name of the type of the form entry.
	//
	// This member is required.
	TypeName *string

	// The type revision of the form entry.
	//
	// This member is required.
	TypeRevision *string

	// Specifies whether a form entry is required.
	Required *bool

	noSmithyDocumentSerde
}

// The details of a metadata form.
type FormInput struct {

	// The name of the metadata form.
	//
	// This member is required.
	FormName *string

	// The content of the metadata form.
	Content *string

	// The ID of the metadata form type.
	TypeIdentifier *string

	// The revision of the metadata form type.
	TypeRevision *string

	noSmithyDocumentSerde
}

// The details of a metadata form.
type FormOutput struct {

	// The name of the metadata form.
	//
	// This member is required.
	FormName *string

	// The content of the metadata form.
	Content *string

	// The name of the metadata form type.
	TypeName *string

	// The revision of the metadata form type.
	TypeRevision *string

	noSmithyDocumentSerde
}

// The details of the metadata form type.
type FormTypeData struct {

	// The identifier of the Amazon DataZone domain in which the form type exists.
	//
	// This member is required.
	DomainId *string

	// The name of the form type.
	//
	// This member is required.
	Name *string

	// The revision of the form type.
	//
	// This member is required.
	Revision *string

	// The timestamp of when the metadata form type was created.
	CreatedAt *time.Time

	// The Amazon DataZone user who created teh metadata form type.
	CreatedBy *string

	// The description of the metadata form type.
	Description *string

	// The imports specified in the form type.
	Imports []Import

	// The model of the form type.
	Model Model

	// The identifier of the Amazon DataZone domain in which the form type was
	// originally created.
	OriginDomainId *string

	// The identifier of the project in which the form type was originally created.
	OriginProjectId *string

	// The identifier of the project that owns the form type.
	OwningProjectId *string

	// The status of the form type.
	Status FormTypeStatus

	noSmithyDocumentSerde
}

// The details of a business glossary.
type GlossaryItem struct {

	// The identifier of the Amazon DataZone domain in which the business glossary
	// exists.
	//
	// This member is required.
	DomainId *string

	// The identifier of the glossary.
	//
	// This member is required.
	Id *string

	// The name of the glossary.
	//
	// This member is required.
	Name *string

	// The identifier of the project that owns the business glosary.
	//
	// This member is required.
	OwningProjectId *string

	// The business glossary status.
	//
	// This member is required.
	Status GlossaryStatus

	// The additional attributes of an Amazon DataZone glossary.
	AdditionalAttributes *GlossaryItemAdditionalAttributes

	// The timestamp of when the glossary was created.
	CreatedAt *time.Time

	// The Amazon DataZone user who created the glossary.
	CreatedBy *string

	// The business glossary description.
	Description *string

	// The timestamp of when the business glossary was updated.
	UpdatedAt *time.Time

	// The Amazon DataZone user who updated the business glossary.
	UpdatedBy *string

	// The usage restrictions associated with a goverened glossary term.
	UsageRestrictions []GlossaryUsageRestriction

	noSmithyDocumentSerde
}

// The additional attributes of an Amazon DataZone glossary.
type GlossaryItemAdditionalAttributes struct {

	// List of rationales indicating why this item was matched by search.
	MatchRationale []MatchRationaleItem

	noSmithyDocumentSerde
}

// The details of a business glossary term.
type GlossaryTermItem struct {

	// The identifier of the Amazon DataZone domain in which the business glossary
	// exists.
	//
	// This member is required.
	DomainId *string

	// The identifier of the business glossary to which the term belongs.
	//
	// This member is required.
	GlossaryId *string

	// The identifier of the business glossary term.
	//
	// This member is required.
	Id *string

	// The name of the business glossary term.
	//
	// This member is required.
	Name *string

	// The status of the business glossary term.
	//
	// This member is required.
	Status GlossaryTermStatus

	// The additional attributes of an Amazon DataZone glossary term.
	AdditionalAttributes *GlossaryTermItemAdditionalAttributes

	// The timestamp of when a business glossary term was created.
	CreatedAt *time.Time

	// The Amazon DataZone user who created the business glossary.
	CreatedBy *string

	// The long description of the business glossary term.
	LongDescription *string

	// The short description of the business glossary term.
	ShortDescription *string

	// The relations of the business glossary term.
	TermRelations *TermRelations

	// The timestamp of when a business glossary term was updated.
	UpdatedAt *time.Time

	// The Amazon DataZone user who updated the business glossary term.
	UpdatedBy *string

	// The usage restrictions associated with a goverened glossary term.
	UsageRestrictions []GlossaryUsageRestriction

	noSmithyDocumentSerde
}

// The additional attributes of an Amazon DataZone glossary term.
type GlossaryTermItemAdditionalAttributes struct {

	// List of rationales indicating why this item was matched by search.
	MatchRationale []MatchRationaleItem

	noSmithyDocumentSerde
}

// The Amazon Web Services Glue connection.
type GlueConnection struct {

	// The Amazon Athena properties of the Amazon Web Services Glue connection.
	AthenaProperties map[string]string

	// The authentication configuration of the Amazon Web Services Glue connection.
	AuthenticationConfiguration *AuthenticationConfiguration

	// The compatible compute environments of the Amazon Web Services Glue connection.
	CompatibleComputeEnvironments []ComputeEnvironments

	// The properties of the Amazon Web Services Glue connection.
	ConnectionProperties map[string]string

	// The connection schema version of the Amazon Web Services Glue connection.
	ConnectionSchemaVersion *int32

	// The type of the Amazon Web Services Glue connection.
	ConnectionType ConnectionType

	// The creation time of the Amazon Web Services Glue connection.
	CreationTime *time.Time

	// The description of the Amazon Web Services Glue connection.
	Description *string

	// The last validation time of the Amazon Web Services Glue connection.
	LastConnectionValidationTime *time.Time

	// The user who last updated the Amazon Web Services Glue connection.
	LastUpdatedBy *string

	// The timestamp at which the Amazon Web Services Glue connection was last updated.
	LastUpdatedTime *time.Time

	// The match criteria of the Amazon Web Services Glue connection.
	MatchCriteria []string

	// The name of the Amazon Web Services Glue connection.
	Name *string

	// The physical connection requirements of the Amazon Web Services Glue connection.
	PhysicalConnectionRequirements *PhysicalConnectionRequirements

	// The Python properties of the Amazon Web Services Glue connection.
	PythonProperties map[string]string

	// The Spark properties of the Amazon Web Services Glue connection.
	SparkProperties map[string]string

	// The status of the Amazon Web Services Glue connection.
	Status ConnectionStatus

	// The status reason of the Amazon Web Services Glue connection.
	StatusReason *string

	noSmithyDocumentSerde
}

// The Amazon Web Services Glue connecton input.
type GlueConnectionInput struct {

	// The Amazon Athena properties of the Amazon Web Services Glue connection.
	AthenaProperties map[string]string

	// The authentication configuration of the Amazon Web Services Glue connection.
	AuthenticationConfiguration *AuthenticationConfigurationInput

	// The connection properties of the Amazon Web Services Glue connection.
	ConnectionProperties map[string]string

	// The connection type of the Amazon Web Services Glue connection.
	ConnectionType GlueConnectionType

	// The description of the Amazon Web Services Glue connection.
	Description *string

	// The match criteria of the Amazon Web Services Glue connection.
	MatchCriteria *string

	// The name of the Amazon Web Services Glue connection.
	Name *string

	// The physical connection requirements for the Amazon Web Services Glue
	// connection.
	PhysicalConnectionRequirements *PhysicalConnectionRequirements

	// The Python properties of the Amazon Web Services Glue connection.
	PythonProperties map[string]string

	// The Spark properties of the Amazon Web Services Glue connection.
	SparkProperties map[string]string

	// Speciefies whether to validate credentials of the Amazon Web Services Glue
	// connection.
	ValidateCredentials *bool

	// Speciefies whether to validate for compute environments of the Amazon Web
	// Services Glue connection.
	ValidateForComputeEnvironments []ComputeEnvironments

	noSmithyDocumentSerde
}

// The Amazon Web Services Glue connection patch.
type GlueConnectionPatch struct {

	// The authentication configuration of the Amazon Web Services Glue connection
	// patch.
	AuthenticationConfiguration *AuthenticationConfigurationPatch

	// The properties of the Amazon Web Services Glue connection patch.
	ConnectionProperties map[string]string

	// The description of the Amazon Web Services Glue connection patch.
	Description *string

	noSmithyDocumentSerde
}

// The GlueOAuth2 credentials of a connection.
type GlueOAuth2Credentials struct {

	// The access token of a connection.
	AccessToken *string

	// The jwt token of the connection.
	JwtToken *string

	// The refresh token of the connection.
	RefreshToken *string

	// The user managed client application client secret of the connection.
	UserManagedClientApplicationClientSecret *string

	noSmithyDocumentSerde
}

// The Amazon Web Services Glue properties of a connection.
type GluePropertiesInput struct {

	// The Amazon Web Services Glue connection.
	GlueConnectionInput *GlueConnectionInput

	noSmithyDocumentSerde
}

// The properties of the Amazon Web Services Glue connection.
type GluePropertiesOutput struct {

	// The error message generated if the action is not completed successfully.
	ErrorMessage *string

	// The status of a connection.
	Status ConnectionStatus

	noSmithyDocumentSerde
}

// The Amazon Web Services Glue properties patch of a connection.
type GluePropertiesPatch struct {

	// The Amazon Web Services Glue properties patch of a connection.
	GlueConnectionInput *GlueConnectionPatch

	noSmithyDocumentSerde
}

// The configuration details of the Amazon Web Services Glue data source.
type GlueRunConfigurationInput struct {

	// The relational filter configurations included in the configuration details of
	// the Amazon Web Services Glue data source.
	//
	// This member is required.
	RelationalFilterConfigurations []RelationalFilterConfiguration

	// Specifies whether to automatically import data quality metrics as part of the
	// data source run.
	AutoImportDataQualityResult *bool

	// The catalog name in the Amazon Web Services Glue run configuration.
	CatalogName *string

	// The data access role included in the configuration details of the Amazon Web
	// Services Glue data source.
	DataAccessRole *string

	noSmithyDocumentSerde
}

// The configuration details of the Amazon Web Services Glue data source.
type GlueRunConfigurationOutput struct {

	// The relational filter configurations included in the configuration details of
	// the Amazon Web Services Glue data source.
	//
	// This member is required.
	RelationalFilterConfigurations []RelationalFilterConfiguration

	// The Amazon Web Services account ID included in the configuration details of the
	// Amazon Web Services Glue data source.
	AccountId *string

	// Specifies whether to automatically import data quality metrics as part of the
	// data source run.
	AutoImportDataQualityResult *bool

	// The catalog name in the Amazon Web Services Glue run configuration.
	CatalogName *string

	// The data access role included in the configuration details of the Amazon Web
	// Services Glue data source.
	DataAccessRole *string

	// The Amazon Web Services region included in the configuration details of the
	// Amazon Web Services Glue data source.
	Region *string

	noSmithyDocumentSerde
}

// The details of the self granting status.
type GlueSelfGrantStatusOutput struct {

	// The details for the self granting status for a Glue data source.
	//
	// This member is required.
	SelfGrantStatusDetails []SelfGrantStatusDetail

	noSmithyDocumentSerde
}

// The details of a listing for which a subscription is granted.
//
// The following types satisfy this interface:
//
//	GrantedEntityMemberListing
type GrantedEntity interface {
	isGrantedEntity()
}

// The listing for which a subscription is granted.
type GrantedEntityMemberListing struct {
	Value ListingRevision

	noSmithyDocumentSerde
}

func (*GrantedEntityMemberListing) isGrantedEntity() {}

// The details of a listing for which a subscription is to be granted.
//
// The following types satisfy this interface:
//
//	GrantedEntityInputMemberListing
type GrantedEntityInput interface {
	isGrantedEntityInput()
}

// The listing for which a subscription is to be granted.
type GrantedEntityInputMemberListing struct {
	Value ListingRevisionInput

	noSmithyDocumentSerde
}

func (*GrantedEntityInputMemberListing) isGrantedEntityInput() {}

// Specifies whether the value is greater than an expression.
type GreaterThanExpression struct {

	// The name of the column.
	//
	// This member is required.
	ColumnName *string

	// The value that might be greater than an expression.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// Specifies whether the value is greater than or equal to an expression.
type GreaterThanOrEqualToExpression struct {

	// The name of the column.
	//
	// This member is required.
	ColumnName *string

	// The value that might be greater than or equal to an expression.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// The details of a group in Amazon DataZone.
type GroupDetails struct {

	// The identifier of the group in Amazon DataZone.
	//
	// This member is required.
	GroupId *string

	noSmithyDocumentSerde
}

// The group principal to whom the policy is granted.
//
// The following types satisfy this interface:
//
//	GroupPolicyGrantPrincipalMemberGroupIdentifier
type GroupPolicyGrantPrincipal interface {
	isGroupPolicyGrantPrincipal()
}

// The ID Of the group of the group principal.
type GroupPolicyGrantPrincipalMemberGroupIdentifier struct {
	Value string

	noSmithyDocumentSerde
}

func (*GroupPolicyGrantPrincipalMemberGroupIdentifier) isGroupPolicyGrantPrincipal() {}

// The details of a group profile.
type GroupProfileSummary struct {

	// The ID of the Amazon DataZone domain of a group profile.
	DomainId *string

	// The group name of a group profile.
	GroupName *string

	// The ID of a group profile.
	Id *string

	// The status of a group profile.
	Status GroupProfileStatus

	noSmithyDocumentSerde
}

// The hyper pod properties of a Amazon Web Services Glue properties patch.
type HyperPodPropertiesInput struct {

	// The cluster name the hyper pod properties.
	//
	// This member is required.
	ClusterName *string

	noSmithyDocumentSerde
}

// The hyper pod properties of a Amazon Web Services Glue properties patch.
type HyperPodPropertiesOutput struct {

	// The cluster name the hyper pod properties.
	//
	// This member is required.
	ClusterName *string

	// The cluster ARN of the hyper pod properties.
	ClusterArn *string

	// The orchestrator of the hyper pod properties.
	Orchestrator HyperPodOrchestrator

	noSmithyDocumentSerde
}

// The IAM properties of a connection.
type IamPropertiesInput struct {

	// Specifies whether Amazon Web Services Glue lineage sync is enabled for a
	// connection.
	GlueLineageSyncEnabled *bool

	noSmithyDocumentSerde
}

// The IAM properties of a connection.
type IamPropertiesOutput struct {

	// The environment ID of the connection.
	EnvironmentId *string

	// Specifies whether Amazon Web Services Glue lineage sync is enabled for a
	// connection.
	GlueLineageSyncEnabled *bool

	noSmithyDocumentSerde
}

// The IAM properties patch of a connection.
type IamPropertiesPatch struct {

	// Specifies whether Amazon Web Services Glue lineage sync is enabled for a
	// connection.
	GlueLineageSyncEnabled *bool

	noSmithyDocumentSerde
}

// The details of an IAM user profile in Amazon DataZone.
type IamUserProfileDetails struct {

	// The ARN of an IAM user profile in Amazon DataZone.
	Arn *string

	noSmithyDocumentSerde
}

// The details of the import of the metadata form type.
type Import struct {

	// The name of the import.
	//
	// This member is required.
	Name *string

	// The revision of the import.
	//
	// This member is required.
	Revision *string

	noSmithyDocumentSerde
}

// Specifies whether values are in the expression.
type InExpression struct {

	// The name of the column.
	//
	// This member is required.
	ColumnName *string

	// The values that might be in the expression.
	//
	// This member is required.
	Values []string

	noSmithyDocumentSerde
}

// Specifies that the expression is not null.
type IsNotNullExpression struct {

	// The name of the column.
	//
	// This member is required.
	ColumnName *string

	noSmithyDocumentSerde
}

// Specifies that the expression is null.
type IsNullExpression struct {

	// The name of the column.
	//
	// This member is required.
	ColumnName *string

	noSmithyDocumentSerde
}

// The details of a job run.
//
// The following types satisfy this interface:
//
//	JobRunDetailsMemberLineageRunDetails
type JobRunDetails interface {
	isJobRunDetails()
}

// The data lineage details of a job run.
type JobRunDetailsMemberLineageRunDetails struct {
	Value LineageRunDetails

	noSmithyDocumentSerde
}

func (*JobRunDetailsMemberLineageRunDetails) isJobRunDetails() {}

// The job run error.
type JobRunError struct {

	// The job run error message.
	//
	// This member is required.
	Message *string

	noSmithyDocumentSerde
}

// The job run summary.
type JobRunSummary struct {

	// The timestamp at which job run was created.
	CreatedAt *time.Time

	// The user who created the job run.
	CreatedBy *string

	// The domain ID of the job run.
	DomainId *string

	// The end time of a job run.
	EndTime *time.Time

	// The error of a job run.
	Error *JobRunError

	// The job ID of a job run.
	JobId *string

	// The job type of a job run.
	JobType JobType

	// The run ID of a job run.
	RunId *string

	// The run mode of a job run.
	RunMode JobRunMode

	// The start time of a job run.
	StartTime *time.Time

	// The status of a job run.
	Status JobRunStatus

	noSmithyDocumentSerde
}

// The Lake Formation configuration of the Data Lake blueprint.
type LakeFormationConfiguration struct {

	// Specifies certain Amazon S3 locations if you do not want Amazon DataZone to
	// automatically register them in hybrid mode.
	LocationRegistrationExcludeS3Locations []string

	// The role that is used to manage read/write access to the chosen Amazon S3
	// bucket(s) for Data Lake using Amazon Web Services Lake Formation hybrid access
	// mode.
	LocationRegistrationRole *string

	noSmithyDocumentSerde
}

// Specifies that a value is less than an expression.
type LessThanExpression struct {

	// The name of the column.
	//
	// This member is required.
	ColumnName *string

	// The value that might be less than the expression.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// Specifies that a value is less than or equal to an expression.
type LessThanOrEqualToExpression struct {

	// The name of the column.
	//
	// This member is required.
	ColumnName *string

	// The value that might be less than or equal to an expression.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// Specifies that a value is like the expression.
type LikeExpression struct {

	// The name of the column.
	//
	// This member is required.
	ColumnName *string

	// The value that might be like the expression.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// The data lineage event summary.
type LineageEventSummary struct {

	// The timestamp at which data lineage event was created.
	CreatedAt *time.Time

	// The user who created the data lineage event.
	CreatedBy *string

	// The domain ID of the lineage event.
	DomainId *string

	// The summary of the data lineate event.
	EventSummary EventSummary

	// The time of the data lineage event.
	EventTime *time.Time

	// The ID of the data lineage event.
	Id *string

	// The processing status of the data lineage event.
	ProcessingStatus LineageEventProcessingStatus

	noSmithyDocumentSerde
}

// The data lineage information.
type LineageInfo struct {

	// The data lineage error message.
	ErrorMessage *string

	// The data lineage event ID.
	EventId *string

	// The data lineage event status.
	EventStatus LineageEventProcessingStatus

	noSmithyDocumentSerde
}

// The reference details for the data lineage node.
type LineageNodeReference struct {

	// The event timestamp of the data lineage node.
	EventTimestamp *time.Time

	// The ID of the data lineage node.
	Id *string

	noSmithyDocumentSerde
}

// The summary of the data lineage node.
type LineageNodeSummary struct {

	// The ID of the domain of the data lineage node.
	//
	// This member is required.
	DomainId *string

	// The ID of the data lineage node.
	//
	// This member is required.
	Id *string

	// The name of the type of the data lineage node.
	//
	// This member is required.
	TypeName *string

	// The timestamp at which the data lineage node was created.
	CreatedAt *time.Time

	// The user who created the data lineage node.
	CreatedBy *string

	// The description of the data lineage node.
	Description *string

	// The event timestamp of the data lineage node.
	EventTimestamp *time.Time

	// The name of the data lineage node.
	Name *string

	// The alternate ID of the data lineage node.
	SourceIdentifier *string

	// The type of the revision of the data lineage node.
	TypeRevision *string

	// The timestamp at which the data lineage node was updated.
	UpdatedAt *time.Time

	// The user who updated the data lineage node.
	UpdatedBy *string

	noSmithyDocumentSerde
}

// The details of a data lineage node type.
type LineageNodeTypeItem struct {

	// The ID of the domain where the data lineage node type lives.
	//
	// This member is required.
	DomainId *string

	// The forms output of the data lineage node type.
	//
	// This member is required.
	FormsOutput map[string]FormEntryOutput

	// The revision of the data lineage node type.
	//
	// This member is required.
	Revision *string

	// The timestamp at which the data lineage node type was created.
	CreatedAt *time.Time

	// The user who created the data lineage node type.
	CreatedBy *string

	// The description of the data lineage node type.
	Description *string

	// The name of the data lineage node type.
	Name *string

	// The timestamp at which the data lineage node type was updated.
	UpdatedAt *time.Time

	// The user who updated the data lineage node type.
	UpdatedBy *string

	noSmithyDocumentSerde
}

// The data lineage run details.
type LineageRunDetails struct {

	// The SQL query run details of a data lineage run.
	SqlQueryRunDetails *LineageSqlQueryRunDetails

	noSmithyDocumentSerde
}

// The SQL query run details of a data lineage run.
type LineageSqlQueryRunDetails struct {

	// The error message of the SQL query run details of a data lineage run.
	ErrorMessages []string

	// The number of queries that failed in the SQL query run details of a data
	// lineage run.
	NumQueriesFailed *int32

	// The query end time in the SQL query run details of a data lineage run.
	QueryEndTime *time.Time

	// The query start time in the SQL query run details of a data lineage run.
	QueryStartTime *time.Time

	// The total queries processed in the SQL query run details of a data lineage run.
	TotalQueriesProcessed *int32

	noSmithyDocumentSerde
}

// The lineage sync schedule.
type LineageSyncSchedule struct {

	// The lineage sync schedule.
	Schedule *string

	noSmithyDocumentSerde
}

// The details of a listing (aka asset published in a Amazon DataZone catalog).
//
// The following types satisfy this interface:
//
//	ListingItemMemberAssetListing
//	ListingItemMemberDataProductListing
type ListingItem interface {
	isListingItem()
}

// An asset published in an Amazon DataZone catalog.
type ListingItemMemberAssetListing struct {
	Value AssetListing

	noSmithyDocumentSerde
}

func (*ListingItemMemberAssetListing) isListingItem() {}

// The data product listing.
type ListingItemMemberDataProductListing struct {
	Value DataProductListing

	noSmithyDocumentSerde
}

func (*ListingItemMemberDataProductListing) isListingItem() {}

// A revision of an asset published in a Amazon DataZone catalog.
type ListingRevision struct {

	// An identifier of a revision of an asset published in a Amazon DataZone catalog.
	//
	// This member is required.
	Id *string

	// The details of a revision of an asset published in a Amazon DataZone catalog.
	//
	// This member is required.
	Revision *string

	noSmithyDocumentSerde
}

// A revision to be made to an asset published in a Amazon DataZone catalog.
type ListingRevisionInput struct {

	// An identifier of revision to be made to an asset published in a Amazon DataZone
	// catalog.
	//
	// This member is required.
	Identifier *string

	// The details of a revision to be made to an asset published in a Amazon DataZone
	// catalog.
	//
	// This member is required.
	Revision *string

	noSmithyDocumentSerde
}

// The summary of the listing of the data product.
type ListingSummary struct {

	// The glossary terms of the data product.
	GlossaryTerms []DetailedGlossaryTerm

	// The ID of the data product listing.
	ListingId *string

	// The revision of the data product listing.
	ListingRevision *string

	noSmithyDocumentSerde
}

// The results of the data product summary.
type ListingSummaryItem struct {

	// The glossary terms of the data product listing.
	GlossaryTerms []DetailedGlossaryTerm

	// The ID of the data product listing.
	ListingId *string

	// The revision of the data product listing.
	ListingRevision *string

	noSmithyDocumentSerde
}

// The offset of a matched term.
type MatchOffset struct {

	// The 0-indexed number indicating the end position (exclusive) of a matched term.
	EndOffset *int32

	// The 0-indexed number indicating the start position (inclusive) of a matched
	// term.
	StartOffset *int32

	noSmithyDocumentSerde
}

// A rationale indicating why this item was matched by search.
//
// The following types satisfy this interface:
//
//	MatchRationaleItemMemberTextMatches
type MatchRationaleItem interface {
	isMatchRationaleItem()
}

// A list of TextMatchItems.
type MatchRationaleItemMemberTextMatches struct {
	Value []TextMatchItem

	noSmithyDocumentSerde
}

func (*MatchRationaleItemMemberTextMatches) isMatchRationaleItem() {}

// The details about a project member.
//
// The following types satisfy this interface:
//
//	MemberMemberGroupIdentifier
//	MemberMemberUserIdentifier
type Member interface {
	isMember()
}

// The ID of the group of a project member.
type MemberMemberGroupIdentifier struct {
	Value string

	noSmithyDocumentSerde
}

func (*MemberMemberGroupIdentifier) isMember() {}

// The user ID of a project member.
type MemberMemberUserIdentifier struct {
	Value string

	noSmithyDocumentSerde
}

func (*MemberMemberUserIdentifier) isMember() {}

// The details about a project member.
//
// The following types satisfy this interface:
//
//	MemberDetailsMemberGroup
//	MemberDetailsMemberUser
type MemberDetails interface {
	isMemberDetails()
}

// The group details of a project member.
type MemberDetailsMemberGroup struct {
	Value GroupDetails

	noSmithyDocumentSerde
}

func (*MemberDetailsMemberGroup) isMemberDetails() {}

// The user details of a project member.
type MemberDetailsMemberUser struct {
	Value UserDetails

	noSmithyDocumentSerde
}

func (*MemberDetailsMemberUser) isMemberDetails() {}

// The enforcement details of a metadata form.
type MetadataFormEnforcementDetail struct {

	// The required metadata forms.
	RequiredMetadataForms []MetadataFormReference

	noSmithyDocumentSerde
}

// The reference of a metadata form.
type MetadataFormReference struct {

	// The type ID of the metadata form reference.
	//
	// This member is required.
	TypeIdentifier *string

	// The type revision of the metadata form reference.
	//
	// This member is required.
	TypeRevision *string

	noSmithyDocumentSerde
}

// The summary of the metadata form.
type MetadataFormSummary struct {

	// The type name of the metadata form.
	//
	// This member is required.
	TypeName *string

	// The type revision of the metadata form.
	//
	// This member is required.
	TypeRevision *string

	// The form name of the metadata form.
	FormName *string

	noSmithyDocumentSerde
}

// The metadata generation run.
type MetadataGenerationRunItem struct {

	// The ID of the Amazon DataZone domain in which the metadata generation run was
	// created.
	//
	// This member is required.
	DomainId *string

	// The ID of the metadata generation run.
	//
	// This member is required.
	Id *string

	// The ID of the project that owns the asset for which the metadata generation was
	// ran.
	//
	// This member is required.
	OwningProjectId *string

	// The timestamp at which the metadata generation run was created.
	CreatedAt *time.Time

	// The user who created the metadata generation run.
	CreatedBy *string

	// The status of the metadata generation run.
	Status MetadataGenerationRunStatus

	// The asset for which metadata was generated.
	Target *MetadataGenerationRunTarget

	// The type of the metadata generation run.
	Type MetadataGenerationRunType

	noSmithyDocumentSerde
}

// The asset for which metadata was generated.
type MetadataGenerationRunTarget struct {

	// The ID of the metadata generation run's target.
	//
	// This member is required.
	Identifier *string

	// The type of the asset for which metadata was generated.
	//
	// This member is required.
	Type MetadataGenerationTargetType

	// The revision of the asset for which metadata was generated.
	Revision *string

	noSmithyDocumentSerde
}

// The model of the API.
//
// The following types satisfy this interface:
//
//	ModelMemberSmithy
type Model interface {
	isModel()
}

// Indicates the smithy model of the API.
type ModelMemberSmithy struct {
	Value string

	noSmithyDocumentSerde
}

func (*ModelMemberSmithy) isModel() {}

// The name identifier.
type NameIdentifier struct {

	// The name in the name identifier.
	Name *string

	// The namespace in the name identifier.
	Namespace *string

	noSmithyDocumentSerde
}

// Specifies that a value is not equal to the expression.
type NotEqualToExpression struct {

	// The name of the column.
	//
	// This member is required.
	ColumnName *string

	// The value that might not be equal to the expression.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// The details of a notification generated in Amazon DataZone.
type NotificationOutput struct {

	// The action link included in the notification.
	//
	// This member is required.
	ActionLink *string

	// The timestamp of when a notification was created.
	//
	// This member is required.
	CreationTimestamp *time.Time

	// The identifier of a Amazon DataZone domain in which the notification exists.
	//
	// This member is required.
	DomainIdentifier *string

	// The identifier of the notification.
	//
	// This member is required.
	Identifier *string

	// The timestamp of when the notification was last updated.
	//
	// This member is required.
	LastUpdatedTimestamp *time.Time

	// The message included in the notification.
	//
	// This member is required.
	Message *string

	// The title of the notification.
	//
	// This member is required.
	Title *string

	// The topic of the notification.
	//
	// This member is required.
	Topic *Topic

	// The type of the notification.
	//
	// This member is required.
	Type NotificationType

	// The metadata included in the notification.
	Metadata map[string]string

	// The status included in the notification.
	Status TaskStatus

	noSmithyDocumentSerde
}

// The details of the resource mentioned in a notification.
type NotificationResource struct {

	// The ID of the resource mentioned in a notification.
	//
	// This member is required.
	Id *string

	// The type of the resource mentioned in a notification.
	//
	// This member is required.
	Type NotificationResourceType

	// The name of the resource mentioned in a notification.
	Name *string

	noSmithyDocumentSerde
}

// Specifies that a value is not in the expression.
type NotInExpression struct {

	// The name of the column.
	//
	// This member is required.
	ColumnName *string

	// The value that might not be in the expression.
	//
	// This member is required.
	Values []string

	noSmithyDocumentSerde
}

// Specifies that a value might be not like the expression.
type NotLikeExpression struct {

	// The name of the column.
	//
	// This member is required.
	ColumnName *string

	// The value that might not be like the expression.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// The OAuth2Client application.
type OAuth2ClientApplication struct {

	// The Amazon Web Services managed client application reference in the
	// OAuth2Client application.
	AWSManagedClientApplicationReference *string

	// The user managed client application client ID in the OAuth2Client application.
	UserManagedClientApplicationClientId *string

	noSmithyDocumentSerde
}

// The OAuth2 properties.
type OAuth2Properties struct {

	// The authorization code properties of the OAuth2 properties.
	AuthorizationCodeProperties *AuthorizationCodeProperties

	// The OAuth2 client application of the OAuth2 properties.
	OAuth2ClientApplication *OAuth2ClientApplication

	// The OAuth2 credentials of the OAuth2 properties.
	OAuth2Credentials *GlueOAuth2Credentials

	// The OAuth2 grant type of the OAuth2 properties.
	OAuth2GrantType OAuth2GrantType

	// The OAuth2 token URL of the OAuth2 properties.
	TokenUrl *string

	// The OAuth2 token URL parameter map of the OAuth2 properties.
	TokenUrlParametersMap map[string]string

	noSmithyDocumentSerde
}

// The open lineage run event summary.
type OpenLineageRunEventSummary struct {

	// The event type of the open lineage run event summary.
	EventType OpenLineageRunState

	// The inputs of the open lineage run event summary.
	Inputs []NameIdentifier

	// The job of the open lineage run event summary.
	Job *NameIdentifier

	// The outputs of the open lineage run event summary.
	Outputs []NameIdentifier

	// The runID of the open lineage run event summary.
	RunId *string

	noSmithyDocumentSerde
}

// The grant details of the override domain unit owners policy.
type OverrideDomainUnitOwnersPolicyGrantDetail struct {

	// Specifies whether the policy is inherited by child domain units.
	IncludeChildDomainUnits *bool

	noSmithyDocumentSerde
}

// The details of the override project owners policy grant.
type OverrideProjectOwnersPolicyGrantDetail struct {

	// Specifies whether the policy is inherited by child domain units.
	IncludeChildDomainUnits *bool

	noSmithyDocumentSerde
}

// The properties of the domain unit owners group.
type OwnerGroupProperties struct {

	// The ID of the domain unit owners group.
	//
	// This member is required.
	GroupIdentifier *string

	noSmithyDocumentSerde
}

// The properties of the domain unit owners group.
type OwnerGroupPropertiesOutput struct {

	// The ID of the domain unit owners group.
	GroupId *string

	noSmithyDocumentSerde
}

// The properties of a domain unit's owner.
//
// The following types satisfy this interface:
//
//	OwnerPropertiesMemberGroup
//	OwnerPropertiesMemberUser
type OwnerProperties interface {
	isOwnerProperties()
}

// Specifies that the domain unit owner is a group.
type OwnerPropertiesMemberGroup struct {
	Value OwnerGroupProperties

	noSmithyDocumentSerde
}

func (*OwnerPropertiesMemberGroup) isOwnerProperties() {}

// Specifies that the domain unit owner is a user.
type OwnerPropertiesMemberUser struct {
	Value OwnerUserProperties

	noSmithyDocumentSerde
}

func (*OwnerPropertiesMemberUser) isOwnerProperties() {}

// The ID of the domain unit owners group.
//
// The following types satisfy this interface:
//
//	OwnerPropertiesOutputMemberGroup
//	OwnerPropertiesOutputMemberUser
type OwnerPropertiesOutput interface {
	isOwnerPropertiesOutput()
}

// Specifies that the domain unit owner is a group.
type OwnerPropertiesOutputMemberGroup struct {
	Value OwnerGroupPropertiesOutput

	noSmithyDocumentSerde
}

func (*OwnerPropertiesOutputMemberGroup) isOwnerPropertiesOutput() {}

// Specifies that the domain unit owner is a user.
type OwnerPropertiesOutputMemberUser struct {
	Value OwnerUserPropertiesOutput

	noSmithyDocumentSerde
}

func (*OwnerPropertiesOutputMemberUser) isOwnerPropertiesOutput() {}

// The properties of the owner user.
type OwnerUserProperties struct {

	// The ID of the owner user.
	//
	// This member is required.
	UserIdentifier *string

	noSmithyDocumentSerde
}

// The properties of the owner user.
type OwnerUserPropertiesOutput struct {

	// The ID of the owner user.
	UserId *string

	noSmithyDocumentSerde
}

// Physical connection requirements of a connection.
type PhysicalConnectionRequirements struct {

	// The availability zone of the physical connection requirements of a connection.
	AvailabilityZone *string

	// The group ID list of the physical connection requirements of a connection.
	SecurityGroupIdList []string

	// The subnet ID of the physical connection requirements of a connection.
	SubnetId *string

	// The subnet ID list of the physical connection requirements of a connection.
	SubnetIdList []string

	noSmithyDocumentSerde
}

// The physical endpoints of a connection.
type PhysicalEndpoint struct {

	// The location of a connection.
	AwsLocation *AwsLocation

	// The Amazon Web Services Glue connection.
	GlueConnection *GlueConnection

	// The Amazon Web Services Glue connection name.
	GlueConnectionName *string

	// The host in the physical endpoints of a connection.
	Host *string

	// The port in the physical endpoints of a connection.
	Port *int32

	// The protocol in the physical endpoints of a connection.
	Protocol Protocol

	// The stage in the physical endpoints of a connection.
	Stage *string

	noSmithyDocumentSerde
}

// The details of the policy grant.
//
// The following types satisfy this interface:
//
//	PolicyGrantDetailMemberAddToProjectMemberPool
//	PolicyGrantDetailMemberCreateAssetType
//	PolicyGrantDetailMemberCreateDomainUnit
//	PolicyGrantDetailMemberCreateEnvironment
//	PolicyGrantDetailMemberCreateEnvironmentFromBlueprint
//	PolicyGrantDetailMemberCreateEnvironmentProfile
//	PolicyGrantDetailMemberCreateFormType
//	PolicyGrantDetailMemberCreateGlossary
//	PolicyGrantDetailMemberCreateProject
//	PolicyGrantDetailMemberCreateProjectFromProjectProfile
//	PolicyGrantDetailMemberDelegateCreateEnvironmentProfile
//	PolicyGrantDetailMemberOverrideDomainUnitOwners
//	PolicyGrantDetailMemberOverrideProjectOwners
//	PolicyGrantDetailMemberUseAssetType
type PolicyGrantDetail interface {
	isPolicyGrantDetail()
}

// Specifies that the policy grant is to be added to the members of the project.
type PolicyGrantDetailMemberAddToProjectMemberPool struct {
	Value AddToProjectMemberPoolPolicyGrantDetail

	noSmithyDocumentSerde
}

func (*PolicyGrantDetailMemberAddToProjectMemberPool) isPolicyGrantDetail() {}

// Specifies that this is a create asset type policy.
type PolicyGrantDetailMemberCreateAssetType struct {
	Value CreateAssetTypePolicyGrantDetail

	noSmithyDocumentSerde
}

func (*PolicyGrantDetailMemberCreateAssetType) isPolicyGrantDetail() {}

// Specifies that this is a create domain unit policy.
type PolicyGrantDetailMemberCreateDomainUnit struct {
	Value CreateDomainUnitPolicyGrantDetail

	noSmithyDocumentSerde
}

func (*PolicyGrantDetailMemberCreateDomainUnit) isPolicyGrantDetail() {}

// Specifies that this is a create environment policy.
type PolicyGrantDetailMemberCreateEnvironment struct {
	Value Unit

	noSmithyDocumentSerde
}

func (*PolicyGrantDetailMemberCreateEnvironment) isPolicyGrantDetail() {}

// The details of the policy of creating an environment.
type PolicyGrantDetailMemberCreateEnvironmentFromBlueprint struct {
	Value Unit

	noSmithyDocumentSerde
}

func (*PolicyGrantDetailMemberCreateEnvironmentFromBlueprint) isPolicyGrantDetail() {}

// Specifies that this is a create environment profile policy.
type PolicyGrantDetailMemberCreateEnvironmentProfile struct {
	Value CreateEnvironmentProfilePolicyGrantDetail

	noSmithyDocumentSerde
}

func (*PolicyGrantDetailMemberCreateEnvironmentProfile) isPolicyGrantDetail() {}

// Specifies that this is a create form type policy.
type PolicyGrantDetailMemberCreateFormType struct {
	Value CreateFormTypePolicyGrantDetail

	noSmithyDocumentSerde
}

func (*PolicyGrantDetailMemberCreateFormType) isPolicyGrantDetail() {}

// Specifies that this is a create glossary policy.
type PolicyGrantDetailMemberCreateGlossary struct {
	Value CreateGlossaryPolicyGrantDetail

	noSmithyDocumentSerde
}

func (*PolicyGrantDetailMemberCreateGlossary) isPolicyGrantDetail() {}

// Specifies that this is a create project policy.
type PolicyGrantDetailMemberCreateProject struct {
	Value CreateProjectPolicyGrantDetail

	noSmithyDocumentSerde
}

func (*PolicyGrantDetailMemberCreateProject) isPolicyGrantDetail() {}

// Specifies whether to create a project from project profile.
type PolicyGrantDetailMemberCreateProjectFromProjectProfile struct {
	Value CreateProjectFromProjectProfilePolicyGrantDetail

	noSmithyDocumentSerde
}

func (*PolicyGrantDetailMemberCreateProjectFromProjectProfile) isPolicyGrantDetail() {}

// Specifies that this is the delegation of the create environment profile policy.
type PolicyGrantDetailMemberDelegateCreateEnvironmentProfile struct {
	Value Unit

	noSmithyDocumentSerde
}

func (*PolicyGrantDetailMemberDelegateCreateEnvironmentProfile) isPolicyGrantDetail() {}

// Specifies whether to override domain unit owners.
type PolicyGrantDetailMemberOverrideDomainUnitOwners struct {
	Value OverrideDomainUnitOwnersPolicyGrantDetail

	noSmithyDocumentSerde
}

func (*PolicyGrantDetailMemberOverrideDomainUnitOwners) isPolicyGrantDetail() {}

// Specifies whether to override project owners.
type PolicyGrantDetailMemberOverrideProjectOwners struct {
	Value OverrideProjectOwnersPolicyGrantDetail

	noSmithyDocumentSerde
}

func (*PolicyGrantDetailMemberOverrideProjectOwners) isPolicyGrantDetail() {}

//	Specifies the domain unit(s) whose projects can use this asset type while
//
// creating asset or asset revisions.
type PolicyGrantDetailMemberUseAssetType struct {
	Value UseAssetTypePolicyGrantDetail

	noSmithyDocumentSerde
}

func (*PolicyGrantDetailMemberUseAssetType) isPolicyGrantDetail() {}

// A member of the policy grant list.
type PolicyGrantMember struct {

	// Specifies the timestamp at which policy grant member was created.
	CreatedAt *time.Time

	// Specifies the user who created the policy grant member.
	CreatedBy *string

	// The details of the policy grant member.
	Detail PolicyGrantDetail

	// The ID of the policy grant.
	GrantId *string

	// The principal of the policy grant member.
	Principal PolicyGrantPrincipal

	noSmithyDocumentSerde
}

// The policy grant principal.
//
// The following types satisfy this interface:
//
//	PolicyGrantPrincipalMemberDomainUnit
//	PolicyGrantPrincipalMemberGroup
//	PolicyGrantPrincipalMemberProject
//	PolicyGrantPrincipalMemberUser
type PolicyGrantPrincipal interface {
	isPolicyGrantPrincipal()
}

// The domain unit of the policy grant principal.
type PolicyGrantPrincipalMemberDomainUnit struct {
	Value DomainUnitPolicyGrantPrincipal

	noSmithyDocumentSerde
}

func (*PolicyGrantPrincipalMemberDomainUnit) isPolicyGrantPrincipal() {}

// The group of the policy grant principal.
type PolicyGrantPrincipalMemberGroup struct {
	Value GroupPolicyGrantPrincipal

	noSmithyDocumentSerde
}

func (*PolicyGrantPrincipalMemberGroup) isPolicyGrantPrincipal() {}

// The project of the policy grant principal.
type PolicyGrantPrincipalMemberProject struct {
	Value ProjectPolicyGrantPrincipal

	noSmithyDocumentSerde
}

func (*PolicyGrantPrincipalMemberProject) isPolicyGrantPrincipal() {}

// The user of the policy grant principal.
type PolicyGrantPrincipalMemberUser struct {
	Value UserPolicyGrantPrincipal

	noSmithyDocumentSerde
}

func (*PolicyGrantPrincipalMemberUser) isPolicyGrantPrincipal() {}

// The configuration of the prediction.
type PredictionConfiguration struct {

	// The business name generation mechanism.
	BusinessNameGeneration *BusinessNameGenerationConfiguration

	noSmithyDocumentSerde
}

// Specifies the error message that is returned if the operation cannot be
// successfully completed.
type ProjectDeletionError struct {

	// The code of the project deletion error.
	Code *string

	// The message of the project deletion error.
	Message *string

	noSmithyDocumentSerde
}

// The project grant filter.
//
// The following types satisfy this interface:
//
//	ProjectGrantFilterMemberDomainUnitFilter
type ProjectGrantFilter interface {
	isProjectGrantFilter()
}

// The domain unit filter of the project grant filter.
type ProjectGrantFilterMemberDomainUnitFilter struct {
	Value DomainUnitFilterForProject

	noSmithyDocumentSerde
}

func (*ProjectGrantFilterMemberDomainUnitFilter) isProjectGrantFilter() {}

// The details of a project member.
type ProjectMember struct {

	// The designated role of a project member.
	//
	// This member is required.
	Designation UserDesignation

	// The membership details of a project member.
	//
	// This member is required.
	MemberDetails MemberDetails

	noSmithyDocumentSerde
}

// The project policy grant principal.
type ProjectPolicyGrantPrincipal struct {

	// The project designation of the project policy grant principal.
	//
	// This member is required.
	ProjectDesignation ProjectDesignation

	// The project grant filter of the project policy grant principal.
	ProjectGrantFilter ProjectGrantFilter

	// The project ID of the project policy grant principal.
	ProjectIdentifier *string

	noSmithyDocumentSerde
}

// The summary of a project profile.
type ProjectProfileSummary struct {

	// The user who created the project profile.
	//
	// This member is required.
	CreatedBy *string

	// The domain ID of the project profile.
	//
	// This member is required.
	DomainId *string

	// The ID of the project profile.
	//
	// This member is required.
	Id *string

	// The name of a project profile.
	//
	// This member is required.
	Name *string

	// The timestamp of when the project profile was created.
	CreatedAt *time.Time

	// The description of the project profile.
	Description *string

	// The domain unit ID of the project profile.
	DomainUnitId *string

	// The timestamp at which a project profile was last updated.
	LastUpdatedAt *time.Time

	// The status of a project profile.
	Status Status

	noSmithyDocumentSerde
}

// Specifies projects in which the rule is created.
type ProjectsForRule struct {

	// The selection mode of the rule.
	//
	// This member is required.
	SelectionMode RuleScopeSelectionMode

	// The specific projects in which the rule is created.
	SpecificProjects []string

	noSmithyDocumentSerde
}

// The details of a Amazon DataZone project.
type ProjectSummary struct {

	// The Amazon DataZone user who created the project.
	//
	// This member is required.
	CreatedBy *string

	// The identifier of a Amazon DataZone domain where the project exists.
	//
	// This member is required.
	DomainId *string

	// The identifier of a project.
	//
	// This member is required.
	Id *string

	// The name of a project.
	//
	// This member is required.
	Name *string

	// The timestamp of when a project was created.
	CreatedAt *time.Time

	// The description of a project.
	Description *string

	// The ID of the domain unit.
	DomainUnitId *string

	// Specifies the error message that is returned if the operation cannot be
	// successfully completed.
	FailureReasons []ProjectDeletionError

	// The status of the project.
	ProjectStatus ProjectStatus

	// The timestamp of when the project was updated.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// The provisioning configuration of the blueprint.
//
// The following types satisfy this interface:
//
//	ProvisioningConfigurationMemberLakeFormationConfiguration
type ProvisioningConfiguration interface {
	isProvisioningConfiguration()
}

// The Lake Formation configuration of the Data Lake blueprint.
type ProvisioningConfigurationMemberLakeFormationConfiguration struct {
	Value LakeFormationConfiguration

	noSmithyDocumentSerde
}

func (*ProvisioningConfigurationMemberLakeFormationConfiguration) isProvisioningConfiguration() {}

// The provisioning properties of an environment blueprint.
//
// The following types satisfy this interface:
//
//	ProvisioningPropertiesMemberCloudFormation
type ProvisioningProperties interface {
	isProvisioningProperties()
}

// The cloud formation properties included as part of the provisioning properties
// of an environment blueprint.
type ProvisioningPropertiesMemberCloudFormation struct {
	Value CloudFormationProperties

	noSmithyDocumentSerde
}

func (*ProvisioningPropertiesMemberCloudFormation) isProvisioningProperties() {}

// The recommendation to be updated as part of the UpdateDataSource action.
type RecommendationConfiguration struct {

	// Specifies whether automatic business name generation is to be enabled or not as
	// part of the recommendation configuration.
	EnableBusinessNameGeneration *bool

	noSmithyDocumentSerde
}

// The details of the Amazon Redshift cluster storage.
type RedshiftClusterStorage struct {

	// The name of an Amazon Redshift cluster.
	//
	// This member is required.
	ClusterName *string

	noSmithyDocumentSerde
}

// The details of the credentials required to access an Amazon Redshift cluster.
type RedshiftCredentialConfiguration struct {

	// The ARN of a secret manager for an Amazon Redshift cluster.
	//
	// This member is required.
	SecretManagerArn *string

	noSmithyDocumentSerde
}

// Amazon Redshift credentials of a connection.
//
// The following types satisfy this interface:
//
//	RedshiftCredentialsMemberSecretArn
//	RedshiftCredentialsMemberUsernamePassword
type RedshiftCredentials interface {
	isRedshiftCredentials()
}

// The secret ARN of the Amazon Redshift credentials of a connection.
type RedshiftCredentialsMemberSecretArn struct {
	Value string

	noSmithyDocumentSerde
}

func (*RedshiftCredentialsMemberSecretArn) isRedshiftCredentials() {}

// The username and password of the Amazon Redshift credentials of a connection.
type RedshiftCredentialsMemberUsernamePassword struct {
	Value UsernamePassword

	noSmithyDocumentSerde
}

func (*RedshiftCredentialsMemberUsernamePassword) isRedshiftCredentials() {}

// The Amaon Redshift lineage sync configuration.
type RedshiftLineageSyncConfigurationInput struct {

	// Specifies whether the Amaon Redshift lineage sync configuration is enabled.
	Enabled *bool

	// The schedule of the Amaon Redshift lineage sync configuration.
	Schedule *LineageSyncSchedule

	noSmithyDocumentSerde
}

// The Amaon Redshift lineage sync configuration.
type RedshiftLineageSyncConfigurationOutput struct {

	// Specifies whether the Amaon Redshift lineage sync configuration is enabled.
	Enabled *bool

	// The lineage job ID of the Amaon Redshift lineage sync configuration.
	LineageJobId *string

	// The schedule of teh Amaon Redshift lineage sync configuration.
	Schedule *LineageSyncSchedule

	noSmithyDocumentSerde
}

// The Amazon Redshift properties.
type RedshiftPropertiesInput struct {

	// The Amaon Redshift credentials.
	Credentials RedshiftCredentials

	// The Amazon Redshift database name.
	DatabaseName *string

	// The Amazon Redshift host.
	Host *string

	// The lineage sync of the Amazon Redshift.
	LineageSync *RedshiftLineageSyncConfigurationInput

	// The Amaon Redshift port.
	Port *int32

	// The Amazon Redshift storage.
	Storage RedshiftStorageProperties

	noSmithyDocumentSerde
}

// The Amazon Redshift properties.
type RedshiftPropertiesOutput struct {

	// The Amazon Redshift credentials.
	Credentials RedshiftCredentials

	// The Amazon Redshift database name.
	DatabaseName *string

	// Specifies whether Amaon Redshift properties has a provisioned secret.
	IsProvisionedSecret *bool

	// The jdbcIam URL of the Amazon Redshift properties.
	JdbcIamUrl *string

	// The jdbcURL of the Amazon Redshift properties.
	JdbcUrl *string

	// The lineage syn of the Amazon Redshift properties.
	LineageSync *RedshiftLineageSyncConfigurationOutput

	// The redshiftTempDir of the Amazon Redshift properties.
	RedshiftTempDir *string

	// The status in the Amazon Redshift properties.
	Status ConnectionStatus

	// The storage in the Amazon Redshift properties.
	Storage RedshiftStorageProperties

	noSmithyDocumentSerde
}

// Amazon Redshift properties patch.
type RedshiftPropertiesPatch struct {

	// The credentials in the Amazon Redshift properties patch.
	Credentials RedshiftCredentials

	// The name in the Amazon Redshift properties patch.
	DatabaseName *string

	// The host in the Amazon Redshift properties patch.
	Host *string

	// The lineage sync in the Amazon Redshift properties patch.
	LineageSync *RedshiftLineageSyncConfigurationInput

	// The port in the Amazon Redshift properties patch.
	Port *int32

	// The storage in the Amazon Redshift properties patch.
	Storage RedshiftStorageProperties

	noSmithyDocumentSerde
}

// The configuration details of the Amazon Redshift data source.
type RedshiftRunConfigurationInput struct {

	// The relational filger configurations included in the configuration details of
	// the Amazon Redshift data source.
	//
	// This member is required.
	RelationalFilterConfigurations []RelationalFilterConfiguration

	// The data access role included in the configuration details of the Amazon
	// Redshift data source.
	DataAccessRole *string

	// The details of the credentials required to access an Amazon Redshift cluster.
	RedshiftCredentialConfiguration *RedshiftCredentialConfiguration

	// The details of the Amazon Redshift storage as part of the configuration of an
	// Amazon Redshift data source run.
	RedshiftStorage RedshiftStorage

	noSmithyDocumentSerde
}

// The configuration details of the Amazon Redshift data source.
type RedshiftRunConfigurationOutput struct {

	// The details of the Amazon Redshift storage as part of the configuration of an
	// Amazon Redshift data source run.
	//
	// This member is required.
	RedshiftStorage RedshiftStorage

	// The relational filger configurations included in the configuration details of
	// the Amazon Redshift data source.
	//
	// This member is required.
	RelationalFilterConfigurations []RelationalFilterConfiguration

	// The ID of the Amazon Web Services account included in the configuration details
	// of the Amazon Redshift data source.
	AccountId *string

	// The data access role included in the configuration details of the Amazon
	// Redshift data source.
	DataAccessRole *string

	// The details of the credentials required to access an Amazon Redshift cluster.
	RedshiftCredentialConfiguration *RedshiftCredentialConfiguration

	// The Amazon Web Services region included in the configuration details of the
	// Amazon Redshift data source.
	Region *string

	noSmithyDocumentSerde
}

// The details for the self granting status for an Amazon Redshift data source.
type RedshiftSelfGrantStatusOutput struct {

	// The details for the self granting status for an Amazon Redshift data source.
	//
	// This member is required.
	SelfGrantStatusDetails []SelfGrantStatusDetail

	noSmithyDocumentSerde
}

// The details of the Amazon Redshift Serverless workgroup storage.
type RedshiftServerlessStorage struct {

	// The name of the Amazon Redshift Serverless workgroup.
	//
	// This member is required.
	WorkgroupName *string

	noSmithyDocumentSerde
}

// The details of the Amazon Redshift storage as part of the configuration of an
// Amazon Redshift data source run.
//
// The following types satisfy this interface:
//
//	RedshiftStorageMemberRedshiftClusterSource
//	RedshiftStorageMemberRedshiftServerlessSource
type RedshiftStorage interface {
	isRedshiftStorage()
}

// The details of the Amazon Redshift cluster source.
type RedshiftStorageMemberRedshiftClusterSource struct {
	Value RedshiftClusterStorage

	noSmithyDocumentSerde
}

func (*RedshiftStorageMemberRedshiftClusterSource) isRedshiftStorage() {}

// The details of the Amazon Redshift Serverless workgroup source.
type RedshiftStorageMemberRedshiftServerlessSource struct {
	Value RedshiftServerlessStorage

	noSmithyDocumentSerde
}

func (*RedshiftStorageMemberRedshiftServerlessSource) isRedshiftStorage() {}

// The Amazon Redshift storage properties.
//
// The following types satisfy this interface:
//
//	RedshiftStoragePropertiesMemberClusterName
//	RedshiftStoragePropertiesMemberWorkgroupName
type RedshiftStorageProperties interface {
	isRedshiftStorageProperties()
}

// The cluster name in the Amazon Redshift storage properties.
type RedshiftStoragePropertiesMemberClusterName struct {
	Value string

	noSmithyDocumentSerde
}

func (*RedshiftStoragePropertiesMemberClusterName) isRedshiftStorageProperties() {}

// The workgroup name in the Amazon Redshift storage properties.
type RedshiftStoragePropertiesMemberWorkgroupName struct {
	Value string

	noSmithyDocumentSerde
}

func (*RedshiftStoragePropertiesMemberWorkgroupName) isRedshiftStorageProperties() {}

// The Amazon Web Services Region.
//
// The following types satisfy this interface:
//
//	RegionMemberRegionName
//	RegionMemberRegionNamePath
type Region interface {
	isRegion()
}

// The Amazon Web Services Region name.
type RegionMemberRegionName struct {
	Value string

	noSmithyDocumentSerde
}

func (*RegionMemberRegionName) isRegion() {}

// The region name path.
type RegionMemberRegionNamePath struct {
	Value string

	noSmithyDocumentSerde
}

func (*RegionMemberRegionNamePath) isRegion() {}

// The details of the automatically generated business metadata that is rejected.
type RejectChoice struct {

	// Specifies the target (for example, a column name) where a prediction can be
	// rejected.
	//
	// This member is required.
	PredictionTarget *string

	// Specifies the the automatically generated business metadata that can be
	// rejected.
	PredictionChoices []int32

	noSmithyDocumentSerde
}

// Specifies the rule and the threshold under which a prediction can be rejected.
type RejectRule struct {

	// Specifies whether you want to reject the top prediction for all targets or none.
	Rule RejectRuleBehavior

	// The confidence score that specifies the condition at which a prediction can be
	// rejected.
	Threshold *float32

	noSmithyDocumentSerde
}

// The relational filter configuration for the data source.
type RelationalFilterConfiguration struct {

	// The database name specified in the relational filter configuration for the data
	// source.
	//
	// This member is required.
	DatabaseName *string

	// The filter expressions specified in the relational filter configuration for the
	// data source.
	FilterExpressions []FilterExpression

	// The schema name specified in the relational filter configuration for the data
	// source.
	SchemaName *string

	noSmithyDocumentSerde
}

// The details of a provisioned resource of this Amazon DataZone environment.
type Resource struct {

	// The type of a provisioned resource of this Amazon DataZone environment.
	//
	// This member is required.
	Type *string

	// The value of a provisioned resource of this Amazon DataZone environment.
	//
	// This member is required.
	Value *string

	// The name of a provisioned resource of this Amazon DataZone environment.
	Name *string

	// The provider of a provisioned resource of this Amazon DataZone environment.
	Provider *string

	noSmithyDocumentSerde
}

// The row filter.
//
// The following types satisfy this interface:
//
//	RowFilterMemberAnd
//	RowFilterMemberExpression
//	RowFilterMemberOr
type RowFilter interface {
	isRowFilter()
}

// The 'and' clause of the row filter.
type RowFilterMemberAnd struct {
	Value []RowFilter

	noSmithyDocumentSerde
}

func (*RowFilterMemberAnd) isRowFilter() {}

// The expression of the row filter.
type RowFilterMemberExpression struct {
	Value RowFilterExpression

	noSmithyDocumentSerde
}

func (*RowFilterMemberExpression) isRowFilter() {}

// The 'or' clause of the row filter.
type RowFilterMemberOr struct {
	Value []RowFilter

	noSmithyDocumentSerde
}

func (*RowFilterMemberOr) isRowFilter() {}

// The row filter configuration details.
type RowFilterConfiguration struct {

	// The row filter.
	//
	// This member is required.
	RowFilter RowFilter

	// Specifies whether the row filter is sensitive.
	Sensitive *bool

	noSmithyDocumentSerde
}

// The row filter expression.
//
// The following types satisfy this interface:
//
//	RowFilterExpressionMemberEqualTo
//	RowFilterExpressionMemberGreaterThan
//	RowFilterExpressionMemberGreaterThanOrEqualTo
//	RowFilterExpressionMemberIn
//	RowFilterExpressionMemberIsNotNull
//	RowFilterExpressionMemberIsNull
//	RowFilterExpressionMemberLessThan
//	RowFilterExpressionMemberLessThanOrEqualTo
//	RowFilterExpressionMemberLike
//	RowFilterExpressionMemberNotEqualTo
//	RowFilterExpressionMemberNotIn
//	RowFilterExpressionMemberNotLike
type RowFilterExpression interface {
	isRowFilterExpression()
}

// The 'equal to' clause of the row filter expression.
type RowFilterExpressionMemberEqualTo struct {
	Value EqualToExpression

	noSmithyDocumentSerde
}

func (*RowFilterExpressionMemberEqualTo) isRowFilterExpression() {}

// The 'greater than' clause of the row filter expression.
type RowFilterExpressionMemberGreaterThan struct {
	Value GreaterThanExpression

	noSmithyDocumentSerde
}

func (*RowFilterExpressionMemberGreaterThan) isRowFilterExpression() {}

// The 'greater than or equal to' clause of the filter expression.
type RowFilterExpressionMemberGreaterThanOrEqualTo struct {
	Value GreaterThanOrEqualToExpression

	noSmithyDocumentSerde
}

func (*RowFilterExpressionMemberGreaterThanOrEqualTo) isRowFilterExpression() {}

// The 'in' clause of the row filter expression.
type RowFilterExpressionMemberIn struct {
	Value InExpression

	noSmithyDocumentSerde
}

func (*RowFilterExpressionMemberIn) isRowFilterExpression() {}

// The 'is not null' clause of the row filter expression.
type RowFilterExpressionMemberIsNotNull struct {
	Value IsNotNullExpression

	noSmithyDocumentSerde
}

func (*RowFilterExpressionMemberIsNotNull) isRowFilterExpression() {}

// The 'is null' clause of the row filter expression.
type RowFilterExpressionMemberIsNull struct {
	Value IsNullExpression

	noSmithyDocumentSerde
}

func (*RowFilterExpressionMemberIsNull) isRowFilterExpression() {}

// The 'less than' clause of the row filter expression.
type RowFilterExpressionMemberLessThan struct {
	Value LessThanExpression

	noSmithyDocumentSerde
}

func (*RowFilterExpressionMemberLessThan) isRowFilterExpression() {}

// The 'less than or equal to' clause of the row filter expression.
type RowFilterExpressionMemberLessThanOrEqualTo struct {
	Value LessThanOrEqualToExpression

	noSmithyDocumentSerde
}

func (*RowFilterExpressionMemberLessThanOrEqualTo) isRowFilterExpression() {}

// The 'like' clause of the row filter expression.
type RowFilterExpressionMemberLike struct {
	Value LikeExpression

	noSmithyDocumentSerde
}

func (*RowFilterExpressionMemberLike) isRowFilterExpression() {}

// The 'no equal to' clause of the row filter expression.
type RowFilterExpressionMemberNotEqualTo struct {
	Value NotEqualToExpression

	noSmithyDocumentSerde
}

func (*RowFilterExpressionMemberNotEqualTo) isRowFilterExpression() {}

// The 'not in' clause of the row filter expression.
type RowFilterExpressionMemberNotIn struct {
	Value NotInExpression

	noSmithyDocumentSerde
}

func (*RowFilterExpressionMemberNotIn) isRowFilterExpression() {}

// The 'not like' clause of the row filter expression.
type RowFilterExpressionMemberNotLike struct {
	Value NotLikeExpression

	noSmithyDocumentSerde
}

func (*RowFilterExpressionMemberNotLike) isRowFilterExpression() {}

// The details of a rule.
//
// The following types satisfy this interface:
//
//	RuleDetailMemberMetadataFormEnforcementDetail
type RuleDetail interface {
	isRuleDetail()
}

// The enforcement detail of the metadata form.
type RuleDetailMemberMetadataFormEnforcementDetail struct {
	Value MetadataFormEnforcementDetail

	noSmithyDocumentSerde
}

func (*RuleDetailMemberMetadataFormEnforcementDetail) isRuleDetail() {}

// The scope of a rule.
type RuleScope struct {

	// The asset type included in the rule scope.
	AssetType *AssetTypesForRule

	// The data product included in the rule scope.
	DataProduct *bool

	// The project included in the rule scope.
	Project *ProjectsForRule

	noSmithyDocumentSerde
}

// The summary of the rule.
type RuleSummary struct {

	// The action of the rule.
	Action RuleAction

	// The ID of the rule.
	Identifier *string

	// The timestamp at which the rule was last updated.
	LastUpdatedBy *string

	// The name of the rule.
	Name *string

	// The revision of the rule.
	Revision *string

	// The type of the rule.
	RuleType RuleType

	// The scope of the rule.
	Scope *RuleScope

	// The target of the rule.
	Target RuleTarget

	// The target type of the rule.
	TargetType RuleTargetType

	// The timestamp at which the rule was last updated.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// The target of the rule.
//
// The following types satisfy this interface:
//
//	RuleTargetMemberDomainUnitTarget
type RuleTarget interface {
	isRuleTarget()
}

// The ID of the domain unit.
type RuleTargetMemberDomainUnitTarget struct {
	Value DomainUnitTarget

	noSmithyDocumentSerde
}

func (*RuleTargetMemberDomainUnitTarget) isRuleTarget() {}

// The asset statistics from the data source run.
type RunStatisticsForAssets struct {

	// The added statistic for the data source run.
	Added *int32

	// The failed statistic for the data source run.
	Failed *int32

	// The skipped statistic for the data source run.
	Skipped *int32

	// The unchanged statistic for the data source run.
	Unchanged *int32

	// The updated statistic for the data source run.
	Updated *int32

	noSmithyDocumentSerde
}

// The Amazon S3 properties of a connection.
type S3PropertiesInput struct {

	// The Amazon S3 URI that's part of the Amazon S3 properties of a connection.
	//
	// This member is required.
	S3Uri *string

	// The Amazon S3 Access Grant location ID that's part of the Amazon S3 properties
	// of a connection.
	S3AccessGrantLocationId *string

	noSmithyDocumentSerde
}

// The Amazon S3 properties of a connection.
type S3PropertiesOutput struct {

	// The Amazon S3 URI that's part of the Amazon S3 properties of a connection.
	//
	// This member is required.
	S3Uri *string

	// The error message that gets displayed.
	ErrorMessage *string

	// The Amazon S3 Access Grant location ID that's part of the Amazon S3 properties
	// of a connection.
	S3AccessGrantLocationId *string

	// The status of the Amazon S3 connection.
	Status ConnectionStatus

	noSmithyDocumentSerde
}

// The Amazon S3 properties patch of a connection.
type S3PropertiesPatch struct {

	// The Amazon S3 URI that's part of the Amazon S3 properties patch of a connection.
	//
	// This member is required.
	S3Uri *string

	// The Amazon S3 Access Grant location ID that's part of the Amazon S3 properties
	// patch of a connection.
	S3AccessGrantLocationId *string

	noSmithyDocumentSerde
}

// The Amazon SageMaker run configuration.
type SageMakerRunConfigurationInput struct {

	// The tracking assets of the Amazon SageMaker run.
	//
	// This member is required.
	TrackingAssets map[string][]string

	noSmithyDocumentSerde
}

// The Amazon SageMaker run configuration.
type SageMakerRunConfigurationOutput struct {

	// The tracking assets of the Amazon SageMaker.
	//
	// This member is required.
	TrackingAssets map[string][]string

	// The Amazon SageMaker account ID.
	AccountId *string

	// The Amazon SageMaker Region.
	Region *string

	noSmithyDocumentSerde
}

// The details of the schedule of the data source runs.
type ScheduleConfiguration struct {

	// The schedule of the data source runs.
	Schedule *string

	// The timezone of the data source run.
	Timezone Timezone

	noSmithyDocumentSerde
}

// The details of the search.
type SearchInItem struct {

	// The search attribute.
	//
	// This member is required.
	Attribute *string

	noSmithyDocumentSerde
}

// The details of the search results.
//
// The following types satisfy this interface:
//
//	SearchInventoryResultItemMemberAssetItem
//	SearchInventoryResultItemMemberDataProductItem
//	SearchInventoryResultItemMemberGlossaryItem
//	SearchInventoryResultItemMemberGlossaryTermItem
type SearchInventoryResultItem interface {
	isSearchInventoryResultItem()
}

// The asset item included in the search results.
type SearchInventoryResultItemMemberAssetItem struct {
	Value AssetItem

	noSmithyDocumentSerde
}

func (*SearchInventoryResultItemMemberAssetItem) isSearchInventoryResultItem() {}

// The data product.
type SearchInventoryResultItemMemberDataProductItem struct {
	Value DataProductResultItem

	noSmithyDocumentSerde
}

func (*SearchInventoryResultItemMemberDataProductItem) isSearchInventoryResultItem() {}

// The glossary item included in the search results.
type SearchInventoryResultItemMemberGlossaryItem struct {
	Value GlossaryItem

	noSmithyDocumentSerde
}

func (*SearchInventoryResultItemMemberGlossaryItem) isSearchInventoryResultItem() {}

// The glossary term item included in the search results.
type SearchInventoryResultItemMemberGlossaryTermItem struct {
	Value GlossaryTermItem

	noSmithyDocumentSerde
}

func (*SearchInventoryResultItemMemberGlossaryTermItem) isSearchInventoryResultItem() {}

// The details of the results of the SearchListings action.
//
// The following types satisfy this interface:
//
//	SearchResultItemMemberAssetListing
//	SearchResultItemMemberDataProductListing
type SearchResultItem interface {
	isSearchResultItem()
}

// The asset listing included in the results of the SearchListings action.
type SearchResultItemMemberAssetListing struct {
	Value AssetListingItem

	noSmithyDocumentSerde
}

func (*SearchResultItemMemberAssetListing) isSearchResultItem() {}

// The data product listing.
type SearchResultItemMemberDataProductListing struct {
	Value DataProductListingItem

	noSmithyDocumentSerde
}

func (*SearchResultItemMemberDataProductListing) isSearchResultItem() {}

// The details of the way to sort search results.
type SearchSort struct {

	// The attribute detail of the way to sort search results.
	//
	// This member is required.
	Attribute *string

	// The order detail of the wya to sort search results.
	Order SortOrder

	noSmithyDocumentSerde
}

// The details of the results of the SearchTypes action.
//
// The following types satisfy this interface:
//
//	SearchTypesResultItemMemberAssetTypeItem
//	SearchTypesResultItemMemberFormTypeItem
//	SearchTypesResultItemMemberLineageNodeTypeItem
type SearchTypesResultItem interface {
	isSearchTypesResultItem()
}

// The asset type included in the results of the SearchTypes action.
type SearchTypesResultItemMemberAssetTypeItem struct {
	Value AssetTypeItem

	noSmithyDocumentSerde
}

func (*SearchTypesResultItemMemberAssetTypeItem) isSearchTypesResultItem() {}

// The form type included in the results of the SearchTypes action.
type SearchTypesResultItemMemberFormTypeItem struct {
	Value FormTypeData

	noSmithyDocumentSerde
}

func (*SearchTypesResultItemMemberFormTypeItem) isSearchTypesResultItem() {}

// The details of a data lineage node type.
type SearchTypesResultItemMemberLineageNodeTypeItem struct {
	Value LineageNodeTypeItem

	noSmithyDocumentSerde
}

func (*SearchTypesResultItemMemberLineageNodeTypeItem) isSearchTypesResultItem() {}

// The details for the self granting status.
type SelfGrantStatusDetail struct {

	// The name of the database used for the data source.
	//
	// This member is required.
	DatabaseName *string

	// The self granting status of the data source.
	//
	// This member is required.
	Status SelfGrantStatus

	// The reason for why the operation failed.
	FailureCause *string

	// The name of the schema used in the data source.
	SchemaName *string

	noSmithyDocumentSerde
}

// The details for the self granting status for a data source.
//
// The following types satisfy this interface:
//
//	SelfGrantStatusOutputMemberGlueSelfGrantStatus
//	SelfGrantStatusOutputMemberRedshiftSelfGrantStatus
type SelfGrantStatusOutput interface {
	isSelfGrantStatusOutput()
}

// The details for the self granting status for a Glue data source.
type SelfGrantStatusOutputMemberGlueSelfGrantStatus struct {
	Value GlueSelfGrantStatusOutput

	noSmithyDocumentSerde
}

func (*SelfGrantStatusOutputMemberGlueSelfGrantStatus) isSelfGrantStatusOutput() {}

// The details for the self granting status for an Amazon Redshift data source.
type SelfGrantStatusOutputMemberRedshiftSelfGrantStatus struct {
	Value RedshiftSelfGrantStatusOutput

	noSmithyDocumentSerde
}

func (*SelfGrantStatusOutputMemberRedshiftSelfGrantStatus) isSelfGrantStatusOutput() {}

// The single sign-on details in Amazon DataZone.
type SingleSignOn struct {

	// The ARN of the IDC instance.
	IdcInstanceArn *string

	// The type of single sign-on in Amazon DataZone.
	Type AuthType

	// The single sign-on user assignment in Amazon DataZone.
	UserAssignment UserAssignment

	noSmithyDocumentSerde
}

// The Spark EMR properties.
type SparkEmrPropertiesInput struct {

	// The compute ARN of Spark EMR.
	ComputeArn *string

	// The instance profile ARN of Spark EMR.
	InstanceProfileArn *string

	// The java virtual env of the Spark EMR.
	JavaVirtualEnv *string

	// The log URI of the Spark EMR.
	LogUri *string

	// The Python virtual env of the Spark EMR.
	PythonVirtualEnv *string

	// The runtime role of the Spark EMR.
	RuntimeRole *string

	// The certificates S3 URI of the Spark EMR.
	TrustedCertificatesS3Uri *string

	noSmithyDocumentSerde
}

// The Spark EMR properties.
type SparkEmrPropertiesOutput struct {

	// The compute ARN of the Spark EMR.
	ComputeArn *string

	// The credentials of the Spark EMR.
	Credentials *UsernamePassword

	// The credential expiration of the Spark EMR.
	CredentialsExpiration *time.Time

	// The governance type of the Spark EMR.
	GovernanceType GovernanceType

	// The instance profile ARN of the Spark EMR.
	InstanceProfileArn *string

	// The Java virtual env of the Spark EMR.
	JavaVirtualEnv *string

	// The livy endpoint of the Spark EMR.
	LivyEndpoint *string

	// The log URI of the Spark EMR.
	LogUri *string

	// The Python virtual env of the Spark EMR.
	PythonVirtualEnv *string

	// The runtime role of the Spark EMR.
	RuntimeRole *string

	// The trusted certificate S3 URL of the Spark EMR.
	TrustedCertificatesS3Uri *string

	noSmithyDocumentSerde
}

// The Spark EMR properties patch.
type SparkEmrPropertiesPatch struct {

	// The compute ARN in the Spark EMR properties patch.
	ComputeArn *string

	// The instance profile ARN in the Spark EMR properties patch.
	InstanceProfileArn *string

	// The Java virtual evn in the Spark EMR properties patch.
	JavaVirtualEnv *string

	// The log URI in the Spark EMR properties patch.
	LogUri *string

	// The Python virtual env in the Spark EMR properties patch.
	PythonVirtualEnv *string

	// The runtime role in the Spark EMR properties patch.
	RuntimeRole *string

	// The trusted certificates S3 URI in the Spark EMR properties patch.
	TrustedCertificatesS3Uri *string

	noSmithyDocumentSerde
}

// The Spark Amazon Web Services Glue args.
type SparkGlueArgs struct {

	// The connection in the Spark Amazon Web Services Glue args.
	Connection *string

	noSmithyDocumentSerde
}

// The Spark Amazon Web Services Glue properties.
type SparkGluePropertiesInput struct {

	// The additional args in the Spark Amazon Web Services Glue properties.
	AdditionalArgs *SparkGlueArgs

	// The Amazon Web Services Glue connection name in the Spark Amazon Web Services
	// Glue properties.
	GlueConnectionName *string

	// The Amazon Web Services Glue version in the Spark Amazon Web Services Glue
	// properties.
	GlueVersion *string

	// The idle timeout in the Spark Amazon Web Services Glue properties.
	IdleTimeout *int32

	// The Java virtual env in the Spark Amazon Web Services Glue properties.
	JavaVirtualEnv *string

	// The number of workers in the Spark Amazon Web Services Glue properties.
	NumberOfWorkers *int32

	// The Python virtual env in the Spark Amazon Web Services Glue properties.
	PythonVirtualEnv *string

	// The worker type in the Spark Amazon Web Services Glue properties.
	WorkerType *string

	noSmithyDocumentSerde
}

// The Spark Amazon Web Services Glue properties.
type SparkGluePropertiesOutput struct {

	// The additional args in the Spark Amazon Web Services Glue properties.
	AdditionalArgs *SparkGlueArgs

	// The Amazon Web Services Glue connection name in the Spark Amazon Web Services
	// Glue properties.
	GlueConnectionName *string

	// The Amazon Web Services Glue version in the Spark Amazon Web Services Glue
	// properties.
	GlueVersion *string

	// The idle timeout in the Spark Amazon Web Services Glue properties.
	IdleTimeout *int32

	// The Java virtual env in the Spark Amazon Web Services Glue properties.
	JavaVirtualEnv *string

	// The number of workers in the Spark Amazon Web Services Glue properties.
	NumberOfWorkers *int32

	// The Python virtual env in the Spark Amazon Web Services Glue properties.
	PythonVirtualEnv *string

	// The worker type in the Spark Amazon Web Services Glue properties.
	WorkerType *string

	noSmithyDocumentSerde
}

// The single sign-on details of the user profile.
type SsoUserProfileDetails struct {

	// The first name included in the single sign-on details of the user profile.
	FirstName *string

	// The last name included in the single sign-on details of the user profile.
	LastName *string

	// The username included in the single sign-on details of the user profile.
	Username *string

	noSmithyDocumentSerde
}

// The details of the asset for which the subscription grant is created.
type SubscribedAsset struct {

	// The identifier of the asset for which the subscription grant is created.
	//
	// This member is required.
	AssetId *string

	// The revision of the asset for which the subscription grant is created.
	//
	// This member is required.
	AssetRevision *string

	// The status of the asset for which the subscription grant is created.
	//
	// This member is required.
	Status SubscriptionGrantStatus

	// The asset scope of the subscribed asset.
	AssetScope *AssetScope

	// The failure cause included in the details of the asset for which the
	// subscription grant is created.
	FailureCause *FailureCause

	// The failure timestamp included in the details of the asset for which the
	// subscription grant is created.
	FailureTimestamp *time.Time

	// The timestamp of when the subscription grant to the asset is created.
	GrantedTimestamp *time.Time

	// The target name of the asset for which the subscription grant is created.
	TargetName *string

	noSmithyDocumentSerde
}

// The details of the published asset for which the subscription grant is created.
type SubscribedAssetListing struct {

	// The asset scope of the subscribed asset listing.
	AssetScope *AssetScope

	// The identifier of the published asset for which the subscription grant is
	// created.
	EntityId *string

	// The revision of the published asset for which the subscription grant is created.
	EntityRevision *string

	// The type of the published asset for which the subscription grant is created.
	EntityType *string

	// The forms attached to the published asset for which the subscription grant is
	// created.
	Forms *string

	// The glossary terms attached to the published asset for which the subscription
	// grant is created.
	GlossaryTerms []DetailedGlossaryTerm

	noSmithyDocumentSerde
}

// The details of the published asset for which the subscription grant is created.
type SubscribedListing struct {

	// The description of the published asset for which the subscription grant is
	// created.
	//
	// This member is required.
	Description *string

	// The identifier of the published asset for which the subscription grant is
	// created.
	//
	// This member is required.
	Id *string

	// The published asset for which the subscription grant is created.
	//
	// This member is required.
	Item SubscribedListingItem

	// The name of the published asset for which the subscription grant is created.
	//
	// This member is required.
	Name *string

	// The identifier of the project of the published asset for which the subscription
	// grant is created.
	//
	// This member is required.
	OwnerProjectId *string

	// The name of the project that owns the published asset for which the
	// subscription grant is created.
	OwnerProjectName *string

	// The revision of the published asset for which the subscription grant is created.
	Revision *string

	noSmithyDocumentSerde
}

// The published asset for which the subscription grant is to be created.
type SubscribedListingInput struct {

	// The identifier of the published asset for which the subscription grant is to be
	// created.
	//
	// This member is required.
	Identifier *string

	noSmithyDocumentSerde
}

// The published asset for which the subscription grant is created.
//
// The following types satisfy this interface:
//
//	SubscribedListingItemMemberAssetListing
//	SubscribedListingItemMemberProductListing
type SubscribedListingItem interface {
	isSubscribedListingItem()
}

// The asset for which the subscription grant is created.
type SubscribedListingItemMemberAssetListing struct {
	Value SubscribedAssetListing

	noSmithyDocumentSerde
}

func (*SubscribedListingItemMemberAssetListing) isSubscribedListingItem() {}

// The data product listing.
type SubscribedListingItemMemberProductListing struct {
	Value SubscribedProductListing

	noSmithyDocumentSerde
}

func (*SubscribedListingItemMemberProductListing) isSubscribedListingItem() {}

// The principal that has the subscription grant for the asset.
//
// The following types satisfy this interface:
//
//	SubscribedPrincipalMemberProject
type SubscribedPrincipal interface {
	isSubscribedPrincipal()
}

// The project that has the subscription grant.
type SubscribedPrincipalMemberProject struct {
	Value SubscribedProject

	noSmithyDocumentSerde
}

func (*SubscribedPrincipalMemberProject) isSubscribedPrincipal() {}

// The principal that is to be given a subscriptiong grant.
//
// The following types satisfy this interface:
//
//	SubscribedPrincipalInputMemberProject
type SubscribedPrincipalInput interface {
	isSubscribedPrincipalInput()
}

// The project that is to be given a subscription grant.
type SubscribedPrincipalInputMemberProject struct {
	Value SubscribedProjectInput

	noSmithyDocumentSerde
}

func (*SubscribedPrincipalInputMemberProject) isSubscribedPrincipalInput() {}

// The data product listing.
type SubscribedProductListing struct {

	// The data assets of the data product listing.
	AssetListings []AssetInDataProductListingItem

	// The description of the data product listing.
	Description *string

	// The ID of the data product listing.
	EntityId *string

	// The revision of the data product listing.
	EntityRevision *string

	// The glossary terms of the data product listing.
	GlossaryTerms []DetailedGlossaryTerm

	// The name of the data product listing.
	Name *string

	noSmithyDocumentSerde
}

// The project that has the subscription grant.
type SubscribedProject struct {

	// The identifier of the project that has the subscription grant.
	Id *string

	// The name of the project that has the subscription grant.
	Name *string

	noSmithyDocumentSerde
}

// The project that is to be given a subscription grant.
type SubscribedProjectInput struct {

	// The identifier of the project that is to be given a subscription grant.
	Identifier *string

	noSmithyDocumentSerde
}

// The details of the subscription grant.
type SubscriptionGrantSummary struct {

	// The timestamp of when a subscription grant was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The datazone user who created the subscription grant.
	//
	// This member is required.
	CreatedBy *string

	// The identifier of the Amazon DataZone domain in which a subscription grant
	// exists.
	//
	// This member is required.
	DomainId *string

	// The entity to which the subscription is granted.
	//
	// This member is required.
	GrantedEntity GrantedEntity

	// The identifier of the subscription grant.
	//
	// This member is required.
	Id *string

	// The status of the subscription grant.
	//
	// This member is required.
	Status SubscriptionGrantOverallStatus

	// The identifier of the target of the subscription grant.
	//
	// This member is required.
	SubscriptionTargetId *string

	// The timestampf of when the subscription grant was updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The assets included in the subscription grant.
	Assets []SubscribedAsset

	// The ID of the subscription.
	//
	// Deprecated: Multiple subscriptions can exist for a single grant
	SubscriptionId *string

	// The Amazon DataZone user who updated the subscription grant.
	UpdatedBy *string

	noSmithyDocumentSerde
}

// The details of the subscription request.
type SubscriptionRequestSummary struct {

	// The timestamp of when a subscription request was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The Amazon DataZone user who created the subscription request.
	//
	// This member is required.
	CreatedBy *string

	// The identifier of the Amazon DataZone domain in which a subscription request
	// exists.
	//
	// This member is required.
	DomainId *string

	// The identifier of the subscription request.
	//
	// This member is required.
	Id *string

	// The reason for the subscription request.
	//
	// This member is required.
	RequestReason *string

	// The status of the subscription request.
	//
	// This member is required.
	Status SubscriptionRequestStatus

	// The listings included in the subscription request.
	//
	// This member is required.
	SubscribedListings []SubscribedListing

	// The principals included in the subscription request.
	//
	// This member is required.
	SubscribedPrincipals []SubscribedPrincipal

	// The timestamp of when the subscription request was updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The decision comment of the subscription request.
	DecisionComment *string

	// The ID of the existing subscription.
	ExistingSubscriptionId *string

	// The summary of the metadata forms.
	MetadataFormsSummary []MetadataFormSummary

	// The identifier of the subscription request reviewer.
	ReviewerId *string

	// The identifier of the Amazon DataZone user who updated the subscription request.
	UpdatedBy *string

	noSmithyDocumentSerde
}

// The details of the subscription.
type SubscriptionSummary struct {

	// The timestamp of when the subscription was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The Amazon DataZone user who created the subscription.
	//
	// This member is required.
	CreatedBy *string

	// The identifier of the Amazon DataZone domain in which a subscription exists.
	//
	// This member is required.
	DomainId *string

	// The identifier of the subscription.
	//
	// This member is required.
	Id *string

	// The status of the subscription.
	//
	// This member is required.
	Status SubscriptionStatus

	// The listing included in the subscription.
	//
	// This member is required.
	SubscribedListing *SubscribedListing

	// The principal included in the subscription.
	//
	// This member is required.
	SubscribedPrincipal SubscribedPrincipal

	// The timestamp of when the subscription was updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The retain permissions included in the subscription.
	RetainPermissions *bool

	// The identifier of the subscription request for the subscription.
	SubscriptionRequestId *string

	// The Amazon DataZone user who updated the subscription.
	UpdatedBy *string

	noSmithyDocumentSerde
}

// The details of the subscription target configuration.
type SubscriptionTargetForm struct {

	// The content of the subscription target configuration.
	//
	// This member is required.
	Content *string

	// The form name included in the subscription target configuration.
	//
	// This member is required.
	FormName *string

	noSmithyDocumentSerde
}

// The details of the subscription target.
type SubscriptionTargetSummary struct {

	// The asset types included in the subscription target.
	//
	// This member is required.
	ApplicableAssetTypes []string

	// The authorized principals included in the subscription target.
	//
	// This member is required.
	AuthorizedPrincipals []string

	// The timestamp of when the subscription target was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The Amazon DataZone user who created the subscription target.
	//
	// This member is required.
	CreatedBy *string

	// The identifier of the Amazon DataZone domain in which the subscription target
	// exists.
	//
	// This member is required.
	DomainId *string

	// The identifier of the environment of the subscription target.
	//
	// This member is required.
	EnvironmentId *string

	// The identifier of the subscription target.
	//
	// This member is required.
	Id *string

	// The name of the subscription target.
	//
	// This member is required.
	Name *string

	// The identifier of the project specified in the subscription target.
	//
	// This member is required.
	ProjectId *string

	// The provider of the subscription target.
	//
	// This member is required.
	Provider *string

	// The configuration of the subscription target.
	//
	// This member is required.
	SubscriptionTargetConfig []SubscriptionTargetForm

	// The type of the subscription target.
	//
	// This member is required.
	Type *string

	// The manage access role specified in the subscription target.
	ManageAccessRole *string

	// The timestamp of when the subscription target was updated.
	UpdatedAt *time.Time

	// The Amazon DataZone user who updated the subscription target.
	UpdatedBy *string

	noSmithyDocumentSerde
}

// The details of the term relations.
type TermRelations struct {

	// The classifies of the term relations.
	Classifies []string

	// The isA property of the term relations.
	IsA []string

	noSmithyDocumentSerde
}

// A structure indicating matched terms for an attribute.
type TextMatchItem struct {

	// The name of the attribute.
	Attribute *string

	// List of offsets indicating matching terms in the TextMatchItem text.
	MatchOffsets []MatchOffset

	// Snippet of attribute text containing highlighted content.
	Text *string

	noSmithyDocumentSerde
}

// The time series data points form.
type TimeSeriesDataPointFormInput struct {

	// The name of the time series data points form.
	//
	// This member is required.
	FormName *string

	// The timestamp of the time series data points form.
	//
	// This member is required.
	Timestamp *time.Time

	// The ID of the type of the time series data points form.
	//
	// This member is required.
	TypeIdentifier *string

	// The content of the time series data points form.
	Content *string

	// The revision type of the time series data points form.
	TypeRevision *string

	noSmithyDocumentSerde
}

// The time series data points form.
type TimeSeriesDataPointFormOutput struct {

	// The name of the time series data points form.
	//
	// This member is required.
	FormName *string

	// The timestamp of the time series data points form.
	//
	// This member is required.
	Timestamp *time.Time

	// The ID of the type of the time series data points form.
	//
	// This member is required.
	TypeIdentifier *string

	// The content of the time series data points form.
	Content *string

	// The ID of the time series data points form.
	Id *string

	// The revision type of the time series data points form.
	TypeRevision *string

	noSmithyDocumentSerde
}

// The summary of the time series data points form.
type TimeSeriesDataPointSummaryFormOutput struct {

	// The name of the time series data points summary form.
	//
	// This member is required.
	FormName *string

	// The timestamp of the time series data points summary form.
	//
	// This member is required.
	Timestamp *time.Time

	// The type ID of the time series data points summary form.
	//
	// This member is required.
	TypeIdentifier *string

	// The content of the summary of the time series data points form.
	ContentSummary *string

	// The ID of the time series data points summary form.
	Id *string

	// The type revision of the time series data points summary form.
	TypeRevision *string

	noSmithyDocumentSerde
}

// The topic of the notification.
type Topic struct {

	// The details of the resource mentioned in a notification.
	//
	// This member is required.
	Resource *NotificationResource

	// The role of the resource mentioned in a notification.
	//
	// This member is required.
	Role NotificationRole

	// The subject of the resource mentioned in a notification.
	//
	// This member is required.
	Subject *string

	noSmithyDocumentSerde
}

// The details of the policy of creating an environment.
type Unit struct {
	noSmithyDocumentSerde
}

// Specifies the domain unit(s) whose projects can use this asset type while
// creating asset or asset revisions.
type UseAssetTypePolicyGrantDetail struct {

	// The ID of the domain unit.
	DomainUnitId *string

	noSmithyDocumentSerde
}

// The user details of a project member.
type UserDetails struct {

	// The identifier of the Amazon DataZone user.
	//
	// This member is required.
	UserId *string

	noSmithyDocumentSerde
}

// The username and password of a connection.
type UsernamePassword struct {

	// The password of a connection.
	//
	// This member is required.
	Password *string

	// The username of a connection.
	//
	// This member is required.
	Username *string

	noSmithyDocumentSerde
}

// The user policy grant principal.
//
// The following types satisfy this interface:
//
//	UserPolicyGrantPrincipalMemberAllUsersGrantFilter
//	UserPolicyGrantPrincipalMemberUserIdentifier
type UserPolicyGrantPrincipal interface {
	isUserPolicyGrantPrincipal()
}

// The all users grant filter of the user policy grant principal.
type UserPolicyGrantPrincipalMemberAllUsersGrantFilter struct {
	Value AllUsersGrantFilter

	noSmithyDocumentSerde
}

func (*UserPolicyGrantPrincipalMemberAllUsersGrantFilter) isUserPolicyGrantPrincipal() {}

// The user ID of the user policy grant principal.
type UserPolicyGrantPrincipalMemberUserIdentifier struct {
	Value string

	noSmithyDocumentSerde
}

func (*UserPolicyGrantPrincipalMemberUserIdentifier) isUserPolicyGrantPrincipal() {}

// The details of the user profile in Amazon DataZone.
//
// The following types satisfy this interface:
//
//	UserProfileDetailsMemberIam
//	UserProfileDetailsMemberSso
type UserProfileDetails interface {
	isUserProfileDetails()
}

// The IAM details included in the user profile details.
type UserProfileDetailsMemberIam struct {
	Value IamUserProfileDetails

	noSmithyDocumentSerde
}

func (*UserProfileDetailsMemberIam) isUserProfileDetails() {}

// The single sign-on details included in the user profile details.
type UserProfileDetailsMemberSso struct {
	Value SsoUserProfileDetails

	noSmithyDocumentSerde
}

func (*UserProfileDetailsMemberSso) isUserProfileDetails() {}

// The details of the user profile.
type UserProfileSummary struct {

	// The details of the user profile.
	Details UserProfileDetails

	// The ID of the Amazon DataZone domain of the user profile.
	DomainId *string

	// The ID of the user profile.
	Id *string

	// The status of the user profile.
	Status UserProfileStatus

	// The type of the user profile.
	Type UserProfileType

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isAccountSource()                 {}
func (*UnknownUnionMember) isActionParameters()              {}
func (*UnknownUnionMember) isAssetFilterConfiguration()      {}
func (*UnknownUnionMember) isAwsAccount()                    {}
func (*UnknownUnionMember) isConnectionPropertiesInput()     {}
func (*UnknownUnionMember) isConnectionPropertiesOutput()    {}
func (*UnknownUnionMember) isConnectionPropertiesPatch()     {}
func (*UnknownUnionMember) isDataSourceConfigurationInput()  {}
func (*UnknownUnionMember) isDataSourceConfigurationOutput() {}
func (*UnknownUnionMember) isDomainUnitGrantFilter()         {}
func (*UnknownUnionMember) isDomainUnitOwnerProperties()     {}
func (*UnknownUnionMember) isEventSummary()                  {}
func (*UnknownUnionMember) isFilterClause()                  {}
func (*UnknownUnionMember) isGrantedEntity()                 {}
func (*UnknownUnionMember) isGrantedEntityInput()            {}
func (*UnknownUnionMember) isGroupPolicyGrantPrincipal()     {}
func (*UnknownUnionMember) isJobRunDetails()                 {}
func (*UnknownUnionMember) isListingItem()                   {}
func (*UnknownUnionMember) isMatchRationaleItem()            {}
func (*UnknownUnionMember) isMember()                        {}
func (*UnknownUnionMember) isMemberDetails()                 {}
func (*UnknownUnionMember) isModel()                         {}
func (*UnknownUnionMember) isOwnerProperties()               {}
func (*UnknownUnionMember) isOwnerPropertiesOutput()         {}
func (*UnknownUnionMember) isPolicyGrantDetail()             {}
func (*UnknownUnionMember) isPolicyGrantPrincipal()          {}
func (*UnknownUnionMember) isProjectGrantFilter()            {}
func (*UnknownUnionMember) isProvisioningConfiguration()     {}
func (*UnknownUnionMember) isProvisioningProperties()        {}
func (*UnknownUnionMember) isRedshiftCredentials()           {}
func (*UnknownUnionMember) isRedshiftStorage()               {}
func (*UnknownUnionMember) isRedshiftStorageProperties()     {}
func (*UnknownUnionMember) isRegion()                        {}
func (*UnknownUnionMember) isRowFilter()                     {}
func (*UnknownUnionMember) isRowFilterExpression()           {}
func (*UnknownUnionMember) isRuleDetail()                    {}
func (*UnknownUnionMember) isRuleTarget()                    {}
func (*UnknownUnionMember) isSearchInventoryResultItem()     {}
func (*UnknownUnionMember) isSearchResultItem()              {}
func (*UnknownUnionMember) isSearchTypesResultItem()         {}
func (*UnknownUnionMember) isSelfGrantStatusOutput()         {}
func (*UnknownUnionMember) isSubscribedListingItem()         {}
func (*UnknownUnionMember) isSubscribedPrincipal()           {}
func (*UnknownUnionMember) isSubscribedPrincipalInput()      {}
func (*UnknownUnionMember) isUserPolicyGrantPrincipal()      {}
func (*UnknownUnionMember) isUserProfileDetails()            {}
