// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Contains metadata about the quantum task action, including the action type and
// program statistics.
type ActionMetadata struct {

	// The type of action associated with the quantum task.
	//
	// This member is required.
	ActionType *string

	// The number of executables in a program set. This is only available for a
	// Program Set.
	ExecutableCount *int64

	// The number of programs in a program set. This is only available for a Program
	// Set.
	ProgramCount *int64

	noSmithyDocumentSerde
}

// Defines the Amazon Braket hybrid job to be created. Specifies the container
// image the job uses and the paths to the Python scripts used for entry and
// training.
type AlgorithmSpecification struct {

	// The container image used to create an Amazon Braket hybrid job.
	ContainerImage *ContainerImage

	// Configures the paths to the Python scripts used for entry and training.
	ScriptModeConfig *ScriptModeConfig

	noSmithyDocumentSerde
}

// The Amazon Braket resource and the association type.
type Association struct {

	// The Amazon Braket resource arn.
	//
	// This member is required.
	Arn *string

	// The association type for the specified Amazon Braket resource arn.
	//
	// This member is required.
	Type AssociationType

	noSmithyDocumentSerde
}

// The container image used to create an Amazon Braket hybrid job.
type ContainerImage struct {

	// The URI locating the container image.
	//
	// This member is required.
	Uri *string

	noSmithyDocumentSerde
}

// Information about the source of the input data used by the Amazon Braket hybrid
// job.
type DataSource struct {

	// Amazon S3 path of the input data used by the hybrid job.
	//
	// This member is required.
	S3DataSource *S3DataSource

	noSmithyDocumentSerde
}

// Configures the primary device used to create and run an Amazon Braket hybrid
// job.
type DeviceConfig struct {

	// The primary device ARN used to create and run an Amazon Braket hybrid job.
	//
	// This member is required.
	Device *string

	noSmithyDocumentSerde
}

// Information about quantum tasks and hybrid jobs queued on a device.
type DeviceQueueInfo struct {

	// The name of the queue.
	//
	// This member is required.
	Queue QueueName

	// The number of hybrid jobs or quantum tasks in the queue for a given device.
	//
	// This member is required.
	QueueSize *string

	// Optional. Specifies the priority of the queue. Quantum tasks in a priority
	// queue are processed before the quantum tasks in a normal queue.
	QueuePriority QueuePriority

	noSmithyDocumentSerde
}

// Includes information about the device.
type DeviceSummary struct {

	// The ARN of the device.
	//
	// This member is required.
	DeviceArn *string

	// The name of the device.
	//
	// This member is required.
	DeviceName *string

	// The status of the device.
	//
	// This member is required.
	DeviceStatus DeviceStatus

	// The type of the device.
	//
	// This member is required.
	DeviceType DeviceType

	// The provider of the device.
	//
	// This member is required.
	ProviderName *string

	noSmithyDocumentSerde
}

// Information about the queue for a specified hybrid job.
type HybridJobQueueInfo struct {

	// Current position of the hybrid job in the jobs queue.
	//
	// This member is required.
	Position *string

	// The name of the queue.
	//
	// This member is required.
	Queue QueueName

	// Optional. Provides more information about the queue position. For example, if
	// the hybrid job is complete and no longer in the queue, the message field
	// contains that information.
	Message *string

	noSmithyDocumentSerde
}

// A list of parameters that specify the input channels, type of input data, and
// where it is located.
type InputFileConfig struct {

	// A named input source that an Amazon Braket hybrid job can consume.
	//
	// This member is required.
	ChannelName *string

	// The location of the input data.
	//
	// This member is required.
	DataSource *DataSource

	// The MIME type of the data.
	ContentType *string

	noSmithyDocumentSerde
}

// Configures the resource instances to use while running the Amazon Braket hybrid
// job on Amazon Braket.
type InstanceConfig struct {

	// Configures the type of resource instances to use while running an Amazon Braket
	// hybrid job.
	//
	// This member is required.
	InstanceType InstanceType

	// The size of the storage volume, in GB, to provision.
	//
	// This member is required.
	VolumeSizeInGb *int32

	// Configures the number of resource instances to use while running an Amazon
	// Braket hybrid job on Amazon Braket. The default value is 1.
	InstanceCount *int32

	noSmithyDocumentSerde
}

// Contains information about the output locations for hybrid job checkpoint data.
type JobCheckpointConfig struct {

	// Identifies the S3 path where you want Amazon Braket to store checkpoint data.
	// For example, s3://bucket-name/key-name-prefix .
	//
	// This member is required.
	S3Uri *string

	// (Optional) The local directory where checkpoint data is stored. The default
	// directory is /opt/braket/checkpoints/ .
	LocalPath *string

	noSmithyDocumentSerde
}

// Details about the type and time events that occurred related to the Amazon
// Braket hybrid job.
type JobEventDetails struct {

	// The type of event that occurred related to the Amazon Braket hybrid job.
	EventType JobEventType

	// A message describing the event that occurred related to the Amazon Braket
	// hybrid job.
	Message *string

	// The time of the event that occurred related to the Amazon Braket hybrid job.
	TimeOfEvent *time.Time

	noSmithyDocumentSerde
}

// Specifies the path to the S3 location where you want to store hybrid job
// artifacts and the encryption key used to store them.
type JobOutputDataConfig struct {

	// Identifies the S3 path where you want Amazon Braket to store the hybrid job
	// training artifacts. For example, s3://bucket-name/key-name-prefix .
	//
	// This member is required.
	S3Path *string

	// The AWS Key Management Service (AWS KMS) key that Amazon Braket uses to encrypt
	// the hybrid job training artifacts at rest using Amazon S3 server-side
	// encryption.
	KmsKeyId *string

	noSmithyDocumentSerde
}

// Specifies limits for how long an Amazon Braket hybrid job can run.
type JobStoppingCondition struct {

	// The maximum length of time, in seconds, that an Amazon Braket hybrid job can
	// run.
	MaxRuntimeInSeconds *int32

	noSmithyDocumentSerde
}

// Provides summary information about an Amazon Braket hybrid job.
type JobSummary struct {

	// The time at which the Amazon Braket hybrid job was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The primary device used by an Amazon Braket hybrid job.
	//
	// This member is required.
	Device *string

	// The ARN of the Amazon Braket hybrid job.
	//
	// This member is required.
	JobArn *string

	// The name of the Amazon Braket hybrid job.
	//
	// This member is required.
	JobName *string

	// The status of the Amazon Braket hybrid job.
	//
	// This member is required.
	Status JobPrimaryStatus

	// The time at which the Amazon Braket hybrid job ended.
	EndedAt *time.Time

	// The time at which the Amazon Braket hybrid job was started.
	StartedAt *time.Time

	// Displays the key, value pairs of tags associated with this hybrid job.
	Tags map[string]string

	noSmithyDocumentSerde
}

// Contains information about validation failures that occurred during the
// processing of a program set in a quantum task.
type ProgramSetValidationFailure struct {

	// The index of the program within the program set that failed validation.
	//
	// This member is required.
	ProgramIndex *int64

	// A list of error messages describing the validation failures that occurred.
	Errors []string

	// The index of the input within the program set that failed validation.
	InputsIndex *int64

	noSmithyDocumentSerde
}

// The queue information for the specified quantum task.
type QuantumTaskQueueInfo struct {

	// Current position of the quantum task in the quantum tasks queue.
	//
	// This member is required.
	Position *string

	// The name of the queue.
	//
	// This member is required.
	Queue QueueName

	// Optional. Provides more information about the queue position. For example, if
	// the quantum task is complete and no longer in the queue, the message field
	// contains that information.
	Message *string

	// Optional. Specifies the priority of the queue. Quantum tasks in a priority
	// queue are processed before the quantum tasks in a normal queue.
	QueuePriority QueuePriority

	noSmithyDocumentSerde
}

// Includes information about a quantum task.
type QuantumTaskSummary struct {

	// The time at which the quantum task was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The ARN of the device the quantum task ran on.
	//
	// This member is required.
	DeviceArn *string

	// The S3 bucket where the quantum task result file is stored.
	//
	// This member is required.
	OutputS3Bucket *string

	// The folder in the S3 bucket where the quantum task result file is stored.
	//
	// This member is required.
	OutputS3Directory *string

	// The ARN of the quantum task.
	//
	// This member is required.
	QuantumTaskArn *string

	// The shots used for the quantum task.
	//
	// This member is required.
	Shots *int64

	// The status of the quantum task.
	//
	// This member is required.
	Status QuantumTaskStatus

	// The time at which the quantum task finished.
	EndedAt *time.Time

	// Displays the key, value pairs of tags associated with this quantum task.
	Tags map[string]string

	noSmithyDocumentSerde
}

// Information about the Amazon S3 storage used by the Amazon Braket hybrid job.
type S3DataSource struct {

	// Depending on the value specified for the S3DataType , identifies either a key
	// name prefix or a manifest that locates the S3 data source.
	//
	// This member is required.
	S3Uri *string

	noSmithyDocumentSerde
}

// Contains information about algorithm scripts used for the Amazon Braket hybrid
// job.
type ScriptModeConfig struct {

	// The entry point in the algorithm scripts from where the execution begins in the
	// hybrid job.
	//
	// This member is required.
	EntryPoint *string

	// The URI that specifies the S3 path to the algorithm scripts used by an Amazon
	// Braket hybrid job.
	//
	// This member is required.
	S3Uri *string

	// The type of compression used to store the algorithm scripts in Amazon S3
	// storage.
	CompressionType CompressionType

	noSmithyDocumentSerde
}

// The filter used to search for devices.
type SearchDevicesFilter struct {

	// The name of the device parameter to filter based on. Only deviceArn filter name
	// is currently supported.
	//
	// This member is required.
	Name *string

	// The values used to filter devices based on the filter name.
	//
	// This member is required.
	Values []string

	noSmithyDocumentSerde
}

// A filter used to search for Amazon Braket hybrid jobs.
type SearchJobsFilter struct {

	// The name of the hybrid job parameter to filter based on. Filter name can be
	// either jobArn or createdAt .
	//
	// This member is required.
	Name *string

	// An operator to use for the filter.
	//
	// This member is required.
	Operator SearchJobsFilterOperator

	// The values used to filter hybrid jobs based on the filter name and operator.
	//
	// This member is required.
	Values []string

	noSmithyDocumentSerde
}

// A filter used to search for quantum tasks.
type SearchQuantumTasksFilter struct {

	// The name of the quantum task parameter to filter based on. Filter name can be
	// either quantumTaskArn , deviceArn , jobArn , status or createdAt .
	//
	// This member is required.
	Name *string

	// An operator to use for the filter.
	//
	// This member is required.
	Operator SearchQuantumTasksFilterOperator

	// The values used to filter quantum tasks based on the filter name and operator.
	//
	// This member is required.
	Values []string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
