// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Contains information about an agent runtime. An agent runtime is the execution
// environment for a Amazon Bedrock Agent.
type Agent struct {

	// The Amazon Resource Name (ARN) of the agent runtime.
	//
	// This member is required.
	AgentRuntimeArn *string

	// The unique identifier of the agent runtime.
	//
	// This member is required.
	AgentRuntimeId *string

	// The name of the agent runtime.
	//
	// This member is required.
	AgentRuntimeName *string

	// The version of the agent runtime.
	//
	// This member is required.
	AgentRuntimeVersion *string

	// The description of the agent runtime.
	//
	// This member is required.
	Description *string

	// The timestamp when the agent runtime was last updated.
	//
	// This member is required.
	LastUpdatedAt *time.Time

	// The current status of the agent runtime.
	//
	// This member is required.
	Status AgentStatus

	noSmithyDocumentSerde
}

// The artifact of the agent.
//
// The following types satisfy this interface:
//
//	AgentArtifactMemberContainerConfiguration
type AgentArtifact interface {
	isAgentArtifact()
}

// The container configuration for the agent artifact.
type AgentArtifactMemberContainerConfiguration struct {
	Value ContainerConfiguration

	noSmithyDocumentSerde
}

func (*AgentArtifactMemberContainerConfiguration) isAgentArtifact() {}

// Contains information about an agent runtime endpoint. An endpoint provides a
// way to connect to and interact with an agent runtime.
type AgentEndpoint struct {

	// The Amazon Resource Name (ARN) of the agent runtime associated with the
	// endpoint.
	//
	// This member is required.
	AgentRuntimeArn *string

	// The Amazon Resource Name (ARN) of the agent runtime endpoint.
	//
	// This member is required.
	AgentRuntimeEndpointArn *string

	// The timestamp when the agent runtime endpoint was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The unique identifier of the agent runtime endpoint.
	//
	// This member is required.
	Id *string

	// The timestamp when the agent runtime endpoint was last updated.
	//
	// This member is required.
	LastUpdatedAt *time.Time

	// The name of the agent runtime endpoint.
	//
	// This member is required.
	Name *string

	// The current status of the agent runtime endpoint.
	//
	// This member is required.
	Status AgentEndpointStatus

	// The description of the agent runtime endpoint.
	Description *string

	// The live version of the agent runtime endpoint. This is the version that is
	// currently serving requests.
	LiveVersion *string

	// The target version of the agent runtime endpoint. This is the version that the
	// endpoint is being updated to.
	TargetVersion *string

	noSmithyDocumentSerde
}

// Contains information about an API key credential provider.
type ApiKeyCredentialProviderItem struct {

	// The timestamp when the API key credential provider was created.
	//
	// This member is required.
	CreatedTime *time.Time

	// The Amazon Resource Name (ARN) of the API key credential provider.
	//
	// This member is required.
	CredentialProviderArn *string

	// The timestamp when the API key credential provider was last updated.
	//
	// This member is required.
	LastUpdatedTime *time.Time

	// The name of the API key credential provider.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// Configuration for API schema.
//
// The following types satisfy this interface:
//
//	ApiSchemaConfigurationMemberInlinePayload
//	ApiSchemaConfigurationMemberS3
type ApiSchemaConfiguration interface {
	isApiSchemaConfiguration()
}

// The inline payload containing the API schema definition.
type ApiSchemaConfigurationMemberInlinePayload struct {
	Value string

	noSmithyDocumentSerde
}

func (*ApiSchemaConfigurationMemberInlinePayload) isApiSchemaConfiguration() {}

// The Amazon S3 configuration for a gateway. This structure defines how the
// gateway accesses files in Amazon S3.
type ApiSchemaConfigurationMemberS3 struct {
	Value S3Configuration

	noSmithyDocumentSerde
}

func (*ApiSchemaConfigurationMemberS3) isApiSchemaConfiguration() {}

// Represents inbound authorization configuration options used to authenticate
// incoming requests.
//
// The following types satisfy this interface:
//
//	AuthorizerConfigurationMemberCustomJWTAuthorizer
type AuthorizerConfiguration interface {
	isAuthorizerConfiguration()
}

// The inbound JWT-based authorization, specifying how incoming requests should be
// authenticated.
type AuthorizerConfigurationMemberCustomJWTAuthorizer struct {
	Value CustomJWTAuthorizerConfiguration

	noSmithyDocumentSerde
}

func (*AuthorizerConfigurationMemberCustomJWTAuthorizer) isAuthorizerConfiguration() {}

// The network configuration for a browser. This structure defines how the browser
// connects to the network.
type BrowserNetworkConfiguration struct {

	// The network mode for the browser. This field specifies how the browser connects
	// to the network.
	//
	// This member is required.
	NetworkMode BrowserNetworkMode

	noSmithyDocumentSerde
}

// Contains summary information about a browser. A browser enables Amazon Bedrock
// Agent to interact with web content.
type BrowserSummary struct {

	// The Amazon Resource Name (ARN) of the browser.
	//
	// This member is required.
	BrowserArn *string

	// The unique identifier of the browser.
	//
	// This member is required.
	BrowserId *string

	// The timestamp when the browser was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The current status of the browser.
	//
	// This member is required.
	Status BrowserStatus

	// The description of the browser.
	Description *string

	// The timestamp when the browser was last updated.
	LastUpdatedAt *time.Time

	// The name of the browser.
	Name *string

	noSmithyDocumentSerde
}

// The network configuration for a code interpreter. This structure defines how
// the code interpreter connects to the network.
type CodeInterpreterNetworkConfiguration struct {

	// The network mode for the code interpreter. This field specifies how the code
	// interpreter connects to the network.
	//
	// This member is required.
	NetworkMode CodeInterpreterNetworkMode

	noSmithyDocumentSerde
}

// Contains summary information about a code interpreter. A code interpreter
// enables Amazon Bedrock Agent to execute code.
type CodeInterpreterSummary struct {

	// The Amazon Resource Name (ARN) of the code interpreter.
	//
	// This member is required.
	CodeInterpreterArn *string

	// The unique identifier of the code interpreter.
	//
	// This member is required.
	CodeInterpreterId *string

	// The timestamp when the code interpreter was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The current status of the code interpreter.
	//
	// This member is required.
	Status CodeInterpreterStatus

	// The description of the code interpreter.
	Description *string

	// The timestamp when the code interpreter was last updated.
	LastUpdatedAt *time.Time

	// The name of the code interpreter.
	Name *string

	noSmithyDocumentSerde
}

// Contains consolidation configuration information for a memory strategy.
//
// The following types satisfy this interface:
//
//	ConsolidationConfigurationMemberCustomConsolidationConfiguration
type ConsolidationConfiguration interface {
	isConsolidationConfiguration()
}

// The custom consolidation configuration.
type ConsolidationConfigurationMemberCustomConsolidationConfiguration struct {
	Value CustomConsolidationConfiguration

	noSmithyDocumentSerde
}

func (*ConsolidationConfigurationMemberCustomConsolidationConfiguration) isConsolidationConfiguration() {
}

// Representation of a container configuration.
type ContainerConfiguration struct {

	// The ECR URI of the container.
	//
	// This member is required.
	ContainerUri *string

	noSmithyDocumentSerde
}

// A credential provider for gateway authentication. This structure contains the
// configuration for authenticating with the target endpoint.
//
// The following types satisfy this interface:
//
//	CredentialProviderMemberApiKeyCredentialProvider
//	CredentialProviderMemberOauthCredentialProvider
type CredentialProvider interface {
	isCredentialProvider()
}

// The API key credential provider. This provider uses an API key to authenticate
// with the target endpoint.
type CredentialProviderMemberApiKeyCredentialProvider struct {
	Value GatewayApiKeyCredentialProvider

	noSmithyDocumentSerde
}

func (*CredentialProviderMemberApiKeyCredentialProvider) isCredentialProvider() {}

// The OAuth credential provider. This provider uses OAuth authentication to
// access the target endpoint.
type CredentialProviderMemberOauthCredentialProvider struct {
	Value OAuthCredentialProvider

	noSmithyDocumentSerde
}

func (*CredentialProviderMemberOauthCredentialProvider) isCredentialProvider() {}

// The configuration for a credential provider. This structure defines how the
// gateway authenticates with the target endpoint.
type CredentialProviderConfiguration struct {

	// The type of credential provider. This field specifies which authentication
	// method the gateway uses.
	//
	// This member is required.
	CredentialProviderType CredentialProviderType

	// The credential provider. This field contains the specific configuration for the
	// credential provider type.
	CredentialProvider CredentialProvider

	noSmithyDocumentSerde
}

// Input for custom configuration of a memory strategy.
//
// The following types satisfy this interface:
//
//	CustomConfigurationInputMemberSemanticOverride
//	CustomConfigurationInputMemberSummaryOverride
//	CustomConfigurationInputMemberUserPreferenceOverride
type CustomConfigurationInput interface {
	isCustomConfigurationInput()
}

// The semantic override configuration for a custom memory strategy.
type CustomConfigurationInputMemberSemanticOverride struct {
	Value SemanticOverrideConfigurationInput

	noSmithyDocumentSerde
}

func (*CustomConfigurationInputMemberSemanticOverride) isCustomConfigurationInput() {}

// The summary override configuration for a custom memory strategy.
type CustomConfigurationInputMemberSummaryOverride struct {
	Value SummaryOverrideConfigurationInput

	noSmithyDocumentSerde
}

func (*CustomConfigurationInputMemberSummaryOverride) isCustomConfigurationInput() {}

// The user preference override configuration for a custom memory strategy.
type CustomConfigurationInputMemberUserPreferenceOverride struct {
	Value UserPreferenceOverrideConfigurationInput

	noSmithyDocumentSerde
}

func (*CustomConfigurationInputMemberUserPreferenceOverride) isCustomConfigurationInput() {}

// Contains custom consolidation configuration information.
//
// The following types satisfy this interface:
//
//	CustomConsolidationConfigurationMemberSemanticConsolidationOverride
//	CustomConsolidationConfigurationMemberSummaryConsolidationOverride
//	CustomConsolidationConfigurationMemberUserPreferenceConsolidationOverride
type CustomConsolidationConfiguration interface {
	isCustomConsolidationConfiguration()
}

// The semantic consolidation override configuration.
type CustomConsolidationConfigurationMemberSemanticConsolidationOverride struct {
	Value SemanticConsolidationOverride

	noSmithyDocumentSerde
}

func (*CustomConsolidationConfigurationMemberSemanticConsolidationOverride) isCustomConsolidationConfiguration() {
}

// The summary consolidation override configuration.
type CustomConsolidationConfigurationMemberSummaryConsolidationOverride struct {
	Value SummaryConsolidationOverride

	noSmithyDocumentSerde
}

func (*CustomConsolidationConfigurationMemberSummaryConsolidationOverride) isCustomConsolidationConfiguration() {
}

// The user preference consolidation override configuration.
type CustomConsolidationConfigurationMemberUserPreferenceConsolidationOverride struct {
	Value UserPreferenceConsolidationOverride

	noSmithyDocumentSerde
}

func (*CustomConsolidationConfigurationMemberUserPreferenceConsolidationOverride) isCustomConsolidationConfiguration() {
}

// Input for a custom consolidation configuration.
//
// The following types satisfy this interface:
//
//	CustomConsolidationConfigurationInputMemberSemanticConsolidationOverride
//	CustomConsolidationConfigurationInputMemberSummaryConsolidationOverride
//	CustomConsolidationConfigurationInputMemberUserPreferenceConsolidationOverride
type CustomConsolidationConfigurationInput interface {
	isCustomConsolidationConfigurationInput()
}

// The semantic consolidation override configuration input.
type CustomConsolidationConfigurationInputMemberSemanticConsolidationOverride struct {
	Value SemanticOverrideConsolidationConfigurationInput

	noSmithyDocumentSerde
}

func (*CustomConsolidationConfigurationInputMemberSemanticConsolidationOverride) isCustomConsolidationConfigurationInput() {
}

// The summary consolidation override configuration input.
type CustomConsolidationConfigurationInputMemberSummaryConsolidationOverride struct {
	Value SummaryOverrideConsolidationConfigurationInput

	noSmithyDocumentSerde
}

func (*CustomConsolidationConfigurationInputMemberSummaryConsolidationOverride) isCustomConsolidationConfigurationInput() {
}

// The user preference consolidation override configuration input.
type CustomConsolidationConfigurationInputMemberUserPreferenceConsolidationOverride struct {
	Value UserPreferenceOverrideConsolidationConfigurationInput

	noSmithyDocumentSerde
}

func (*CustomConsolidationConfigurationInputMemberUserPreferenceConsolidationOverride) isCustomConsolidationConfigurationInput() {
}

// Contains custom extraction configuration information.
//
// The following types satisfy this interface:
//
//	CustomExtractionConfigurationMemberSemanticExtractionOverride
//	CustomExtractionConfigurationMemberUserPreferenceExtractionOverride
type CustomExtractionConfiguration interface {
	isCustomExtractionConfiguration()
}

// The semantic extraction override configuration.
type CustomExtractionConfigurationMemberSemanticExtractionOverride struct {
	Value SemanticExtractionOverride

	noSmithyDocumentSerde
}

func (*CustomExtractionConfigurationMemberSemanticExtractionOverride) isCustomExtractionConfiguration() {
}

// The user preference extraction override configuration.
type CustomExtractionConfigurationMemberUserPreferenceExtractionOverride struct {
	Value UserPreferenceExtractionOverride

	noSmithyDocumentSerde
}

func (*CustomExtractionConfigurationMemberUserPreferenceExtractionOverride) isCustomExtractionConfiguration() {
}

// Input for a custom extraction configuration.
//
// The following types satisfy this interface:
//
//	CustomExtractionConfigurationInputMemberSemanticExtractionOverride
//	CustomExtractionConfigurationInputMemberUserPreferenceExtractionOverride
type CustomExtractionConfigurationInput interface {
	isCustomExtractionConfigurationInput()
}

// The semantic extraction override configuration input.
type CustomExtractionConfigurationInputMemberSemanticExtractionOverride struct {
	Value SemanticOverrideExtractionConfigurationInput

	noSmithyDocumentSerde
}

func (*CustomExtractionConfigurationInputMemberSemanticExtractionOverride) isCustomExtractionConfigurationInput() {
}

// The user preference extraction override configuration input.
type CustomExtractionConfigurationInputMemberUserPreferenceExtractionOverride struct {
	Value UserPreferenceOverrideExtractionConfigurationInput

	noSmithyDocumentSerde
}

func (*CustomExtractionConfigurationInputMemberUserPreferenceExtractionOverride) isCustomExtractionConfigurationInput() {
}

// Configuration for inbound JWT-based authorization, specifying how incoming
// requests should be authenticated.
type CustomJWTAuthorizerConfiguration struct {

	// This URL is used to fetch OpenID Connect configuration or authorization server
	// metadata for validating incoming tokens.
	//
	// This member is required.
	DiscoveryUrl *string

	// Represents individual audience values that are validated in the incoming JWT
	// token validation process.
	AllowedAudience []string

	// Represents individual client IDs that are validated in the incoming JWT token
	// validation process.
	AllowedClients []string

	noSmithyDocumentSerde
}

// Input for creating a custom memory strategy.
type CustomMemoryStrategyInput struct {

	// The name of the custom memory strategy.
	//
	// This member is required.
	Name *string

	// The configuration for the custom memory strategy.
	Configuration CustomConfigurationInput

	// The description of the custom memory strategy.
	Description *string

	// The namespaces associated with the custom memory strategy.
	Namespaces []string

	noSmithyDocumentSerde
}

// Input configuration for a custom OAuth2 provider.
type CustomOauth2ProviderConfigInput struct {

	// The client ID for the custom OAuth2 provider.
	//
	// This member is required.
	ClientId *string

	// The client secret for the custom OAuth2 provider.
	//
	// This member is required.
	ClientSecret *string

	// The OAuth2 discovery information for the custom provider.
	//
	// This member is required.
	OauthDiscovery Oauth2Discovery

	noSmithyDocumentSerde
}

// Output configuration for a custom OAuth2 provider.
type CustomOauth2ProviderConfigOutput struct {

	// The OAuth2 discovery information for the custom provider.
	//
	// This member is required.
	OauthDiscovery Oauth2Discovery

	noSmithyDocumentSerde
}

// Input for deleting a memory strategy.
type DeleteMemoryStrategyInput struct {

	// The unique identifier of the memory strategy to delete.
	//
	// This member is required.
	MemoryStrategyId *string

	noSmithyDocumentSerde
}

// Contains extraction configuration information for a memory strategy.
//
// The following types satisfy this interface:
//
//	ExtractionConfigurationMemberCustomExtractionConfiguration
type ExtractionConfiguration interface {
	isExtractionConfiguration()
}

// The custom extraction configuration.
type ExtractionConfigurationMemberCustomExtractionConfiguration struct {
	Value CustomExtractionConfiguration

	noSmithyDocumentSerde
}

func (*ExtractionConfigurationMemberCustomExtractionConfiguration) isExtractionConfiguration() {}

// An API key credential provider for gateway authentication. This structure
// contains the configuration for authenticating with the target endpoint using an
// API key.
type GatewayApiKeyCredentialProvider struct {

	// The Amazon Resource Name (ARN) of the API key credential provider. This ARN
	// identifies the provider in Amazon Web Services.
	//
	// This member is required.
	ProviderArn *string

	// The location of the API key credential. This field specifies where in the
	// request the API key should be placed.
	CredentialLocation ApiKeyCredentialLocation

	// The name of the credential parameter for the API key. This parameter name is
	// used when sending the API key to the target endpoint.
	CredentialParameterName *string

	// The prefix for the API key credential. This prefix is added to the API key when
	// sending it to the target endpoint.
	CredentialPrefix *string

	noSmithyDocumentSerde
}

// The configuration for a gateway protocol. This structure defines how the
// gateway communicates with external services.
//
// The following types satisfy this interface:
//
//	GatewayProtocolConfigurationMemberMcp
type GatewayProtocolConfiguration interface {
	isGatewayProtocolConfiguration()
}

// The configuration for the Model Context Protocol (MCP). This protocol enables
// communication between Amazon Bedrock Agent and external tools.
type GatewayProtocolConfigurationMemberMcp struct {
	Value MCPGatewayConfiguration

	noSmithyDocumentSerde
}

func (*GatewayProtocolConfigurationMemberMcp) isGatewayProtocolConfiguration() {}

// Contains summary information about a gateway.
type GatewaySummary struct {

	// The type of authorizer used by the gateway.
	//
	// This member is required.
	AuthorizerType AuthorizerType

	// The timestamp when the gateway was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The unique identifier of the gateway.
	//
	// This member is required.
	GatewayId *string

	// The name of the gateway.
	//
	// This member is required.
	Name *string

	// The protocol type used by the gateway.
	//
	// This member is required.
	ProtocolType GatewayProtocolType

	// The current status of the gateway.
	//
	// This member is required.
	Status GatewayStatus

	// The timestamp when the gateway was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The description of the gateway.
	Description *string

	noSmithyDocumentSerde
}

// Input configuration for a GitHub OAuth2 provider.
type GithubOauth2ProviderConfigInput struct {

	// The client ID for the GitHub OAuth2 provider.
	//
	// This member is required.
	ClientId *string

	// The client secret for the GitHub OAuth2 provider.
	//
	// This member is required.
	ClientSecret *string

	noSmithyDocumentSerde
}

// Output configuration for a GitHub OAuth2 provider.
type GithubOauth2ProviderConfigOutput struct {

	// The OAuth2 discovery information for the GitHub provider.
	//
	// This member is required.
	OauthDiscovery Oauth2Discovery

	noSmithyDocumentSerde
}

// Input configuration for a Google OAuth2 provider.
type GoogleOauth2ProviderConfigInput struct {

	// The client ID for the Google OAuth2 provider.
	//
	// This member is required.
	ClientId *string

	// The client secret for the Google OAuth2 provider.
	//
	// This member is required.
	ClientSecret *string

	noSmithyDocumentSerde
}

// Output configuration for a Google OAuth2 provider.
type GoogleOauth2ProviderConfigOutput struct {

	// The OAuth2 discovery information for the Google provider.
	//
	// This member is required.
	OauthDiscovery Oauth2Discovery

	noSmithyDocumentSerde
}

// Contains the KMS configuration for a resource.
type KmsConfiguration struct {

	// The type of KMS key (CustomerManagedKey or ServiceManagedKey).
	//
	// This member is required.
	KeyType KeyType

	// The Amazon Resource Name (ARN) of the KMS key.
	KmsKeyArn *string

	noSmithyDocumentSerde
}

// The configuration for a Model Context Protocol (MCP) gateway. This structure
// defines how the gateway implements the MCP protocol.
type MCPGatewayConfiguration struct {

	// The instructions for using the Model Context Protocol gateway. These
	// instructions provide guidance on how to interact with the gateway.
	Instructions *string

	// The search type for the Model Context Protocol gateway. This field specifies
	// how the gateway handles search operations.
	SearchType SearchType

	// The supported versions of the Model Context Protocol. This field specifies
	// which versions of the protocol the gateway can use.
	SupportedVersions []string

	noSmithyDocumentSerde
}

// The Lambda configuration for a Model Context Protocol target. This structure
// defines how the gateway uses a Lambda function to communicate with the target.
type McpLambdaTargetConfiguration struct {

	// The Amazon Resource Name (ARN) of the Lambda function. This function is invoked
	// by the gateway to communicate with the target.
	//
	// This member is required.
	LambdaArn *string

	// The tool schema for the Lambda function. This schema defines the structure of
	// the tools that the Lambda function provides.
	//
	// This member is required.
	ToolSchema ToolSchema

	noSmithyDocumentSerde
}

// The Model Context Protocol (MCP) configuration for a target. This structure
// defines how the gateway uses MCP to communicate with the target.
//
// The following types satisfy this interface:
//
//	McpTargetConfigurationMemberLambda
//	McpTargetConfigurationMemberOpenApiSchema
//	McpTargetConfigurationMemberSmithyModel
type McpTargetConfiguration interface {
	isMcpTargetConfiguration()
}

// The Lambda configuration for the Model Context Protocol target. This
// configuration defines how the gateway uses a Lambda function to communicate with
// the target.
type McpTargetConfigurationMemberLambda struct {
	Value McpLambdaTargetConfiguration

	noSmithyDocumentSerde
}

func (*McpTargetConfigurationMemberLambda) isMcpTargetConfiguration() {}

// The OpenAPI schema for the Model Context Protocol target. This schema defines
// the API structure of the target.
type McpTargetConfigurationMemberOpenApiSchema struct {
	Value ApiSchemaConfiguration

	noSmithyDocumentSerde
}

func (*McpTargetConfigurationMemberOpenApiSchema) isMcpTargetConfiguration() {}

// The Smithy model for the Model Context Protocol target. This model defines the
// API structure of the target using the Smithy specification.
type McpTargetConfigurationMemberSmithyModel struct {
	Value ApiSchemaConfiguration

	noSmithyDocumentSerde
}

func (*McpTargetConfigurationMemberSmithyModel) isMcpTargetConfiguration() {}

// Contains information about a memory resource.
type Memory struct {

	// The Amazon Resource Name (ARN) of the memory.
	//
	// This member is required.
	Arn *string

	// The timestamp when the memory was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The number of days after which memory events will expire.
	//
	// This member is required.
	EventExpiryDuration *int32

	// The unique identifier of the memory.
	//
	// This member is required.
	Id *string

	// The name of the memory.
	//
	// This member is required.
	Name *string

	// The current status of the memory.
	//
	// This member is required.
	Status MemoryStatus

	// The timestamp when the memory was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The description of the memory.
	Description *string

	// The ARN of the KMS key used to encrypt the memory.
	EncryptionKeyArn *string

	// The reason for failure if the memory is in a failed state.
	FailureReason *string

	// The ARN of the IAM role that provides permissions for the memory.
	MemoryExecutionRoleArn *string

	// The list of memory strategies associated with this memory.
	Strategies []MemoryStrategy

	noSmithyDocumentSerde
}

// Contains information about a memory strategy.
type MemoryStrategy struct {

	// The name of the memory strategy.
	//
	// This member is required.
	Name *string

	// The namespaces associated with the memory strategy.
	//
	// This member is required.
	Namespaces []string

	// The unique identifier of the memory strategy.
	//
	// This member is required.
	StrategyId *string

	// The type of the memory strategy.
	//
	// This member is required.
	Type MemoryStrategyType

	// The configuration of the memory strategy.
	Configuration *StrategyConfiguration

	// The timestamp when the memory strategy was created.
	CreatedAt *time.Time

	// The description of the memory strategy.
	Description *string

	// The current status of the memory strategy.
	Status MemoryStrategyStatus

	// The timestamp when the memory strategy was last updated.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// Contains input information for creating a memory strategy.
//
// The following types satisfy this interface:
//
//	MemoryStrategyInputMemberCustomMemoryStrategy
//	MemoryStrategyInputMemberSemanticMemoryStrategy
//	MemoryStrategyInputMemberSummaryMemoryStrategy
//	MemoryStrategyInputMemberUserPreferenceMemoryStrategy
type MemoryStrategyInput interface {
	isMemoryStrategyInput()
}

// Input for creating a custom memory strategy.
type MemoryStrategyInputMemberCustomMemoryStrategy struct {
	Value CustomMemoryStrategyInput

	noSmithyDocumentSerde
}

func (*MemoryStrategyInputMemberCustomMemoryStrategy) isMemoryStrategyInput() {}

// Input for creating a semantic memory strategy.
type MemoryStrategyInputMemberSemanticMemoryStrategy struct {
	Value SemanticMemoryStrategyInput

	noSmithyDocumentSerde
}

func (*MemoryStrategyInputMemberSemanticMemoryStrategy) isMemoryStrategyInput() {}

// Input for creating a summary memory strategy.
type MemoryStrategyInputMemberSummaryMemoryStrategy struct {
	Value SummaryMemoryStrategyInput

	noSmithyDocumentSerde
}

func (*MemoryStrategyInputMemberSummaryMemoryStrategy) isMemoryStrategyInput() {}

// Input for creating a user preference memory strategy.
type MemoryStrategyInputMemberUserPreferenceMemoryStrategy struct {
	Value UserPreferenceMemoryStrategyInput

	noSmithyDocumentSerde
}

func (*MemoryStrategyInputMemberUserPreferenceMemoryStrategy) isMemoryStrategyInput() {}

// Contains summary information about a memory resource.
type MemorySummary struct {

	// The timestamp when the memory was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The timestamp when the memory was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The Amazon Resource Name (ARN) of the memory.
	Arn *string

	// The unique identifier of the memory.
	Id *string

	// The current status of the memory.
	Status MemoryStatus

	noSmithyDocumentSerde
}

// Input configuration for a Microsoft OAuth2 provider.
type MicrosoftOauth2ProviderConfigInput struct {

	// The client ID for the Microsoft OAuth2 provider.
	//
	// This member is required.
	ClientId *string

	// The client secret for the Microsoft OAuth2 provider.
	//
	// This member is required.
	ClientSecret *string

	noSmithyDocumentSerde
}

// Output configuration for a Microsoft OAuth2 provider.
type MicrosoftOauth2ProviderConfigOutput struct {

	// The OAuth2 discovery information for the Microsoft provider.
	//
	// This member is required.
	OauthDiscovery Oauth2Discovery

	noSmithyDocumentSerde
}

// Contains information for modifying a consolidation configuration.
//
// The following types satisfy this interface:
//
//	ModifyConsolidationConfigurationMemberCustomConsolidationConfiguration
type ModifyConsolidationConfiguration interface {
	isModifyConsolidationConfiguration()
}

// The updated custom consolidation configuration.
type ModifyConsolidationConfigurationMemberCustomConsolidationConfiguration struct {
	Value CustomConsolidationConfigurationInput

	noSmithyDocumentSerde
}

func (*ModifyConsolidationConfigurationMemberCustomConsolidationConfiguration) isModifyConsolidationConfiguration() {
}

// Contains information for modifying an extraction configuration.
//
// The following types satisfy this interface:
//
//	ModifyExtractionConfigurationMemberCustomExtractionConfiguration
type ModifyExtractionConfiguration interface {
	isModifyExtractionConfiguration()
}

// The updated custom extraction configuration.
type ModifyExtractionConfigurationMemberCustomExtractionConfiguration struct {
	Value CustomExtractionConfigurationInput

	noSmithyDocumentSerde
}

func (*ModifyExtractionConfigurationMemberCustomExtractionConfiguration) isModifyExtractionConfiguration() {
}

// Contains information for modifying memory strategies.
type ModifyMemoryStrategies struct {

	// The list of memory strategies to add.
	AddMemoryStrategies []MemoryStrategyInput

	// The list of memory strategies to delete.
	DeleteMemoryStrategies []DeleteMemoryStrategyInput

	// The list of memory strategies to modify.
	ModifyMemoryStrategies []ModifyMemoryStrategyInput

	noSmithyDocumentSerde
}

// Input for modifying a memory strategy.
type ModifyMemoryStrategyInput struct {

	// The unique identifier of the memory strategy to modify.
	//
	// This member is required.
	MemoryStrategyId *string

	// The updated configuration for the memory strategy.
	Configuration *ModifyStrategyConfiguration

	// The updated description of the memory strategy.
	Description *string

	// The updated namespaces for the memory strategy.
	Namespaces []string

	noSmithyDocumentSerde
}

// Contains information for modifying a strategy configuration.
type ModifyStrategyConfiguration struct {

	// The updated consolidation configuration.
	Consolidation ModifyConsolidationConfiguration

	// The updated extraction configuration.
	Extraction ModifyExtractionConfiguration

	noSmithyDocumentSerde
}

// SecurityConfig for the Agent.
type NetworkConfiguration struct {

	// The network mode for the agent runtime.
	//
	// This member is required.
	NetworkMode NetworkMode

	noSmithyDocumentSerde
}

// Contains the authorization server metadata for an OAuth2 provider.
type Oauth2AuthorizationServerMetadata struct {

	// The authorization endpoint URL for the OAuth2 authorization server.
	//
	// This member is required.
	AuthorizationEndpoint *string

	// The issuer URL for the OAuth2 authorization server.
	//
	// This member is required.
	Issuer *string

	// The token endpoint URL for the OAuth2 authorization server.
	//
	// This member is required.
	TokenEndpoint *string

	// The supported response types for the OAuth2 authorization server.
	ResponseTypes []string

	noSmithyDocumentSerde
}

// Contains information about an OAuth2 credential provider.
type Oauth2CredentialProviderItem struct {

	// The timestamp when the OAuth2 credential provider was created.
	//
	// This member is required.
	CreatedTime *time.Time

	// The Amazon Resource Name (ARN) of the OAuth2 credential provider.
	//
	// This member is required.
	CredentialProviderArn *string

	// The vendor of the OAuth2 credential provider.
	//
	// This member is required.
	CredentialProviderVendor CredentialProviderVendorType

	// The timestamp when the OAuth2 credential provider was last updated.
	//
	// This member is required.
	LastUpdatedTime *time.Time

	// The name of the OAuth2 credential provider.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// Contains the discovery information for an OAuth2 provider.
//
// The following types satisfy this interface:
//
//	Oauth2DiscoveryMemberAuthorizationServerMetadata
//	Oauth2DiscoveryMemberDiscoveryUrl
type Oauth2Discovery interface {
	isOauth2Discovery()
}

// The authorization server metadata for the OAuth2 provider.
type Oauth2DiscoveryMemberAuthorizationServerMetadata struct {
	Value Oauth2AuthorizationServerMetadata

	noSmithyDocumentSerde
}

func (*Oauth2DiscoveryMemberAuthorizationServerMetadata) isOauth2Discovery() {}

// The discovery URL for the OAuth2 provider.
type Oauth2DiscoveryMemberDiscoveryUrl struct {
	Value string

	noSmithyDocumentSerde
}

func (*Oauth2DiscoveryMemberDiscoveryUrl) isOauth2Discovery() {}

// Contains the input configuration for an OAuth2 provider.
//
// The following types satisfy this interface:
//
//	Oauth2ProviderConfigInputMemberCustomOauth2ProviderConfig
//	Oauth2ProviderConfigInputMemberGithubOauth2ProviderConfig
//	Oauth2ProviderConfigInputMemberGoogleOauth2ProviderConfig
//	Oauth2ProviderConfigInputMemberMicrosoftOauth2ProviderConfig
//	Oauth2ProviderConfigInputMemberSalesforceOauth2ProviderConfig
//	Oauth2ProviderConfigInputMemberSlackOauth2ProviderConfig
type Oauth2ProviderConfigInput interface {
	isOauth2ProviderConfigInput()
}

// The configuration for a custom OAuth2 provider.
type Oauth2ProviderConfigInputMemberCustomOauth2ProviderConfig struct {
	Value CustomOauth2ProviderConfigInput

	noSmithyDocumentSerde
}

func (*Oauth2ProviderConfigInputMemberCustomOauth2ProviderConfig) isOauth2ProviderConfigInput() {}

// The configuration for a GitHub OAuth2 provider.
type Oauth2ProviderConfigInputMemberGithubOauth2ProviderConfig struct {
	Value GithubOauth2ProviderConfigInput

	noSmithyDocumentSerde
}

func (*Oauth2ProviderConfigInputMemberGithubOauth2ProviderConfig) isOauth2ProviderConfigInput() {}

// The configuration for a Google OAuth2 provider.
type Oauth2ProviderConfigInputMemberGoogleOauth2ProviderConfig struct {
	Value GoogleOauth2ProviderConfigInput

	noSmithyDocumentSerde
}

func (*Oauth2ProviderConfigInputMemberGoogleOauth2ProviderConfig) isOauth2ProviderConfigInput() {}

// The configuration for a Microsoft OAuth2 provider.
type Oauth2ProviderConfigInputMemberMicrosoftOauth2ProviderConfig struct {
	Value MicrosoftOauth2ProviderConfigInput

	noSmithyDocumentSerde
}

func (*Oauth2ProviderConfigInputMemberMicrosoftOauth2ProviderConfig) isOauth2ProviderConfigInput() {}

// The configuration for a Salesforce OAuth2 provider.
type Oauth2ProviderConfigInputMemberSalesforceOauth2ProviderConfig struct {
	Value SalesforceOauth2ProviderConfigInput

	noSmithyDocumentSerde
}

func (*Oauth2ProviderConfigInputMemberSalesforceOauth2ProviderConfig) isOauth2ProviderConfigInput() {}

// The configuration for a Slack OAuth2 provider.
type Oauth2ProviderConfigInputMemberSlackOauth2ProviderConfig struct {
	Value SlackOauth2ProviderConfigInput

	noSmithyDocumentSerde
}

func (*Oauth2ProviderConfigInputMemberSlackOauth2ProviderConfig) isOauth2ProviderConfigInput() {}

// Contains the output configuration for an OAuth2 provider.
//
// The following types satisfy this interface:
//
//	Oauth2ProviderConfigOutputMemberCustomOauth2ProviderConfig
//	Oauth2ProviderConfigOutputMemberGithubOauth2ProviderConfig
//	Oauth2ProviderConfigOutputMemberGoogleOauth2ProviderConfig
//	Oauth2ProviderConfigOutputMemberMicrosoftOauth2ProviderConfig
//	Oauth2ProviderConfigOutputMemberSalesforceOauth2ProviderConfig
//	Oauth2ProviderConfigOutputMemberSlackOauth2ProviderConfig
type Oauth2ProviderConfigOutput interface {
	isOauth2ProviderConfigOutput()
}

// The output configuration for a custom OAuth2 provider.
type Oauth2ProviderConfigOutputMemberCustomOauth2ProviderConfig struct {
	Value CustomOauth2ProviderConfigOutput

	noSmithyDocumentSerde
}

func (*Oauth2ProviderConfigOutputMemberCustomOauth2ProviderConfig) isOauth2ProviderConfigOutput() {}

// The output configuration for a GitHub OAuth2 provider.
type Oauth2ProviderConfigOutputMemberGithubOauth2ProviderConfig struct {
	Value GithubOauth2ProviderConfigOutput

	noSmithyDocumentSerde
}

func (*Oauth2ProviderConfigOutputMemberGithubOauth2ProviderConfig) isOauth2ProviderConfigOutput() {}

// The output configuration for a Google OAuth2 provider.
type Oauth2ProviderConfigOutputMemberGoogleOauth2ProviderConfig struct {
	Value GoogleOauth2ProviderConfigOutput

	noSmithyDocumentSerde
}

func (*Oauth2ProviderConfigOutputMemberGoogleOauth2ProviderConfig) isOauth2ProviderConfigOutput() {}

// The output configuration for a Microsoft OAuth2 provider.
type Oauth2ProviderConfigOutputMemberMicrosoftOauth2ProviderConfig struct {
	Value MicrosoftOauth2ProviderConfigOutput

	noSmithyDocumentSerde
}

func (*Oauth2ProviderConfigOutputMemberMicrosoftOauth2ProviderConfig) isOauth2ProviderConfigOutput() {
}

// The output configuration for a Salesforce OAuth2 provider.
type Oauth2ProviderConfigOutputMemberSalesforceOauth2ProviderConfig struct {
	Value SalesforceOauth2ProviderConfigOutput

	noSmithyDocumentSerde
}

func (*Oauth2ProviderConfigOutputMemberSalesforceOauth2ProviderConfig) isOauth2ProviderConfigOutput() {
}

// The output configuration for a Slack OAuth2 provider.
type Oauth2ProviderConfigOutputMemberSlackOauth2ProviderConfig struct {
	Value SlackOauth2ProviderConfigOutput

	noSmithyDocumentSerde
}

func (*Oauth2ProviderConfigOutputMemberSlackOauth2ProviderConfig) isOauth2ProviderConfigOutput() {}

// An OAuth credential provider for gateway authentication. This structure
// contains the configuration for authenticating with the target endpoint using
// OAuth.
type OAuthCredentialProvider struct {

	// The Amazon Resource Name (ARN) of the OAuth credential provider. This ARN
	// identifies the provider in Amazon Web Services.
	//
	// This member is required.
	ProviderArn *string

	// The OAuth scopes for the credential provider. These scopes define the level of
	// access requested from the OAuth provider.
	//
	// This member is required.
	Scopes []string

	// The custom parameters for the OAuth credential provider. These parameters
	// provide additional configuration for the OAuth authentication process.
	CustomParameters map[string]string

	noSmithyDocumentSerde
}

// The protocol configuration for an agent runtime. This structure defines how the
// agent runtime communicates with clients.
type ProtocolConfiguration struct {

	// The server protocol for the agent runtime. This field specifies which protocol
	// the agent runtime uses to communicate with clients.
	//
	// This member is required.
	ServerProtocol ServerProtocol

	noSmithyDocumentSerde
}

// The recording configuration for a browser. This structure defines how browser
// sessions are recorded.
type RecordingConfig struct {

	// Indicates whether recording is enabled for the browser. When set to true,
	// browser sessions are recorded.
	Enabled bool

	// The Amazon S3 location where browser recordings are stored. This location
	// contains the recorded browser sessions.
	S3Location *S3Location

	noSmithyDocumentSerde
}

// The Amazon S3 configuration for a gateway. This structure defines how the
// gateway accesses files in Amazon S3.
type S3Configuration struct {

	// The account ID of the Amazon S3 bucket owner. This ID is used for cross-account
	// access to the bucket.
	BucketOwnerAccountId *string

	// The URI of the Amazon S3 object. This URI specifies the location of the object
	// in Amazon S3.
	Uri *string

	noSmithyDocumentSerde
}

// The Amazon S3 location for storing data. This structure defines where in Amazon
// S3 data is stored.
type S3Location struct {

	// The name of the Amazon S3 bucket. This bucket contains the stored data.
	//
	// This member is required.
	Bucket *string

	// The prefix for objects in the Amazon S3 bucket. This prefix is added to the
	// object keys to organize the data.
	//
	// This member is required.
	Prefix *string

	noSmithyDocumentSerde
}

// Input configuration for a Salesforce OAuth2 provider.
type SalesforceOauth2ProviderConfigInput struct {

	// The client ID for the Salesforce OAuth2 provider.
	//
	// This member is required.
	ClientId *string

	// The client secret for the Salesforce OAuth2 provider.
	//
	// This member is required.
	ClientSecret *string

	noSmithyDocumentSerde
}

// Output configuration for a Salesforce OAuth2 provider.
type SalesforceOauth2ProviderConfigOutput struct {

	// The OAuth2 discovery information for the Salesforce provider.
	//
	// This member is required.
	OauthDiscovery Oauth2Discovery

	noSmithyDocumentSerde
}

// A schema definition for a gateway target. This structure defines the structure
// of the API that the target exposes.
type SchemaDefinition struct {

	// The type of the schema definition. This field specifies the data type of the
	// schema.
	//
	// This member is required.
	Type SchemaType

	// The description of the schema definition. This description provides information
	// about the purpose and usage of the schema.
	Description *string

	// The items in the schema definition. This field is used for array types to
	// define the structure of the array elements.
	Items *SchemaDefinition

	// The properties of the schema definition. These properties define the fields in
	// the schema.
	Properties map[string]SchemaDefinition

	// The required fields in the schema definition. These fields must be provided
	// when using the schema.
	Required []string

	noSmithyDocumentSerde
}

// Contains information about a secret in AWS Secrets Manager.
type Secret struct {

	// The Amazon Resource Name (ARN) of the secret in AWS Secrets Manager.
	//
	// This member is required.
	SecretArn *string

	noSmithyDocumentSerde
}

// Contains semantic consolidation override configuration.
type SemanticConsolidationOverride struct {

	// The text to append to the prompt for semantic consolidation.
	//
	// This member is required.
	AppendToPrompt *string

	// The model ID to use for semantic consolidation.
	//
	// This member is required.
	ModelId *string

	noSmithyDocumentSerde
}

// Contains semantic extraction override configuration.
type SemanticExtractionOverride struct {

	// The text to append to the prompt for semantic extraction.
	//
	// This member is required.
	AppendToPrompt *string

	// The model ID to use for semantic extraction.
	//
	// This member is required.
	ModelId *string

	noSmithyDocumentSerde
}

// Input for creating a semantic memory strategy.
type SemanticMemoryStrategyInput struct {

	// The name of the semantic memory strategy.
	//
	// This member is required.
	Name *string

	// The description of the semantic memory strategy.
	Description *string

	// The namespaces associated with the semantic memory strategy.
	Namespaces []string

	noSmithyDocumentSerde
}

// Input for semantic override configuration in a memory strategy.
type SemanticOverrideConfigurationInput struct {

	// The consolidation configuration for a semantic override.
	Consolidation *SemanticOverrideConsolidationConfigurationInput

	// The extraction configuration for a semantic override.
	Extraction *SemanticOverrideExtractionConfigurationInput

	noSmithyDocumentSerde
}

// Input for semantic override consolidation configuration in a memory strategy.
type SemanticOverrideConsolidationConfigurationInput struct {

	// The text to append to the prompt for semantic consolidation.
	//
	// This member is required.
	AppendToPrompt *string

	// The model ID to use for semantic consolidation.
	//
	// This member is required.
	ModelId *string

	noSmithyDocumentSerde
}

// Input for semantic override extraction configuration in a memory strategy.
type SemanticOverrideExtractionConfigurationInput struct {

	// The text to append to the prompt for semantic extraction.
	//
	// This member is required.
	AppendToPrompt *string

	// The model ID to use for semantic extraction.
	//
	// This member is required.
	ModelId *string

	noSmithyDocumentSerde
}

// Input configuration for a Slack OAuth2 provider.
type SlackOauth2ProviderConfigInput struct {

	// The client ID for the Slack OAuth2 provider.
	//
	// This member is required.
	ClientId *string

	// The client secret for the Slack OAuth2 provider.
	//
	// This member is required.
	ClientSecret *string

	noSmithyDocumentSerde
}

// Output configuration for a Slack OAuth2 provider.
type SlackOauth2ProviderConfigOutput struct {

	// The OAuth2 discovery information for the Slack provider.
	//
	// This member is required.
	OauthDiscovery Oauth2Discovery

	noSmithyDocumentSerde
}

// Contains configuration information for a memory strategy.
type StrategyConfiguration struct {

	// The consolidation configuration for the memory strategy.
	Consolidation ConsolidationConfiguration

	// The extraction configuration for the memory strategy.
	Extraction ExtractionConfiguration

	// The type of override for the strategy configuration.
	Type OverrideType

	noSmithyDocumentSerde
}

// Contains summary consolidation override configuration.
type SummaryConsolidationOverride struct {

	// The text to append to the prompt for summary consolidation.
	//
	// This member is required.
	AppendToPrompt *string

	// The model ID to use for summary consolidation.
	//
	// This member is required.
	ModelId *string

	noSmithyDocumentSerde
}

// Input for creating a summary memory strategy.
type SummaryMemoryStrategyInput struct {

	// The name of the summary memory strategy.
	//
	// This member is required.
	Name *string

	// The description of the summary memory strategy.
	Description *string

	// The namespaces associated with the summary memory strategy.
	Namespaces []string

	noSmithyDocumentSerde
}

// Input for summary override configuration in a memory strategy.
type SummaryOverrideConfigurationInput struct {

	// The consolidation configuration for a summary override.
	Consolidation *SummaryOverrideConsolidationConfigurationInput

	noSmithyDocumentSerde
}

// Input for summary override consolidation configuration in a memory strategy.
type SummaryOverrideConsolidationConfigurationInput struct {

	// The text to append to the prompt for summary consolidation.
	//
	// This member is required.
	AppendToPrompt *string

	// The model ID to use for summary consolidation.
	//
	// This member is required.
	ModelId *string

	noSmithyDocumentSerde
}

// The configuration for a gateway target. This structure defines how the gateway
// connects to and interacts with the target endpoint.
//
// The following types satisfy this interface:
//
//	TargetConfigurationMemberMcp
type TargetConfiguration interface {
	isTargetConfiguration()
}

// The Model Context Protocol (MCP) configuration for the target. This
// configuration defines how the gateway uses MCP to communicate with the target.
type TargetConfigurationMemberMcp struct {
	Value McpTargetConfiguration

	noSmithyDocumentSerde
}

func (*TargetConfigurationMemberMcp) isTargetConfiguration() {}

// Contains summary information about a gateway target. A target represents an
// endpoint that the gateway can connect to.
type TargetSummary struct {

	// The timestamp when the target was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The name of the target.
	//
	// This member is required.
	Name *string

	// The current status of the target.
	//
	// This member is required.
	Status TargetStatus

	// The unique identifier of the target.
	//
	// This member is required.
	TargetId *string

	// The timestamp when the target was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The description of the target.
	Description *string

	noSmithyDocumentSerde
}

// A tool definition for a gateway target. This structure defines a tool that the
// target exposes through the Model Context Protocol.
type ToolDefinition struct {

	// The description of the tool. This description provides information about the
	// purpose and usage of the tool.
	//
	// This member is required.
	Description *string

	// The input schema for the tool. This schema defines the structure of the input
	// that the tool accepts.
	//
	// This member is required.
	InputSchema *SchemaDefinition

	// The name of the tool. This name identifies the tool in the Model Context
	// Protocol.
	//
	// This member is required.
	Name *string

	// The output schema for the tool. This schema defines the structure of the output
	// that the tool produces.
	OutputSchema *SchemaDefinition

	noSmithyDocumentSerde
}

// A tool schema for a gateway target. This structure defines the schema for a
// tool that the target exposes through the Model Context Protocol.
//
// The following types satisfy this interface:
//
//	ToolSchemaMemberInlinePayload
//	ToolSchemaMemberS3
type ToolSchema interface {
	isToolSchema()
}

// The inline payload of the tool schema. This payload contains the schema
// definition directly in the request.
type ToolSchemaMemberInlinePayload struct {
	Value []ToolDefinition

	noSmithyDocumentSerde
}

func (*ToolSchemaMemberInlinePayload) isToolSchema() {}

// The Amazon S3 location of the tool schema. This location contains the schema
// definition file.
type ToolSchemaMemberS3 struct {
	Value S3Configuration

	noSmithyDocumentSerde
}

func (*ToolSchemaMemberS3) isToolSchema() {}

// Contains user preference consolidation override configuration.
type UserPreferenceConsolidationOverride struct {

	// The text to append to the prompt for user preference consolidation.
	//
	// This member is required.
	AppendToPrompt *string

	// The model ID to use for user preference consolidation.
	//
	// This member is required.
	ModelId *string

	noSmithyDocumentSerde
}

// Contains user preference extraction override configuration.
type UserPreferenceExtractionOverride struct {

	// The text to append to the prompt for user preference extraction.
	//
	// This member is required.
	AppendToPrompt *string

	// The model ID to use for user preference extraction.
	//
	// This member is required.
	ModelId *string

	noSmithyDocumentSerde
}

// Input for creating a user preference memory strategy.
type UserPreferenceMemoryStrategyInput struct {

	// The name of the user preference memory strategy.
	//
	// This member is required.
	Name *string

	// The description of the user preference memory strategy.
	Description *string

	// The namespaces associated with the user preference memory strategy.
	Namespaces []string

	noSmithyDocumentSerde
}

// Input for user preference override configuration in a memory strategy.
type UserPreferenceOverrideConfigurationInput struct {

	// The consolidation configuration for a user preference override.
	Consolidation *UserPreferenceOverrideConsolidationConfigurationInput

	// The extraction configuration for a user preference override.
	Extraction *UserPreferenceOverrideExtractionConfigurationInput

	noSmithyDocumentSerde
}

// Input for user preference override consolidation configuration in a memory
// strategy.
type UserPreferenceOverrideConsolidationConfigurationInput struct {

	// The text to append to the prompt for user preference consolidation.
	//
	// This member is required.
	AppendToPrompt *string

	// The model ID to use for user preference consolidation.
	//
	// This member is required.
	ModelId *string

	noSmithyDocumentSerde
}

// Input for user preference override extraction configuration in a memory
// strategy.
type UserPreferenceOverrideExtractionConfigurationInput struct {

	// The text to append to the prompt for user preference extraction.
	//
	// This member is required.
	AppendToPrompt *string

	// The model ID to use for user preference extraction.
	//
	// This member is required.
	ModelId *string

	noSmithyDocumentSerde
}

// Stores information about a field passed inside a request that resulted in an
// exception.
type ValidationExceptionField struct {

	// A message describing why this field failed validation.
	//
	// This member is required.
	Message *string

	// The name of the field.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// The information about the workload identity.
type WorkloadIdentityDetails struct {

	// The ARN associated with the workload identity.
	//
	// This member is required.
	WorkloadIdentityArn *string

	noSmithyDocumentSerde
}

// Contains information about a workload identity.
type WorkloadIdentityType struct {

	// The name of the workload identity.
	//
	// This member is required.
	Name *string

	// The Amazon Resource Name (ARN) of the workload identity.
	//
	// This member is required.
	WorkloadIdentityArn *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isAgentArtifact()                         {}
func (*UnknownUnionMember) isApiSchemaConfiguration()                {}
func (*UnknownUnionMember) isAuthorizerConfiguration()               {}
func (*UnknownUnionMember) isConsolidationConfiguration()            {}
func (*UnknownUnionMember) isCredentialProvider()                    {}
func (*UnknownUnionMember) isCustomConfigurationInput()              {}
func (*UnknownUnionMember) isCustomConsolidationConfiguration()      {}
func (*UnknownUnionMember) isCustomConsolidationConfigurationInput() {}
func (*UnknownUnionMember) isCustomExtractionConfiguration()         {}
func (*UnknownUnionMember) isCustomExtractionConfigurationInput()    {}
func (*UnknownUnionMember) isExtractionConfiguration()               {}
func (*UnknownUnionMember) isGatewayProtocolConfiguration()          {}
func (*UnknownUnionMember) isMcpTargetConfiguration()                {}
func (*UnknownUnionMember) isMemoryStrategyInput()                   {}
func (*UnknownUnionMember) isModifyConsolidationConfiguration()      {}
func (*UnknownUnionMember) isModifyExtractionConfiguration()         {}
func (*UnknownUnionMember) isOauth2Discovery()                       {}
func (*UnknownUnionMember) isOauth2ProviderConfigInput()             {}
func (*UnknownUnionMember) isOauth2ProviderConfigOutput()            {}
func (*UnknownUnionMember) isTargetConfiguration()                   {}
func (*UnknownUnionMember) isToolSchema()                            {}
