// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrockagentcorecontrol

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrockagentcorecontrol/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Creates a gateway for Amazon Bedrock Agent. A gateway serves as an integration
// point between your agent and external services.
//
// To create a gateway, you must specify a name, protocol type, and IAM role. The
// role grants the gateway permission to access Amazon Web Services services and
// resources.
func (c *Client) CreateGateway(ctx context.Context, params *CreateGatewayInput, optFns ...func(*Options)) (*CreateGatewayOutput, error) {
	if params == nil {
		params = &CreateGatewayInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateGateway", params, optFns, c.addOperationCreateGatewayMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateGatewayOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateGatewayInput struct {

	// The authorizer configuration for the Gateway.
	//
	// This member is required.
	AuthorizerConfiguration types.AuthorizerConfiguration

	// The type of authorizer to use for the gateway.
	//
	// This member is required.
	AuthorizerType types.AuthorizerType

	// The name of the gateway. The name must be unique within your account.
	//
	// This member is required.
	Name *string

	// The protocol type for the gateway. Currently supports MCP (Model Context
	// Protocol).
	//
	// This member is required.
	ProtocolType types.GatewayProtocolType

	// The Amazon Resource Name (ARN) of the IAM role that provides permissions for
	// the gateway to access Amazon Web Services services.
	//
	// This member is required.
	RoleArn *string

	// A unique, case-sensitive identifier to ensure that the operation completes no
	// more than one time. If this token matches a previous request, Amazon Bedrock
	// ignores the request but does not return an error.
	ClientToken *string

	// The description of the gateway.
	Description *string

	// The verbosity of exception messages. Use DEBUG mode to see granular exception
	// messages from a Gateway. If this parameter is not set, exception messages are by
	// default sanitized for presentation to end users.
	ExceptionLevel types.ExceptionLevel

	// The Amazon Resource Name (ARN) of the KMS key used to encrypt data associated
	// with the gateway.
	KmsKeyArn *string

	// The configuration settings for the protocol specified in the protocolType
	// parameter.
	ProtocolConfiguration types.GatewayProtocolConfiguration

	noSmithyDocumentSerde
}

type CreateGatewayOutput struct {

	// The type of authorizer used by the gateway.
	//
	// This member is required.
	AuthorizerType types.AuthorizerType

	// The timestamp when the gateway was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The Amazon Resource Name (ARN) of the created gateway.
	//
	// This member is required.
	GatewayArn *string

	// The unique identifier of the created gateway.
	//
	// This member is required.
	GatewayId *string

	// The name of the gateway.
	//
	// This member is required.
	Name *string

	// The protocol type of the gateway.
	//
	// This member is required.
	ProtocolType types.GatewayProtocolType

	// The current status of the gateway.
	//
	// This member is required.
	Status types.GatewayStatus

	// The timestamp when the gateway was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The authorizer configuration for the created Gateway.
	AuthorizerConfiguration types.AuthorizerConfiguration

	// The description of the gateway.
	Description *string

	// The verbosity of exception messages. Use DEBUG mode to see granular exception
	// messages from a Gateway. If this parameter is not set, exception messages are by
	// default sanitized for presentation to end users.
	ExceptionLevel types.ExceptionLevel

	// The URL endpoint for the created gateway.
	GatewayUrl *string

	// The Amazon Resource Name (ARN) of the KMS key used to encrypt data associated
	// with the gateway.
	KmsKeyArn *string

	// The configuration settings for the protocol used by the gateway.
	ProtocolConfiguration types.GatewayProtocolConfiguration

	// The Amazon Resource Name (ARN) of the IAM role associated with the gateway.
	RoleArn *string

	// The reasons for the current status of the gateway.
	StatusReasons []string

	// The workload identity details for the created Gateway.
	WorkloadIdentityDetails *types.WorkloadIdentityDetails

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateGatewayMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateGateway{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateGateway{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateGateway"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opCreateGatewayMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpCreateGatewayValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateGateway(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpCreateGateway struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpCreateGateway) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpCreateGateway) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*CreateGatewayInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *CreateGatewayInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opCreateGatewayMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpCreateGateway{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opCreateGateway(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateGateway",
	}
}
