// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrockagentcore

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrockagentcore/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Retrieves detailed information about a specific code interpreter session in
// Amazon Bedrock. This operation returns the session's configuration, current
// status, and metadata.
//
// To get a code interpreter session, you must specify both the code interpreter
// identifier and the session ID. The response includes information about the
// session's timeout settings and current status.
//
// The following operations are related to GetCodeInterpreterSession :
//
// [StartCodeInterpreterSession]
//
// [ListCodeInterpreterSessions]
//
// [StopCodeInterpreterSession]
//
// [StopCodeInterpreterSession]: https://docs.aws.amazon.com/API_StopCodeInterpreterSession.html
// [StartCodeInterpreterSession]: https://docs.aws.amazon.com/API_StartCodeInterpreterSession.html
// [ListCodeInterpreterSessions]: https://docs.aws.amazon.com/API_ListCodeInterpreterSessions.html
func (c *Client) GetCodeInterpreterSession(ctx context.Context, params *GetCodeInterpreterSessionInput, optFns ...func(*Options)) (*GetCodeInterpreterSessionOutput, error) {
	if params == nil {
		params = &GetCodeInterpreterSessionInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetCodeInterpreterSession", params, optFns, c.addOperationGetCodeInterpreterSessionMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetCodeInterpreterSessionOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetCodeInterpreterSessionInput struct {

	// The unique identifier of the code interpreter associated with the session.
	//
	// This member is required.
	CodeInterpreterIdentifier *string

	// The unique identifier of the code interpreter session to retrieve.
	//
	// This member is required.
	SessionId *string

	noSmithyDocumentSerde
}

type GetCodeInterpreterSessionOutput struct {

	// The identifier of the code interpreter.
	//
	// This member is required.
	CodeInterpreterIdentifier *string

	// The time at which the code interpreter session was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The identifier of the code interpreter session.
	//
	// This member is required.
	SessionId *string

	// The name of the code interpreter session.
	Name *string

	// The timeout period for the code interpreter session in seconds.
	SessionTimeoutSeconds *int32

	// The current status of the code interpreter session. Possible values include
	// ACTIVE, STOPPING, and STOPPED.
	Status types.CodeInterpreterSessionStatus

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetCodeInterpreterSessionMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetCodeInterpreterSession{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetCodeInterpreterSession{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetCodeInterpreterSession"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetCodeInterpreterSessionValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetCodeInterpreterSession(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetCodeInterpreterSession(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetCodeInterpreterSession",
	}
}
