// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrock

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrock/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Retrieves the current annotations for an Automated Reasoning policy build
// workflow. Annotations contain corrections to the rules, variables and types to
// be applied to the policy.
func (c *Client) GetAutomatedReasoningPolicyAnnotations(ctx context.Context, params *GetAutomatedReasoningPolicyAnnotationsInput, optFns ...func(*Options)) (*GetAutomatedReasoningPolicyAnnotationsOutput, error) {
	if params == nil {
		params = &GetAutomatedReasoningPolicyAnnotationsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetAutomatedReasoningPolicyAnnotations", params, optFns, c.addOperationGetAutomatedReasoningPolicyAnnotationsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetAutomatedReasoningPolicyAnnotationsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetAutomatedReasoningPolicyAnnotationsInput struct {

	// The unique identifier of the build workflow whose annotations you want to
	// retrieve.
	//
	// This member is required.
	BuildWorkflowId *string

	// The Amazon Resource Name (ARN) of the Automated Reasoning policy whose
	// annotations you want to retrieve.
	//
	// This member is required.
	PolicyArn *string

	noSmithyDocumentSerde
}

type GetAutomatedReasoningPolicyAnnotationsOutput struct {

	// A hash value representing the current state of the annotations. This is used
	// for optimistic concurrency control when updating annotations.
	//
	// This member is required.
	AnnotationSetHash *string

	// The current set of annotations containing rules, variables, and types extracted
	// from the source documents. These can be modified before finalizing the policy.
	//
	// This member is required.
	Annotations []types.AutomatedReasoningPolicyAnnotation

	// The unique identifier of the build workflow.
	//
	// This member is required.
	BuildWorkflowId *string

	// The name of the Automated Reasoning policy.
	//
	// This member is required.
	Name *string

	// The Amazon Resource Name (ARN) of the Automated Reasoning policy.
	//
	// This member is required.
	PolicyArn *string

	// The timestamp when the annotations were last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetAutomatedReasoningPolicyAnnotationsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetAutomatedReasoningPolicyAnnotations{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetAutomatedReasoningPolicyAnnotations{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetAutomatedReasoningPolicyAnnotations"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetAutomatedReasoningPolicyAnnotationsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetAutomatedReasoningPolicyAnnotations(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetAutomatedReasoningPolicyAnnotations(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetAutomatedReasoningPolicyAnnotations",
	}
}
