// Code generated by smithy-go-codegen DO NOT EDIT.

package aiops

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/aiops/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates an investigation group in your account. Creating an investigation group
// is a one-time setup task for each Region in your account. It is a necessary task
// to be able to perform investigations.
//
// Settings in the investigation group help you centrally manage the common
// properties of your investigations, such as the following:
//
//   - Who can access the investigations
//
//   - Whether investigation data is encrypted with a customer managed Key
//     Management Service key.
//
//   - How long investigations and their data are retained by default.
//
// Currently, you can have one investigation group in each Region in your account.
// Each investigation in a Region is a part of the investigation group in that
// Region
//
// To create an investigation group and set up CloudWatch investigations, you must
// be signed in to an IAM principal that has either the AIOpsConsoleAdminPolicy or
// the AdministratorAccess IAM policy attached, or to an account that has similar
// permissions.
//
// You can configure CloudWatch alarms to start investigations and add events to
// investigations. If you create your investigation group with
// CreateInvestigationGroup and you want to enable alarms to do this, you must use
// PutInvestigationGroupPolicy to create a resource policy that grants this
// permission to CloudWatch alarms.
//
// For more information about configuring CloudWatch alarms, see [Using Amazon CloudWatch alarms]
//
// [Using Amazon CloudWatch alarms]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/AlarmThatSendsEmail.html
func (c *Client) CreateInvestigationGroup(ctx context.Context, params *CreateInvestigationGroupInput, optFns ...func(*Options)) (*CreateInvestigationGroupOutput, error) {
	if params == nil {
		params = &CreateInvestigationGroupInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateInvestigationGroup", params, optFns, c.addOperationCreateInvestigationGroupMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateInvestigationGroupOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateInvestigationGroupInput struct {

	// Provides a name for the investigation group.
	//
	// This member is required.
	Name *string

	// Specify the ARN of the IAM role that CloudWatch investigations will use when it
	// gathers investigation data. The permissions in this role determine which of your
	// resources that CloudWatch investigations will have access to during
	// investigations.
	//
	// For more information, see [How to control what data CloudWatch investigations has access to during investigations].
	//
	// [How to control what data CloudWatch investigations has access to during investigations]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Investigations-Security.html#Investigations-Security-Data
	//
	// This member is required.
	RoleArn *string

	// Use this structure to integrate CloudWatch investigations with chat
	// applications. This structure is a string array. For the first string, specify
	// the ARN of an Amazon SNS topic. For the array of strings, specify the ARNs of
	// one or more chat applications configurations that you want to associate with
	// that topic. For more information about these configuration ARNs, see [Getting started with Amazon Q in chat applications]and [Resource type defined by Amazon Web Services Chatbot].
	//
	// [Resource type defined by Amazon Web Services Chatbot]: https://docs.aws.amazon.com/service-authorization/latest/reference/list_awschatbot.html#awschatbot-resources-for-iam-policies
	// [Getting started with Amazon Q in chat applications]: https://docs.aws.amazon.com/chatbot/latest/adminguide/getting-started.html
	ChatbotNotificationChannel map[string][]string

	// List of sourceRoleArn values that have been configured for cross-account access.
	CrossAccountConfigurations []types.CrossAccountConfiguration

	// Use this structure if you want to use a customer managed KMS key to encrypt
	// your investigation data. If you omit this parameter, CloudWatch investigations
	// will use an Amazon Web Services key to encrypt the data. For more information,
	// see [Encryption of investigation data].
	//
	// [Encryption of investigation data]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Investigations-Security.html#Investigations-KMS
	EncryptionConfiguration *types.EncryptionConfiguration

	// Specify true to enable CloudWatch investigations to have access to change
	// events that are recorded by CloudTrail. The default is true .
	IsCloudTrailEventHistoryEnabled *bool

	// Specify how long that investigation data is kept. For more information, see [Operational investigation data retention].
	//
	// If you omit this parameter, the default of 90 days is used.
	//
	// [Operational investigation data retention]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Investigations-Retention.html
	RetentionInDays *int64

	// Enter the existing custom tag keys for custom applications in your system.
	// Resource tags help CloudWatch investigations narrow the search space when it is
	// unable to discover definite relationships between resources. For example, to
	// discover that an Amazon ECS service depends on an Amazon RDS database,
	// CloudWatch investigations can discover this relationship using data sources such
	// as X-Ray and CloudWatch Application Signals. However, if you haven't deployed
	// these features, CloudWatch investigations will attempt to identify possible
	// relationships. Tag boundaries can be used to narrow the resources that will be
	// discovered by CloudWatch investigations in these cases.
	//
	// You don't need to enter tags created by myApplications or CloudFormation,
	// because CloudWatch investigations can automatically detect those tags.
	TagKeyBoundaries []string

	// A list of key-value pairs to associate with the investigation group. You can
	// associate as many as 50 tags with an investigation group. To be able to
	// associate tags when you create the investigation group, you must have the
	// cloudwatch:TagResource permission.
	//
	// Tags can help you organize and categorize your resources. You can also use them
	// to scope user permissions by granting a user permission to access or change only
	// resources with certain tag values.
	Tags map[string]string

	noSmithyDocumentSerde
}

type CreateInvestigationGroupOutput struct {

	// The ARN of the investigation group that you just created.
	Arn *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateInvestigationGroupMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateInvestigationGroup{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateInvestigationGroup{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateInvestigationGroup"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpCreateInvestigationGroupValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateInvestigationGroup(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateInvestigationGroup(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateInvestigationGroup",
	}
}
