// Code generated by smithy-go-codegen DO NOT EDIT.

package workmail

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/workmail/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns a summary of your Personal Access Tokens.
func (c *Client) ListPersonalAccessTokens(ctx context.Context, params *ListPersonalAccessTokensInput, optFns ...func(*Options)) (*ListPersonalAccessTokensOutput, error) {
	if params == nil {
		params = &ListPersonalAccessTokensInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListPersonalAccessTokens", params, optFns, c.addOperationListPersonalAccessTokensMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListPersonalAccessTokensOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListPersonalAccessTokensInput struct {

	//  The Organization ID.
	//
	// This member is required.
	OrganizationId *string

	//  The maximum amount of items that should be returned in a response.
	MaxResults *int32

	//  The token from the previous response to query the next page.
	NextToken *string

	//  The WorkMail User ID.
	UserId *string

	noSmithyDocumentSerde
}

type ListPersonalAccessTokensOutput struct {

	//  The token from the previous response to query the next page.
	NextToken *string

	//  Lists all the personal tokens in an organization or user, if user ID is
	// provided.
	PersonalAccessTokenSummaries []types.PersonalAccessTokenSummary

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListPersonalAccessTokensMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListPersonalAccessTokens{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListPersonalAccessTokens{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListPersonalAccessTokens"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListPersonalAccessTokensValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListPersonalAccessTokens(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListPersonalAccessTokensPaginatorOptions is the paginator options for
// ListPersonalAccessTokens
type ListPersonalAccessTokensPaginatorOptions struct {
	//  The maximum amount of items that should be returned in a response.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListPersonalAccessTokensPaginator is a paginator for ListPersonalAccessTokens
type ListPersonalAccessTokensPaginator struct {
	options   ListPersonalAccessTokensPaginatorOptions
	client    ListPersonalAccessTokensAPIClient
	params    *ListPersonalAccessTokensInput
	nextToken *string
	firstPage bool
}

// NewListPersonalAccessTokensPaginator returns a new
// ListPersonalAccessTokensPaginator
func NewListPersonalAccessTokensPaginator(client ListPersonalAccessTokensAPIClient, params *ListPersonalAccessTokensInput, optFns ...func(*ListPersonalAccessTokensPaginatorOptions)) *ListPersonalAccessTokensPaginator {
	if params == nil {
		params = &ListPersonalAccessTokensInput{}
	}

	options := ListPersonalAccessTokensPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListPersonalAccessTokensPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListPersonalAccessTokensPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListPersonalAccessTokens page.
func (p *ListPersonalAccessTokensPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListPersonalAccessTokensOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListPersonalAccessTokens(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListPersonalAccessTokensAPIClient is a client that implements the
// ListPersonalAccessTokens operation.
type ListPersonalAccessTokensAPIClient interface {
	ListPersonalAccessTokens(context.Context, *ListPersonalAccessTokensInput, ...func(*Options)) (*ListPersonalAccessTokensOutput, error)
}

var _ ListPersonalAccessTokensAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListPersonalAccessTokens(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListPersonalAccessTokens",
	}
}
