// Code generated by smithy-go-codegen DO NOT EDIT.

package transcribe

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/transcribe/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	"github.com/aws/smithy-go/tracing"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"path"
)

type awsAwsjson11_serializeOpCreateCallAnalyticsCategory struct {
}

func (*awsAwsjson11_serializeOpCreateCallAnalyticsCategory) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreateCallAnalyticsCategory) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateCallAnalyticsCategoryInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("Transcribe.CreateCallAnalyticsCategory")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreateCallAnalyticsCategoryInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreateLanguageModel struct {
}

func (*awsAwsjson11_serializeOpCreateLanguageModel) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreateLanguageModel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateLanguageModelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("Transcribe.CreateLanguageModel")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreateLanguageModelInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreateMedicalVocabulary struct {
}

func (*awsAwsjson11_serializeOpCreateMedicalVocabulary) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreateMedicalVocabulary) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateMedicalVocabularyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("Transcribe.CreateMedicalVocabulary")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreateMedicalVocabularyInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreateVocabulary struct {
}

func (*awsAwsjson11_serializeOpCreateVocabulary) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreateVocabulary) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateVocabularyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("Transcribe.CreateVocabulary")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreateVocabularyInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreateVocabularyFilter struct {
}

func (*awsAwsjson11_serializeOpCreateVocabularyFilter) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreateVocabularyFilter) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateVocabularyFilterInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("Transcribe.CreateVocabularyFilter")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreateVocabularyFilterInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteCallAnalyticsCategory struct {
}

func (*awsAwsjson11_serializeOpDeleteCallAnalyticsCategory) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteCallAnalyticsCategory) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteCallAnalyticsCategoryInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("Transcribe.DeleteCallAnalyticsCategory")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteCallAnalyticsCategoryInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteCallAnalyticsJob struct {
}

func (*awsAwsjson11_serializeOpDeleteCallAnalyticsJob) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteCallAnalyticsJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteCallAnalyticsJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("Transcribe.DeleteCallAnalyticsJob")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteCallAnalyticsJobInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteLanguageModel struct {
}

func (*awsAwsjson11_serializeOpDeleteLanguageModel) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteLanguageModel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteLanguageModelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("Transcribe.DeleteLanguageModel")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteLanguageModelInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteMedicalScribeJob struct {
}

func (*awsAwsjson11_serializeOpDeleteMedicalScribeJob) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteMedicalScribeJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteMedicalScribeJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("Transcribe.DeleteMedicalScribeJob")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteMedicalScribeJobInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteMedicalTranscriptionJob struct {
}

func (*awsAwsjson11_serializeOpDeleteMedicalTranscriptionJob) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteMedicalTranscriptionJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteMedicalTranscriptionJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("Transcribe.DeleteMedicalTranscriptionJob")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteMedicalTranscriptionJobInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteMedicalVocabulary struct {
}

func (*awsAwsjson11_serializeOpDeleteMedicalVocabulary) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteMedicalVocabulary) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteMedicalVocabularyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("Transcribe.DeleteMedicalVocabulary")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteMedicalVocabularyInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteTranscriptionJob struct {
}

func (*awsAwsjson11_serializeOpDeleteTranscriptionJob) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteTranscriptionJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteTranscriptionJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("Transcribe.DeleteTranscriptionJob")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteTranscriptionJobInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteVocabulary struct {
}

func (*awsAwsjson11_serializeOpDeleteVocabulary) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteVocabulary) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteVocabularyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("Transcribe.DeleteVocabulary")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteVocabularyInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteVocabularyFilter struct {
}

func (*awsAwsjson11_serializeOpDeleteVocabularyFilter) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteVocabularyFilter) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteVocabularyFilterInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("Transcribe.DeleteVocabularyFilter")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteVocabularyFilterInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeLanguageModel struct {
}

func (*awsAwsjson11_serializeOpDescribeLanguageModel) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeLanguageModel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeLanguageModelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("Transcribe.DescribeLanguageModel")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeLanguageModelInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetCallAnalyticsCategory struct {
}

func (*awsAwsjson11_serializeOpGetCallAnalyticsCategory) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetCallAnalyticsCategory) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetCallAnalyticsCategoryInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("Transcribe.GetCallAnalyticsCategory")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetCallAnalyticsCategoryInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetCallAnalyticsJob struct {
}

func (*awsAwsjson11_serializeOpGetCallAnalyticsJob) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetCallAnalyticsJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetCallAnalyticsJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("Transcribe.GetCallAnalyticsJob")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetCallAnalyticsJobInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetMedicalScribeJob struct {
}

func (*awsAwsjson11_serializeOpGetMedicalScribeJob) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetMedicalScribeJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetMedicalScribeJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("Transcribe.GetMedicalScribeJob")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetMedicalScribeJobInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetMedicalTranscriptionJob struct {
}

func (*awsAwsjson11_serializeOpGetMedicalTranscriptionJob) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetMedicalTranscriptionJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetMedicalTranscriptionJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("Transcribe.GetMedicalTranscriptionJob")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetMedicalTranscriptionJobInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetMedicalVocabulary struct {
}

func (*awsAwsjson11_serializeOpGetMedicalVocabulary) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetMedicalVocabulary) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetMedicalVocabularyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("Transcribe.GetMedicalVocabulary")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetMedicalVocabularyInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetTranscriptionJob struct {
}

func (*awsAwsjson11_serializeOpGetTranscriptionJob) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetTranscriptionJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetTranscriptionJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("Transcribe.GetTranscriptionJob")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetTranscriptionJobInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetVocabulary struct {
}

func (*awsAwsjson11_serializeOpGetVocabulary) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetVocabulary) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetVocabularyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("Transcribe.GetVocabulary")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetVocabularyInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetVocabularyFilter struct {
}

func (*awsAwsjson11_serializeOpGetVocabularyFilter) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetVocabularyFilter) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetVocabularyFilterInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("Transcribe.GetVocabularyFilter")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetVocabularyFilterInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListCallAnalyticsCategories struct {
}

func (*awsAwsjson11_serializeOpListCallAnalyticsCategories) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListCallAnalyticsCategories) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListCallAnalyticsCategoriesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("Transcribe.ListCallAnalyticsCategories")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListCallAnalyticsCategoriesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListCallAnalyticsJobs struct {
}

func (*awsAwsjson11_serializeOpListCallAnalyticsJobs) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListCallAnalyticsJobs) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListCallAnalyticsJobsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("Transcribe.ListCallAnalyticsJobs")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListCallAnalyticsJobsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListLanguageModels struct {
}

func (*awsAwsjson11_serializeOpListLanguageModels) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListLanguageModels) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListLanguageModelsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("Transcribe.ListLanguageModels")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListLanguageModelsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListMedicalScribeJobs struct {
}

func (*awsAwsjson11_serializeOpListMedicalScribeJobs) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListMedicalScribeJobs) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListMedicalScribeJobsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("Transcribe.ListMedicalScribeJobs")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListMedicalScribeJobsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListMedicalTranscriptionJobs struct {
}

func (*awsAwsjson11_serializeOpListMedicalTranscriptionJobs) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListMedicalTranscriptionJobs) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListMedicalTranscriptionJobsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("Transcribe.ListMedicalTranscriptionJobs")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListMedicalTranscriptionJobsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListMedicalVocabularies struct {
}

func (*awsAwsjson11_serializeOpListMedicalVocabularies) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListMedicalVocabularies) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListMedicalVocabulariesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("Transcribe.ListMedicalVocabularies")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListMedicalVocabulariesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListTagsForResource struct {
}

func (*awsAwsjson11_serializeOpListTagsForResource) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListTagsForResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTagsForResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("Transcribe.ListTagsForResource")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListTagsForResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListTranscriptionJobs struct {
}

func (*awsAwsjson11_serializeOpListTranscriptionJobs) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListTranscriptionJobs) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTranscriptionJobsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("Transcribe.ListTranscriptionJobs")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListTranscriptionJobsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListVocabularies struct {
}

func (*awsAwsjson11_serializeOpListVocabularies) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListVocabularies) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListVocabulariesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("Transcribe.ListVocabularies")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListVocabulariesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListVocabularyFilters struct {
}

func (*awsAwsjson11_serializeOpListVocabularyFilters) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListVocabularyFilters) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListVocabularyFiltersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("Transcribe.ListVocabularyFilters")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListVocabularyFiltersInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpStartCallAnalyticsJob struct {
}

func (*awsAwsjson11_serializeOpStartCallAnalyticsJob) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpStartCallAnalyticsJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartCallAnalyticsJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("Transcribe.StartCallAnalyticsJob")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentStartCallAnalyticsJobInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpStartMedicalScribeJob struct {
}

func (*awsAwsjson11_serializeOpStartMedicalScribeJob) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpStartMedicalScribeJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartMedicalScribeJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("Transcribe.StartMedicalScribeJob")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentStartMedicalScribeJobInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpStartMedicalTranscriptionJob struct {
}

func (*awsAwsjson11_serializeOpStartMedicalTranscriptionJob) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpStartMedicalTranscriptionJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartMedicalTranscriptionJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("Transcribe.StartMedicalTranscriptionJob")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentStartMedicalTranscriptionJobInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpStartTranscriptionJob struct {
}

func (*awsAwsjson11_serializeOpStartTranscriptionJob) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpStartTranscriptionJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartTranscriptionJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("Transcribe.StartTranscriptionJob")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentStartTranscriptionJobInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpTagResource struct {
}

func (*awsAwsjson11_serializeOpTagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpTagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*TagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("Transcribe.TagResource")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentTagResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUntagResource struct {
}

func (*awsAwsjson11_serializeOpUntagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUntagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UntagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("Transcribe.UntagResource")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUntagResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUpdateCallAnalyticsCategory struct {
}

func (*awsAwsjson11_serializeOpUpdateCallAnalyticsCategory) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUpdateCallAnalyticsCategory) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateCallAnalyticsCategoryInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("Transcribe.UpdateCallAnalyticsCategory")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUpdateCallAnalyticsCategoryInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUpdateMedicalVocabulary struct {
}

func (*awsAwsjson11_serializeOpUpdateMedicalVocabulary) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUpdateMedicalVocabulary) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateMedicalVocabularyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("Transcribe.UpdateMedicalVocabulary")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUpdateMedicalVocabularyInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUpdateVocabulary struct {
}

func (*awsAwsjson11_serializeOpUpdateVocabulary) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUpdateVocabulary) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateVocabularyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("Transcribe.UpdateVocabulary")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUpdateVocabularyInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUpdateVocabularyFilter struct {
}

func (*awsAwsjson11_serializeOpUpdateVocabularyFilter) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUpdateVocabularyFilter) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateVocabularyFilterInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("Transcribe.UpdateVocabularyFilter")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUpdateVocabularyFilterInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsAwsjson11_serializeDocumentAbsoluteTimeRange(v *types.AbsoluteTimeRange, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EndTime != nil {
		ok := object.Key("EndTime")
		ok.Long(*v.EndTime)
	}

	if v.First != nil {
		ok := object.Key("First")
		ok.Long(*v.First)
	}

	if v.Last != nil {
		ok := object.Key("Last")
		ok.Long(*v.Last)
	}

	if v.StartTime != nil {
		ok := object.Key("StartTime")
		ok.Long(*v.StartTime)
	}

	return nil
}

func awsAwsjson11_serializeDocumentCallAnalyticsJobSettings(v *types.CallAnalyticsJobSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ContentRedaction != nil {
		ok := object.Key("ContentRedaction")
		if err := awsAwsjson11_serializeDocumentContentRedaction(v.ContentRedaction, ok); err != nil {
			return err
		}
	}

	if v.LanguageIdSettings != nil {
		ok := object.Key("LanguageIdSettings")
		if err := awsAwsjson11_serializeDocumentLanguageIdSettingsMap(v.LanguageIdSettings, ok); err != nil {
			return err
		}
	}

	if v.LanguageModelName != nil {
		ok := object.Key("LanguageModelName")
		ok.String(*v.LanguageModelName)
	}

	if v.LanguageOptions != nil {
		ok := object.Key("LanguageOptions")
		if err := awsAwsjson11_serializeDocumentLanguageOptions(v.LanguageOptions, ok); err != nil {
			return err
		}
	}

	if v.Summarization != nil {
		ok := object.Key("Summarization")
		if err := awsAwsjson11_serializeDocumentSummarization(v.Summarization, ok); err != nil {
			return err
		}
	}

	if len(v.VocabularyFilterMethod) > 0 {
		ok := object.Key("VocabularyFilterMethod")
		ok.String(string(v.VocabularyFilterMethod))
	}

	if v.VocabularyFilterName != nil {
		ok := object.Key("VocabularyFilterName")
		ok.String(*v.VocabularyFilterName)
	}

	if v.VocabularyName != nil {
		ok := object.Key("VocabularyName")
		ok.String(*v.VocabularyName)
	}

	return nil
}

func awsAwsjson11_serializeDocumentChannelDefinition(v *types.ChannelDefinition, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ChannelId != 0 {
		ok := object.Key("ChannelId")
		ok.Integer(v.ChannelId)
	}

	if len(v.ParticipantRole) > 0 {
		ok := object.Key("ParticipantRole")
		ok.String(string(v.ParticipantRole))
	}

	return nil
}

func awsAwsjson11_serializeDocumentChannelDefinitions(v []types.ChannelDefinition, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentChannelDefinition(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentClinicalNoteGenerationSettings(v *types.ClinicalNoteGenerationSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.NoteTemplate) > 0 {
		ok := object.Key("NoteTemplate")
		ok.String(string(v.NoteTemplate))
	}

	return nil
}

func awsAwsjson11_serializeDocumentContentRedaction(v *types.ContentRedaction, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PiiEntityTypes != nil {
		ok := object.Key("PiiEntityTypes")
		if err := awsAwsjson11_serializeDocumentPiiEntityTypes(v.PiiEntityTypes, ok); err != nil {
			return err
		}
	}

	if len(v.RedactionOutput) > 0 {
		ok := object.Key("RedactionOutput")
		ok.String(string(v.RedactionOutput))
	}

	if len(v.RedactionType) > 0 {
		ok := object.Key("RedactionType")
		ok.String(string(v.RedactionType))
	}

	return nil
}

func awsAwsjson11_serializeDocumentInputDataConfig(v *types.InputDataConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DataAccessRoleArn != nil {
		ok := object.Key("DataAccessRoleArn")
		ok.String(*v.DataAccessRoleArn)
	}

	if v.S3Uri != nil {
		ok := object.Key("S3Uri")
		ok.String(*v.S3Uri)
	}

	if v.TuningDataS3Uri != nil {
		ok := object.Key("TuningDataS3Uri")
		ok.String(*v.TuningDataS3Uri)
	}

	return nil
}

func awsAwsjson11_serializeDocumentInterruptionFilter(v *types.InterruptionFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AbsoluteTimeRange != nil {
		ok := object.Key("AbsoluteTimeRange")
		if err := awsAwsjson11_serializeDocumentAbsoluteTimeRange(v.AbsoluteTimeRange, ok); err != nil {
			return err
		}
	}

	if v.Negate != nil {
		ok := object.Key("Negate")
		ok.Boolean(*v.Negate)
	}

	if len(v.ParticipantRole) > 0 {
		ok := object.Key("ParticipantRole")
		ok.String(string(v.ParticipantRole))
	}

	if v.RelativeTimeRange != nil {
		ok := object.Key("RelativeTimeRange")
		if err := awsAwsjson11_serializeDocumentRelativeTimeRange(v.RelativeTimeRange, ok); err != nil {
			return err
		}
	}

	if v.Threshold != nil {
		ok := object.Key("Threshold")
		ok.Long(*v.Threshold)
	}

	return nil
}

func awsAwsjson11_serializeDocumentJobExecutionSettings(v *types.JobExecutionSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AllowDeferredExecution != nil {
		ok := object.Key("AllowDeferredExecution")
		ok.Boolean(*v.AllowDeferredExecution)
	}

	if v.DataAccessRoleArn != nil {
		ok := object.Key("DataAccessRoleArn")
		ok.String(*v.DataAccessRoleArn)
	}

	return nil
}

func awsAwsjson11_serializeDocumentKMSEncryptionContextMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsAwsjson11_serializeDocumentLanguageIdSettings(v *types.LanguageIdSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LanguageModelName != nil {
		ok := object.Key("LanguageModelName")
		ok.String(*v.LanguageModelName)
	}

	if v.VocabularyFilterName != nil {
		ok := object.Key("VocabularyFilterName")
		ok.String(*v.VocabularyFilterName)
	}

	if v.VocabularyName != nil {
		ok := object.Key("VocabularyName")
		ok.String(*v.VocabularyName)
	}

	return nil
}

func awsAwsjson11_serializeDocumentLanguageIdSettingsMap(v map[string]types.LanguageIdSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		mapVar := v[key]
		if err := awsAwsjson11_serializeDocumentLanguageIdSettings(&mapVar, om); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentLanguageOptions(v []types.LanguageCode, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsAwsjson11_serializeDocumentMedia(v *types.Media, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MediaFileUri != nil {
		ok := object.Key("MediaFileUri")
		ok.String(*v.MediaFileUri)
	}

	if v.RedactedMediaFileUri != nil {
		ok := object.Key("RedactedMediaFileUri")
		ok.String(*v.RedactedMediaFileUri)
	}

	return nil
}

func awsAwsjson11_serializeDocumentMedicalScribeChannelDefinition(v *types.MedicalScribeChannelDefinition, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	{
		ok := object.Key("ChannelId")
		ok.Integer(v.ChannelId)
	}

	if len(v.ParticipantRole) > 0 {
		ok := object.Key("ParticipantRole")
		ok.String(string(v.ParticipantRole))
	}

	return nil
}

func awsAwsjson11_serializeDocumentMedicalScribeChannelDefinitions(v []types.MedicalScribeChannelDefinition, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentMedicalScribeChannelDefinition(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentMedicalScribeSettings(v *types.MedicalScribeSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ChannelIdentification != nil {
		ok := object.Key("ChannelIdentification")
		ok.Boolean(*v.ChannelIdentification)
	}

	if v.ClinicalNoteGenerationSettings != nil {
		ok := object.Key("ClinicalNoteGenerationSettings")
		if err := awsAwsjson11_serializeDocumentClinicalNoteGenerationSettings(v.ClinicalNoteGenerationSettings, ok); err != nil {
			return err
		}
	}

	if v.MaxSpeakerLabels != nil {
		ok := object.Key("MaxSpeakerLabels")
		ok.Integer(*v.MaxSpeakerLabels)
	}

	if v.ShowSpeakerLabels != nil {
		ok := object.Key("ShowSpeakerLabels")
		ok.Boolean(*v.ShowSpeakerLabels)
	}

	if len(v.VocabularyFilterMethod) > 0 {
		ok := object.Key("VocabularyFilterMethod")
		ok.String(string(v.VocabularyFilterMethod))
	}

	if v.VocabularyFilterName != nil {
		ok := object.Key("VocabularyFilterName")
		ok.String(*v.VocabularyFilterName)
	}

	if v.VocabularyName != nil {
		ok := object.Key("VocabularyName")
		ok.String(*v.VocabularyName)
	}

	return nil
}

func awsAwsjson11_serializeDocumentMedicalTranscriptionSetting(v *types.MedicalTranscriptionSetting, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ChannelIdentification != nil {
		ok := object.Key("ChannelIdentification")
		ok.Boolean(*v.ChannelIdentification)
	}

	if v.MaxAlternatives != nil {
		ok := object.Key("MaxAlternatives")
		ok.Integer(*v.MaxAlternatives)
	}

	if v.MaxSpeakerLabels != nil {
		ok := object.Key("MaxSpeakerLabels")
		ok.Integer(*v.MaxSpeakerLabels)
	}

	if v.ShowAlternatives != nil {
		ok := object.Key("ShowAlternatives")
		ok.Boolean(*v.ShowAlternatives)
	}

	if v.ShowSpeakerLabels != nil {
		ok := object.Key("ShowSpeakerLabels")
		ok.Boolean(*v.ShowSpeakerLabels)
	}

	if v.VocabularyName != nil {
		ok := object.Key("VocabularyName")
		ok.String(*v.VocabularyName)
	}

	return nil
}

func awsAwsjson11_serializeDocumentModelSettings(v *types.ModelSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LanguageModelName != nil {
		ok := object.Key("LanguageModelName")
		ok.String(*v.LanguageModelName)
	}

	return nil
}

func awsAwsjson11_serializeDocumentNonTalkTimeFilter(v *types.NonTalkTimeFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AbsoluteTimeRange != nil {
		ok := object.Key("AbsoluteTimeRange")
		if err := awsAwsjson11_serializeDocumentAbsoluteTimeRange(v.AbsoluteTimeRange, ok); err != nil {
			return err
		}
	}

	if v.Negate != nil {
		ok := object.Key("Negate")
		ok.Boolean(*v.Negate)
	}

	if v.RelativeTimeRange != nil {
		ok := object.Key("RelativeTimeRange")
		if err := awsAwsjson11_serializeDocumentRelativeTimeRange(v.RelativeTimeRange, ok); err != nil {
			return err
		}
	}

	if v.Threshold != nil {
		ok := object.Key("Threshold")
		ok.Long(*v.Threshold)
	}

	return nil
}

func awsAwsjson11_serializeDocumentPhrases(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentPiiEntityTypes(v []types.PiiEntityType, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsAwsjson11_serializeDocumentRelativeTimeRange(v *types.RelativeTimeRange, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EndPercentage != nil {
		ok := object.Key("EndPercentage")
		ok.Integer(*v.EndPercentage)
	}

	if v.First != nil {
		ok := object.Key("First")
		ok.Integer(*v.First)
	}

	if v.Last != nil {
		ok := object.Key("Last")
		ok.Integer(*v.Last)
	}

	if v.StartPercentage != nil {
		ok := object.Key("StartPercentage")
		ok.Integer(*v.StartPercentage)
	}

	return nil
}

func awsAwsjson11_serializeDocumentRule(v types.Rule, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.RuleMemberInterruptionFilter:
		av := object.Key("InterruptionFilter")
		if err := awsAwsjson11_serializeDocumentInterruptionFilter(&uv.Value, av); err != nil {
			return err
		}

	case *types.RuleMemberNonTalkTimeFilter:
		av := object.Key("NonTalkTimeFilter")
		if err := awsAwsjson11_serializeDocumentNonTalkTimeFilter(&uv.Value, av); err != nil {
			return err
		}

	case *types.RuleMemberSentimentFilter:
		av := object.Key("SentimentFilter")
		if err := awsAwsjson11_serializeDocumentSentimentFilter(&uv.Value, av); err != nil {
			return err
		}

	case *types.RuleMemberTranscriptFilter:
		av := object.Key("TranscriptFilter")
		if err := awsAwsjson11_serializeDocumentTranscriptFilter(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsAwsjson11_serializeDocumentRuleList(v []types.Rule, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if vv := v[i]; vv == nil {
			continue
		}
		if err := awsAwsjson11_serializeDocumentRule(v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentSentimentFilter(v *types.SentimentFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AbsoluteTimeRange != nil {
		ok := object.Key("AbsoluteTimeRange")
		if err := awsAwsjson11_serializeDocumentAbsoluteTimeRange(v.AbsoluteTimeRange, ok); err != nil {
			return err
		}
	}

	if v.Negate != nil {
		ok := object.Key("Negate")
		ok.Boolean(*v.Negate)
	}

	if len(v.ParticipantRole) > 0 {
		ok := object.Key("ParticipantRole")
		ok.String(string(v.ParticipantRole))
	}

	if v.RelativeTimeRange != nil {
		ok := object.Key("RelativeTimeRange")
		if err := awsAwsjson11_serializeDocumentRelativeTimeRange(v.RelativeTimeRange, ok); err != nil {
			return err
		}
	}

	if v.Sentiments != nil {
		ok := object.Key("Sentiments")
		if err := awsAwsjson11_serializeDocumentSentimentValueList(v.Sentiments, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentSentimentValueList(v []types.SentimentValue, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsAwsjson11_serializeDocumentSettings(v *types.Settings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ChannelIdentification != nil {
		ok := object.Key("ChannelIdentification")
		ok.Boolean(*v.ChannelIdentification)
	}

	if v.MaxAlternatives != nil {
		ok := object.Key("MaxAlternatives")
		ok.Integer(*v.MaxAlternatives)
	}

	if v.MaxSpeakerLabels != nil {
		ok := object.Key("MaxSpeakerLabels")
		ok.Integer(*v.MaxSpeakerLabels)
	}

	if v.ShowAlternatives != nil {
		ok := object.Key("ShowAlternatives")
		ok.Boolean(*v.ShowAlternatives)
	}

	if v.ShowSpeakerLabels != nil {
		ok := object.Key("ShowSpeakerLabels")
		ok.Boolean(*v.ShowSpeakerLabels)
	}

	if len(v.VocabularyFilterMethod) > 0 {
		ok := object.Key("VocabularyFilterMethod")
		ok.String(string(v.VocabularyFilterMethod))
	}

	if v.VocabularyFilterName != nil {
		ok := object.Key("VocabularyFilterName")
		ok.String(*v.VocabularyFilterName)
	}

	if v.VocabularyName != nil {
		ok := object.Key("VocabularyName")
		ok.String(*v.VocabularyName)
	}

	return nil
}

func awsAwsjson11_serializeDocumentStringTargetList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentSubtitleFormats(v []types.SubtitleFormat, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsAwsjson11_serializeDocumentSubtitles(v *types.Subtitles, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Formats != nil {
		ok := object.Key("Formats")
		if err := awsAwsjson11_serializeDocumentSubtitleFormats(v.Formats, ok); err != nil {
			return err
		}
	}

	if v.OutputStartIndex != nil {
		ok := object.Key("OutputStartIndex")
		ok.Integer(*v.OutputStartIndex)
	}

	return nil
}

func awsAwsjson11_serializeDocumentSummarization(v *types.Summarization, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.GenerateAbstractiveSummary != nil {
		ok := object.Key("GenerateAbstractiveSummary")
		ok.Boolean(*v.GenerateAbstractiveSummary)
	}

	return nil
}

func awsAwsjson11_serializeDocumentTag(v *types.Tag, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Key != nil {
		ok := object.Key("Key")
		ok.String(*v.Key)
	}

	if v.Value != nil {
		ok := object.Key("Value")
		ok.String(*v.Value)
	}

	return nil
}

func awsAwsjson11_serializeDocumentTagKeyList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentTagList(v []types.Tag, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentTag(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentToxicityCategories(v []types.ToxicityCategory, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsAwsjson11_serializeDocumentToxicityDetection(v []types.ToxicityDetectionSettings, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentToxicityDetectionSettings(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentToxicityDetectionSettings(v *types.ToxicityDetectionSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ToxicityCategories != nil {
		ok := object.Key("ToxicityCategories")
		if err := awsAwsjson11_serializeDocumentToxicityCategories(v.ToxicityCategories, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentTranscriptFilter(v *types.TranscriptFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AbsoluteTimeRange != nil {
		ok := object.Key("AbsoluteTimeRange")
		if err := awsAwsjson11_serializeDocumentAbsoluteTimeRange(v.AbsoluteTimeRange, ok); err != nil {
			return err
		}
	}

	if v.Negate != nil {
		ok := object.Key("Negate")
		ok.Boolean(*v.Negate)
	}

	if len(v.ParticipantRole) > 0 {
		ok := object.Key("ParticipantRole")
		ok.String(string(v.ParticipantRole))
	}

	if v.RelativeTimeRange != nil {
		ok := object.Key("RelativeTimeRange")
		if err := awsAwsjson11_serializeDocumentRelativeTimeRange(v.RelativeTimeRange, ok); err != nil {
			return err
		}
	}

	if v.Targets != nil {
		ok := object.Key("Targets")
		if err := awsAwsjson11_serializeDocumentStringTargetList(v.Targets, ok); err != nil {
			return err
		}
	}

	if len(v.TranscriptFilterType) > 0 {
		ok := object.Key("TranscriptFilterType")
		ok.String(string(v.TranscriptFilterType))
	}

	return nil
}

func awsAwsjson11_serializeDocumentWords(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeOpDocumentCreateCallAnalyticsCategoryInput(v *CreateCallAnalyticsCategoryInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CategoryName != nil {
		ok := object.Key("CategoryName")
		ok.String(*v.CategoryName)
	}

	if len(v.InputType) > 0 {
		ok := object.Key("InputType")
		ok.String(string(v.InputType))
	}

	if v.Rules != nil {
		ok := object.Key("Rules")
		if err := awsAwsjson11_serializeDocumentRuleList(v.Rules, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsAwsjson11_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreateLanguageModelInput(v *CreateLanguageModelInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.BaseModelName) > 0 {
		ok := object.Key("BaseModelName")
		ok.String(string(v.BaseModelName))
	}

	if v.InputDataConfig != nil {
		ok := object.Key("InputDataConfig")
		if err := awsAwsjson11_serializeDocumentInputDataConfig(v.InputDataConfig, ok); err != nil {
			return err
		}
	}

	if len(v.LanguageCode) > 0 {
		ok := object.Key("LanguageCode")
		ok.String(string(v.LanguageCode))
	}

	if v.ModelName != nil {
		ok := object.Key("ModelName")
		ok.String(*v.ModelName)
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsAwsjson11_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreateMedicalVocabularyInput(v *CreateMedicalVocabularyInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.LanguageCode) > 0 {
		ok := object.Key("LanguageCode")
		ok.String(string(v.LanguageCode))
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsAwsjson11_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.VocabularyFileUri != nil {
		ok := object.Key("VocabularyFileUri")
		ok.String(*v.VocabularyFileUri)
	}

	if v.VocabularyName != nil {
		ok := object.Key("VocabularyName")
		ok.String(*v.VocabularyName)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreateVocabularyFilterInput(v *CreateVocabularyFilterInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DataAccessRoleArn != nil {
		ok := object.Key("DataAccessRoleArn")
		ok.String(*v.DataAccessRoleArn)
	}

	if len(v.LanguageCode) > 0 {
		ok := object.Key("LanguageCode")
		ok.String(string(v.LanguageCode))
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsAwsjson11_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.VocabularyFilterFileUri != nil {
		ok := object.Key("VocabularyFilterFileUri")
		ok.String(*v.VocabularyFilterFileUri)
	}

	if v.VocabularyFilterName != nil {
		ok := object.Key("VocabularyFilterName")
		ok.String(*v.VocabularyFilterName)
	}

	if v.Words != nil {
		ok := object.Key("Words")
		if err := awsAwsjson11_serializeDocumentWords(v.Words, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreateVocabularyInput(v *CreateVocabularyInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DataAccessRoleArn != nil {
		ok := object.Key("DataAccessRoleArn")
		ok.String(*v.DataAccessRoleArn)
	}

	if len(v.LanguageCode) > 0 {
		ok := object.Key("LanguageCode")
		ok.String(string(v.LanguageCode))
	}

	if v.Phrases != nil {
		ok := object.Key("Phrases")
		if err := awsAwsjson11_serializeDocumentPhrases(v.Phrases, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsAwsjson11_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.VocabularyFileUri != nil {
		ok := object.Key("VocabularyFileUri")
		ok.String(*v.VocabularyFileUri)
	}

	if v.VocabularyName != nil {
		ok := object.Key("VocabularyName")
		ok.String(*v.VocabularyName)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteCallAnalyticsCategoryInput(v *DeleteCallAnalyticsCategoryInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CategoryName != nil {
		ok := object.Key("CategoryName")
		ok.String(*v.CategoryName)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteCallAnalyticsJobInput(v *DeleteCallAnalyticsJobInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CallAnalyticsJobName != nil {
		ok := object.Key("CallAnalyticsJobName")
		ok.String(*v.CallAnalyticsJobName)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteLanguageModelInput(v *DeleteLanguageModelInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ModelName != nil {
		ok := object.Key("ModelName")
		ok.String(*v.ModelName)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteMedicalScribeJobInput(v *DeleteMedicalScribeJobInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MedicalScribeJobName != nil {
		ok := object.Key("MedicalScribeJobName")
		ok.String(*v.MedicalScribeJobName)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteMedicalTranscriptionJobInput(v *DeleteMedicalTranscriptionJobInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MedicalTranscriptionJobName != nil {
		ok := object.Key("MedicalTranscriptionJobName")
		ok.String(*v.MedicalTranscriptionJobName)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteMedicalVocabularyInput(v *DeleteMedicalVocabularyInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.VocabularyName != nil {
		ok := object.Key("VocabularyName")
		ok.String(*v.VocabularyName)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteTranscriptionJobInput(v *DeleteTranscriptionJobInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.TranscriptionJobName != nil {
		ok := object.Key("TranscriptionJobName")
		ok.String(*v.TranscriptionJobName)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteVocabularyFilterInput(v *DeleteVocabularyFilterInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.VocabularyFilterName != nil {
		ok := object.Key("VocabularyFilterName")
		ok.String(*v.VocabularyFilterName)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteVocabularyInput(v *DeleteVocabularyInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.VocabularyName != nil {
		ok := object.Key("VocabularyName")
		ok.String(*v.VocabularyName)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeLanguageModelInput(v *DescribeLanguageModelInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ModelName != nil {
		ok := object.Key("ModelName")
		ok.String(*v.ModelName)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetCallAnalyticsCategoryInput(v *GetCallAnalyticsCategoryInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CategoryName != nil {
		ok := object.Key("CategoryName")
		ok.String(*v.CategoryName)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetCallAnalyticsJobInput(v *GetCallAnalyticsJobInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CallAnalyticsJobName != nil {
		ok := object.Key("CallAnalyticsJobName")
		ok.String(*v.CallAnalyticsJobName)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetMedicalScribeJobInput(v *GetMedicalScribeJobInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MedicalScribeJobName != nil {
		ok := object.Key("MedicalScribeJobName")
		ok.String(*v.MedicalScribeJobName)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetMedicalTranscriptionJobInput(v *GetMedicalTranscriptionJobInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MedicalTranscriptionJobName != nil {
		ok := object.Key("MedicalTranscriptionJobName")
		ok.String(*v.MedicalTranscriptionJobName)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetMedicalVocabularyInput(v *GetMedicalVocabularyInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.VocabularyName != nil {
		ok := object.Key("VocabularyName")
		ok.String(*v.VocabularyName)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetTranscriptionJobInput(v *GetTranscriptionJobInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.TranscriptionJobName != nil {
		ok := object.Key("TranscriptionJobName")
		ok.String(*v.TranscriptionJobName)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetVocabularyFilterInput(v *GetVocabularyFilterInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.VocabularyFilterName != nil {
		ok := object.Key("VocabularyFilterName")
		ok.String(*v.VocabularyFilterName)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetVocabularyInput(v *GetVocabularyInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.VocabularyName != nil {
		ok := object.Key("VocabularyName")
		ok.String(*v.VocabularyName)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListCallAnalyticsCategoriesInput(v *ListCallAnalyticsCategoriesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListCallAnalyticsJobsInput(v *ListCallAnalyticsJobsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.JobNameContains != nil {
		ok := object.Key("JobNameContains")
		ok.String(*v.JobNameContains)
	}

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if len(v.Status) > 0 {
		ok := object.Key("Status")
		ok.String(string(v.Status))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListLanguageModelsInput(v *ListLanguageModelsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NameContains != nil {
		ok := object.Key("NameContains")
		ok.String(*v.NameContains)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if len(v.StatusEquals) > 0 {
		ok := object.Key("StatusEquals")
		ok.String(string(v.StatusEquals))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListMedicalScribeJobsInput(v *ListMedicalScribeJobsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.JobNameContains != nil {
		ok := object.Key("JobNameContains")
		ok.String(*v.JobNameContains)
	}

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if len(v.Status) > 0 {
		ok := object.Key("Status")
		ok.String(string(v.Status))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListMedicalTranscriptionJobsInput(v *ListMedicalTranscriptionJobsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.JobNameContains != nil {
		ok := object.Key("JobNameContains")
		ok.String(*v.JobNameContains)
	}

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if len(v.Status) > 0 {
		ok := object.Key("Status")
		ok.String(string(v.Status))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListMedicalVocabulariesInput(v *ListMedicalVocabulariesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NameContains != nil {
		ok := object.Key("NameContains")
		ok.String(*v.NameContains)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if len(v.StateEquals) > 0 {
		ok := object.Key("StateEquals")
		ok.String(string(v.StateEquals))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListTagsForResourceInput(v *ListTagsForResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceArn != nil {
		ok := object.Key("ResourceArn")
		ok.String(*v.ResourceArn)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListTranscriptionJobsInput(v *ListTranscriptionJobsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.JobNameContains != nil {
		ok := object.Key("JobNameContains")
		ok.String(*v.JobNameContains)
	}

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if len(v.Status) > 0 {
		ok := object.Key("Status")
		ok.String(string(v.Status))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListVocabulariesInput(v *ListVocabulariesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NameContains != nil {
		ok := object.Key("NameContains")
		ok.String(*v.NameContains)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if len(v.StateEquals) > 0 {
		ok := object.Key("StateEquals")
		ok.String(string(v.StateEquals))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListVocabularyFiltersInput(v *ListVocabularyFiltersInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NameContains != nil {
		ok := object.Key("NameContains")
		ok.String(*v.NameContains)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentStartCallAnalyticsJobInput(v *StartCallAnalyticsJobInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CallAnalyticsJobName != nil {
		ok := object.Key("CallAnalyticsJobName")
		ok.String(*v.CallAnalyticsJobName)
	}

	if v.ChannelDefinitions != nil {
		ok := object.Key("ChannelDefinitions")
		if err := awsAwsjson11_serializeDocumentChannelDefinitions(v.ChannelDefinitions, ok); err != nil {
			return err
		}
	}

	if v.DataAccessRoleArn != nil {
		ok := object.Key("DataAccessRoleArn")
		ok.String(*v.DataAccessRoleArn)
	}

	if v.Media != nil {
		ok := object.Key("Media")
		if err := awsAwsjson11_serializeDocumentMedia(v.Media, ok); err != nil {
			return err
		}
	}

	if v.OutputEncryptionKMSKeyId != nil {
		ok := object.Key("OutputEncryptionKMSKeyId")
		ok.String(*v.OutputEncryptionKMSKeyId)
	}

	if v.OutputLocation != nil {
		ok := object.Key("OutputLocation")
		ok.String(*v.OutputLocation)
	}

	if v.Settings != nil {
		ok := object.Key("Settings")
		if err := awsAwsjson11_serializeDocumentCallAnalyticsJobSettings(v.Settings, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsAwsjson11_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentStartMedicalScribeJobInput(v *StartMedicalScribeJobInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ChannelDefinitions != nil {
		ok := object.Key("ChannelDefinitions")
		if err := awsAwsjson11_serializeDocumentMedicalScribeChannelDefinitions(v.ChannelDefinitions, ok); err != nil {
			return err
		}
	}

	if v.DataAccessRoleArn != nil {
		ok := object.Key("DataAccessRoleArn")
		ok.String(*v.DataAccessRoleArn)
	}

	if v.KMSEncryptionContext != nil {
		ok := object.Key("KMSEncryptionContext")
		if err := awsAwsjson11_serializeDocumentKMSEncryptionContextMap(v.KMSEncryptionContext, ok); err != nil {
			return err
		}
	}

	if v.Media != nil {
		ok := object.Key("Media")
		if err := awsAwsjson11_serializeDocumentMedia(v.Media, ok); err != nil {
			return err
		}
	}

	if v.MedicalScribeJobName != nil {
		ok := object.Key("MedicalScribeJobName")
		ok.String(*v.MedicalScribeJobName)
	}

	if v.OutputBucketName != nil {
		ok := object.Key("OutputBucketName")
		ok.String(*v.OutputBucketName)
	}

	if v.OutputEncryptionKMSKeyId != nil {
		ok := object.Key("OutputEncryptionKMSKeyId")
		ok.String(*v.OutputEncryptionKMSKeyId)
	}

	if v.Settings != nil {
		ok := object.Key("Settings")
		if err := awsAwsjson11_serializeDocumentMedicalScribeSettings(v.Settings, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsAwsjson11_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentStartMedicalTranscriptionJobInput(v *StartMedicalTranscriptionJobInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.ContentIdentificationType) > 0 {
		ok := object.Key("ContentIdentificationType")
		ok.String(string(v.ContentIdentificationType))
	}

	if v.KMSEncryptionContext != nil {
		ok := object.Key("KMSEncryptionContext")
		if err := awsAwsjson11_serializeDocumentKMSEncryptionContextMap(v.KMSEncryptionContext, ok); err != nil {
			return err
		}
	}

	if len(v.LanguageCode) > 0 {
		ok := object.Key("LanguageCode")
		ok.String(string(v.LanguageCode))
	}

	if v.Media != nil {
		ok := object.Key("Media")
		if err := awsAwsjson11_serializeDocumentMedia(v.Media, ok); err != nil {
			return err
		}
	}

	if len(v.MediaFormat) > 0 {
		ok := object.Key("MediaFormat")
		ok.String(string(v.MediaFormat))
	}

	if v.MediaSampleRateHertz != nil {
		ok := object.Key("MediaSampleRateHertz")
		ok.Integer(*v.MediaSampleRateHertz)
	}

	if v.MedicalTranscriptionJobName != nil {
		ok := object.Key("MedicalTranscriptionJobName")
		ok.String(*v.MedicalTranscriptionJobName)
	}

	if v.OutputBucketName != nil {
		ok := object.Key("OutputBucketName")
		ok.String(*v.OutputBucketName)
	}

	if v.OutputEncryptionKMSKeyId != nil {
		ok := object.Key("OutputEncryptionKMSKeyId")
		ok.String(*v.OutputEncryptionKMSKeyId)
	}

	if v.OutputKey != nil {
		ok := object.Key("OutputKey")
		ok.String(*v.OutputKey)
	}

	if v.Settings != nil {
		ok := object.Key("Settings")
		if err := awsAwsjson11_serializeDocumentMedicalTranscriptionSetting(v.Settings, ok); err != nil {
			return err
		}
	}

	if len(v.Specialty) > 0 {
		ok := object.Key("Specialty")
		ok.String(string(v.Specialty))
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsAwsjson11_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	if len(v.Type) > 0 {
		ok := object.Key("Type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentStartTranscriptionJobInput(v *StartTranscriptionJobInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ContentRedaction != nil {
		ok := object.Key("ContentRedaction")
		if err := awsAwsjson11_serializeDocumentContentRedaction(v.ContentRedaction, ok); err != nil {
			return err
		}
	}

	if v.IdentifyLanguage != nil {
		ok := object.Key("IdentifyLanguage")
		ok.Boolean(*v.IdentifyLanguage)
	}

	if v.IdentifyMultipleLanguages != nil {
		ok := object.Key("IdentifyMultipleLanguages")
		ok.Boolean(*v.IdentifyMultipleLanguages)
	}

	if v.JobExecutionSettings != nil {
		ok := object.Key("JobExecutionSettings")
		if err := awsAwsjson11_serializeDocumentJobExecutionSettings(v.JobExecutionSettings, ok); err != nil {
			return err
		}
	}

	if v.KMSEncryptionContext != nil {
		ok := object.Key("KMSEncryptionContext")
		if err := awsAwsjson11_serializeDocumentKMSEncryptionContextMap(v.KMSEncryptionContext, ok); err != nil {
			return err
		}
	}

	if len(v.LanguageCode) > 0 {
		ok := object.Key("LanguageCode")
		ok.String(string(v.LanguageCode))
	}

	if v.LanguageIdSettings != nil {
		ok := object.Key("LanguageIdSettings")
		if err := awsAwsjson11_serializeDocumentLanguageIdSettingsMap(v.LanguageIdSettings, ok); err != nil {
			return err
		}
	}

	if v.LanguageOptions != nil {
		ok := object.Key("LanguageOptions")
		if err := awsAwsjson11_serializeDocumentLanguageOptions(v.LanguageOptions, ok); err != nil {
			return err
		}
	}

	if v.Media != nil {
		ok := object.Key("Media")
		if err := awsAwsjson11_serializeDocumentMedia(v.Media, ok); err != nil {
			return err
		}
	}

	if len(v.MediaFormat) > 0 {
		ok := object.Key("MediaFormat")
		ok.String(string(v.MediaFormat))
	}

	if v.MediaSampleRateHertz != nil {
		ok := object.Key("MediaSampleRateHertz")
		ok.Integer(*v.MediaSampleRateHertz)
	}

	if v.ModelSettings != nil {
		ok := object.Key("ModelSettings")
		if err := awsAwsjson11_serializeDocumentModelSettings(v.ModelSettings, ok); err != nil {
			return err
		}
	}

	if v.OutputBucketName != nil {
		ok := object.Key("OutputBucketName")
		ok.String(*v.OutputBucketName)
	}

	if v.OutputEncryptionKMSKeyId != nil {
		ok := object.Key("OutputEncryptionKMSKeyId")
		ok.String(*v.OutputEncryptionKMSKeyId)
	}

	if v.OutputKey != nil {
		ok := object.Key("OutputKey")
		ok.String(*v.OutputKey)
	}

	if v.Settings != nil {
		ok := object.Key("Settings")
		if err := awsAwsjson11_serializeDocumentSettings(v.Settings, ok); err != nil {
			return err
		}
	}

	if v.Subtitles != nil {
		ok := object.Key("Subtitles")
		if err := awsAwsjson11_serializeDocumentSubtitles(v.Subtitles, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsAwsjson11_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.ToxicityDetection != nil {
		ok := object.Key("ToxicityDetection")
		if err := awsAwsjson11_serializeDocumentToxicityDetection(v.ToxicityDetection, ok); err != nil {
			return err
		}
	}

	if v.TranscriptionJobName != nil {
		ok := object.Key("TranscriptionJobName")
		ok.String(*v.TranscriptionJobName)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentTagResourceInput(v *TagResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceArn != nil {
		ok := object.Key("ResourceArn")
		ok.String(*v.ResourceArn)
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsAwsjson11_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUntagResourceInput(v *UntagResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceArn != nil {
		ok := object.Key("ResourceArn")
		ok.String(*v.ResourceArn)
	}

	if v.TagKeys != nil {
		ok := object.Key("TagKeys")
		if err := awsAwsjson11_serializeDocumentTagKeyList(v.TagKeys, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUpdateCallAnalyticsCategoryInput(v *UpdateCallAnalyticsCategoryInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CategoryName != nil {
		ok := object.Key("CategoryName")
		ok.String(*v.CategoryName)
	}

	if len(v.InputType) > 0 {
		ok := object.Key("InputType")
		ok.String(string(v.InputType))
	}

	if v.Rules != nil {
		ok := object.Key("Rules")
		if err := awsAwsjson11_serializeDocumentRuleList(v.Rules, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUpdateMedicalVocabularyInput(v *UpdateMedicalVocabularyInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.LanguageCode) > 0 {
		ok := object.Key("LanguageCode")
		ok.String(string(v.LanguageCode))
	}

	if v.VocabularyFileUri != nil {
		ok := object.Key("VocabularyFileUri")
		ok.String(*v.VocabularyFileUri)
	}

	if v.VocabularyName != nil {
		ok := object.Key("VocabularyName")
		ok.String(*v.VocabularyName)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUpdateVocabularyFilterInput(v *UpdateVocabularyFilterInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DataAccessRoleArn != nil {
		ok := object.Key("DataAccessRoleArn")
		ok.String(*v.DataAccessRoleArn)
	}

	if v.VocabularyFilterFileUri != nil {
		ok := object.Key("VocabularyFilterFileUri")
		ok.String(*v.VocabularyFilterFileUri)
	}

	if v.VocabularyFilterName != nil {
		ok := object.Key("VocabularyFilterName")
		ok.String(*v.VocabularyFilterName)
	}

	if v.Words != nil {
		ok := object.Key("Words")
		if err := awsAwsjson11_serializeDocumentWords(v.Words, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUpdateVocabularyInput(v *UpdateVocabularyInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DataAccessRoleArn != nil {
		ok := object.Key("DataAccessRoleArn")
		ok.String(*v.DataAccessRoleArn)
	}

	if len(v.LanguageCode) > 0 {
		ok := object.Key("LanguageCode")
		ok.String(string(v.LanguageCode))
	}

	if v.Phrases != nil {
		ok := object.Key("Phrases")
		if err := awsAwsjson11_serializeDocumentPhrases(v.Phrases, ok); err != nil {
			return err
		}
	}

	if v.VocabularyFileUri != nil {
		ok := object.Key("VocabularyFileUri")
		ok.String(*v.VocabularyFileUri)
	}

	if v.VocabularyName != nil {
		ok := object.Key("VocabularyName")
		ok.String(*v.VocabularyName)
	}

	return nil
}
