// Code generated by smithy-go-codegen DO NOT EDIT.

package taxsettings

import (
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/taxsettings/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/middleware"
)

type validateOpBatchDeleteTaxRegistration struct {
}

func (*validateOpBatchDeleteTaxRegistration) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpBatchDeleteTaxRegistration) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*BatchDeleteTaxRegistrationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpBatchDeleteTaxRegistrationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpBatchGetTaxExemptions struct {
}

func (*validateOpBatchGetTaxExemptions) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpBatchGetTaxExemptions) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*BatchGetTaxExemptionsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpBatchGetTaxExemptionsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpBatchPutTaxRegistration struct {
}

func (*validateOpBatchPutTaxRegistration) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpBatchPutTaxRegistration) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*BatchPutTaxRegistrationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpBatchPutTaxRegistrationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteSupplementalTaxRegistration struct {
}

func (*validateOpDeleteSupplementalTaxRegistration) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteSupplementalTaxRegistration) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteSupplementalTaxRegistrationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteSupplementalTaxRegistrationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetTaxRegistrationDocument struct {
}

func (*validateOpGetTaxRegistrationDocument) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetTaxRegistrationDocument) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetTaxRegistrationDocumentInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetTaxRegistrationDocumentInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpPutSupplementalTaxRegistration struct {
}

func (*validateOpPutSupplementalTaxRegistration) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpPutSupplementalTaxRegistration) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*PutSupplementalTaxRegistrationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpPutSupplementalTaxRegistrationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpPutTaxExemption struct {
}

func (*validateOpPutTaxExemption) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpPutTaxExemption) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*PutTaxExemptionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpPutTaxExemptionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpPutTaxRegistration struct {
}

func (*validateOpPutTaxRegistration) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpPutTaxRegistration) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*PutTaxRegistrationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpPutTaxRegistrationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

func addOpBatchDeleteTaxRegistrationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpBatchDeleteTaxRegistration{}, middleware.After)
}

func addOpBatchGetTaxExemptionsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpBatchGetTaxExemptions{}, middleware.After)
}

func addOpBatchPutTaxRegistrationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpBatchPutTaxRegistration{}, middleware.After)
}

func addOpDeleteSupplementalTaxRegistrationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteSupplementalTaxRegistration{}, middleware.After)
}

func addOpGetTaxRegistrationDocumentValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetTaxRegistrationDocument{}, middleware.After)
}

func addOpPutSupplementalTaxRegistrationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpPutSupplementalTaxRegistration{}, middleware.After)
}

func addOpPutTaxExemptionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpPutTaxExemption{}, middleware.After)
}

func addOpPutTaxRegistrationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpPutTaxRegistration{}, middleware.After)
}

func validateAdditionalInfoRequest(v *types.AdditionalInfoRequest) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AdditionalInfoRequest"}
	if v.IsraelAdditionalInfo != nil {
		if err := validateIsraelAdditionalInfo(v.IsraelAdditionalInfo); err != nil {
			invalidParams.AddNested("IsraelAdditionalInfo", err.(smithy.InvalidParamsError))
		}
	}
	if v.EstoniaAdditionalInfo != nil {
		if err := validateEstoniaAdditionalInfo(v.EstoniaAdditionalInfo); err != nil {
			invalidParams.AddNested("EstoniaAdditionalInfo", err.(smithy.InvalidParamsError))
		}
	}
	if v.SpainAdditionalInfo != nil {
		if err := validateSpainAdditionalInfo(v.SpainAdditionalInfo); err != nil {
			invalidParams.AddNested("SpainAdditionalInfo", err.(smithy.InvalidParamsError))
		}
	}
	if v.KenyaAdditionalInfo != nil {
		if err := validateKenyaAdditionalInfo(v.KenyaAdditionalInfo); err != nil {
			invalidParams.AddNested("KenyaAdditionalInfo", err.(smithy.InvalidParamsError))
		}
	}
	if v.SouthKoreaAdditionalInfo != nil {
		if err := validateSouthKoreaAdditionalInfo(v.SouthKoreaAdditionalInfo); err != nil {
			invalidParams.AddNested("SouthKoreaAdditionalInfo", err.(smithy.InvalidParamsError))
		}
	}
	if v.GeorgiaAdditionalInfo != nil {
		if err := validateGeorgiaAdditionalInfo(v.GeorgiaAdditionalInfo); err != nil {
			invalidParams.AddNested("GeorgiaAdditionalInfo", err.(smithy.InvalidParamsError))
		}
	}
	if v.RomaniaAdditionalInfo != nil {
		if err := validateRomaniaAdditionalInfo(v.RomaniaAdditionalInfo); err != nil {
			invalidParams.AddNested("RomaniaAdditionalInfo", err.(smithy.InvalidParamsError))
		}
	}
	if v.UkraineAdditionalInfo != nil {
		if err := validateUkraineAdditionalInfo(v.UkraineAdditionalInfo); err != nil {
			invalidParams.AddNested("UkraineAdditionalInfo", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateAddress(v *types.Address) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Address"}
	if v.AddressLine1 == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AddressLine1"))
	}
	if v.City == nil {
		invalidParams.Add(smithy.NewErrParamRequired("City"))
	}
	if v.PostalCode == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PostalCode"))
	}
	if v.CountryCode == nil {
		invalidParams.Add(smithy.NewErrParamRequired("CountryCode"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateAuthority(v *types.Authority) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Authority"}
	if v.Country == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Country"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateDestinationS3Location(v *types.DestinationS3Location) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DestinationS3Location"}
	if v.Bucket == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Bucket"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateEstoniaAdditionalInfo(v *types.EstoniaAdditionalInfo) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "EstoniaAdditionalInfo"}
	if v.RegistryCommercialCode == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RegistryCommercialCode"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateExemptionCertificate(v *types.ExemptionCertificate) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ExemptionCertificate"}
	if v.DocumentName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DocumentName"))
	}
	if v.DocumentFile == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DocumentFile"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateGeorgiaAdditionalInfo(v *types.GeorgiaAdditionalInfo) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GeorgiaAdditionalInfo"}
	if len(v.PersonType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("PersonType"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateIsraelAdditionalInfo(v *types.IsraelAdditionalInfo) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "IsraelAdditionalInfo"}
	if len(v.DealerType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("DealerType"))
	}
	if len(v.CustomerType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("CustomerType"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateKenyaAdditionalInfo(v *types.KenyaAdditionalInfo) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "KenyaAdditionalInfo"}
	if len(v.PersonType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("PersonType"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRomaniaAdditionalInfo(v *types.RomaniaAdditionalInfo) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RomaniaAdditionalInfo"}
	if len(v.TaxRegistrationNumberType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("TaxRegistrationNumberType"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSourceS3Location(v *types.SourceS3Location) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SourceS3Location"}
	if v.Bucket == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Bucket"))
	}
	if v.Key == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Key"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSouthKoreaAdditionalInfo(v *types.SouthKoreaAdditionalInfo) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SouthKoreaAdditionalInfo"}
	if v.BusinessRepresentativeName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("BusinessRepresentativeName"))
	}
	if v.LineOfBusiness == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LineOfBusiness"))
	}
	if v.ItemOfBusiness == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ItemOfBusiness"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSpainAdditionalInfo(v *types.SpainAdditionalInfo) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SpainAdditionalInfo"}
	if len(v.RegistrationType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("RegistrationType"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSupplementalTaxRegistrationEntry(v *types.SupplementalTaxRegistrationEntry) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SupplementalTaxRegistrationEntry"}
	if v.RegistrationId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RegistrationId"))
	}
	if len(v.RegistrationType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("RegistrationType"))
	}
	if v.LegalName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LegalName"))
	}
	if v.Address == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Address"))
	} else if v.Address != nil {
		if err := validateAddress(v.Address); err != nil {
			invalidParams.AddNested("Address", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTaxDocumentMetadata(v *types.TaxDocumentMetadata) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TaxDocumentMetadata"}
	if v.TaxDocumentAccessToken == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TaxDocumentAccessToken"))
	}
	if v.TaxDocumentName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TaxDocumentName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTaxRegistrationDocFile(v *types.TaxRegistrationDocFile) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TaxRegistrationDocFile"}
	if v.FileName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("FileName"))
	}
	if v.FileContent == nil {
		invalidParams.Add(smithy.NewErrParamRequired("FileContent"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTaxRegistrationDocument(v *types.TaxRegistrationDocument) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TaxRegistrationDocument"}
	if v.S3Location != nil {
		if err := validateSourceS3Location(v.S3Location); err != nil {
			invalidParams.AddNested("S3Location", err.(smithy.InvalidParamsError))
		}
	}
	if v.File != nil {
		if err := validateTaxRegistrationDocFile(v.File); err != nil {
			invalidParams.AddNested("File", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTaxRegistrationDocuments(v []types.TaxRegistrationDocument) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TaxRegistrationDocuments"}
	for i := range v {
		if err := validateTaxRegistrationDocument(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTaxRegistrationEntry(v *types.TaxRegistrationEntry) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TaxRegistrationEntry"}
	if v.RegistrationId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RegistrationId"))
	}
	if len(v.RegistrationType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("RegistrationType"))
	}
	if v.LegalAddress != nil {
		if err := validateAddress(v.LegalAddress); err != nil {
			invalidParams.AddNested("LegalAddress", err.(smithy.InvalidParamsError))
		}
	}
	if v.AdditionalTaxInformation != nil {
		if err := validateAdditionalInfoRequest(v.AdditionalTaxInformation); err != nil {
			invalidParams.AddNested("AdditionalTaxInformation", err.(smithy.InvalidParamsError))
		}
	}
	if v.VerificationDetails != nil {
		if err := validateVerificationDetails(v.VerificationDetails); err != nil {
			invalidParams.AddNested("VerificationDetails", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateUkraineAdditionalInfo(v *types.UkraineAdditionalInfo) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UkraineAdditionalInfo"}
	if len(v.UkraineTrnType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("UkraineTrnType"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateVerificationDetails(v *types.VerificationDetails) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "VerificationDetails"}
	if v.TaxRegistrationDocuments != nil {
		if err := validateTaxRegistrationDocuments(v.TaxRegistrationDocuments); err != nil {
			invalidParams.AddNested("TaxRegistrationDocuments", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpBatchDeleteTaxRegistrationInput(v *BatchDeleteTaxRegistrationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "BatchDeleteTaxRegistrationInput"}
	if v.AccountIds == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccountIds"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpBatchGetTaxExemptionsInput(v *BatchGetTaxExemptionsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "BatchGetTaxExemptionsInput"}
	if v.AccountIds == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccountIds"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpBatchPutTaxRegistrationInput(v *BatchPutTaxRegistrationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "BatchPutTaxRegistrationInput"}
	if v.AccountIds == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccountIds"))
	}
	if v.TaxRegistrationEntry == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TaxRegistrationEntry"))
	} else if v.TaxRegistrationEntry != nil {
		if err := validateTaxRegistrationEntry(v.TaxRegistrationEntry); err != nil {
			invalidParams.AddNested("TaxRegistrationEntry", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteSupplementalTaxRegistrationInput(v *DeleteSupplementalTaxRegistrationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteSupplementalTaxRegistrationInput"}
	if v.AuthorityId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AuthorityId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetTaxRegistrationDocumentInput(v *GetTaxRegistrationDocumentInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetTaxRegistrationDocumentInput"}
	if v.DestinationS3Location != nil {
		if err := validateDestinationS3Location(v.DestinationS3Location); err != nil {
			invalidParams.AddNested("DestinationS3Location", err.(smithy.InvalidParamsError))
		}
	}
	if v.TaxDocumentMetadata == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TaxDocumentMetadata"))
	} else if v.TaxDocumentMetadata != nil {
		if err := validateTaxDocumentMetadata(v.TaxDocumentMetadata); err != nil {
			invalidParams.AddNested("TaxDocumentMetadata", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpPutSupplementalTaxRegistrationInput(v *PutSupplementalTaxRegistrationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PutSupplementalTaxRegistrationInput"}
	if v.TaxRegistrationEntry == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TaxRegistrationEntry"))
	} else if v.TaxRegistrationEntry != nil {
		if err := validateSupplementalTaxRegistrationEntry(v.TaxRegistrationEntry); err != nil {
			invalidParams.AddNested("TaxRegistrationEntry", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpPutTaxExemptionInput(v *PutTaxExemptionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PutTaxExemptionInput"}
	if v.AccountIds == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccountIds"))
	}
	if v.Authority == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Authority"))
	} else if v.Authority != nil {
		if err := validateAuthority(v.Authority); err != nil {
			invalidParams.AddNested("Authority", err.(smithy.InvalidParamsError))
		}
	}
	if v.ExemptionType == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ExemptionType"))
	}
	if v.ExemptionCertificate == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ExemptionCertificate"))
	} else if v.ExemptionCertificate != nil {
		if err := validateExemptionCertificate(v.ExemptionCertificate); err != nil {
			invalidParams.AddNested("ExemptionCertificate", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpPutTaxRegistrationInput(v *PutTaxRegistrationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PutTaxRegistrationInput"}
	if v.TaxRegistrationEntry == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TaxRegistrationEntry"))
	} else if v.TaxRegistrationEntry != nil {
		if err := validateTaxRegistrationEntry(v.TaxRegistrationEntry); err != nil {
			invalidParams.AddNested("TaxRegistrationEntry", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}
