// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
)

// An attachment to a case communication. The attachment consists of the file name
// and the content of the file. Each attachment file size should not exceed 5 MB.
// File types that are supported include the following: pdf, jpeg,.doc, .log, .text
type Attachment struct {

	// The content of the attachment file.
	Data []byte

	// The name of the attachment file.
	FileName *string

	noSmithyDocumentSerde
}

// The file name and ID of an attachment to a case communication. You can use the
// ID to retrieve the attachment with the DescribeAttachmentoperation.
type AttachmentDetails struct {

	// The ID of the attachment.
	AttachmentId *string

	// The file name of the attachment.
	FileName *string

	noSmithyDocumentSerde
}

// A JSON-formatted object that contains the metadata for a support case. It is
// contained in the response from a DescribeCasesrequest. CaseDetails contains the following
// fields:
//
//   - caseId - The support case ID requested or returned in the call. The case ID
//     is an alphanumeric string formatted as shown in this example:
//     case-12345678910-2013-c4c1d2bf33c5cf47.
//
//   - categoryCode - The category of problem for the support case. Corresponds to
//     the CategoryCode values returned by a call to DescribeServices.
//
//   - displayId - The identifier for the case on pages in the Amazon Web Services
//     Support Center.
//
//   - language - The language in which Amazon Web Services Support handles the
//     case. Amazon Web Services Support currently supports Chinese (“zh”), English
//     ("en"), Japanese ("ja") and Korean (“ko”). You must specify the ISO 639-1 code
//     for the language parameter if you want support in that language.
//
//   - nextToken - A resumption point for pagination.
//
//   - recentCommunications - One or more Communicationobjects. Fields of these objects are
//     attachments , body , caseId , submittedBy , and timeCreated .
//
//   - serviceCode - The identifier for the Amazon Web Services service that
//     corresponds to the service code defined in the call to DescribeServices.
//
//   - severityCode - The severity code assigned to the case. Contains one of the
//     values returned by the call to DescribeSeverityLevels. The possible values are: low , normal , high
//     , urgent , and critical .
//
//   - status - The status of the case in the Amazon Web Services Support Center.
//     Valid values:
//
//   - all-open
//
//   - customer-action-completed
//
//   - opened
//
//   - pending-customer-action
//
//   - reopened
//
//   - resolved
//
//   - unassigned
//
//   - work-in-progress
//
//   - subject - The subject line of the case.
//
//   - submittedBy - The email address of the account that submitted the case.
//
//   - timeCreated - The time the case was created, in ISO-8601 format.
type CaseDetails struct {

	// The support case ID requested or returned in the call. The case ID is an
	// alphanumeric string formatted as shown in this example:
	// case-12345678910-2013-c4c1d2bf33c5cf47
	CaseId *string

	// The category of problem for the support case.
	CategoryCode *string

	// The email addresses that receive copies of communication about the case.
	CcEmailAddresses []string

	// The ID displayed for the case in the Amazon Web Services Support Center. This
	// is a numeric string.
	DisplayId *string

	// The language in which Amazon Web Services Support handles the case. Amazon Web
	// Services Support currently supports Chinese (“zh”), English ("en"), Japanese
	// ("ja") and Korean (“ko”). You must specify the ISO 639-1 code for the language
	// parameter if you want support in that language.
	Language *string

	// The five most recent communications between you and Amazon Web Services Support
	// Center, including the IDs of any attachments to the communications. Also
	// includes a nextToken that you can use to retrieve earlier communications.
	RecentCommunications *RecentCaseCommunications

	// The code for the Amazon Web Services service. You can get a list of codes and
	// the corresponding service names by calling DescribeServices.
	ServiceCode *string

	// The code for the severity level returned by the call to DescribeSeverityLevels.
	SeverityCode *string

	// The status of the case.
	//
	// Valid values:
	//
	//   - all-open
	//
	//   - customer-action-completed
	//
	//   - opened
	//
	//   - pending-customer-action
	//
	//   - reopened
	//
	//   - resolved
	//
	//   - unassigned
	//
	//   - work-in-progress
	Status *string

	// The subject line for the case in the Amazon Web Services Support Center.
	Subject *string

	// The email address of the account that submitted the case.
	SubmittedBy *string

	// The time that the case was created in the Amazon Web Services Support Center.
	TimeCreated *string

	noSmithyDocumentSerde
}

// A JSON-formatted name/value pair that represents the category name and category
// code of the problem, selected from the DescribeServicesresponse for each Amazon Web Services
// service.
type Category struct {

	// The category code for the support case.
	Code *string

	// The category name for the support case.
	Name *string

	noSmithyDocumentSerde
}

// A communication associated with a support case. The communication consists of
// the case ID, the message body, attachment information, the submitter of the
// communication, and the date and time of the communication.
type Communication struct {

	// Information about the attachments to the case communication.
	AttachmentSet []AttachmentDetails

	// The text of the communication between the customer and Amazon Web Services
	// Support.
	Body *string

	// The support case ID requested or returned in the call. The case ID is an
	// alphanumeric string formatted as shown in this example:
	// case-12345678910-2013-c4c1d2bf33c5cf47
	CaseId *string

	// The identity of the account that submitted, or responded to, the support case.
	// Customer entries include the IAM role as well as the email address (for example,
	// "AdminRole (Role) ). Entries from the Amazon Web Services Support team display
	// "Amazon Web Services," and don't show an email address.
	SubmittedBy *string

	// The time the communication was created.
	TimeCreated *string

	noSmithyDocumentSerde
}

// A JSON-formatted object that contains the CommunicationTypeOptions for creating
// a case for a certain communication channel. It is contained in the response from
// a DescribeCreateCaseOptionsrequest. CommunicationTypeOptions contains the following fields:
//
//   - datesWithoutSupport - A JSON-formatted list containing date and time ranges
//     for periods without support in UTC time. Date and time format is RFC 3339 :
//     'yyyy-MM-dd'T'HH:mm:ss.SSSZZ'.
//
//   - supportedHours - A JSON-formatted list containing time ranges when support
//     are available. Time format is RFC 3339 : 'HH:mm:ss.SSS'.
//
//   - type - A string value indicating the communication type that the
//     aforementioned rules apply to. At the moment the type value can assume one of 3
//     values at the moment chat , web and call .
type CommunicationTypeOptions struct {

	//  A JSON-formatted list containing date and time ranges for periods without
	// support
	DatesWithoutSupport []DateInterval

	//  A JSON-formatted list containing time ranges when support is available.
	SupportedHours []SupportedHour

	//  A string value indicating the communication type. At the moment the type value
	// can assume one of 3 values at the moment chat, web and call.
	Type *string

	noSmithyDocumentSerde
}

// Date and time (UTC) format in RFC 3339 : 'yyyy-MM-dd'T'HH:mm:ss.SSSZZ'.
type DateInterval struct {

	//  End Date Time (UTC). RFC 3339 format : 'yyyy-MM-dd'T'HH:mm:ss.SSSZZ'.
	EndDateTime *string

	//  A JSON object containing start and date time (UTC). Date and time format is
	// RFC 3339 : 'yyyy-MM-dd'T'HH:mm:ss.SSSZZ'.
	StartDateTime *string

	noSmithyDocumentSerde
}

// The five most recent communications associated with the case.
type RecentCaseCommunications struct {

	// The five most recent communications associated with the case.
	Communications []Communication

	// A resumption point for pagination.
	NextToken *string

	noSmithyDocumentSerde
}

// Information about an Amazon Web Services service returned by the DescribeServices operation.
type Service struct {

	// A list of categories that describe the type of support issue a case describes.
	// Categories consist of a category name and a category code. Category names and
	// codes are passed to Amazon Web Services Support when you call CreateCase.
	Categories []Category

	// The code for an Amazon Web Services service returned by the DescribeServices response. The name
	// element contains the corresponding friendly name.
	Code *string

	// The friendly name for an Amazon Web Services service. The code element contains
	// the corresponding code.
	Name *string

	noSmithyDocumentSerde
}

// A code and name pair that represents the severity level of a support case. The
// available values depend on the support plan for the account. For more
// information, see [Choosing a severity]in the Amazon Web Services Support User Guide.
//
// [Choosing a severity]: https://docs.aws.amazon.com/awssupport/latest/user/case-management.html#choosing-severity
type SeverityLevel struct {

	// The code for case severity level.
	//
	// Valid values: low | normal | high | urgent | critical
	Code *string

	// The name of the severity level that corresponds to the severity level code.
	//
	// The values returned by the API are different from the values that appear in the
	// Amazon Web Services Support Center. For example, the API uses the code low , but
	// the name appears as General guidance in Support Center.
	//
	// The following are the API code names and how they appear in the console:
	//
	//   - low - General guidance
	//
	//   - normal - System impaired
	//
	//   - high - Production system impaired
	//
	//   - urgent - Production system down
	//
	//   - critical - Business-critical system down
	//
	// For more information, see [Choosing a severity] in the Amazon Web Services Support User Guide.
	//
	// [Choosing a severity]: https://docs.aws.amazon.com/awssupport/latest/user/case-management.html#choosing-severity
	Name *string

	noSmithyDocumentSerde
}

// Time range object with startTime and endTime range in RFC 3339 format.
// 'HH:mm:ss.SSS' .
type SupportedHour struct {

	//  End Time. RFC 3339 format 'HH:mm:ss.SSS' .
	EndTime *string

	//  Start Time. RFC 3339 format 'HH:mm:ss.SSS' .
	StartTime *string

	noSmithyDocumentSerde
}

//	A JSON-formatted object that contains the available ISO 639-1 language code ,
//
// language name and langauge display value. The language code is what should be
// used in the CreateCasecall.
type SupportedLanguage struct {

	//  2 digit ISO 639-1 code. e.g. en
	Code *string

	//  Language display value e.g. ENGLISH
	Display *string

	//  Full language description e.g. ENGLISH
	Language *string

	noSmithyDocumentSerde
}

// The container for summary information that relates to the category of the
// Trusted Advisor check.
type TrustedAdvisorCategorySpecificSummary struct {

	// The summary information about cost savings for a Trusted Advisor check that is
	// in the Cost Optimizing category.
	CostOptimizing *TrustedAdvisorCostOptimizingSummary

	noSmithyDocumentSerde
}

// The description and metadata for a Trusted Advisor check.
type TrustedAdvisorCheckDescription struct {

	// The category of the Trusted Advisor check.
	//
	// This member is required.
	Category *string

	// The description of the Trusted Advisor check, which includes the alert criteria
	// and recommended operations (contains HTML markup).
	//
	// This member is required.
	Description *string

	// The unique identifier for the Trusted Advisor check.
	//
	// This member is required.
	Id *string

	// The column headings for the data returned by the Trusted Advisor check. The
	// order of the headings corresponds to the order of the data in the Metadata
	// element of the TrustedAdvisorResourceDetailfor the check. Metadata contains all the data that is shown in
	// the Excel download, even in those cases where the UI shows just summary data.
	//
	// This member is required.
	Metadata []*string

	// The display name for the Trusted Advisor check.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// The refresh status of a Trusted Advisor check.
type TrustedAdvisorCheckRefreshStatus struct {

	// The unique identifier for the Trusted Advisor check.
	//
	// This member is required.
	CheckId *string

	// The amount of time, in milliseconds, until the Trusted Advisor check is
	// eligible for refresh.
	//
	// This member is required.
	MillisUntilNextRefreshable int64

	// The status of the Trusted Advisor check for which a refresh has been requested:
	//
	//   - none - The check is not refreshed or the non-success status exceeds the
	//   timeout
	//
	//   - enqueued - The check refresh requests has entered the refresh queue
	//
	//   - processing - The check refresh request is picked up by the rule processing
	//   engine
	//
	//   - success - The check is successfully refreshed
	//
	//   - abandoned - The check refresh has failed
	//
	// This member is required.
	Status *string

	noSmithyDocumentSerde
}

// The results of a Trusted Advisor check returned by DescribeTrustedAdvisorCheckResult.
type TrustedAdvisorCheckResult struct {

	// Summary information that relates to the category of the check. Cost Optimizing
	// is the only category that is currently supported.
	//
	// This member is required.
	CategorySpecificSummary *TrustedAdvisorCategorySpecificSummary

	// The unique identifier for the Trusted Advisor check.
	//
	// This member is required.
	CheckId *string

	// The details about each resource listed in the check result.
	//
	// This member is required.
	FlaggedResources []TrustedAdvisorResourceDetail

	// Details about Amazon Web Services resources that were analyzed in a call to
	// Trusted Advisor DescribeTrustedAdvisorCheckSummaries.
	//
	// This member is required.
	ResourcesSummary *TrustedAdvisorResourcesSummary

	// The alert status of the check: "ok" (green), "warning" (yellow), "error" (red),
	// or "not_available".
	//
	// This member is required.
	Status *string

	// The time of the last refresh of the check.
	//
	// This member is required.
	Timestamp *string

	noSmithyDocumentSerde
}

// A summary of a Trusted Advisor check result, including the alert status, last
// refresh, and number of resources examined.
type TrustedAdvisorCheckSummary struct {

	// Summary information that relates to the category of the check. Cost Optimizing
	// is the only category that is currently supported.
	//
	// This member is required.
	CategorySpecificSummary *TrustedAdvisorCategorySpecificSummary

	// The unique identifier for the Trusted Advisor check.
	//
	// This member is required.
	CheckId *string

	// Details about Amazon Web Services resources that were analyzed in a call to
	// Trusted Advisor DescribeTrustedAdvisorCheckSummaries.
	//
	// This member is required.
	ResourcesSummary *TrustedAdvisorResourcesSummary

	// The alert status of the check: "ok" (green), "warning" (yellow), "error" (red),
	// or "not_available".
	//
	// This member is required.
	Status *string

	// The time of the last refresh of the check.
	//
	// This member is required.
	Timestamp *string

	// Specifies whether the Trusted Advisor check has flagged resources.
	HasFlaggedResources bool

	noSmithyDocumentSerde
}

// The estimated cost savings that might be realized if the recommended operations
// are taken.
type TrustedAdvisorCostOptimizingSummary struct {

	// The estimated monthly savings that might be realized if the recommended
	// operations are taken.
	//
	// This member is required.
	EstimatedMonthlySavings float64

	// The estimated percentage of savings that might be realized if the recommended
	// operations are taken.
	//
	// This member is required.
	EstimatedPercentMonthlySavings float64

	noSmithyDocumentSerde
}

// Contains information about a resource identified by a Trusted Advisor check.
type TrustedAdvisorResourceDetail struct {

	// Additional information about the identified resource. The exact metadata and
	// its order can be obtained by inspecting the TrustedAdvisorCheckDescriptionobject returned by the call to DescribeTrustedAdvisorChecks.
	// Metadata contains all the data that is shown in the Excel download, even in
	// those cases where the UI shows just summary data.
	//
	// This member is required.
	Metadata []*string

	// The unique identifier for the identified resource.
	//
	// This member is required.
	ResourceId *string

	// The status code for the resource identified in the Trusted Advisor check.
	//
	// This member is required.
	Status *string

	// Specifies whether the Amazon Web Services resource was ignored by Trusted
	// Advisor because it was marked as suppressed by the user.
	IsSuppressed bool

	// The Amazon Web Services Region in which the identified resource is located.
	Region *string

	noSmithyDocumentSerde
}

// Details about Amazon Web Services resources that were analyzed in a call to
// Trusted Advisor DescribeTrustedAdvisorCheckSummaries.
type TrustedAdvisorResourcesSummary struct {

	// The number of Amazon Web Services resources that were flagged (listed) by the
	// Trusted Advisor check.
	//
	// This member is required.
	ResourcesFlagged int64

	// The number of Amazon Web Services resources ignored by Trusted Advisor because
	// information was unavailable.
	//
	// This member is required.
	ResourcesIgnored int64

	// The number of Amazon Web Services resources that were analyzed by the Trusted
	// Advisor check.
	//
	// This member is required.
	ResourcesProcessed int64

	// The number of Amazon Web Services resources ignored by Trusted Advisor because
	// they were marked as suppressed by the user.
	//
	// This member is required.
	ResourcesSuppressed int64

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
