// Code generated by smithy-go-codegen DO NOT EDIT.

package supplychain

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/supplychain/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Enables you to programmatically list all data pipelines for the provided Amazon
// Web Services Supply Chain instance.
func (c *Client) ListDataIntegrationFlows(ctx context.Context, params *ListDataIntegrationFlowsInput, optFns ...func(*Options)) (*ListDataIntegrationFlowsOutput, error) {
	if params == nil {
		params = &ListDataIntegrationFlowsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListDataIntegrationFlows", params, optFns, c.addOperationListDataIntegrationFlowsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListDataIntegrationFlowsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// The request parameters for ListDataIntegrationFlows.
type ListDataIntegrationFlowsInput struct {

	// The Amazon Web Services Supply Chain instance identifier.
	//
	// This member is required.
	InstanceId *string

	// Specify the maximum number of DataIntegrationFlows to fetch in one paginated
	// request.
	MaxResults *int32

	// The pagination token to fetch the next page of the DataIntegrationFlows.
	NextToken *string

	noSmithyDocumentSerde
}

// The response parameters for ListDataIntegrationFlows.
type ListDataIntegrationFlowsOutput struct {

	// The response parameters for ListDataIntegrationFlows.
	//
	// This member is required.
	Flows []types.DataIntegrationFlow

	// The pagination token to fetch the next page of the DataIntegrationFlows.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListDataIntegrationFlowsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListDataIntegrationFlows{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListDataIntegrationFlows{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListDataIntegrationFlows"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListDataIntegrationFlowsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListDataIntegrationFlows(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListDataIntegrationFlowsPaginatorOptions is the paginator options for
// ListDataIntegrationFlows
type ListDataIntegrationFlowsPaginatorOptions struct {
	// Specify the maximum number of DataIntegrationFlows to fetch in one paginated
	// request.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListDataIntegrationFlowsPaginator is a paginator for ListDataIntegrationFlows
type ListDataIntegrationFlowsPaginator struct {
	options   ListDataIntegrationFlowsPaginatorOptions
	client    ListDataIntegrationFlowsAPIClient
	params    *ListDataIntegrationFlowsInput
	nextToken *string
	firstPage bool
}

// NewListDataIntegrationFlowsPaginator returns a new
// ListDataIntegrationFlowsPaginator
func NewListDataIntegrationFlowsPaginator(client ListDataIntegrationFlowsAPIClient, params *ListDataIntegrationFlowsInput, optFns ...func(*ListDataIntegrationFlowsPaginatorOptions)) *ListDataIntegrationFlowsPaginator {
	if params == nil {
		params = &ListDataIntegrationFlowsInput{}
	}

	options := ListDataIntegrationFlowsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListDataIntegrationFlowsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListDataIntegrationFlowsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListDataIntegrationFlows page.
func (p *ListDataIntegrationFlowsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListDataIntegrationFlowsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListDataIntegrationFlows(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListDataIntegrationFlowsAPIClient is a client that implements the
// ListDataIntegrationFlows operation.
type ListDataIntegrationFlowsAPIClient interface {
	ListDataIntegrationFlows(context.Context, *ListDataIntegrationFlowsInput, ...func(*Options)) (*ListDataIntegrationFlowsOutput, error)
}

var _ ListDataIntegrationFlowsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListDataIntegrationFlows(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListDataIntegrationFlows",
	}
}
