// Code generated by smithy-go-codegen DO NOT EDIT.

package supplychain

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/supplychain/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// List flow executions.
func (c *Client) ListDataIntegrationFlowExecutions(ctx context.Context, params *ListDataIntegrationFlowExecutionsInput, optFns ...func(*Options)) (*ListDataIntegrationFlowExecutionsOutput, error) {
	if params == nil {
		params = &ListDataIntegrationFlowExecutionsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListDataIntegrationFlowExecutions", params, optFns, c.addOperationListDataIntegrationFlowExecutionsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListDataIntegrationFlowExecutionsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// The request parameters of ListFlowExecutions.
type ListDataIntegrationFlowExecutionsInput struct {

	// The flow name.
	//
	// This member is required.
	FlowName *string

	// The AWS Supply Chain instance identifier.
	//
	// This member is required.
	InstanceId *string

	// The number to specify the max number of flow executions to fetch in this
	// paginated request.
	MaxResults *int32

	// The pagination token to fetch next page of flow executions.
	NextToken *string

	noSmithyDocumentSerde
}

// The response parameters of ListFlowExecutions.
type ListDataIntegrationFlowExecutionsOutput struct {

	// The list of flow executions.
	//
	// This member is required.
	FlowExecutions []types.DataIntegrationFlowExecution

	// The pagination token to fetch next page of flow executions.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListDataIntegrationFlowExecutionsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListDataIntegrationFlowExecutions{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListDataIntegrationFlowExecutions{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListDataIntegrationFlowExecutions"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListDataIntegrationFlowExecutionsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListDataIntegrationFlowExecutions(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListDataIntegrationFlowExecutionsPaginatorOptions is the paginator options for
// ListDataIntegrationFlowExecutions
type ListDataIntegrationFlowExecutionsPaginatorOptions struct {
	// The number to specify the max number of flow executions to fetch in this
	// paginated request.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListDataIntegrationFlowExecutionsPaginator is a paginator for
// ListDataIntegrationFlowExecutions
type ListDataIntegrationFlowExecutionsPaginator struct {
	options   ListDataIntegrationFlowExecutionsPaginatorOptions
	client    ListDataIntegrationFlowExecutionsAPIClient
	params    *ListDataIntegrationFlowExecutionsInput
	nextToken *string
	firstPage bool
}

// NewListDataIntegrationFlowExecutionsPaginator returns a new
// ListDataIntegrationFlowExecutionsPaginator
func NewListDataIntegrationFlowExecutionsPaginator(client ListDataIntegrationFlowExecutionsAPIClient, params *ListDataIntegrationFlowExecutionsInput, optFns ...func(*ListDataIntegrationFlowExecutionsPaginatorOptions)) *ListDataIntegrationFlowExecutionsPaginator {
	if params == nil {
		params = &ListDataIntegrationFlowExecutionsInput{}
	}

	options := ListDataIntegrationFlowExecutionsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListDataIntegrationFlowExecutionsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListDataIntegrationFlowExecutionsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListDataIntegrationFlowExecutions page.
func (p *ListDataIntegrationFlowExecutionsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListDataIntegrationFlowExecutionsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListDataIntegrationFlowExecutions(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListDataIntegrationFlowExecutionsAPIClient is a client that implements the
// ListDataIntegrationFlowExecutions operation.
type ListDataIntegrationFlowExecutionsAPIClient interface {
	ListDataIntegrationFlowExecutions(context.Context, *ListDataIntegrationFlowExecutionsInput, ...func(*Options)) (*ListDataIntegrationFlowExecutionsOutput, error)
}

var _ ListDataIntegrationFlowExecutionsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListDataIntegrationFlowExecutions(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListDataIntegrationFlowExecutions",
	}
}
