// Code generated by smithy-go-codegen DO NOT EDIT.

package ssoadmin

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/ssoadmin/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists the status of the Amazon Web Services account assignment deletion
// requests for a specified IAM Identity Center instance.
func (c *Client) ListAccountAssignmentDeletionStatus(ctx context.Context, params *ListAccountAssignmentDeletionStatusInput, optFns ...func(*Options)) (*ListAccountAssignmentDeletionStatusOutput, error) {
	if params == nil {
		params = &ListAccountAssignmentDeletionStatusInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListAccountAssignmentDeletionStatus", params, optFns, c.addOperationListAccountAssignmentDeletionStatusMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListAccountAssignmentDeletionStatusOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListAccountAssignmentDeletionStatusInput struct {

	// The ARN of the IAM Identity Center instance under which the operation will be
	// executed. For more information about ARNs, see Amazon Resource Names (ARNs) and Amazon Web Services Service Namespacesin the Amazon Web Services
	// General Reference.
	//
	// This member is required.
	InstanceArn *string

	// Filters results based on the passed attribute value.
	Filter *types.OperationStatusFilter

	// The maximum number of results to display for the assignment.
	MaxResults *int32

	// The pagination token for the list API. Initially the value is null. Use the
	// output of previous API calls to make subsequent calls.
	NextToken *string

	noSmithyDocumentSerde
}

type ListAccountAssignmentDeletionStatusOutput struct {

	// The status object for the account assignment deletion operation.
	AccountAssignmentsDeletionStatus []types.AccountAssignmentOperationStatusMetadata

	// The pagination token for the list API. Initially the value is null. Use the
	// output of previous API calls to make subsequent calls.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListAccountAssignmentDeletionStatusMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListAccountAssignmentDeletionStatus{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListAccountAssignmentDeletionStatus{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListAccountAssignmentDeletionStatus"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListAccountAssignmentDeletionStatusValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListAccountAssignmentDeletionStatus(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListAccountAssignmentDeletionStatusPaginatorOptions is the paginator options
// for ListAccountAssignmentDeletionStatus
type ListAccountAssignmentDeletionStatusPaginatorOptions struct {
	// The maximum number of results to display for the assignment.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListAccountAssignmentDeletionStatusPaginator is a paginator for
// ListAccountAssignmentDeletionStatus
type ListAccountAssignmentDeletionStatusPaginator struct {
	options   ListAccountAssignmentDeletionStatusPaginatorOptions
	client    ListAccountAssignmentDeletionStatusAPIClient
	params    *ListAccountAssignmentDeletionStatusInput
	nextToken *string
	firstPage bool
}

// NewListAccountAssignmentDeletionStatusPaginator returns a new
// ListAccountAssignmentDeletionStatusPaginator
func NewListAccountAssignmentDeletionStatusPaginator(client ListAccountAssignmentDeletionStatusAPIClient, params *ListAccountAssignmentDeletionStatusInput, optFns ...func(*ListAccountAssignmentDeletionStatusPaginatorOptions)) *ListAccountAssignmentDeletionStatusPaginator {
	if params == nil {
		params = &ListAccountAssignmentDeletionStatusInput{}
	}

	options := ListAccountAssignmentDeletionStatusPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListAccountAssignmentDeletionStatusPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListAccountAssignmentDeletionStatusPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListAccountAssignmentDeletionStatus page.
func (p *ListAccountAssignmentDeletionStatusPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListAccountAssignmentDeletionStatusOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListAccountAssignmentDeletionStatus(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListAccountAssignmentDeletionStatusAPIClient is a client that implements the
// ListAccountAssignmentDeletionStatus operation.
type ListAccountAssignmentDeletionStatusAPIClient interface {
	ListAccountAssignmentDeletionStatus(context.Context, *ListAccountAssignmentDeletionStatusInput, ...func(*Options)) (*ListAccountAssignmentDeletionStatusOutput, error)
}

var _ ListAccountAssignmentDeletionStatusAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListAccountAssignmentDeletionStatus(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListAccountAssignmentDeletionStatus",
	}
}
