// Code generated by smithy-go-codegen DO NOT EDIT.

package sfn

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/sfn/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Validates the syntax of a state machine definition specified in [Amazon States Language] (ASL), a
// JSON-based, structured language.
//
// You can validate that a state machine definition is correct without creating a
// state machine resource.
//
// Suggested uses for ValidateStateMachineDefinition :
//
//   - Integrate automated checks into your code review or Continuous Integration
//     (CI) process to check state machine definitions before starting deployments.
//
//   - Run validation from a Git pre-commit hook to verify the definition before
//     committing to your source repository.
//
// Validation will look for problems in your state machine definition and return a
// result and a list of diagnostic elements.
//
// The result value will be OK when your workflow definition can be successfully
// created or updated. Note the result can be OK even when diagnostic warnings are
// present in the response. The result value will be FAIL when the workflow
// definition contains errors that would prevent you from creating or updating your
// state machine.
//
// The list of [ValidateStateMachineDefinitionDiagnostic] data elements can contain zero or more WARNING and/or ERROR
// elements.
//
// The ValidateStateMachineDefinition API might add new diagnostics in the future,
// adjust diagnostic codes, or change the message wording. Your automated processes
// should only rely on the value of the result field value (OK, FAIL). Do not rely
// on the exact order, count, or wording of diagnostic messages.
//
// [Amazon States Language]: https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html
// [ValidateStateMachineDefinitionDiagnostic]: https://docs.aws.amazon.com/step-functions/latest/apireference/API_ValidateStateMachineDefinitionDiagnostic.html
func (c *Client) ValidateStateMachineDefinition(ctx context.Context, params *ValidateStateMachineDefinitionInput, optFns ...func(*Options)) (*ValidateStateMachineDefinitionOutput, error) {
	if params == nil {
		params = &ValidateStateMachineDefinitionInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ValidateStateMachineDefinition", params, optFns, c.addOperationValidateStateMachineDefinitionMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ValidateStateMachineDefinitionOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ValidateStateMachineDefinitionInput struct {

	// The Amazon States Language definition of the state machine. For more
	// information, see [Amazon States Language](ASL).
	//
	// [Amazon States Language]: https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html
	//
	// This member is required.
	Definition *string

	// The maximum number of diagnostics that are returned per call. The default and
	// maximum value is 100. Setting the value to 0 will also use the default of 100.
	//
	// If the number of diagnostics returned in the response exceeds maxResults , the
	// value of the truncated field in the response will be set to true .
	MaxResults int32

	// Minimum level of diagnostics to return. ERROR returns only ERROR diagnostics,
	// whereas WARNING returns both WARNING and ERROR diagnostics. The default is ERROR
	// .
	Severity types.ValidateStateMachineDefinitionSeverity

	// The target type of state machine for this definition. The default is STANDARD .
	Type types.StateMachineType

	noSmithyDocumentSerde
}

type ValidateStateMachineDefinitionOutput struct {

	// An array of diagnostic errors and warnings found during validation of the state
	// machine definition. Since warnings do not prevent deploying your workflow
	// definition, the result value could be OK even when warning diagnostics are
	// present in the response.
	//
	// This member is required.
	Diagnostics []types.ValidateStateMachineDefinitionDiagnostic

	// The result value will be OK when no syntax errors are found, or FAIL if the
	// workflow definition does not pass verification.
	//
	// This member is required.
	Result types.ValidateStateMachineDefinitionResultCode

	// The result value will be true if the number of diagnostics found in the
	// workflow definition exceeds maxResults . When all diagnostics results are
	// returned, the value will be false .
	Truncated *bool

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationValidateStateMachineDefinitionMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpValidateStateMachineDefinition{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpValidateStateMachineDefinition{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ValidateStateMachineDefinition"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpValidateStateMachineDefinitionValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opValidateStateMachineDefinition(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opValidateStateMachineDefinition(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ValidateStateMachineDefinition",
	}
}
