// Code generated by smithy-go-codegen DO NOT EDIT.

package securityir

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Grants permission to upload an attachment to a case.
func (c *Client) GetCaseAttachmentUploadUrl(ctx context.Context, params *GetCaseAttachmentUploadUrlInput, optFns ...func(*Options)) (*GetCaseAttachmentUploadUrlOutput, error) {
	if params == nil {
		params = &GetCaseAttachmentUploadUrlInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetCaseAttachmentUploadUrl", params, optFns, c.addOperationGetCaseAttachmentUploadUrlMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetCaseAttachmentUploadUrlOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetCaseAttachmentUploadUrlInput struct {

	// Required element for GetCaseAttachmentUploadUrl to identify the case ID for
	// uploading an attachment to.
	//
	// This member is required.
	CaseId *string

	// Required element for GetCaseAttachmentUploadUrl to identify the size od the
	// file attachment.
	//
	// This member is required.
	ContentLength *int64

	// Required element for GetCaseAttachmentUploadUrl to identify the file name of
	// the attachment to upload.
	//
	// This member is required.
	FileName *string

	// Optional element for customer provided token.
	ClientToken *string

	noSmithyDocumentSerde
}

type GetCaseAttachmentUploadUrlOutput struct {

	// Response element providing the Amazon S3 presigned UTL to upload the attachment.
	//
	// This member is required.
	AttachmentPresignedUrl *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetCaseAttachmentUploadUrlMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetCaseAttachmentUploadUrl{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetCaseAttachmentUploadUrl{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetCaseAttachmentUploadUrl"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opGetCaseAttachmentUploadUrlMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpGetCaseAttachmentUploadUrlValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetCaseAttachmentUploadUrl(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpGetCaseAttachmentUploadUrl struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpGetCaseAttachmentUploadUrl) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpGetCaseAttachmentUploadUrl) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*GetCaseAttachmentUploadUrlInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *GetCaseAttachmentUploadUrlInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opGetCaseAttachmentUploadUrlMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpGetCaseAttachmentUploadUrl{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opGetCaseAttachmentUploadUrl(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetCaseAttachmentUploadUrl",
	}
}
