// Code generated by smithy-go-codegen DO NOT EDIT.

package sagemaker

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/sagemaker/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Updates the platform software of a SageMaker HyperPod cluster for security
// patching. To learn how to use this API, see [Update the SageMaker HyperPod platform software of a cluster].
//
// The UpgradeClusterSoftware API call may impact your SageMaker HyperPod cluster
// uptime and availability. Plan accordingly to mitigate potential disruptions to
// your workloads.
//
// [Update the SageMaker HyperPod platform software of a cluster]: https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-hyperpod-operate.html#sagemaker-hyperpod-operate-cli-command-update-cluster-software
func (c *Client) UpdateClusterSoftware(ctx context.Context, params *UpdateClusterSoftwareInput, optFns ...func(*Options)) (*UpdateClusterSoftwareOutput, error) {
	if params == nil {
		params = &UpdateClusterSoftwareInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateClusterSoftware", params, optFns, c.addOperationUpdateClusterSoftwareMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateClusterSoftwareOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateClusterSoftwareInput struct {

	// Specify the name or the Amazon Resource Name (ARN) of the SageMaker HyperPod
	// cluster you want to update for security patching.
	//
	// This member is required.
	ClusterName *string

	// The configuration to use when updating the AMI versions.
	DeploymentConfig *types.DeploymentConfiguration

	// The array of instance groups for which to update AMI versions.
	InstanceGroups []types.UpdateClusterSoftwareInstanceGroupSpecification

	noSmithyDocumentSerde
}

type UpdateClusterSoftwareOutput struct {

	// The Amazon Resource Name (ARN) of the SageMaker HyperPod cluster being updated
	// for security patching.
	//
	// This member is required.
	ClusterArn *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateClusterSoftwareMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpUpdateClusterSoftware{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpUpdateClusterSoftware{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateClusterSoftware"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateClusterSoftwareValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateClusterSoftware(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateClusterSoftware(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateClusterSoftware",
	}
}
