// Code generated by smithy-go-codegen DO NOT EDIT.

package s3control

import (
	"context"
	"errors"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/aws"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	internalConfig "github.com/aws/aws-sdk-go-v2/internal/configsources"
	"github.com/aws/aws-sdk-go-v2/internal/endpoints"
	"github.com/aws/aws-sdk-go-v2/internal/endpoints/awsrulesfn"
	internalendpoints "github.com/aws/aws-sdk-go-v2/service/s3control/internal/endpoints"
	smithy "github.com/aws/smithy-go"
	smithyauth "github.com/aws/smithy-go/auth"
	smithyendpoints "github.com/aws/smithy-go/endpoints"
	"github.com/aws/smithy-go/endpoints/private/rulesfn"
	"github.com/aws/smithy-go/middleware"
	"github.com/aws/smithy-go/ptr"
	"github.com/aws/smithy-go/tracing"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"net/http"
	"net/url"
	"os"
	"strings"
)

// EndpointResolverOptions is the service endpoint resolver options
type EndpointResolverOptions = internalendpoints.Options

// EndpointResolver interface for resolving service endpoints.
type EndpointResolver interface {
	ResolveEndpoint(region string, options EndpointResolverOptions) (aws.Endpoint, error)
}

var _ EndpointResolver = &internalendpoints.Resolver{}

// NewDefaultEndpointResolver constructs a new service endpoint resolver
func NewDefaultEndpointResolver() *internalendpoints.Resolver {
	return internalendpoints.New()
}

// EndpointResolverFunc is a helper utility that wraps a function so it satisfies
// the EndpointResolver interface. This is useful when you want to add additional
// endpoint resolving logic, or stub out specific endpoints with custom values.
type EndpointResolverFunc func(region string, options EndpointResolverOptions) (aws.Endpoint, error)

func (fn EndpointResolverFunc) ResolveEndpoint(region string, options EndpointResolverOptions) (endpoint aws.Endpoint, err error) {
	return fn(region, options)
}

// EndpointResolverFromURL returns an EndpointResolver configured using the
// provided endpoint url. By default, the resolved endpoint resolver uses the
// client region as signing region, and the endpoint source is set to
// EndpointSourceCustom.You can provide functional options to configure endpoint
// values for the resolved endpoint.
func EndpointResolverFromURL(url string, optFns ...func(*aws.Endpoint)) EndpointResolver {
	e := aws.Endpoint{URL: url, Source: aws.EndpointSourceCustom}
	for _, fn := range optFns {
		fn(&e)
	}

	return EndpointResolverFunc(
		func(region string, options EndpointResolverOptions) (aws.Endpoint, error) {
			if len(e.SigningRegion) == 0 {
				e.SigningRegion = region
			}
			return e, nil
		},
	)
}

type ResolveEndpoint struct {
	Resolver EndpointResolver
	Options  EndpointResolverOptions
}

func (*ResolveEndpoint) ID() string {
	return "ResolveEndpoint"
}

func (m *ResolveEndpoint) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	if !awsmiddleware.GetRequiresLegacyEndpoints(ctx) {
		return next.HandleSerialize(ctx, in)
	}

	req, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, fmt.Errorf("unknown transport type %T", in.Request)
	}

	if m.Resolver == nil {
		return out, metadata, fmt.Errorf("expected endpoint resolver to not be nil")
	}

	eo := m.Options
	eo.Logger = middleware.GetLogger(ctx)

	var endpoint aws.Endpoint
	endpoint, err = m.Resolver.ResolveEndpoint(awsmiddleware.GetRegion(ctx), eo)
	if err != nil {
		nf := (&aws.EndpointNotFoundError{})
		if errors.As(err, &nf) {
			ctx = awsmiddleware.SetRequiresLegacyEndpoints(ctx, false)
			return next.HandleSerialize(ctx, in)
		}
		return out, metadata, fmt.Errorf("failed to resolve service endpoint, %w", err)
	}

	req.URL, err = url.Parse(endpoint.URL)
	if err != nil {
		return out, metadata, fmt.Errorf("failed to parse endpoint URL: %w", err)
	}

	if len(awsmiddleware.GetSigningName(ctx)) == 0 {
		signingName := endpoint.SigningName
		if len(signingName) == 0 {
			signingName = "s3"
		}
		ctx = awsmiddleware.SetSigningName(ctx, signingName)
	}
	ctx = awsmiddleware.SetEndpointSource(ctx, endpoint.Source)
	ctx = smithyhttp.SetHostnameImmutable(ctx, endpoint.HostnameImmutable)
	ctx = awsmiddleware.SetSigningRegion(ctx, endpoint.SigningRegion)
	ctx = awsmiddleware.SetPartitionID(ctx, endpoint.PartitionID)
	return next.HandleSerialize(ctx, in)
}
func addResolveEndpointMiddleware(stack *middleware.Stack, o Options) error {
	return stack.Serialize.Insert(&ResolveEndpoint{
		Resolver: o.EndpointResolver,
		Options:  o.EndpointOptions,
	}, "OperationSerializer", middleware.Before)
}

func removeResolveEndpointMiddleware(stack *middleware.Stack) error {
	_, err := stack.Serialize.Remove((&ResolveEndpoint{}).ID())
	return err
}

type wrappedEndpointResolver struct {
	awsResolver aws.EndpointResolverWithOptions
}

func (w *wrappedEndpointResolver) ResolveEndpoint(region string, options EndpointResolverOptions) (endpoint aws.Endpoint, err error) {
	return w.awsResolver.ResolveEndpoint(ServiceID, region, options)
}

type awsEndpointResolverAdaptor func(service, region string) (aws.Endpoint, error)

func (a awsEndpointResolverAdaptor) ResolveEndpoint(service, region string, options ...interface{}) (aws.Endpoint, error) {
	return a(service, region)
}

var _ aws.EndpointResolverWithOptions = awsEndpointResolverAdaptor(nil)

// withEndpointResolver returns an aws.EndpointResolverWithOptions that first delegates endpoint resolution to the awsResolver.
// If awsResolver returns aws.EndpointNotFoundError error, the v1 resolver middleware will swallow the error,
// and set an appropriate context flag such that fallback will occur when EndpointResolverV2 is invoked
// via its middleware.
//
// If another error (besides aws.EndpointNotFoundError) is returned, then that error will be propagated.
func withEndpointResolver(awsResolver aws.EndpointResolver, awsResolverWithOptions aws.EndpointResolverWithOptions) EndpointResolver {
	var resolver aws.EndpointResolverWithOptions

	if awsResolverWithOptions != nil {
		resolver = awsResolverWithOptions
	} else if awsResolver != nil {
		resolver = awsEndpointResolverAdaptor(awsResolver.ResolveEndpoint)
	}

	return &wrappedEndpointResolver{
		awsResolver: resolver,
	}
}

func finalizeClientEndpointResolverOptions(options *Options) {
	options.EndpointOptions.LogDeprecated = options.ClientLogMode.IsDeprecatedUsage()

	if len(options.EndpointOptions.ResolvedRegion) == 0 {
		const fipsInfix = "-fips-"
		const fipsPrefix = "fips-"
		const fipsSuffix = "-fips"

		if strings.Contains(options.Region, fipsInfix) ||
			strings.Contains(options.Region, fipsPrefix) ||
			strings.Contains(options.Region, fipsSuffix) {
			options.EndpointOptions.ResolvedRegion = strings.ReplaceAll(strings.ReplaceAll(strings.ReplaceAll(
				options.Region, fipsInfix, "-"), fipsPrefix, ""), fipsSuffix, "")
			options.EndpointOptions.UseFIPSEndpoint = aws.FIPSEndpointStateEnabled
		}
	}

	if options.EndpointOptions.UseDualStackEndpoint == aws.DualStackEndpointStateUnset {
		if options.UseDualstack {
			options.EndpointOptions.UseDualStackEndpoint = aws.DualStackEndpointStateEnabled
		} else {
			options.EndpointOptions.UseDualStackEndpoint = aws.DualStackEndpointStateDisabled
		}
	}

}

func resolveEndpointResolverV2(options *Options) {
	if options.EndpointResolverV2 == nil {
		options.EndpointResolverV2 = NewDefaultEndpointResolverV2()
	}
}

func resolveBaseEndpoint(cfg aws.Config, o *Options) {
	if cfg.BaseEndpoint != nil {
		o.BaseEndpoint = cfg.BaseEndpoint
	}

	_, g := os.LookupEnv("AWS_ENDPOINT_URL")
	_, s := os.LookupEnv("AWS_ENDPOINT_URL_S3_CONTROL")

	if g && !s {
		return
	}

	value, found, err := internalConfig.ResolveServiceBaseEndpoint(context.Background(), "S3 Control", cfg.ConfigSources)
	if found && err == nil {
		o.BaseEndpoint = &value
	}
}

func bindRegion(region string) *string {
	if region == "" {
		return nil
	}
	return aws.String(endpoints.MapFIPSRegion(region))
}

// EndpointParameters provides the parameters that influence how endpoints are
// resolved.
type EndpointParameters struct {
	// The AWS region used to dispatch the request.
	//
	// Parameter is
	// required.
	//
	// AWS::Region
	Region *string

	// When true, send this request to the FIPS-compliant regional endpoint. If the
	// configured endpoint does not have a FIPS compliant endpoint, dispatching the
	// request will return an error.
	//
	// Defaults to false if no value is
	// provided.
	//
	// AWS::UseFIPS
	UseFIPS *bool

	// When true, use the dual-stack endpoint. If the configured endpoint does not
	// support dual-stack, dispatching the request MAY return an error.
	//
	// Defaults to
	// false if no value is provided.
	//
	// AWS::UseDualStack
	UseDualStack *bool

	// Override the endpoint used to send this request
	//
	// Parameter is
	// required.
	//
	// SDK::Endpoint
	Endpoint *string

	// The Account ID used to send the request. This is an optional parameter that will
	// be set automatically for operations that require it.
	//
	// Parameter is required.
	AccountId *string

	// Internal parameter for operations that require account id host
	// prefix.
	//
	// Parameter is required.
	RequiresAccountId *bool

	// The Outpost ID.  Some operations have an optional OutpostId which should be used
	// in endpoint construction.
	//
	// Parameter is required.
	OutpostId *string

	// The S3 bucket used to send the request. This is an optional parameter that will
	// be set automatically for operations that are scoped to an S3 bucket.
	//
	// Parameter
	// is required.
	Bucket *string

	// The S3 AccessPointName used to send the request. This is an optional parameter
	// that will be set automatically for operations that are scoped to an S3
	// AccessPoint.
	//
	// Parameter is required.
	AccessPointName *string

	// When an Access Point ARN is provided and this flag is enabled, the SDK MUST use
	// the ARN's region when constructing the endpoint instead of the client's
	// configured region.
	//
	// Parameter is required.
	//
	// AWS::S3Control::UseArnRegion
	UseArnRegion *bool

	// Internal parameter to indicate whether S3Express operation should use control
	// plane, (ex. ListDirectoryAccessPoints)
	//
	// Parameter is required.
	UseS3ExpressControlEndpoint *bool
}

// ValidateRequired validates required parameters are set.
func (p EndpointParameters) ValidateRequired() error {
	if p.UseDualStack == nil {
		return fmt.Errorf("parameter UseDualStack is required")
	}

	if p.UseFIPS == nil {
		return fmt.Errorf("parameter UseFIPS is required")
	}

	return nil
}

// WithDefaults returns a shallow copy of EndpointParameterswith default values
// applied to members where applicable.
func (p EndpointParameters) WithDefaults() EndpointParameters {
	if p.UseDualStack == nil {
		p.UseDualStack = ptr.Bool(false)
	}

	if p.UseFIPS == nil {
		p.UseFIPS = ptr.Bool(false)
	}
	return p
}

type stringSlice []string

func (s stringSlice) Get(i int) *string {
	if i < 0 || i >= len(s) {
		return nil
	}

	v := s[i]
	return &v
}

// EndpointResolverV2 provides the interface for resolving service endpoints.
type EndpointResolverV2 interface {
	// ResolveEndpoint attempts to resolve the endpoint with the provided options,
	// returning the endpoint if found. Otherwise an error is returned.
	ResolveEndpoint(ctx context.Context, params EndpointParameters) (
		smithyendpoints.Endpoint, error,
	)
}

// resolver provides the implementation for resolving endpoints.
type resolver struct{}

func NewDefaultEndpointResolverV2() EndpointResolverV2 {
	return &resolver{}
}

// ResolveEndpoint attempts to resolve the endpoint with the provided options,
// returning the endpoint if found. Otherwise an error is returned.
func (r *resolver) ResolveEndpoint(
	ctx context.Context, params EndpointParameters,
) (
	endpoint smithyendpoints.Endpoint, err error,
) {
	params = params.WithDefaults()
	if err = params.ValidateRequired(); err != nil {
		return endpoint, fmt.Errorf("endpoint parameters are not valid, %w", err)
	}
	_UseFIPS := *params.UseFIPS
	_UseDualStack := *params.UseDualStack

	if exprVal := params.Region; exprVal != nil {
		_Region := *exprVal
		_ = _Region
		if _UseFIPS == true {
			if exprVal := awsrulesfn.GetPartition(_Region); exprVal != nil {
				_partitionResult := *exprVal
				_ = _partitionResult
				if _partitionResult.Name == "aws-cn" {
					return endpoint, fmt.Errorf("endpoint rule error, %s", "Partition does not support FIPS")
				}
			}
		}
		if exprVal := params.OutpostId; exprVal != nil {
			_OutpostId := *exprVal
			_ = _OutpostId
			if exprVal := awsrulesfn.GetPartition(_Region); exprVal != nil {
				_partitionResult := *exprVal
				_ = _partitionResult
				if exprVal := params.RequiresAccountId; exprVal != nil {
					_RequiresAccountId := *exprVal
					_ = _RequiresAccountId
					if _RequiresAccountId == true {
						if !(params.AccountId != nil) {
							return endpoint, fmt.Errorf("endpoint rule error, %s", "AccountId is required but not set")
						}
					}
				}
				if exprVal := params.AccountId; exprVal != nil {
					_AccountId := *exprVal
					_ = _AccountId
					if !(rulesfn.IsValidHostLabel(_AccountId, false)) {
						return endpoint, fmt.Errorf("endpoint rule error, %s", "AccountId must only contain a-z, A-Z, 0-9 and `-`.")
					}
				}
				if !(rulesfn.IsValidHostLabel(_OutpostId, false)) {
					return endpoint, fmt.Errorf("endpoint rule error, %s", "OutpostId must only contain a-z, A-Z, 0-9 and `-`.")
				}
				if exprVal := params.Endpoint; exprVal != nil {
					_Endpoint := *exprVal
					_ = _Endpoint
					if _UseDualStack == true {
						return endpoint, fmt.Errorf("endpoint rule error, %s", "Invalid Configuration: DualStack and custom endpoint are not supported")
					}
				}
				if rulesfn.IsValidHostLabel(_Region, true) {
					if exprVal := params.Endpoint; exprVal != nil {
						_Endpoint := *exprVal
						_ = _Endpoint
						if exprVal := rulesfn.ParseURL(_Endpoint); exprVal != nil {
							_url := *exprVal
							_ = _url
							uriString := func() string {
								var out strings.Builder
								out.WriteString(_url.Scheme)
								out.WriteString("://")
								out.WriteString(_url.Authority)
								out.WriteString(_url.Path)
								return out.String()
							}()

							uri, err := url.Parse(uriString)
							if err != nil {
								return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
							}

							return smithyendpoints.Endpoint{
								URI:     *uri,
								Headers: http.Header{},
								Properties: func() smithy.Properties {
									var out smithy.Properties
									smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
										{
											SchemeID: "aws.auth#sigv4",
											SignerProperties: func() smithy.Properties {
												var sp smithy.Properties
												smithyhttp.SetDisableDoubleEncoding(&sp, true)

												smithyhttp.SetSigV4SigningName(&sp, "s3-outposts")
												smithyhttp.SetSigV4ASigningName(&sp, "s3-outposts")

												smithyhttp.SetSigV4SigningRegion(&sp, _Region)
												return sp
											}(),
										},
									})
									return out
								}(),
							}, nil
						}
					}
					if _UseFIPS == true {
						if _UseDualStack == true {
							uriString := func() string {
								var out strings.Builder
								out.WriteString("https://s3-outposts-fips.")
								out.WriteString(_Region)
								out.WriteString(".")
								out.WriteString(_partitionResult.DualStackDnsSuffix)
								return out.String()
							}()

							uri, err := url.Parse(uriString)
							if err != nil {
								return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
							}

							return smithyendpoints.Endpoint{
								URI:     *uri,
								Headers: http.Header{},
								Properties: func() smithy.Properties {
									var out smithy.Properties
									smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
										{
											SchemeID: "aws.auth#sigv4",
											SignerProperties: func() smithy.Properties {
												var sp smithy.Properties
												smithyhttp.SetDisableDoubleEncoding(&sp, true)

												smithyhttp.SetSigV4SigningName(&sp, "s3-outposts")
												smithyhttp.SetSigV4ASigningName(&sp, "s3-outposts")

												smithyhttp.SetSigV4SigningRegion(&sp, _Region)
												return sp
											}(),
										},
									})
									return out
								}(),
							}, nil
						}
					}
					if _UseFIPS == true {
						uriString := func() string {
							var out strings.Builder
							out.WriteString("https://s3-outposts-fips.")
							out.WriteString(_Region)
							out.WriteString(".")
							out.WriteString(_partitionResult.DnsSuffix)
							return out.String()
						}()

						uri, err := url.Parse(uriString)
						if err != nil {
							return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
						}

						return smithyendpoints.Endpoint{
							URI:     *uri,
							Headers: http.Header{},
							Properties: func() smithy.Properties {
								var out smithy.Properties
								smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
									{
										SchemeID: "aws.auth#sigv4",
										SignerProperties: func() smithy.Properties {
											var sp smithy.Properties
											smithyhttp.SetDisableDoubleEncoding(&sp, true)

											smithyhttp.SetSigV4SigningName(&sp, "s3-outposts")
											smithyhttp.SetSigV4ASigningName(&sp, "s3-outposts")

											smithyhttp.SetSigV4SigningRegion(&sp, _Region)
											return sp
										}(),
									},
								})
								return out
							}(),
						}, nil
					}
					if _UseDualStack == true {
						uriString := func() string {
							var out strings.Builder
							out.WriteString("https://s3-outposts.")
							out.WriteString(_Region)
							out.WriteString(".")
							out.WriteString(_partitionResult.DualStackDnsSuffix)
							return out.String()
						}()

						uri, err := url.Parse(uriString)
						if err != nil {
							return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
						}

						return smithyendpoints.Endpoint{
							URI:     *uri,
							Headers: http.Header{},
							Properties: func() smithy.Properties {
								var out smithy.Properties
								smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
									{
										SchemeID: "aws.auth#sigv4",
										SignerProperties: func() smithy.Properties {
											var sp smithy.Properties
											smithyhttp.SetDisableDoubleEncoding(&sp, true)

											smithyhttp.SetSigV4SigningName(&sp, "s3-outposts")
											smithyhttp.SetSigV4ASigningName(&sp, "s3-outposts")

											smithyhttp.SetSigV4SigningRegion(&sp, _Region)
											return sp
										}(),
									},
								})
								return out
							}(),
						}, nil
					}
					uriString := func() string {
						var out strings.Builder
						out.WriteString("https://s3-outposts.")
						out.WriteString(_Region)
						out.WriteString(".")
						out.WriteString(_partitionResult.DnsSuffix)
						return out.String()
					}()

					uri, err := url.Parse(uriString)
					if err != nil {
						return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
					}

					return smithyendpoints.Endpoint{
						URI:     *uri,
						Headers: http.Header{},
						Properties: func() smithy.Properties {
							var out smithy.Properties
							smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
								{
									SchemeID: "aws.auth#sigv4",
									SignerProperties: func() smithy.Properties {
										var sp smithy.Properties
										smithyhttp.SetDisableDoubleEncoding(&sp, true)

										smithyhttp.SetSigV4SigningName(&sp, "s3-outposts")
										smithyhttp.SetSigV4ASigningName(&sp, "s3-outposts")

										smithyhttp.SetSigV4SigningRegion(&sp, _Region)
										return sp
									}(),
								},
							})
							return out
						}(),
					}, nil
				}
				return endpoint, fmt.Errorf("endpoint rule error, %s", "Invalid region: region was not a valid DNS name.")
			}
			return endpoint, fmt.Errorf("Endpoint resolution failed. Invalid operation or environment input.")
		}
		if exprVal := params.AccessPointName; exprVal != nil {
			_AccessPointName := *exprVal
			_ = _AccessPointName
			if exprVal := rulesfn.SubString(_AccessPointName, 0, 7, true); exprVal != nil {
				_accessPointSuffix := *exprVal
				_ = _accessPointSuffix
				if _accessPointSuffix == "--xa-s3" {
					if exprVal := awsrulesfn.GetPartition(_Region); exprVal != nil {
						_partitionResult := *exprVal
						_ = _partitionResult
						if exprVal := params.Endpoint; exprVal != nil {
							_Endpoint := *exprVal
							_ = _Endpoint
							if _UseDualStack == true {
								return endpoint, fmt.Errorf("endpoint rule error, %s", "Invalid Configuration: DualStack and custom endpoint are not supported")
							}
						}
						if _UseDualStack == true {
							return endpoint, fmt.Errorf("endpoint rule error, %s", "S3Express does not support Dual-stack.")
						}
						if exprVal := params.Endpoint; exprVal != nil {
							_Endpoint := *exprVal
							_ = _Endpoint
							if exprVal := rulesfn.ParseURL(_Endpoint); exprVal != nil {
								_url := *exprVal
								_ = _url
								uriString := func() string {
									var out strings.Builder
									out.WriteString(_url.Scheme)
									out.WriteString("://")
									out.WriteString(_url.Authority)
									return out.String()
								}()

								uri, err := url.Parse(uriString)
								if err != nil {
									return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
								}

								return smithyendpoints.Endpoint{
									URI:     *uri,
									Headers: http.Header{},
									Properties: func() smithy.Properties {
										var out smithy.Properties
										smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
											{
												SchemeID: "aws.auth#sigv4",
												SignerProperties: func() smithy.Properties {
													var sp smithy.Properties
													smithyhttp.SetDisableDoubleEncoding(&sp, true)

													smithyhttp.SetSigV4SigningName(&sp, "s3express")
													smithyhttp.SetSigV4ASigningName(&sp, "s3express")

													smithyhttp.SetSigV4SigningRegion(&sp, _Region)
													return sp
												}(),
											},
										})
										return out
									}(),
								}, nil
							}
						}
						if exprVal := rulesfn.SubString(_AccessPointName, 7, 15, true); exprVal != nil {
							_s3expressAvailabilityZoneId := *exprVal
							_ = _s3expressAvailabilityZoneId
							if exprVal := rulesfn.SubString(_AccessPointName, 15, 17, true); exprVal != nil {
								_s3expressAvailabilityZoneDelim := *exprVal
								_ = _s3expressAvailabilityZoneDelim
								if _s3expressAvailabilityZoneDelim == "--" {
									if _UseFIPS == true {
										uriString := func() string {
											var out strings.Builder
											out.WriteString("https://s3express-control-fips.")
											out.WriteString(_Region)
											out.WriteString(".")
											out.WriteString(_partitionResult.DnsSuffix)
											return out.String()
										}()

										uri, err := url.Parse(uriString)
										if err != nil {
											return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
										}

										return smithyendpoints.Endpoint{
											URI:     *uri,
											Headers: http.Header{},
											Properties: func() smithy.Properties {
												var out smithy.Properties
												smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
													{
														SchemeID: "aws.auth#sigv4",
														SignerProperties: func() smithy.Properties {
															var sp smithy.Properties
															smithyhttp.SetDisableDoubleEncoding(&sp, true)

															smithyhttp.SetSigV4SigningName(&sp, "s3express")
															smithyhttp.SetSigV4ASigningName(&sp, "s3express")

															smithyhttp.SetSigV4SigningRegion(&sp, _Region)
															return sp
														}(),
													},
												})
												return out
											}(),
										}, nil
									}
									uriString := func() string {
										var out strings.Builder
										out.WriteString("https://s3express-control.")
										out.WriteString(_Region)
										out.WriteString(".")
										out.WriteString(_partitionResult.DnsSuffix)
										return out.String()
									}()

									uri, err := url.Parse(uriString)
									if err != nil {
										return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
									}

									return smithyendpoints.Endpoint{
										URI:     *uri,
										Headers: http.Header{},
										Properties: func() smithy.Properties {
											var out smithy.Properties
											smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
												{
													SchemeID: "aws.auth#sigv4",
													SignerProperties: func() smithy.Properties {
														var sp smithy.Properties
														smithyhttp.SetDisableDoubleEncoding(&sp, true)

														smithyhttp.SetSigV4SigningName(&sp, "s3express")
														smithyhttp.SetSigV4ASigningName(&sp, "s3express")

														smithyhttp.SetSigV4SigningRegion(&sp, _Region)
														return sp
													}(),
												},
											})
											return out
										}(),
									}, nil
								}
							}
						}
						if exprVal := rulesfn.SubString(_AccessPointName, 7, 16, true); exprVal != nil {
							_s3expressAvailabilityZoneId := *exprVal
							_ = _s3expressAvailabilityZoneId
							if exprVal := rulesfn.SubString(_AccessPointName, 16, 18, true); exprVal != nil {
								_s3expressAvailabilityZoneDelim := *exprVal
								_ = _s3expressAvailabilityZoneDelim
								if _s3expressAvailabilityZoneDelim == "--" {
									if _UseFIPS == true {
										uriString := func() string {
											var out strings.Builder
											out.WriteString("https://s3express-control-fips.")
											out.WriteString(_Region)
											out.WriteString(".")
											out.WriteString(_partitionResult.DnsSuffix)
											return out.String()
										}()

										uri, err := url.Parse(uriString)
										if err != nil {
											return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
										}

										return smithyendpoints.Endpoint{
											URI:     *uri,
											Headers: http.Header{},
											Properties: func() smithy.Properties {
												var out smithy.Properties
												smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
													{
														SchemeID: "aws.auth#sigv4",
														SignerProperties: func() smithy.Properties {
															var sp smithy.Properties
															smithyhttp.SetDisableDoubleEncoding(&sp, true)

															smithyhttp.SetSigV4SigningName(&sp, "s3express")
															smithyhttp.SetSigV4ASigningName(&sp, "s3express")

															smithyhttp.SetSigV4SigningRegion(&sp, _Region)
															return sp
														}(),
													},
												})
												return out
											}(),
										}, nil
									}
									uriString := func() string {
										var out strings.Builder
										out.WriteString("https://s3express-control.")
										out.WriteString(_Region)
										out.WriteString(".")
										out.WriteString(_partitionResult.DnsSuffix)
										return out.String()
									}()

									uri, err := url.Parse(uriString)
									if err != nil {
										return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
									}

									return smithyendpoints.Endpoint{
										URI:     *uri,
										Headers: http.Header{},
										Properties: func() smithy.Properties {
											var out smithy.Properties
											smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
												{
													SchemeID: "aws.auth#sigv4",
													SignerProperties: func() smithy.Properties {
														var sp smithy.Properties
														smithyhttp.SetDisableDoubleEncoding(&sp, true)

														smithyhttp.SetSigV4SigningName(&sp, "s3express")
														smithyhttp.SetSigV4ASigningName(&sp, "s3express")

														smithyhttp.SetSigV4SigningRegion(&sp, _Region)
														return sp
													}(),
												},
											})
											return out
										}(),
									}, nil
								}
							}
						}
						if exprVal := rulesfn.SubString(_AccessPointName, 7, 20, true); exprVal != nil {
							_s3expressAvailabilityZoneId := *exprVal
							_ = _s3expressAvailabilityZoneId
							if exprVal := rulesfn.SubString(_AccessPointName, 20, 22, true); exprVal != nil {
								_s3expressAvailabilityZoneDelim := *exprVal
								_ = _s3expressAvailabilityZoneDelim
								if _s3expressAvailabilityZoneDelim == "--" {
									if _UseFIPS == true {
										uriString := func() string {
											var out strings.Builder
											out.WriteString("https://s3express-control-fips.")
											out.WriteString(_Region)
											out.WriteString(".")
											out.WriteString(_partitionResult.DnsSuffix)
											return out.String()
										}()

										uri, err := url.Parse(uriString)
										if err != nil {
											return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
										}

										return smithyendpoints.Endpoint{
											URI:     *uri,
											Headers: http.Header{},
											Properties: func() smithy.Properties {
												var out smithy.Properties
												smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
													{
														SchemeID: "aws.auth#sigv4",
														SignerProperties: func() smithy.Properties {
															var sp smithy.Properties
															smithyhttp.SetDisableDoubleEncoding(&sp, true)

															smithyhttp.SetSigV4SigningName(&sp, "s3express")
															smithyhttp.SetSigV4ASigningName(&sp, "s3express")

															smithyhttp.SetSigV4SigningRegion(&sp, _Region)
															return sp
														}(),
													},
												})
												return out
											}(),
										}, nil
									}
									uriString := func() string {
										var out strings.Builder
										out.WriteString("https://s3express-control.")
										out.WriteString(_Region)
										out.WriteString(".")
										out.WriteString(_partitionResult.DnsSuffix)
										return out.String()
									}()

									uri, err := url.Parse(uriString)
									if err != nil {
										return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
									}

									return smithyendpoints.Endpoint{
										URI:     *uri,
										Headers: http.Header{},
										Properties: func() smithy.Properties {
											var out smithy.Properties
											smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
												{
													SchemeID: "aws.auth#sigv4",
													SignerProperties: func() smithy.Properties {
														var sp smithy.Properties
														smithyhttp.SetDisableDoubleEncoding(&sp, true)

														smithyhttp.SetSigV4SigningName(&sp, "s3express")
														smithyhttp.SetSigV4ASigningName(&sp, "s3express")

														smithyhttp.SetSigV4SigningRegion(&sp, _Region)
														return sp
													}(),
												},
											})
											return out
										}(),
									}, nil
								}
							}
						}
						if exprVal := rulesfn.SubString(_AccessPointName, 7, 21, true); exprVal != nil {
							_s3expressAvailabilityZoneId := *exprVal
							_ = _s3expressAvailabilityZoneId
							if exprVal := rulesfn.SubString(_AccessPointName, 21, 23, true); exprVal != nil {
								_s3expressAvailabilityZoneDelim := *exprVal
								_ = _s3expressAvailabilityZoneDelim
								if _s3expressAvailabilityZoneDelim == "--" {
									if _UseFIPS == true {
										uriString := func() string {
											var out strings.Builder
											out.WriteString("https://s3express-control-fips.")
											out.WriteString(_Region)
											out.WriteString(".")
											out.WriteString(_partitionResult.DnsSuffix)
											return out.String()
										}()

										uri, err := url.Parse(uriString)
										if err != nil {
											return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
										}

										return smithyendpoints.Endpoint{
											URI:     *uri,
											Headers: http.Header{},
											Properties: func() smithy.Properties {
												var out smithy.Properties
												smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
													{
														SchemeID: "aws.auth#sigv4",
														SignerProperties: func() smithy.Properties {
															var sp smithy.Properties
															smithyhttp.SetDisableDoubleEncoding(&sp, true)

															smithyhttp.SetSigV4SigningName(&sp, "s3express")
															smithyhttp.SetSigV4ASigningName(&sp, "s3express")

															smithyhttp.SetSigV4SigningRegion(&sp, _Region)
															return sp
														}(),
													},
												})
												return out
											}(),
										}, nil
									}
									uriString := func() string {
										var out strings.Builder
										out.WriteString("https://s3express-control.")
										out.WriteString(_Region)
										out.WriteString(".")
										out.WriteString(_partitionResult.DnsSuffix)
										return out.String()
									}()

									uri, err := url.Parse(uriString)
									if err != nil {
										return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
									}

									return smithyendpoints.Endpoint{
										URI:     *uri,
										Headers: http.Header{},
										Properties: func() smithy.Properties {
											var out smithy.Properties
											smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
												{
													SchemeID: "aws.auth#sigv4",
													SignerProperties: func() smithy.Properties {
														var sp smithy.Properties
														smithyhttp.SetDisableDoubleEncoding(&sp, true)

														smithyhttp.SetSigV4SigningName(&sp, "s3express")
														smithyhttp.SetSigV4ASigningName(&sp, "s3express")

														smithyhttp.SetSigV4SigningRegion(&sp, _Region)
														return sp
													}(),
												},
											})
											return out
										}(),
									}, nil
								}
							}
						}
						if exprVal := rulesfn.SubString(_AccessPointName, 7, 27, true); exprVal != nil {
							_s3expressAvailabilityZoneId := *exprVal
							_ = _s3expressAvailabilityZoneId
							if exprVal := rulesfn.SubString(_AccessPointName, 27, 29, true); exprVal != nil {
								_s3expressAvailabilityZoneDelim := *exprVal
								_ = _s3expressAvailabilityZoneDelim
								if _s3expressAvailabilityZoneDelim == "--" {
									if _UseFIPS == true {
										uriString := func() string {
											var out strings.Builder
											out.WriteString("https://s3express-control-fips.")
											out.WriteString(_Region)
											out.WriteString(".")
											out.WriteString(_partitionResult.DnsSuffix)
											return out.String()
										}()

										uri, err := url.Parse(uriString)
										if err != nil {
											return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
										}

										return smithyendpoints.Endpoint{
											URI:     *uri,
											Headers: http.Header{},
											Properties: func() smithy.Properties {
												var out smithy.Properties
												smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
													{
														SchemeID: "aws.auth#sigv4",
														SignerProperties: func() smithy.Properties {
															var sp smithy.Properties
															smithyhttp.SetDisableDoubleEncoding(&sp, true)

															smithyhttp.SetSigV4SigningName(&sp, "s3express")
															smithyhttp.SetSigV4ASigningName(&sp, "s3express")

															smithyhttp.SetSigV4SigningRegion(&sp, _Region)
															return sp
														}(),
													},
												})
												return out
											}(),
										}, nil
									}
									uriString := func() string {
										var out strings.Builder
										out.WriteString("https://s3express-control.")
										out.WriteString(_Region)
										out.WriteString(".")
										out.WriteString(_partitionResult.DnsSuffix)
										return out.String()
									}()

									uri, err := url.Parse(uriString)
									if err != nil {
										return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
									}

									return smithyendpoints.Endpoint{
										URI:     *uri,
										Headers: http.Header{},
										Properties: func() smithy.Properties {
											var out smithy.Properties
											smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
												{
													SchemeID: "aws.auth#sigv4",
													SignerProperties: func() smithy.Properties {
														var sp smithy.Properties
														smithyhttp.SetDisableDoubleEncoding(&sp, true)

														smithyhttp.SetSigV4SigningName(&sp, "s3express")
														smithyhttp.SetSigV4ASigningName(&sp, "s3express")

														smithyhttp.SetSigV4SigningRegion(&sp, _Region)
														return sp
													}(),
												},
											})
											return out
										}(),
									}, nil
								}
							}
						}
						return endpoint, fmt.Errorf("endpoint rule error, %s", "Unrecognized S3Express Access Point name format.")
					}
					return endpoint, fmt.Errorf("Endpoint resolution failed. Invalid operation or environment input.")
				}
			}
		}
		if exprVal := params.UseS3ExpressControlEndpoint; exprVal != nil {
			_UseS3ExpressControlEndpoint := *exprVal
			_ = _UseS3ExpressControlEndpoint
			if _UseS3ExpressControlEndpoint == true {
				if exprVal := awsrulesfn.GetPartition(_Region); exprVal != nil {
					_partitionResult := *exprVal
					_ = _partitionResult
					if exprVal := params.Endpoint; exprVal != nil {
						_Endpoint := *exprVal
						_ = _Endpoint
						if _UseDualStack == true {
							return endpoint, fmt.Errorf("endpoint rule error, %s", "Invalid Configuration: DualStack and custom endpoint are not supported")
						}
					}
					if _UseDualStack == true {
						return endpoint, fmt.Errorf("endpoint rule error, %s", "S3Express does not support Dual-stack.")
					}
					if exprVal := params.Endpoint; exprVal != nil {
						_Endpoint := *exprVal
						_ = _Endpoint
						if exprVal := rulesfn.ParseURL(_Endpoint); exprVal != nil {
							_url := *exprVal
							_ = _url
							uriString := func() string {
								var out strings.Builder
								out.WriteString(_url.Scheme)
								out.WriteString("://")
								out.WriteString(_url.Authority)
								return out.String()
							}()

							uri, err := url.Parse(uriString)
							if err != nil {
								return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
							}

							return smithyendpoints.Endpoint{
								URI:     *uri,
								Headers: http.Header{},
								Properties: func() smithy.Properties {
									var out smithy.Properties
									smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
										{
											SchemeID: "aws.auth#sigv4",
											SignerProperties: func() smithy.Properties {
												var sp smithy.Properties
												smithyhttp.SetDisableDoubleEncoding(&sp, true)

												smithyhttp.SetSigV4SigningName(&sp, "s3express")
												smithyhttp.SetSigV4ASigningName(&sp, "s3express")

												smithyhttp.SetSigV4SigningRegion(&sp, _Region)
												return sp
											}(),
										},
									})
									return out
								}(),
							}, nil
						}
					}
					if _UseFIPS == true {
						uriString := func() string {
							var out strings.Builder
							out.WriteString("https://s3express-control-fips.")
							out.WriteString(_Region)
							out.WriteString(".")
							out.WriteString(_partitionResult.DnsSuffix)
							return out.String()
						}()

						uri, err := url.Parse(uriString)
						if err != nil {
							return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
						}

						return smithyendpoints.Endpoint{
							URI:     *uri,
							Headers: http.Header{},
							Properties: func() smithy.Properties {
								var out smithy.Properties
								smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
									{
										SchemeID: "aws.auth#sigv4",
										SignerProperties: func() smithy.Properties {
											var sp smithy.Properties
											smithyhttp.SetDisableDoubleEncoding(&sp, true)

											smithyhttp.SetSigV4SigningName(&sp, "s3express")
											smithyhttp.SetSigV4ASigningName(&sp, "s3express")

											smithyhttp.SetSigV4SigningRegion(&sp, _Region)
											return sp
										}(),
									},
								})
								return out
							}(),
						}, nil
					}
					uriString := func() string {
						var out strings.Builder
						out.WriteString("https://s3express-control.")
						out.WriteString(_Region)
						out.WriteString(".")
						out.WriteString(_partitionResult.DnsSuffix)
						return out.String()
					}()

					uri, err := url.Parse(uriString)
					if err != nil {
						return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
					}

					return smithyendpoints.Endpoint{
						URI:     *uri,
						Headers: http.Header{},
						Properties: func() smithy.Properties {
							var out smithy.Properties
							smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
								{
									SchemeID: "aws.auth#sigv4",
									SignerProperties: func() smithy.Properties {
										var sp smithy.Properties
										smithyhttp.SetDisableDoubleEncoding(&sp, true)

										smithyhttp.SetSigV4SigningName(&sp, "s3express")
										smithyhttp.SetSigV4ASigningName(&sp, "s3express")

										smithyhttp.SetSigV4SigningRegion(&sp, _Region)
										return sp
									}(),
								},
							})
							return out
						}(),
					}, nil
				}
				return endpoint, fmt.Errorf("Endpoint resolution failed. Invalid operation or environment input.")
			}
		}
		if _Region == "snow" {
			if exprVal := params.Endpoint; exprVal != nil {
				_Endpoint := *exprVal
				_ = _Endpoint
				if exprVal := rulesfn.ParseURL(_Endpoint); exprVal != nil {
					_url := *exprVal
					_ = _url
					if exprVal := awsrulesfn.GetPartition(_Region); exprVal != nil {
						_partitionResult := *exprVal
						_ = _partitionResult
						if _UseDualStack == true {
							return endpoint, fmt.Errorf("endpoint rule error, %s", "S3 Snow does not support DualStack")
						}
						if _UseFIPS == true {
							return endpoint, fmt.Errorf("endpoint rule error, %s", "S3 Snow does not support FIPS")
						}
						uriString := func() string {
							var out strings.Builder
							out.WriteString(_url.Scheme)
							out.WriteString("://")
							out.WriteString(_url.Authority)
							return out.String()
						}()

						uri, err := url.Parse(uriString)
						if err != nil {
							return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
						}

						return smithyendpoints.Endpoint{
							URI:     *uri,
							Headers: http.Header{},
							Properties: func() smithy.Properties {
								var out smithy.Properties
								smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
									{
										SchemeID: "aws.auth#sigv4",
										SignerProperties: func() smithy.Properties {
											var sp smithy.Properties
											smithyhttp.SetDisableDoubleEncoding(&sp, true)

											smithyhttp.SetSigV4SigningName(&sp, "s3")
											smithyhttp.SetSigV4ASigningName(&sp, "s3")

											smithyhttp.SetSigV4SigningRegion(&sp, _Region)
											return sp
										}(),
									},
								})
								return out
							}(),
						}, nil
					}
					return endpoint, fmt.Errorf("Endpoint resolution failed. Invalid operation or environment input.")
				}
			}
		}
		if exprVal := params.AccessPointName; exprVal != nil {
			_AccessPointName := *exprVal
			_ = _AccessPointName
			if exprVal := awsrulesfn.ParseARN(_AccessPointName); exprVal != nil {
				_accessPointArn := *exprVal
				_ = _accessPointArn
				if exprVal := _accessPointArn.ResourceId.Get(0); exprVal != nil {
					_arnType := *exprVal
					_ = _arnType
					if !(_arnType == "") {
						if _accessPointArn.Service == "s3-outposts" {
							if exprVal := _accessPointArn.ResourceId.Get(1); exprVal != nil {
								_outpostId := *exprVal
								_ = _outpostId
								if rulesfn.IsValidHostLabel(_outpostId, false) {
									if exprVal := params.Endpoint; exprVal != nil {
										_Endpoint := *exprVal
										_ = _Endpoint
										if _UseDualStack == true {
											return endpoint, fmt.Errorf("endpoint rule error, %s", "Invalid Configuration: DualStack and custom endpoint are not supported")
										}
									}
									if exprVal := params.UseArnRegion; exprVal != nil {
										_UseArnRegion := *exprVal
										_ = _UseArnRegion
										if _UseArnRegion == false {
											if !(_accessPointArn.Region == _Region) {
												return endpoint, fmt.Errorf("endpoint rule error, %s", func() string {
													var out strings.Builder
													out.WriteString("Invalid configuration: region from ARN `")
													out.WriteString(_accessPointArn.Region)
													out.WriteString("` does not match client region `")
													out.WriteString(_Region)
													out.WriteString("` and UseArnRegion is `false`")
													return out.String()
												}())
											}
										}
									}
									if exprVal := awsrulesfn.GetPartition(_Region); exprVal != nil {
										_partitionResult := *exprVal
										_ = _partitionResult
										if exprVal := awsrulesfn.GetPartition(_accessPointArn.Region); exprVal != nil {
											_arnPartition := *exprVal
											_ = _arnPartition
											if _arnPartition.Name == _partitionResult.Name {
												if rulesfn.IsValidHostLabel(_accessPointArn.Region, true) {
													if !(_accessPointArn.AccountId == "") {
														if rulesfn.IsValidHostLabel(_accessPointArn.AccountId, false) {
															if exprVal := params.AccountId; exprVal != nil {
																_AccountId := *exprVal
																_ = _AccountId
																if !(_AccountId == _accessPointArn.AccountId) {
																	return endpoint, fmt.Errorf("endpoint rule error, %s", func() string {
																		var out strings.Builder
																		out.WriteString("Invalid ARN: the accountId specified in the ARN (`")
																		out.WriteString(_accessPointArn.AccountId)
																		out.WriteString("`) does not match the parameter (`")
																		out.WriteString(_AccountId)
																		out.WriteString("`)")
																		return out.String()
																	}())
																}
															}
															if exprVal := _accessPointArn.ResourceId.Get(2); exprVal != nil {
																_outpostType := *exprVal
																_ = _outpostType
																if exprVal := _accessPointArn.ResourceId.Get(3); exprVal != nil {
																	_accessPointName := *exprVal
																	_ = _accessPointName
																	if _outpostType == "accesspoint" {
																		if _UseFIPS == true {
																			if _UseDualStack == true {
																				uriString := func() string {
																					var out strings.Builder
																					out.WriteString("https://s3-outposts-fips.")
																					out.WriteString(_accessPointArn.Region)
																					out.WriteString(".")
																					out.WriteString(_arnPartition.DualStackDnsSuffix)
																					return out.String()
																				}()

																				uri, err := url.Parse(uriString)
																				if err != nil {
																					return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
																				}

																				return smithyendpoints.Endpoint{
																					URI: *uri,
																					Headers: func() http.Header {
																						headers := http.Header{}
																						headers.Set("x-amz-account-id", _accessPointArn.AccountId)
																						headers.Set("x-amz-outpost-id", _outpostId)
																						return headers
																					}(),
																					Properties: func() smithy.Properties {
																						var out smithy.Properties
																						smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
																							{
																								SchemeID: "aws.auth#sigv4",
																								SignerProperties: func() smithy.Properties {
																									var sp smithy.Properties
																									smithyhttp.SetDisableDoubleEncoding(&sp, true)

																									smithyhttp.SetSigV4SigningName(&sp, "s3-outposts")
																									smithyhttp.SetSigV4ASigningName(&sp, "s3-outposts")

																									smithyhttp.SetSigV4SigningRegion(&sp, _accessPointArn.Region)
																									return sp
																								}(),
																							},
																						})
																						return out
																					}(),
																				}, nil
																			}
																		}
																		if _UseFIPS == true {
																			uriString := func() string {
																				var out strings.Builder
																				out.WriteString("https://s3-outposts-fips.")
																				out.WriteString(_accessPointArn.Region)
																				out.WriteString(".")
																				out.WriteString(_arnPartition.DnsSuffix)
																				return out.String()
																			}()

																			uri, err := url.Parse(uriString)
																			if err != nil {
																				return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
																			}

																			return smithyendpoints.Endpoint{
																				URI: *uri,
																				Headers: func() http.Header {
																					headers := http.Header{}
																					headers.Set("x-amz-account-id", _accessPointArn.AccountId)
																					headers.Set("x-amz-outpost-id", _outpostId)
																					return headers
																				}(),
																				Properties: func() smithy.Properties {
																					var out smithy.Properties
																					smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
																						{
																							SchemeID: "aws.auth#sigv4",
																							SignerProperties: func() smithy.Properties {
																								var sp smithy.Properties
																								smithyhttp.SetDisableDoubleEncoding(&sp, true)

																								smithyhttp.SetSigV4SigningName(&sp, "s3-outposts")
																								smithyhttp.SetSigV4ASigningName(&sp, "s3-outposts")

																								smithyhttp.SetSigV4SigningRegion(&sp, _accessPointArn.Region)
																								return sp
																							}(),
																						},
																					})
																					return out
																				}(),
																			}, nil
																		}
																		if _UseDualStack == true {
																			uriString := func() string {
																				var out strings.Builder
																				out.WriteString("https://s3-outposts.")
																				out.WriteString(_accessPointArn.Region)
																				out.WriteString(".")
																				out.WriteString(_arnPartition.DualStackDnsSuffix)
																				return out.String()
																			}()

																			uri, err := url.Parse(uriString)
																			if err != nil {
																				return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
																			}

																			return smithyendpoints.Endpoint{
																				URI: *uri,
																				Headers: func() http.Header {
																					headers := http.Header{}
																					headers.Set("x-amz-account-id", _accessPointArn.AccountId)
																					headers.Set("x-amz-outpost-id", _outpostId)
																					return headers
																				}(),
																				Properties: func() smithy.Properties {
																					var out smithy.Properties
																					smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
																						{
																							SchemeID: "aws.auth#sigv4",
																							SignerProperties: func() smithy.Properties {
																								var sp smithy.Properties
																								smithyhttp.SetDisableDoubleEncoding(&sp, true)

																								smithyhttp.SetSigV4SigningName(&sp, "s3-outposts")
																								smithyhttp.SetSigV4ASigningName(&sp, "s3-outposts")

																								smithyhttp.SetSigV4SigningRegion(&sp, _accessPointArn.Region)
																								return sp
																							}(),
																						},
																					})
																					return out
																				}(),
																			}, nil
																		}
																		if exprVal := params.Endpoint; exprVal != nil {
																			_Endpoint := *exprVal
																			_ = _Endpoint
																			if exprVal := rulesfn.ParseURL(_Endpoint); exprVal != nil {
																				_url := *exprVal
																				_ = _url
																				uriString := func() string {
																					var out strings.Builder
																					out.WriteString(_url.Scheme)
																					out.WriteString("://")
																					out.WriteString(_url.Authority)
																					out.WriteString(_url.Path)
																					return out.String()
																				}()

																				uri, err := url.Parse(uriString)
																				if err != nil {
																					return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
																				}

																				return smithyendpoints.Endpoint{
																					URI: *uri,
																					Headers: func() http.Header {
																						headers := http.Header{}
																						headers.Set("x-amz-account-id", _accessPointArn.AccountId)
																						headers.Set("x-amz-outpost-id", _outpostId)
																						return headers
																					}(),
																					Properties: func() smithy.Properties {
																						var out smithy.Properties
																						smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
																							{
																								SchemeID: "aws.auth#sigv4",
																								SignerProperties: func() smithy.Properties {
																									var sp smithy.Properties
																									smithyhttp.SetDisableDoubleEncoding(&sp, true)

																									smithyhttp.SetSigV4SigningName(&sp, "s3-outposts")
																									smithyhttp.SetSigV4ASigningName(&sp, "s3-outposts")

																									smithyhttp.SetSigV4SigningRegion(&sp, _accessPointArn.Region)
																									return sp
																								}(),
																							},
																						})
																						return out
																					}(),
																				}, nil
																			}
																		}
																		uriString := func() string {
																			var out strings.Builder
																			out.WriteString("https://s3-outposts.")
																			out.WriteString(_accessPointArn.Region)
																			out.WriteString(".")
																			out.WriteString(_arnPartition.DnsSuffix)
																			return out.String()
																		}()

																		uri, err := url.Parse(uriString)
																		if err != nil {
																			return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
																		}

																		return smithyendpoints.Endpoint{
																			URI: *uri,
																			Headers: func() http.Header {
																				headers := http.Header{}
																				headers.Set("x-amz-account-id", _accessPointArn.AccountId)
																				headers.Set("x-amz-outpost-id", _outpostId)
																				return headers
																			}(),
																			Properties: func() smithy.Properties {
																				var out smithy.Properties
																				smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
																					{
																						SchemeID: "aws.auth#sigv4",
																						SignerProperties: func() smithy.Properties {
																							var sp smithy.Properties
																							smithyhttp.SetDisableDoubleEncoding(&sp, true)

																							smithyhttp.SetSigV4SigningName(&sp, "s3-outposts")
																							smithyhttp.SetSigV4ASigningName(&sp, "s3-outposts")

																							smithyhttp.SetSigV4SigningRegion(&sp, _accessPointArn.Region)
																							return sp
																						}(),
																					},
																				})
																				return out
																			}(),
																		}, nil
																	}
																	return endpoint, fmt.Errorf("endpoint rule error, %s", func() string {
																		var out strings.Builder
																		out.WriteString("Expected an outpost type `accesspoint`, found `")
																		out.WriteString(_outpostType)
																		out.WriteString("`")
																		return out.String()
																	}())
																}
																return endpoint, fmt.Errorf("endpoint rule error, %s", "Invalid ARN: expected an access point name")
															}
															return endpoint, fmt.Errorf("endpoint rule error, %s", "Invalid ARN: Expected a 4-component resource")
														}
														return endpoint, fmt.Errorf("endpoint rule error, %s", func() string {
															var out strings.Builder
															out.WriteString("Invalid ARN: The account id may only contain a-z, A-Z, 0-9 and `-`. Found: `")
															out.WriteString(_accessPointArn.AccountId)
															out.WriteString("`")
															return out.String()
														}())
													}
													return endpoint, fmt.Errorf("endpoint rule error, %s", "Invalid ARN: missing account ID")
												}
												return endpoint, fmt.Errorf("endpoint rule error, %s", func() string {
													var out strings.Builder
													out.WriteString("Invalid region in ARN: `")
													out.WriteString(_accessPointArn.Region)
													out.WriteString("` (invalid DNS name)")
													return out.String()
												}())
											}
											return endpoint, fmt.Errorf("endpoint rule error, %s", func() string {
												var out strings.Builder
												out.WriteString("Client was configured for partition `")
												out.WriteString(_partitionResult.Name)
												out.WriteString("` but ARN has `")
												out.WriteString(_arnPartition.Name)
												out.WriteString("`")
												return out.String()
											}())
										}
										return endpoint, fmt.Errorf("Endpoint resolution failed. Invalid operation or environment input.")
									}
									return endpoint, fmt.Errorf("Endpoint resolution failed. Invalid operation or environment input.")
								}
								return endpoint, fmt.Errorf("endpoint rule error, %s", func() string {
									var out strings.Builder
									out.WriteString("Invalid ARN: The outpost Id must only contain a-z, A-Z, 0-9 and `-`., found: `")
									out.WriteString(_outpostId)
									out.WriteString("`")
									return out.String()
								}())
							}
							return endpoint, fmt.Errorf("endpoint rule error, %s", "Invalid ARN: The Outpost Id was not set")
						}
						return endpoint, fmt.Errorf("Endpoint resolution failed. Invalid operation or environment input.")
					}
				}
				return endpoint, fmt.Errorf("endpoint rule error, %s", "Invalid ARN: No ARN type specified")
			}
		}
		if exprVal := params.Bucket; exprVal != nil {
			_Bucket := *exprVal
			_ = _Bucket
			if exprVal := awsrulesfn.ParseARN(_Bucket); exprVal != nil {
				_bucketArn := *exprVal
				_ = _bucketArn
				if exprVal := _bucketArn.ResourceId.Get(0); exprVal != nil {
					_arnType := *exprVal
					_ = _arnType
					if !(_arnType == "") {
						if _bucketArn.Service == "s3-outposts" {
							if exprVal := _bucketArn.ResourceId.Get(1); exprVal != nil {
								_outpostId := *exprVal
								_ = _outpostId
								if rulesfn.IsValidHostLabel(_outpostId, false) {
									if exprVal := params.Endpoint; exprVal != nil {
										_Endpoint := *exprVal
										_ = _Endpoint
										if _UseDualStack == true {
											return endpoint, fmt.Errorf("endpoint rule error, %s", "Invalid Configuration: DualStack and custom endpoint are not supported")
										}
									}
									if exprVal := params.UseArnRegion; exprVal != nil {
										_UseArnRegion := *exprVal
										_ = _UseArnRegion
										if _UseArnRegion == false {
											if !(_bucketArn.Region == _Region) {
												return endpoint, fmt.Errorf("endpoint rule error, %s", func() string {
													var out strings.Builder
													out.WriteString("Invalid configuration: region from ARN `")
													out.WriteString(_bucketArn.Region)
													out.WriteString("` does not match client region `")
													out.WriteString(_Region)
													out.WriteString("` and UseArnRegion is `false`")
													return out.String()
												}())
											}
										}
									}
									if exprVal := awsrulesfn.GetPartition(_bucketArn.Region); exprVal != nil {
										_arnPartition := *exprVal
										_ = _arnPartition
										if exprVal := awsrulesfn.GetPartition(_Region); exprVal != nil {
											_partitionResult := *exprVal
											_ = _partitionResult
											if _arnPartition.Name == _partitionResult.Name {
												if rulesfn.IsValidHostLabel(_bucketArn.Region, true) {
													if !(_bucketArn.AccountId == "") {
														if rulesfn.IsValidHostLabel(_bucketArn.AccountId, false) {
															if exprVal := params.AccountId; exprVal != nil {
																_AccountId := *exprVal
																_ = _AccountId
																if !(_AccountId == _bucketArn.AccountId) {
																	return endpoint, fmt.Errorf("endpoint rule error, %s", func() string {
																		var out strings.Builder
																		out.WriteString("Invalid ARN: the accountId specified in the ARN (`")
																		out.WriteString(_bucketArn.AccountId)
																		out.WriteString("`) does not match the parameter (`")
																		out.WriteString(_AccountId)
																		out.WriteString("`)")
																		return out.String()
																	}())
																}
															}
															if exprVal := _bucketArn.ResourceId.Get(2); exprVal != nil {
																_outpostType := *exprVal
																_ = _outpostType
																if exprVal := _bucketArn.ResourceId.Get(3); exprVal != nil {
																	_bucketName := *exprVal
																	_ = _bucketName
																	if _outpostType == "bucket" {
																		if _UseFIPS == true {
																			if _UseDualStack == true {
																				uriString := func() string {
																					var out strings.Builder
																					out.WriteString("https://s3-outposts-fips.")
																					out.WriteString(_bucketArn.Region)
																					out.WriteString(".")
																					out.WriteString(_arnPartition.DualStackDnsSuffix)
																					return out.String()
																				}()

																				uri, err := url.Parse(uriString)
																				if err != nil {
																					return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
																				}

																				return smithyendpoints.Endpoint{
																					URI: *uri,
																					Headers: func() http.Header {
																						headers := http.Header{}
																						headers.Set("x-amz-account-id", _bucketArn.AccountId)
																						headers.Set("x-amz-outpost-id", _outpostId)
																						return headers
																					}(),
																					Properties: func() smithy.Properties {
																						var out smithy.Properties
																						smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
																							{
																								SchemeID: "aws.auth#sigv4",
																								SignerProperties: func() smithy.Properties {
																									var sp smithy.Properties
																									smithyhttp.SetDisableDoubleEncoding(&sp, true)

																									smithyhttp.SetSigV4SigningName(&sp, "s3-outposts")
																									smithyhttp.SetSigV4ASigningName(&sp, "s3-outposts")

																									smithyhttp.SetSigV4SigningRegion(&sp, _bucketArn.Region)
																									return sp
																								}(),
																							},
																						})
																						return out
																					}(),
																				}, nil
																			}
																		}
																		if _UseFIPS == true {
																			uriString := func() string {
																				var out strings.Builder
																				out.WriteString("https://s3-outposts-fips.")
																				out.WriteString(_bucketArn.Region)
																				out.WriteString(".")
																				out.WriteString(_arnPartition.DnsSuffix)
																				return out.String()
																			}()

																			uri, err := url.Parse(uriString)
																			if err != nil {
																				return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
																			}

																			return smithyendpoints.Endpoint{
																				URI: *uri,
																				Headers: func() http.Header {
																					headers := http.Header{}
																					headers.Set("x-amz-account-id", _bucketArn.AccountId)
																					headers.Set("x-amz-outpost-id", _outpostId)
																					return headers
																				}(),
																				Properties: func() smithy.Properties {
																					var out smithy.Properties
																					smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
																						{
																							SchemeID: "aws.auth#sigv4",
																							SignerProperties: func() smithy.Properties {
																								var sp smithy.Properties
																								smithyhttp.SetDisableDoubleEncoding(&sp, true)

																								smithyhttp.SetSigV4SigningName(&sp, "s3-outposts")
																								smithyhttp.SetSigV4ASigningName(&sp, "s3-outposts")

																								smithyhttp.SetSigV4SigningRegion(&sp, _bucketArn.Region)
																								return sp
																							}(),
																						},
																					})
																					return out
																				}(),
																			}, nil
																		}
																		if _UseDualStack == true {
																			uriString := func() string {
																				var out strings.Builder
																				out.WriteString("https://s3-outposts.")
																				out.WriteString(_bucketArn.Region)
																				out.WriteString(".")
																				out.WriteString(_arnPartition.DualStackDnsSuffix)
																				return out.String()
																			}()

																			uri, err := url.Parse(uriString)
																			if err != nil {
																				return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
																			}

																			return smithyendpoints.Endpoint{
																				URI: *uri,
																				Headers: func() http.Header {
																					headers := http.Header{}
																					headers.Set("x-amz-account-id", _bucketArn.AccountId)
																					headers.Set("x-amz-outpost-id", _outpostId)
																					return headers
																				}(),
																				Properties: func() smithy.Properties {
																					var out smithy.Properties
																					smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
																						{
																							SchemeID: "aws.auth#sigv4",
																							SignerProperties: func() smithy.Properties {
																								var sp smithy.Properties
																								smithyhttp.SetDisableDoubleEncoding(&sp, true)

																								smithyhttp.SetSigV4SigningName(&sp, "s3-outposts")
																								smithyhttp.SetSigV4ASigningName(&sp, "s3-outposts")

																								smithyhttp.SetSigV4SigningRegion(&sp, _bucketArn.Region)
																								return sp
																							}(),
																						},
																					})
																					return out
																				}(),
																			}, nil
																		}
																		if exprVal := params.Endpoint; exprVal != nil {
																			_Endpoint := *exprVal
																			_ = _Endpoint
																			if exprVal := rulesfn.ParseURL(_Endpoint); exprVal != nil {
																				_url := *exprVal
																				_ = _url
																				uriString := func() string {
																					var out strings.Builder
																					out.WriteString(_url.Scheme)
																					out.WriteString("://")
																					out.WriteString(_url.Authority)
																					out.WriteString(_url.Path)
																					return out.String()
																				}()

																				uri, err := url.Parse(uriString)
																				if err != nil {
																					return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
																				}

																				return smithyendpoints.Endpoint{
																					URI: *uri,
																					Headers: func() http.Header {
																						headers := http.Header{}
																						headers.Set("x-amz-account-id", _bucketArn.AccountId)
																						headers.Set("x-amz-outpost-id", _outpostId)
																						return headers
																					}(),
																					Properties: func() smithy.Properties {
																						var out smithy.Properties
																						smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
																							{
																								SchemeID: "aws.auth#sigv4",
																								SignerProperties: func() smithy.Properties {
																									var sp smithy.Properties
																									smithyhttp.SetDisableDoubleEncoding(&sp, true)

																									smithyhttp.SetSigV4SigningName(&sp, "s3-outposts")
																									smithyhttp.SetSigV4ASigningName(&sp, "s3-outposts")

																									smithyhttp.SetSigV4SigningRegion(&sp, _bucketArn.Region)
																									return sp
																								}(),
																							},
																						})
																						return out
																					}(),
																				}, nil
																			}
																		}
																		uriString := func() string {
																			var out strings.Builder
																			out.WriteString("https://s3-outposts.")
																			out.WriteString(_bucketArn.Region)
																			out.WriteString(".")
																			out.WriteString(_arnPartition.DnsSuffix)
																			return out.String()
																		}()

																		uri, err := url.Parse(uriString)
																		if err != nil {
																			return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
																		}

																		return smithyendpoints.Endpoint{
																			URI: *uri,
																			Headers: func() http.Header {
																				headers := http.Header{}
																				headers.Set("x-amz-account-id", _bucketArn.AccountId)
																				headers.Set("x-amz-outpost-id", _outpostId)
																				return headers
																			}(),
																			Properties: func() smithy.Properties {
																				var out smithy.Properties
																				smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
																					{
																						SchemeID: "aws.auth#sigv4",
																						SignerProperties: func() smithy.Properties {
																							var sp smithy.Properties
																							smithyhttp.SetDisableDoubleEncoding(&sp, true)

																							smithyhttp.SetSigV4SigningName(&sp, "s3-outposts")
																							smithyhttp.SetSigV4ASigningName(&sp, "s3-outposts")

																							smithyhttp.SetSigV4SigningRegion(&sp, _bucketArn.Region)
																							return sp
																						}(),
																					},
																				})
																				return out
																			}(),
																		}, nil
																	}
																	return endpoint, fmt.Errorf("endpoint rule error, %s", func() string {
																		var out strings.Builder
																		out.WriteString("Invalid ARN: Expected an outpost type `bucket`, found `")
																		out.WriteString(_outpostType)
																		out.WriteString("`")
																		return out.String()
																	}())
																}
																return endpoint, fmt.Errorf("endpoint rule error, %s", "Invalid ARN: expected a bucket name")
															}
															return endpoint, fmt.Errorf("endpoint rule error, %s", "Invalid ARN: Expected a 4-component resource")
														}
														return endpoint, fmt.Errorf("endpoint rule error, %s", func() string {
															var out strings.Builder
															out.WriteString("Invalid ARN: The account id may only contain a-z, A-Z, 0-9 and `-`. Found: `")
															out.WriteString(_bucketArn.AccountId)
															out.WriteString("`")
															return out.String()
														}())
													}
													return endpoint, fmt.Errorf("endpoint rule error, %s", "Invalid ARN: missing account ID")
												}
												return endpoint, fmt.Errorf("endpoint rule error, %s", func() string {
													var out strings.Builder
													out.WriteString("Invalid region in ARN: `")
													out.WriteString(_bucketArn.Region)
													out.WriteString("` (invalid DNS name)")
													return out.String()
												}())
											}
											return endpoint, fmt.Errorf("endpoint rule error, %s", func() string {
												var out strings.Builder
												out.WriteString("Client was configured for partition `")
												out.WriteString(_partitionResult.Name)
												out.WriteString("` but ARN has `")
												out.WriteString(_arnPartition.Name)
												out.WriteString("`")
												return out.String()
											}())
										}
										return endpoint, fmt.Errorf("Endpoint resolution failed. Invalid operation or environment input.")
									}
									return endpoint, fmt.Errorf("Endpoint resolution failed. Invalid operation or environment input.")
								}
								return endpoint, fmt.Errorf("endpoint rule error, %s", func() string {
									var out strings.Builder
									out.WriteString("Invalid ARN: The outpost Id must only contain a-z, A-Z, 0-9 and `-`., found: `")
									out.WriteString(_outpostId)
									out.WriteString("`")
									return out.String()
								}())
							}
							return endpoint, fmt.Errorf("endpoint rule error, %s", "Invalid ARN: The Outpost Id was not set")
						}
						return endpoint, fmt.Errorf("Endpoint resolution failed. Invalid operation or environment input.")
					}
				}
				return endpoint, fmt.Errorf("endpoint rule error, %s", "Invalid ARN: No ARN type specified")
			}
		}
		if exprVal := awsrulesfn.GetPartition(_Region); exprVal != nil {
			_partitionResult := *exprVal
			_ = _partitionResult
			if rulesfn.IsValidHostLabel(_Region, true) {
				if exprVal := params.RequiresAccountId; exprVal != nil {
					_RequiresAccountId := *exprVal
					_ = _RequiresAccountId
					if _RequiresAccountId == true {
						if !(params.AccountId != nil) {
							return endpoint, fmt.Errorf("endpoint rule error, %s", "AccountId is required but not set")
						}
					}
				}
				if exprVal := params.AccountId; exprVal != nil {
					_AccountId := *exprVal
					_ = _AccountId
					if !(rulesfn.IsValidHostLabel(_AccountId, false)) {
						return endpoint, fmt.Errorf("endpoint rule error, %s", "AccountId must only contain a-z, A-Z, 0-9 and `-`.")
					}
				}
				if exprVal := params.Endpoint; exprVal != nil {
					_Endpoint := *exprVal
					_ = _Endpoint
					if exprVal := rulesfn.ParseURL(_Endpoint); exprVal != nil {
						_url := *exprVal
						_ = _url
						if _UseDualStack == true {
							return endpoint, fmt.Errorf("endpoint rule error, %s", "Invalid Configuration: DualStack and custom endpoint are not supported")
						}
						if exprVal := params.RequiresAccountId; exprVal != nil {
							_RequiresAccountId := *exprVal
							_ = _RequiresAccountId
							if _RequiresAccountId == true {
								if exprVal := params.AccountId; exprVal != nil {
									_AccountId := *exprVal
									_ = _AccountId
									uriString := func() string {
										var out strings.Builder
										out.WriteString(_url.Scheme)
										out.WriteString("://")
										out.WriteString(_AccountId)
										out.WriteString(".")
										out.WriteString(_url.Authority)
										out.WriteString(_url.Path)
										return out.String()
									}()

									uri, err := url.Parse(uriString)
									if err != nil {
										return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
									}

									return smithyendpoints.Endpoint{
										URI:     *uri,
										Headers: http.Header{},
										Properties: func() smithy.Properties {
											var out smithy.Properties
											smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
												{
													SchemeID: "aws.auth#sigv4",
													SignerProperties: func() smithy.Properties {
														var sp smithy.Properties
														smithyhttp.SetDisableDoubleEncoding(&sp, true)

														smithyhttp.SetSigV4SigningName(&sp, "s3")
														smithyhttp.SetSigV4ASigningName(&sp, "s3")

														smithyhttp.SetSigV4SigningRegion(&sp, _Region)
														return sp
													}(),
												},
											})
											return out
										}(),
									}, nil
								}
							}
						}
						uriString := func() string {
							var out strings.Builder
							out.WriteString(_url.Scheme)
							out.WriteString("://")
							out.WriteString(_url.Authority)
							out.WriteString(_url.Path)
							return out.String()
						}()

						uri, err := url.Parse(uriString)
						if err != nil {
							return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
						}

						return smithyendpoints.Endpoint{
							URI:     *uri,
							Headers: http.Header{},
							Properties: func() smithy.Properties {
								var out smithy.Properties
								smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
									{
										SchemeID: "aws.auth#sigv4",
										SignerProperties: func() smithy.Properties {
											var sp smithy.Properties
											smithyhttp.SetDisableDoubleEncoding(&sp, true)

											smithyhttp.SetSigV4SigningName(&sp, "s3")
											smithyhttp.SetSigV4ASigningName(&sp, "s3")

											smithyhttp.SetSigV4SigningRegion(&sp, _Region)
											return sp
										}(),
									},
								})
								return out
							}(),
						}, nil
					}
				}
				if _UseFIPS == true {
					if _UseDualStack == true {
						if exprVal := params.RequiresAccountId; exprVal != nil {
							_RequiresAccountId := *exprVal
							_ = _RequiresAccountId
							if _RequiresAccountId == true {
								if exprVal := params.AccountId; exprVal != nil {
									_AccountId := *exprVal
									_ = _AccountId
									uriString := func() string {
										var out strings.Builder
										out.WriteString("https://")
										out.WriteString(_AccountId)
										out.WriteString(".s3-control-fips.dualstack.")
										out.WriteString(_Region)
										out.WriteString(".")
										out.WriteString(_partitionResult.DnsSuffix)
										return out.String()
									}()

									uri, err := url.Parse(uriString)
									if err != nil {
										return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
									}

									return smithyendpoints.Endpoint{
										URI:     *uri,
										Headers: http.Header{},
										Properties: func() smithy.Properties {
											var out smithy.Properties
											smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
												{
													SchemeID: "aws.auth#sigv4",
													SignerProperties: func() smithy.Properties {
														var sp smithy.Properties
														smithyhttp.SetDisableDoubleEncoding(&sp, true)

														smithyhttp.SetSigV4SigningName(&sp, "s3")
														smithyhttp.SetSigV4ASigningName(&sp, "s3")

														smithyhttp.SetSigV4SigningRegion(&sp, _Region)
														return sp
													}(),
												},
											})
											return out
										}(),
									}, nil
								}
							}
						}
					}
				}
				if _UseFIPS == true {
					if _UseDualStack == true {
						uriString := func() string {
							var out strings.Builder
							out.WriteString("https://s3-control-fips.dualstack.")
							out.WriteString(_Region)
							out.WriteString(".")
							out.WriteString(_partitionResult.DnsSuffix)
							return out.String()
						}()

						uri, err := url.Parse(uriString)
						if err != nil {
							return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
						}

						return smithyendpoints.Endpoint{
							URI:     *uri,
							Headers: http.Header{},
							Properties: func() smithy.Properties {
								var out smithy.Properties
								smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
									{
										SchemeID: "aws.auth#sigv4",
										SignerProperties: func() smithy.Properties {
											var sp smithy.Properties
											smithyhttp.SetDisableDoubleEncoding(&sp, true)

											smithyhttp.SetSigV4SigningName(&sp, "s3")
											smithyhttp.SetSigV4ASigningName(&sp, "s3")

											smithyhttp.SetSigV4SigningRegion(&sp, _Region)
											return sp
										}(),
									},
								})
								return out
							}(),
						}, nil
					}
				}
				if _UseFIPS == true {
					if _UseDualStack == false {
						if exprVal := params.RequiresAccountId; exprVal != nil {
							_RequiresAccountId := *exprVal
							_ = _RequiresAccountId
							if _RequiresAccountId == true {
								if exprVal := params.AccountId; exprVal != nil {
									_AccountId := *exprVal
									_ = _AccountId
									uriString := func() string {
										var out strings.Builder
										out.WriteString("https://")
										out.WriteString(_AccountId)
										out.WriteString(".s3-control-fips.")
										out.WriteString(_Region)
										out.WriteString(".")
										out.WriteString(_partitionResult.DnsSuffix)
										return out.String()
									}()

									uri, err := url.Parse(uriString)
									if err != nil {
										return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
									}

									return smithyendpoints.Endpoint{
										URI:     *uri,
										Headers: http.Header{},
										Properties: func() smithy.Properties {
											var out smithy.Properties
											smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
												{
													SchemeID: "aws.auth#sigv4",
													SignerProperties: func() smithy.Properties {
														var sp smithy.Properties
														smithyhttp.SetDisableDoubleEncoding(&sp, true)

														smithyhttp.SetSigV4SigningName(&sp, "s3")
														smithyhttp.SetSigV4ASigningName(&sp, "s3")

														smithyhttp.SetSigV4SigningRegion(&sp, _Region)
														return sp
													}(),
												},
											})
											return out
										}(),
									}, nil
								}
							}
						}
					}
				}
				if _UseFIPS == true {
					if _UseDualStack == false {
						uriString := func() string {
							var out strings.Builder
							out.WriteString("https://s3-control-fips.")
							out.WriteString(_Region)
							out.WriteString(".")
							out.WriteString(_partitionResult.DnsSuffix)
							return out.String()
						}()

						uri, err := url.Parse(uriString)
						if err != nil {
							return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
						}

						return smithyendpoints.Endpoint{
							URI:     *uri,
							Headers: http.Header{},
							Properties: func() smithy.Properties {
								var out smithy.Properties
								smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
									{
										SchemeID: "aws.auth#sigv4",
										SignerProperties: func() smithy.Properties {
											var sp smithy.Properties
											smithyhttp.SetDisableDoubleEncoding(&sp, true)

											smithyhttp.SetSigV4SigningName(&sp, "s3")
											smithyhttp.SetSigV4ASigningName(&sp, "s3")

											smithyhttp.SetSigV4SigningRegion(&sp, _Region)
											return sp
										}(),
									},
								})
								return out
							}(),
						}, nil
					}
				}
				if _UseFIPS == false {
					if _UseDualStack == true {
						if exprVal := params.RequiresAccountId; exprVal != nil {
							_RequiresAccountId := *exprVal
							_ = _RequiresAccountId
							if _RequiresAccountId == true {
								if exprVal := params.AccountId; exprVal != nil {
									_AccountId := *exprVal
									_ = _AccountId
									uriString := func() string {
										var out strings.Builder
										out.WriteString("https://")
										out.WriteString(_AccountId)
										out.WriteString(".s3-control.dualstack.")
										out.WriteString(_Region)
										out.WriteString(".")
										out.WriteString(_partitionResult.DnsSuffix)
										return out.String()
									}()

									uri, err := url.Parse(uriString)
									if err != nil {
										return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
									}

									return smithyendpoints.Endpoint{
										URI:     *uri,
										Headers: http.Header{},
										Properties: func() smithy.Properties {
											var out smithy.Properties
											smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
												{
													SchemeID: "aws.auth#sigv4",
													SignerProperties: func() smithy.Properties {
														var sp smithy.Properties
														smithyhttp.SetDisableDoubleEncoding(&sp, true)

														smithyhttp.SetSigV4SigningName(&sp, "s3")
														smithyhttp.SetSigV4ASigningName(&sp, "s3")

														smithyhttp.SetSigV4SigningRegion(&sp, _Region)
														return sp
													}(),
												},
											})
											return out
										}(),
									}, nil
								}
							}
						}
					}
				}
				if _UseFIPS == false {
					if _UseDualStack == true {
						uriString := func() string {
							var out strings.Builder
							out.WriteString("https://s3-control.dualstack.")
							out.WriteString(_Region)
							out.WriteString(".")
							out.WriteString(_partitionResult.DnsSuffix)
							return out.String()
						}()

						uri, err := url.Parse(uriString)
						if err != nil {
							return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
						}

						return smithyendpoints.Endpoint{
							URI:     *uri,
							Headers: http.Header{},
							Properties: func() smithy.Properties {
								var out smithy.Properties
								smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
									{
										SchemeID: "aws.auth#sigv4",
										SignerProperties: func() smithy.Properties {
											var sp smithy.Properties
											smithyhttp.SetDisableDoubleEncoding(&sp, true)

											smithyhttp.SetSigV4SigningName(&sp, "s3")
											smithyhttp.SetSigV4ASigningName(&sp, "s3")

											smithyhttp.SetSigV4SigningRegion(&sp, _Region)
											return sp
										}(),
									},
								})
								return out
							}(),
						}, nil
					}
				}
				if _UseFIPS == false {
					if _UseDualStack == false {
						if exprVal := params.RequiresAccountId; exprVal != nil {
							_RequiresAccountId := *exprVal
							_ = _RequiresAccountId
							if _RequiresAccountId == true {
								if exprVal := params.AccountId; exprVal != nil {
									_AccountId := *exprVal
									_ = _AccountId
									uriString := func() string {
										var out strings.Builder
										out.WriteString("https://")
										out.WriteString(_AccountId)
										out.WriteString(".s3-control.")
										out.WriteString(_Region)
										out.WriteString(".")
										out.WriteString(_partitionResult.DnsSuffix)
										return out.String()
									}()

									uri, err := url.Parse(uriString)
									if err != nil {
										return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
									}

									return smithyendpoints.Endpoint{
										URI:     *uri,
										Headers: http.Header{},
										Properties: func() smithy.Properties {
											var out smithy.Properties
											smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
												{
													SchemeID: "aws.auth#sigv4",
													SignerProperties: func() smithy.Properties {
														var sp smithy.Properties
														smithyhttp.SetDisableDoubleEncoding(&sp, true)

														smithyhttp.SetSigV4SigningName(&sp, "s3")
														smithyhttp.SetSigV4ASigningName(&sp, "s3")

														smithyhttp.SetSigV4SigningRegion(&sp, _Region)
														return sp
													}(),
												},
											})
											return out
										}(),
									}, nil
								}
							}
						}
					}
				}
				if _UseFIPS == false {
					if _UseDualStack == false {
						uriString := func() string {
							var out strings.Builder
							out.WriteString("https://s3-control.")
							out.WriteString(_Region)
							out.WriteString(".")
							out.WriteString(_partitionResult.DnsSuffix)
							return out.String()
						}()

						uri, err := url.Parse(uriString)
						if err != nil {
							return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
						}

						return smithyendpoints.Endpoint{
							URI:     *uri,
							Headers: http.Header{},
							Properties: func() smithy.Properties {
								var out smithy.Properties
								smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
									{
										SchemeID: "aws.auth#sigv4",
										SignerProperties: func() smithy.Properties {
											var sp smithy.Properties
											smithyhttp.SetDisableDoubleEncoding(&sp, true)

											smithyhttp.SetSigV4SigningName(&sp, "s3")
											smithyhttp.SetSigV4ASigningName(&sp, "s3")

											smithyhttp.SetSigV4SigningRegion(&sp, _Region)
											return sp
										}(),
									},
								})
								return out
							}(),
						}, nil
					}
				}
				return endpoint, fmt.Errorf("Endpoint resolution failed. Invalid operation or environment input.")
			}
			return endpoint, fmt.Errorf("endpoint rule error, %s", "Invalid region: region was not a valid DNS name.")
		}
		return endpoint, fmt.Errorf("Endpoint resolution failed. Invalid operation or environment input.")
	}
	return endpoint, fmt.Errorf("endpoint rule error, %s", "Region must be set")
}

type endpointParamsBinder interface {
	bindEndpointParams(*EndpointParameters)
}

func bindEndpointParams(ctx context.Context, input interface{}, options Options) *EndpointParameters {
	params := &EndpointParameters{}

	params.Region = bindRegion(options.Region)
	params.UseFIPS = aws.Bool(options.EndpointOptions.UseFIPSEndpoint == aws.FIPSEndpointStateEnabled)
	params.UseDualStack = aws.Bool(options.EndpointOptions.UseDualStackEndpoint == aws.DualStackEndpointStateEnabled)
	params.Endpoint = options.BaseEndpoint
	params.UseArnRegion = aws.Bool(options.UseARNRegion)

	if b, ok := input.(endpointParamsBinder); ok {
		b.bindEndpointParams(params)
	}

	return params
}

type resolveEndpointV2Middleware struct {
	options Options
}

func (*resolveEndpointV2Middleware) ID() string {
	return "ResolveEndpointV2"
}

func (m *resolveEndpointV2Middleware) HandleFinalize(ctx context.Context, in middleware.FinalizeInput, next middleware.FinalizeHandler) (
	out middleware.FinalizeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "ResolveEndpoint")
	defer span.End()

	if awsmiddleware.GetRequiresLegacyEndpoints(ctx) {
		return next.HandleFinalize(ctx, in)
	}

	req, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, fmt.Errorf("unknown transport type %T", in.Request)
	}

	if m.options.EndpointResolverV2 == nil {
		return out, metadata, fmt.Errorf("expected endpoint resolver to not be nil")
	}

	params := bindEndpointParams(ctx, getOperationInput(ctx), m.options)
	endpt, err := timeOperationMetric(ctx, "client.call.resolve_endpoint_duration",
		func() (smithyendpoints.Endpoint, error) {
			return m.options.EndpointResolverV2.ResolveEndpoint(ctx, *params)
		})
	if err != nil {
		return out, metadata, fmt.Errorf("failed to resolve service endpoint, %w", err)
	}

	span.SetProperty("client.call.resolved_endpoint", endpt.URI.String())

	if endpt.URI.RawPath == "" && req.URL.RawPath != "" {
		endpt.URI.RawPath = endpt.URI.Path
	}
	req.URL.Scheme = endpt.URI.Scheme
	req.URL.Host = endpt.URI.Host
	req.URL.Path = smithyhttp.JoinPath(endpt.URI.Path, req.URL.Path)
	req.URL.RawPath = smithyhttp.JoinPath(endpt.URI.RawPath, req.URL.RawPath)
	for k := range endpt.Headers {
		req.Header.Set(k, endpt.Headers.Get(k))
	}

	rscheme := getResolvedAuthScheme(ctx)
	if rscheme == nil {
		return out, metadata, fmt.Errorf("no resolved auth scheme")
	}

	opts, _ := smithyauth.GetAuthOptions(&endpt.Properties)
	for _, o := range opts {
		rscheme.SignerProperties.SetAll(&o.SignerProperties)
	}

	span.End()
	return next.HandleFinalize(ctx, in)
}
