// Code generated by smithy-go-codegen DO NOT EDIT.

package pinpointsmsvoicev2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/pinpointsmsvoicev2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Update a country rule set to ALLOW , BLOCK , MONITOR , or FILTER messages to be
// sent to the specified destination counties. You can update one or multiple
// countries at a time. The updates are only applied to the specified
// NumberCapability type.
func (c *Client) UpdateProtectConfigurationCountryRuleSet(ctx context.Context, params *UpdateProtectConfigurationCountryRuleSetInput, optFns ...func(*Options)) (*UpdateProtectConfigurationCountryRuleSetOutput, error) {
	if params == nil {
		params = &UpdateProtectConfigurationCountryRuleSetInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateProtectConfigurationCountryRuleSet", params, optFns, c.addOperationUpdateProtectConfigurationCountryRuleSetMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateProtectConfigurationCountryRuleSetOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateProtectConfigurationCountryRuleSetInput struct {

	// A map of ProtectConfigurationCountryRuleSetInformation objects that contain the
	// details for the requested NumberCapability. The Key is the two-letter ISO
	// country code. For a list of supported ISO country codes, see [Supported countries and regions (SMS channel)]in the AWS End
	// User Messaging SMS User Guide.
	//
	// For example, to set the United States as allowed and Canada as blocked, the
	// CountryRuleSetUpdates would be formatted as: "CountryRuleSetUpdates": { "US" :
	// { "ProtectStatus": "ALLOW" } "CA" : { "ProtectStatus": "BLOCK" } }
	//
	// [Supported countries and regions (SMS channel)]: https://docs.aws.amazon.com/sms-voice/latest/userguide/phone-numbers-sms-by-country.html
	//
	// This member is required.
	CountryRuleSetUpdates map[string]types.ProtectConfigurationCountryRuleSetInformation

	// The number capability to apply the CountryRuleSetUpdates updates to.
	//
	// This member is required.
	NumberCapability types.NumberCapability

	// The unique identifier for the protect configuration.
	//
	// This member is required.
	ProtectConfigurationId *string

	noSmithyDocumentSerde
}

type UpdateProtectConfigurationCountryRuleSetOutput struct {

	// An array of ProtectConfigurationCountryRuleSetInformation containing the rules
	// for the NumberCapability.
	//
	// This member is required.
	CountryRuleSet map[string]types.ProtectConfigurationCountryRuleSetInformation

	// The number capability that was updated
	//
	// This member is required.
	NumberCapability types.NumberCapability

	// The Amazon Resource Name (ARN) of the protect configuration.
	//
	// This member is required.
	ProtectConfigurationArn *string

	// The unique identifier for the protect configuration.
	//
	// This member is required.
	ProtectConfigurationId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateProtectConfigurationCountryRuleSetMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpUpdateProtectConfigurationCountryRuleSet{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpUpdateProtectConfigurationCountryRuleSet{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateProtectConfigurationCountryRuleSet"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateProtectConfigurationCountryRuleSetValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateProtectConfigurationCountryRuleSet(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateProtectConfigurationCountryRuleSet(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateProtectConfigurationCountryRuleSet",
	}
}
