// Code generated by smithy-go-codegen DO NOT EDIT.

package pinpointsmsvoicev2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/pinpointsmsvoicev2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates or updates a keyword configuration on an origination phone number or
// pool.
//
// A keyword is a word that you can search for on a particular phone number or
// pool. It is also a specific word or phrase that an end user can send to your
// number to elicit a response, such as an informational message or a special
// offer. When your number receives a message that begins with a keyword, AWS End
// User Messaging SMS and Voice responds with a customizable message.
//
// If you specify a keyword that isn't valid, an error is returned.
func (c *Client) PutKeyword(ctx context.Context, params *PutKeywordInput, optFns ...func(*Options)) (*PutKeywordOutput, error) {
	if params == nil {
		params = &PutKeywordInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "PutKeyword", params, optFns, c.addOperationPutKeywordMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*PutKeywordOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type PutKeywordInput struct {

	// The new keyword to add.
	//
	// This member is required.
	Keyword *string

	// The message associated with the keyword.
	//
	// This member is required.
	KeywordMessage *string

	// The origination identity to use such as a PhoneNumberId, PhoneNumberArn,
	// SenderId or SenderIdArn. You can use DescribePhoneNumbersget the values for PhoneNumberId and
	// PhoneNumberArn while DescribeSenderIdscan be used to get the values for SenderId and SenderIdArn.
	//
	// If you are using a shared AWS End User Messaging SMS and Voice resource then
	// you must use the full Amazon Resource Name(ARN).
	//
	// This member is required.
	OriginationIdentity *string

	// The action to perform for the new keyword when it is received.
	//
	//   - AUTOMATIC_RESPONSE: A message is sent to the recipient.
	//
	//   - OPT_OUT: Keeps the recipient from receiving future messages.
	//
	//   - OPT_IN: The recipient wants to receive future messages.
	KeywordAction types.KeywordAction

	noSmithyDocumentSerde
}

type PutKeywordOutput struct {

	// The keyword that was added.
	Keyword *string

	// The action to perform when the keyword is used.
	KeywordAction types.KeywordAction

	// The message associated with the keyword.
	KeywordMessage *string

	// The PhoneNumberId or PoolId that the keyword was associated with.
	OriginationIdentity *string

	// The PhoneNumberArn or PoolArn that the keyword was associated with.
	OriginationIdentityArn *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationPutKeywordMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpPutKeyword{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpPutKeyword{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "PutKeyword"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpPutKeywordValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opPutKeyword(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opPutKeyword(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "PutKeyword",
	}
}
